/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    interface_location.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-10-03
 * @section DESCRIPTION
 *			Interface location on the FPGA
 */

#ifndef INTERFACE_LOCATION_H
#define INTERFACE_LOCATION_H

#include "coordinates.h"
#include <string>
#include <vector>
#include <iostream>
using namespace std;

enum InterfacePosition {DONT_CARE, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST};
const string NO_INTERFACE_DEFINED = "ANY_IF";

class InterfaceLocation {
	
private:
	string type;				/*< Interface type (e.g. AXI, PLB or logical expression) */
	vector<string> expression;	/*< Interface as a logical expression, parsed from the previous string */
	Coordinates location;		/*< Interface placement on the FPGA */
	InterfacePosition position;	/*< Relative position of the interface in the RZ */

public:
	InterfaceLocation(string n, Coordinates c, InterfacePosition pos = DONT_CARE) : type(n), location(c), position(pos) {
		// Parse expression
		string remainingExpression(type);
		while(remainingExpression.find(" ") != string::npos) {
			size_t offset = remainingExpression.find(" ");
			expression.push_back(remainingExpression.substr(0, offset));
			remainingExpression.erase(0, offset + 1);
		}

		// Insert last element
		expression.push_back(remainingExpression);
	}

	InterfaceLocation(vector<string> exp, Coordinates c, InterfacePosition pos = DONT_CARE) : expression(exp), location(c), position(pos) {
		type = "";
	}

	vector<string> getInterfaceExpressionVector(void) const;
	Coordinates getInterfaceLocation(void) const;
	InterfacePosition getInterfacePosition(void) const;

};

#endif
