/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    RZStats.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-02-16
 * @section DESCRIPTION
 *			Statistics for an RZ as provided by the simulator.
 */

#include "RZStats.h"

double RZStats::getRZStateTime(RZState state) {
	return rzStateTimes[state];
}

void RZStats::printRZStats(void) {
	if(isRZ) cout << "RZ " << name << " has the following results:" << endl;
	else cout << "Processor " << name << " has the following results:" << endl;
	cout << "Time blank:\t\t" << rzStateTimes[RZ_BLANK] << " %" << endl;
	cout << "Time reconfiguring:\t" << rzStateTimes[RZ_RECONFIG] << " %" << endl;
	cout << "Time mapped:\t\t" << rzStateTimes[RZ_MAPPED] << " %" << endl;
	cout << "Time active:\t\t" << rzStateTimes[RZ_ACTIVE] << " %" << endl;
	cout << "Time running:\t\t" << rzStateTimes[RZ_RUNNING] << " %" << endl;
	map<string, double>::iterator it2;
	for(it2 = taskExecutionTimes.begin(); it2 != taskExecutionTimes.end(); it2++)
		cout << "\tTask " << it2->first << ": " << it2->second << " %" << endl;
	cout << endl;
}

map<string, double> RZStats::getTaskExecutionTimesMap(void) {
	return taskExecutionTimes;
}
