/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    RZFinderManager.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-04-24
 * @section DESCRIPTION
 *			A static class to manage synthesis reports
 */


#include "RZFinderManager.h"

map<ResourceRequirements, vector<RZ> > RZFinderManager::resourceRequirementsRZSetMap;


vector<RZ> RZFinderManager::retrieveRZSet(ResourceRequirements &res) {

	map<ResourceRequirements, vector<RZ> >::const_iterator it;
	for(it = resourceRequirementsRZSetMap.begin(); it != resourceRequirementsRZSetMap.end(); it++) {
		if(res == it->first) {
			cout << "RZ set already found for these resource requirements" << endl;
			return it->second;
		}
	}

	// Function has not returned, meaning RZ set for these resource requirements has not been determined yet
	vector<RZ> tmp;
	// Effectively find RZ set
	res.findRZs();
	tmp = res.getRZSet();

	resourceRequirementsRZSetMap.insert(pair<ResourceRequirements, vector<RZ> >(res, tmp));

	return tmp;
}
