FORTRESS_HEADER

# Get absolute path
set absolute_path [pwd]

# Check existence of a project with the same name
if {[file exists "$absolute_path/planahead/$env(solution_name)"]} {
	puts "Deleting existing directory..."
	file delete -force -- "$absolute_path/planahead/$env(solution_name)"
}

create_project "$env(solution_name)" "$absolute_path/planahead/$env(solution_name)" -part FORTRESS_DEVICE
set_property design_mode GateLvl [get_property srcset [current_run]]
set_property edif_top_file "$absolute_path/top.ngc" [get_property srcset [current_run]]
add_files -fileset [get_property constrset [current_run]] -norecurse FORTRESS_UCF_FILE
set_property name config_1 [current_run]
set_property is_partial_reconfig true [current_project]
open_netlist_design -name netlist_1
