/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconfiguration_unit.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-10-19
 * @section DESCRIPTION
 *			A reconfiguration unit, either HW or SW
 */

#include "reconfiguration_unit.h"
#include "utils.h"

bool ReconfigurationUnit::isBusy(void) {
	return busy;
}

void ReconfigurationUnit::setBusy(bool b) {

	bool oldBusy(busy);
	busy = b;

	if(oldBusy) {
		busyTime += (rs_time_stamp() - Utils::maxTime(requestTime, last_window_reset));
	}
	
	if(busy) requestTime = rs_time_stamp();
}

rs_time ReconfigurationUnit::getBusyTime(void) {
	return busyTime;
}

rs_time ReconfigurationUnit::getRequestTime(void) {
	return requestTime;
}

//double ReconfigurationUnit::getOccupationRateOverLastWindow(void) {
//
//	// Update value if busy (only considered at a switch)
//	if(busy) busyTime += (rs_time_stamp() - Utils::maxTime(requestTime, last_window_reset));
//	last_window_reset = rs_time_stamp();
//
//	rs_time newBusyTimeValue = busyTime - busyTimeOnLastCall;
//	busyTimeOnLastCall = busyTime;
//
//	window_function.setNewValue(newBusyTimeValue);
//	return window_function.getInstantOccupationRate();
//}
