/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    resources.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-06-20
 * @section DESCRIPTION
 *			Resources representation
 */

#ifndef RESOURCES_H
#define RESOURCES_H

#include <string>
#include <map>
using namespace std;

class Resources {

private:

	map<string, int> resourceMap;

public:
	Resources(map<string, int> _resourceMap) : resourceMap(_resourceMap) {}

	Resources() {}

	Resources(const Resources &other) {
		resourceMap = other.resourceMap;
	}

	int getResourceCount(string resource_name) const;
	map<string, int> &getResourceMap(void);
};

#endif
