/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    memory_manager.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-05-20
 * @section DESCRIPTION
 *			This class defines a memory manager used to maintain
 *			a pool of transactions.
 */

#ifndef MEMORY_MANAGER_H
#define MEMORY_MANAGER_H

//#include "tlm.h"
#include "utils.h"
#include <stdint.h>
#include <cassert>
#include <mutex>
#include <iostream>


class
rs_payload;


class Memory_manager {//: public tlm::tlm_mm_interface {

	typedef rs_payload gp_t;
	
public:
	Memory_manager() : free_list(0), empties(0)
		#ifdef DEBUG
			, count(0)
		#endif
	{}

	~Memory_manager() {
		/*while(empties != 0) {
			delete empties->trans;
			access *current = empties;
			empties = empties->next;
			delete current;
		}*/
	}

	gp_t* allocate();
	void  free(gp_t* trans);
	
private:
	struct access {
		gp_t* trans;
		access* next;
		access* prev;
	};
	
	access* free_list;
	access* empties;
	std::mutex mtx;

#ifdef DEBUG
	int count;
#endif
};


enum com_command {
	COM_READ_COMMAND=0,
	COM_WRITE_COMMAND,
	COM_IGNORE_COMMAND
	};

class rs_payload{
private :
	com_command      command;
	uint64_t address;
	uint8_t* data_ptr;
	uint64_t data_lengthgth;
	Memory_manager* m_mm;
	unsigned int ref_count;
	std::mutex mtx;
	
	rs_payload(const rs_payload& x)
	: command(x.get_command())
	, address(x.get_address())
	, data_ptr(x.get_data_ptr())
	, data_lengthgth(x.get_data_length())
	{
		std::cout << "copie trans "<< std::endl;
	}
	
public :
	rs_payload()
	: command(COM_IGNORE_COMMAND)
	, address(0)
	, data_ptr(0)
	, data_lengthgth(0)
	, m_mm(0)
	, ref_count(0)
	{}

	explicit rs_payload(Memory_manager* mm)
	: command(COM_IGNORE_COMMAND)
	, address(0)
	, data_ptr(0)
	, data_lengthgth(0)
	, m_mm(mm)
	, ref_count(0)
	{}

	rs_payload& operator= (rs_payload& x)
	{
		command     = x.get_command();
		address     = x.get_address();
		data_ptr    = x.get_data_ptr();
		data_lengthgth = x.get_data_length();
	}

	void     set_command     (const com_command);
	void     set_address     (const uint64_t);
	void     set_data_ptr    (uint8_t*);
	void     set_data_length (const uint64_t);
	com_command get_command     ()const;
	uint64_t get_address     ()const;
	uint8_t* get_data_ptr    ()const;
	uint64_t get_data_length ()const;

	void	 release();
	void	 acquire();
};

inline
void rs_payload::set_command(const com_command cmd){
	command = cmd;
}

inline
void rs_payload::set_address(const uint64_t addr){
	address = addr;
}

inline
void rs_payload::set_data_ptr(uint8_t* d_ptr){
	data_ptr = d_ptr;
}

inline
void rs_payload::set_data_length(const uint64_t d_len){
	data_lengthgth = d_len;
}
inline
com_command rs_payload::get_command(void) const{
	return command;
}

inline
uint64_t rs_payload::get_address(void) const{
	return address;
}

inline
uint8_t* rs_payload::get_data_ptr(void) const{
	return data_ptr;
}

inline
uint64_t rs_payload::get_data_length(void) const{
	return data_lengthgth;
}


inline
void rs_payload::release(void){
	mtx.lock();
	if (m_mm == 0){
		assert(m_mm != 0 );
	}
	assert(ref_count > 0);
	if (-- ref_count == 0)
		m_mm->free(this);
	mtx.unlock();
}

inline
void rs_payload::acquire(void){
	mtx.lock();
	assert(m_mm != 0);
	ref_count++;
	mtx.unlock();
	
}


#endif
