/**
  * @file    MainTestBench.h
  * @author  XXX
  * @version 1.0
  * @date    March 2, 2016 1:41:55 PM CET
  * @section DESCRIPTION
  * 
  * User OUT Testbench algorithms files of MainTestBench
  */



#ifndef MAINTESTBENCH_TESTBENCH_FILE_H
#define MAINTESTBENCH_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/********************/
/* Output TestBench */

template<int No>
void MainTestBench(Testbench_out_interface<No>& tb_interface) {
	tb_interface.wait_on_sinc();
	// Default
	//
	// DATA SEND
	//
	for (int i = 0; i < NB_TRANSACTIONS_TO_SEND; i++) {

		// Check that first module in the chain is ready
#ifdef GENERATE_LOG_FILE
		tb_interface.get_logfile() << endl << rs_time_stamp() << ": " << tb_interface.TB_IF_name() << " checks instantiation for following modules" << endl;
#endif

		// Initialize data to send for this transaction
		for(int j = 0; j < No; j++) {
			int *data_out_ptr = tb_interface.TB_IF_get_data_out_ptr(j);
			for(int k = 0; k < 16; k++) data_out_ptr[k] = (i << 16) | k;
		}

		tb_interface.TB_IF_nb_send_all_data();

		/* DO NOTHING */
		/* check_target method asks for following modules instantiation, answer from
		 * the manager will produce an event responsible for data transfers */

		// Wait until all responses from following modules have been received */
		wait_TB_IF_all_responses_received_event();
		//wait(tb_interface.TB_IF_all_responses_received_event());


#ifdef GENERATE_LOG_FILE
		tb_interface.get_logfile() << rs_time_stamp() << ": " << tb_interface.TB_IF_name() << ": Transaction " << i << " has been sent" << endl;
#endif

		if(i != (NB_TRANSACTIONS_TO_SEND - 1)) {
			// Delay next transaction by waiting extra time
			rs_time delayToNextPacket((i + 1) * tb_interface.TB_IF_get_period() - rs_time_stamp());
			if(delayToNextPacket < RS_ZERO_TIME) {
				cerr << "ERROR in TB: Negative delay to next packet send! Consider revising periods and other timing information" << endl;
				exit(RECOSIM_INTERNAL_ERROR_ERRCODE);
			}
			wait_for_time(delayToNextPacket);
		}

		tb_interface.TB_IF_increment_current_transaction_id();
	}

#ifdef GENERATE_LOG_FILE
	tb_interface.get_logfile() << rs_time_stamp() << ": " << tb_interface.TB_IF_name() << ": All transactions have been sent" << endl;
#endif

}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
