/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    task_priority_comparato_interface.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-03-18
 * @section DESCRIPTION
 *			Interface to be passed as a parameter for task priority comparison and sorting
 */

#ifndef TASK_PRIORITY_COMPARATOR_INTERFACE_H
#define TASK_PRIORITY_COMPARATOR_INTERFACE_H

#include "rs_time.h"

#define BEGIN_PRIORITY_COMPARATOR(nom) class nom##PriorityComparator { \
	public: \
	nom##PriorityComparator() {} \
	bool operator() (const Task_priority_comparator_interface& lhs, const Task_priority_comparator_interface& rhs) const

#define END_PRIORITY_COMPARATOR  };


class Task_priority_comparator_interface {

public:

	/**
	 * @brief Get task deadline (as the maximum acceptable time for one task execution)
	 * @return sc_time representation of the task deadline
	 */
	virtual rs_time get_deadline_time(void) const = 0;

	/**
	 * @brief Get task deadline (absolute time representation)
	 * @return sc_time representation of the task deadline (absolute time)
	 */
	virtual rs_time get_task_deadline(void) const = 0;

	/**
	 * @brief Return task period
	 * @return Task period
	 */
	virtual rs_time get_task_period(void) const = 0;

	/**
	 * @brief Return task offset
	 * @return Task offset
	 */
	virtual rs_time get_task_offset(void) const = 0;

	/**
	 * @brief Return task priority
	 * @return Taks priority
	 */
	virtual int get_task_priority(void) const = 0;
};


#endif
