/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    configuration_request.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-03-01
 * @section DESCRIPTION
 *			A configuration request
 */

#ifndef CONFIGURATION_REQUEST_H
#define CONFIGURATION_REQUEST_H

#include "reconfigurable_zone.h"
#include <ostream>
#include <sys/types.h>

class ConfigurationRequest {

private:

	int   taskID;
	pid_t taskTID;
	int   taskImplementationID;
	RZ*   hostingRZ;

public:
	ConfigurationRequest(int _taskID, pid_t _taskTID,int _taskImplementationID, RZ* _hostingRZ) : taskID(_taskID), taskTID(_taskTID), taskImplementationID(_taskImplementationID), hostingRZ(_hostingRZ) {}
	ConfigurationRequest() : taskID(0), taskTID(0), taskImplementationID(0), hostingRZ(0) {}

	int getTaskID(void) const;
	pid_t getTaskTID(void) const;
	int getTaskImplementationID(void) const;
	RZ* getHostingRZ(void) const;

	// For use in sc_buffer
	const bool operator==(const ConfigurationRequest&);
	friend std::ostream& operator <<(std::ostream&, const ConfigurationRequest&);
	
};

#endif
