FORTRESS_HEADER

#include "rs_time.h"
#include "rs_event.h"
#include "my_priority_queue.h"
#include "user_scheduling.h"
#include "scheduler_request.h"
#include "user_parameters.h"
#include "reconfigurable_zone.h"
#include "testbench_in.h"
#include "testbench_out.h"
#include "module.h"
#include "reconf_threads.h"
#include "configuration_file_parser.h"
#include "utils.h"
#include "reconfiguration_manager.h"
#include "generation_helper.h"
#include "testbench_algorithms.h"
#include "module_algorithms.h"
#include "application.h"

#include "fpga.h"
#include "task.h"

#include <sstream>
#include <fstream>
#include <string>
#include <iostream>
#include <thread>
#include <chrono>
#include <map>

bool Utils::VERBOSE_MODE					= FORTRESS_VERBOSE_MODE;

FORTRESS_ALGO_DECLARATION

int main(int argc, char* argv[]) {
	
	filebuf fb0;
	fb0.open("/dev/pts/4",ios::out);
	ostream fout(&fb0);
	fout << string(80, '\n');

	string simulationName;

	if(argc == 2) {
		cout << "RZ file to parse: " << argv[1] << endl;
		simulationName = "";
	} else if(argc == 3) {
		cout << "RZ file to parse: " << argv[1] << endl;
		cout << "Simulation name: " << argv[2] << endl;
		simulationName = argv[2];
	} else {
		cout << "Need parameters. Usage: ./exec path_to_RZ_file simulation_name" << endl;
		return -1;
	}
	
	string path(argv[1]);

	/* Log Files */
FORTRESS_LOGFILE
	/* VCD Trace Files */
FORTRESS_TRACEFILE
	/* RZ Properties */
	map<string, RZ_config*> rz_cfg_table;
	RZ_config::initRZConfigTable(rz_cfg_table);
	
	/* Module Instances Declaration*/
FORTRESS_MODULE_DECL
	/* Read RZ Configuration File */
	vector<RZ *> rz_table;
	vector<Task> task_table;
	FPGA* fpga = new FPGA();
	if(readRZConfigurationFile(path, rz_table, task_table, fpga) != 0) {
		cerr << "ERROR: Unable to read RZ configuration file, exiting..." << endl;
		return -1;
	}
	Reconfiguration_manager manager("Reconfiguration_manager", rz_table, task_table, WAITING_QUEUE_HANDLER_REF(FORTRESS_WAITING_QUEUE_HANDLER), fpga, fout, rz_cfg_table);
	
FORTRESS_APPLICATIONS_LIST

	/* Application Defined */
	manager.applicationDefined();
	
	/* DEBUG TRACE */
FORTRESS_DEBUG_TRACE
	/* Activate Trace */

	/* Simulator Configuration */
FORTRESS_MANAGER_ATTRIBUTES

FORTRESS_OFFSET_HYPERPERIOD

FORTRESS_MONITORING
	/* Start Application(s) */
	this_thread::sleep_for(chrono::seconds(4));
	
FORTRESS_MIDDLEWARE_START_APPS

	rs_event* main_sleep;
	main_sleep = new rs_event();
	main_sleep->wait();

	/* End of Simulation */
	Reconfiguration_manager::verifySimulationTimes();
		
	/* Display Information */

	/* Flush Streams */
	fout.flush();
}


