FORTRESS_HEADER

#include "simulation.h"
#include "user_parameters.h"

// STEP 0: Environment
PlanAheadVersion Simulation::planAheadVersion	= PLANAHEAD_FORTRESS_XILINX_VERSION;
string Simulation::planAheadPath				= FORTRESS_PLANAHEAD_PATH;
bool Simulation::VERBOSE_MODE					= FORTRESS_VERBOSE_MODE;

// STEP 1: RZ determination per task
bool Simulation::USE_RZ_SET_DESCRIPTION_FILE = FORTRESS_USE_RZ_SET_DESCRIPTION_FILE;
string Simulation::RZ_SET_DESCRIPTION_FILENAME = FORTRESS_RZ_SET_DESCRIPTION_FILENAME;
bool Simulation::PURELY_RECONFIGURABLE_RZ = FORTRESS_ALLOW_PURELY_RECONFIGURABLE_RZ;
bool Simulation::ALLOW_NON_RECTANGULAR_RZ = FORTRESS_ALLOW_NON_RECTANGULAR_RZ;
double Simulation::OVERSIZED_RZ_TRIGGER = FORTRESS_OVERSIZED_RZ_TRIGGER;
double Simulation::RESOURCES_MARGIN = FORTRESS_RESOURCES_MARGIN;
bool Simulation::IGNORE_RZ_POSITION_CONSTRAINTS = FORTRESS_IGNORE_RZ_POSITION_CONSTRAINTS;

// STEP 2: RZ sort
double Simulation::COST_SHAPE_WEIGHT		= FORTRESS_COST_SHAPE_WEIGHT; 
double Simulation::COST_COMPLIANCE_WEIGHT	= FORTRESS_COST_COMPLIANCE_WEIGHT; 
double Simulation::COST_INTERNAL_FRAGMENTATION_WEIGHT	= FORTRESS_INTERNAL_FRAGMENTATION_WEIGHT;
bool Simulation::CHECK_RZ_REDUNDANCY		= FORTRESS_CHECK_RZ_REDUNDANCY; 

// STEP 3: RZ selection for simulation
ImplementationMetric Simulation::IMPLEMENTATION_METRIC	= FORTRESS_IMPLEMENTATION_METRIC; 
double Simulation::TRIGGER_FACTOR_UNACCEPTABLE			= FORTRESS_TRIGGER_FACTOR_UNACCEPTABLE;
double Simulation::TRIGGER_FACTOR_OPTIMUM				= FORTRESS_TRIGGER_FACTOR_OPTIMUM;
int Simulation::MINIMUM_DISTANCE_BETWEEN_RZS			= FORTRESS_MINIMUM_DISTANCE_BETWEEN_RZS;

// STEP 4: Allocation
AllocationStrategy Simulation::ALLOCATION_STRATEGY = FORTRESS_ALLOCATION_STRATEGY; /* Allocation optimization strategy */
ProcessorAllocationStrategy Simulation::PROCESSOR_ALLOCATION_STRATEGY = FORTRESS_PROCESSOR_ALLOCATION_STRATEGY; /* Allocation optimization strategy for processors */

// STEP 5: PR cost model
BitstreamGeneration Simulation::BITSTREAM_GENERATION = FORTRESS_PLANAHEAD_IMPLEMENTATION;	/* Bistream generation for compression estimation */
float Simulation::MEAN_COMPRESSION_RATIO	= (float)((FORTRESS_MEAN_COMPRESSION_RATIO)/100.0f);	/* Mean compression ratio */
float Simulation::Tbus						= (float)(FORTRESS_TBUS);	/* Bus period in nanoseconds */
float Simulation::Ticap						= (float)(FORTRESS_TICAP);	/* ICAP period in nanoseconds */
float Simulation::Nburst					= (float)(FORTRESS_NBURST);	/* Burst length */
float Simulation::tburst					= (float)(FORTRESS_TBURST);	/* Time spent on a burst, in cycles of Tbus */
float Simulation::latency					= (float)(FORTRESS_LATENCY);	/* Latency to initiate a transaction on the bus, in cycles of Tbus */
float Simulation::fifoDepth					= (float)(FORTRESS_FIFODEPTH);	/* FaRM FIFO depth in 32-bit words */

// Step 6 : Simulation
bool Simulation::RUN_SIMULATION_UNTIL_STATIC_SOLUTION	= FORTRESS_RUN_SIMULATION_UNTIL_STATIC_SOLUTION; 

