/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.FortressXMLBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.jdom.JDOMException;

public class FortressSystem
extends FortressXMLBuilder {
    public void loadFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getSystemFile());
        if (!f.exists()) {
            System.err.println("Internal Error : The system configuration file (" + f.getAbsoluteFile() + ") is not found !");
            throw new IOException("Internal Error : The system configuration file (" + f.getAbsoluteFile() + ") is not found !");
        }
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public Vector<String> getSchedulerQueueStrategyList() throws JDOMException {
        return this.getList("SchedulerQueueStrategy", "LIST", "name");
    }

    public boolean isSchedulerQueueStrategy(String strategy_name) throws JDOMException {
        Vector<String> list = this.getList("SchedulerQueueStrategy", "LIST", "name");
        int i = 0;
        while (i < list.size()) {
            String value = list.elementAt(i);
            if (value.equals(strategy_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDefaultSchedulerQueueStrategy() throws JDOMException {
        return this.getValue("SchedulerQueueStrategy", "DEFAULT_STRATEGY", "value");
    }

    public Vector<String> getSchedulerStrategyList() throws JDOMException {
        return this.getList("SchedulerStrategy", "LIST", "name");
    }

    public boolean isSchedulerStrategy(String strategy_name) throws JDOMException {
        Vector<String> list = this.getList("SchedulerStrategy", "LIST", "name");
        int i = 0;
        while (i < list.size()) {
            String value = list.elementAt(i);
            if (value.equals(strategy_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDefaultSchedulerStrategy() throws JDOMException {
        return this.getValue("SchedulerStrategy", "DEFAULT_STRATEGY", "value");
    }
}

