/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import java.io.File;
import java.util.Vector;

public class ConfigApplication
implements Comparable<Object> {
    public static final String APP_INST_PREFIX = "App_";
    String instName;
    String file;
    boolean local;
    boolean active;
    int QoS;
    int EnergyConsumptionLimit;

    public ConfigApplication(ConfigApplication cfgApp, String instName) {
        this(cfgApp.file, cfgApp.local, instName, cfgApp.active, cfgApp.QoS, cfgApp.EnergyConsumptionLimit);
    }

    public ConfigApplication(String file, boolean local, String instName) {
        this(file, local, instName, true, 100, 10);
    }

    public ConfigApplication(String file, boolean local, String instName, boolean active, int QoS, int EnergyConsumptionLimit) {
        this.file = file;
        this.local = local;
        this.instName = instName;
        this.active = active;
        this.QoS = QoS;
        this.EnergyConsumptionLimit = EnergyConsumptionLimit;
    }

    public boolean equals(ConfigApplication cp) {
        return this.getInstanceName().equals(cp.getInstanceName());
    }

    @Override
    public int compareTo(Object cp) {
        return this.getInstanceName().compareTo(((ConfigApplication)cp).getInstanceName());
    }

    public boolean identical(ConfigApplication cp) {
        return this.instName.equals(cp.getInstanceName()) && this.file.equals(cp.getFile()) && this.local == cp.isLocal() && this.active == cp.isActive() && this.QoS == cp.getQoS() && this.EnergyConsumptionLimit == cp.getEnergyConsumptionLimit();
    }

    public String toString() {
        if (this.local) {
            return "[" + this.getFileName() + ", instance = " + this.getInstanceName() + ",  active = " + this.active + ", QoS = " + this.QoS + " %, Energy = " + this.EnergyConsumptionLimit + " \ufffdJ]";
        }
        return "[" + this.getFileName() + ", instance = " + this.getInstanceName() + ",  active = " + this.active + ", QoS = " + this.QoS + " %, Energy = " + this.EnergyConsumptionLimit + " \ufffdJ] " + this.file;
    }

    public String getInstanceName() {
        return this.instName;
    }

    public void setInstanceName(String name) {
        this.instName = name;
    }

    public String getFileName() {
        int k = this.file.lastIndexOf(File.separator);
        String fdest = k == -1 ? this.file : this.file.substring(k + 1);
        return fdest.substring(0, fdest.lastIndexOf("."));
    }

    public String getFileNameWithExtension() {
        int k = this.file.lastIndexOf(File.separator);
        String fdest = k == -1 ? this.file : this.file.substring(k + 1);
        return fdest;
    }

    public void setFile(String val) {
        this.file = val;
    }

    public String getFile() {
        return this.file;
    }

    public void setLocal(boolean val) {
        this.local = val;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setActive(boolean val) {
        this.active = val;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setQoS(int val) {
        this.QoS = val;
    }

    public int getQoS() {
        return this.QoS;
    }

    public void setEnergyConsumptionLimit(int val) {
        this.EnergyConsumptionLimit = val;
    }

    public int getEnergyConsumptionLimit() {
        return this.EnergyConsumptionLimit;
    }

    public int computeInstanceNumber(Vector<ConfigApplication> appList) {
        int n = 0;
        int i = 0;
        while (i < appList.size()) {
            if (appList.elementAt(i).getFile().equals(this.getFile())) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public boolean isOnActiveFileList(Vector<ConfigApplication> appList) {
        int i = 0;
        while (i < appList.size()) {
            if (appList.elementAt(i).getFile().equals(this.getFile()) && appList.elementAt(i).isActive()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<ConfigApplication> getActiveInstanceList(Vector<ConfigApplication> appList) {
        Vector<ConfigApplication> instList = new Vector<ConfigApplication>();
        int i = 0;
        while (i < appList.size()) {
            if (appList.elementAt(i).getFile().equals(this.getFile()) && appList.elementAt(i).isActive()) {
                instList.add(appList.elementAt(i));
            }
            ++i;
        }
        return instList;
    }

    public static Vector<ConfigApplication> getActiveInstanceList(Vector<ConfigApplication> appList, String filename) {
        Vector<ConfigApplication> instList = new Vector<ConfigApplication>();
        int i = 0;
        while (i < appList.size()) {
            if (appList.elementAt(i).getFile().equals(filename) && appList.elementAt(i).isActive()) {
                instList.add(appList.elementAt(i));
            }
            ++i;
        }
        return instList;
    }

    public static Vector<String> getAllInstanceNameList(Vector<ConfigApplication> appList) {
        Vector<String> instList = new Vector<String>();
        int i = 0;
        while (i < appList.size()) {
            instList.add(appList.elementAt(i).getInstanceName());
            ++i;
        }
        return instList;
    }

    public static String createInstanceName(Vector<ConfigApplication> appList, String prefix) {
        String instName = String.valueOf(prefix) + "0";
        Vector<String> allInstNameList = ConfigApplication.getAllInstanceNameList(appList);
        int i = 0;
        while (i < allInstNameList.size()) {
            instName = String.valueOf(prefix) + i;
            if (!allInstNameList.elementAt(i).equalsIgnoreCase(instName)) {
                return instName;
            }
            ++i;
        }
        return String.valueOf(prefix) + allInstNameList.size();
    }
}

