/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.FortressGeneration;
import fortress.generation.ReplaceKeyword;
import fortress.xml.DevicePackage;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressPreferences;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class VariousGeneration {
    public static final String WINDOWS_COMPILATION_BAT_FILE = "FoRTReSS_compilation.bat";
    public static final String WINDOWS_RUN_VISUAL_CPP_BAT_FILE = "FoRTReSS_run_visual.bat";
    public static final String LINUX_RUN_CODE_BLOCK_BASH_FILE = "open_cb";
    static final String LINUX_COMPILATION_MAKEFILE = "Makefile";
    static final String WAVEFILE = "wave.do";
    String configuration;

    public VariousGeneration(String configuration) {
        this.configuration = configuration;
    }

    public static String getWindowsCompilationBatFile(String configuration) {
        return String.valueOf(FortressEnv.getScriptCompilationFilePath(configuration)) + WINDOWS_COMPILATION_BAT_FILE;
    }

    public static String getLinuxCompilationMakeFile(String configuration) {
        return String.valueOf(FortressEnv.getScriptCompilationFilePath(configuration)) + LINUX_COMPILATION_MAKEFILE;
    }

    public void Generate(OutputStream console) throws Exception {
        String destNGCFile;
        String src;
        String buf;
        ReplaceKeyword rk;
        String generated_filename;
        String template_filename;
        PrintStream out = new PrintStream(console);
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        if (pref.isVerboseMode()) {
            out.println("----------------------------------");
            out.println("- Script Generation");
            out.println("- " + FortressEnv.getLaboratory());
            out.println("- " + FortressEnv.today());
            out.println("- Configuration : " + this.configuration);
            out.println();
        }
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage dp = lib.getDevicePackage(conf.getSelectedDevice());
        if (dp == null) {
            throw new Exception("No Device Found : " + conf.getSelectedDevice());
        }
        if (FortressEnv.isWindowsOS()) {
            template_filename = FortressEnv.getWindowsCompilationBatFile();
            generated_filename = String.valueOf(FortressEnv.getScriptCompilationFilePath(this.configuration)) + WINDOWS_COMPILATION_BAT_FILE;
            if (pref.isVerboseMode()) {
                out.print("Running generation of Windows Script Bat File (Compilation) : " + generated_filename + " ... ");
            }
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf = FortressGeneration.createFortressHeaderForBatFile(WINDOWS_COMPILATION_BAT_FILE, "Bat File for Compilation");
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = pref.getSystemCPath();
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_PATH", buf);
            buf = pref.getSystemCLibPath();
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_LIB_PATH", buf);
            buf = pref.getMsBuildPath();
            rk.addReplaceKeyword("FORTRESS_MSBUILD_PATH", buf);
            buf = pref.getXercesPath();
            rk.addReplaceKeyword("FORTRESS_XERCES_PATH", buf);
            if (pref.getVisualStudioVersion().equals(FortressPreferences.VISUAL_STUDIO_2010_32bits)) {
                buf = FortressEnv.getFortressCLibraryPath(false);
                rk.addReplaceKeyword("FORTRESS_CLIB_PATH", buf);
                buf = "FoRTReSS_solution_v10.sln";
                rk.addReplaceKeyword("FORTRESS_SOLUTION_SLN", buf);
            } else if (pref.getVisualStudioVersion().equals(FortressPreferences.VISUAL_STUDIO_2012_32bits)) {
                buf = FortressEnv.getFortressCLibraryPath(false);
                rk.addReplaceKeyword("FORTRESS_CLIB_PATH", buf);
                buf = "FoRTReSS_solution_v11.sln";
                rk.addReplaceKeyword("FORTRESS_SOLUTION_SLN", buf);
            } else {
                FortressException.messageError(out, "Various Gen.", "Bat File for Compilation is not possible !, please check Visual Studio Version on preferences.");
            }
            rk.Generate(true);
            if (pref.isVerboseMode()) {
                out.println("done");
            }
            template_filename = FortressEnv.getWindowsRunVisualCppBatFile();
            generated_filename = String.valueOf(FortressEnv.getScriptCompilationFilePath(this.configuration)) + WINDOWS_RUN_VISUAL_CPP_BAT_FILE;
            if (pref.isVerboseMode()) {
                out.print("Running generation of Windows Script Bat File (run Visual C++) : " + generated_filename + " ... ");
            }
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf = FortressGeneration.createFortressHeaderForBatFile(WINDOWS_COMPILATION_BAT_FILE, "Bat File for Compilation");
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = pref.getSystemCPath();
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_PATH", buf);
            buf = pref.getSystemCLibPath();
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_LIB_PATH", buf);
            buf = pref.getVisualCPPPath();
            rk.addReplaceKeyword("FORTRESS_VISUAL_CPP_EXE", buf);
            buf = pref.getXercesPath();
            rk.addReplaceKeyword("FORTRESS_XERCES_PATH", buf);
            if (pref.getVisualStudioVersion().equals(FortressPreferences.VISUAL_STUDIO_2010_32bits)) {
                buf = FortressEnv.getFortressCLibraryPath(false);
                rk.addReplaceKeyword("FORTRESS_CLIB_PATH", buf);
                buf = "FoRTReSS_solution_v10.sln";
                rk.addReplaceKeyword("FORTRESS_SOLUTION_SLN", buf);
            } else if (pref.getVisualStudioVersion().equals(FortressPreferences.VISUAL_STUDIO_2012_32bits)) {
                buf = FortressEnv.getFortressCLibraryPath(false);
                rk.addReplaceKeyword("FORTRESS_CLIB_PATH", buf);
                buf = "FoRTReSS_solution_v11.sln";
                rk.addReplaceKeyword("FORTRESS_SOLUTION_SLN", buf);
            } else {
                FortressException.messageError(out, "Various Gen.", "Bat File for Compilation is not possible !, please check Visual Studio Version on preferences.");
            }
            rk.Generate(true);
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
        if (FortressEnv.isLinuxOS()) {
            template_filename = FortressEnv.getCompilationMakefile();
            generated_filename = String.valueOf(FortressEnv.getScriptCompilationFilePath(this.configuration)) + LINUX_COMPILATION_MAKEFILE;
            if (pref.isVerboseMode()) {
                out.print("Running generation of MakeFile : " + generated_filename + " ... ");
            }
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf = FortressGeneration.createFortressHeaderForTCL(LINUX_COMPILATION_MAKEFILE, "Make for Compilation");
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = "\"" + pref.getSystemCPath() + "\"" + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_PATH", buf);
            buf = pref.getSystemCLibPath();
            rk.addReplaceKeyword("FORTRESS_SYSTEMC_LIB_PATH", buf);
            buf = String.valueOf(pref.getXercesPath()) + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_XERCES_PATH", buf);
            buf = "\"" + FortressEnv.getFortressCLibraryPath(FortressEnv.is64bitOS()) + "\"" + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_CLIB_PATH", buf);
            rk.Generate(true);
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
        String xilinx_version = pref.getXilinxToolVersion();
        if (FortressEnv.isWindowsOS()) {
            template_filename = FortressEnv.getWindowsTemplateViewPlacementBatFile();
            generated_filename = FortressEnv.getWindowsViewPlacementBatFile(this.configuration);
            if (pref.isVerboseMode()) {
                out.print("Running generation of Windows View Placement Bat File : " + generated_filename + " ... ");
            }
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf = FortressGeneration.createFortressHeaderForBatFile("view_placement.bat", "View Placement on Planahead Tool");
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = "\"" + pref.getPlanheadPath() + "\"";
            rk.addReplaceKeyword("FORTRESS_PLANAHEAD", buf);
            buf = FortressEnv.getViewPlacementScriptFile(xilinx_version);
            rk.addReplaceKeyword("FORTRESS_TCL_SCRIPT", buf);
            rk.Generate();
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
        if (FortressEnv.isLinuxOS()) {
            template_filename = FortressEnv.getLinuxTemplateViewPlacementScriptFile();
            generated_filename = FortressEnv.getLinuxViewPlacementScriptFile(this.configuration);
            if (pref.isVerboseMode()) {
                out.print("Running generation of Linux View Placement script File : " + generated_filename + " ... ");
            }
            rk = new ReplaceKeyword(template_filename, generated_filename);
            buf = FortressGeneration.createFortressHeaderForTCL("view_placement.sh", "View Placement on Planahead Tool");
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = "\"" + pref.getPlanheadPath() + "\"";
            rk.addReplaceKeyword("FORTRESS_PLANAHEAD", buf);
            buf = FortressEnv.getViewPlacementScriptFile(xilinx_version);
            rk.addReplaceKeyword("FORTRESS_TCL_SCRIPT", buf);
            rk.Generate(true);
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
        template_filename = FortressEnv.getTemplateViewPlacementScriptFile(xilinx_version);
        generated_filename = FortressEnv.getViewPlacementScriptFile(this.configuration, xilinx_version);
        if (pref.isVerboseMode()) {
            out.print("Running generation of Windows View Placement TCL Script File : " + generated_filename + " ... ");
        }
        rk = new ReplaceKeyword(template_filename, generated_filename);
        buf = FortressGeneration.createFortressHeaderForTCL(FortressEnv.getViewPlacementScriptFile(xilinx_version), "View Placement on Planahead Tool");
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        buf = conf.getSelectedFullDeviceName();
        rk.addReplaceKeyword("FORTRESS_DEVICE", buf);
        buf = "\"${absolute_path}/" + FortressEnv.getRelativeUcfViewPlacementFile() + "$env(solution_name).ucf\"";
        rk.addReplaceKeyword("FORTRESS_UCF_FILE", buf);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (!FortressEnv.FileCopy(new File(src = FortressEnv.getTemplatePlacementNgcFile(dp.getCategory())), new File(destNGCFile = FortressEnv.getPlacementNgcFile(this.configuration)))) {
            FortressException.messageError(out, "Various Gen.", "Copy of " + src + " is not possible on " + destNGCFile + " !");
        } else if (pref.isVerboseMode()) {
            out.println("Script for placement (tcl file) : " + destNGCFile + " ... ");
        }
    }
}

