/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.generation.FortressGeneration;
import fortress.generation.ReplaceKeyword;
import fortress.xml.ConfigPowerFctPoint;
import fortress.xml.ConfigPowerGroup;
import fortress.xml.ConfigProcessor;
import fortress.xml.ConfigProcessorName;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ConfigRZGeneration {
    public final String CONFIG_RZ_HEADER_FILENAME = "rz_config.h";
    public final String RZ_DEFAULT_INST_GROUP_NAME = "RZDefaultGroupName";
    String configuration;

    public ConfigRZGeneration(String configuration) {
        this.configuration = configuration;
    }

    public void Generate(OutputStream console) throws Exception {
        PrintStream out = new PrintStream(console);
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        if (pref.isVerboseMode()) {
            out.println("----------------------------------");
            out.println("- Config RZ Header Generation");
            out.println("- " + FortressEnv.getLaboratory());
            out.println("- " + FortressEnv.today());
            out.println("- Configuration : " + this.configuration);
            out.println();
        }
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        String template_filename = FortressEnv.getHeaderRZConfigTemplateFile();
        String generated_filename = String.valueOf(FortressEnv.getHeaderRZConfigPath(this.configuration)) + "rz_config.h";
        if (pref.isVerboseMode()) {
            out.print("Running generation of Device Header : " + generated_filename + " ... ");
        }
        ReplaceKeyword rk = new ReplaceKeyword(template_filename, generated_filename);
        String buf = FortressGeneration.createFortressHeaderForC("rz_config.h", "RZ Properties");
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        buf = "";
        String RZdefaultGroupName = conf.getRZDefaultGroupName();
        if (RZdefaultGroupName != null && !RZdefaultGroupName.isEmpty()) {
            Vector<ConfigPowerGroup> configGroupList = pref.getRZConfigPowerGroupList();
            int i = 0;
            while (i < configGroupList.size()) {
                ConfigPowerGroup cfgGrp = configGroupList.elementAt(i);
                if (cfgGrp.getGroupName().equals(RZdefaultGroupName)) {
                    buf = String.valueOf(buf) + "\t\t/* RZ Default Domain */" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "\t\tpowerFctList = new vector<Config_fct_point*>;" + FortressEnv.EOL;
                    Vector<ConfigPowerFctPoint> fctPointList = cfgGrp.getctPointList();
                    int j = 0;
                    while (j < fctPointList.size()) {
                        buf = String.valueOf(buf) + "\t\tpowerFctList->push_back(new Config_fct_point(" + fctPointList.elementAt(j).getVoltage() + "F," + fctPointList.elementAt(j).getFrequency() + "F));" + FortressEnv.EOL;
                        ++j;
                    }
                    buf = String.valueOf(buf) + "\t\ttable[\"RZDefaultGroupName\"] =\tnew RZ_config(new Config_param_group(\"" + RZdefaultGroupName + "\" , " + cfgGrp.isCommonDomain() + ", new Config_fct_point(" + cfgGrp.getNominalFctPoint().getVoltage() + "F," + cfgGrp.getNominalFctPoint().getFrequency() + "F), powerFctList));" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + FortressEnv.EOL;
                }
                ++i;
            }
        }
        Vector<ConfigProcessorName> procNameList = pref.getConfigProcessorNameList();
        Vector<ConfigPowerGroup> configGroupList = pref.getProcConfigPowerGroupList();
        Vector<ConfigProcessor> instList = conf.getConfigProcessorList();
        int i = 0;
        while (i < instList.size()) {
            ConfigProcessor cfgProc = instList.elementAt(i);
            if (cfgProc.isActive()) {
                boolean addGroupName = false;
                String groupName = cfgProc.getPowerGroupName();
                int j = 0;
                while (j < configGroupList.size()) {
                    ConfigPowerGroup cfgGrp = configGroupList.elementAt(j);
                    if (cfgGrp.getGroupName().equals(groupName)) {
                        buf = String.valueOf(buf) + "\t\tpowerFctList = new vector<Config_fct_point*>;" + FortressEnv.EOL;
                        Vector<ConfigPowerFctPoint> fctPointList = cfgGrp.getctPointList();
                        int k = 0;
                        while (k < fctPointList.size()) {
                            buf = String.valueOf(buf) + "\t\tpowerFctList->push_back(new Config_fct_point(" + fctPointList.elementAt(k).getVoltage() + "F," + fctPointList.elementAt(k).getFrequency() + "F));" + FortressEnv.EOL;
                            ++k;
                        }
                        buf = String.valueOf(buf) + "\t\ttable[\"" + cfgProc.getInstanceName() + "\"] =\tnew RZ_config(new Config_param_group(\"" + groupName + "\" , " + cfgGrp.isCommonDomain() + ", new Config_fct_point(" + cfgGrp.getNominalFctPoint().getVoltage() + "F," + cfgGrp.getNominalFctPoint().getFrequency() + "F), powerFctList)";
                        addGroupName = true;
                    }
                    ++j;
                }
                boolean foundProcName = false;
                String procName = cfgProc.getType();
                int j2 = 0;
                while (j2 < procNameList.size()) {
                    ConfigProcessorName cfgProcName = procNameList.elementAt(j2);
                    if (cfgProcName.getProcessorName().equals(procName)) {
                        foundProcName = true;
                        if (addGroupName) {
                            buf = String.valueOf(buf) + "," + FortressEnv.EOL;
                            buf = String.valueOf(buf) + "\t\t\t\tnew Config_processor(\"" + cfgProc.getInstanceName() + "\", new Config_processor_name(\"" + cfgProcName.getProcessorName() + "\", " + cfgProcName.getStaticPowerCoeff() + "F, " + cfgProcName.getIdlePowerCoeff() + "F, " + cfgProcName.getRunPowerCoeff() + "F), " + cfgProc.getContextSwitchTime() + ", \"" + cfgProc.getInterfaces() + "\", \"" + groupName + "\"));" + FortressEnv.EOL;
                            buf = String.valueOf(buf) + FortressEnv.EOL;
                        } else {
                            groupName = "";
                            buf = String.valueOf(buf) + "\t\ttable[\"" + cfgProc.getInstanceName() + "\"] =\tnew RZ_config(new Config_processor(\"" + cfgProc.getInstanceName() + "\", new Config_processor_name(\"" + cfgProcName.getProcessorName() + "\", " + cfgProcName.getStaticPowerCoeff() + "F, " + cfgProcName.getIdlePowerCoeff() + "F, " + cfgProcName.getRunPowerCoeff() + "F), " + cfgProc.getContextSwitchTime() + ", \"" + cfgProc.getInterfaces() + "\", \"" + groupName + "\"));" + FortressEnv.EOL;
                            buf = String.valueOf(buf) + FortressEnv.EOL;
                        }
                    }
                    ++j2;
                }
                if (!foundProcName && addGroupName) {
                    buf = String.valueOf(buf) + ");" + FortressEnv.EOL;
                }
            }
            ++i;
        }
        if (!buf.isEmpty()) {
            buf = "\t\tvector<Config_fct_point*>* powerFctList;" + FortressEnv.EOL + FortressEnv.EOL + buf;
        }
        rk.addReplaceKeyword("FORTRESS_ADD_RZ_CONFIG_TABLE", buf);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
    }
}

