/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.generation.CSVQoS;
import fortress.generation.CSVTableLine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSVParser {
    public static final int MAX_APP_CAR_NUMBER = 45;
    final String BEGIN_END_TABLE = "======================================================================";
    final String BETWEEN_COL_TABLE = "------------------------------------------";
    double achievedSimulationTime;
    double minimumSimulationTime;
    double applicationOffset;
    double applicationHyperperiod;
    Vector<CSVTableLine> reconfUnitsOccupationRate;
    Vector<CSVTableLine> scheduler;
    Vector<CSVQoS> table_QoS;
    Vector<CSVQoS> table_QoS_per_hyperperiod;
    int RZnumber;
    Vector<String> rzName;
    Vector<CSVTableLine> rzTable;
    Hashtable<String, Vector<CSVTableLine>> rzPropertiesTable;
    int procNumber;
    Vector<String> procName;
    Vector<CSVTableLine> procTable;
    Vector<String> ImplStaticVersurPR_title;
    Vector<CSVTableLine> ImplStaticVersurPR;

    public CSVParser(String pathfile) throws FileNotFoundException, IOException {
        this.loadFile(pathfile);
    }

    public double getAchievedSimulationTimeInUs() {
        return this.achievedSimulationTime;
    }

    public double getMinimumSimulationTimeInUs() {
        return this.minimumSimulationTime;
    }

    public double getApplicationOffsetInUs() {
        return this.applicationOffset;
    }

    public double getApplicationHyperperiodInUs() {
        return this.applicationHyperperiod;
    }

    public int getRZNumber() {
        return this.RZnumber;
    }

    public Vector<String> getRZList() {
        return this.rzName;
    }

    public int getProcessorNumber() {
        return this.procNumber;
    }

    public Vector<String> getProcessorList() {
        return this.procName;
    }

    public Vector<String> getRessourceList() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.ImplStaticVersurPR.size()) {
            CSVTableLine line = this.ImplStaticVersurPR.elementAt(i);
            v.add(line.getName());
            ++i;
        }
        return v;
    }

    void loadFile(String pathfile) throws FileNotFoundException, IOException {
        String read_line;
        this.rzTable = new Vector();
        this.rzPropertiesTable = new Hashtable();
        this.rzName = new Vector();
        this.procTable = new Vector();
        this.procName = new Vector();
        this.table_QoS = new Vector();
        this.table_QoS_per_hyperperiod = new Vector();
        FileInputStream ips = new FileInputStream(pathfile);
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((read_line = br.readLine()) != null) {
            int i;
            Vector<CSVTableLine> list;
            double simulationTime = this.extractSimulationTime("Achieved simulation time:", read_line);
            if (simulationTime > 0.0) {
                this.achievedSimulationTime = simulationTime;
            }
            if ((simulationTime = this.extractSimulationTime("Minimum simulation time:", read_line)) > 0.0) {
                this.minimumSimulationTime = simulationTime;
            }
            if ((simulationTime = this.extractSimulationTime("Application offset:", read_line)) > 0.0) {
                this.applicationOffset = simulationTime;
            }
            if ((simulationTime = this.extractSimulationTime("Application hyperperiod:", read_line)) > 0.0) {
                this.applicationHyperperiod = simulationTime;
            }
            if (read_line.contains("= Processor(s) occupation rates")) {
                this.procNumber = this.extractTableOccupationRate(br, this.procName, this.procTable);
            }
            if (read_line.contains("= RZ(s) occupation rates")) {
                this.RZnumber = this.extractTableOccupationRate(br, this.rzName, this.rzTable);
            }
            if (read_line.contains("= RZ(s) properties")) {
                this.extractRZProperties(br, this.rzPropertiesTable);
            }
            if (read_line.contains("= Reconfiguration units occupation rates")) {
                this.reconfUnitsOccupationRate = this.extractCSVLines(br);
                continue;
            }
            if (read_line.contains("= Scheduler =")) {
                this.scheduler = this.extractCSVLines(br);
                continue;
            }
            if (read_line.contains("= Achieved QoS factor")) {
                list = this.extractCSVLines(br);
                i = 0;
                while (i < list.size()) {
                    this.table_QoS.add(new CSVQoS(list.elementAt(i)));
                    ++i;
                }
                continue;
            }
            if (read_line.contains("= Minimal QoS factor")) {
                list = this.extractCSVLines(br);
                i = 0;
                while (i < list.size()) {
                    this.table_QoS_per_hyperperiod.add(new CSVQoS(list.elementAt(i)));
                    ++i;
                }
                continue;
            }
            if (read_line.contains("= Missed deadlines")) {
                this.extractCSVMissedDeadlineLines(br);
                continue;
            }
            if (!read_line.contains("Static implementation versus PR implementation")) continue;
            read_line = br.readLine();
            this.ImplStaticVersurPR_title = this.extractImplStaticVersurPRTableLineFirst(read_line);
            this.ImplStaticVersurPR = this.extractCSVLines(br);
        }
        br.close();
    }

    public int extractTableOccupationRate(BufferedReader br, Vector<String> areaName, Vector<CSVTableLine> areaTable) throws IOException {
        String read_line = br.readLine();
        this.extractTableLineFirst(read_line, areaName);
        int areaNumber = areaName.size();
        read_line = br.readLine();
        areaTable.add(this.extractCSVLine(read_line));
        read_line = br.readLine();
        areaTable.add(this.extractCSVLine(read_line));
        read_line = br.readLine();
        areaTable.add(this.extractCSVLine(read_line));
        read_line = br.readLine();
        areaTable.add(this.extractCSVLine(read_line));
        read_line = br.readLine();
        areaTable.add(this.extractCSVLine(read_line));
        while ((read_line = br.readLine()) != null) {
            if ((read_line = read_line.trim()).isEmpty()) break;
            areaTable.add(this.extractCSVLine(read_line));
        }
        return areaNumber;
    }

    public void extractRZProperties(BufferedReader br, Hashtable<String, Vector<CSVTableLine>> table) throws IOException {
        String read_line;
        String name = "";
        Vector<CSVTableLine> tab = new Vector<CSVTableLine>();
        while ((read_line = br.readLine()) != null) {
            if ((read_line = read_line.trim()).isEmpty()) {
                if (name.isEmpty()) break;
                table.put(name, tab);
                break;
            }
            int index = read_line.indexOf(";");
            if (index > 0) {
                tab.add(this.extractCSVLine(read_line));
                continue;
            }
            if (!name.isEmpty()) {
                table.put(name, tab);
            }
            name = FortressEnv.transformToId(read_line.substring(index + 1).trim());
            tab = new Vector();
        }
    }

    public String toString() {
        int l;
        String s = "Achieved Simulation Time  : " + this.achievedSimulationTime + " us" + FortressEnv.EOL;
        s = String.valueOf(s) + "Minimum Simulation Time   : " + this.minimumSimulationTime + " us" + FortressEnv.EOL;
        s = String.valueOf(s) + "Application Offset        : " + this.applicationOffset + " us" + FortressEnv.EOL;
        s = String.valueOf(s) + "Application Hyperperiod   : " + this.applicationHyperperiod + " us" + FortressEnv.EOL;
        s = String.valueOf(s) + FortressEnv.EOL;
        String tmp_s = "RZ number : " + this.RZnumber;
        if (this.RZnumber > 0) {
            s = String.valueOf(s) + "======================================================================" + FortressEnv.EOL;
            l = 45 - tmp_s.length();
            if (l < 0) {
                tmp_s = tmp_s.substring(-l);
            } else {
                byte[] b = new byte[l];
                int i = 0;
                while (i < l) {
                    b[i] = 32;
                    ++i;
                }
                tmp_s = String.valueOf(tmp_s) + new String(b);
            }
            tmp_s = String.valueOf(tmp_s) + " [";
            int i = 0;
            while (i < this.RZnumber) {
                tmp_s = i == this.RZnumber - 1 ? String.valueOf(tmp_s) + this.rzName.elementAt(i) : String.valueOf(tmp_s) + this.rzName.elementAt(i) + ", ";
                ++i;
            }
            tmp_s = String.valueOf(tmp_s) + "]" + FortressEnv.EOL;
            tmp_s = String.valueOf(tmp_s) + "------------------------------------------" + FortressEnv.EOL;
            i = 0;
            while (i < this.rzTable.size()) {
                tmp_s = String.valueOf(tmp_s) + this.rzTable.elementAt(i).toString() + FortressEnv.EOL;
                if (i == 3) {
                    tmp_s = String.valueOf(tmp_s) + "------------------------------------------" + FortressEnv.EOL;
                }
                ++i;
            }
            tmp_s = String.valueOf(tmp_s) + "======================================================================" + FortressEnv.EOL;
            tmp_s = String.valueOf(tmp_s) + FortressEnv.EOL;
            if (!this.rzPropertiesTable.isEmpty()) {
                tmp_s = String.valueOf(tmp_s) + "======================================================================" + FortressEnv.EOL;
                tmp_s = String.valueOf(tmp_s) + "RZ Properties (Ressources)" + FortressEnv.EOL;
                Enumeration<String> e = this.rzPropertiesTable.keys();
                while (e.hasMoreElements()) {
                    String rzName = e.nextElement();
                    Vector<CSVTableLine> rzPropTable = this.rzPropertiesTable.get(rzName);
                    tmp_s = String.valueOf(tmp_s) + "------------------------------------------" + FortressEnv.EOL;
                    tmp_s = String.valueOf(tmp_s) + "              " + rzName + FortressEnv.EOL;
                    int j = 0;
                    while (j < rzPropTable.size()) {
                        tmp_s = String.valueOf(tmp_s) + rzPropTable.elementAt(j).toString() + FortressEnv.EOL;
                        ++j;
                    }
                }
                tmp_s = String.valueOf(tmp_s) + "======================================================================" + FortressEnv.EOL;
            }
        } else {
            tmp_s = String.valueOf(tmp_s) + FortressEnv.EOL;
        }
        s = String.valueOf(s) + tmp_s;
        s = String.valueOf(s) + FortressEnv.EOL;
        tmp_s = "Processor number : " + this.procNumber;
        if (this.procNumber > 0) {
            s = String.valueOf(s) + "======================================================================" + FortressEnv.EOL;
            l = 45 - tmp_s.length();
            if (l < 0) {
                tmp_s = tmp_s.substring(-l);
            } else {
                byte[] b = new byte[l];
                int i = 0;
                while (i < l) {
                    b[i] = 32;
                    ++i;
                }
                tmp_s = String.valueOf(tmp_s) + new String(b);
            }
            tmp_s = String.valueOf(tmp_s) + " [";
            int i = 0;
            while (i < this.procNumber) {
                tmp_s = i == this.procNumber - 1 ? String.valueOf(tmp_s) + this.procName.elementAt(i) : String.valueOf(tmp_s) + this.procName.elementAt(i) + ", ";
                ++i;
            }
            tmp_s = String.valueOf(tmp_s) + "]" + FortressEnv.EOL;
            tmp_s = String.valueOf(tmp_s) + "------------------------------------------" + FortressEnv.EOL;
            i = 0;
            while (i < this.procTable.size()) {
                tmp_s = String.valueOf(tmp_s) + this.procTable.elementAt(i).toString() + FortressEnv.EOL;
                if (i == 4) {
                    tmp_s = String.valueOf(tmp_s) + "------------------------------------------" + FortressEnv.EOL;
                }
                ++i;
            }
            tmp_s = String.valueOf(tmp_s) + "======================================================================" + FortressEnv.EOL;
        } else {
            tmp_s = String.valueOf(tmp_s) + FortressEnv.EOL;
        }
        s = String.valueOf(s) + tmp_s;
        s = String.valueOf(s) + FortressEnv.EOL;
        s = String.valueOf(s) + "Reconfiguration units occupation rates (in % of the simulation time)" + FortressEnv.EOL;
        int i = 0;
        while (i < this.reconfUnitsOccupationRate.size()) {
            s = String.valueOf(s) + "  " + this.reconfUnitsOccupationRate.elementAt(i).toString() + FortressEnv.EOL;
            ++i;
        }
        s = String.valueOf(s) + FortressEnv.EOL;
        s = String.valueOf(s) + "Scheduler" + FortressEnv.EOL;
        i = 0;
        while (i < this.scheduler.size()) {
            s = String.valueOf(s) + "  " + this.scheduler.elementAt(i).toString() + FortressEnv.EOL;
            ++i;
        }
        s = String.valueOf(s) + FortressEnv.EOL;
        s = String.valueOf(s) + "Achieved QoS factor for application (in %)" + FortressEnv.EOL;
        i = 0;
        while (i < this.table_QoS.size()) {
            s = String.valueOf(s) + "  " + this.table_QoS.elementAt(i).toString();
            ++i;
        }
        s = String.valueOf(s) + FortressEnv.EOL;
        s = String.valueOf(s) + "Minimal QoS factor on an hyperperiod (in %)" + FortressEnv.EOL;
        i = 0;
        while (i < this.table_QoS_per_hyperperiod.size()) {
            s = String.valueOf(s) + "  " + this.table_QoS_per_hyperperiod.elementAt(i).toString();
            ++i;
        }
        s = String.valueOf(s) + FortressEnv.EOL;
        if (this.RZnumber > 0) {
            s = String.valueOf(s) + "Static implementation versus PR implementation" + FortressEnv.EOL;
            String tmpS = this.ImplStaticVersurPR_title.elementAt(0);
            int l2 = 45 - tmpS.length();
            if (l2 < 0) {
                tmpS = tmpS.substring(-l2);
            } else {
                byte[] b = new byte[l2];
                int i2 = 0;
                while (i2 < l2) {
                    b[i2] = 32;
                    ++i2;
                }
                tmpS = String.valueOf(tmpS) + new String(b);
            }
            s = String.valueOf(s) + "  " + tmpS + " [";
            int i3 = 1;
            while (i3 < this.ImplStaticVersurPR_title.size()) {
                s = i3 == this.ImplStaticVersurPR_title.size() - 1 ? String.valueOf(s) + this.ImplStaticVersurPR_title.elementAt(i3) : String.valueOf(s) + this.ImplStaticVersurPR_title.elementAt(i3) + ", ";
                ++i3;
            }
            s = String.valueOf(s) + "]" + FortressEnv.EOL;
            i3 = 0;
            while (i3 < this.ImplStaticVersurPR.size()) {
                s = String.valueOf(s) + "  " + this.ImplStaticVersurPR.elementAt(i3).toString() + FortressEnv.EOL;
                ++i3;
            }
        }
        return s;
    }

    double extractSimulationTime(String timeHeaderId, String line) {
        double simulationTime = 0.0;
        if (line.contains(timeHeaderId)) {
            String[] word = line.split(":");
            word = word[1].trim().split(" ");
            simulationTime = Double.parseDouble(word[0].trim());
            String unit = word[1].trim();
            if (unit.equalsIgnoreCase("ps")) {
                simulationTime /= 1000000.0;
            } else if (unit.equalsIgnoreCase("ns")) {
                simulationTime /= 1000.0;
            } else if (unit.equalsIgnoreCase("ms")) {
                simulationTime *= 1000.0;
            } else if (unit.equalsIgnoreCase("sec")) {
                simulationTime = simulationTime * 1000.0 * 1000.0;
            }
        }
        return simulationTime;
    }

    void extractTableLineFirst(String line, Vector<String> v) {
        if (line.indexOf("RZ;") == 0 || line.indexOf(";") == 0) {
            String[] word = line.split(";");
            int i = 1;
            while (i < word.length) {
                v.add(FortressEnv.transformToId(word[i].trim()));
                ++i;
            }
        }
    }

    Vector<String> extractImplStaticVersurPRTableLineFirst(String line) {
        Vector<String> v = null;
        if (line.indexOf("Resource type;") == 0) {
            String[] word = line.split(";");
            v = new Vector<String>(word.length);
            int i = 0;
            while (i < word.length) {
                v.add(word[i].trim());
                ++i;
            }
        }
        return v;
    }

    CSVTableLine extractCSVLine(String line) {
        String[] word = line.split(";");
        Vector<Double> v = new Vector<Double>(word.length);
        int i = 1;
        while (i < word.length) {
            v.add(Double.parseDouble(word[i].trim()));
            ++i;
        }
        return new CSVTableLine(word[0].trim(), v);
    }

    Vector<CSVTableLine> extractCSVLines(BufferedReader br) throws IOException {
        String read_line;
        Vector<CSVTableLine> list = new Vector<CSVTableLine>();
        while ((read_line = br.readLine()) != null) {
            if (read_line.trim().isEmpty() || read_line.trim().startsWith("=====")) break;
            CSVTableLine csvLine = this.extractCSVLine(read_line);
            list.add(csvLine);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    void extractCSVMissedDeadlineLines(BufferedReader br) throws IOException {
        endMissedDeadline = false;
        read_line = br.readLine();
        block0: while (!endMissedDeadline && read_line != null) {
            word = read_line.split(";");
            appName = word[0].trim();
            csvQos = null;
            i = 0;
            while (i < this.table_QoS.size()) {
                if (this.table_QoS.elementAt(i).getName().equals(appName)) {
                    csvQos = this.table_QoS.elementAt(i);
                }
                ++i;
            }
            if (csvQos != null) ** GOTO lbl21
            return;
lbl-1000:
            // 1 sources

            {
                if (read_line.trim().isEmpty()) {
                    endMissedDeadline = true;
                    continue block0;
                }
                word = read_line.split(";");
                if (word[1].trim().isEmpty()) continue block0;
                csvQos.addMissedDeadline(word[0].trim(), word[1].trim());
lbl21:
                // 2 sources

                ** while ((read_line = br.readLine()) != null)
            }
lbl22:
            // 1 sources

        }
    }
}

