/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenUserRZDescriptionFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        if (!FortressEnv.isExistFile(FortressEnv.getConstraintsPath())) {
            MessageBox messageDialog = new MessageBox(shell, 1);
            messageDialog.setText("Error");
            messageDialog.setMessage("No constraint files found ! Please, create a RZ description file.");
            messageDialog.open();
            return null;
        }
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("Open RZ Description File");
        fileDialog.setFilterPath(FortressEnv.getConstraintsPath());
        String[] filterExt = new String[]{"*.rrd"};
        fileDialog.setFilterExtensions(filterExt);
        String name = fileDialog.open();
        if (name != null) {
            try {
                FortressEnv.openTextEditor(name);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && !pref.getTextEditorPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

