/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.generation.ReplaceKeyword;
import fortress.xml.FortressPreferences;
import jfb.gmf.modulesystem.ImplementationHard;
import jfb.gmf.modulesystem.ImplementationSoft;
import jfb.gmf.modulesystem.ModulesystemPackage;
import jfb.gmf.modulesystem.diagram.edit.parts.ImplementationHardEditPart;
import jfb.gmf.modulesystem.diagram.edit.parts.ImplementationSoftEditPart;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewUserModuleAlgorithmHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement();
            if (editPart instanceof ImplementationHardEditPart) {
                ImplementationHardEditPart hwEditPart = (ImplementationHardEditPart)editPart;
                ImplementationHard mod = (ImplementationHard)hwEditPart.resolveSemanticElement();
                TransactionalEditingDomain domain = hwEditPart.getEditingDomain();
                CommandStack commandStack = domain.getCommandStack();
                Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("New Hw Algorithm File");
                fileDialog.setFilterPath(FortressEnv.getUserAlgorithmsSourcePath());
                String[] filterExt = new String[]{"*.h"};
                fileDialog.setFilterExtensions(filterExt);
                String name = fileDialog.open();
                if (name != null) {
                    String template_filename = FortressEnv.getTemplateUserAlgorithmsFile();
                    if (!(name = FortressEnv.transformToIdWithPath(name.trim())).endsWith(".h")) {
                        name = String.valueOf(name) + ".h";
                    }
                    String filename = name;
                    name = FortressEnv.extractFilenameWithoutExtension(name);
                    if (FortressEnv.isExistFile(filename)) {
                        MessageBox messageDialog = new MessageBox(shell, 1);
                        messageDialog.setText("Error");
                        messageDialog.setMessage("The algorithm module " + name + ".h already exists !");
                        messageDialog.open();
                        return null;
                    }
                    ReplaceKeyword rk = new ReplaceKeyword(template_filename, filename);
                    String buf = "/**" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @file    " + name + ".h" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @author  XXX" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @version 1.0" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @date    " + FortressEnv.today() + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @section DESCRIPTION" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * " + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * User Algorithms files of " + name + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  */" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + FortressEnv.EOL;
                    rk.addReplaceKeyword("FORTRESS_HEADER", buf);
                    buf = name;
                    rk.addReplaceKeyword("RECOSIM_USER_ALGORITHM", buf);
                    buf = name.toUpperCase();
                    rk.addReplaceKeyword("RECOSIM_USER_UPPER_ALGORITHM", buf);
                    try {
                        rk.Generate();
                        commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getImplementationHard_Algorithm_name(), (Object)name));
                        commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getImplementationHard_Use_algorithm(), (Object)true));
                        FortressEnv.openTextEditor(filename);
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            } else if (editPart instanceof ImplementationSoftEditPart) {
                ImplementationSoftEditPart swEditPart = (ImplementationSoftEditPart)editPart;
                ImplementationSoft mod = (ImplementationSoft)swEditPart.resolveSemanticElement();
                TransactionalEditingDomain domain = swEditPart.getEditingDomain();
                CommandStack commandStack = domain.getCommandStack();
                Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("New Sw Algorithm File");
                fileDialog.setFilterPath(FortressEnv.getUserAlgorithmsSourcePath());
                String[] filterExt = new String[]{"*.h"};
                fileDialog.setFilterExtensions(filterExt);
                String name = fileDialog.open();
                if (name != null) {
                    String template_filename = FortressEnv.getTemplateUserAlgorithmsFile();
                    if (!(name = FortressEnv.transformToIdWithPath(name.trim())).endsWith(".h")) {
                        name = String.valueOf(name) + ".h";
                    }
                    String filename = name;
                    name = FortressEnv.extractFilenameWithoutExtension(name);
                    if (FortressEnv.isExistFile(filename)) {
                        MessageBox messageDialog = new MessageBox(shell, 1);
                        messageDialog.setText("Error");
                        messageDialog.setMessage("The algorithm module " + name + ".h already exists !");
                        messageDialog.open();
                        return null;
                    }
                    ReplaceKeyword rk = new ReplaceKeyword(template_filename, filename);
                    String buf = "/**" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @file    " + name + ".h" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @author  XXX" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @version 1.0" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @date    " + FortressEnv.today() + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * @section DESCRIPTION" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * " + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  * User Algorithms files of " + name + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "  */" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + FortressEnv.EOL;
                    rk.addReplaceKeyword("FORTRESS_HEADER", buf);
                    buf = name;
                    rk.addReplaceKeyword("RECOSIM_USER_ALGORITHM", buf);
                    buf = "\t// Sw Default behavior" + FortressEnv.EOL;
                    buf = String.valueOf(buf) + "\tuser_algorithm_SW(user_algo_interface);" + FortressEnv.EOL;
                    rk.addReplaceKeyword("RECOSIM_DEFAULT_ALGORITHM", buf);
                    buf = name.toUpperCase();
                    rk.addReplaceKeyword("RECOSIM_USER_UPPER_ALGORITHM", buf);
                    try {
                        rk.Generate();
                        commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getImplementationSoft_Algorithm_name(), (Object)name));
                        commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getImplementationSoft_Use_algorithm(), (Object)true));
                        FortressEnv.openTextEditor(filename);
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && !pref.getTextEditorPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

