/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import jfb.gmf.modulesystem.ImplementationHard;
import jfb.gmf.modulesystem.ModulesystemPackage;
import jfb.gmf.modulesystem.diagram.edit.parts.ImplementationHardEditPart;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class NetlistCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGraphicalEditPart editPart;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection && (editPart = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement()) instanceof ImplementationHardEditPart) {
            Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
            if (!FortressEnv.isExistFile(FortressEnv.getNetlistPath())) {
                MessageBox messageDialog = new MessageBox(shell, 1);
                messageDialog.setText("Error");
                messageDialog.setMessage("No Netlist files found ! Please, add/import netlist files on Preference menu.");
                messageDialog.open();
                return null;
            }
            ImplementationHardEditPart moduleEditPart = (ImplementationHardEditPart)editPart;
            ImplementationHard mod = (ImplementationHard)moduleEditPart.resolveSemanticElement();
            TransactionalEditingDomain domain = moduleEditPart.getEditingDomain();
            CommandStack commandStack = domain.getCommandStack();
            FileDialog fileDialog = new FileDialog(shell, 4096);
            fileDialog.setText("Open");
            fileDialog.setFilterPath(FortressEnv.getNetlistPath());
            String[] filterExt = new String[]{"*.ngc", "*.edf"};
            fileDialog.setFilterExtensions(filterExt);
            String selected = fileDialog.open();
            if (selected != null) {
                selected = FortressEnv.extractFilenameWithoutExtension(selected);
                commandStack.execute(SetCommand.create((EditingDomain)domain, (Object)mod, (Object)ModulesystemPackage.eINSTANCE.getImplementationHard_Netlist(), (Object)selected));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }
}

