/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportUserRZDescriptionFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FortressEnv.CreateDirectory(FortressEnv.getConstraintsPath());
        Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setText("Import RZ Description File");
        fileDialog.setFilterPath(FortressEnv.getConstraintsPath());
        String[] filterExt = new String[]{"*.rrd"};
        fileDialog.setFilterExtensions(filterExt);
        String name = fileDialog.open();
        if (name != null) {
            try {
                FortressEnv.importConstraintFile(name);
            }
            catch (IOException ex) {
                MessageBox messageDialog = new MessageBox(shell, 1);
                messageDialog.setText("Error");
                messageDialog.setMessage(ex.getMessage());
                messageDialog.open();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

