/*
 * Decompiled with CFR 0.152.
 */
package jfb.gmf.modulesystem.diagram.part;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jfb.gmf.modulesystem.ModuleDiagram;
import jfb.gmf.modulesystem.ModulesystemFactory;
import jfb.gmf.modulesystem.diagram.part.Messages;
import jfb.gmf.modulesystem.diagram.part.ModulesystemDiagramEditorPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModulesystemDiagramEditorUtil {
    public static Map<?, ?> getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static boolean openDiagram(Resource diagram) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new URIEditorInput(diagram.getURI()), "jfb.gmf.modulesystem.diagram.part.ModulesystemDiagramEditorID");
        return true;
    }

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (extension != null && !extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(extension);
        }
        extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 1;
        while (filePath.toFile().exists()) {
            filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    public static Resource openModel(Shell shell, String description, TransactionalEditingDomain editingDomain) {
        FileDialog fileDialog = new FileDialog(shell, 4096);
        if (description != null) {
            fileDialog.setText(description);
        }
        fileDialog.open();
        String fileName = fileDialog.getFileName();
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        if (fileDialog.getFilterPath() != null) {
            fileName = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileName;
        }
        URI uri = URI.createFileURI((String)fileName);
        Resource resource = null;
        try {
            resource = editingDomain.getResourceSet().getResource(uri, true);
        }
        catch (WrappedException we) {
            ModulesystemDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + uri, we);
            MessageDialog.openError((Shell)shell, (String)Messages.ModulesystemDiagramEditorUtil_OpenModelResourceErrorDialogTitle, (String)NLS.bind((String)Messages.ModulesystemDiagramEditorUtil_OpenModelResourceErrorDialogMessage, (Object)fileName));
        }
        return resource;
    }

    public static void runWizard(Shell shell, Wizard wizard, String settingsKey) {
        IDialogSettings pluginDialogSettings = ModulesystemDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);
        }
        wizard.setDialogSettings(wizardDialogSettings);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask(Messages.ModulesystemDiagramEditorUtil_CreateDiagramProgressTask, 3);
        final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.ModulesystemDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ModuleDiagram model = ModulesystemDiagramEditorUtil.createInitialModel();
                ModulesystemDiagramEditorUtil.attachModelToResource(model, modelResource);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Modulesystem", (PreferencesHint)ModulesystemDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    modelResource.save(ModulesystemDiagramEditorUtil.getSaveOptions());
                    diagramResource.save(ModulesystemDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    ModulesystemDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            ModulesystemDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        return diagramResource;
    }

    private static ModuleDiagram createInitialModel() {
        return ModulesystemFactory.eINSTANCE.createModuleDiagram();
    }

    private static void attachModelToResource(ModuleDiagram model, Resource resource) {
        resource.getContents().add((Object)model);
    }

    public static void selectElementsInDiagram(IDiagramWorkbenchPart diagramPart, List<EditPart> editParts) {
        diagramPart.getDiagramGraphicalViewer().deselectAll();
        EditPart firstPrimary = null;
        for (EditPart nextPart : editParts) {
            diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);
            if (firstPrimary != null || !(nextPart instanceof IPrimaryEditPart)) continue;
            firstPrimary = nextPart;
        }
        if (!editParts.isEmpty()) {
            diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : editParts.get(0));
        }
    }

    private static int findElementsInDiagramByID(DiagramEditPart diagramPart, EObject element, List<EditPart> editPartCollector) {
        EditPart editPart;
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramPart.getViewer();
        int intialNumOfEditParts = editPartCollector.size();
        if (element instanceof View && (editPart = (EditPart)viewer.getEditPartRegistry().get(element)) != null) {
            editPartCollector.add(editPart);
            return 1;
        }
        String elementID = EMFCoreUtil.getProxyID((EObject)element);
        List associatedParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
        for (EditPart nextPart : associatedParts) {
            EditPart parentPart = nextPart.getParent();
            while (parentPart != null && !associatedParts.contains(parentPart)) {
                parentPart = parentPart.getParent();
            }
            if (parentPart != null) continue;
            editPartCollector.add(nextPart);
        }
        if (intialNumOfEditParts == editPartCollector.size()) {
            if (!associatedParts.isEmpty()) {
                editPartCollector.add((EditPart)associatedParts.get(0));
            } else if (element.eContainer() != null) {
                return ModulesystemDiagramEditorUtil.findElementsInDiagramByID(diagramPart, element.eContainer(), editPartCollector);
            }
        }
        return editPartCollector.size() - intialNumOfEditParts;
    }

    public static View findView(DiagramEditPart diagramEditPart, EObject targetElement, LazyElement2ViewMap lazyElement2ViewMap) {
        boolean hasStructuralURI = false;
        if (targetElement.eResource() instanceof XMLResource) {
            hasStructuralURI = ((XMLResource)targetElement.eResource()).getID(targetElement) == null;
        }
        Diagram view = null;
        LinkedList<EditPart> editPartHolder = new LinkedList<EditPart>();
        if (hasStructuralURI && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {
            view = lazyElement2ViewMap.getElement2ViewMap().get(targetElement);
        } else if (ModulesystemDiagramEditorUtil.findElementsInDiagramByID(diagramEditPart, targetElement, editPartHolder) > 0) {
            EditPart editPart = editPartHolder.get(0);
            view = editPart.getModel() instanceof View ? (View)editPart.getModel() : null;
        }
        return view == null ? diagramEditPart.getDiagramView() : view;
    }

    public static class LazyElement2ViewMap {
        private Map<EObject, View> element2ViewMap;
        private View scope;
        private Set<? extends EObject> elementSet;

        public LazyElement2ViewMap(View scope, Set<? extends EObject> elements) {
            this.scope = scope;
            this.elementSet = elements;
        }

        public final Map<EObject, View> getElement2ViewMap() {
            if (this.element2ViewMap == null) {
                this.element2ViewMap = new HashMap<EObject, View>();
                for (EObject eObject : this.elementSet) {
                    View view;
                    if (!(eObject instanceof View) || (view = (View)eObject).getDiagram() != this.scope.getDiagram()) continue;
                    this.element2ViewMap.put(eObject, view);
                }
                LazyElement2ViewMap.buildElement2ViewMap(this.scope, this.element2ViewMap, this.elementSet);
            }
            return this.element2ViewMap;
        }

        private static boolean buildElement2ViewMap(View parentView, Map<EObject, View> element2ViewMap, Set<? extends EObject> elements) {
            if (elements.size() == element2ViewMap.size()) {
                return true;
            }
            if (parentView.isSetElement() && !element2ViewMap.containsKey(parentView.getElement()) && elements.contains(parentView.getElement())) {
                element2ViewMap.put(parentView.getElement(), parentView);
                if (elements.size() == element2ViewMap.size()) {
                    return true;
                }
            }
            boolean complete = false;
            Iterator it = parentView.getChildren().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            it = parentView.getSourceEdges().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            it = parentView.getTargetEdges().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            return complete;
        }
    }
}

