/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import java.util.Vector;

public class RZDescription {
    int Column;
    int Height;
    int Line;
    String RZ_ID;
    Vector<String[]> cellList;

    public RZDescription(int Line, int Column, int Height, String RZ_ID) {
        this.Line = Line;
        this.Column = Column;
        this.Height = Height;
        this.RZ_ID = RZ_ID;
        this.cellList = new Vector(Column);
    }

    public int getLine() {
        return this.Line;
    }

    public int getColumn() {
        return this.Column;
    }

    public int getHeight() {
        return this.Height;
    }

    public String getRZ_ID() {
        return this.RZ_ID;
    }

    public Vector<String[]> getDeviceCellList() {
        return this.cellList;
    }

    public void reverseDeviceCellList() {
        Vector<String[]> cellListTmp = new Vector<String[]>();
        int i = this.cellList.size() - 1;
        while (i >= 0) {
            String[] cell = this.cellList.elementAt(i);
            cellListTmp.add(cell);
            --i;
        }
        this.cellList = cellListTmp;
    }

    public String[] getDeviceCell(int column) throws Exception {
        if (column < this.cellList.size()) {
            return this.cellList.elementAt(column);
        }
        throw new Exception("Error : Column number is wrong!");
    }

    public boolean isCellUsed(int column, int row) throws Exception {
        String[] dc = this.getDeviceCell(column);
        return dc[row].equalsIgnoreCase("USED");
    }

    public boolean isCellUnused(int column, int row) throws Exception {
        String[] dc = this.getDeviceCell(column);
        return dc[row].equalsIgnoreCase("UNUSED");
    }

    public void addCell(String val) {
        String[] c = new String[this.Line];
        int i = 0;
        while (i < c.length) {
            c[i] = val;
            ++i;
        }
        this.cellList.add(c);
    }

    public void addCell(int repeat, String val) {
        int i = 0;
        while (i < repeat) {
            this.addCell(val);
            ++i;
        }
    }

    public void addCell(String[] val) {
        this.cellList.add(val);
    }

    public void addCell(int repeat, String[] val) {
        int i = 0;
        while (i < repeat) {
            this.addCell(val);
            ++i;
        }
    }
}

