/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.xml.DeviceCell;
import fortress.xml.DeviceColumn;
import fortress.xml.DevicePackage;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDevice;
import fortress.xml.TaskCellDescription;
import fortress.xml.TaskDescription;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;

public class FortressDeviceLibrary
extends FortressDevice {
    final String SliceL = "SliceL";
    final String SliceM = "SliceM";
    final String Slice = "Slice";
    Vector<DevicePackage> DevicePackageList;

    public FortressDeviceLibrary() throws Exception {
        try {
            this.loadDevicePackageList();
        }
        catch (Exception e) {
            throw new Exception("Error : Load Device Package List error ! " + e.toString());
        }
    }

    public Vector<String> getDeviceList() {
        Vector<String> v = new Vector<String>(this.DevicePackageList.size());
        int i = 0;
        while (i < this.DevicePackageList.size()) {
            v.add(this.DevicePackageList.elementAt(i).getDeviceName());
            ++i;
        }
        return v;
    }

    public DevicePackage getDevicePackage(String DeviceName) {
        int i = 0;
        while (i < this.DevicePackageList.size()) {
            if (DeviceName.equalsIgnoreCase(this.DevicePackageList.elementAt(i).getDeviceName())) {
                return this.DevicePackageList.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    void loadDevicePackageList() throws Exception {
        String path = FortressEnv.getDeviceLibraryPath();
        File dir = new File(path);
        File[] list = dir.listFiles();
        this.DevicePackageList = new Vector(list.length);
        int i = 0;
        while (i < list.length) {
            if (!list[i].isDirectory() && list[i].getName().contains(".xml")) {
                Element root = this.loadFile(String.valueOf(path) + list[i].getName());
                String DeviceName = this.getDeviceName(root);
                String[] SpeedGrade = this.getSpeedGrade(root);
                String[] DevicePackage2 = this.getDevicePackage(root);
                String Society = this.getSociety(root);
                String Category2 = this.getCategory(root);
                int LineNumber = this.getLineNumber(root);
                int ColumnNumber = this.getColumnNumber(root);
                int LutSliceNumber = this.getLutSliceNumber(root);
                int FFSliceNumber = this.getFFSliceNumber(root);
                HashMap<String, DeviceCell> refCells = this.loadReferenceCells(root);
                DevicePackage dp = this.loadCell(root, DeviceName, DevicePackage2, SpeedGrade, Society, Category2, LineNumber, ColumnNumber, LutSliceNumber, FFSliceNumber, refCells);
                this.DevicePackageList.add(dp);
            }
            ++i;
        }
    }

    HashMap<String, DeviceCell> loadReferenceCells(Element root) throws JDOMException {
        DeviceCell cell;
        HashMap<String, DeviceCell> refCells = new HashMap<String, DeviceCell>();
        List config_list = root.getChildren("Cells");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            throw new JDOMException("Error: No Reference Cells Found !");
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("Cell");
        if (!(i = config_list.iterator()).hasNext()) {
            throw new JDOMException("Error: No Cell Found on Reference Cells !");
        }
        for (Element el2 : config_list) {
            String name = el2.getAttributeValue("name");
            if (refCells.containsKey(name)) {
                throw new JDOMException("Error: NReference Cell " + name + " is declared twice !");
            }
            String description = this.getValue(el2, "desc");
            int cost = Integer.parseInt(this.getValueWithDefaultValue(el2, "cost", "0"));
            int nbCellsPerColumn = Integer.parseInt(this.getValueWithDefaultValue(el2, "nbCellsPerColumn", "0"));
            boolean reconfigurable = Boolean.parseBoolean(this.getValueWithDefaultValue(el2, "reconfigurable", "false"));
            int bitstreamSizePerColumn = Integer.parseInt(this.getValueWithDefaultValue(el2, "bitstreamSizePerColumn", "0"));
            int defaultIncrement = Integer.parseInt(this.getValueWithDefaultValue(el2, "defaultIncrement", "1"));
            String group = this.getValue(el2, "group");
            int f_red = Integer.parseInt(this.getValueWithDefaultValue(el2, "f_red", "255"));
            int f_green = Integer.parseInt(this.getValueWithDefaultValue(el2, "f_green", "255"));
            int f_blue = Integer.parseInt(this.getValueWithDefaultValue(el2, "f_blue", "255"));
            boolean virtual = Boolean.parseBoolean(this.getValueWithDefaultValue(el2, "virtual", "false"));
            boolean marginSensitive = Boolean.parseBoolean(this.getValueWithDefaultValue(el2, "marginSensitive", "false"));
            DeviceCell cell2 = new DeviceCell(name, description, reconfigurable, cost, nbCellsPerColumn, bitstreamSizePerColumn, defaultIncrement, group, new Color(f_red, f_green, f_blue), virtual, marginSensitive);
            refCells.put(name, cell2);
        }
        if (!refCells.containsKey("SliceL")) {
            cell = new DeviceCell("SliceL", "", true, 1, 40, 5904, 2, "CLB", new Color(255, 255, 255), true, true);
            refCells.put("SliceL", cell);
        }
        if (!refCells.containsKey("SliceM")) {
            cell = new DeviceCell("SliceM", "", true, 4, 40, 5904, 2, "CLB", new Color(255, 255, 255), true, true);
            refCells.put("SliceM", cell);
        }
        if (!refCells.containsKey("Slice")) {
            cell = new DeviceCell("Slice", "", true, 1, 40, 5904, 2, "CLB", new Color(255, 255, 255), true, true);
            refCells.put("Slice", cell);
        }
        return refCells;
    }

    int getLutSliceNumber(Element root) throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue(root, "Ressources", "NB_LUT_SLICE", "value", "4"));
    }

    int getFFSliceNumber(Element root) throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue(root, "Ressources", "NB_FF_SLICE", "value", "4"));
    }

    public DevicePackage loadCell(Element root, String DeviceName, String[] DevicePackage2, String[] SpeedGrade, String Society, String Category2, int LineNumber, int ColumnNumber, int LutSliceNumber, int FFSliceNumber, HashMap<String, DeviceCell> refCells) throws Exception {
        DevicePackage dp = new DevicePackage(DeviceName, DevicePackage2, SpeedGrade, Society, Category2, LineNumber, ColumnNumber, LutSliceNumber, FFSliceNumber, refCells);
        List config_list = root.getChildren("Description");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            throw new JDOMException("Error: No Description Found !");
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("CN");
        if (!(i = config_list.iterator()).hasNext()) {
            throw new JDOMException("Error: No CN Found !");
        }
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            int repeat = Integer.parseInt(this.getValueWithDefaultValue(el, "REPEAT", "1"));
            String positionConstraint = this.getValueWithDefaultValue(el, "positionConstraint", "BOTH");
            String cellName = el.getAttributeValue("ALL");
            if (cellName == null) {
                DeviceCell[] cell = new DeviceCell[LineNumber];
                int j = 0;
                while (j < LineNumber) {
                    cellName = el.getAttributeValue("L" + j);
                    if (cellName == null) {
                        throw new JDOMException("Error : No Cell found for column N\ufffd" + cpt);
                    }
                    DeviceCell c = new DeviceCell(dp.getDeviceCell(cellName));
                    c.setCoordonnate(this.getX(el, j), -1);
                    c.setPositionConstraint(positionConstraint);
                    cell[j] = c;
                    ++j;
                }
                if (repeat > 1) {
                    dp.addCell(1, cell);
                    j = 0;
                    while (j < LineNumber) {
                        cell[j].setCoordonnate(-1, -1);
                        cell[j].setPositionConstraint(positionConstraint);
                        ++j;
                    }
                    dp.addCell(repeat - 1, cell);
                } else {
                    dp.addCell(repeat, cell);
                }
            } else {
                DeviceCell c = new DeviceCell(dp.getDeviceCell(cellName));
                c.setCoordonnate(this.getX(el, 0), -1);
                c.setPositionConstraint(positionConstraint);
                if (repeat > 1) {
                    dp.addCell(1, c);
                    c.setCoordonnate(-1, -1);
                    dp.addCell(repeat - 1, c);
                } else {
                    dp.addCell(repeat, c);
                }
            }
            cpt += repeat;
        }
        if (cpt != ColumnNumber) {
            throw new JDOMException("Error : Number of Column (" + cpt + ") is not equal to the ColumnNumber (" + ColumnNumber + ")");
        }
        this.updateXYCoordinate(dp);
        return dp;
    }

    private int getX(Element el, int line) {
        String Xs = el.getAttributeValue("X" + line);
        if (Xs == null) {
            Xs = el.getAttributeValue("X");
        }
        if (Xs == null) {
            return -1;
        }
        return Integer.parseInt(Xs);
    }

    private void updateXYCoordinate(DevicePackage dp) {
        HashMap<String, DeviceCell> refCells = dp.getReferenceCell();
        Vector<DeviceColumn> colList = dp.getDeviceCellList();
        HashMap<String, int[]> XCellList = new HashMap<String, int[]>();
        for (Map.Entry<String, DeviceCell> entry : refCells.entrySet()) {
            DeviceCell refCell = entry.getValue();
            int[] cell = new int[dp.getLineNumber()];
            int i = 0;
            while (i < dp.getLineNumber()) {
                cell[i] = 0;
                ++i;
            }
            XCellList.put(refCell.getName(), cell);
        }
        int i = 0;
        while (i < colList.size()) {
            DeviceCell[] cell = colList.get(i).getCells();
            int j = 0;
            while (j < cell.length) {
                int[] cptGroupX;
                String groupCellName;
                int k;
                Vector<DeviceCell> groupList;
                String cellName = cell[j].getName();
                int[] cptX = (int[])XCellList.get(cellName);
                int X = cell[j].getX();
                if (X == -1) {
                    cell[j].setCoordonnate(cptX[j], i);
                    int n = j;
                    cptX[n] = cptX[n] + cell[j].getDefaultIncrement();
                    if (cell[j].hasGroup()) {
                        groupList = dp.getRefCellsOnGroup(cell[j].getGroup());
                        k = 0;
                        while (k < groupList.size()) {
                            groupCellName = groupList.elementAt(k).getName();
                            if (!groupCellName.equals(cellName)) {
                                cptGroupX = (int[])XCellList.get(groupCellName);
                                int n2 = j;
                                cptGroupX[n2] = cptGroupX[n2] + groupList.elementAt(k).getDefaultIncrement();
                            }
                            ++k;
                        }
                    }
                } else {
                    cell[j].setCoordonnate(X, i);
                    cptX[j] = X + cell[j].getDefaultIncrement();
                    if (cell[j].hasGroup()) {
                        groupList = dp.getRefCellsOnGroup(cell[j].getGroup());
                        k = 0;
                        while (k < groupList.size()) {
                            groupCellName = groupList.elementAt(k).getName();
                            if (!groupCellName.equals(cellName)) {
                                cptGroupX = (int[])XCellList.get(groupCellName);
                                cptGroupX[j] = X + groupList.elementAt(k).getDefaultIncrement();
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public long computeBitstreamSize(PrintStream out, FortressConfiguration conf, TaskDescription taskDescription, double margin) throws Exception {
        long bitstreamSize = 0L;
        DevicePackage dp = this.getDevicePackage(taskDescription.getDeviceName());
        if (dp == null) {
            FortressException.messageError(out, "Summary Report Gen.", "No Device Found in the task description : " + taskDescription.getDeviceName());
        }
        Vector<TaskCellDescription> taskCellList = taskDescription.getTaskCellDescriptionList();
        int i = 0;
        while (i < taskCellList.size()) {
            TaskCellDescription tcd = taskCellList.elementAt(i);
            DeviceCell dc = dp.getDeviceCell(tcd.getCellName());
            bitstreamSize += dc.computeBitstreamSize(tcd.getCellNumber(), margin);
            ++i;
        }
        return bitstreamSize;
    }
}

