/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.xml.FortressBenchModule;
import fortress.xml.FortressNodeModule;

public class FortressConnection {
    String connection_name;
    String packet_size;
    String input_communication_type;
    String output_communication_type;
    String begin_req;
    String end_req;
    String begin_resp;
    String end_resp;
    boolean input_priority_channel;
    boolean output_priority_channel;
    boolean transient_channel;
    TargetConnectionType target_Block;
    String target_module;
    Object inout_module;

    public FortressConnection(String connection_name, String packet_size, String input_communication_type, String output_communication_type, String begin_req, String end_req, String begin_resp, String end_resp, boolean input_priority_channel, boolean output_priority_channel, boolean transient_channel, TargetConnectionType target_Block, String target_module) {
        this.connection_name = connection_name;
        this.packet_size = packet_size;
        this.input_communication_type = input_communication_type;
        this.output_communication_type = output_communication_type;
        this.begin_req = begin_req;
        this.end_req = end_req;
        this.begin_resp = begin_resp;
        this.end_resp = end_resp;
        this.input_priority_channel = input_priority_channel;
        this.output_priority_channel = output_priority_channel;
        this.transient_channel = transient_channel;
        this.target_Block = target_Block;
        this.target_module = target_module;
        this.inout_module = null;
    }

    public FortressConnection(FortressConnection fc) {
        this.connection_name = fc.connection_name;
        this.packet_size = fc.packet_size;
        this.input_communication_type = fc.input_communication_type;
        this.output_communication_type = fc.output_communication_type;
        this.begin_req = fc.begin_req;
        this.end_req = fc.end_req;
        this.begin_resp = fc.begin_resp;
        this.end_resp = fc.end_resp;
        this.input_priority_channel = fc.input_priority_channel;
        this.output_priority_channel = fc.output_priority_channel;
        this.transient_channel = fc.transient_channel;
        this.target_Block = fc.target_Block;
        this.target_module = fc.target_module;
        this.inout_module = null;
    }

    public String getTargetModule() {
        return this.target_module;
    }

    public String getInOutModuleName() {
        if (this.isNodeModule()) {
            return this.getNodeModule().getModuleName();
        }
        return this.getBenchModule().getModuleName();
    }

    public void setModule(Object inModule) {
        this.inout_module = inModule;
    }

    public boolean isNodeModule() {
        return this.inout_module instanceof FortressNodeModule;
    }

    public FortressNodeModule getNodeModule() {
        return (FortressNodeModule)this.inout_module;
    }

    public FortressBenchModule getBenchModule() {
        return (FortressBenchModule)this.inout_module;
    }

    public boolean equals(FortressConnection fc) {
        return this.connection_name.equals(fc.getConnectionName());
    }

    public String getConnectionName() {
        return this.connection_name;
    }

    public static String getDefaultPacketSize() {
        return "16";
    }

    public String getPacketSize() {
        return this.packet_size;
    }

    public static String getDefaultInputCommunicationType() {
        return "DEFAULT_IF";
    }

    public String getInputCommunicationType() {
        return this.input_communication_type;
    }

    public static String getDefaultOutputCommunicationType() {
        return "DEFAULT_IF";
    }

    public String getOutputCommunicationType() {
        return this.output_communication_type;
    }

    public static String getDefaultBeginReq() {
        return "0.0";
    }

    public String getBeginReq() {
        return this.begin_req;
    }

    public static String getDefaultEndReq() {
        return "0.0";
    }

    public String getEndReq() {
        return this.end_req;
    }

    public static String getDefaultBeginResp() {
        return "0.0";
    }

    public String getBeginResp() {
        return this.begin_resp;
    }

    public static String getDefaultEndResp() {
        return "0.0";
    }

    public String getEndResp() {
        return this.end_resp;
    }

    public static boolean isDefaultInputPriorityChannel() {
        return false;
    }

    public boolean isInputPriorityChannel() {
        return this.input_priority_channel;
    }

    public static boolean isDefaultOutputPriorityChannel() {
        return false;
    }

    public boolean isOutputPriorityChannel() {
        return this.output_priority_channel;
    }

    public static boolean isDefaultTransientChannel() {
        return false;
    }

    public boolean isTransientChannel() {
        return this.transient_channel;
    }

    public static enum TargetConnectionType {
        MODULE,
        TESTBENCH;

    }
}

