/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.xml.FortressConnection;
import fortress.xml.FortressNodeModule;
import java.util.Vector;

public class FortressBenchModule {
    String module_name;
    String testBench_thread;
    boolean activated_trace;
    String tracefile;
    boolean enable_configuration_signals_trace;
    String logfile;
    String period;
    Vector<FortressConnection> outConnections;
    Vector<FortressConnection> inConnections;

    public FortressBenchModule(String module_name, String testBench_thread, String period, boolean activated_trace, String tracefile, boolean enable_configuration_signals_trace, String logfile, Vector<FortressConnection> outConnections) {
        this.module_name = module_name;
        this.testBench_thread = testBench_thread;
        this.period = period;
        this.activated_trace = activated_trace;
        this.tracefile = tracefile;
        this.enable_configuration_signals_trace = enable_configuration_signals_trace;
        this.logfile = logfile;
        this.outConnections = outConnections;
        this.inConnections = null;
    }

    public boolean equals(FortressBenchModule fmi) {
        return this.module_name.equals(fmi.getModuleName());
    }

    public boolean equals(FortressNodeModule fmi) {
        return this.module_name.equals(fmi.getModuleName());
    }

    public Vector<FortressConnection> getOutConnections() {
        return this.outConnections;
    }

    public int getOutputConnectionNumber() {
        return this.outConnections.size();
    }

    public void setInConnections(Vector<FortressConnection> inConnections) {
        this.inConnections = inConnections;
    }

    public Vector<FortressConnection> getInConnections() {
        return this.inConnections;
    }

    public int getInputConnectionNumber() {
        return this.inConnections.size();
    }

    public Vector<FortressConnection> getOutFortressConnection(String targetModuleName) {
        Vector<FortressConnection> conOutList = new Vector<FortressConnection>();
        int i = 0;
        while (i < this.outConnections.size()) {
            if (this.outConnections.elementAt(i).getTargetModule().equals(targetModuleName)) {
                conOutList.add(this.outConnections.elementAt(i));
            }
            ++i;
        }
        return conOutList;
    }

    public String getModuleName() {
        return this.module_name;
    }

    public String getPeriod() {
        return this.period;
    }

    public static String getDefaultTestBenchThread() {
        return "";
    }

    public static String getDefaultPeriod() {
        return "100";
    }

    public String getTestBenchThread() {
        return this.testBench_thread;
    }

    public static boolean isDefaultActivatedTrace() {
        return true;
    }

    public boolean isActivatedTrace() {
        return this.activated_trace;
    }

    public static boolean isDefaultEnableConfigurationSignalsTrace() {
        return false;
    }

    public boolean isEnableConfigurationSignalsTrace() {
        return this.enable_configuration_signals_trace;
    }

    public static String getDefaultTraceFile(String moduleName) {
        return String.valueOf(moduleName) + ".tra";
    }

    public String getTraceFile() {
        return this.tracefile;
    }

    public static String getDefaultLogFile(String moduleName) {
        return String.valueOf(moduleName) + ".log";
    }

    public String getLogFile() {
        return this.logfile;
    }
}

