/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.xml.DeviceCell;
import fortress.xml.DeviceColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DevicePackage {
    String DeviceName;
    String[] SpeedGrade;
    String[] DevicePackage;
    HashMap<String, DeviceCell> refCells;
    String Society;
    String Category;
    int LineNumber;
    int ColumnNumber;
    int LutSliceNumber;
    int FFSliceNumber;
    Vector<DeviceColumn> cellList;

    public DevicePackage(String DeviceName, String[] DevicePackage2, String[] SpeedGrade, String Society, String Category2, int LineNumber, int ColumnNumber, int LutSliceNumber, int FFSliceNumber, HashMap<String, DeviceCell> refCells) {
        this.DeviceName = DeviceName;
        this.SpeedGrade = SpeedGrade;
        this.DevicePackage = DevicePackage2;
        this.Society = Society;
        this.Category = Category2;
        this.LineNumber = LineNumber;
        this.ColumnNumber = ColumnNumber;
        this.LutSliceNumber = LutSliceNumber;
        this.FFSliceNumber = FFSliceNumber;
        this.refCells = refCells;
        this.cellList = new Vector(ColumnNumber);
    }

    public String getDeviceName() {
        return this.DeviceName;
    }

    public String[] getSpeedGrade() {
        return this.SpeedGrade;
    }

    public String[] getDevicePackage() {
        return this.DevicePackage;
    }

    public String getSociety() {
        return this.Society;
    }

    public String getCategory() {
        return this.Category;
    }

    public int getLineNumber() {
        return this.LineNumber;
    }

    public int getColumnNumber() {
        return this.ColumnNumber;
    }

    public Vector<DeviceColumn> getDeviceCellList() {
        return this.cellList;
    }

    public DeviceColumn getDeviceCell(int column) throws Exception {
        if (column < this.cellList.size()) {
            return this.cellList.elementAt(column);
        }
        throw new Exception("Error : Column number is wrong !");
    }

    public DeviceCell getCell(int column, int row) throws Exception {
        DeviceColumn dc = this.getDeviceCell(column);
        return dc.getCell(row);
    }

    public int getLutSliceNumber() {
        return this.LutSliceNumber;
    }

    public int getFFSliceNumber() {
        return this.FFSliceNumber;
    }

    public void addCell(DeviceCell c) {
        DeviceColumn cells = new DeviceColumn(this.LineNumber);
        cells.setAllCell(c);
        this.cellList.add(cells);
    }

    public void addCell(int repeat, DeviceCell c) {
        int i = 0;
        while (i < repeat) {
            DeviceColumn cells = new DeviceColumn(this.LineNumber);
            cells.setAllCell(c);
            this.cellList.add(cells);
            ++i;
        }
    }

    public void addCell(DeviceCell[] c) throws Exception {
        DeviceColumn cells = new DeviceColumn(this.LineNumber);
        cells.setCells(c);
        this.cellList.add(cells);
    }

    public void addCell(int repeat, DeviceCell[] c) throws Exception {
        int i = 0;
        while (i < repeat) {
            DeviceColumn cells = new DeviceColumn(this.LineNumber);
            cells.setCells(c);
            this.cellList.add(cells);
            ++i;
        }
    }

    public DeviceCell getDeviceCell(String name) throws Exception {
        if (!this.refCells.containsKey(name)) {
            throw new Exception("Error : The Cell Name " + name + " is not declared !");
        }
        return this.refCells.get(name);
    }

    public Vector<DeviceCell> getRefCellsOnGroup(String groupName) {
        Vector<DeviceCell> groupList = new Vector<DeviceCell>();
        for (Map.Entry<String, DeviceCell> entry : this.refCells.entrySet()) {
            DeviceCell cell = entry.getValue();
            if (!cell.hasGroup() || !groupName.equals(cell.getGroup())) continue;
            groupList.add(cell);
        }
        return groupList;
    }

    public HashMap<String, DeviceCell> getReferenceCell() {
        return this.refCells;
    }
}

