/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.CSVParser;
import fortress.xml.ConfigApplication;
import fortress.xml.ConfigProcessor;
import fortress.xml.DevicePackage;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressModuleImplementation;
import fortress.xml.FortressNodeModule;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressSchematic;
import fortress.xml.FortressSystem;
import fortress.xml.TaskDescription;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ReportGeneration {
    FortressSystem system;
    String configuration;

    public ReportGeneration(String configuration) {
        this.configuration = configuration;
        this.system = FortressEnv.getFortressSystem();
    }

    public void GenerateStatisticReport(OutputStream console) throws Exception {
        String csvPath;
        Vector<String> csvfileList;
        PrintStream out = new PrintStream(console);
        out.print("Loading Preferences ... ");
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        out.println("done");
        out.print("Loading Configuration ... ");
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        out.println("done");
        Vector<ConfigApplication> activeAppList = conf.getActiveConfigApplicationSchematicNameList();
        Vector<FortressSchematic> appList = new Vector<FortressSchematic>();
        int i = 0;
        while (i < activeAppList.size()) {
            ConfigApplication ca = activeAppList.elementAt(i);
            out.print("Loading Application File : " + ca.getFile() + " ... ");
            FortressSchematic fs = new FortressSchematic(ca.getFile());
            fs.loadFile(ca);
            appList.add(fs);
            out.println("done");
            ++i;
        }
        if (appList.size() == 0) {
            FortressException.messageError(out, "Statictic Report Gen.", "No application found ! Please, go to the preference menu and add application(s).");
        }
        if ((csvfileList = FortressEnv.getFileListWithoutExtension(csvPath = FortressEnv.getStatisticReportFilePath(this.configuration), ".csv")).size() == 0) {
            out.println("Generating Statistic Report File : No Results");
        } else {
            out.println("Generating Statistic Report File(s) ...");
        }
        int i2 = 0;
        while (i2 < csvfileList.size()) {
            String csvfile = String.valueOf(csvPath) + csvfileList.elementAt(i2) + ".csv";
            try {
                CSVParser csvparser = new CSVParser(csvfile);
                String buf = csvparser.toString();
                if (pref.isVerboseMode()) {
                    out.print("Generating Statistic Report File : " + csvfileList.elementAt(i2) + "_statistics.rpt ... ");
                }
                String reportFile = FortressEnv.getStatisticReportFile(this.configuration, csvfileList.elementAt(i2));
                FortressEnv.saveFile(reportFile, buf);
                if (pref.isVerboseMode()) {
                    out.println("done");
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            ++i2;
        }
    }

    public String GeneratePreReport(OutputStream console) throws Exception {
        FortressSchematic fs;
        String buf = "";
        PrintStream out = new PrintStream(console);
        out.print("Loading Preferences ... ");
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        out.println("done");
        if (pref.isVerboseMode()) {
            out.println("----------------------------------");
            out.println("- Report Generation");
            out.println("- " + FortressEnv.getLaboratory());
            out.println("- " + FortressEnv.today());
            out.println("- Configuration : " + this.configuration);
            out.println();
        }
        out.print("Loading Configuration ... ");
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        out.println("done");
        out.print("Loading Device Library ... ");
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage dp = lib.getDevicePackage(conf.getSelectedDevice());
        if (dp == null) {
            FortressException.messageError(out, "Summary Report Gen.", "No Device Found : " + conf.getSelectedDevice());
        }
        out.println("done");
        Vector<ConfigApplication> activeAppList = conf.getActiveConfigApplicationSchematicNameList();
        Vector<FortressSchematic> appList = new Vector<FortressSchematic>();
        int i = 0;
        while (i < activeAppList.size()) {
            ConfigApplication ca = activeAppList.elementAt(i);
            out.print("Loading Application File : " + ca.getFile() + " ... ");
            fs = new FortressSchematic(ca.getFile());
            fs.loadFile(ca);
            appList.add(fs);
            out.println("done");
            ++i;
        }
        if (appList.size() == 0) {
            FortressException.messageError(out, "Summary Report Gen.", "No application found ! Please, go to the preference menu and add application(s).");
        }
        buf = String.valueOf(buf) + "****************************************************" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "* FoRTReSS Generation Flow - version " + FortressEnv.getFullFortressVersion() + FortressEnv.EOL;
        buf = String.valueOf(buf) + "* " + FortressEnv.getLaboratory() + FortressEnv.EOL;
        buf = String.valueOf(buf) + "* " + FortressEnv.today() + FortressEnv.EOL;
        buf = String.valueOf(buf) + "* Configuration : " + this.configuration + FortressEnv.EOL;
        buf = String.valueOf(buf) + FortressEnv.EOL + FortressEnv.EOL;
        Vector<ConfigProcessor> procList = conf.getActiveConfigProcessorList();
        buf = String.valueOf(buf) + "=======================" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "          Plan" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "=======================" + FortressEnv.EOL;
        if (procList.size() > 0) {
            buf = String.valueOf(buf) + "\t* Processor descriptions" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t* Scheduler" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t* Application descriptions" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t* Scenario examples" + FortressEnv.EOL;
        } else {
            buf = String.valueOf(buf) + "\t* Scheduler" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t* Application descriptions" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t* Scenario examples" + FortressEnv.EOL;
        }
        buf = String.valueOf(buf) + FortressEnv.EOL;
        if (procList.size() > 0) {
            buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "                                 Processors Descriptions " + FortressEnv.EOL;
            buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
            buf = String.valueOf(buf) + FortressEnv.EOL;
            int j = 0;
            while (j < procList.size()) {
                ConfigProcessor cp = procList.elementAt(j);
                buf = String.valueOf(buf) + "Processor : " + cp.getInstanceName() + " (" + cp.getType() + ")" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "\tContext Switch time : " + cp.getContextSwitchTime() + " us" + FortressEnv.EOL;
                buf = String.valueOf(buf) + "\tInterface(s) : ";
                String type_if = cp.getInterfaces();
                Vector<String> type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if);
                if (type_if_list == null) {
                    FortressException.messageError(out, "Summary Report Gen.", "Syntax Error on Interface Type for Processor " + cp.getInstanceName() + " with type " + cp.getType() + " : " + type_if);
                }
                if (type_if_list.size() == 0) {
                    buf = String.valueOf(buf) + "None";
                }
                int cpt_if = 0;
                while (cpt_if < type_if_list.size()) {
                    buf = cpt_if == 0 ? String.valueOf(buf) + type_if_list.elementAt(cpt_if) : String.valueOf(buf) + ", " + type_if_list.elementAt(cpt_if);
                    ++cpt_if;
                }
                buf = String.valueOf(buf) + FortressEnv.EOL;
                buf = String.valueOf(buf) + FortressEnv.EOL;
                ++j;
            }
            buf = String.valueOf(buf) + FortressEnv.EOL;
        }
        buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "                                  Scheduler" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
        buf = String.valueOf(buf) + FortressEnv.EOL;
        buf = String.valueOf(buf) + "Scheduler Overhead : " + conf.getSchedulerExecutionTime() + " us" + FortressEnv.EOL;
        buf = String.valueOf(buf) + FortressEnv.EOL;
        buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "                         Application Descriptions" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "================================================================================" + FortressEnv.EOL;
        int i2 = 0;
        while (i2 < appList.size()) {
            fs = (FortressSchematic)appList.elementAt(i2);
            String appPrefix = appList.size() == 1 ? "" : String.valueOf(fs.getApplicationName()) + "_";
            Vector<ConfigApplication> configAppList = conf.getConfigApplicationList();
            Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(configAppList, fs.getFileName());
            int app_repeat = instanceConfigAppList.size();
            buf = String.valueOf(buf) + "Application : " + fs.getApplicationName() + " (Instance number : " + app_repeat + ")" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + FortressEnv.EOL;
            buf = String.valueOf(buf) + FortressEnv.EOL;
            int repeat = 0;
            while (repeat < app_repeat) {
                Vector<FortressNodeModule> nodeList = fs.getNodeModuleList();
                String iter = app_repeat == 1 ? "" : "_" + String.valueOf(repeat);
                int j = 0;
                while (j < nodeList.size()) {
                    String implName;
                    FortressModuleImplementation fmi;
                    FortressNodeModule node = nodeList.elementAt(j);
                    String moduleName = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter;
                    buf = String.valueOf(buf) + "\t" + moduleName + " (";
                    buf = node.getPeriod().isEmpty() ? String.valueOf(buf) + "No Periodic Task" : (Integer.valueOf(node.getPeriod()) == 0 ? String.valueOf(buf) + "No Periodic Task" : String.valueOf(buf) + "Period Task : " + node.getPeriod() + " us");
                    buf = String.valueOf(buf) + ", Begin time : " + node.getBeginTime() + " us";
                    buf = String.valueOf(buf) + ", Deadline : " + node.getDeadline() + " us";
                    buf = String.valueOf(buf) + ")" + FortressEnv.EOL;
                    Vector<FortressModuleImplementation> implList = node.getHwImplementationList();
                    if (implList.size() == 0) {
                        buf = String.valueOf(buf) + "\t\t(No Hw Implementation)" + FortressEnv.EOL;
                    }
                    int k = 0;
                    while (k < implList.size()) {
                        double impl_margin;
                        fmi = implList.elementAt(k);
                        implName = String.valueOf(moduleName) + "." + FortressEnv.transformToId(fmi.getImplementationName());
                        String task_report = fmi.getTaskReport();
                        String task_report_file = pref.getAbsoluteTaskFile(task_report);
                        if (task_report_file == null) {
                            FortressException.messageError(out, "Summary Report Gen.", "No Task Report File found (" + task_report + ") for Implementation " + fmi.getImplementationName() + " for node " + moduleName + ". Please select a report on popup menu of the Hw implementation.");
                        }
                        buf = String.valueOf(buf) + "\t\t" + implName + " (Report : " + task_report + ")" + FortressEnv.EOL;
                        double margin = Double.parseDouble(conf.getResourcesMargin());
                        TaskDescription taskDescription = new TaskDescription(lib, task_report_file);
                        buf = String.valueOf(buf) + "\t\t\t" + taskDescription.toString();
                        String margin_s = fmi.getResourceMargin().trim();
                        if (!margin_s.isEmpty() && (impl_margin = Double.parseDouble(margin_s)) != 0.0) {
                            margin = impl_margin;
                        }
                        buf = String.valueOf(buf) + ", margin : " + margin + "%";
                        long bitstreamSize = lib.computeBitstreamSize(out, conf, taskDescription, margin);
                        buf = String.valueOf(buf) + ", estimated bitstream size : " + bitstreamSize + " bytes";
                        buf = String.valueOf(buf) + FortressEnv.EOL;
                        buf = fmi.getNbPreemptionPoints() > 0 ? String.valueOf(buf) + "\t\t\tPremptive (" + fmi.getNbPreemptionPoints() + ")" : String.valueOf(buf) + "\t\t\t";
                        buf = String.valueOf(buf) + ", BCET : " + fmi.getBCET() + " us";
                        buf = String.valueOf(buf) + ", WCET : " + fmi.getWCET() + " us";
                        buf = String.valueOf(buf) + ", Context Swith : " + fmi.getContextSwitchTime() + " us";
                        double reconfigTime = conf.computeReconfigurationTime(bitstreamSize);
                        buf = String.valueOf(buf) + ", reconfig time : " + (double)Math.round(reconfigTime * 10.0) / 10.0 + " us";
                        buf = String.valueOf(buf) + FortressEnv.EOL;
                        ++k;
                    }
                    implList = node.getSwImplementationList();
                    if (implList.size() == 0) {
                        buf = String.valueOf(buf) + "\t\t(No Sw Implementation)" + FortressEnv.EOL;
                    }
                    k = 0;
                    while (k < implList.size()) {
                        fmi = implList.elementAt(k);
                        implName = String.valueOf(moduleName) + "." + FortressEnv.transformToId(fmi.getImplementationName());
                        buf = String.valueOf(buf) + "\t\t" + implName + FortressEnv.EOL;
                        buf = fmi.getNbPreemptionPoints() > 0 ? String.valueOf(buf) + "\t\t\tPremptive (" + fmi.getNbPreemptionPoints() + ")" : String.valueOf(buf) + "\t\t\t";
                        buf = String.valueOf(buf) + "BCET : " + fmi.getBCET() + " us";
                        buf = String.valueOf(buf) + ", WCET : " + fmi.getWCET() + " us";
                        buf = String.valueOf(buf) + ", Context Swith : cf. processor";
                        buf = String.valueOf(buf) + ", binary loading time : " + fmi.getBinaryLoadingTime() + " us";
                        buf = String.valueOf(buf) + FortressEnv.EOL;
                        ++k;
                    }
                    buf = String.valueOf(buf) + FortressEnv.EOL;
                    ++j;
                }
                ++repeat;
            }
            buf = String.valueOf(buf) + FortressEnv.EOL;
            ++i2;
        }
        String timing_examples = FortressEnv.readTextFile(FortressEnv.getTimingExamplesFile());
        buf = String.valueOf(buf) + timing_examples + FortressEnv.EOL;
        return buf;
    }
}

