/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.generation.ApplicationGeneration;
import fortress.generation.ConfigRZGeneration;
import fortress.generation.DeviceHeaderGeneration;
import fortress.generation.VariousGeneration;
import fortress.xml.DevicePackage;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import java.io.OutputStream;
import java.io.PrintStream;

public class FortressGeneration {
    String configuration;
    boolean middleware_gen;

    public FortressGeneration(String configuration) {
        this.configuration = configuration;
        this.middleware_gen = false;
    }

    public FortressGeneration(String configuration, boolean middleware_gen) {
        this.configuration = configuration;
        this.middleware_gen = middleware_gen;
    }

    public void Generate(OutputStream console) throws Exception {
        PrintStream out = new PrintStream(console);
        out.println("****************************************************");
        out.println("* FoRTReSS Generation Flow - version " + FortressEnv.getFullFortressVersion());
        out.println("* " + FortressEnv.getLaboratory());
        out.println("* " + FortressEnv.today());
        out.println("* Configuration : " + this.configuration);
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage dp = lib.getDevicePackage(conf.getSelectedDevice());
        if (dp == null) {
            throw new Exception("No Device Found : " + conf.getSelectedDevice());
        }
        out.println("* Device Name : " + dp.getDeviceName() + " (" + dp.getCategory() + ")");
        out.println();
        ApplicationGeneration apps = new ApplicationGeneration(this.configuration);
        apps.GenerateRecosim(console);
        apps.GenerateMiddleware(console);
        DeviceHeaderGeneration ghg = new DeviceHeaderGeneration(this.configuration);
        ghg.Generate(console);
        ConfigRZGeneration cfgRZgen = new ConfigRZGeneration(this.configuration);
        cfgRZgen.Generate(console);
        VariousGeneration vg = new VariousGeneration(this.configuration);
        vg.Generate(console);
        apps.printStatistic(out);
        out.println();
        out.println();
        out.println("FoRTReSS Generation Flow ... done !");
    }

    public static String createFortressHeaderForBatFile(String file, String description) {
        return FortressGeneration.createFortressHeader("rem ***************************", "rem", "", file, description);
    }

    public static String createFortressHeaderForBatFile(String file, String[] description) {
        return FortressGeneration.createFortressHeader("rem ***************************", "rem", "", file, description);
    }

    public static String createFortressHeaderForC(String file, String description) {
        return FortressGeneration.createFortressHeader("/**", " *", "*/", file, description);
    }

    public static String createFortressHeaderForC(String file, String[] description) {
        return FortressGeneration.createFortressHeader("/**", " *", "*/", file, description);
    }

    public static String createFortressHeaderForVHDL(String file, String description) {
        return FortressGeneration.createFortressHeader("------------------------------", "--", "------------------------------", file, description);
    }

    public static String createFortressHeaderForVHDL(String file, String[] description) {
        return FortressGeneration.createFortressHeader("------------------------------", "--", "------------------------------", file, description);
    }

    public static String createFortressHeaderForTCL(String file, String description) {
        return FortressGeneration.createFortressHeader("##############################", "##", "", file, description);
    }

    public static String createFortressHeaderForTCL(String file, String[] description) {
        return FortressGeneration.createFortressHeader("##############################", "##", "", file, description);
    }

    public static String createFortressHeader(String beginRem, String middleRem, String endRem, String file, String description) {
        return FortressGeneration.createFortressHeader(beginRem, middleRem, endRem, file, new String[]{description});
    }

    public static String createFortressHeader(String beginRem, String middleRem, String endRem, String file, String[] description) {
        String buf = String.valueOf(beginRem) + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " UNS - CNRS" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " Copyright 2013 All Rights Reserved." + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " These computer program listings and specifications, herein, are" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " the property of Universit\ufffd de Nice Sophia-Antipolis (UNS) and Centre National" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " de la Recherche Scientifique (CNRS), and shall not be reproduced or" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " copied or used in whole or in part as the basis for manufacture" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " or sale of items without written permission." + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " For a license agreement, please contact: licensing@sattse.com" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " @file    " + file + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + "          " + FortressEnv.getLaboratory() + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " @version " + FortressEnv.getFullFortressVersion() + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " @date    " + FortressEnv.today() + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + " @section DESCRIPTION" + FortressEnv.EOL;
        buf = String.valueOf(buf) + middleRem + FortressEnv.EOL;
        int i = 0;
        while (i < description.length) {
            buf = String.valueOf(buf) + middleRem + "          " + description[i] + FortressEnv.EOL;
            ++i;
        }
        buf = String.valueOf(buf) + endRem + FortressEnv.EOL;
        buf = String.valueOf(buf) + FortressEnv.EOL;
        return buf;
    }
}

