/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import fortress.env.CommandExec;
import fortress.env.CommandExecListener;
import fortress.env.ConsoleCommandExecListener;
import fortress.env.DoubleOutputStream;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.DoWaveGeneration;
import fortress.generation.FortressGeneration;
import fortress.generation.LatexTraceGeneration;
import fortress.generation.ReportGeneration;
import fortress.generation.VariousGeneration;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.ui.console.MessageConsoleStream;

public class FortressFlow
extends Thread {
    public final int NO_SOLUTION_FOUND = -559038737;
    String configuration;
    OutputStream console;
    FlowStep flowStep;
    boolean middleware_gen;
    String arg;
    CommandExec cmdExec;
    CommandExecListener commandExecListener;
    static Vector<FortressFlow> flowList = new Vector();

    public FortressFlow(String configuration, OutputStream console, boolean middleware_gen, String arg) {
        this.configuration = configuration;
        this.console = console;
        this.cmdExec = null;
        this.middleware_gen = middleware_gen;
        this.arg = arg;
    }

    public void setCommandExecListener(CommandExecListener commandExecListener) {
        this.commandExecListener = commandExecListener;
    }

    public void terminateCmdExecCommand() {
        if (this.cmdExec != null) {
            this.cmdExec.interrupt();
        }
    }

    public void setFlowStep(FlowStep flowStep) {
        this.flowStep = flowStep;
    }

    @Override
    public void run() {
        block16: {
            try {
                int exitValue = -1;
                FortressConsole.getMessageConsoleStream();
                if (this.flowStep == FlowStep.GENE_BEFORE_SIM) {
                    exitValue = this.generationBeforeSimulation();
                } else if (this.flowStep == FlowStep.COMPILE) {
                    exitValue = this.compilation();
                } else if (this.flowStep == FlowStep.COMPILE_MW) {
                    exitValue = this.compilationMiddleware();
                } else if (this.flowStep == FlowStep.EXECUTE_MW) {
                    exitValue = this.executeMiddleware();
                } else if (this.flowStep == FlowStep.SIMULATE) {
                    exitValue = this.simulation();
                } else if (this.flowStep == FlowStep.RUN_VISUAL_CPP) {
                    exitValue = this.runVisualBeforeSimulation();
                } else if (this.flowStep == FlowStep.RUN_CODE_BLOCK) {
                    exitValue = this.runCodeBlockBeforeSimulation();
                }
                if (this.commandExecListener != null) {
                    this.commandExecListener.commandExecStop(exitValue);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.commandExecListener == null) break block16;
                this.commandExecListener.commandExecInterruptedException(ex);
            }
        }
    }

    public static FortressFlow createFortressFlow(String configuration, OutputStream console, boolean middleware_gen) {
        return FortressFlow.createFortressFlow(configuration, console, middleware_gen, null);
    }

    public static FortressFlow createFortressFlow(String configuration, OutputStream console, boolean middleware_gen, String arg) {
        FortressFlow.removeFortressFlow(configuration);
        FortressFlow ff = new FortressFlow(configuration, console, middleware_gen, arg);
        flowList.add(ff);
        return ff;
    }

    public static int existsFortressFlow(String configuration) {
        int i = 0;
        while (i < flowList.size()) {
            if (flowList.elementAt(i).getConfiguration().equals(configuration)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean removeFortressFlow(String configuration) {
        int val = FortressFlow.existsFortressFlow(configuration);
        if (val != -1) {
            flowList.removeElementAt(val);
            return true;
        }
        return false;
    }

    public static void terminateAllFortressFlow() {
        int i = 0;
        while (i < flowList.size()) {
            FortressFlow ff = flowList.elementAt(i);
            ff.terminateCmdExecCommand();
            ff.interrupt();
            ++i;
        }
        flowList.removeAllElements();
    }

    public static void runFortressConfiguration(String configuration, FlowStep flowStep, boolean middleware_gen) throws Exception {
        FortressFlow.runFortressConfiguration(configuration, flowStep, middleware_gen, null);
    }

    public static void runFortressConfiguration(String configuration, FlowStep flowStep, boolean middleware_gen, String arg) throws Exception {
        Vector<String> v = new Vector<String>();
        v.add(configuration);
        FortressFlow.runFortressConfigurations(configuration, v, flowStep, middleware_gen, arg);
    }

    public static void runFortressConfigurations(String currentConfiguration, Vector<String> configurationList, FlowStep flowStep, boolean middleware_gen) throws Exception {
        FortressFlow.runFortressConfigurations(currentConfiguration, configurationList, flowStep, middleware_gen, null);
    }

    public static void runFortressConfigurations(String currentConfiguration, Vector<String> configurationList, FlowStep flowStep, boolean middleware_gen, String arg) throws Exception {
        MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
        int i = 0;
        while (i < configurationList.size()) {
            FortressFlow flow;
            String configuration = configurationList.elementAt(i);
            if (currentConfiguration.equals(configuration)) {
                flow = FortressFlow.createFortressFlow(configuration, (OutputStream)console, middleware_gen, arg);
                flow.setCommandExecListener(new ConsoleCommandExecListener(console));
            } else {
                flow = FortressFlow.createFortressFlow(configuration, null, middleware_gen, arg);
            }
            flow.setFlowStep(flowStep);
            flow.start();
            FortressFlow.removeFortressFlow(configuration);
            ++i;
        }
    }

    public static boolean cleanAllGeneratedFilesConfiguration(Vector<String> configurationList) throws IOException, FileNotFoundException {
        MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
        boolean result = true;
        int i = 0;
        while (i < configurationList.size()) {
            String configuration = configurationList.elementAt(i);
            result &= FortressFlow.cleanAllGeneratedFilesConfiguration((OutputStream)console, configuration);
            ++i;
        }
        return result;
    }

    public static boolean cleanAllGeneratedFilesConfiguration(OutputStream console, String configuration) throws IOException, FileNotFoundException {
        boolean result;
        int error_nb = 0;
        String logFile = FortressEnv.getConfigurationLogFile(configuration);
        FileOutputStream ops = new FileOutputStream(logFile, false);
        DoubleOutputStream doubleStream = new DoubleOutputStream(console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println("Clean All Generated Files for configuration : " + configuration + " ...");
        String path = FortressEnv.getCopyGenerationDirPath(configuration, false);
        if (FortressEnv.isExistFile(path) && !(result = FortressEnv.deleteDir(new File(path)))) {
            printout.println("Error: Impossible to delete Simulation directory : " + path);
            ++error_nb;
        }
        if (FortressEnv.isExistFile(path = FortressEnv.getCopyGenerationDirPath(configuration, true)) && !(result = FortressEnv.deleteDir(new File(path)))) {
            printout.println("Error: Impossible to delete Middleware directory : " + path);
            ++error_nb;
        }
        if (FortressEnv.isExistFile(path = FortressEnv.getVCDTraceFilePath(configuration)) && !(result = FortressEnv.deleteDir(new File(path)))) {
            printout.println("Error: Impossible to delete Solution directory : " + path);
            ++error_nb;
        }
        if (FortressEnv.isExistFile(path = FortressEnv.getPlacementPath(configuration)) && !(result = FortressEnv.deleteDir(new File(path)))) {
            printout.println("Error: Impossible to delete Placement directory : " + path);
            ++error_nb;
        }
        if (error_nb == 0) {
            printout.println("done !");
        } else {
            printout.println(String.valueOf(error_nb) + " Error(s) : Some directories were not deleted.");
        }
        ((OutputStream)ops).close();
        return true;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    void setConsole(OutputStream console) {
        this.console = console;
    }

    public int generationBeforeSimulation() throws Exception {
        return this.generationBeforeSimulation(true);
    }

    public int generationBeforeSimulation(boolean resetLogFile) throws Exception {
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        if (flowStep == FlowStep.EXECUTE_MW || flowStep == FlowStep.COMPILE_MW || flowStep == FlowStep.COMPILE || flowStep == FlowStep.SIMULATE || flowStep == FlowStep.GENE_AFTER_SIM) {
            String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
            FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
            DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
            PrintStream printout = new PrintStream(doubleStream);
            printout.println("Generation is already done !");
            ((OutputStream)ops).close();
            return 0;
        }
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        try (FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);){
            DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
            PrintStream printout = new PrintStream(doubleStream);
            String reportFile = FortressEnv.getApplicationSummaryReportFile(this.configuration);
            try {
                printout.println("Generation of Information Report ... ");
                ReportGeneration rg = new ReportGeneration(this.configuration);
                String buf = rg.GeneratePreReport(doubleStream);
                FortressEnv.saveFile(reportFile, buf);
                printout.println("done ! ");
            }
            catch (Exception ex) {
                printout.println("ERROR : " + ex.getMessage());
                FortressEnv.deleteFile(reportFile);
                ex.printStackTrace();
            }
            FortressGeneration fg = new FortressGeneration(this.configuration);
            fg.Generate(doubleStream);
        }
        return 0;
    }

    public int runVisualBeforeSimulation() throws Exception {
        return this.runVisualBeforeSimulation(false);
    }

    public int runVisualBeforeSimulation(boolean resetLogFile) throws Exception {
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Running Visual C++  (configuration : " + this.configuration + ")");
        printout.println();
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            printout.println();
            printout.println("WARNING : the generation is not updated !");
            printout.println();
        }
        String dir = FortressEnv.getScriptCompilationFilePath(this.configuration);
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        pref.loadFile();
        String cmd = String.valueOf(dir) + "FoRTReSS_run_visual.bat";
        printout.println(String.valueOf(cmd) + " from dir " + dir);
        this.cmdExec = null;
        int exitValue = -1;
        try {
            this.cmdExec = new CommandExec(null, dir, cmd, this.commandExecListener);
            this.cmdExec.start();
            exitValue = this.cmdExec.waitFor();
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int runCodeBlockBeforeSimulation() throws Exception {
        return this.runCodeBlockBeforeSimulation(false);
    }

    public int runCodeBlockBeforeSimulation(boolean resetLogFile) throws Exception {
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Running Code Block  (configuration : " + this.configuration + ")");
        printout.println();
        String solutionPath = FortressEnv.getSolutionsPath(this.configuration);
        new File(solutionPath).mkdir();
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            printout.println();
            printout.println("WARNING : the generation is not updated !");
            printout.println();
        }
        String dir = FortressEnv.getScriptCompilationFilePath(this.configuration);
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        pref.loadFile();
        String cmd = String.valueOf(dir) + "open_cb";
        printout.println(String.valueOf(cmd) + " from dir " + dir);
        this.cmdExec = null;
        int exitValue = -1;
        try {
            this.cmdExec = new CommandExec(null, dir, cmd, this.commandExecListener);
            this.cmdExec.start();
            exitValue = this.cmdExec.waitFor();
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int compilation() throws Exception {
        return this.compilation(false);
    }

    public int compilation(boolean resetLogFile) throws Exception {
        PrintStream printout;
        DoubleOutputStream doubleStream;
        FileOutputStream ops;
        String logFile;
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            this.generationBeforeSimulation();
        } else if (flowStep == FlowStep.SIMULATE || flowStep == FlowStep.GENE_AFTER_SIM) {
            logFile = FortressEnv.getConfigurationLogFile(this.configuration);
            ops = new FileOutputStream(logFile, !resetLogFile);
            doubleStream = new DoubleOutputStream(this.console, ops);
            printout = new PrintStream(doubleStream);
            printout.println("Compilation is already done !");
            ((OutputStream)ops).close();
        }
        logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        ops = new FileOutputStream(logFile, !resetLogFile);
        doubleStream = new DoubleOutputStream(this.console, ops);
        printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Compilation Step  (configuration : " + this.configuration + ")");
        printout.println();
        String dir = FortressEnv.getScriptCompilationFilePath(this.configuration);
        String cmd = "";
        if (FortressEnv.isWindowsOS()) {
            cmd = VariousGeneration.getWindowsCompilationBatFile(this.configuration);
        } else if (FortressEnv.isLinuxOS()) {
            cmd = "make";
        }
        printout.println("Running " + cmd + "from dir " + dir);
        this.cmdExec = null;
        int exitValue = -1;
        try {
            this.cmdExec = new CommandExec(doubleStream, dir, cmd, this.commandExecListener);
            this.cmdExec.start();
            exitValue = this.cmdExec.waitFor();
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int compilationMiddleware() throws Exception {
        return this.compilationMiddleware(false);
    }

    public int compilationMiddleware(boolean resetLogFile) throws Exception {
        PrintStream printout;
        DoubleOutputStream doubleStream;
        FileOutputStream ops;
        String logFile;
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            this.generationBeforeSimulation();
        } else if (flowStep == FlowStep.SIMULATE || flowStep == FlowStep.GENE_AFTER_SIM) {
            logFile = FortressEnv.getConfigurationLogFile(this.configuration);
            ops = new FileOutputStream(logFile, !resetLogFile);
            doubleStream = new DoubleOutputStream(this.console, ops);
            printout = new PrintStream(doubleStream);
            printout.println("Compilation is already done !");
            ((OutputStream)ops).close();
        }
        logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        ops = new FileOutputStream(logFile, !resetLogFile);
        doubleStream = new DoubleOutputStream(this.console, ops);
        printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Compilation Middleware Step  (configuration : " + this.configuration + ")");
        printout.println();
        String dir = FortressEnv.getCopyGenerationDirPath(this.configuration, true);
        String cmd = "";
        if (FortressEnv.isWindowsOS()) {
            cmd = VariousGeneration.getWindowsCompilationBatFile(this.configuration);
        } else if (FortressEnv.isLinuxOS()) {
            cmd = "make";
        }
        printout.println("Running " + cmd + "from dir " + dir);
        this.cmdExec = null;
        int exitValue = -1;
        try {
            this.cmdExec = new CommandExec(doubleStream, dir, cmd, this.commandExecListener);
            this.cmdExec.start();
            exitValue = this.cmdExec.waitFor();
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int simulation() throws Exception {
        return this.simulation(false);
    }

    public int simulation(boolean resetLogFile) throws Exception {
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            this.generationBeforeSimulation();
            this.compilation();
        } else if (flowStep == FlowStep.COMPILE) {
            this.compilation();
        } else if (flowStep == FlowStep.GENE_AFTER_SIM) {
            String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
            FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
            DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
            PrintStream printout = new PrintStream(doubleStream);
            printout.println("Simulation is already done !");
            printout.println();
            ((OutputStream)ops).close();
        }
        File sim_dir = new File(FortressEnv.getSolutionsPath(this.configuration));
        if (sim_dir.exists() && !FortressEnv.deleteDir(sim_dir)) {
            throw new Exception("Error : The solutions directory is not deleted. Please, close the tools using this directory or delete it manually");
        }
        FortressEnv.CreateDirectory(FortressEnv.getResultFortressSimulationPath(this.configuration));
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Simulation Step  (configuration : " + this.configuration + ")");
        printout.println();
        String dir = FortressEnv.getFortressRunningSimulationPath(this.configuration);
        String cmd = "";
        if (FortressEnv.isWindowsOS()) {
            cmd = FortressEnv.getWindowsFortressSimulationExecutable(this.configuration);
        } else if (FortressEnv.isLinuxOS()) {
            cmd = FortressEnv.getLinuxFortressSimulationExecutable(this.configuration);
        }
        printout.println("Working Directory : " + dir);
        printout.println("Running " + cmd);
        printout.println();
        if (!FortressFlow.checkXercesLibraryPath()) {
            FortressException.messageWarning(printout, "Env Sim.", "Xerces Library may not be added on your PATH env.");
        }
        int exitValue = -1;
        this.cmdExec = null;
        try {
            try {
                this.cmdExec = new CommandExec(doubleStream, dir, cmd, this.commandExecListener);
                this.cmdExec.start();
                exitValue = this.cmdExec.waitFor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.generationAfterSimulation();
                if (this.cmdExec != null) {
                    this.cmdExec.close();
                }
                ((OutputStream)ops).close();
                this.cmdExec = null;
            }
        }
        finally {
            this.generationAfterSimulation();
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int executeMiddleware() throws Exception {
        return this.executeMiddleware(false);
    }

    public int executeMiddleware(boolean resetLogFile) throws Exception {
        PrintStream printout;
        DoubleOutputStream doubleStream;
        FileOutputStream ops;
        String logFile;
        FlowStep flowStep = FortressFlow.checkingRecentStep(this.configuration, this.middleware_gen);
        if (flowStep == FlowStep.GENE_BEFORE_SIM) {
            this.generationBeforeSimulation();
            this.compilationMiddleware();
        } else if (flowStep == FlowStep.COMPILE || flowStep == FlowStep.COMPILE_MW) {
            this.compilationMiddleware();
        } else if (flowStep == FlowStep.GENE_AFTER_SIM) {
            logFile = FortressEnv.getConfigurationLogFile(this.configuration);
            ops = new FileOutputStream(logFile, !resetLogFile);
            doubleStream = new DoubleOutputStream(this.console, ops);
            printout = new PrintStream(doubleStream);
            printout.println("Simulation is already done !");
            printout.println();
            ((OutputStream)ops).close();
        }
        logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        ops = new FileOutputStream(logFile, !resetLogFile);
        doubleStream = new DoubleOutputStream(this.console, ops);
        printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("Middleware Execution Step  (configuration : " + this.configuration + ")");
        printout.println();
        String[] cmd = new String[2];
        String dir = FortressEnv.getCopyGenerationDirPath(this.configuration, true);
        cmd[0] = "." + File.separator + "exe" + File.separator + "RecoSim";
        cmd[1] = this.arg;
        printout.println("Working Directory : " + dir);
        printout.println("Running " + cmd[0] + " " + cmd[1]);
        printout.println();
        int exitValue = -1;
        this.cmdExec = null;
        try {
            try {
                this.cmdExec = new CommandExec(doubleStream, dir, cmd, this.commandExecListener);
                this.cmdExec.start();
                exitValue = this.cmdExec.waitFor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.cmdExec != null) {
                    this.cmdExec.close();
                }
                ((OutputStream)ops).close();
                this.cmdExec = null;
            }
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public void generationAfterSimulation() throws Exception {
        this.generationAfterSimulation(false);
    }

    public void generationAfterSimulation(boolean resetLogFile) throws Exception {
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        try {
            try {
                String rzSetPath = FortressEnv.getFortressRunningSimulationPath(this.configuration);
                String destDir = FortressEnv.getCopyGenerationDirPath(this.configuration, true);
                File rzSetPathFile = new File(rzSetPath);
                File[] files = rzSetPathFile.listFiles();
                int i = 0;
                while (i < files.length) {
                    String file = files[i].getName();
                    if (file.startsWith("RZset_")) {
                        FortressEnv.FileCopy(files[i], new File(String.valueOf(destDir) + File.separator + file));
                    }
                    ++i;
                }
                DoWaveGeneration dwg = new DoWaveGeneration(this.configuration);
                dwg.Generate(doubleStream);
                ReportGeneration rg = new ReportGeneration(this.configuration);
                rg.GenerateStatisticReport(doubleStream);
                LatexTraceGeneration ltg = new LatexTraceGeneration(this.configuration);
                ltg.Generate(doubleStream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ((OutputStream)ops).close();
            }
        }
        finally {
            ((OutputStream)ops).close();
        }
    }

    public static boolean isFlowUpdated(String configuration, boolean middleware_gen) throws Exception {
        FlowStep step = FortressFlow.checkingRecentStep(configuration, middleware_gen);
        return step == FlowStep.GENE_AFTER_SIM;
    }

    static FlowStep checkingRecentStep(String configuration, boolean middleware_gen) throws Exception {
        FlowStep step = FlowStep.GENE_BEFORE_SIM;
        long gene_before_sim = 0L;
        long date = FortressEnv.getDate(FortressEnv.getPreferencesFile());
        if (date > gene_before_sim) {
            gene_before_sim = date;
        }
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(configuration);
        date = FortressEnv.getDate(FortressEnv.getConfigurationFile(configuration));
        if (date > gene_before_sim) {
            gene_before_sim = date;
        }
        Vector<ConfigApplication> appNameList = conf.getConfigApplicationList();
        int i = 0;
        while (i < appNameList.size()) {
            ConfigApplication ca = appNameList.elementAt(i);
            if (ca.isActive() && (date = ca.isLocal() ? FortressEnv.getDate(FortressEnv.getSchematicFile(ca.getFileNameWithExtension())) : FortressEnv.getDate(ca.getFile())) > gene_before_sim) {
                gene_before_sim = date;
            }
            ++i;
        }
        String user_parameters_path = FortressEnv.getUserSourcePath();
        date = FortressEnv.getDateOnDirectory(user_parameters_path);
        if (date > gene_before_sim) {
            gene_before_sim = date;
        }
        long compile = 0L;
        if (!middleware_gen) {
            if (FortressEnv.isLinuxOS()) {
                date = FortressEnv.getDate(VariousGeneration.getLinuxCompilationMakeFile(configuration));
                if (date > compile) {
                    compile = date;
                }
            } else {
                date = FortressEnv.getDate(VariousGeneration.getWindowsCompilationBatFile(configuration));
                if (date > compile) {
                    compile = date;
                }
            }
        } else {
            String generated_recosim_main = String.valueOf(FortressEnv.getRecosimApplicationPath(configuration, true)) + "recosim_main.cpp";
            date = FortressEnv.getDate(generated_recosim_main);
            if (date > compile) {
                compile = date;
            }
        }
        long simulate = 0L;
        if (!middleware_gen) {
            if (FortressEnv.isLinuxOS()) {
                date = FortressEnv.getDate(FortressEnv.getLinuxFortressSimulationExecutable(configuration));
                if (date > simulate) {
                    simulate = date;
                }
            } else {
                date = FortressEnv.getDate(FortressEnv.getWindowsFortressSimulationExecutable(configuration));
                if (date > simulate) {
                    simulate = date;
                }
            }
        } else {
            String dir = FortressEnv.getCopyGenerationDirPath(configuration, true);
            String cmd = String.valueOf(File.separator) + "exe" + File.separator + "Recosim";
            date = FortressEnv.getDate(String.valueOf(dir) + cmd);
            if (date > simulate) {
                simulate = date;
            }
        }
        long time = FortressFlow.max(gene_before_sim, compile);
        step = (time = FortressFlow.max(time, simulate)) == gene_before_sim ? FlowStep.GENE_BEFORE_SIM : (time == compile ? (!middleware_gen ? FlowStep.COMPILE : FlowStep.COMPILE_MW) : (!middleware_gen ? FlowStep.SIMULATE : FlowStep.EXECUTE_MW));
        return step;
    }

    private static long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public int viewTrace(String vcd_file) throws Exception {
        return this.viewTrace(vcd_file, false);
    }

    public int viewTrace(String vcd_file, boolean resetLogFile) throws Exception {
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("View Trace  (configuration : " + this.configuration + ")");
        printout.println();
        if (!FortressFlow.isFlowUpdated(this.configuration, this.middleware_gen)) {
            printout.println("!!!!!!!!!!!!!!");
            printout.println("WARNING : View Trace is not updated ! Please, run simulation.");
            printout.println("!!!!!!!!!!!!!!");
            printout.println();
        }
        printout.println("VCD File : " + vcd_file);
        String dir = FortressEnv.getVCDTraceFilePath(this.configuration);
        String[] cmd = new String[2];
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            cmd[0] = FortressEnv.getWindowsViewWaveBatFile(this.configuration);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            cmd[0] = FortressEnv.getLinuxViewWaveScriptFile(this.configuration);
        }
        cmd[1] = vcd_file;
        printout.println("Running " + cmd[0] + " " + cmd[1]);
        int exitValue = -1;
        this.cmdExec = null;
        try {
            try {
                this.cmdExec = new CommandExec(doubleStream, dir, cmd, null);
                this.cmdExec.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                printout.println("Error : " + ex.getMessage());
                if (this.cmdExec != null) {
                    this.cmdExec.close();
                }
                ((OutputStream)ops).close();
                this.cmdExec = null;
            }
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public int viewPlacement(String ucf_file) throws Exception {
        return this.viewPlacement(ucf_file, false);
    }

    public int viewPlacement(String ucf_file, boolean resetLogFile) throws Exception {
        String logFile = FortressEnv.getConfigurationLogFile(this.configuration);
        FileOutputStream ops = new FileOutputStream(logFile, !resetLogFile);
        DoubleOutputStream doubleStream = new DoubleOutputStream(this.console, ops);
        PrintStream printout = new PrintStream(doubleStream);
        printout.println();
        printout.println("*********************************************************");
        printout.println("View Placement  (configuration : " + this.configuration + ")");
        printout.println();
        if (!FortressFlow.isFlowUpdated(this.configuration, this.middleware_gen)) {
            printout.println("!!!!!!!!!!!!!!");
            printout.println("WARNING : View Placement is not updated ! Please, run simulation.");
            printout.println("!!!!!!!!!!!!!!");
            printout.println();
        }
        printout.println("UCF File : " + ucf_file + ".ucf");
        String dir = FortressEnv.getPlacementPath(this.configuration);
        String[] cmd = new String[2];
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            cmd[0] = FortressEnv.getWindowsViewPlacementBatFile(this.configuration);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            cmd[0] = FortressEnv.getLinuxViewPlacementScriptFile(this.configuration);
        }
        cmd[1] = ucf_file;
        printout.println("Running " + cmd[0] + " " + cmd[1]);
        int exitValue = -1;
        this.cmdExec = null;
        try {
            try {
                this.cmdExec = new CommandExec(doubleStream, dir, cmd, null);
                this.cmdExec.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                printout.println("Error : " + ex.getMessage());
                if (this.cmdExec != null) {
                    this.cmdExec.close();
                }
                ((OutputStream)ops).close();
                this.cmdExec = null;
            }
        }
        finally {
            if (this.cmdExec != null) {
                this.cmdExec.close();
            }
            ((OutputStream)ops).close();
            this.cmdExec = null;
        }
        return exitValue;
    }

    public static boolean checkXercesLibraryPath() {
        String envPath = System.getenv("path");
        if (envPath == null) {
            envPath = System.getenv("path");
        }
        if (envPath == null) {
            envPath = System.getenv("PATH");
        }
        if (envPath == null) {
            return false;
        }
        return envPath.contains("xerces");
    }

    public static enum FlowStep {
        GENE_BEFORE_SIM,
        COMPILE,
        SIMULATE,
        GENE_AFTER_SIM,
        RUN_CODE_BLOCK,
        RUN_VISUAL_CPP,
        COMPILE_MW,
        EXECUTE_MW;

    }
}

