/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import fortress.env.FortressConsole;
import fortress.env.LicenseManager;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressProject;
import fortress.xml.FortressSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.jdom.JDOMException;

public class FortressEnv {
    public static final String VERSION_FORTRESS = "1.0";
    public static final String BUILD_VERSION_FORTRESS = "build:2014/06/04";
    public static final String FORTRESS_PATH_ENV = "FORTRESS_PATH";
    public static final String EOL = System.getProperty("line.separator");
    static final String LICENSE_FILE = "fortress.lic";
    static final String PREFERENCES_FILE = "fortress.prj";
    static final String CONFIGURATION_FILE = "configuration.xml";
    static final String CONFIGURATION_LOG_FILE = "transcript.log";
    static final String RECOSIM_LOG_FILE = "solution";
    public static final String RECOSIM_LOG_FILE_EXT = ".log";
    static final String RECOSIM_TRACE_FILE = "solution";
    public static final String RECOSIM_TRACE_FILE_EXT = ".vcd";
    public static final String SOLUTIONS_PATH = "solutions/";
    static final String VIEWWAVE_FILE = "view_wave.bat";
    static final String LINUX_VIEWWAVE_FILE = "view_wave.sh";
    static final String VIEWWAVE_SCRIPT_FILE = "view.do";
    static final String TIMING_EXAMPLES_FILE = "timing_examples.txt";
    public static final String VIEW_PLACEMENT_FILE = "view_placement.bat";
    public static final String LINUX_VIEW_PLACEMENT_FILE = "view_placement.sh";
    public static final String VIEW_PLACEMENT_SCRIPT_FILE_XILINX = "open_placement_view_project_";
    public static final String VIEW_PLACEMENT_SCRIPT_FILE_XILINX_EXT = ".tcl";
    public static final String PLANAHEAD_PLACEMENT_PATH = "placement";
    public static final String APPLICATION_SUMMARY_REPORT_FILE = "application_summary.rpt";
    static final String RECOSIM_RESULT_FILE = "result.txt";
    static final String RECOSIM_CSV_FILE = "solution";
    public static final String RECOSIM_CSV_FILE_EXT = ".csv";
    static final String FINAL_CSV_FILE = "final_solution.csv";
    static final String RECOSIM_WINDOWS_COMPILATION_BAT_FILE = "FoRTReSS_compilation.bat";
    static final String RECOSIM_WINDOWS_RUN_VISUAL_CPP_BAT_FILE = "FoRTReSS_run_visual.bat";
    static final String RECOSIM_MAKEFILE = "Makefile";
    static final String DO_WAVEFORM_FILE = "wave.do";
    static final String NETLIST_LOCAL_PATH = "netlists";
    public static final String NGC_FILE_EXT = ".ngc";
    public static final String EDF_FILE_EXT = ".edf";
    static final String TASK_LOCAL_PATH = "tasks";
    public static final String SYR_FILE_EXT = ".syr";
    public static final String TSK_FILE_EXT = ".tsk";
    static final String SIMULATION_DIR = "simulation";
    static final String MIDDLEWARE_DIR = "middleware";
    static final String CONSTRAINT_DIR = "constraints";
    public static final String CONSTRAINT_RZ_DESCRIPTION_EXTENSION = ".rrd";
    public static final String SCHEMATIC_EXTENSION = ".modulesystem";
    static String FORTRESS_PATH = "";
    static String PROJECT_PATH = "";
    static String RECOSIM_GENERATION_PATH = "recosim";
    public static final String USER_SRC_GEN = "src_gen";
    public static final String USER_TASK_PRIORITY_FILE = "user_task_priority_comparator.h";
    public static final String USER_SCHEDULING_STRATEGY_FILE = "user_scheduling.cpp";
    public static final String USER_MONITORING_MODULE_FILE = "user_monitoring.h";
    public static final String USER_PARAMETERS_HEADER_FILE = "user_parameters.h";
    public static final String USER_PARAMETERS_BODY_FILE = "user_parameters.cpp";
    public static final String USER_IN_TESTBENCH_FILE = "user_in_testbench_algorithms.h";
    public static final String USER_OUT_TESTBENCH_FILE = "user_out_testbench_algorithms.h";
    public static final String USER_MODULE_ALGORITHM_FILE = "user_module_algorithms.h";
    public static final String USER_RZ_DESCRIPTION_FILE = "rz_description.rz";
    static FortressPreferences preferences = null;
    static FortressDeviceLibrary deviceLibrary = null;
    static FortressSystem system = null;
    static DateFormat longDateFormatEN = DateFormat.getDateTimeInstance(1, 1, new Locale("EN", "en"));
    static FortressProject fortressProject;

    static {
        FortressEnv.FirstMessage();
        FortressEnv.initFortressPath();
        FortressEnv.initProjectPath();
        try {
            system = new FortressSystem();
            system.loadFile();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public static String getTitle(String project, String config) {
        if (project.isEmpty()) {
            return "FoRTReSS Tool Box " + FortressEnv.getFortressVersion() + " [" + "No Project" + "]";
        }
        if (config == null) {
            config = "";
        }
        if (config.isEmpty()) {
            return "FoRTReSS Tool Box " + FortressEnv.getFortressVersion() + " [" + project + " - " + "No Config" + "]";
        }
        return "FoRTReSS Tool Box " + FortressEnv.getFortressVersion() + " [" + project + " - " + config + "]";
    }

    public static String getFortressVersion() {
        return VERSION_FORTRESS;
    }

    public static String getFullFortressVersion() {
        return "1.0-build:2014/06/04";
    }

    public static void FirstMessage() {
        System.out.println("*****************************************************************");
        System.out.println("Welcome to FoRTReSS tool !");
        System.out.println("Version " + FortressEnv.getFullFortressVersion() + " - University of Nice-Sophia Antipolis - LEAT/CNRS");
        System.out.print("System: " + FortressEnv.getOS());
        System.out.println();
        System.out.println();
    }

    public static String getOS() {
        String s = FortressEnv.isLinuxOS() ? "Linux" : "Windows";
        s = FortressEnv.is64bitOS() ? String.valueOf(s) + " (64 bits)" : String.valueOf(s) + " (32 bits)";
        return s;
    }

    public static void initFortressPath() {
        FORTRESS_PATH = Platform.getInstallLocation().getURL().getPath();
        preferences = new FortressPreferences();
        try {
            deviceLibrary = new FortressDeviceLibrary();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            System.out.println("Get Licence ...");
            String filename = FortressEnv.getLicenseFile();
            LicenseManager lm = new LicenseManager(filename);
            System.out.println(lm.toString());
            Calendar now = Calendar.getInstance();
            int days = lm.isValidLicence(now.get(1), now.get(2) + 1, now.get(5));
            if (days >= 0) {
                System.out.println(" Valid licence for " + days + " days.");
            } else {
                System.out.println("Error : Invalid licence since " + -days + " days.");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.err.println("No License Found !, Please, copy the licence file (fortress.lic) to " + FORTRESS_PATH + ".");
            System.exit(-1);
        }
    }

    public static void initProjectPath() {
        try {
            fortressProject = new FortressProject();
            String project_path = fortressProject.getCurrentProjectPath();
            if (project_path.isEmpty()) {
                System.out.println("No Current Project.");
                PROJECT_PATH = null;
                return;
            }
            System.out.println("Current Project Path : " + project_path);
            fortressProject.addProjectPath(project_path);
            fortressProject.saveFile();
            FortressEnv.setProjectPath(project_path);
        }
        catch (Exception ex) {
            System.err.println("Error Loading Project Path !");
            System.err.println(ex.getMessage());
        }
    }

    public static void closeApplicationDiagram() {
        IWorkbench iw = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindows = iw.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindows.getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            String name = editors[i].getName();
            if (name.endsWith(".modulesystem_diagram") || name.toUpperCase().endsWith(".modulesystem_diagram")) {
                editors[i].getPage().closeEditor(editors[i].getEditor(false), true);
            }
            ++i;
        }
        FortressConsole.clear();
    }

    public static void openApplicationDiagram() throws IOException, JDOMException {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        pref.loadFile();
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(pref.getActiveConfiguration());
        IWorkbench iw = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindows = iw.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindows.getActivePage();
        Vector<ConfigApplication> activeAppList = conf.getConfigApplicationList();
        int i = 0;
        while (i < activeAppList.size()) {
            ConfigApplication ca = activeAppList.elementAt(i);
            String filename = ca.isLocal() ? FortressEnv.getSchematicFile(ca.getFileNameWithExtension()) : ca.getFile();
            if (new File(filename = String.valueOf(filename) + "_diagram").exists()) {
                URI fileURI = URI.createFileURI((String)filename);
                IEditorDescriptor editorDescriptor = iw.getEditorRegistry().getDefaultEditor(fileURI.toFileString());
                try {
                    page.openEditor((IEditorInput)new URIEditorInput(fileURI), editorDescriptor.getId());
                }
                catch (PartInitException partInitException) {}
            }
            ++i;
        }
        FortressConsole.loadLogFile(pref.getActiveConfiguration());
        workbenchWindows.getShell().setText(FortressEnv.getTitle(new FortressProject().getCurrentProjectPath(), pref.getActiveConfiguration()));
    }

    public static void changeDefaultDirectory(String newPath) {
        System.setProperty("user.dir", newPath);
    }

    public static FortressProject getFortressProjects() {
        return fortressProject;
    }

    public static boolean hasOpenedProject() {
        return PROJECT_PATH != null;
    }

    public static boolean isWindowsOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isLinuxOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean is64bitOS() {
        boolean is64bit = false;
        String os = System.getProperty("sun.arch.data.model", "").toLowerCase();
        is64bit = !os.isEmpty() ? System.getProperty("java.vm.name").toLowerCase().indexOf("64") >= 0 : os.equals("64");
        return is64bit;
    }

    public static String getFortressPath() {
        return FORTRESS_PATH;
    }

    public static String getLicenseFile() {
        return String.valueOf(FortressEnv.getFortressPath()) + LICENSE_FILE;
    }

    public static String getImageFile(String imFile) {
        return String.valueOf(FORTRESS_PATH) + "pictures/" + imFile;
    }

    public static String getFortressCLibraryPath(boolean is64bits) {
        String archi = is64bits ? "x86_64" : "x86";
        File f = new File(String.valueOf(FortressEnv.getTemplatePath()) + "lib" + File.separator + archi + File.separator);
        return f.getAbsolutePath();
    }

    public static String getTutorialHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/tutorial.pdf");
        return f.getAbsolutePath();
    }

    public static String getSchedulerApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_scheduler__interface.html");
        return f.getAbsolutePath();
    }

    public static String getTaskPriorityComparatorSchedulerApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_task__priority__comparator__interface.html");
        return f.getAbsolutePath();
    }

    public static String getTaskToSchedulerApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_task__to__schedule__interface.html");
        return f.getAbsolutePath();
    }

    public static String getAlgorithmApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_user__algorithm__interface.html");
        return f.getAbsolutePath();
    }

    public static String getTestbenchInApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_testbench__in__interface.html");
        return f.getAbsolutePath();
    }

    public static String getTestbenchOutApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_testbench__out__interface.html");
        return f.getAbsolutePath();
    }

    public static String getTestbenchInOutApiHelpFile() {
        File f = new File(String.valueOf(FORTRESS_PATH) + "doc/api/RecoSim/class_testbench__inout__interface.html");
        return f.getAbsolutePath();
    }

    public static String getProjectFile() {
        return String.valueOf(FortressEnv.getFortressPath()) + "fortress_project.xml";
    }

    public static String getSystemFile() {
        return String.valueOf(FortressEnv.getFortressPath()) + "fortress_system.xml";
    }

    public static FortressSystem getFortressSystem() {
        return system;
    }

    public static String getTemplatePath() {
        return String.valueOf(FortressEnv.getFortressPath()) + "templates" + File.separator;
    }

    public static String getDeviceLibraryPath() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "devices" + File.separator;
    }

    public static String getTemplateGenerationDirPath(boolean middleware_gen) {
        if (middleware_gen) {
            return String.valueOf(FortressEnv.getTemplatePath()) + MIDDLEWARE_DIR + File.separator;
        }
        return String.valueOf(FortressEnv.getTemplatePath()) + SIMULATION_DIR + File.separator;
    }

    public static String getTemplatePreferenceFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "template_preferences.xml";
    }

    public static String getDefaultConfigurationFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "default_configuration.xml";
    }

    public static String getDefaultProjectFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "default_project.xml";
    }

    public static String getWindowsCompilationBatFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "cpp" + File.separator + RECOSIM_WINDOWS_COMPILATION_BAT_FILE;
    }

    public static String getWindowsRunVisualCppBatFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "cpp" + File.separator + RECOSIM_WINDOWS_RUN_VISUAL_CPP_BAT_FILE;
    }

    public static String getWindowsTemplateViewWaveBatFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + VIEWWAVE_FILE;
    }

    public static String getLinuxTemplateViewWaveScriptFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + LINUX_VIEWWAVE_FILE;
    }

    public static String getSolutionsPath(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + SOLUTIONS_PATH;
    }

    public static String getWindowsViewWaveBatFile(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + SOLUTIONS_PATH + VIEWWAVE_FILE;
    }

    public static String getLinuxViewWaveScriptFile(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + SOLUTIONS_PATH + LINUX_VIEWWAVE_FILE;
    }

    public static String getTemplateViewWaveScriptFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + VIEWWAVE_SCRIPT_FILE;
    }

    public static String getTimingExamplesFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + TIMING_EXAMPLES_FILE;
    }

    public static String getViewWaveScriptFile(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + SOLUTIONS_PATH + VIEWWAVE_SCRIPT_FILE;
    }

    public static String getApplicationSummaryReportFile(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + APPLICATION_SUMMARY_REPORT_FILE;
    }

    public static String getPDFSimplifiedTrace(String configuration, String solution) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH + File.separator + solution + "_trace.pdf";
    }

    public static String getTemplateNgcFile(String category) {
        return "top_" + category + NGC_FILE_EXT;
    }

    public static String getTemplatePlacementNgcFile(String category) {
        return String.valueOf(FortressEnv.getTemplatePath()) + PLANAHEAD_PLACEMENT_PATH + "/" + FortressEnv.getTemplateNgcFile(category);
    }

    public static String getPlacementNgcFile(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/top.ngc";
    }

    public static String getPlacementPath(String configuration) {
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/";
    }

    public static String getWindowsTemplateViewPlacementBatFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + PLANAHEAD_PLACEMENT_PATH + "/" + VIEW_PLACEMENT_FILE;
    }

    public static String getLinuxTemplateViewPlacementScriptFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + PLANAHEAD_PLACEMENT_PATH + "/" + LINUX_VIEW_PLACEMENT_FILE;
    }

    public static String getWindowsViewPlacementBatFile(String configuration) {
        FortressEnv.CreateDirectory(String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/");
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/" + VIEW_PLACEMENT_FILE;
    }

    public static String getLinuxViewPlacementScriptFile(String configuration) {
        FortressEnv.CreateDirectory(String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/");
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/" + LINUX_VIEW_PLACEMENT_FILE;
    }

    public static String getViewPlacementScriptFile(String version) {
        return VIEW_PLACEMENT_SCRIPT_FILE_XILINX + version + VIEW_PLACEMENT_SCRIPT_FILE_XILINX_EXT;
    }

    public static String getTemplateViewPlacementScriptFile(String version) {
        return String.valueOf(FortressEnv.getTemplatePath()) + PLANAHEAD_PLACEMENT_PATH + "/" + FortressEnv.getViewPlacementScriptFile(version);
    }

    public static String getViewPlacementScriptFile(String configuration, String version) {
        FortressEnv.CreateDirectory(String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/");
        return String.valueOf(FortressEnv.getConfigurationPath(configuration)) + PLANAHEAD_PLACEMENT_PATH + "/" + FortressEnv.getViewPlacementScriptFile(version);
    }

    public static String getRelativeUcfViewPlacementFile() {
        return "../solutions/";
    }

    public static String getCompilationMakefile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "cpp" + File.separator + RECOSIM_MAKEFILE;
    }

    public static String getTemplateDoWave() {
        return String.valueOf(FortressEnv.getTemplatePath()) + DO_WAVEFORM_FILE;
    }

    public static void setProjectPath(String path) {
        PROJECT_PATH = String.valueOf(path) + File.separator;
        FortressEnv.changeDefaultDirectory(PROJECT_PATH);
    }

    public static String getProjectPath() {
        return PROJECT_PATH;
    }

    public static String getPreferencesFile() {
        return String.valueOf(FortressEnv.getProjectPath()) + PREFERENCES_FILE;
    }

    public static String getConfigurationLogFile(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + CONFIGURATION_LOG_FILE;
    }

    public static String getFortressRunningSimulationPath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator;
    }

    public static String getWindowsFortressSimulationExecutablePath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + "exe" + File.separator;
    }

    public static String getWindowsFortressSimulationExecutable(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + "exe" + File.separator + "FoRTReSS.exe";
    }

    public static String getLinuxFortressSimulationExecutable(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + "exe" + File.separator + "FoRTReSS";
    }

    public static String getSchematicFile(String filename) {
        return String.valueOf(FortressEnv.getProjectPath()) + filename;
    }

    public static String getNetlistPath() {
        return String.valueOf(FortressEnv.getProjectPath()) + NETLIST_LOCAL_PATH + File.separator;
    }

    public static String getNetlistRelativePath() {
        return "../../../netlists/";
    }

    public static String getTaskReportPath() {
        String path = String.valueOf(FortressEnv.getProjectPath()) + TASK_LOCAL_PATH + File.separator;
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        return String.valueOf(FortressEnv.getProjectPath()) + TASK_LOCAL_PATH + File.separator;
    }

    public static String getTaskReportRelativePath() {
        return "../../../tasks/";
    }

    public static boolean isExistFile(String filepath) {
        File f = new File(filepath);
        return f.exists();
    }

    public static String getConfigurationPath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator;
    }

    public static String getConfigurationFile(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + CONFIGURATION_FILE;
    }

    public static String getCopyGenerationDirPath(String configuration, boolean middleware_gen) {
        if (middleware_gen) {
            return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + MIDDLEWARE_DIR;
        }
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR;
    }

    public static String getConstraintsPath() {
        return String.valueOf(FortressEnv.getProjectPath()) + CONSTRAINT_DIR;
    }

    public static String getConstraintsRelativePath() {
        return "../../../constraints/";
    }

    public static String getVCDTraceFilePath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static String getCSVFilePath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static String getStatisticReportFilePath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static String getStatisticReportFile(String configuration, String csvName) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH + csvName + "_statistics.rpt";
    }

    public static String getLatexTraceReportFile(String configuration, String csvName) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH + File.separator + csvName + "_trace.tex";
    }

    public static String getLogReportFile(String configuration, String csvName) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH + File.separator + csvName + RECOSIM_LOG_FILE_EXT;
    }

    public static String getUCFFilePath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static String getRelativeRecosimLogFile(String configuration) {
        return "../../solutions/solution.log";
    }

    public static String getRelativeRecosimLogFileWithoutExtension() {
        return "../../solutions/solution";
    }

    public static String getRelativeRecosimTraceFile() {
        return "../../solutions/solution.vcd";
    }

    public static String getRelativeRecosimTraceFileWithoutExtension() {
        return "../../solutions/solution";
    }

    public static String getRelativeRecosimResultFile() {
        return "../../solutions/result.txt";
    }

    public static String getRelativeRecosimCSVFile() {
        return "../../solutions/solution.csv";
    }

    public static String getRelativeRecosimCSVFileWithoutExtension() {
        return "../../solutions/solution";
    }

    public static String getResultFortressSimulationRelativePath() {
        return "../../solutions/";
    }

    public static String getResultFortressSimulationPath(String configuration) {
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static boolean createConfigurationPath(String configuration) {
        return new File(String.valueOf(FortressEnv.getProjectPath()) + configuration).mkdir();
    }

    public static FortressPreferences getFortressPreferences() {
        return preferences;
    }

    public static FortressDeviceLibrary getFortressDeviceLibrary() {
        return deviceLibrary;
    }

    public static String getTemplateCppPath() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "cpp" + File.separator;
    }

    public static String getHeaderDeviceTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "device.h";
    }

    public static String getHeaderRZConfigTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "rz_config.h";
    }

    public static String getFortressParametersTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "fortress_parameters.cpp";
    }

    public static String getRecosimParametersTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "recosim_parameters.cpp";
    }

    public static String getUserSchedulingHeaderTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "user_scheduling.h";
    }

    public static String getUserSchedulingBodyTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "waiting_queue_handler.cpp";
    }

    public static String getUserTestBenchAlgoTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "user_testbench_algorithms.h";
    }

    public static String getUserModuleAlgoTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + USER_MODULE_ALGORITHM_FILE;
    }

    public static String getFortressMainTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "fortress_main.cpp";
    }

    public static String getRecosimMainTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "recosim_main.cpp";
    }

    public static String getMiddlewareRecosimMainTemplateFile() {
        return String.valueOf(FortressEnv.getTemplateCppPath()) + "middleware_recosim_main.cpp";
    }

    public static String getHeaderDevicePath(String configuration) {
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + USER_SRC_GEN).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + USER_SRC_GEN + File.separator;
    }

    public static String getHeaderRZConfigPath(String configuration) {
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "RecoSim" + File.separator + USER_SRC_GEN).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "RecoSim" + File.separator + USER_SRC_GEN + File.separator;
    }

    public static String getFortressApplicationPath(String configuration) {
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + USER_SRC_GEN).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "FoRTReSS" + File.separator + USER_SRC_GEN + File.separator;
    }

    public static String getRecosimApplicationPath(String configuration, boolean middleware_gen) {
        if (middleware_gen) {
            new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + MIDDLEWARE_DIR + File.separator + USER_SRC_GEN).mkdirs();
            return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + MIDDLEWARE_DIR + File.separator + USER_SRC_GEN + File.separator;
        }
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "RecoSim" + File.separator + USER_SRC_GEN).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator + "RecoSim" + File.separator + USER_SRC_GEN + File.separator;
    }

    public static String getScriptCompilationFilePath(String configuration) {
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SIMULATION_DIR + File.separator;
    }

    public static String getWaveFilePath(String configuration) {
        new File(String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH).mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + configuration + File.separator + SOLUTIONS_PATH;
    }

    public static String today() {
        return longDateFormatEN.format(new Date());
    }

    public static String getLaboratory() {
        return "University of Nice-Sophia Antipolis - LEAT/CNRS";
    }

    public static Vector<String> getLocalSchematicFileList() throws IOException {
        Vector<String> xmllist = new Vector<String>();
        String path = FortressEnv.getProjectPath();
        File dir = new File(path);
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            if (!list[i].isDirectory() && list[i].getName().endsWith(SCHEMATIC_EXTENSION)) {
                xmllist.add(list[i].getName());
            }
            ++i;
        }
        return xmllist;
    }

    public static Vector<String> getLocalSchematicFileListWithoutExtension() throws IOException {
        Vector<String> xmlextlist = FortressEnv.getLocalSchematicFileList();
        Vector<String> xmllist = new Vector<String>(xmlextlist.size());
        int i = 0;
        while (i < xmlextlist.size()) {
            String s = xmlextlist.elementAt(i);
            xmllist.add(s.substring(0, s.indexOf(SCHEMATIC_EXTENSION)));
            ++i;
        }
        return xmllist;
    }

    public static boolean FileCopy(File Source, File Destination) {
        return FortressEnv.FileCopy(Source, Destination, true);
    }

    public static boolean FileCopy(File Source, File Destination, boolean overwrite) {
        boolean resultat = false;
        if (!overwrite && Destination.exists()) {
            return resultat;
        }
        FileInputStream filesource = null;
        FileOutputStream fileDestination = null;
        try {
            try {
                int nblecture;
                fileDestination = new FileOutputStream(Destination);
                filesource = new FileInputStream(Source);
                byte[] buffer = new byte[524288];
                while ((nblecture = filesource.read(buffer)) != -1) {
                    fileDestination.write(buffer, 0, nblecture);
                }
                Destination.setExecutable(Source.canExecute());
                Destination.setReadable(Source.canRead());
                Destination.setWritable(Source.canWrite());
                resultat = true;
            }
            catch (FileNotFoundException nf) {
                nf.printStackTrace();
                try {
                    filesource.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    fileDestination.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                try {
                    filesource.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    fileDestination.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                filesource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                fileDestination.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultat;
    }

    public static boolean importTaskFile(String srcPathFile) throws IOException {
        int k = srcPathFile.lastIndexOf(File.separator);
        String fdest = k == -1 ? srcPathFile : srcPathFile.substring(k + 1);
        String destFile = String.valueOf(FortressEnv.getTaskReportPath()) + fdest;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            throw new IOException("File " + fdest + " already exists in project !");
        }
        return FortressEnv.FileCopy(new File(srcPathFile), Filedest);
    }

    public static boolean importSchematicFile(String srcPathFile) throws IOException {
        int k = srcPathFile.lastIndexOf(File.separator);
        String fdest = k == -1 ? srcPathFile : srcPathFile.substring(k + 1);
        String destFile = String.valueOf(FortressEnv.getNetlistPath()) + fdest;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            throw new IOException("File " + fdest + " already exists in project !");
        }
        return FortressEnv.FileCopy(new File(srcPathFile), Filedest);
    }

    public static boolean removeSchematicFile(String filename) throws IOException {
        String destFile = String.valueOf(FortressEnv.getProjectPath()) + filename;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            return Filedest.delete();
        }
        return false;
    }

    public static boolean importNetlistFile(String srcPathFile) throws IOException {
        int k = srcPathFile.lastIndexOf(File.separator);
        String fdest = k == -1 ? srcPathFile : srcPathFile.substring(k + 1);
        String destFile = String.valueOf(FortressEnv.getNetlistPath()) + fdest;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            throw new IOException("File " + fdest + " already exists in project !");
        }
        return FortressEnv.FileCopy(new File(srcPathFile), Filedest);
    }

    public static boolean removeNetlistFile(String filename) throws IOException {
        String destFile = String.valueOf(FortressEnv.getNetlistPath()) + filename;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            return Filedest.delete();
        }
        return false;
    }

    public static boolean importSysthesisReportFile(String srcPathFile) throws IOException {
        int k = srcPathFile.lastIndexOf(File.separator);
        String fdest = k == -1 ? srcPathFile : srcPathFile.substring(k + 1);
        String destFile = String.valueOf(FortressEnv.getNetlistPath()) + fdest;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            throw new IOException("File " + fdest + " already exists in project !");
        }
        return FortressEnv.FileCopy(new File(srcPathFile), Filedest);
    }

    public static boolean removeTaskReportFile(String filename) throws IOException {
        String destFile = String.valueOf(FortressEnv.getTaskReportPath()) + filename;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            return Filedest.delete();
        }
        return false;
    }

    public static boolean importConstraintFile(String srcPathFile) throws IOException {
        int k = srcPathFile.lastIndexOf(File.separator);
        String fdest = k == -1 ? srcPathFile : srcPathFile.substring(k + 1);
        String destFile = String.valueOf(FortressEnv.getConstraintsPath()) + File.separator + fdest;
        File Filedest = new File(destFile);
        if (Filedest.exists()) {
            throw new IOException("File " + fdest + " already exists in project !");
        }
        return FortressEnv.FileCopy(new File(srcPathFile), Filedest);
    }

    public static String transformToIdWithPath(String name) {
        String ext;
        String path;
        String filename;
        int k = (name = FortressEnv.convertPathForOS(name)).lastIndexOf(File.separator);
        if (k == -1) {
            filename = name;
            path = "";
        } else {
            filename = name.substring(k + 1);
            path = name.substring(0, k + 1);
        }
        k = filename.lastIndexOf(46);
        if (k == -1) {
            ext = "";
        } else {
            ext = filename.substring(k);
            filename = filename.substring(0, k);
        }
        filename = FortressEnv.transformToId(filename);
        return String.valueOf(path) + filename + ext;
    }

    public static String transformToId(String name) {
        String id = name;
        id = id.replace(' ', '_');
        id = id.replace('.', '_');
        id = id.replace('-', '_');
        id = id.replace('\'', '_');
        id = id.replace('\"', '_');
        id = id.replace('\ufffd', '_');
        id = id.replace('&', '_');
        id = id.replace(',', '_');
        id = id.replace(';', '_');
        id = id.replace(':', '_');
        id = id.replace('/', '_');
        id = id.replace('\\', '_');
        id = id.replace('\ufffd', 'e');
        id = id.replace('\ufffd', 'e');
        id = id.replace('\ufffd', 'e');
        id = id.replace('\ufffd', 'e');
        id = id.replace('\ufffd', 'a');
        id = id.replace('\ufffd', 'i');
        id = id.replace('\ufffd', 'u');
        id = id.replace('\ufffd', 'u');
        id = id.replace('\ufffd', 'c');
        return id;
    }

    public static boolean CreateDirectory(String destinationPath) {
        File f = new File(destinationPath);
        if (!f.exists()) {
            f.mkdirs();
            return true;
        }
        return false;
    }

    public static boolean DirectoryCopy(File sourcePath, String destinationPath) throws IOException {
        if (sourcePath.isDirectory()) {
            File dest = new File(destinationPath);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            File[] list = sourcePath.listFiles();
            int i = 0;
            while (i < list.length) {
                String newDest = String.valueOf(destinationPath) + File.separator + list[i].getName();
                boolean result = FortressEnv.DirectoryCopy(list[i], newDest);
                if (!result) {
                    return false;
                }
                ++i;
            }
        } else {
            File dest = new File(destinationPath);
            return FortressEnv.FileCopy(sourcePath, dest);
        }
        return true;
    }

    public static Vector<String> getFileListWithoutExtension(String path, String ext) throws IOException {
        Vector<String> filelist = new Vector<String>();
        File dir = new File(path);
        File[] list = dir.listFiles();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                String s = list[i].getName();
                if (!list[i].isDirectory()) {
                    if (s.endsWith(ext.toUpperCase())) {
                        filelist.add(s.substring(0, s.lastIndexOf(ext.toUpperCase())));
                    } else if (s.endsWith(ext.toLowerCase())) {
                        filelist.add(s.substring(0, s.lastIndexOf(ext.toLowerCase())));
                    }
                }
                ++i;
            }
        }
        return filelist;
    }

    public static void createProject() {
        new File(FortressEnv.getProjectPath()).mkdir();
        new File(String.valueOf(FortressEnv.getProjectPath()) + File.separator + "synthesis").mkdir();
        new File(String.valueOf(FortressEnv.getProjectPath()) + File.separator + NETLIST_LOCAL_PATH).mkdir();
        new File(String.valueOf(FortressEnv.getProjectPath()) + File.separator + "src").mkdir();
    }

    public static long getDate(String path) {
        File f = new File(path);
        return f.lastModified();
    }

    public static long getDateOnDirectory(String path) {
        return FortressEnv.getDateOnDirectory(0L, new File(path));
    }

    private static long getDateOnDirectory(long date, File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                long datedir = FortressEnv.getDateOnDirectory(date, new File(dir, children[i]));
                if (date < datedir) {
                    date = datedir;
                }
                ++i;
            }
        } else if (date < dir.lastModified()) {
            date = dir.lastModified();
        }
        return date;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FortressEnv.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String path) {
        File f = new File(path);
        return f.delete();
    }

    public static void readTextFile(String pathfile, OutputStream console) throws FileNotFoundException, IOException {
        String read_line;
        PrintStream out = new PrintStream(console);
        FileInputStream ips = new FileInputStream(pathfile);
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((read_line = br.readLine()) != null) {
            out.println(read_line);
        }
        br.close();
    }

    public static String readTextFile(String pathfile) throws FileNotFoundException, IOException {
        String read_line;
        String buf = "";
        FileInputStream ips = new FileInputStream(pathfile);
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((read_line = br.readLine()) != null) {
            buf = String.valueOf(buf) + read_line + EOL;
        }
        br.close();
        return buf;
    }

    public static String convertPathForOS(String name) {
        if (FortressEnv.isWindowsOS()) {
            return name.replace("/", "\\");
        }
        return name.replace("\\", "/");
    }

    public static String convertPathForLinux(String name) {
        return name.replace("\\", "/");
    }

    public static void openTextEditor(String absfilename) throws IOException, JDOMException {
        preferences.loadReadOnlyFile();
        String editPath = preferences.getTextEditorPath();
        if (editPath == null) {
            JOptionPane.showMessageDialog(null, "Editor not found ! Please, open preference menu and select an editor.", "Editor Error", 0);
        }
        if (editPath.trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Editor not found ! Please, open preference menu and select an editor.", "Editor Error", 0);
        }
        int index = editPath.lastIndexOf(File.separator);
        String dir = editPath.substring(0, index);
        String[] cmd = new String[]{editPath, absfilename};
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        pb.directory(new File(dir));
        pb.start();
    }

    public static String extractFilenameWithoutExtension(String pathFile) {
        int k = FortressEnv.convertPathForOS(pathFile).lastIndexOf(File.separator);
        String fdest = k == -1 ? pathFile : pathFile.substring(k + 1);
        k = fdest.lastIndexOf(46);
        if (k != -1) {
            fdest = fdest.substring(0, k);
        }
        return fdest;
    }

    public static boolean isSYRExtension(String s) {
        return s.endsWith(SYR_FILE_EXT) || s.endsWith(SYR_FILE_EXT.toUpperCase());
    }

    public static String getTemplateUserTaskPriorityFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_TASK_PRIORITY_FILE;
    }

    public static String getUserTaskPriorityFile() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + USER_TASK_PRIORITY_FILE;
    }

    public static String getTemplateUserSchedulingStrategyFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_SCHEDULING_STRATEGY_FILE;
    }

    public static String getTemplateUserMonitoringModuleFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_MONITORING_MODULE_FILE;
    }

    public static String getUserSchedulingStrategyFile() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + USER_SCHEDULING_STRATEGY_FILE;
    }

    public static String getUserMonitoringModuleFile() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + USER_MONITORING_MODULE_FILE;
    }

    public static String getTemplateUserParametersHeaderFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_PARAMETERS_HEADER_FILE;
    }

    public static String getUserUserParametersHeaderFile() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + USER_PARAMETERS_HEADER_FILE;
    }

    public static String getTemplateUserParametersBodyFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_PARAMETERS_BODY_FILE;
    }

    public static String getUserUserParametersBodyFile() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + USER_PARAMETERS_BODY_FILE;
    }

    public static String getTemplateUserInTestbenchFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_IN_TESTBENCH_FILE;
    }

    public static String getTemplateUserOutTestbenchFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_OUT_TESTBENCH_FILE;
    }

    public static String getTemplateUserAlgorithmsFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_MODULE_ALGORITHM_FILE;
    }

    public static String getTemplateUserRZDescriptionFile() {
        return String.valueOf(FortressEnv.getTemplatePath()) + "user_files" + File.separator + USER_RZ_DESCRIPTION_FILE;
    }

    public static String getUserSourcePath() {
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + "/";
    }

    public static String getUserBenchesSourcePath() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + "benches").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + "benches" + File.separator;
    }

    public static String getUserAlgorithmsSourcePath() {
        new File(String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + "algorithms").mkdirs();
        return String.valueOf(FortressEnv.getProjectPath()) + "src" + File.separator + "algorithms" + File.separator;
    }

    public static void saveFile(String filename, String buffer) throws Exception {
        FileOutputStream ops = new FileOutputStream(filename);
        OutputStreamWriter opsw = new OutputStreamWriter(ops);
        opsw.write(buffer);
        opsw.close();
    }

    public static Vector<NetworkInterface> getNetworkInterfaceList() throws SocketException {
        Vector<NetworkInterface> niList = new Vector<NetworkInterface>();
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        while (nets.hasMoreElements()) {
            NetworkInterface netint = nets.nextElement();
            byte[] mac_ref = netint.getHardwareAddress();
            if (mac_ref == null || mac_ref.length == 0 || FortressEnv.isMacExist(niList, netint)) continue;
            niList.addElement(netint);
        }
        return niList;
    }

    public static boolean isMacExist(Vector<NetworkInterface> niList, NetworkInterface netint) throws SocketException {
        boolean found = false;
        byte[] mac_ref = netint.getHardwareAddress();
        int i = 0;
        while (i < niList.size()) {
            byte[] mac = niList.elementAt(i).getHardwareAddress();
            if (mac.length == mac_ref.length) {
                found = true;
                int j = 0;
                while (j < mac_ref.length) {
                    if (mac_ref[j] != mac[j]) {
                        found = false;
                    }
                    ++j;
                }
            }
            if (found) break;
            ++i;
        }
        return found;
    }

    public static Vector<String> getRZsetFileSolution(String configuration) {
        Vector<String> list = new Vector<String>();
        String rzSetPath = FortressEnv.getFortressRunningSimulationPath(configuration);
        File rzSetPathFile = new File(rzSetPath);
        File[] files = rzSetPathFile.listFiles();
        if (files == null) {
            return list;
        }
        int i = 0;
        while (i < files.length) {
            String file = files[i].getName();
            if (file.startsWith("RZset_")) {
                list.add(file);
            }
            ++i;
        }
        return list;
    }
}

