/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ViewTrace;

import Modulesystem.diagram.commands.InputDialog;
import fortress.env.ConsoleCommandExecListener;
import fortress.env.DoubleOutputStream;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.env.FortressFlow;
import fortress.xml.FortressPreferences;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class ViewTraceCurrentConfigHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            Vector<String> v;
            Display display;
            String configuration;
            block5: {
                try {
                    FortressPreferences pref = FortressEnv.getFortressPreferences();
                    pref.loadFile();
                    configuration = pref.getActiveConfiguration();
                    String vcdPath = FortressEnv.getCSVFilePath(configuration);
                    display = PlatformUI.createDisplay();
                    v = FortressEnv.getFileListWithoutExtension(vcdPath, ".vcd");
                    if (v.size() != 0) break block5;
                    JOptionPane.showMessageDialog(null, "No solution found ! Please, simulate this configuration.", null, 1);
                    return null;
                }
                catch (Exception exception) {}
            }
            InputDialog inputDiag = new InputDialog(display, "View Full Trace (ModelSim)", "Select a Solution", v.toArray());
            String vcdFile = (String)inputDiag.open();
            if (vcdFile == null) break block6;
            MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
            DoubleOutputStream doubleStream = new DoubleOutputStream((OutputStream)console, null);
            PrintStream out = new PrintStream(doubleStream);
            FortressFlow flow = FortressFlow.createFortressFlow(configuration, (OutputStream)console, false);
            flow.setCommandExecListener(new ConsoleCommandExecListener(console));
            try {
                out.println("Open Modelsim ...");
                flow.viewTrace(vcdFile);
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage());
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return pref.hasActiveConfiguration() && FortressEnv.hasOpenedProject() && !pref.getModelsimPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

