/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.xml.ConfigProcessorName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProcessorInputDialog
extends JDialog
implements ActionListener {
    JTextField proc_name_textField;
    JFormattedTextField static_power_textField;
    JFormattedTextField idle_power_textField;
    JFormattedTextField run_power_textField;
    JButton okButton;
    JButton cancelButton;
    boolean cancelAction;
    ConfigProcessorName configProcessorName;

    public ProcessorInputDialog(Frame WindowsParameters, String title) {
        super(WindowsParameters, title, true);
        this.createDialog(WindowsParameters);
    }

    public ProcessorInputDialog(Frame WindowsParameters, String title, ConfigProcessorName configProcessorName) {
        super(WindowsParameters, title, true);
        this.createDialog(WindowsParameters);
        this.proc_name_textField.setText(configProcessorName.getProcessorName());
        this.static_power_textField.setValue(Float.valueOf(configProcessorName.getStaticPowerCoeff()));
        this.idle_power_textField.setValue(Float.valueOf(configProcessorName.getIdlePowerCoeff()));
        this.run_power_textField.setValue(Float.valueOf(configProcessorName.getRunPowerCoeff()));
    }

    public void createDialog(Frame WindowsParameters) {
        this.cancelAction = true;
        Point p = WindowsParameters.getLocation();
        this.setLocation(p.x + 200, p.y + 200);
        this.setResizable(false);
        JPanel proc_type_panel = new JPanel();
        FlowLayout info_panel_layout = new FlowLayout(0);
        proc_type_panel.setLayout(info_panel_layout);
        JLabel info = new JLabel();
        info.setText("Processor Type : ");
        info.setPreferredSize(new Dimension(130, 20));
        proc_type_panel.add(info);
        this.proc_name_textField = new JTextField("");
        this.proc_name_textField.setPreferredSize(new Dimension(150, 20));
        proc_type_panel.add(this.proc_name_textField);
        JPanel static_power_panel = new JPanel();
        FlowLayout static_power_layout = new FlowLayout(0);
        static_power_panel.setLayout(static_power_layout);
        info = new JLabel();
        info.setText("Static Power Coeff : ");
        info.setPreferredSize(new Dimension(130, 20));
        static_power_panel.add(info);
        this.static_power_textField = new JFormattedTextField(new Float(0.0f));
        this.static_power_textField.setPreferredSize(new Dimension(80, 20));
        static_power_panel.add(this.static_power_textField);
        JPanel idle_power_panel = new JPanel();
        FlowLayout idle_power_layout = new FlowLayout(0);
        idle_power_panel.setLayout(idle_power_layout);
        info = new JLabel();
        info.setText("Idle Power Coeff : ");
        info.setPreferredSize(new Dimension(130, 20));
        idle_power_panel.add(info);
        this.idle_power_textField = new JFormattedTextField(new Float(0.0f));
        this.idle_power_textField.setPreferredSize(new Dimension(80, 20));
        idle_power_panel.add(this.idle_power_textField);
        JPanel run_power_panel = new JPanel();
        FlowLayout run_power_layout = new FlowLayout(0);
        run_power_panel.setLayout(run_power_layout);
        info = new JLabel();
        info.setText("Run Power Coeff : ");
        info.setPreferredSize(new Dimension(130, 20));
        run_power_panel.add(info);
        this.run_power_textField = new JFormattedTextField(new Float(0.0f));
        this.run_power_textField.setPreferredSize(new Dimension(80, 20));
        run_power_panel.add(this.run_power_textField);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel button_panel = new JPanel();
        GridLayout button_panel_layout = new GridLayout(1, 0);
        button_panel_layout.setHgap(10);
        button_panel.setLayout(button_panel_layout);
        button_panel.add(this.cancelButton);
        button_panel.add(this.okButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraintLayout = new GridBagConstraints();
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 0;
        JPanel page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(proc_type_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 1;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(static_power_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 2;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(idle_power_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 3;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(run_power_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 4;
        JPanel page_end_panel = new JPanel();
        page_end_panel.setLayout(new FlowLayout(2));
        page_end_panel.add(button_panel);
        this.add((Component)page_end_panel, constraintLayout);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.configProcessorName = new ConfigProcessorName(this.proc_name_textField.getText().trim());
            this.configProcessorName.setStaticPowerCoeff(((Float)this.static_power_textField.getValue()).floatValue());
            this.configProcessorName.setIdlePowerCoeff(((Float)this.idle_power_textField.getValue()).floatValue());
            this.configProcessorName.setRunPowerCoeff(((Float)this.run_power_textField.getValue()).floatValue());
            this.cancelAction = false;
            this.dispose();
        } else if (event.getSource() == this.cancelButton) {
            this.cancelAction = true;
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this.cancelAction;
    }

    public ConfigProcessorName getConfigProcessorName() {
        return this.configProcessorName;
    }
}

