/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressProject;
import java.io.File;
import javax.swing.JOptionPane;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class InputDialogNewProject
extends Dialog {
    public InputDialogNewProject(Display display, String title) {
        this(display, 67680, title);
    }

    public InputDialogNewProject(Display display, int style, String title) {
        super(new Shell(display), style);
        this.setText(title);
    }

    public void open() {
        final Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText("New Project");
        Composite composite = new Composite((Composite)shell, 2048);
        composite.setBounds(0, 0, 390, 170);
        Label ProjectLocation_label = new Label(composite, 0);
        Label ProjectName_label = new Label(composite, 0);
        ProjectName_label.setText("Project Name: ");
        ProjectName_label.setBounds(10, 10, 200, 20);
        final Text ProjectName = new Text(composite, 2048);
        ProjectName.setBounds(10, 35, 370, 25);
        ProjectLocation_label.setText("Project Location : ");
        ProjectLocation_label.setBounds(10, 65, 200, 20);
        final Text ProjectLocation = new Text(composite, 2048);
        ProjectLocation.setBounds(10, 93, 280, 25);
        Button Browse = new Button(composite, 0);
        Browse.setText("Browse");
        Browse.setBounds(310, 90, 70, 30);
        Button ok = new Button(composite, 0);
        ok.setText("OK");
        ok.setBounds(235, 130, 70, 30);
        Button cancel = new Button(composite, 8);
        cancel.setText("Cancel");
        cancel.setBounds(310, 130, 70, 30);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!ProjectLocation.getText().isEmpty() && !ProjectName.getText().isEmpty()) {
                    MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                    try {
                        FortressEnv.closeApplicationDiagram();
                        FortressProject fp = new FortressProject();
                        String project_path = String.valueOf(ProjectLocation.getText()) + File.separator + ProjectName.getText();
                        if (project_path.isEmpty()) {
                            console.println("Error: Select a current path !");
                            return;
                        }
                        console.println("Current Project Path : " + project_path);
                        fp.addProjectPath(project_path);
                        FortressEnv.setProjectPath(project_path);
                        FortressEnv.createProject();
                        fp.saveFile();
                        FortressPreferences pref = null;
                        pref = FortressEnv.getFortressPreferences();
                        pref.loadFile();
                        pref.saveFile();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    IWorkbenchWindow Windows = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    Windows.getShell().setText(FortressEnv.getTitle(ProjectLocation.getText(), ""));
                    shell.close();
                } else if (ProjectName.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(null, "You did not enter a Project name.", null, 1);
                } else {
                    JOptionPane.showMessageDialog(null, "You did not enter a Project location.", null, 1);
                }
            }
        });
        Browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog fDial = new DirectoryDialog(shell, 4096);
                fDial.setText("Select Project Location");
                fDial.open();
                if (!fDial.getFilterPath().isEmpty()) {
                    ProjectLocation.setText(fDial.getFilterPath());
                }
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.pack();
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = shell.getSize();
        shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

