/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InputDialog
extends Dialog {
    private String message;
    private Object selectedValue;
    private Object[] values;

    public InputDialog(Display display, String title, String message, Object[] values) {
        this(display, 67680, title, message, values);
    }

    public InputDialog(Display display, int style, String title, String message, Object[] values) {
        super(new Shell(display), style);
        this.message = message;
        this.values = values;
        this.setText(title);
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public Object open() {
        return this.open(null);
    }

    public Object open(Object defaultSelectedValue) {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        shell.setSize(200, 110);
        this.createContents(shell, defaultSelectedValue);
        shell.pack();
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = shell.getSize();
        shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selectedValue;
    }

    private void createContents(final Shell shell, Object defaultSelectedValue) {
        shell.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label((Composite)shell, 0);
        label.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        final Combo combo = new Combo((Composite)shell, 2572);
        int defaultSelectedIndex = 0;
        int i = 0;
        while (i < this.values.length) {
            String val = this.values[i].toString();
            combo.add(val);
            if (defaultSelectedValue != null && val.equals(defaultSelectedValue.toString())) {
                defaultSelectedIndex = i;
            }
            ++i;
        }
        combo.select(defaultSelectedIndex);
        data = new GridData(768);
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        Button ok = new Button((Composite)shell, 8);
        ok.setText("OK");
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog.this.selectedValue = InputDialog.this.values[combo.getSelectionIndex()];
                shell.close();
            }
        });
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText("Cancel");
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog.this.selectedValue = null;
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }
}

