/**
 * @file	user_parameters.cpp
 * @author  XXX
 * @version 1.0
 * @date	XXX
 *
 * @section DESCRIPTION
 *
 * User defined parameters.
 */

#include "user_parameters.h"
 
#ifdef RECOSIM_PART
#include <systemc.h>
#endif


/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/



My_Simulation_states tasks_execution_time = WCET;
#ifdef RECOSIM_PART

/* Hierarchical Task Example */

const string HSEM_IN = "IN";
const string HSEM_OUT = "OUT";
const string FOLLOW_TASK = "FOLLOW_TASK";
const string MAIN_TASK = "MAIN_TASK";

const unsigned int APP_NUMBER = APPLICATION_NUMBER;
const string APP_PREFIX = "App";

map<const string, sc_semaphore *> create_hierarchical_sem_map()
{
	map<const string, sc_semaphore *> m;

	for (int i=0; i<APP_NUMBER; i++) {

        	stringstream ss;
        	ss << i;
        	string str = ss.str(); ss.str("");

		string app = APP_PREFIX +  str;
	
	#ifdef PARALLEL_BEHV
	
		for (int j=0; j<NB_SCALES_FOLLOW_TASK; j++) {
			ss.clear();       			
			ss << j;
        		str = ss.str(); ss.str("");

			m[app + "_1" + str + FOLLOW_TASK + HSEM_IN] = new sc_semaphore(0);
			m[app + "_1" + str + FOLLOW_TASK + HSEM_OUT] = new sc_semaphore(0);
		}

		for (int j=0; j<NB_SCALES_MAIN_TASK; j++) {
			ss.clear();       			
			ss << j;
        		str = ss.str(); ss.str("");

			m[app + "_2" + str + MAIN_TASK + HSEM_IN] = new sc_semaphore(0);
			m[app + "_2" + str + MAIN_TASK + HSEM_OUT] = new sc_semaphore(0);
		}

	#else
		m[app + FOLLOW_TASK + HSEM_IN] = new sc_semaphore(0);
		m[app + FOLLOW_TASK + HSEM_OUT] = new sc_semaphore(0);

		m[app + MAIN_TASK + HSEM_IN] = new sc_semaphore(0);
		m[app + MAIN_TASK + HSEM_OUT] = new sc_semaphore(0);
	#endif
	}

	return m;
}

string extractApplicationName(string app_p) {
    if(app_p.find("_") != string::npos) {
        return (app_p.substr(0, app_p.find("_"))).c_str();
    }
    else return app_p;
}

map<const string, sc_semaphore *> hierarchical_sem_map = create_hierarchical_sem_map();

/* End Hierarchical Task Example */

sc_time application_start_time(SC_ZERO_TIME);
#endif
int current_application_id=0;
int current_application_id_out=0;

double cost_result[MAX_RZ][MAX_IMPL];
double cost_energy[MAX_RZ][MAX_IMPL];
double cost_time[MAX_RZ][MAX_IMPL];
double cost_resource[MAX_RZ][MAX_IMPL];

double cost_result_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
double cost_energy_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
double cost_time_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
double cost_resource_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];

unsigned int CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS]={222,333,666};
unsigned int global_operating_point=MAX_FREQ_STEPS-1;
double CPU_VOLTAGES_STEPS[MAX_FREQ_STEPS]={0.6,0.8,1};

/**************************  END USER SPACE ********************************/
/***************************************************************************/
