/**
  * @file    retach.h
  * @author  XXX
  * @version 1.0
  * @date    December 5, 2014 11:23:29 AM CET
  * @section DESCRIPTION
  * 
  * User Algorithms files of retach
  */



#ifndef RETACH_MODULE_ALGORITHMS_FILE_H
#define RETACH_MODULE_ALGORITHMS_FILE_H

#include "user_algorithm_interface.h"

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

template<int Ni, int No>
void retach(User_algorithm_interface<Ni, No> &user_algo_interface) {
		while(true) {

		/*******************************************************************************/
		/****                    MANDATORY PART (EXCEPT DISPLAY)                    ****/

		
		

		/* WAIT FOR START ALGORITHM EVENT : Only for Dynamic tasks */
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Beginning of loop" << endl;
		current_time_state = tasks_execution_time;
		user_algo_interface.b_execution_requested();
		

		
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Execution requested" << endl;
		
		/* TRACE : The algorithm is idle in order to have an accurate trace */
		user_algo_interface.set_algorithm_idle();

		/* WAIT FOR NEXT PERIOD to begin to start algorithm execution. For non-periodic modules, function returns right away */
		user_algo_interface.wait_until_next_period();
		


		
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " New period started" << endl;
#endif
		user_algo_interface.set_algorithm_waiting();

		/**** BEGINNING OF DATA RECEPTION SEGMENT ****/


		user_algo_interface.b_data_received("MT_W");
		int *data;
		data = user_algo_interface.get_data_in_ptr("MT_W");
//		if ((data[0]>>16)%2==0)
			user_algo_interface.b_data_received("FT1_W");
		
		//user_algo_interface.b_all_data_received();

		user_algo_interface.set_algorithm_running();

		/**** END OF DATA RECEPTION SEGMENT ****/

		/**** BEGINNING OF USER ALGORITHM ****/
			
		
		//sc_time my_WCET=(user_algo_interface.get_WCET())*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[global_operating_point]);  
		//sc_time my_BCET=(user_algo_interface.get_BCET())*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[global_operating_point]);  
		sc_time my_WCET=user_algo_interface.get_WCET();  
		sc_time my_BCET=user_algo_interface.get_BCET(); 
			
		double random = rand()%101;

		double random_result =(random/100.0)*(my_WCET.to_seconds()-my_BCET.to_seconds());

		sc_time random_execution_time = my_BCET;

		if (tasks_execution_time == RANDOM)		
			random_execution_time = my_BCET + sc_time(random_result, SC_SEC);

		if (tasks_execution_time == BCET)
			random_execution_time = my_BCET;
			
		if (tasks_execution_time == WCET)
			random_execution_time = my_WCET;

		
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Execution times : " << random_execution_time.to_seconds()*1000 << " ms : " << endl;

		
		
		// Preemption points
		for(int i = 0; i < user_algo_interface.get_nb_preemption_points(); i++) {
			wait(user_algo_interface.get_WCET()/(user_algo_interface.get_nb_preemption_points() + 1));

			user_algo_interface.preemption_point();
			user_algo_interface.set_algorithm_running();

		}

		// Wait for the last execution segment (after last preemption point)
		wait(user_algo_interface.get_WCET()/(user_algo_interface.get_nb_preemption_points() + 1));
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " User algorithm ended" << endl;
#endif






		/**** END OF USER ALGORITHM ****/


		// Check that all data issued from previous algorithm execution has been processed and sent
		//user_algo_interface.b_all_data_sent();

		// When all data is sent, indicate that a new sequence starts now
		// MUST BE DONE ONLY AFTER VERIFYING THAT ALL PREVIOUS DATA HAVE BEEN SENT
		user_algo_interface.start_new_transaction_sequence();

		// Find a channel that is not transient and has updated data
		//int channel_id = 0;
		//while(user_algo_interface.is_channel_transient(channel_id) || !user_algo_interface.nb_data_received(channel_id)) channel_id++;
		
		string channel_id="MT_W";
		// Copy data
		int data_in_length = 0;
		int data_out_length = 0;
		for(int i = 0; i < No; i++) {
			data_in_length = user_algo_interface.get_data_in_length("MT_W");
			data_out_length = user_algo_interface.get_data_out_length(i);

			if(data_out_length <= data_in_length) {
				memcpy(user_algo_interface.get_data_out_ptr(i), user_algo_interface.get_data_in_ptr("MT_W"), data_out_length);
			} else {
				memcpy(user_algo_interface.get_data_out_ptr(i), user_algo_interface.get_data_in_ptr("MT_W"), data_in_length);
				for(int j = data_in_length; j < data_out_length; j+=4) user_algo_interface.get_data_out_ptr(i)[j/4] = 0;
			}
			
			user_algo_interface.set_address_out(i, user_algo_interface.get_address_in("MT_W"));
			
		}

		// Release input sockets (we won't need their data anymore) for they are used by preceding modules again
		//user_algo_interface.release_all_input_sockets();
		
		user_algo_interface.release_input_socket("MT_W");
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Release Main Task comm" << endl;
//		if ((data[0]>>16)%2==0)
		{
			user_algo_interface.release_input_socket("FT1_W");
			user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Release FollowTask comm" << endl;
		}

		// Notify RZ to continue processing
		user_algo_interface.end_of_algorithm();

		// Send data to all sockets
		user_algo_interface.nb_send_all_data();
		

		// Wait for the event notifying a possible change in the user algorithm thread
		user_algo_interface.wait_for_update_user_algorithm();

		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Update user algorithm event received" << endl;

		if(user_algo_interface.kill_user_algorithm()) {
#ifdef GENERATE_LOG_FILE
			user_algo_interface.get_logfile() << user_algo_interface.get_name() << " User algorithm thread has to be killed!" << endl;
#endif
			return;
		}
	}
}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
