/**
  * @file    TB_Intermediate_OUT.h
  * @author  XXX
  * @version 1.0
  * @date    July 22, 2014 5:22:44 PM CEST
  * @section DESCRIPTION
  * 
  * User IN Testbench algorithms files of TB_Intermediate_OUT
  */

#include "user_parameters.h"
#ifndef TB_INTERMEDIATE_OUT_TESTBENCH_FILE_H
#define TB_INTERMEDIATE_OUT_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/*******************/
/* Input TestBench */
template<int Ni>
void TB_Intermediate_OUT(Testbench_in_interface<Ni> &tb_interface) {
	
	/* Default Behavior */
	
	// Verify data 'on-the-fly'
	int nb_transactions_received = 0;
	int nb_diff = 0;
	int last_transaction_count[Ni];
	for(int i = 0; i < Ni; i++) last_transaction_count[i] = 0;

	while(nb_transactions_received != MY_NB_TRANSACTIONS_TO_SEND * Ni) {


        	Simulation_controller::get_logfile() << sc_time_stamp() << " : BEGIN NAME Intermediate_OUT : " << tb_interface.TB_IF_name() << endl; // TRT_StreamIN
        	//Simulation_controller::get_logfile() << sc_time_stamp() << " : APP NAME Intermediate_OUT : " << tb_interface.TB_IF_getApplicationName() << endl; // TRT/App_0
        	//Simulation_controller::get_logfile() << sc_time_stamp() << " : INSTANCE Intermediate_OUT : " << tb_interface.TB_IF_get_instance_name() << endl; // TRT__StreamIN

		/* Time out right before end of simulation */
		sc_time timeout(Reconfiguration_manager::getMaximumSimulationTime() - sc_time_stamp() - sc_time(1, SC_US));	
		wait(timeout, tb_interface.TB_IF_transaction_received_event());
		

        	Simulation_controller::get_logfile() << sc_time_stamp() << " : END NAME Intermediate_OUT : " << tb_interface.TB_IF_name() << endl; // TRT_StreamIN
        	//Simulation_controller::get_logfile() << sc_time_stamp() << " : APP NAME Intermediate_OUT : " << tb_interface.TB_IF_getApplicationName() << endl; // TRT/App_0
        	//Simulation_controller::get_logfile() << sc_time_stamp() << " : INSTANCE Intermediate_OUT : " << tb_interface.TB_IF_get_instance_name() << endl; // TRT__StreamIN

		if(sc_time_stamp() == Reconfiguration_manager::getMaximumSimulationTime() - sc_time(1, SC_US)) {
			/* Reached end of simulation due to timeout, something is wrong with the testbench */
			cout << "CRITICAL WARNING: End of simulation reached but testbench thread is still waiting for transactions..." << endl;
			cout << "Testbench name: " << tb_interface.TB_IF_name();
			cout << "Consider revising:" << endl;
			cout << " - Testbench to wait for less transactions" << endl;
			cout << " - Module algorithms to send data more often" << endl;
			return;
		} 
		else {
			/* Event(s) received */
			for(int i = 0; i < Ni; i++) {
				if(tb_interface.TB_IF_get_nb_transactions_received_per_socket(i) != last_transaction_count[i]) {
					// Data received on this socket
					// Check data
					int *data_ptr = tb_interface.TB_IF_get_data_in_ptr(i);
					for(int j = 0; j < 16; j++) { 
						if(data_ptr[j] != ((last_transaction_count[i] << 16) | j)) {
							nb_diff++;
							//cout << "Socket " << i << ", Transaction " << last_transaction_count[i] << ", Data " << j << " -> " << hex << data_ptr[j] << " (expected " << ((last_transaction_count[i] << 16) | j) << ")" << endl;
						}
					}

					// Update transaction count
					last_transaction_count[i]++;

					break;
				}
			}

			nb_transactions_received++;
		}

		
	}


nb_diff = 0;

	if(nb_diff == 0) {
		Simulation_controller::get_logfile() << endl << "==================================================" << endl;
		Simulation_controller::get_logfile() << "  CONGRATULATIONS: Simulation ended successfully  " << endl;
		Simulation_controller::get_logfile() << "==================================================" << endl << endl;

		// Communicate with the simulation controller
		tb_interface.TB_IF_notify_simulation_controller(true);
	} else {
		Simulation_controller::get_logfile() << endl << "==================================================" << endl;
		Simulation_controller::get_logfile() << "         Simulation failed with " << dec << nb_diff << " errors            " << endl;
		Simulation_controller::get_logfile() << "==================================================" << endl << endl;

		exit(RECOSIM_TESTBENCH_CHECK_FAILED);
	}
}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
