/**
 * @file	user_parameters.h
 * @author  XXX
 * @version 1.0
 * @date	XXX
 *
 * @section DESCRIPTION
 *
 * User defined parameters.
 */
 

#ifndef USER_PARAMETERS_H
#define USER_PARAMETERS_H

#include "utils.h"



#ifdef RECOSIM_PART
#include <systemc.h>
#include <sstream>
#include <map>
using namespace std;
#endif

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

#define ZC702
//#define VIRTEX6
#define AET_RATIO 0.5f

#ifdef VIRTEX6
	#define CPU_PSTATIC 1000 		// *** NOT USED ANY MORE  
	#define CPU_PIDLE 1000 			// *** BUG: SMART_STATIC REQUIRES NON NULL VALUES FOR CORRECT SCHED
	#define CPU_PRUN 1000 			// *** ALSO REMOVE ALL CPU_P* PARAMETERS IN USER_MONITORING.H

	#define P_RECONF 150
	#define RECONF_SPEED 400 		//400MB/s
	#define CELL_SIZE 162 			//40.5*4Byte //Virtex6 !!
	//global static power is 48.51mW
	#define P_STATIC_ML605 2050		// *** TO BE CHECKED
	#define N_SLICES_ML605 37680
	#define P_STATIC_1CELL 0.05440552 	// mW/slice (FPGA static power)
//	#define P_STATIC_1CELL (P_STATIC_ML605/N_SLICES_ML605) 		// BUG CETTE EXPRESSION RENVOIE 0!?
	
	//CPU power model
	#define PM_CPU_STATIC 150		// Static Power coef
	#define PM_CPU_ALPHA 0.5 		// Idle power coef
	#define PM_CPU_BETA 0.06		// Run power coef
	#define PM_CPU_VOLTAGE 1
//	#define PM_CPU_CORENUMBER 2		// *** NOT USED ANY MORE
	#define PM_CPU_FREQUENCY 100		// 200	
	//power equation is P=Pstatic*Vcore*Ncores+alpha*Vcore*Vcore*Ncores*Freq+beta*Vcore*Vcore*Ncoresrunning*Freq
#endif

#ifdef ZC702
	#define CPU_PSTATIC 1000 		// *** NOT USED ANY MORE  
	#define CPU_PIDLE 1000 			// *** BUG: SMART_STATIC REQUIRES NON NULL VALUES FOR CORRECT SCHED
	#define CPU_PRUN 1000 			// *** ALSO REMOVE ALL CPU_P* PARAMETERS IN USER_MONITORING.H

	#define P_RECONF (2.8*4*5) // x4 if we suppose 400M is 4*dynamic power consumption at 120M x5 for demo
	//#define RECONF_SPEED 120 //120MB/s (PCAP)
	#define RECONF_SPEED 400 //We suppose a highspeed reconf, PCAP is too slow for realtime apps
	
	#define CELL_SIZE 162 //40.5*4Byte //Virtex6 !! MUST VERIFY FOR ZC702!!!!!!!!
	//ZC702 has 13300 slices?
	//global static power is 29mW
	#define P_STATIC_XC7Z020 29
	#define N_SLICES_XC7Z020 13300 		// *** TO BE CHECKED 
//	#define P_STATIC_XC7Z045 1500  		// XC7Z020 TOO SMALL FOR SMART STATIC SOLUTION
//	#define N_SLICES_XC7Z045 54654 		// *** TO BE CHECKED / XC7Z045 USED FOR SMART STATIC SOLUTION
	#define P_STATIC_1CELL 0.002180 	// mW/slice (XC7Z020 static power)
//	#define P_STATIC_1CELL 0.027445 	// mW/slice (XC7Z045 static power)
//	#define P_STATIC_1CELL (P_STATIC_XC7Z020/N_SLICES_XC7Z020)	// BUG CETTE EXPRESSION RENVOIE 0!?
//	#define P_STATIC_1CELL (P_STATIC_XC7Z045/N_SLICES_XC7Z045)	// BUG CETTE EXPRESSION RENVOIE 0!?

	//CPU power model
	#define PM_CPU_STATIC 89.8		// Static Power coef
	#define PM_CPU_ALPHA 0.0837 		// Idle power coef
	#define PM_CPU_BETA 0.1790		// Run power coef
	#define PM_CPU_VOLTAGE 1
//	#define PM_CPU_CORENUMBER 2		// *** NOT USED ANY MORE
	#define PM_CPU_FREQUENCY 667
	//power equation is P=Pstatic*Vcore*Ncores+alpha*Vcore*Vcore*Ncores*Freq+beta*Vcore*Vcore*Ncoresrunning*Freq
#endif


/************** CONFIGURATION *********************/

//#define PARALLEL_BEHV

#define APPLICATION_NUMBER 8

#define NB_SCALES_MAIN_TASK 10
#define NB_SCALES_FOLLOW_TASK 7

/**************************************************/

#define MY_NB_TRANSACTIONS_TO_SEND 4*APPLICATION_NUMBER

enum My_Simulation_states { WCET,BCET,RANDOM};
extern My_Simulation_states tasks_execution_time;


#ifdef RECOSIM_PART

/* Hierarchical Task Example */

extern const string HSEM_IN;
extern const string HSEM_OUT;
extern const string FOLLOW_TASK;
extern const string MAIN_TASK;

extern const unsigned int APP_NUMBER;
extern const string APP_PREFIX;

extern map<const string, sc_semaphore *> hierarchical_sem_map;
string extractApplicationName(string app_p);

/* End Hierarchical Task Example */


//extern sc_event TB_lock[NB_SLICES_APPLICATION];
//extern sc_semaphore Main_lock_IN;
//extern sc_semaphore Main_lock_OUT;
//extern sc_semaphore Follow_lock_IN;
//extern sc_semaphore Follow_lock_OUT;
extern sc_time application_start_time;
#endif


extern int current_application_id;
extern int current_application_id_out;

#define MAX_RZ 31*APPLICATION_NUMBER	//300*APPLICATION_NUMBER
#define MAX_IMPL 71*APPLICATION_NUMBER	//600*APPLICATION_NUMBER
//definitions for EA3c
extern double cost_result[MAX_RZ][MAX_IMPL];
extern double cost_energy[MAX_RZ][MAX_IMPL];
extern double cost_time[MAX_RZ][MAX_IMPL];
extern double cost_resource[MAX_RZ][MAX_IMPL];

//definitions for EA3deadline
#define MAX_FREQ_STEPS 3
extern double cost_result_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
extern double cost_energy_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
extern double cost_time_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];
extern double cost_resource_d[MAX_RZ][MAX_IMPL][MAX_FREQ_STEPS];

extern unsigned int CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS];
extern unsigned int global_operating_point;
extern double CPU_VOLTAGES_STEPS[MAX_FREQ_STEPS];


//My_Simulation_states tasking_execution_time = WCET;

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
