/**
  * @file    TB_Intermediate_IN.h
  * @author  XXX
  * @version 1.0
  * @date    July 22, 2014 5:57:58 PM CEST
  * @section DESCRIPTION
  * 
  * User OUT Testbench algorithms files of TB_Intermediate_IN
  */

#include "user_parameters.h"
#ifndef TB_INTERMEDIATE_IN_TESTBENCH_FILE_H
#define TB_INTERMEDIATE_IN_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/********************/
/* Output TestBench */
template<int No>
void TB_Intermediate_IN(Testbench_out_interface<No>& tb_interface) {
	// Default
	//
	// DATA SEND
	//
	
	int my_id=0;
	
	if (current_application_id<NB_SLICES_APPLICATION)
		my_id=current_application_id;
		
	current_application_id++;
	
	for (int i = 0; i < NB_TRANSACTIONS_TO_SEND; i++) {

		// Check that first module in the chain is ready
#ifdef GENERATE_LOG_FILE
		Simulation_controller::get_logfile() << endl << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << " checks instantiation for following modules" << endl;
#endif

		// Initialize data to send for this transaction
		for(int j = 0; j < No; j++) {
			int *data_out_ptr = tb_interface.TB_IF_get_data_out_ptr(j);
			for(int k = 0; k < 16; k++) data_out_ptr[k] = (i << 16) | k;
		}

		wait(TB_lock[my_id]);
		
		tb_interface.TB_IF_nb_send_all_data();

		/* DO NOTHING */
		/* check_target method asks for following modules instantiation, answer from
		 * the manager will produce an event responsible for data transfers */

		// Wait until all responses from following modules have been received */
		wait(tb_interface.TB_IF_all_responses_received_event());

#ifdef GENERATE_LOG_FILE
		Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": Transaction " << i << " has been sent" << endl;
#endif

		if(i != (NB_TRANSACTIONS_TO_SEND - 1)) {
			// Delay next transaction by waiting extra time
			sc_time delayToNextPacket((i + 1) * tb_interface.TB_IF_get_period() - sc_time_stamp());
			if(delayToNextPacket < SC_ZERO_TIME) {
				cerr << "ERROR in TB: Negative delay to next packet send! Consider revising periods and other timing information" << endl;
				exit(RECOSIM_INTERNAL_ERROR_ERRCODE);
			}
	//		wait(TB_lock[my_id]);//wait(delayToNextPacket);
		}

		tb_interface.TB_IF_increment_current_transaction_id();
	}

#ifdef GENERATE_LOG_FILE
	Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": All transactions have been sent" << endl;
#endif

}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
