/**
  * @file    TB_Follow_Task_IN.h
  * @author  XXX
  * @version 1.0
  * @date    July 22, 2014 5:57:58 PM CEST
  * @section DESCRIPTION
  * 
  * User OUT Testbench algorithms files of TB_Intermediate_IN
  */

#include "user_parameters.h"
#ifndef TB_FOLLOW_TASK_IN_TESTBENCH_FILE_H
#define TB_FOLLOW_TASK_IN_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/********************/
/* Output TestBench */
template<int No>
void TB_Follow_Task_IN(Testbench_out_interface<No>& tb_interface) {
	// Default
	//
	// DATA SEND
	//
	
	int my_id=0;
	
	if (current_application_id<NB_SCALES_MAIN_TASK)
		my_id=current_application_id;
		
	current_application_id++;
	
	for (int nb_trans = 0; nb_trans < MY_NB_TRANSACTIONS_TO_SEND; nb_trans++)
	for (int i=0; i<NB_SCALES_FOLLOW_TASK; i++) {	
#
		// Initialize data to send for this transaction
		for(int j = 0; j < No; j++) {
			int *data_out_ptr = tb_interface.TB_IF_get_data_out_ptr(j);
			for(int k = 0; k < 16; k++) data_out_ptr[k] = (i << 16) | k;
		}
		
        	//Simulation_controller::get_logfile() << "NAME FOLLOW : " << tb_interface.TB_IF_name() << endl; // TRT_followS_Main_Task_IN
        	Simulation_controller::get_logfile() << "(" << i << ")" << "WAIT APP NAME FOLLOW : " << tb_interface.TB_IF_getApplicationName() << endl; // TRT_followS/App_1
        	//Simulation_controller::get_logfile() << "INSTANCE FOLLOW : " << tb_interface.TB_IF_get_instance_name() << endl; // TRT_followS__Main_Task_IN

		/* Hierarchical Task Example */

	#ifdef PARALLEL_BEHV
		string app_p = tb_interface.TB_IF_get_instance_top_application_name();
		sc_semaphore *sem = hierarchical_sem_map[app_p + FOLLOW_TASK + HSEM_IN];
		sem->wait();
	#else
		string app_p = extractApplicationName(tb_interface.TB_IF_get_instance_top_application_name());
		sc_semaphore *sem = hierarchical_sem_map[app_p + FOLLOW_TASK + HSEM_IN];
		sem->wait();
	#endif
		

		Simulation_controller::get_logfile() << sc_time_stamp() << " (" << i << ")" << " : BEGIN NAME FOLLOW : " << tb_interface.TB_IF_name() << " released IN " << my_id << endl;

		tb_interface.TB_IF_nb_send_all_data();

		/* DO NOTHING */
		/* check_target method asks for following modules instantiation, answer from
		 * the manager will produce an event responsible for data transfers */

		// Wait until all responses from following modules have been received */
		wait(tb_interface.TB_IF_all_responses_received_event());

		Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": Transaction " << i << " has been sent" << endl;

		if(i == (NB_SCALES_FOLLOW_TASK - 1) && nb_trans == (MY_NB_TRANSACTIONS_TO_SEND - 1)) {
			Simulation_controller::get_logfile() << sc_time_stamp() << " : END_END NAME FOLLOW TASK : " << tb_interface.TB_IF_getApplicationName() << endl; // TRT/App_0
		}
		else {
			// Delay next transaction by waiting extra time
			sc_time delayToNextPacket((i + 1) * tb_interface.TB_IF_get_period() - sc_time_stamp());
			if(delayToNextPacket < SC_ZERO_TIME) {
				cerr << "ERROR in TB: Negative delay to next packet send! Consider revising periods and other timing information" << endl;
				exit(RECOSIM_INTERNAL_ERROR_ERRCODE);
			}
		}

		tb_interface.TB_IF_increment_current_transaction_id();
	}

#ifdef GENERATE_LOG_FILE
	Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": All transactions have been sent" << endl;
#endif

}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
