/**
  * @file    TBout2.h
  * @author  XXX
  * @version 1.0
  * @date    July 16, 2014 6:16:22 PM CEST
  * @section DESCRIPTION
  * 
  * User OUT Testbench algorithms files of TBout2
  */



#ifndef TBOUT2_TESTBENCH_FILE_H
#define TBOUT2_TESTBENCH_FILE_H

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

/********************/
/* Output TestBench */
//RECOSIM_USER_IF_OUT_BEGIN
template<int No>
void TBout2(Testbench_out_interface<No>& tb_interface) {
	// Default
	//
	// DATA SEND
	//
	tasks_execution_time = BCET;
	
	for (int i = 0; i < MY_NB_TRANSACTIONS_TO_SEND; i++) {
	
		if (i==1)
			tasks_execution_time = WCET;	
		else if (i==2)
			tasks_execution_time = BCET;
		else if (i>2)
			tasks_execution_time = RANDOM;

		// Check that first module in the chain is ready
        	Simulation_controller::get_logfile() << sc_time_stamp() << " : BEGIN APP NAME TBOUT2 : " << tb_interface.TB_IF_getApplicationName() << endl; // TRT/App_0

		// Initialize data to send for this transaction
		for(int j = 0; j < No; j++) {
			int *data_out_ptr = tb_interface.TB_IF_get_data_out_ptr(j);
			for(int k = 0; k < 16; k++) data_out_ptr[k] = (i << 16) | k;
		}

		tb_interface.TB_IF_nb_send_all_data();

		/* DO NOTHING */
		/* check_target method asks for following modules instantiation, answer from
		 * the manager will produce an event responsible for data transfers */

		// Wait until all responses from following modules have been received */
		
		application_start_time=sc_time_stamp();
		
		wait(tb_interface.TB_IF_all_responses_received_event());

		Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": TBOUT2 Transaction " << i << " has been sent" << endl;

		if(i != (MY_NB_TRANSACTIONS_TO_SEND - 1)) {
			// Delay next transaction by waiting extra time
			sc_time delayToNextPacket((i + 1) * tb_interface.TB_IF_get_period() - sc_time_stamp());
			if(delayToNextPacket < SC_ZERO_TIME) {
				cerr << "ERROR in TB: Negative delay to next packet send! Consider revising periods and other timing information" << endl;
				exit(RECOSIM_INTERNAL_ERROR_ERRCODE);
			}
			wait(delayToNextPacket);
		}

		tb_interface.TB_IF_increment_current_transaction_id();
	}

//#ifdef GENERATE_LOG_FILE
	Simulation_controller::get_logfile() << sc_time_stamp() << ": " << tb_interface.TB_IF_name() << ": All transactions have been sent" << endl;
//#endif

}
//RECOSIM_USER_IF_OUT_END

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
