/*
 * @file	user_scheduling.cpp
 * @author  XXX
 * @version 1.0
 * @date	XXX
 *
 * @section DESCRIPTION
 *
 * User-defined Scheduling/Mapping-Allocation schemes
 */

#include "user_scheduling.h"
#include "application.h"

//#define STATIC_SOLUTION
//#define SW_SOLUTION

/*
 * Steps :
 * 1) Choose Scheduling : DEFAULT_SCHEDULING_ALGORITHM or SCHEDULING_ALGORITHM, but not both (delete or comment the unused choice)
 * 2) Choose Mapping/Allocation : DEFAULT_MAPPING_ALGORITHM or MAPPING_ALGORITHM, but not both (delete or comment the unused choice)
 * 3) Replace NewStrategyName by your own strategy name declared in FoRTReSS Preference
 *
 * Help : go to FoRTReSS Menu : Help => FoRTReSS API => Scheduler API => Scheduler
 *        The instance name is "scheduler"
 *        Example : to get waiting queue size of tasks
 *            int Qsize = scheduler.Scheduler_get_waiting_queue_size();
 */




/* Default Scheduling Algorithm */
//DEFAULT_SCHEDULING_ALGORITHM(IdenticalScheduling)

// Comment for no blanking Strategy
#define STRATEGY_BLANK

void blanking_algo(Scheduler_interface &scheduler) {

#ifdef STRATEGY_BLANK

	int queueSize = (int) scheduler.Scheduler_get_waiting_queue_size();
	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int i=0;
	int CPU_idle=1;
	while(i < (int) all_RZs.size()) {
		if (all_RZs.at(i)->get_implementation_type()!=HARD && (!scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)) && scheduler.Scheduler_get_task_state(all_RZs.at(i)) == RUNNING))
			CPU_idle=0;

		i++;
	}

	if (CPU_idle) //since cores frequency is same, must verify that all cores are free.
		global_operating_point=0; //select lowest F operating point.

	if (queueSize==0)
	{
		//scheduler.Scheduler_get_output_stream() << " - QUEUE=0 ";

		int i=0;
		int blank=1;
		while(i < (int) all_RZs.size()) {
		
			if (scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)) == true) {
				// ALREADY BLANK
			}
			else if (scheduler.Scheduler_get_task_state(all_RZs.at(i)) == RUNNING) {
				//scheduler.Scheduler_get_output_stream() << "> " << all_RZs.at(i)->getName() << " - BUT STILL RUNNING";
				blank=0;
			}
			else if (scheduler.Scheduler_get_task_state(all_RZs.at(i)) == MAPPED) {
				//DO BLANK HERE!
				scheduler.Scheduler_get_output_stream() << "> " << all_RZs.at(i)->getName() << " - WE CAN BLANK";
			}
			else {
				//scheduler.Scheduler_get_output_stream() << "> " << all_RZs.at(i)->getName() << " - ELSE BUT STILL RUNNING";
				blank=0;
			}

			i++;
		}
		//scheduler.Scheduler_get_output_stream() << " -- CAN WE BLANK? " << blank <<endl;
		if (blank) {
			i=0;
			while(i < (int) all_RZs.size()) {

				scheduler.Scheduler_set_blank(all_RZs.at(i));
				//scheduler.Scheduler_get_output_stream() << " Blanking " << all_RZs.at(i)->getName() << endl;
				i++;
			}
		}
	}
#endif
}




/* User Scheduling Algorithm */
SCHEDULING_ALGORITHM(Static) 		{/* ToDo */}
SCHEDULING_ALGORITHM(Smart_Static) 		{/* ToDo */}
SCHEDULING_ALGORITHM(EA1_all) 	{/* ToDo */}
SCHEDULING_ALGORITHM(EA1_free) 	{/* ToDo */}
SCHEDULING_ALGORITHM(EA2_c) 		{/* ToDo */}
SCHEDULING_ALGORITHM(EA2_cr) 		{/* ToDo */}
SCHEDULING_ALGORITHM(EA2_crn) 		{/* ToDo */}
SCHEDULING_ALGORITHM(EA2_cn) 		{/* ToDo */}
SCHEDULING_ALGORITHM(TA1)			{/* ToDo */}
SCHEDULING_ALGORITHM(EA3)			{/* ToDo */}

SCHEDULING_ALGORITHM(EA3c) {
	blanking_algo(scheduler);
}

SCHEDULING_ALGORITHM(EA3dead) {
	blanking_algo(scheduler);
}


SCHEDULING_ALGORITHM(EA3dead3) {
	blanking_algo(scheduler);
}


/* Default Mapping/Allocation Algorithm */
//DEFAULT_MAPPING_ALGORITHM(IdenticalScheduling)

/* User Mapping/Allocation Algorithm */

/* STATIC, reconfigure une fois les RZ au début */

MAPPING_ALGORITHM(Static) {
	/* ToDo */

	Return_mapping_information mapping;

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << "Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;
		/*
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}
	*/

		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}

						if ((implementation_RZ->get_implementation_type()==SOFT) || (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i))==true) || (scheduler.Scheduler_get_current_module_ID(implementation_RZ)== i))
						{
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if (current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								{
									if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
										bestRZ = compatible_RZs.at(i);
									else
										bestRZ=0;
								}
								else
									if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
									{}
									else
										bestRZ=0;
								bestImplementationID = j;
								best_aggregate_energy = current_energy;
							}

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID);
	}
return mapping;
}

/* on met les taches de même bitstream sur la même RZ */

MAPPING_ALGORITHM(Smart_Static) {
	/* ToDo */

	Return_mapping_information mapping;

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
	int ii=0;
		scheduler.Scheduler_get_output_stream() << "Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;
		/*
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}
						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if ((implementation_RZ->get_implementation_type()==SOFT) || (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i))==true) || (taskVector.at(j).hasSameNetlist(taskImpl)== true))
						{
							if (current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								{
									if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
									{
										bestRZ = compatible_RZs.at(i);
										if (implementation_RZ->get_implementation_type()!=SOFT)
											for (ii = 0 ; ii < (int) compatible_RZs.size(); ii++) {
												TaskImplementation taskImpl1 = compatible_RZs.at(ii)->getCurrentImplementation();
												if ((taskVector.at(j).hasSameNetlist(taskImpl1)== true) && (ii != i))
													bestRZ=0;
											}

									}
									else
										bestRZ=0;
								}
								else
									if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
									{}
									else
										bestRZ=0;
								bestImplementationID = j;
								best_aggregate_energy = current_energy;
							}

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA1_all) {
	/* ToDo */

	Return_mapping_information mapping;

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << "Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;
		/*
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;

			i++;

		}*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								//else
								//	current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//else
							//	current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


							scheduler.Scheduler_get_output_stream() << "        current_energy : " << current_energy << endl;
							//current_energy=current_Prun*aggregate_time.to_seconds();
							//scheduler.Scheduler_get_output_stream() << " : Erun : " << current_energy << endl; //" : size : " <<  rz_table.size() <<  endl;
						}

								TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
								if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
									if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									{
										if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
											bestRZ = compatible_RZs.at(i);
										else
											bestRZ=0;
									}
									else
										if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
										{}
										else
											bestRZ=0;
									bestImplementationID = j;
									best_aggregate_energy = current_energy;

								}


					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA1_free) {
	/* ToDo */

	Return_mapping_information mapping;

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << "Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;
		/*
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;

			i++;

		}*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED/* ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								//else
								//	current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//else
							//	current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


							scheduler.Scheduler_get_output_stream() << "        current_energy : " << current_energy << endl;
							//current_energy=current_Prun*aggregate_time.to_seconds();
							//scheduler.Scheduler_get_output_stream() << " : Erun : " << current_energy << endl; //" : size : " <<  rz_table.size() <<  endl;
						}

								TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
								if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
									if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									{
										if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
											bestRZ = compatible_RZs.at(i);
										else
											bestRZ=0;
									}
									else
										if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
										{}
										else
											bestRZ=0;
									bestImplementationID = j;
									best_aggregate_energy = current_energy;

								}


					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA2_c) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(true);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;



		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
							{
								if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
									bestRZ = compatible_RZs.at(i);
								else
									bestRZ=0;
							}
							else
								if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
								{}
								else
									bestRZ=0;
							bestImplementationID = j;
							best_aggregate_energy = current_energy;

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA2_cr) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(true);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
							{
								if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
									bestRZ = compatible_RZs.at(i);
								else
									bestRZ=0;
							}
							else
								if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
								{}
								else
									bestRZ=0;
							bestImplementationID = j;
							best_aggregate_energy = current_energy;

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA2_crn) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
							{
								if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
									bestRZ = compatible_RZs.at(i);
								else
									bestRZ=0;
							}
							else
								if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
								{}
								else
									bestRZ=0;
							bestImplementationID = j;
							best_aggregate_energy = current_energy;

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA2_cn) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << endl;

		i = 0;
		/*
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING //*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true))
								current_energy=running_energy;
							else
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								else
									current_energy=2*running_energy+reconf_energy;
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< endl;
						}
						else //SOFT
						{
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							else
								current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << endl;


						}

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy < best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
							{
								if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT)
									bestRZ = compatible_RZs.at(i);
								else
									bestRZ=0;
							}
							else
								if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
								{}
								else
									bestRZ=0;
							bestImplementationID = j;
							best_aggregate_energy = current_energy;

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
return mapping;
}



int implementedTaskInWaitingList(Scheduler_interface* scheduler, RZ* currentRZ)
{
int queueSize = (int) scheduler->Scheduler_get_waiting_queue_size();
int k = 0;
int cnt = 0;

if(scheduler->Scheduler_is_RZ_blank(currentRZ))
	return 0;
else
{
	while(k <  queueSize)
	{

		vector<TaskImplementation> taskVector(currentRZ->getTaskImplementationVector());
		for(int j = 0; j < (int) taskVector.size(); j++) {
			//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
			if (scheduler->Scheduler_get_element(k).has_implementation(taskVector.at(j)))
			{
				TaskImplementation taskImpl = currentRZ->getCurrentImplementation();
				if(taskVector.at(j).hasSameNetlist(taskImpl))
					cnt++;
			}
		}

	k++;
	}

	return cnt;
}
}

/* DEV */
MAPPING_ALGORITHM(TA1) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();



	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	//double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE	//*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				if (scheduler.Scheduler_get_current_module_ID(implementation_RZ) !=-1)
				if (implementedTaskInWaitingList(&scheduler, implementation_RZ))
//					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_current_module_ID(implementation_RZ)<< " is in waiting list" << endl;

					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is in waiting list" << endl;
				else
					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is not in waiting list" << endl;
				//*/

				scheduler.Scheduler_get_output_stream() << "    "<< scheduler.Scheduler_get_current_module_ID(implementation_RZ) << " running since: " << scheduler.Scheduler_get_task_running_time(scheduler.Scheduler_get_current_module_ID(implementation_RZ)) << endl;

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds(); //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								current_energy=running_energy;
								execution_time=taskVector.at(j).getWorstCaseExecutionTime();
							}
							else
							{
								//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								//else
								//	current_energy=2*running_energy+reconf_energy;

								//execution_time=taskVector.at(j).getWorstCaseExecutionTime()+ sc_time(((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000,SC_SEC);
								execution_time=taskVector.at(j).getWorstCaseExecutionTime()+ taskVector.at(j).getCompressedReconfigurationTime();
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< " Execution time: " << execution_time <<endl;

						}
						else //SOFT
						{
							//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//else
							//	current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							execution_time=taskVector.at(j).getWorstCaseExecutionTime();
							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << " Execution time: " << execution_time <<endl;


						}

						/*if (application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time))
							current_energy = current_energy*4; //if this implementation doesnt satisfy deadline add arbitrary cost (energy*4)
							*/

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || execution_time <= best_aggregate_time) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (/*application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time) && */((implementedTaskInWaitingList(&scheduler, implementation_RZ))==0 || (taskVector.at(j).hasSameNetlist(taskImpl)== true) ))
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
								{
									if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT  || ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i))))
									{
										scheduler.Scheduler_get_output_stream() << "          Good" <<endl;
										bestRZ = compatible_RZs.at(i);
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but reconfiguration controller busy" <<endl;
										bestRZ=0;
									}
								}
								else
									if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (execution_time < best_aggregate_time)
											bestRZ=0;
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (execution_time < best_aggregate_time)
											bestRZ=0;
									}
								bestImplementationID = j;
								best_aggregate_time = execution_time;
							}

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() <<endl;
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}


/* DEV */
MAPPING_ALGORITHM(EA3) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();



	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		i = 0;
		while(i < (int) compatible_RZs.size()) {

		if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
		else
			scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE	//*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);

				if (scheduler.Scheduler_get_current_module_ID(implementation_RZ) !=-1) {
                    if (implementedTaskInWaitingList(&scheduler, implementation_RZ))
                        scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is in waiting list" << endl;
                    else
                        scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is not in waiting list" << endl;
				}

				scheduler.Scheduler_get_output_stream() << "    "<< scheduler.Scheduler_get_current_module_ID(implementation_RZ) << " running since: " << scheduler.Scheduler_get_task_running_time(scheduler.Scheduler_get_current_module_ID(implementation_RZ)) << endl;

				vector<TaskImplementation> taskVector(implementation_RZ->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++) {
					//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;

						//sc_time aggregate_time(taskVector.at(j).getCompressedReconfigurationTime() + taskVector.at(j).getWorstCaseExecutionTime());

						if (implementation_RZ->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//double reconf_energy=P_RECONF*((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000; //--> time in s not in us
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds(); //--> time in s not in us
							scheduler.Scheduler_get_output_stream() << "        resources : " << implementation_RZ->get_resources_ptr()->getResourceCount("Slice")<< endl;
							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								current_energy=running_energy;
								execution_time=taskVector.at(j).getWorstCaseExecutionTime();
							}
							else
							{
								//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
									current_energy=running_energy+reconf_energy;
								//else
								//	current_energy=2*running_energy+reconf_energy;

								//execution_time=taskVector.at(j).getWorstCaseExecutionTime()+ sc_time(((double)implementation_RZ->get_resources_ptr()->getResourceCount("Slice")*40*CELL_SIZE/RECONF_SPEED)/1000000,SC_SEC);
								execution_time=taskVector.at(j).getWorstCaseExecutionTime()+ taskVector.at(j).getCompressedReconfigurationTime();
							}
							scheduler.Scheduler_get_output_stream() << "        hard energy : " << reconf_energy << "mJ + " << running_energy<< "mJ = "<< current_energy<< " Execution time: " << execution_time <<endl;

						}
						else //SOFT
						{
							//if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED)
								current_energy=CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());
							//else
							//	current_energy=2*CPU_PRUN*(taskVector.at(j).getWorstCaseExecutionTime().to_seconds());

							execution_time=taskVector.at(j).getWorstCaseExecutionTime();
							scheduler.Scheduler_get_output_stream() << "        soft energy : " << current_energy << "mJ" << " Execution time: " << execution_time <<endl;


						}

						/*if (application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time))
							current_energy = current_energy*4; //if this implementation doesnt satisfy deadline add arbitrary cost (energy*4)
							*/

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy <= best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(taskImpl)== true)) {
							if (/*application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time) && */((implementedTaskInWaitingList(&scheduler, implementation_RZ))==0 || (taskVector.at(j).hasSameNetlist(taskImpl)== true) ))
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
								{
									if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT  || ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i))))
									{
										scheduler.Scheduler_get_output_stream() << "          Good" <<endl;
										bestRZ = compatible_RZs.at(i);
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but reconfiguration controller busy" <<endl;
										bestRZ=0;
									}
								}
								else
									if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (current_energy < best_aggregate_energy)
											bestRZ=0;
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (current_energy < best_aggregate_energy)
											bestRZ=0;
									}
								bestImplementationID = j;
								best_aggregate_energy = current_energy;
							}

						}
					}
				}
			}
			i++;
		}

	if(bestRZ != 0) {
		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() <<endl;
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}



int currentTaskInWaitingList(Scheduler_interface* scheduler, RZ* currentRZ, TaskImplementation currentImpl)
{
int queueSize = (int) scheduler->Scheduler_get_waiting_queue_size();
int k = 0;
int cnt = 0;

//if(scheduler->Scheduler_is_RZ_blank(currentRZ))
//	return 0;
//else
//{
	while(k <  queueSize)
	{

		vector<TaskImplementation> taskVector(currentRZ->getTaskImplementationVector());
		for(int j = 0; j < (int) taskVector.size(); j++) {
			//scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName()<< endl;
			if (scheduler->Scheduler_get_element(k).has_implementation(taskVector.at(j)))
			{
				if(taskVector.at(j).hasSameNetlist(currentImpl))
					cnt++;
			}
		}


		/*if (scheduler->Scheduler_get_module_ID(scheduler->Scheduler_get_element(k)) == scheduler->Scheduler_get_current_module_ID(currentRZ))
			cnt++;*/
	k++;
	}
	if (cnt==0) //should not arrived if currentRZ is well passed
		cnt=1;
	/*
		return true;
	else
		return false;*/
	return cnt;
//}
}


/* ********************************************************************************* */
/* Pas de prise en compte de la deadline, sans DVFS avec un objectif de faible conso */
/* conf. RECOSOC */

MAPPING_ALGORITHM(EA3c) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();



	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	//double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				cost_energy[i][j]=-1;
				cost_time[i][j]=-1;
				cost_resource[i][j]=-1;
				cost_result[i][j]=-1;
			}

		i = 0;
		for(unsigned int i = 0; i < compatible_RZs.size(); i++)
		{
			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
			else
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == IDLE	//*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);
				sc_time task_wcet(SC_ZERO_TIME);
				vector<TaskImplementation> taskVector(compatible_RZs.at(i)->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++)
				{


					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName() << " Task Name : "<< taskVector.at(j).getTaskName() << endl;

/*
						if (taskVector.at(j).getTaskName().find("ICAVLC_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("IQTr_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("Inv_Pred_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("DBF_1")!=string::npos)
						{
							task_wcet=taskVector.at(j).getWorstCaseExecutionTime()/NB_SLICES_APPLICATION;
							scheduler.Scheduler_get_output_stream() << "      Implementation: is sliced" << endl;
						}
						else
*/
						task_wcet=taskVector.at(j).getWorstCaseExecutionTime();



						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*task_wcet.to_seconds();
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();

							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								current_energy=running_energy;
								execution_time=task_wcet;

								scheduler.Scheduler_get_output_stream() << "        hard : " << running_energy<< "mJ" << " time: " << execution_time <<endl;
							}
							else
							{
								scheduler.Scheduler_get_output_stream() << "        Tasks in waiting list? : " << currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)) <<endl;


								current_energy=running_energy+reconf_energy/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));
								execution_time=task_wcet+ taskVector.at(j).getCompressedReconfigurationTime()/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));

								scheduler.Scheduler_get_output_stream() << "        hard : " << reconf_energy << "mJ + " << running_energy << "mJ = " << current_energy<< " time: " << taskVector.at(j).getCompressedReconfigurationTime() << " + " << taskVector.at(j).getWorstCaseExecutionTime() << " = " << execution_time <<endl;
							}


						}
						else //SOFT
						{
							double cpu_run_power=PM_CPU_BETA*PM_CPU_VOLTAGE*PM_CPU_VOLTAGE*1*PM_CPU_FREQUENCY;

							current_energy=cpu_run_power*(task_wcet.to_seconds());
							execution_time=task_wcet;

							scheduler.Scheduler_get_output_stream() << "        soft : " << current_energy << "mJ" << " Execution time: " << execution_time <<endl;
						}


						cost_energy[i][j]=current_energy;
						cost_time[i][j]=execution_time.to_seconds();

						current_energy=0;
						execution_time=SC_ZERO_TIME;

						double current_cost=0;

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if (implementation_RZ->get_implementation_type()==HARD && reconfiguration_manager_busy!=0 && (taskVector.at(j).hasSameNetlist(taskImpl)== false))
						{
							//current_cost++;
							scheduler.Scheduler_get_output_stream() << "        Controler busy" <<endl;
							current_energy+=0;
							execution_time+=taskVector.at(j).getCompressedReconfigurationTime(); // !!!!!!!!! Example! Must be modified with estimated end of time
						}

						if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
							{}
						else
						{
							/*if ((taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== false) )
								current_cost++;
							else
								current_cost--;*/
							scheduler.Scheduler_get_output_stream() << "        RZ busy" <<endl;
							execution_time=task_wcet; //example
						}
						taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if ((implementedTaskInWaitingList(&scheduler, implementation_RZ))>=1 && (taskVector.at(j).hasSameNetlist(taskImpl)== false) && implementation_RZ->get_implementation_type()==HARD )
						{
							//estimate cost to do this at one more reconf.
							current_energy+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();
							execution_time+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*taskVector.at(j).getCompressedReconfigurationTime();
							scheduler.Scheduler_get_output_stream() << "        RZ holds future implementations" <<endl;
							current_cost=1;

						}

						//if (current_cost<0) current_cost=0;
						cost_resource[i][j]=current_cost;
						cost_energy[i][j]+=current_energy;
						cost_time[i][j]+=execution_time.to_seconds();
					}
				}
			}
		}

		double max_energy=-1;
		double max_time=-1;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				if (cost_energy[i][j] > max_energy)
					max_energy=cost_energy[i][j];
				if (cost_time[i][j] > max_time)
					max_time=cost_time[i][j];
			}

		if (max_time==0) max_time=1;
		if (max_energy==0) max_energy=1;

		double alpha=0.8;

		double min_cost = 1.5;
		int bestRZid=0;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				if (cost_resource[i][j] != -1)
				{
					cost_energy[i][j] /= max_energy;
					cost_time[i][j] /= max_time;


					cost_result[i][j]=alpha*cost_energy[i][j]+(1-alpha)*cost_time[i][j];//+cost_resource[i][j];
					if (cost_result[i][j] < min_cost)
					{
						min_cost = cost_result[i][j];
						bestRZ = compatible_RZs.at(i);
						bestRZid = i;
						bestImplementationID = j;
					}

					scheduler.Scheduler_get_output_stream() << "        cost : " << i << " " << j << "  " << cost_result[i][j] <<endl;


				}
			}

		if (bestRZ != 0 && (scheduler.Scheduler_is_RZ_blank(bestRZ) || scheduler.Scheduler_get_task_state(bestRZ) == MAPPED || scheduler.Scheduler_get_task_state(bestRZ) == PREEMPTED_MAPPED ))
		{

		}
		else
			bestRZ=0;

		if (bestRZ != 0 && (cost_resource[bestRZid][bestImplementationID]==1) /*&& alpha > 0.5*/)
		{
			bestRZ=0;
		}


	/*
				if (scheduler.Scheduler_get_current_module_ID(implementation_RZ) !=-1)
				if (implementedTaskInWaitingList(&scheduler, implementation_RZ))
//					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_current_module_ID(implementation_RZ)<< " is in waiting list" << endl;

					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is in waiting list" << endl;
				else
					scheduler.Scheduler_get_output_stream() << "    COMPARE: " << scheduler.Scheduler_get_task_to_schedule_ptr(scheduler.Scheduler_get_current_module_ID(implementation_RZ))->getName() << " is not in waiting list" << endl;


				scheduler.Scheduler_get_output_stream() << "    "<< scheduler.Scheduler_get_current_module_ID(implementation_RZ) << " running since: " << scheduler.Scheduler_get_task_running_time(scheduler.Scheduler_get_current_module_ID(implementation_RZ)) << endl;
				*/

						/*if (application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time))
							current_energy = current_energy*4; //if this implementation doesnt satisfy deadline add arbitrary cost (energy*4)
							*/



	/*

						if(current_request.has_implementation(taskVector.at(j)) && (bestImplementationID == -1 || current_energy <= best_aggregate_energy) || (taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== true)) {
							if (/*application_start_time+current_request.get_task_deadline()>(sc_time_stamp()+execution_time) && *//*((implementedTaskInWaitingList(&scheduler, implementation_RZ))==0 || (taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== true) ))
							{
								if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
								{
									if (reconfiguration_manager_busy==0 || implementation_RZ->get_implementation_type()==SOFT  || ((taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i))))
									{
										scheduler.Scheduler_get_output_stream() << "          Good" <<endl;
										bestRZ = compatible_RZs.at(i);
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but reconfiguration controller busy" <<endl;
										bestRZ=0;
									}
								}
								else
									if (scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING && compatible_RZs.at(i)->get_implementation_type()!=HARD)
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (current_energy < best_aggregate_energy)
											bestRZ=0;
									}
									else
									{
										scheduler.Scheduler_get_output_stream() << "          Good but RZ running" <<endl;
										if (current_energy < best_aggregate_energy)
											bestRZ=0;
									}
								bestImplementationID = j;
								best_aggregate_energy = current_energy;
							}

						}
					}
				}
			}
			i++;
		}*/

	if(bestRZ != 0) {
		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() <<endl;
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}
/* DEV */
MAPPING_ALGORITHM(EA3dead) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int queueSize = (int) scheduler.Scheduler_get_waiting_queue_size();

	int TLP = ((int)queueSize/((int)all_RZs.size()));
	if (TLP*(int)all_RZs.size()!=(int)queueSize)
		TLP=TLP+1;

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	//double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " ;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - TLP: " << TLP << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					cost_energy_d[i][j][k]=-1;
					cost_time_d[i][j][k]=-1;
					cost_resource_d[i][j][k]=-1;
					cost_result_d[i][j][k]=-1;
				}
			}

		i = 0;
		sc_time task_best_wcet(10,SC_SEC);
		for(unsigned int i = 0; i < compatible_RZs.size(); i++)
		{
			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
			else
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == IDLE	//*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);
				sc_time task_wcet(SC_ZERO_TIME);

				vector<TaskImplementation> taskVector(compatible_RZs.at(i)->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++)
				{


					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName() << " Task Name : "<< taskVector.at(j).getTaskName() << endl;
/*
						if (taskVector.at(j).getTaskName().find("ICAVLC_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("IQTr_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("Inv_Pred_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("DBF_1")!=string::npos)
						{
							task_wcet=taskVector.at(j).getWorstCaseExecutionTime()/NB_SLICES_APPLICATION;
							scheduler.Scheduler_get_output_stream() << "      Implementation: is sliced" << endl;
						}
						else
*/
						task_wcet=taskVector.at(j).getWorstCaseExecutionTime();

						if (task_best_wcet>task_wcet)
							task_best_wcet=task_wcet;

						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*task_wcet.to_seconds();
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();

							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								current_energy=running_energy;
								execution_time=task_wcet;

								scheduler.Scheduler_get_output_stream() << "        hard : " << running_energy<< "mJ" << " time: " << execution_time <<endl;
							}
							else
							{
								scheduler.Scheduler_get_output_stream() << "        Tasks in waiting list? : " << currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)) <<endl;


								current_energy=running_energy+reconf_energy/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));
								execution_time=task_wcet+ taskVector.at(j).getCompressedReconfigurationTime()/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));

								scheduler.Scheduler_get_output_stream() << "        hard : " << reconf_energy << "mJ + " << running_energy << "mJ = " << current_energy<< " time: " << taskVector.at(j).getCompressedReconfigurationTime() << " + " << taskVector.at(j).getWorstCaseExecutionTime() << " = " << execution_time <<endl;
							}

						cost_energy_d[i][j][0]=current_energy;
						cost_time_d[i][j][0]=execution_time.to_seconds();


						}
						else //SOFT
						{
							for (int k=0;k<MAX_FREQ_STEPS;k++) //DVFS
							{

								//double cpu_run_power=PM_CPU_BETA*PM_CPU_VOLTAGE*PM_CPU_VOLTAGE*1*PM_CPU_FREQUENCY;
								double cpu_run_power=PM_CPU_BETA*CPU_VOLTAGES_STEPS[k]*CPU_VOLTAGES_STEPS[k]*1*CPU_FREQUENCIES_STEPS[k];
								current_energy=cpu_run_power*(task_wcet.to_seconds());
								execution_time=task_wcet*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[k]);
								scheduler.Scheduler_get_output_stream() << "        soft : " << current_energy << "mJ" << " Execution time: " << execution_time << "@" << CPU_FREQUENCIES_STEPS[k] << "MHz" << endl;

								cost_energy_d[i][j][k]=current_energy;
								cost_time_d[i][j][k]=execution_time.to_seconds();

							}
						}


						//cost_energy[i][j]=current_energy;
						//cost_time[i][j]=execution_time.to_seconds();

						current_energy=0;
						execution_time=SC_ZERO_TIME;

						double current_cost=0;

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if (implementation_RZ->get_implementation_type()==HARD && reconfiguration_manager_busy!=0 && (taskVector.at(j).hasSameNetlist(taskImpl)== false))
						{
							//current_cost++;
							scheduler.Scheduler_get_output_stream() << "        Controler busy" <<endl;
							current_energy+=0;
							execution_time+=taskVector.at(j).getCompressedReconfigurationTime(); // !!!!!!!!! Example! Must be modified with estimated end of time
						}

						if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
							{}
						else
						{
							/*if ((taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== false) )
								current_cost++;
							else
								current_cost--;*/
							scheduler.Scheduler_get_output_stream() << "        RZ busy" <<endl;
							execution_time=task_wcet; //example
						}

						taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if ((implementedTaskInWaitingList(&scheduler, implementation_RZ))>=1 && (taskVector.at(j).hasSameNetlist(taskImpl)== false) && implementation_RZ->get_implementation_type()==HARD )
						{
							//estimate cost to do this at one more reconf.
							current_energy+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();
							execution_time+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*taskVector.at(j).getCompressedReconfigurationTime();
							scheduler.Scheduler_get_output_stream() << "        RZ holds future implementations" <<endl;
							current_cost=1;

						}

						//if (current_cost<0) current_cost=0;
						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							cost_resource_d[i][j][0]=current_cost;
							cost_energy_d[i][j][0]+=current_energy;
							cost_time_d[i][j][0]+=execution_time.to_seconds();
						}
						else
						{
							for (int k=0;k<MAX_FREQ_STEPS;k++)
							{
								cost_resource_d[i][j][k]=current_cost;
								cost_energy_d[i][j][k]+=current_energy;
								cost_time_d[i][j][k]+=execution_time.to_seconds();
							}
						}
					}
				}
			}
		}

		double max_energy=-1;
		double max_time=-1;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_energy_d[i][j][k] > max_energy)
						max_energy=cost_energy_d[i][j][k];
					if (cost_time_d[i][j][k] > max_time)
						max_time=cost_time_d[i][j][k];
				}
			}

		if (max_time==0) max_time=1;
		if (max_energy==0) max_energy=1;

		double alpha=0.5;

		scheduler.Scheduler_get_output_stream() << "  deadline: " << application_start_time +current_request.get_task_deadline() << " WCET : " << sc_time_stamp()+task_best_wcet << endl;
		/*if (application_start_time+current_request.get_task_deadline()>sc_time_stamp()+(task_best_wcet*1.5))
		{
			alpha=0.7;
			scheduler.Scheduler_get_output_stream() << "  energy mode" << endl;
		}
		else
		{
			alpha=0.3;
			scheduler.Scheduler_get_output_stream() << "  performance mode" << endl;
		}*/

		#define ALPHA_MIN 0.1
		#define ALPHA_MAX 0.9

		#define TASK_DEADLINE (application_start_time+current_request.get_task_deadline())
		//#define TASK_BCET (sc_time_stamp()+(2*task_best_wcet))
		//#define TASK_WCET (sc_time_stamp()+(6*task_best_wcet))
		#define TASK_BCET (sc_time_stamp()+(TLP*task_best_wcet))
		#define TASK_WCET (sc_time_stamp()+(2*TLP*task_best_wcet))

		/*if (application_start_time+current_request.get_task_deadline()<sc_time_stamp()+(1.5*task_best_wcet))
			alpha=ALPHA_MIN; //MAX PERF
		else
		if (application_start_time+current_request.get_task_deadline()>sc_time_stamp()+(3*task_best_wcet))
			alpha=ALPHA_MAX; //E SAVING
		else
		{
			alpha=1-(((application_start_time+current_request.get_task_deadline())-(sc_time_stamp()+(1.5*task_best_wcet)))/(sc_time_stamp()+(3*task_best_wcet)-sc_time_stamp()+(1.5*task_best_wcet))*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);
		}*/
		if (TASK_DEADLINE<TASK_BCET)
			alpha=ALPHA_MIN; //MAX PERF
		else
		if (TASK_DEADLINE>TASK_WCET)
			alpha=ALPHA_MAX; //E SAVING
		else
		{
			alpha=1-(((TASK_DEADLINE)-TASK_BCET)/(TASK_WCET-TASK_BCET)*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);
		}

		scheduler.Scheduler_get_output_stream() << "  alpha mode" << alpha << endl;

		double min_cost = 1.5;
		int bestRZid=0;
		int bestFREQ=0;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_resource_d[i][j][k] != -1 && cost_energy_d[i][j][k] != -1)
					{
						scheduler.Scheduler_get_output_stream() << "      exectime: " << cost_time_d[i][j][k]*1000 << " endtime: " << (cost_time_d[i][j][k]+sc_time_stamp().to_seconds())*1000 << " deadline: " << TASK_DEADLINE.to_seconds()*1000 << endl;
						if (cost_time_d[i][j][k]*TLP+sc_time_stamp().to_seconds()>TASK_DEADLINE.to_seconds())
						{
							cost_energy_d[i][j][k]+=max_energy;
						}
						cost_energy_d[i][j][k] /= max_energy;
						cost_time_d[i][j][k] /= max_time;


						cost_result_d[i][j][k]=alpha*cost_energy_d[i][j][k]+(1-alpha)*cost_time_d[i][j][k];//+cost_resource[i][j];
						if (cost_result_d[i][j][k] < min_cost)
						{
							min_cost = cost_result_d[i][j][k];
							bestRZ = compatible_RZs.at(i);
							bestRZid = i;
							bestImplementationID = j;
							bestFREQ = k;
						}

						scheduler.Scheduler_get_output_stream() << "        cost : " << i << " " << j << " " << CPU_FREQUENCIES_STEPS[k] <<"  " << cost_result_d[i][j][k] <<endl;

					}
				}
			}

		if (bestRZ != 0 && (scheduler.Scheduler_is_RZ_blank(bestRZ) || scheduler.Scheduler_get_task_state(bestRZ) == MAPPED || scheduler.Scheduler_get_task_state(bestRZ) == PREEMPTED_MAPPED ))
		{

		}
		else
			bestRZ=0;

		if (bestRZ != 0 && (cost_resource[bestRZid][bestImplementationID]==1) /*&& alpha > 0.5*/)
		{
			bestRZ=0;
		}


	if(bestRZ != 0) {
		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() <<endl;
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
		if (bestRZ->get_implementation_type()!=HARD)
			global_operating_point=bestFREQ;
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}

/* DEV */
MAPPING_ALGORITHM(EA3dead2) {
	/* ToDo */

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int queueSize = (int) scheduler.Scheduler_get_waiting_queue_size();

	int TLP = ((int)queueSize/((int)all_RZs.size()));
	if (TLP*(int)all_RZs.size()!=(int)queueSize)
		TLP=TLP+1;

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	//double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " ;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - TLP: " << TLP << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;

		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/


		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					cost_energy_d[i][j][k]=-1;
					cost_time_d[i][j][k]=-1;
					cost_resource_d[i][j][k]=-1;
					cost_result_d[i][j][k]=-1;
				}
			}

		i = 0;
		sc_time task_best_wcet(10,SC_SEC);
		for(unsigned int i = 0; i < compatible_RZs.size(); i++)
		{
			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
			else
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;



			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == IDLE	//*/
				)
			{
				//free RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);
				sc_time task_wcet(SC_ZERO_TIME);

				vector<TaskImplementation> taskVector(compatible_RZs.at(i)->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++)
				{


					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName() << " Task Name : "<< taskVector.at(j).getTaskName() << endl;
/*
						if (taskVector.at(j).getTaskName().find("ICAVLC_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("IQTr_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("Inv_Pred_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("DBF_1")!=string::npos)
						{
							task_wcet=taskVector.at(j).getWorstCaseExecutionTime()/NB_SLICES_APPLICATION;
							scheduler.Scheduler_get_output_stream() << "      Implementation: is sliced" << endl;
						}
						else
*/
						task_wcet=taskVector.at(j).getWorstCaseExecutionTime();

						if (task_best_wcet>task_wcet)
							task_best_wcet=task_wcet;

						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							double running_energy=taskVector.at(j).getPrun()*task_wcet.to_seconds();
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();

							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								if (taskVector.at(j).getTaskName().find("blank")!=string::npos)
								{
									current_energy=running_energy+reconf_energy;
									execution_time=task_wcet+taskVector.at(j).getCompressedReconfigurationTime();
								}
								else
								{
									current_energy=running_energy;
									execution_time=task_wcet;
								}

								scheduler.Scheduler_get_output_stream() << "        hard : " << running_energy<< "mJ" << " time: " << execution_time <<endl;
							}
							else
							{
								scheduler.Scheduler_get_output_stream() << "        Tasks in waiting list? : " << currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)) <<endl;

								if (taskVector.at(j).getTaskName().find("blank")!=string::npos)
									current_energy=running_energy;
								else
									current_energy=running_energy+reconf_energy/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));
								execution_time=task_wcet+ taskVector.at(j).getCompressedReconfigurationTime()/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));

								#ifdef STRATEGY_STATIC
								if (!scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
									current_energy+=running_energy+reconf_energy; //static hack
								#endif

								scheduler.Scheduler_get_output_stream() << "        hard : " << reconf_energy << "mJ + " << running_energy << "mJ = " << current_energy<< " time: " << taskVector.at(j).getCompressedReconfigurationTime() << " + " << taskVector.at(j).getWorstCaseExecutionTime() << " = " << execution_time <<endl;
							}

						cost_energy_d[i][j][0]=current_energy;
						cost_time_d[i][j][0]=execution_time.to_seconds();


						}
						else //SOFT
						{
							for (int k=0;k<MAX_FREQ_STEPS;k++) //DVFS
							{

								//double cpu_run_power=PM_CPU_BETA*PM_CPU_VOLTAGE*PM_CPU_VOLTAGE*1*PM_CPU_FREQUENCY;
								double cpu_run_power=PM_CPU_BETA*CPU_VOLTAGES_STEPS[k]*CPU_VOLTAGES_STEPS[k]*1*CPU_FREQUENCIES_STEPS[k];
								current_energy=cpu_run_power*(task_wcet.to_seconds());
								execution_time=task_wcet*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[k]);
								scheduler.Scheduler_get_output_stream() << "        soft : " << current_energy << "mJ" << " Execution time: " << execution_time << "@" << CPU_FREQUENCIES_STEPS[k] << "MHz" << endl;

								cost_energy_d[i][j][k]=current_energy;
								cost_time_d[i][j][k]=execution_time.to_seconds();

							}
						}


						//cost_energy[i][j]=current_energy;
						//cost_time[i][j]=execution_time.to_seconds();

						current_energy=0;
						execution_time=SC_ZERO_TIME;

						//double current_cost=0;

						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if (implementation_RZ->get_implementation_type()==HARD && reconfiguration_manager_busy!=0 && (taskVector.at(j).hasSameNetlist(taskImpl)== false))
						{
							//current_cost++;
							scheduler.Scheduler_get_output_stream() << "        Controler busy" <<endl;
							current_energy+=0;
							execution_time+=taskVector.at(j).getCompressedReconfigurationTime(); // !!!!!!!!! Example! Must be modified with estimated end of time
						}

						if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
							{}
						else
						{
							/*if ((taskVector.at(j).hasSameNetlist(compatible_RZs.at(i)->getCurrentImplementation())== false) )
								current_cost++;
							else
								current_cost--;*/
							scheduler.Scheduler_get_output_stream() << "        RZ busy" <<endl;
							execution_time+=task_wcet/2; //example
						}

						taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if ((implementedTaskInWaitingList(&scheduler, implementation_RZ))>=1 && (taskVector.at(j).hasSameNetlist(taskImpl)== false) && implementation_RZ->get_implementation_type()==HARD )
						{
							//estimate cost to do this at one more reconf.
							current_energy+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();
							execution_time+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*taskVector.at(j).getCompressedReconfigurationTime();
							scheduler.Scheduler_get_output_stream() << "        RZ holds future implementations" <<endl;
							//current_cost=1;

						}

						#define ALPHA_MIN2 0.1
						#define ALPHA_MAX2 0.9

						#define TASK_DEADLINE2 (application_start_time+current_request.get_task_deadline()).to_seconds()
						/*#define TASK_BCET2 (sc_time_stamp()+(TLP*task_wcet)) //(sc_time_stamp()+(TLP*cost_energy_d[i][j][k]))
						#define TASK_BCETF2 (sc_time_stamp()+(TLP*task_wcet*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[k])))
						#define TASK_WCET2 (sc_time_stamp()+(2*TLP*task_wcet))
						#define TASK_WCETF2 (sc_time_stamp()+(2*TLP*task_wcet*(CPU_FREQUENCIES_STEPS[MAX_FREQ_STEPS-1]/CPU_FREQUENCIES_STEPS[k])))
						*/
						#define TASK_BCET2 (sc_time_stamp().to_seconds()+(TLP*cost_time_d[i][j][0])) //(sc_time_stamp()+(TLP*cost_energy_d[i][j][k]))
						#define TASK_BCETF2 (sc_time_stamp().to_seconds()+(TLP*cost_time_d[i][j][k]))
						#define TASK_WCET2 (sc_time_stamp().to_seconds()+(2*TLP*cost_time_d[i][j][0]))
						#define TASK_WCETF2 (sc_time_stamp().to_seconds()+(2*TLP*cost_time_d[i][j][k]))

						//if (current_cost<0) current_cost=0;
						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{

							//int k=0;

							cost_energy_d[i][j][0]+=current_energy;
							cost_time_d[i][j][0]+=execution_time.to_seconds();

							if (TASK_DEADLINE2<TASK_BCET2)
								cost_resource_d[i][j][0]=ALPHA_MIN2; //MAX PERF
							else
							if (TASK_DEADLINE2>TASK_WCET2)
								cost_resource_d[i][j][0]=ALPHA_MAX2; //MAX ENERGY
							else
								cost_resource_d[i][j][0]=(((TASK_DEADLINE2)-TASK_BCET2)/(TASK_WCET2-TASK_BCET2)*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);

							//cost_resource_d[i][j][0]=current_cost;

						}
						else
						{
							for (int k=0;k<MAX_FREQ_STEPS;k++)
							{

								cost_energy_d[i][j][k]+=current_energy;
								cost_time_d[i][j][k]+=execution_time.to_seconds();

								//cost_resource_d[i][j][k]=current_cost;
								if (TASK_DEADLINE2<TASK_BCETF2)
									cost_resource_d[i][j][k]=ALPHA_MIN2; //MAX PERF
								else
								if (TASK_DEADLINE2>TASK_WCETF2)
									cost_resource_d[i][j][k]=ALPHA_MAX2; //MAX ENERGY
								else
									cost_resource_d[i][j][k]=(((TASK_DEADLINE2)-TASK_BCETF2)/(TASK_WCETF2-TASK_BCETF2)*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);


							}
						}
					}
				}
			}
		}

		double max_energy=-1;
		double max_time=-1;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_energy_d[i][j][k] > max_energy)
						max_energy=cost_energy_d[i][j][k];
					if (cost_time_d[i][j][k] > max_time)
						max_time=cost_time_d[i][j][k];
				}
			}

		if (max_time==0) max_time=1;
		if (max_energy==0) max_energy=1;

		double alpha=0.5;

		scheduler.Scheduler_get_output_stream() << "  deadline: " << application_start_time +current_request.get_task_deadline() << " WCET : " << sc_time_stamp()+task_best_wcet << endl;
		/*if (application_start_time+current_request.get_task_deadline()>sc_time_stamp()+(task_best_wcet*1.5))
		{
			alpha=0.7;
			scheduler.Scheduler_get_output_stream() << "  energy mode" << endl;
		}
		else
		{
			alpha=0.3;
			scheduler.Scheduler_get_output_stream() << "  performance mode" << endl;
		}*/

		//#define ALPHA_MIN 0.1
		//#define ALPHA_MAX 0.9

		//#define TASK_DEADLINE (application_start_time+current_request.get_task_deadline())
		//#define TASK_BCET (sc_time_stamp()+(2*task_best_wcet))
		//#define TASK_WCET (sc_time_stamp()+(6*task_best_wcet))
		//#define TASK_BCET (sc_time_stamp()+(TLP*task_best_wcet))
		//#define TASK_WCET (sc_time_stamp()+(2*TLP*task_best_wcet))

		/*if (application_start_time+current_request.get_task_deadline()<sc_time_stamp()+(1.5*task_best_wcet))
			alpha=ALPHA_MIN; //MAX PERF
		else
		if (application_start_time+current_request.get_task_deadline()>sc_time_stamp()+(3*task_best_wcet))
			alpha=ALPHA_MAX; //E SAVING
		else
		{
			alpha=1-(((application_start_time+current_request.get_task_deadline())-(sc_time_stamp()+(1.5*task_best_wcet)))/(sc_time_stamp()+(3*task_best_wcet)-sc_time_stamp()+(1.5*task_best_wcet))*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);
		}*/

		/*if (TASK_DEADLINE<TASK_BCET)
			alpha=ALPHA_MIN; //MAX PERF
		else
		if (TASK_DEADLINE>TASK_WCET)
			alpha=ALPHA_MAX; //E SAVING
		else
		{
			alpha=1-(((TASK_DEADLINE)-TASK_BCET)/(TASK_WCET-TASK_BCET)*(ALPHA_MAX-ALPHA_MIN)+ALPHA_MIN);
		}
		*/


		double min_cost = 999;
		//int bestRZid=0;
		int bestFREQ=0;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_resource_d[i][j][k] != -1 && cost_energy_d[i][j][k] != -1)
					{
						scheduler.Scheduler_get_output_stream() << "      exectime: " << cost_time_d[i][j][k]*1000 << " endtime: " << (cost_time_d[i][j][k]+sc_time_stamp().to_seconds())*1000 << " deadline: " << TASK_DEADLINE2*1000 << endl;
						alpha=cost_resource_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << "      alpha mode" << alpha << endl;
						/*if (cost_time_d[i][j][k]*TLP+sc_time_stamp().to_seconds()>TASK_DEADLINE2.to_seconds())
						{
							cost_energy_d[i][j][k]+=max_energy;
						}*/

						scheduler.Scheduler_get_output_stream() << "        COST: " << i << "(" << compatible_RZs.at(i)->getName() << ") impl: " << j << " | ";

						if (compatible_RZs.at(i)->get_implementation_type()!=HARD)
							scheduler.Scheduler_get_output_stream() << CPU_FREQUENCIES_STEPS[k] <<"MHz  ";



						cost_energy_d[i][j][k] /= max_energy;
						cost_time_d[i][j][k] /= max_time;
						/*if (TASK_DEADLINE2-sc_time_stamp().to_seconds() != 0);
							cost_time_d[i][j][k] /= (TASK_DEADLINE2-sc_time_stamp().to_seconds());
						if (cost_time_d[i][j][k] < 0)
							cost_time_d[i][j][k] = -cost_time_d[i][j][k];
						*/
						scheduler.Scheduler_get_output_stream() << " energy: " << cost_energy_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << " time: " << cost_time_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << " alpha: " << alpha;


						cost_result_d[i][j][k]=alpha*cost_energy_d[i][j][k]+(1-alpha)*cost_time_d[i][j][k];//+cost_resource[i][j];
						if (cost_result_d[i][j][k] < min_cost)
						{
							min_cost = cost_result_d[i][j][k];
							bestRZ = compatible_RZs.at(i);
							//bestRZid = i;
							bestImplementationID = j;
							bestFREQ = k;
						}

						scheduler.Scheduler_get_output_stream() << " | result: " << cost_result_d[i][j][k] <<endl;

					}
				}
			}

		if (bestRZ != 0 && (scheduler.Scheduler_is_RZ_blank(bestRZ) || scheduler.Scheduler_get_task_state(bestRZ) == MAPPED || scheduler.Scheduler_get_task_state(bestRZ) == PREEMPTED_MAPPED ))
		{

		}
		else
			bestRZ=0;

	if(bestRZ != 0) {
		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() <<endl;
		mapping = Return_mapping_information(bestRZ, bestImplementationID, false);
		if (bestRZ->get_implementation_type()!=HARD)
			global_operating_point=bestFREQ;
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}


void printOperatingPoints(Scheduler_interface* scheduler, RZ* currentRZ)
{
	scheduler->Scheduler_get_output_stream() << "  "<< currentRZ->getName() <<" operating points : "  << endl;

	scheduler->Scheduler_get_output_stream() << "   - nom : "  << scheduler->Scheduler_get_rz_properties(currentRZ).getConfigDomain()->getNominalFctPoint().toString() << endl;

	vector<Config_fct_point*> configPointList=scheduler->Scheduler_get_rz_properties(currentRZ).getConfigDomain()->getFctPointList();
	scheduler->Scheduler_get_output_stream() << "   nb : "  << configPointList.size() << endl;

	int i=0;

	while (i < (int) configPointList.size())
	{
		//scheduler->Scheduler_get_output_stream() << "    additional op point : " << configPointList->at(i)->toString() << endl;
		scheduler->Scheduler_get_output_stream() << "   - add : "  << configPointList.at(i)->toString() << endl;
		i++;
	}

	scheduler->Scheduler_get_output_stream() << "   + cur : "  << scheduler->Scheduler_get_current_fct_point(currentRZ).toString() << endl;
	//scheduler->Scheduler_get_output_stream() << "  RZ "<< currentRZ->getName() <<" Current operating point : "  << scheduler->Scheduler_get_current_fct_point(currentRZ)->toString() << endl;

}

/* *********************************** */
/* Prend en compte la deadline et DVFS */

MAPPING_ALGORITHM(EA3dead3) {

	Return_mapping_information mapping;
	mapping.set_exit_mapping_algo(false);

	/* Get request with the highest priority inside waiting queue */
	SchedulerRequest current_request = scheduler.Scheduler_current_task_waiting();

	/* Retrieve task ID associated with scheduler request */
	int waiting_task_id = scheduler.Scheduler_get_module_ID(current_request);

	/* List of reconfigurable zones that fit waiting task id */
	vector<RZ *> compatible_RZs = scheduler.Scheduler_get_compatible_rz_vector(waiting_task_id);

	vector<RZ *> all_RZs = scheduler.Scheduler_get_all_rz_vector();

	int queueSize = (int) scheduler.Scheduler_get_waiting_queue_size();

	int TLP = ((int)queueSize/((int)all_RZs.size()));
	if (TLP*(int)all_RZs.size()!=(int)queueSize)
		TLP=TLP+1;

	int reconfiguration_manager_busy=0;


	RZ* implementation_RZ = 0;


	int bestImplementationID = -1;
	RZ* bestRZ = 0;
	//sc_time best_aggregate_time(SC_ZERO_TIME);

//	double current_Prun;
	double current_energy;
	//double best_aggregate_energy=99999;

	sc_time execution_time(SC_ZERO_TIME);


//	if(implementation_RZ == 0) {
	int i = 0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - Exploring... " ;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << " - TLP: " << TLP << endl;
		scheduler.Scheduler_get_output_stream() << "  Task: " << current_request.getName() << " Deadline : " << current_request.get_task_deadline() << endl;
		scheduler.Scheduler_get_output_stream() << "  App start: " << application_start_time << " Deadline : " << application_start_time+current_request.get_task_deadline() << endl;

		/*
		int max = scheduler.Scheduler_get_application_number();
		int k=0;
		scheduler.Scheduler_get_output_stream() << sc_time_stamp() << ": APP_IF : " << max << endl;
		while (k < max) {

			Application_interface* app = scheduler.Scheduler_get_application_interface(k);

			scheduler.Scheduler_get_output_stream()  << "     name : " << app->getName() << endl;

			k++;
		}*/

		i = 0;


		//check reconfiguration manager state
		// Permet d'ajouter un cout de temps de reconfiguration sur le temps de l'exécution estimé de la tâche courante SI le controleur est occupé
		// Pour le moment, on prend comme temps de reconfig de la tâche courante au lieu du temps restant de reconfiguration actuel
		//  |---cfg T1 ----|
		//            |-cfg T2---||-cfg T2---|
		//            <- erreur ->
		while(i < (int) all_RZs.size()) {
			if(	scheduler.Scheduler_is_RZ_blank(all_RZs.at(i)))
			{}
			else
				if(scheduler.Scheduler_get_task_state(all_RZs.at(i)) == QUEUED || scheduler.Scheduler_get_task_state(all_RZs.at(i)) == CONFIG)
					reconfiguration_manager_busy=1;
			i++;
		}//*/

		//init cost tab
		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					cost_energy_d[i][j][k]=-1;
					cost_time_d[i][j][k]=-1;
					cost_resource_d[i][j][k]=-1;
					cost_result_d[i][j][k]=-1;
				}
			}

		i = 0;
		sc_time task_best_wcet(10,SC_SEC);

		for(unsigned int i = 0; i < compatible_RZs.size(); i++)
		{
			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << "blank" << endl;
			else
				scheduler.Scheduler_get_output_stream() << "    RZname: " << compatible_RZs.at(i)->getName()<< " - RZState: " << scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) << endl;


			/* Le IF ne sert peut être à rien (à vérifier s'il y a d'autres constantes) */
			if(	scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) ||  //check if RZ is blank
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || //if not, is it free?
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == RUNNING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONFIG ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == QUEUED ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == WAITING ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == CONTEXT_RESTORE ||
				scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == IDLE	//*/
				)
			{
				//compatible RZ found, check implementation possibilities
				implementation_RZ = compatible_RZs.at(i);
				sc_time task_wcet(SC_ZERO_TIME);

				vector<TaskImplementation> taskVector(compatible_RZs.at(i)->getTaskImplementationVector());
				for(int j = 0; j < (int) taskVector.size(); j++)
				{
					if (current_request.has_implementation(taskVector.at(j)))
					{
						scheduler.Scheduler_get_output_stream() << "      Implementation: " << taskVector.at(j).getImplementationName() << " Task Name : "<< taskVector.at(j).getTaskName() << endl;

						//check application parallelism : TODO make it without specific names!
						// Permet de parallèliser les taches suivant le nombre de slice (on divise le temps d'exe de la tache par le degré de parallèlisme)
/*
						if (taskVector.at(j).getTaskName().find("ICAVLC_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("IQTr_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("Inv_Pred_1")!=string::npos ||
							taskVector.at(j).getTaskName().find("DBF_1")!=string::npos)
						{
							task_wcet=taskVector.at(j).getWorstCaseExecutionTime()/NB_SLICES_APPLICATION;
							scheduler.Scheduler_get_output_stream() << "      Implementation: is sliced" << endl;
						}
						else
*/
						task_wcet=taskVector.at(j).getWorstCaseExecutionTime();

						//compute energy/time cost
						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							// P_RECONF : conso de FaRM (mW)
							double running_energy=taskVector.at(j).getPrun()*task_wcet.to_seconds();
							double reconf_energy=P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();

							TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
							if ((taskVector.at(j).hasSameNetlist(taskImpl)== true)&& !scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
							{
								if (taskVector.at(j).getTaskName().find("blank")!=string::npos)
								{
									// voir graphique (module "blank"), permet de gérer le blank avec le temps de reconfig lorsque le blank n'était pas dans FoRTReSS.
									// blank est une tâche de conso 0 mW. Il faut la mettre dynamique pour le bon fonctionnement
									current_energy=running_energy+reconf_energy;
									execution_time=task_wcet+taskVector.at(j).getCompressedReconfigurationTime();
								}
								else
								{
									current_energy=running_energy;
									execution_time=task_wcet;
								}

								scheduler.Scheduler_get_output_stream() << "        hard : " << running_energy<< "mJ" << " time: " << execution_time <<endl;
							}
							else
							{
								// Bitstream différent
								scheduler.Scheduler_get_output_stream() << "        Tasks in waiting list? : " << currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)) <<endl;

								if (taskVector.at(j).getTaskName().find("blank")!=string::npos)
									current_energy=running_energy;	// tache "blank" donc current_energy = 0 puisque Prun = 0
								else {
									//  currentTaskInWaitingList() renvoie le nombre de taches dans la waiting list qui ont la même implémentation que la tâche courante
									// et donc, on divise le reconf_energy par ce nombre (estimation ...)
									current_energy=running_energy+reconf_energy/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));
								}
								execution_time=task_wcet+ taskVector.at(j).getCompressedReconfigurationTime()/(currentTaskInWaitingList(&scheduler, implementation_RZ, taskVector.at(j)));

								#ifdef STRATEGY_STATIC
								// Si pas blank, augmente le cout
								if (!scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)))
									current_energy+=running_energy+reconf_energy; //static hack
								#endif

								scheduler.Scheduler_get_output_stream() << "        hard : " << reconf_energy << "mJ + " << running_energy << "mJ = " << current_energy<< " time: " << taskVector.at(j).getCompressedReconfigurationTime() << " + " << taskVector.at(j).getWorstCaseExecutionTime() << " = " << execution_time <<endl;
							}

						cost_energy_d[i][j][0]=current_energy;
						cost_time_d[i][j][0]=execution_time.to_seconds();


						}
						else //SOFT
						{

							int k=0;

							Config_fct_point configPoint, nominalPoint;
							nominalPoint = scheduler.Scheduler_get_rz_properties(implementation_RZ).getConfigDomain()->getNominalFctPoint();
							configPoint = scheduler.Scheduler_get_rz_properties(implementation_RZ).getConfigDomain()->getNominalFctPoint();

							vector<Config_fct_point*> addconfigPointList=scheduler.Scheduler_get_rz_properties(implementation_RZ).getConfigDomain()->getFctPointList();

							vector<Config_fct_point*> configPointList;
							//configPointList = new vector<Config_fct_point*>;

							configPointList.push_back(&nominalPoint);
							while (k < (int) addconfigPointList.size())
							{
								configPointList.push_back(addconfigPointList.at(k));
								k++;
							}

							k=0;
							while (k < (int) configPointList.size())
							{

								configPoint = configPointList.at(k);
								/// modifier : PM_CPU_BETA
								double cpu_run_power=PM_CPU_BETA*configPoint.getVoltage()*configPoint.getVoltage()*1*configPoint.getFrequency();
								current_energy=cpu_run_power*(task_wcet.to_seconds());
								execution_time=task_wcet*(nominalPoint.getFrequency()/configPoint.getFrequency());
								scheduler.Scheduler_get_output_stream() << "        soft : " << current_energy << "mJ" << " Execution time: " << execution_time << "@" << configPoint.getFrequency() << "MHz" << endl;

								cost_energy_d[i][j][k]=current_energy;
								cost_time_d[i][j][k]=execution_time.to_seconds();

								k++;
							}

						}


						current_energy=0;
						execution_time=SC_ZERO_TIME;


						// add time cost if reconfiguration controller is busy
						TaskImplementation taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if (implementation_RZ->get_implementation_type()==HARD && reconfiguration_manager_busy!=0 && (taskVector.at(j).hasSameNetlist(taskImpl)== false))
						{
							scheduler.Scheduler_get_output_stream() << "        Controler busy" <<endl;
							current_energy+=0;
							execution_time+=taskVector.at(j).getCompressedReconfigurationTime(); // !!!!!!!!! Example! Must be modified with estimated end of time
						}

						// add time cost if RZ busy
						if (scheduler.Scheduler_is_RZ_blank(compatible_RZs.at(i)) || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == MAPPED || scheduler.Scheduler_get_task_state(compatible_RZs.at(i)) == PREEMPTED_MAPPED )
						{}
						else
						{
							scheduler.Scheduler_get_output_stream() << "        RZ busy" <<endl;
							execution_time+=task_wcet/2; //example : il faudrait le remaining time estimated de la tache en cours sur la RZ courante au lieu de task_wcet/2
						}

						// add cost if the current RZ implementation is the same of at least one we have in the waiting list but we currently evaluate to reconfigure another implementation and the need to reconfigure again later
						taskImpl = compatible_RZs.at(i)->getCurrentImplementation();
						if ((implementedTaskInWaitingList(&scheduler, implementation_RZ))>=1 && (taskVector.at(j).hasSameNetlist(taskImpl)== false) && implementation_RZ->get_implementation_type()==HARD )
						{
							//estimate cost to do this at one more reconf.
							current_energy+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*P_RECONF*taskVector.at(j).getCompressedReconfigurationTime().to_seconds();
							execution_time+=implementedTaskInWaitingList(&scheduler, implementation_RZ)*taskVector.at(j).getCompressedReconfigurationTime();
							scheduler.Scheduler_get_output_stream() << "        RZ holds future implementations" <<endl;

						}

						#define ALPHA_MIN3 0.1
						#define ALPHA_MAX3 0.9

						#define TASK_DEADLINE3 (application_start_time+current_request.get_task_deadline()).to_seconds()

						#define TASK_BCET3 (sc_time_stamp().to_seconds()+(TLP*cost_time_d[i][j][0])) //(sc_time_stamp()+(TLP*cost_energy_d[i][j][k]))
						#define TASK_BCETF3 (sc_time_stamp().to_seconds()+(TLP*cost_time_d[i][j][k]))
						#define TASK_WCET3 (sc_time_stamp().to_seconds()+(2*TLP*cost_time_d[i][j][0]))
						#define TASK_WCETF3 (sc_time_stamp().to_seconds()+(2*TLP*cost_time_d[i][j][k]))

						//compute alpha (energy VS time cost) value for each solution regarding the task's deadline value.
						if (compatible_RZs.at(i)->get_implementation_type()==HARD)
						{
							cost_energy_d[i][j][0]+=current_energy;
							cost_time_d[i][j][0]+=execution_time.to_seconds();

							if (TASK_DEADLINE3<TASK_BCET3)
								cost_resource_d[i][j][0]=ALPHA_MIN3; //MAX PERF
							else
							if (TASK_DEADLINE3>TASK_WCET3)
								cost_resource_d[i][j][0]=ALPHA_MAX3; //MAX ENERGY
							else
								cost_resource_d[i][j][0]=(((TASK_DEADLINE3)-TASK_BCET3)/(TASK_WCET3-TASK_BCET3)*(ALPHA_MAX3-ALPHA_MIN3)+ALPHA_MIN3);
						}
						else
						{
							for (int k=0;k<MAX_FREQ_STEPS;k++)
							{

								cost_energy_d[i][j][k]+=current_energy;
								cost_time_d[i][j][k]+=execution_time.to_seconds();

								if (TASK_DEADLINE3<TASK_BCETF3)
									cost_resource_d[i][j][k]=ALPHA_MIN3; //MAX PERF
								else
								if (TASK_DEADLINE3>TASK_WCETF3)
									cost_resource_d[i][j][k]=ALPHA_MAX3; //MAX ENERGY
								else
									cost_resource_d[i][j][k]=(((TASK_DEADLINE3)-TASK_BCETF3)/(TASK_WCETF3-TASK_BCETF3)*(ALPHA_MAX3-ALPHA_MIN3)+ALPHA_MIN3);


							}
						}
					}
				}
			}
		}


		// get max time cost and energy cost to further normalize
		double max_energy=-1;
		double max_time=-1;

		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_energy_d[i][j][k] > max_energy)
						max_energy=cost_energy_d[i][j][k];
					if (cost_time_d[i][j][k] > max_time)
						max_time=cost_time_d[i][j][k];
				}
			}

		if (max_time==0) max_time=1;
		if (max_energy==0) max_energy=1;

		double alpha=0.5;

		scheduler.Scheduler_get_output_stream() << "  deadline: " << application_start_time +current_request.get_task_deadline()  << endl;


		double min_cost = 999;
		//int bestRZid=0;
		unsigned int bestFREQ=0;


		// find lowest cost solution!
		for (int i=0;i<MAX_RZ;i++)
			for (int j=0;j<MAX_IMPL;j++)
			{
				for (int k=0;k<MAX_FREQ_STEPS;k++)
				{
					if (cost_resource_d[i][j][k] != -1 && cost_energy_d[i][j][k] != -1)
					{
						scheduler.Scheduler_get_output_stream() << "      exectime: " << cost_time_d[i][j][k]*1000 << " endtime: " << (cost_time_d[i][j][k]+sc_time_stamp().to_seconds())*1000 << " deadline: " << TASK_DEADLINE2*1000 << endl;
						alpha=cost_resource_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << "      alpha mode" << alpha << endl;

						scheduler.Scheduler_get_output_stream() << "        COST: " << i << "(" << compatible_RZs.at(i)->getName() << ") impl: " << j << " | ";

						//if (compatible_RZs.at(i)->get_implementation_type()!=HARD)
						//	scheduler.Scheduler_get_output_stream() << CPU_FREQUENCIES_STEPS[k] <<"MHz  ";



						cost_energy_d[i][j][k] /= max_energy;
						cost_time_d[i][j][k] /= max_time;

						scheduler.Scheduler_get_output_stream() << " energy: " << cost_energy_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << " time: " << cost_time_d[i][j][k];
						scheduler.Scheduler_get_output_stream() << " alpha: " << alpha;


						cost_result_d[i][j][k]=alpha*cost_energy_d[i][j][k]+(1-alpha)*cost_time_d[i][j][k];//+cost_resource[i][j];
						if (cost_result_d[i][j][k] < min_cost)
						{
							min_cost = cost_result_d[i][j][k];
							bestRZ = compatible_RZs.at(i);
							//bestRZid = i;
							bestImplementationID = j;
							bestFREQ = k;
						}

						scheduler.Scheduler_get_output_stream() << " | result: " << cost_result_d[i][j][k] <<endl;

					}
				}
			}

		printOperatingPoints(&scheduler, bestRZ);
		//scheduler.Scheduler_get_output_stream() << "  RZ "<< bestRZ->getName() <<" operating point : "  << scheduler.Scheduler_get_rz_properties(bestRZ)->getConfigDomain()->getctPointList()->at(0)->toString() << endl;
		//do not implement if RZ is not free
		if (bestRZ != 0 && (scheduler.Scheduler_is_RZ_blank(bestRZ) || scheduler.Scheduler_get_task_state(bestRZ) == MAPPED || scheduler.Scheduler_get_task_state(bestRZ) == PREEMPTED_MAPPED ))
		{
			//ok keep implementation
		}
		else
			bestRZ=0; //do not implement - it will be done in one of the next scheduler calls.


	//return implementation
	if(bestRZ != 0) {

		vector<Config_fct_point*> addconfigPointList=scheduler.Scheduler_get_rz_properties(bestRZ).getConfigDomain()->getFctPointList();

		vector<Config_fct_point*> configPointList;
		//configPointList = new vector<Config_fct_point*>;

		configPointList.push_back(&scheduler.Scheduler_get_rz_properties(bestRZ).getConfigDomain()->getNominalFctPoint());

		int k=0;
		while (k < (int) addconfigPointList.size())
		{
			configPointList.push_back(addconfigPointList.at(k));
			k++;
		}
		Config_fct_point *newconfigPoint;
		if (bestFREQ <= configPointList.size())
			newconfigPoint = configPointList.at(bestFREQ);
		else
		{
			scheduler.Scheduler_get_output_stream() << "Cfg Point ERROR!!! Nominal point taken" << endl;
			newconfigPoint = configPointList.at(0); //nominal default
		}


		scheduler.Scheduler_get_output_stream() << "  Implementation Selected : " << bestRZ->getTaskImplementationVector().at(bestImplementationID).getFullName() << " - on : " << bestRZ->getName() ;
		scheduler.Scheduler_get_output_stream() << newconfigPoint->toString() <<endl;

		mapping = Return_mapping_information(bestRZ, bestImplementationID, newconfigPoint, false);
		if (bestRZ->get_implementation_type()!=HARD)
			global_operating_point=bestFREQ;
	}
	else
		scheduler.Scheduler_get_output_stream() << "  No Implementation" <<endl;

return mapping;
}



