/**
  * @file    Follow_Task.h
  * @author  XXX
  * @version 1.0
  * @date    December 9, 2014 11:30:51 AM CET
  * @section DESCRIPTION
  * 
  * User Algorithms files of Main_Task
  */



#ifndef FOLLOW_TASK_MODULE_ALGORITHMS_FILE_H
#define FOLLOW_TASK_MODULE_ALGORITHMS_FILE_H

#include "user_algorithm_interface.h"

/*****************************************************************************/
/**************************  BEGIN USER SPACE ********************************/

template<int Ni, int No>
void Follow_Task(User_algorithm_interface<Ni, No> &user_algo_interface) {
	// Sw Default behavior
	srand ((unsigned int)sc_time_stamp().to_double());	
	user_algo_interface.get_logfile() << sc_time_stamp() << "init srand" << endl;
	
	

	while(true) {

		/*******************************************************************************/
		/****                    MANDATORY PART (EXCEPT DISPLAY)                    ****/

	

		/* WAIT FOR START ALGORITHM EVENT : Only for Dynamic tasks */
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Beginning of loop" << endl;
#endif
		current_time_state = tasks_execution_time;
		user_algo_interface.b_execution_requested();
		
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Execution requested" << endl;
#endif

		/* TRACE : The algorithm is idle in order to have an accurate trace */
		user_algo_interface.set_algorithm_idle();

		/* WAIT FOR NEXT PERIOD to begin to start algorithm execution. For non-periodic modules, function returns right away */
		user_algo_interface.wait_until_next_period();
		
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " New period started" << endl;
#endif
		user_algo_interface.set_algorithm_waiting();

		/**** BEGINNING OF DATA RECEPTION SEGMENT ****/

		user_algo_interface.b_all_data_received();

		user_algo_interface.set_algorithm_running();

		/**** END OF DATA RECEPTION SEGMENT ****/

		/**** BEGINNING OF USER ALGORITHM ****/

	#ifdef PARALLEL_BEHV

		string app_p = extractApplicationName(user_algo_interface.get_top_application_name());
		sc_semaphore *sem;
		stringstream ss;
		for (int i=0; i<NB_SCALES_FOLLOW_TASK; i++) {     			
			ss << i;
        		string str = ss.str(); ss.str("");

			user_algo_interface.get_logfile() << sc_time_stamp() << ": " << " BEGIN Hierarchical task notified from " << user_algo_interface.get_name() << endl;
			sem = hierarchical_sem_map[app_p + "_1" + str + FOLLOW_TASK + HSEM_IN];
			sem->post(); 
			wait(SC_ZERO_TIME); 
		}

		for (int i=0; i<NB_SCALES_FOLLOW_TASK; i++) {	
			ss << i;
        		string str = ss.str(); ss.str("");

			sem = hierarchical_sem_map[app_p + "_1" + str + FOLLOW_TASK + HSEM_OUT];
			sem->wait(); 
			wait(SC_ZERO_TIME);
			user_algo_interface.get_logfile() << sc_time_stamp() << ": " << " END Hierarchical task released from " << user_algo_interface.get_name() << endl;
		}

	#else
		for (int i=0; i<NB_SCALES_FOLLOW_TASK; i++) {

			user_algo_interface.get_logfile() << sc_time_stamp() << ": " << " BEGIN Hierarchical task notified from " << user_algo_interface.get_name() << endl;
	
			string app_p = extractApplicationName(user_algo_interface.get_top_application_name());
			sc_semaphore *sem = hierarchical_sem_map[app_p + FOLLOW_TASK + HSEM_IN];
			sem->post(); 
			wait(SC_ZERO_TIME); 
			
			sem = hierarchical_sem_map[app_p + FOLLOW_TASK + HSEM_OUT];
			sem->wait(); 
			wait(SC_ZERO_TIME);

			user_algo_interface.get_logfile() << sc_time_stamp() << ": " << " END Hierarchical task released from " << user_algo_interface.get_name() << endl;
		}
	#endif

		/**** END OF USER ALGORITHM ****/


		// Check that all data issued from previous algorithm execution has been processed and sent
		user_algo_interface.b_all_data_sent();

		// When all data is sent, indicate that a new sequence starts now
		// MUST BE DONE ONLY AFTER VERIFYING THAT ALL PREVIOUS DATA HAVE BEEN SENT
		user_algo_interface.start_new_transaction_sequence();

		// Find a channel that is not transient and has updated data
		int channel_id = 0;
		while(user_algo_interface.is_channel_transient(channel_id) || !user_algo_interface.nb_data_received(channel_id)) channel_id++;

		// Copy data
		int data_in_length = 0;
		int data_out_length = 0;
		for(int i = 0; i < No; i++) {
			data_in_length = user_algo_interface.get_data_in_length(channel_id);
			data_out_length = user_algo_interface.get_data_out_length(i);

			if(data_out_length <= data_in_length) {
				memcpy(user_algo_interface.get_data_out_ptr(i), user_algo_interface.get_data_in_ptr(channel_id), data_out_length);
			} else {
				memcpy(user_algo_interface.get_data_out_ptr(i), user_algo_interface.get_data_in_ptr(channel_id), data_in_length);
				for(int j = data_in_length; j < data_out_length; j+=4) user_algo_interface.get_data_out_ptr(i)[j/4] = 0;
			}
			
			user_algo_interface.set_address_out(i, user_algo_interface.get_address_in(channel_id));
		}

		// Release input sockets (we won't need their data anymore) for they are used by preceding modules again
		user_algo_interface.release_all_input_sockets();

		// Notify RZ to continue processing
		user_algo_interface.end_of_algorithm();

		// Send data to all sockets
		user_algo_interface.nb_send_all_data();


		// Wait for the event notifying a possible change in the user algorithm thread
		user_algo_interface.wait_for_update_user_algorithm();
#ifdef GENERATE_LOG_FILE
		user_algo_interface.get_logfile() << sc_time_stamp() << ": " << user_algo_interface.get_name() << " Update user algorithm event received" << endl;
#endif

		if(user_algo_interface.kill_user_algorithm()) {
#ifdef GENERATE_LOG_FILE
			user_algo_interface.get_logfile() << user_algo_interface.get_name() << " User algorithm thread has to be killed!" << endl;
#endif
			return;
		}
	}

}

/**************************  END USER SPACE ********************************/
/***************************************************************************/

#endif
