@ Fichier td5.s  
@ arm-none-eabi-as -g -o td5.o td5.s
@ arm-none-eabi-ld -o td5.elf td5.o

										@directives de compilation
			.text
			.align 4
	
			.global _start
										@section de données
MAT:		.word	1, 2, 3, 4, 5, 6, 7, 8, 9	
MAT_T:		.word	0, 0, 0, 0, 0, 0, 0, 0, 0
M:			.word	3

										@section de code
_start :	
			ADR		R0, MAT
			STR 	R0, [SP, #-4]! 		@ passage des parametres par la pile
			ADR		R0, MAT_T
			STR 	R0, [SP, #-4]!
			LDR		R0, M
			STR 	R0, [SP, #-4]!
			BL		TRANSPOSE
			ADD		SP, SP, #12			@ efface les parametres de la pile

			BX		LR	  				@ Fin du programme


GET: 		@ resultat renvoye dans R6
			STMFD	SP!, {R1, R2, R3, R4, R5, LR}
										@ lecture des parametres @MAT, M, I et J dans la pile
			LDR		R1, [SP, #36]		@ R0 <- @MAT
			LDR		R2, [SP, #32]		@ R2 <- M
			LDR		R3, [SP, #28]		@ R3 <- I
			LDR		R4, [SP, #24]		@ R4 <- J
			MUL		R5, R4, R2			@ R5 <- J*M
			ADD		R5, R5, R3			@ R5 <-  J*M + I
			LDR		R6, [R1, R5, LSL#2]	@ R6 <- mem[@MAT+((J*M+I)*4)}
			LDMFD	SP!, {R1, R2, R3, R4, R5, LR}
			MOV		PC, LR

SET: 		
			STMFD	SP!, {R0, R1, R2, R3, R4, R5, R6, LR}
										@ lecture des parametres @MAT_T, M, I, J et VAL dans la pile
			LDR		R0, [SP, #48]		@ R0 <- @MAT
			LDR		R2, [SP, #44]		@ R2 <- M
			LDR		R3, [SP, #40]		@ R3 <- I
			LDR		R4, [SP, #36]		@ R4 <- J
			LDR		R5, [SP, #32]		@ R5 <- VAL
			MUL		R6, R4, R2			@ R6 <- J*M
			ADD		R6, R6, R3			@ R6 <-  J*M + I
			STR		R5, [R0, R6, LSL#2]	@ R5 <- mem[@MAT+((J*M+I)*4)}
			LDMFD	SP!, {R0, R1, R2, R3, R4, R5, R6, LR}
			MOV		PC, LR

TRANSPOSE: 
			STMFD	SP!, {R0, R3, R4, R6, R7, LR}
										@ lecture des parametres @MAT, @MAT_T, M dans la pile
			LDR		R0, [SP, #32]		@ R0 <- adresse MAT
			LDR		R1, [SP, #28]		@ R1 <- adresse MAT_T
			LDR		R2, [SP, #24]		@ R2 <- M
			MOV		R4, #0	@ j
FOR_J: 		MOV		R3, #0	@ i
FOR_I:		STR 	R0, [SP, #-4]!		@ passage du parametre @MAT par la pile
			STR 	R2, [SP, #-4]!		@ passage du parametre M par la pile
			STR 	R3, [SP, #-4]!		@ passage du parametre I par la pile
			STR 	R4, [SP, #-4]!		@ passage du parametre J par la pile
			BL		GET
			ADD		SP, SP, #16			@ efface les parametres de la pile
			STR 	R1, [SP, #-4]!		@ passage du parametre @MAT_T par la pile
			STR 	R2, [SP, #-4]!		@ passage du parametre M par la pile
			STR 	R4, [SP, #-4]!		@ passage du parametre J par la pile (permutation I <-> J)
			STR 	R3, [SP, #-4]!		@ passage du parametre I par la pile (permutation J <-> I)
			STR 	R6, [SP, #-4]!		@ passage du parametre VAL par la pile 
			BL		SET
			ADD		SP, SP, #20			@ efface les parametres de la pile
			ADD		R3, R3, #1
			CMP		R3, R2
			BLT		FOR_I
			ADD		R4, R4, #1
			CMP		R4, R2
			BLT		FOR_J
			LDMFD	SP!, {R0, R3, R4, R6, R7, LR}
			MOV		PC, LR

