/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : WIDGET_Amplifier.c
Purpose     : Shows how to create a radial menu with motion support
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include "DIALOG.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define ID_WIN_0        (GUI_ID_USER + 0x00)

#define AMP_COLOR_GRAY   0x4C4B4D
#define AMP_COLOR_GREEN  0x00E800
#define AMP_COLOR_YELLOW 0x46D6FF

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  int x;
  int y;
  int Pressed;
  int Delay;
} ANIM;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       Knob 140x140
*/
static GUI_CONST_STORAGE unsigned long _acknob_gray_trans_140x140[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF7F7F7, 
        0xFFF6F6F6, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFF0F0F0, 0xFFEEEEEE, 0xFFEBEBEB, 0xFFE7E7E7, 0xFFE3E3E3, 0xFFDFDFDF, 0xFFDDDDDD, 0xFFDCDCDC, 0xFFD8D8D8, 0xFFD3D3D3, 0xFFCDCCCE, 0xFFC8C7C9, 0xFFC4C3C5, 0xFFC3C2C4, 0xFFB9B8BC, 0xE6B8B7BB, 0xC2B7B6BA, 
        0xA1B6B5B9, 0x83B7B6BA, 0x67B8B7BB, 0x4FB9B8BC, 0x39BAB9BD, 0x27C2C1C5, 0x18C3C2C6, 0x0CC5C4C8, 0x04C7C6CA, 0x00C7C6CA, 0x04C5C4C8, 0x0CC4C3C7, 0x18C2C1C5, 0x27C0BFC3, 0x39C0BFC3, 0x4FBFBEC2, 0x67BFBEC2, 0x83BFBEC2, 0xA1C0BFC3, 0xC2C0BFC3, 
        0xE6C0BFC1, 0xFFC6C6C6, 0xFFC7C7C7, 0xFFC9C9C9, 0xFFCCCCCC, 0xFFD0D0D0, 0xFFD4D4D4, 0xFFD9D9D9, 0xFFDCDCDC, 0xFFE0E0E0, 0xFFE3E3E3, 0xFFE7E7E7, 0xFFEAEAEA, 0xFFEDEDED, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF6F6F6, 0xFFF7F7F7, 0xFFF8F8F8, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF4F4F4, 
        0xFFF3F3F3, 0xFFEFEFEF, 0xFFEDEDED, 0xFFE9E9E9, 0xFFE6E6E6, 0xFFE3E3E3, 0xFFDFDFDF, 0xFFDADADA, 0xFFD6D6D6, 0xFFCECECE, 0xFFCBCBCB, 0xFFC5C5C5, 0xFFBBBBBB, 0xF5B0AFB1, 0xC2A6A5A7, 0x929F9EA0, 0x649D9C9E, 0x38A5A4A8, 0x0EA5A4A8, 0x00A7A6AA, 
        0x00AAA9AD, 0x00AEADB1, 0x00B2B1B5, 0x00B6B4BA, 0x00B9B7BD, 0x00BFBEC2, 0x00C1C0C4, 0x00C5C4C8, 0x00C8C7CB, 0x00C9C8CC, 0x00C8C7CB, 0x00C6C5C9, 0x00C5C4C8, 0x00C4C3C7, 0x00C3C2C6, 0x00C1C0C4, 0x00BFBEC2, 0x00BDBCC0, 0x00BBBABE, 0x00B9B8BC, 
        0x0EB9B8BC, 0x38B5B4B6, 0x64B7B7B7, 0x92B9B9B9, 0xC2BCBCBC, 0xF5C1C1C1, 0xFFC6C6C6, 0xFFCCCCCC, 0xFFD0D0D0, 0xFFD6D6D6, 0xFFD9D9D9, 0xFFDEDEDE, 0xFFE2E2E2, 0xFFE5E5E5, 0xFFE9E9E9, 0xFFEDEDED, 0xFFF1F1F1, 0xFFF3F3F3, 0xFFF4F4F4, 0xFFF7F7F7, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFF3F3F3, 0xFFF2F2F2, 
        0xFFEBEBEB, 0xFFE9E9E9, 0xFFE4E4E4, 0xFFDFDFDF, 0xFFDADADA, 0xFFD6D6D6, 0xFFD0D0D0, 0xFFCACACA, 0xFFC6C6C6, 0xFFAEADAF, 0xD8A1A0A2, 0x9D929193, 0x638C8B8D, 0x2B8E8D8F, 0x00929193, 0x00969597, 0x0099989A, 0x009E9DA1, 0x00A09FA3, 0x00A4A3A7, 
        0x00A8A7AB, 0x00ABA9AF, 0x00AFADB3, 0x00B4B2B8, 0x00B7B5BB, 0x00BCBBBF, 0x00BDBCC0, 0x00BFBEC2, 0x00C4C3C7, 0x00C8C7CB, 0x00CAC9CD, 0x00C9C8CC, 0x00C7C6CA, 0x00C3C2C6, 0x00C2C1C5, 0x00C0BFC3, 0x00BFBEC2, 0x00BFBEC2, 0x00BEBDC1, 0x00BDBCC0, 
        0x00BCBBBF, 0x00B8B7B9, 0x00B7B6B8, 0x00B7B6B8, 0x00B5B4B6, 0x2BB2B1B3, 0x63B1B0B2, 0x9DB6B5B7, 0xD8BCBBBD, 0xFFC6C5C7, 0xFFC9C8CA, 0xFFCFCED0, 0xFFD5D4D6, 0xFFD9D8DA, 0xFFDDDCDE, 0xFFE4E3E5, 0xFFEAE9EB, 0xFFEDEDED, 0xFFEEEEEE, 0xFFF1F1F1, 
        0xFFF5F5F5, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFF3F3F3, 0xFFF0F0F0, 0xFFF2F2F2, 0xFFEAEAEA, 0xFFE2E2E2, 
        0xFFE5E5E5, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD5D5D5, 0xFFCDCDCD, 0xFFC5C5C5, 0xFFB7B7B7, 0xDC9C9C9C, 0x99828282, 0x57828183, 0x17818082, 0x00848385, 0x008A898B, 0x00908F91, 0x00929193, 0x00949395, 0x00959496, 0x009E9DA1, 0x00A09FA3, 0x00A3A2A6, 
        0x00A6A5A9, 0x00A8A6AC, 0x00ABA9AF, 0x00AEACB2, 0x00B0AFB3, 0x00B7B6BA, 0x00B8B7BB, 0x00BBBABE, 0x00C0BFC3, 0x00C4C3C7, 0x00C6C5C9, 0x00C7C6CA, 0x00C6C5C9, 0x00C6C5C9, 0x00C5C4C8, 0x00C4C3C7, 0x00C2C1C5, 0x00C1C0C4, 0x00BEBDC1, 0x00BBBABE, 
        0x00B9B8BC, 0x00BCBBBD, 0x00BAB9BB, 0x00B7B6B8, 0x00B4B3B5, 0x00B0AFB1, 0x00ADACAE, 0x00AFAEB0, 0x17B3B2B4, 0x57B1B0B2, 0x99B5B4B6, 0xDCBEBDBF, 0xFFC8C7C9, 0xFFD0CFD1, 0xFFD5D4D6, 0xFFDAD9DB, 0xFFDEDDDF, 0xFFE3E3E3, 0xFFE7E7E7, 0xFFEDEDED, 
        0xFFF0F0F0, 0xFFF2F2F2, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFEEEEEE, 0xFFEFEFEF, 0xFFF2F2F2, 0xFFEAEAEA, 0xFFE4E4E4, 0xFFDFDFDF, 
        0xFFD3D3D3, 0xFFD6D6D6, 0xFFD1D1D1, 0xFFBDBDBD, 0xFF9C9C9C, 0xB47E7E7E, 0x6B707070, 0x23717171, 0x00777777, 0x0079787A, 0x007B7A7C, 0x007E7D7F, 0x00838284, 0x00868587, 0x008A898B, 0x008F8E90, 0x00949395, 0x00949397, 0x0097969A, 0x009C9B9F, 
        0x00A1A0A4, 0x00A6A5A9, 0x00AAA9AD, 0x00AEADB1, 0x00B1B0B4, 0x00B2B1B5, 0x00B5B4B6, 0x00B9B8BA, 0x00BDBCBE, 0x00C1C0C2, 0x00C4C3C5, 0x00C7C6C8, 0x00C8C7C9, 0x00C8C7C9, 0x00C6C5C7, 0x00C3C2C4, 0x00C1C0C2, 0x00C0BFC1, 0x00BFBEC0, 0x00BEBDBF, 
        0x00BEBDBF, 0x00BAB9BB, 0x00BAB9BB, 0x00BAB9BB, 0x00BAB9BB, 0x00B7B6B8, 0x00B3B2B4, 0x00B1B0B2, 0x00B0AFB1, 0x00ABAAAC, 0x00AAA9AB, 0x23ACABAD, 0x6BB2B1B3, 0xB4B9B8BA, 0xFFC1C0C2, 0xFFCAC9CB, 0xFFD1D0D2, 0xFFDADADA, 0xFFDDDDDD, 0xFFE1E1E1, 
        0xFFE7E7E7, 0xFFECECEC, 0xFFF1F1F1, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFECECEC, 0xFFF6F6F6, 0xFFECECEC, 0xFFDEDEDE, 0xFFDEDEDE, 0xFFD9D9D9, 0xFFCFCFCF, 
        0xFFCFCFCF, 0xFFB6B6B6, 0xEC929292, 0x9C6F6F6F, 0x4D666666, 0x006A6A6A, 0x006D6D6D, 0x006F6F6F, 0x00747474, 0x00757476, 0x007A797B, 0x00807F81, 0x00848385, 0x00868587, 0x00888789, 0x008B8A8C, 0x008E8D8F, 0x00939296, 0x0097969A, 0x009B9A9E, 
        0x009F9EA2, 0x00A2A1A5, 0x00A4A3A7, 0x00A7A6AA, 0x00A9A8AA, 0x00B2B1B3, 0x00B5B4B6, 0x00BAB9BB, 0x00BDBCBE, 0x00C0BFC1, 0x00C4C3C5, 0x00C8C7C9, 0x00CCCBCD, 0x00C9C8CA, 0x00C8C7C9, 0x00C7C6C8, 0x00C6C5C7, 0x00C4C3C5, 0x00C2C1C3, 0x00C0BFC1, 
        0x00BFBEC0, 0x00C0BFC1, 0x00BDBCBE, 0x00B9B8BA, 0x00B7B6B8, 0x00B6B5B7, 0x00B4B3B5, 0x00B3B2B4, 0x00B2B1B3, 0x00B2B1B3, 0x00AEADAF, 0x00AAA9AB, 0x00A8A7A9, 0x00A9A8AA, 0x4DAEADAF, 0x9CB7B6B8, 0xECBFBEC0, 0xFFC9C9C9, 0xFFD0D0D0, 0xFFD8D8D8, 
        0xFFDFDFDF, 0xFFE3E3E3, 0xFFE8E8E8, 0xFFECECEC, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFF0F0F0, 0xFFECECEC, 0xFFE1E1E1, 0xFFDFDFDF, 0xFFDDDDDD, 0xFFD3D3D3, 0xFFCCCCCC, 0xFFB6B6B6, 
        0xEA939393, 0x946B6B6B, 0x405E5E5E, 0x005A5A5A, 0x00626262, 0x00686868, 0x00676767, 0x006B6B6B, 0x00747474, 0x00747375, 0x00777678, 0x007A797B, 0x007D7C7E, 0x00807F81, 0x00848385, 0x0089888A, 0x008C8B8D, 0x00929193, 0x00979698, 0x009F9EA0, 
        0x00A8A7A9, 0x00B0AFB1, 0x00B8B7B9, 0x00BEBDBF, 0x00C2C1C3, 0x00C7C6C8, 0x00CACACA, 0x00CECECE, 0x00D1D1D1, 0x00D4D4D4, 0x00D7D7D7, 0x00DDDDDD, 0x00E1E1E1, 0x00E3E3E3, 0x00E4E4E4, 0x00E5E5E5, 0x00E2E2E2, 0x00DCDCDC, 0x00D3D3D3, 0x00CACACA, 
        0x00C4C4C4, 0x00C1C0C2, 0x00BEBDBF, 0x00BBBABC, 0x00B9B8BA, 0x00B9B8BA, 0x00B7B6B8, 0x00B3B2B4, 0x00B0AFB1, 0x00B1B0B2, 0x00B0AFB1, 0x00B0AFB1, 0x00AEADAF, 0x00ABAAAC, 0x00A8A7A9, 0x00A9A8AA, 0x40ACABAD, 0x94B2B2B2, 0xEABEBEBE, 0xFFCCCCCC, 
        0xFFD5D5D5, 0xFFD8D8D8, 0xFFDCDCDC, 0xFFE5E5E5, 0xFFEDEDED, 0xFFF0F0F0, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFECECEC, 0xFFE9E9E9, 0xFFE0E0E0, 0xFFE0E0E0, 0xFFD4D4D4, 0xFFCCCCCC, 0xFFC3C3C3, 0xF6A1A1A1, 0x9C787878, 
        0x42676767, 0x00616161, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 0x00636363, 0x00656565, 0x00666666, 0x00706F71, 0x00737274, 0x00767577, 0x007A797B, 0x00828183, 0x008D8C8E, 0x00979698, 0x009D9C9E, 0x00ACABAD, 0x00AFAEB0, 0x00B3B2B4, 
        0x00B7B6B8, 0x00BAB9BB, 0x00BDBCBE, 0x00C0BFC1, 0x00C3C3C3, 0x00C8C8C8, 0x00CBCBCB, 0x00CECECE, 0x00D1D1D1, 0x00D4D4D4, 0x00D7D7D7, 0x00DCDCDC, 0x00E0E0E0, 0x00E2E2E2, 0x00E5E5E5, 0x00EAEAEA, 0x00EEEEEE, 0x00F2F2F2, 0x00F5F5F5, 0x00F7F7F7, 
        0x00F9F9F9, 0x00EEEDEF, 0x00E3E2E4, 0x00D3D2D4, 0x00C4C3C5, 0x00BDBCBE, 0x00BBBABC, 0x00BAB9BB, 0x00B8B7B9, 0x00B0AFB1, 0x00B0AFB1, 0x00B0AFB1, 0x00B0AFB1, 0x00ADACAE, 0x00A9A8AA, 0x00A7A6A8, 0x00A8A7A9, 0x00A7A7A7, 0x42ABABAB, 0x9CB3B3B3, 
        0xF6BFBFBF, 0xFFCCCCCC, 0xFFD8D8D8, 0xFFDEDEDE, 0xFFE1E1E1, 0xFFE9E9E9, 0xFFECECEC, 0xFFF1F1F1, 0xFFF5F5F5, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFDEDEDE, 0xFFD9D9D9, 0xFFD1D1D1, 0xFFC7C7C7, 0xFFACACAC, 0xB2828282, 0x546A6A6A, 0x006A6A6A, 
        0x006E6E6E, 0x00656565, 0x00656565, 0x00636363, 0x005E5E5E, 0x005D5D5D, 0x00616161, 0x00676767, 0x006A6A6A, 0x0069686A, 0x00747377, 0x00828185, 0x008E8D91, 0x0099989A, 0x00A2A1A3, 0x00A8A7A9, 0x00A9A8AA, 0x00A9A9A9, 0x00ACACAC, 0x00B0B0B0, 
        0x00B4B4B4, 0x00B7B7B7, 0x00BBBBBB, 0x00BFBFBF, 0x00C2C2C2, 0x00C8C8C8, 0x00CACACA, 0x00CDCDCD, 0x00D1D1D1, 0x00D4D4D4, 0x00D8D8D8, 0x00DCDCDC, 0x00DFDFDF, 0x00E7E7E7, 0x00E8E8E8, 0x00E9E9E9, 0x00EAEAEA, 0x00EDEDED, 0x00F3F3F3, 0x00F9F9F9, 
        0x00FEFEFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00F9F8FA, 0x00ECEBED, 0x00D9D8DA, 0x00C3C2C4, 0x00B2B1B3, 0x00BAB9BB, 0x00B4B3B5, 0x00AFAEB0, 0x00ADACAE, 0x00ADACAE, 0x00ADACAE, 0x00ACABAD, 0x00ACABAD, 0x00A9A9A9, 0x00A5A5A5, 0x00A3A3A3, 
        0x54AAAAAA, 0xB2BABABA, 0xFFC8C8C8, 0xFFD1D1D1, 0xFFD3D3D3, 0xFFDEDEDE, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFDBDBDB, 0xFFD6D6D6, 0xFFCECECE, 0xFFBDBDBD, 0xD69D9D9D, 0x73818181, 0x12787878, 0x00797979, 0x00737373, 
        0x006B6B6B, 0x006B6B6B, 0x00656565, 0x00616161, 0x00606060, 0x005D5D5D, 0x005C5C5C, 0x00656565, 0x00706F71, 0x00878688, 0x008E8D91, 0x00959498, 0x0098979B, 0x009A999B, 0x009E9D9F, 0x00A2A1A3, 0x00A4A3A5, 0x00ACACAC, 0x00AEAEAE, 0x00B2B2B2, 
        0x00B5B5B5, 0x00B8B8B8, 0x00BBBBBB, 0x00C0C1BF, 0x00C2C3C1, 0x00C8C8C8, 0x00C9C9C9, 0x00CCCCCC, 0x00D0D0D0, 0x00D4D4D4, 0x00D8D8D8, 0x00DBDBDB, 0x00DEDEDE, 0x00E1E1E1, 0x00E4E4E4, 0x00E9E9E9, 0x00EEEEEE, 0x00F2F2F2, 0x00F5F5F5, 0x00F9F9F9, 
        0x00FBFBFB, 0x00FDFCFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FFFEFF, 0x00FDFCFE, 0x00F8F7F9, 0x00EEEDEF, 0x00E6E5E7, 0x00C4C3C5, 0x00BBBABC, 0x00B2B1B3, 0x00B0AFB1, 0x00B1B0B2, 0x00B0AFB1, 0x00ADACAE, 0x00AAA9AB, 0x00A9A9A9, 0x00A9A9A9, 0x00A7A7A7, 
        0x00A4A4A4, 0x12A4A4A4, 0x73AFAFAF, 0xD6C0C0C0, 0xFFCFCFCF, 0xFFD6D6D6, 0xFFDBDBDB, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE5E5E5, 0xFFDEDEDE, 0xFFDCDCDC, 0xFFD3D3D3, 0xFFC5C5C5, 0xFFADACAE, 0xA1949395, 0x3B828183, 0x00828183, 0x00828183, 0x00787779, 0x00727173, 
        0x00737274, 0x006E6D6F, 0x0069686A, 0x00636264, 0x00626163, 0x00676668, 0x00737274, 0x007F7E80, 0x00888789, 0x008D8C8E, 0x008F8E90, 0x00939294, 0x00979698, 0x009A999B, 0x009E9D9F, 0x00A3A2A4, 0x00A6A5A7, 0x00A9A9A9, 0x00ACACAC, 0x00B0B0B0, 
        0x00B4B4B4, 0x00B7B7B7, 0x00BBBBBB, 0x00BFBFBF, 0x00C2C2C2, 0x00C6C6C6, 0x00C9C9C9, 0x00CECECE, 0x00D1D1D1, 0x00D4D4D4, 0x00D8D8D8, 0x00DCDCDC, 0x00E0E0E0, 0x00E2E2E2, 0x00E6E6E6, 0x00EBEBEB, 0x00EEEEEE, 0x00F1F1F1, 0x00F5F5F5, 0x00FAFAFA, 
        0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FBFBFB, 0x00F8F8F8, 0x00F3F3F3, 0x00EFEFEF, 0x00EDEDED, 0x00E0E0E0, 0x00CCCCCC, 0x00BBBBBB, 0x00B1B1B1, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ABAAAC, 0x00A9A8AA, 0x00A8A7A9, 
        0x00A8A7A9, 0x00A5A4A6, 0x00A3A2A4, 0x3BA9A8AA, 0xA1B2B1B3, 0xFFCBCBCB, 0xFFCECECE, 0xFFD7D7D7, 0xFFE2E2E2, 0xFFE9E9E9, 0xFFECECEC, 0xFFF1F2F0, 0xFFF7F8F6, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF2F2F2, 0xFFECECEC, 0xFFE5E5E5, 0xFFDFDFDF, 0xFFD8D8D8, 0xFFCFCFCF, 0xFFBEBEBE, 0xDCAAAAAA, 0x72929193, 0x08908F91, 0x008A898B, 0x00848385, 0x00807F81, 0x007D7C7E, 0x0079787A, 
        0x00767577, 0x00727173, 0x00706F71, 0x006F6E70, 0x00717072, 0x00767577, 0x007D7C7E, 0x00848385, 0x0089888A, 0x008B8A8C, 0x008E8D8F, 0x00929193, 0x00969597, 0x0099989A, 0x009D9C9E, 0x00A2A1A3, 0x00A5A4A6, 0x00A8A8A8, 0x00ABABAB, 0x00B0B0B0, 
        0x00B3B3B3, 0x00B7B7B7, 0x00BBBBBB, 0x00BFBFBF, 0x00C2C2C2, 0x00C6C6C6, 0x00C9C9C9, 0x00CECECE, 0x00D1D1D1, 0x00D4D4D4, 0x00D8D8D8, 0x00DCDCDC, 0x00E0E0E0, 0x00E3E3E3, 0x00E7E7E7, 0x00ECECEC, 0x00EFEFEF, 0x00F2F2F2, 0x00F6F6F6, 0x00FBFBFB, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FAFAFA, 0x00F7F7F7, 0x00F2F2F2, 0x00EEEEEE, 0x00E9E9E9, 0x00E4E4E4, 0x00DDDDDD, 0x00D4D4D4, 0x00C9C9C9, 0x00BDBDBD, 0x00B1B1B1, 0x00AAAAAA, 0x00ADACAE, 0x00ABAAAC, 0x00ABAAAC, 
        0x00ABAAAC, 0x00A7A6A8, 0x00A2A1A3, 0x00A2A1A3, 0x08A6A5A7, 0x72AFAFAF, 0xDCC1C1C1, 0xFFD1D1D1, 0xFFD7D7D7, 0xFFDEDEDE, 0xFFE9E9E9, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFF1F1F1, 0xFFECECEC, 0xFFE4E4E4, 0xFFDDDDDD, 0xFFD6D6D6, 0xFFC9C9C9, 0xFFBABABA, 0xB6A8A8A8, 0x49979797, 0x00949395, 0x008F8E90, 0x008B8A8C, 0x008B8A8C, 0x00888789, 0x00818082, 0x007E7D7F, 
        0x007F7E80, 0x00727173, 0x00737274, 0x00767577, 0x007A797B, 0x007E7D7F, 0x00828183, 0x00858486, 0x00868587, 0x008A898B, 0x008D8C8E, 0x00908F91, 0x00949395, 0x00989799, 0x009C9B9D, 0x00A09FA1, 0x00A3A2A4, 0x00A8A8A8, 0x00ABABAB, 0x00AFAFAF, 
        0x00B3B3B3, 0x00B6B6B6, 0x00BABABA, 0x00BEBEBE, 0x00C1C1C1, 0x00C6C6C6, 0x00C9C9C9, 0x00CECECE, 0x00D1D1D1, 0x00D4D4D4, 0x00D8D8D8, 0x00DDDDDD, 0x00E0E0E0, 0x00E4E4E4, 0x00E8E8E8, 0x00ECECEC, 0x00F0F0F0, 0x00F3F3F3, 0x00F7F7F7, 0x00FCFCFC, 
        0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F9F9F9, 0x00F6F6F6, 0x00F0F0F0, 0x00EBEBEB, 0x00E5E5E5, 0x00E3E3E3, 0x00E0E0E0, 0x00DCDCDC, 0x00D5D5D5, 0x00CBCBCB, 0x00C0C0C0, 0x00B8B8B8, 0x00AFAEB0, 0x00ACABAD, 0x00AAA9AB, 
        0x00ABAAAC, 0x00A9A8AA, 0x00A4A3A5, 0x00A2A1A3, 0x00A2A1A3, 0x00A0A0A0, 0x49AAAAAA, 0xB6BBBBBB, 0xFFCBCBCB, 0xFFD6D6D6, 0xFFDDDDDD, 0xFFE4E4E4, 0xFFEAEAEA, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFF9F9F9, 0xFFF7F7F7, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE4E4E4, 0xFFDBDBDB, 0xFFD3D3D3, 0xFFC9C9C9, 0xFFB8B8B8, 0x96A9A9A9, 0x26A0A0A0, 0x009B9B9B, 0x00989799, 0x00989799, 0x00939294, 0x008B8A8C, 0x008A898B, 0x008A898B, 0x00807F81, 
        0x00727173, 0x00706F71, 0x00717072, 0x00747375, 0x00777678, 0x007B7A7C, 0x007E7D7F, 0x00828183, 0x00848385, 0x00888789, 0x008B8A8C, 0x008F8E90, 0x00939294, 0x00979698, 0x009B9A9C, 0x009F9EA0, 0x00A2A1A3, 0x00A7A7A7, 0x00AAAAAA, 0x00AEAEAE, 
        0x00B2B2B2, 0x00B6B6B6, 0x00BABABA, 0x00BEBEBE, 0x00C1C1C1, 0x00C5C5C5, 0x00C9C9C9, 0x00CDCDCD, 0x00D1D1D1, 0x00D4D4D4, 0x00D8D8D8, 0x00DDDDDD, 0x00E1E1E1, 0x00E5E5E5, 0x00E8E8E8, 0x00EDEDED, 0x00F1F1F1, 0x00F4F4F4, 0x00F8F8F8, 0x00FCFCFC, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F8F8F8, 0x00F4F4F4, 0x00EEEEEE, 0x00E9E9E9, 0x00E3E3E3, 0x00DFDFDF, 0x00DADADA, 0x00D6D6D6, 0x00D3D3D3, 0x00CFCFCF, 0x00CBCBCB, 0x00C8C8C8, 0x00B6B5B7, 0x00B0AFB1, 0x00ABAAAC, 
        0x00AAA9AB, 0x00AAA9AB, 0x00A8A7A9, 0x00A6A5A7, 0x00A6A5A7, 0x00A2A2A2, 0x009F9F9F, 0x26A6A6A6, 0x96B9B9B9, 0xFFC9C9C9, 0xFFD2D2D2, 0xFFDADADA, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 
        0xFFF7F7F7, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFEAEAEA, 0xFFE4E4E4, 0xFFDADADA, 0xFFD0D0D0, 0xFFC6C6C6, 0xF0BDBDBD, 0x7CAEAEAE, 0x08A4A4A4, 0x00A2A2A2, 0x00A3A3A3, 0x009B9A9C, 0x00979698, 0x00959496, 0x00949395, 0x008B8A8C, 0x007A797B, 0x006D6C6E, 
        0x00686769, 0x006E6D6F, 0x00706F71, 0x00737274, 0x00767577, 0x0079787A, 0x007D7C7E, 0x00818082, 0x00848385, 0x00878688, 0x008A898B, 0x008E8D8F, 0x00929193, 0x00969597, 0x009A999B, 0x009E9D9F, 0x00A2A1A3, 0x00A6A6A6, 0x00A9A9A9, 0x00ADADAD, 
        0x00B1B1B1, 0x00B5B5B5, 0x00B9B9B9, 0x00BDBDBD, 0x00C0C0C0, 0x00C5C5C5, 0x00C8C8C8, 0x00CDCDCD, 0x00D1D1D1, 0x00D5D5D5, 0x00D8D8D8, 0x00DDDDDD, 0x00E1E1E1, 0x00E5E5E5, 0x00E8E8E8, 0x00EDEDED, 0x00F1F1F1, 0x00F5F5F5, 0x00F9F9F9, 0x00FCFCFC, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBFBFB, 0x00F7F7F7, 0x00F2F2F2, 0x00ECECEC, 0x00E7E7E7, 0x00E3E3E3, 0x00DFDFDF, 0x00DADADA, 0x00D6D6D6, 0x00D3D3D3, 0x00CECECE, 0x00CACACA, 0x00C6C6C6, 0x00C0BFC1, 0x00B9B8BA, 0x00B1B0B2, 
        0x00ADACAE, 0x00ACABAD, 0x00AAA9AB, 0x00A8A8A8, 0x00A6A6A6, 0x00A4A4A4, 0x00A4A4A4, 0x00A2A2A2, 0x08A4A4A4, 0x7CB1B1B1, 0xF0C5C5C5, 0xFFD4D4D4, 0xFFD9D9D9, 0xFFE2E2E2, 0xFFE8E8E8, 0xFFEFEFEF, 0xFFF4F4F4, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFF9F9F9, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 
        0xFFF4F4F4, 0xFFF0F0F0, 0xFFEBEBEB, 0xFFE2E2E2, 0xFFDBDBDB, 0xFFD1D1D1, 0xFFC4C4C4, 0xDFBBBBBB, 0x68B6B6B6, 0x00AEAEAE, 0x00A9A9A9, 0x00A7A7A7, 0x00A4A4A4, 0x00A2A1A3, 0x009F9EA0, 0x0099989A, 0x008C8B8D, 0x00777678, 0x00656466, 0x00626163, 
        0x0069686A, 0x006B6A6C, 0x006E6D6F, 0x00727173, 0x00767577, 0x0079787A, 0x007C7B7D, 0x007F7E80, 0x00828183, 0x00868587, 0x0089888A, 0x008D8C8E, 0x00919092, 0x00959496, 0x0099989A, 0x009D9C9E, 0x00A1A0A2, 0x00A5A5A5, 0x00A8A8A8, 0x00ACACAC, 
        0x00B0B0B0, 0x00B4B4B4, 0x00B8B8B8, 0x00BCBCBC, 0x00BFBFBF, 0x00C5C5C5, 0x00C8C8C8, 0x00CDCDCD, 0x00D1D1D1, 0x00D5D5D5, 0x00D9D9D9, 0x00DEDEDE, 0x00E1E1E1, 0x00E6E6E6, 0x00E9E9E9, 0x00EDEDED, 0x00F2F2F2, 0x00F6F6F6, 0x00FAFAFA, 0x00FDFDFD, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00F9F9F9, 0x00F4F4F4, 0x00F0F0F0, 0x00EAEAEA, 0x00E5E5E5, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D4D4D4, 0x00D0D0D0, 0x00CBCBCB, 0x00C5C5C5, 0x00C1C1C1, 0x00BFBEC0, 0x00BBBABC, 0x00B5B4B6, 
        0x00B0AFB1, 0x00AEADAF, 0x00ACABAD, 0x00A9A9A9, 0x00A7A7A7, 0x00A8A8A8, 0x00A6A6A6, 0x00A2A2A2, 0x00A0A0A0, 0x00A3A3A3, 0x68AFAFAF, 0xDFC2C2C2, 0xFFD2D2D2, 0xFFDADADA, 0xFFE2E2E2, 0xFFEAEAEA, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF4F4F4, 
        0xFFEFEFEF, 0xFFE9E9E9, 0xFFE2E2E2, 0xFFD9D9D9, 0xFFD1D1D1, 0xFFC8C8C8, 0xD4C0C0C0, 0x5ABBBBBB, 0x00B8B8B8, 0x00B3B3B3, 0x00B0B0B0, 0x00ADADAD, 0x00A6A6A6, 0x00A3A2A4, 0x00A4A3A5, 0x008D8C8E, 0x00676668, 0x00575658, 0x00646365, 0x006A696B, 
        0x00626163, 0x00676668, 0x006B6A6C, 0x00706F71, 0x00747375, 0x00767577, 0x0079787A, 0x007C7B7D, 0x007E7D7F, 0x00848385, 0x00878688, 0x008B8A8C, 0x008F8E90, 0x00939294, 0x00979698, 0x009C9B9D, 0x009F9EA0, 0x00A4A4A4, 0x00A7A7A7, 0x00ACACAC, 
        0x00B0B0B0, 0x00B4B4B4, 0x00B8B8B8, 0x00BCBCBC, 0x00BFBFBF, 0x00C4C4C4, 0x00C8C8C8, 0x00CDCDCD, 0x00D1D1D1, 0x00D5D5D5, 0x00D9D9D9, 0x00DEDEDE, 0x00E2E2E2, 0x00E7E7E7, 0x00E9E9E9, 0x00EEEEEE, 0x00F3F3F3, 0x00F7F7F7, 0x00FBFBFB, 0x00FEFEFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F6F6F6, 0x00F1F1F1, 0x00EDEDED, 0x00E7E7E7, 0x00E3E3E3, 0x00DEDEDE, 0x00DADADA, 0x00D3D3D3, 0x00CECECE, 0x00CBCBCB, 0x00C7C7C7, 0x00C3C3C3, 0x00C0C0C0, 0x00B9B8BA, 0x00B7B6B8, 0x00B3B2B4, 
        0x00AFAEB0, 0x00ACACAC, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ACACAC, 0x00A5A5A5, 0x00A4A4A4, 0x00A6A6A6, 0x00A2A2A2, 0x009F9F9F, 0x5AAEAEAE, 0xD4C2C2C2, 0xFFD0D0D0, 0xFFD9D9D9, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF5F5F5, 0xFFF8F8F8, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF1F1F1, 
        0xFFEAEAEA, 0xFFE3E3E3, 0xFFDBDBDB, 0xFFD1D1D1, 0xFFC8C8C8, 0xCEC3C3C3, 0x51C1C1C1, 0x00C1C1C1, 0x00BEBEBE, 0x00B7B7B7, 0x00B3B3B3, 0x00B1B1B1, 0x00ACACAC, 0x00AAA9AB, 0x00818082, 0x005E5D5F, 0x00585759, 0x005B5A5C, 0x0059585A, 0x005E5D5F, 
        0x0069686A, 0x00676668, 0x006A696B, 0x006E6D6F, 0x00717072, 0x00737274, 0x00767577, 0x007A797B, 0x007D7C7E, 0x00838284, 0x00868587, 0x008A898B, 0x008E8D8F, 0x00929193, 0x00969597, 0x009B9A9C, 0x009E9D9F, 0x00A4A4A4, 0x00A7A7A7, 0x00ABABAB, 
        0x00AFAFAF, 0x00B3B3B3, 0x00B7B7B7, 0x00BCBCBC, 0x00BFBFBF, 0x00C4C4C4, 0x00C8C8C8, 0x00CDCDCD, 0x00D1D1D1, 0x00D5D5D5, 0x00D9D9D9, 0x00DEDEDE, 0x00E2E2E2, 0x00E8E8E8, 0x00EAEAEA, 0x00EFEFEF, 0x00F4F4F4, 0x00F8F8F8, 0x00FCFCFC, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FAFAFA, 0x00F5F5F5, 0x00F0F0F0, 0x00EBEBEB, 0x00E6E6E6, 0x00E1E1E1, 0x00DBDBDB, 0x00D8D8D8, 0x00D3D3D3, 0x00CFCFCF, 0x00CBCBCB, 0x00C6C6C6, 0x00C1C1C1, 0x00BDBDBD, 0x00B8B7B9, 0x00B6B5B7, 0x00B2B1B3, 
        0x00ACABAD, 0x00A7A7A7, 0x00A7A7A7, 0x00A9A9A9, 0x00ABABAB, 0x00A9A9A9, 0x00AAAAAA, 0x00AAAAAA, 0x00A6A6A6, 0x00A1A1A1, 0x00A1A1A1, 0x00A6A6A6, 0x51ABABAB, 0xCEC7C7C7, 0xFFD0D0D0, 0xFFDADADA, 0xFFE3E3E3, 0xFFE9E9E9, 0xFFEFEFEF, 0xFFF4F4F4, 
        0xFFF6F6F6, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF3F3F3, 0xFFE8E8E8, 
        0xFFE2E2E2, 0xFFDDDDDD, 0xFFD0D0D0, 0xFFC6C6C6, 0xCECACACA, 0x4ED0D0D0, 0x00C7C7C7, 0x00C3C3C3, 0x00C2C2C2, 0x00B8B8B8, 0x00BABABA, 0x00B3B3B3, 0x00B2B2B2, 0x006D6C6E, 0x005B5A5C, 0x00515052, 0x00565557, 0x005A595B, 0x00585759, 0x005B5A5C, 
        0x00636264, 0x00656466, 0x00676668, 0x006B6A6C, 0x006E6D6F, 0x00717072, 0x00757476, 0x0079787A, 0x007C7B7D, 0x00818082, 0x00848385, 0x0089888A, 0x008D8C8E, 0x00908F91, 0x00949395, 0x0099989A, 0x009D9C9E, 0x00A2A2A2, 0x00A6A6A6, 0x00ABABAB, 
        0x00AFAFAF, 0x00B3B3B3, 0x00B7B7B7, 0x00BCBCBC, 0x00C0C0C0, 0x00C3C3C3, 0x00C7C7C7, 0x00CCCCCC, 0x00D1D1D1, 0x00D4D4D4, 0x00D9D9D9, 0x00DEDEDE, 0x00E2E2E2, 0x00E6E6E6, 0x00EAEAEA, 0x00EFEFEF, 0x00F3F3F3, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 
        0x00FEFEFE, 0x00FFFFFF, 0x00FEFEFE, 0x00F8F8F8, 0x00F3F3F3, 0x00EEEEEE, 0x00E9E9E9, 0x00E4E4E4, 0x00E0E0E0, 0x00DADADA, 0x00D6D6D6, 0x00D0D0D0, 0x00CCCCCC, 0x00C8C8C8, 0x00C3C3C3, 0x00BDBDBD, 0x00BABABA, 0x00B6B6B6, 0x00B2B2B2, 0x00ACACAC, 
        0x00A7A7A7, 0x00A4A4A4, 0x00A2A2A2, 0x009F9F9F, 0x009D9D9D, 0x00ABABAB, 0x00A9A9A9, 0x00ACACAC, 0x00A7A7A7, 0x00A4A3A5, 0x00A6A5A7, 0x00A8A7A9, 0x009B9A9C, 0x4EADADAD, 0xCEBFBFBF, 0xFFD2D2D2, 0xFFDCDCDC, 0xFFE2E2E2, 0xFFEAEAEA, 0xFFF1F1F1, 
        0xFFF4F4F4, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF6F6F6, 0xFFF4F4F4, 0xFFE6E6E6, 0xFFE5E5E5, 
        0xFFE1E1E1, 0xFFCCCCCC, 0xFFC8C8C8, 0xD4D1D1D1, 0x51D1D1D1, 0x00CECECE, 0x00C8C8C8, 0x00C9C9C9, 0x00C1C1C1, 0x00C6C6C6, 0x00BDBDBD, 0x00B1B1B1, 0x00616161, 0x00535254, 0x004E4D4F, 0x004D4C4E, 0x00535254, 0x00585759, 0x005A595B, 0x005D5C5E, 
        0x00616062, 0x00636264, 0x00666567, 0x0069686A, 0x006D6C6E, 0x00706F71, 0x00747375, 0x00787779, 0x007B7A7C, 0x00807F81, 0x00838284, 0x00878688, 0x008B8A8C, 0x008F8E90, 0x00939294, 0x00989799, 0x009C9B9D, 0x00A1A1A1, 0x00A5A5A5, 0x00AAAAAA, 
        0x00AEAEAE, 0x00B2B2B2, 0x00B6B6B6, 0x00BBBBBB, 0x00BFBFBF, 0x00C3C3C3, 0x00C7C7C7, 0x00CCCCCC, 0x00D1D1D1, 0x00D4D4D4, 0x00D9D9D9, 0x00DEDEDE, 0x00E2E2E2, 0x00E7E7E7, 0x00EBEBEB, 0x00EFEFEF, 0x00F3F3F3, 0x00F8F8F8, 0x00FDFDFD, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F7F7F7, 0x00F2F2F2, 0x00EDEDED, 0x00E8E8E8, 0x00E2E2E2, 0x00DEDEDE, 0x00D7D7D7, 0x00D4D4D4, 0x00CECECE, 0x00C9C9C9, 0x00C5C5C5, 0x00C1C1C1, 0x00BBBBBB, 0x00B7B7B7, 0x00B4B4B4, 0x00B0B0B0, 0x00AAAAAA, 
        0x00A5A5A5, 0x00A2A2A2, 0x009F9F9F, 0x009C9C9C, 0x009A9A9A, 0x00989898, 0x00ACACAC, 0x00A9A9A9, 0x00A8A8A8, 0x00A7A6A8, 0x00A9A8AA, 0x009F9EA0, 0x00A7A6A8, 0x00A2A2A2, 0x51AEAEAE, 0xD4C0C0C0, 0xFFD1D1D1, 0xFFDCDCDC, 0xFFE4E4E4, 0xFFEBEBEB, 
        0xFFF1F1F1, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE1E1E1, 0xFFDDDDDD, 
        0xFFD4D4D4, 0xFFC5C5C5, 0xDFCDCDCD, 0x5ADBDBDB, 0x00D7D7D7, 0x00D5D5D5, 0x00CECECE, 0x00CACACA, 0x00CECECE, 0x00C1C1C1, 0x00B6B6B6, 0x00585858, 0x00484848, 0x00454446, 0x004B4A4C, 0x004F4E50, 0x00515052, 0x00545355, 0x0059585A, 0x005C5B5D, 
        0x005B5A5C, 0x00616062, 0x00646365, 0x00676668, 0x006B6A6C, 0x006E6D6F, 0x00727173, 0x00767577, 0x0079787A, 0x007D7C7E, 0x00818082, 0x00858486, 0x0089888A, 0x008D8C8E, 0x00919092, 0x00969597, 0x009A999B, 0x009F9F9F, 0x00A3A3A3, 0x00A8A8A8, 
        0x00ADADAD, 0x00B1B1B1, 0x00B5B5B5, 0x00BABABA, 0x00BEBEBE, 0x00C3C3C3, 0x00C7C7C7, 0x00CCCCCC, 0x00D1D1D1, 0x00D4D4D4, 0x00D9D9D9, 0x00DEDEDE, 0x00E2E2E2, 0x00E8E8E8, 0x00ECECEC, 0x00F0F0F0, 0x00F5F5F5, 0x00F9F9F9, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 0x00F5F5F5, 0x00F0F0F0, 0x00EBEBEB, 0x00E6E6E6, 0x00E0E0E0, 0x00DCDCDC, 0x00D5D5D5, 0x00D1D1D1, 0x00CBCBCB, 0x00C7C7C7, 0x00C2C2C2, 0x00BDBDBD, 0x00B8B8B8, 0x00B4B4B4, 0x00B0B0B0, 0x00ACACAC, 0x00A7A7A7, 
        0x00A3A3A3, 0x009F9F9F, 0x009B9B9B, 0x00979797, 0x00949494, 0x00929292, 0x00949494, 0x00A7A6A8, 0x00A8A7A9, 0x00AEADAF, 0x00A2A1A3, 0x00A7A6A8, 0x00A5A4A6, 0x009E9E9E, 0x00A2A2A2, 0x5AAFAFAF, 0xDFC3C3C3, 0xFFD4D4D4, 0xFFDDDDDD, 0xFFE6E6E6, 
        0xFFEDEDED, 0xFFF2F2F2, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEEEEEE, 0xFFE6E6E6, 0xFFE2E2E2, 0xFFD1D1D1, 
        0xFFC6C6C6, 0xF0D3D3D3, 0x68E0E0E0, 0x00DFDFDF, 0x00DADADA, 0x00D4D4D4, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00BABABA, 0x004D4D4D, 0x00444444, 0x00454545, 0x00464547, 0x004C4B4D, 0x00504F51, 0x004F4E50, 0x00504F51, 0x00565557, 0x0059585A, 
        0x0059585A, 0x005F5E60, 0x00626163, 0x00656466, 0x0069686A, 0x006C6B6D, 0x00706F71, 0x00757476, 0x00787779, 0x007B7A7C, 0x007F7E80, 0x00838284, 0x00878688, 0x008B8A8C, 0x008F8E90, 0x00959496, 0x00989799, 0x009E9E9E, 0x00A2A2A2, 0x00A7A7A7, 
        0x00ACACAC, 0x00B0B0B0, 0x00B4B4B4, 0x00BABABA, 0x00BEBEBE, 0x00C2C2C2, 0x00C6C6C6, 0x00CCCCCC, 0x00D0D0D0, 0x00D5D5D5, 0x00D9D9D9, 0x00DFDFDF, 0x00E3E3E3, 0x00E8E8E8, 0x00EDEDED, 0x00F2F2F2, 0x00F6F6F6, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FDFDFD, 0x00F9F9F9, 0x00F3F3F3, 0x00EEEEEE, 0x00E9E9E9, 0x00E3E3E3, 0x00DDDDDD, 0x00D9D9D9, 0x00D3D3D3, 0x00CFCFCF, 0x00C9C9C9, 0x00C4C4C4, 0x00C0C0C0, 0x00BBBBBB, 0x00B5B5B5, 0x00B1B1B1, 0x00ACACAC, 0x00A9A9A9, 0x00A4A4A4, 
        0x00A0A0A0, 0x009C9C9C, 0x00989898, 0x00939393, 0x00909090, 0x00909090, 0x00878787, 0x008C8B8D, 0x00ABAAAC, 0x00A6A5A7, 0x00AEADAF, 0x00A6A5A7, 0x00A3A2A4, 0x00A3A3A3, 0x00A0A0A0, 0x00A5A5A5, 0x68B4B4B4, 0xF0C6C6C6, 0xFFD4D4D4, 0xFFE0E0E0, 
        0xFFE8E8E8, 0xFFEEEEEE, 0xFFF3F3F3, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFE9E9E9, 0xFFE0E0E0, 0xFFD5D5D5, 0xFFC9C9C9, 
        0xFFD0D0D0, 0x7CE4E4E4, 0x00EAEAEA, 0x00E2E2E2, 0x00DEDEDE, 0x00D6D6D6, 0x00D9D9D9, 0x00D4D4D4, 0x00BCBCBC, 0x00515151, 0x003F3F3F, 0x003D3D3D, 0x00434343, 0x00454446, 0x00464547, 0x0049484A, 0x004B4A4C, 0x004E4D4F, 0x00525153, 0x00565557, 
        0x0059585A, 0x005D5C5E, 0x00605F61, 0x00636264, 0x00676668, 0x006A696B, 0x006E6D6F, 0x00737274, 0x00767577, 0x0079787A, 0x007D7C7E, 0x00818082, 0x00868587, 0x0089888A, 0x008E8D8F, 0x00939294, 0x00979698, 0x009D9D9D, 0x00A0A0A0, 0x00A6A6A6, 
        0x00ABABAB, 0x00AFAFAF, 0x00B4B4B4, 0x00BABABA, 0x00BEBEBE, 0x00C2C2C2, 0x00C6C6C6, 0x00CCCCCC, 0x00D0D0D0, 0x00D5D5D5, 0x00D9D9D9, 0x00DFDFDF, 0x00E3E3E3, 0x00E9E9E9, 0x00EEEEEE, 0x00F3F3F3, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FCFCFC, 0x00F8F8F8, 0x00F1F1F1, 0x00ECECEC, 0x00E7E7E7, 0x00E1E1E1, 0x00DBDBDB, 0x00D7D7D7, 0x00D1D1D1, 0x00CCCCCC, 0x00C7C7C7, 0x00C2C2C2, 0x00BDBDBD, 0x00B8B8B8, 0x00B2B2B2, 0x00AEAEAE, 0x00A8A8A8, 0x00A5A5A5, 0x00A1A1A1, 
        0x009D9D9D, 0x00999999, 0x00959595, 0x00919191, 0x008E8E8E, 0x008B8A8C, 0x00878688, 0x00868587, 0x00858486, 0x00A8A7A9, 0x00A9A8AA, 0x00AAA9AB, 0x00A7A6A8, 0x00A7A7A7, 0x00A3A3A3, 0x00A0A0A0, 0x00A5A5A5, 0x7CB4B4B4, 0xFFC8C8C8, 0xFFD8D8D8, 
        0xFFE1E1E1, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEAEAEA, 0xFFE4E4E4, 0xFFD9D9D9, 0xFFC5C5C5, 0xFFD0D0D0, 
        0x96EAEAEA, 0x08EDEDED, 0x00E8E8E8, 0x00E7E7E7, 0x00E3E3E3, 0x00E6E6E6, 0x00D8D8D8, 0x00CACACA, 0x00515151, 0x00333333, 0x003F3F3F, 0x003F3F3F, 0x00404040, 0x00434244, 0x00424143, 0x00454446, 0x004B4A4C, 0x004F4E50, 0x00504F51, 0x00535254, 
        0x00575658, 0x005A595B, 0x005D5C5E, 0x00616062, 0x00646365, 0x00686769, 0x006C6B6D, 0x00706F71, 0x00737274, 0x00777678, 0x007B7A7C, 0x007F7E80, 0x00848385, 0x00888789, 0x008C8B8D, 0x00929193, 0x00969597, 0x009B9B9B, 0x009F9F9F, 0x00A5A5A5, 
        0x00AAAAAA, 0x00AEAEAE, 0x00B3B3B3, 0x00B9B9B9, 0x00BDBDBD, 0x00C2C2C2, 0x00C6C6C6, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00DFDFDF, 0x00E3E3E3, 0x00E9E9E9, 0x00EEEEEE, 0x00F4F4F4, 0x00F8F8F8, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FEFEFE, 0x00FAFAFA, 0x00F5F5F5, 0x00EFEFEF, 0x00E9E9E9, 0x00E4E4E4, 0x00DEDEDE, 0x00D8D8D8, 0x00D3D3D3, 0x00CECECE, 0x00CACACA, 0x00C4C4C4, 0x00BFBFBF, 0x00BABABA, 0x00B5B5B5, 0x00AFAFAF, 0x00ABABAB, 0x00A5A5A5, 0x00A2A2A2, 0x009D9D9D, 
        0x00999999, 0x00969696, 0x00929292, 0x008E8E8E, 0x008B8B8B, 0x00848385, 0x008B8A8C, 0x007D7C7E, 0x007D7C7E, 0x00828183, 0x00A3A2A4, 0x00AAA9AB, 0x00ACABAD, 0x00A8A8A8, 0x00A5A5A5, 0x00A0A0A0, 0x009F9F9F, 0x08A8A8A8, 0x96BBBBBB, 0xFFCECECE, 
        0xFFDADADA, 0xFFE4E4E4, 0xFFEAEAEA, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF3F3F3, 0xFFEDEDED, 0xFFE4E4E4, 0xFFDCDCDC, 0xFFCFCFCF, 0xFFCECECE, 0xB6E6E6E6, 
        0x26FAFAFA, 0x00F2F2F2, 0x00EAEAEA, 0x00ECECEC, 0x00E7E7E7, 0x00DFDFDF, 0x00D3D3D3, 0x00515151, 0x00343434, 0x00353535, 0x00323232, 0x00424242, 0x003C3C3C, 0x00414042, 0x00414042, 0x00454446, 0x004A494B, 0x004C4B4D, 0x004D4C4E, 0x00504F51, 
        0x00545355, 0x00575658, 0x005A595B, 0x005E5D5F, 0x00626163, 0x00656466, 0x0069686A, 0x006E6D6F, 0x00717072, 0x00757476, 0x00787779, 0x007D7C7E, 0x00828183, 0x00868587, 0x008A898B, 0x00908F91, 0x00949395, 0x00999999, 0x009D9D9D, 0x00A3A3A3, 
        0x00A9A9A9, 0x00ADADAD, 0x00B2B2B2, 0x00B8B8B8, 0x00BCBCBC, 0x00C1C1C1, 0x00C5C5C5, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00E0E0E0, 0x00E4E4E4, 0x00E9E9E9, 0x00EEEEEE, 0x00F4F4F4, 0x00F9F9F9, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FEFEFE, 0x00F7F7F7, 0x00F3F3F3, 0x00EDEDED, 0x00E7E7E7, 0x00E1E1E1, 0x00DBDBDB, 0x00D5D5D5, 0x00D0D0D0, 0x00CACACA, 0x00C6C6C6, 0x00C0C0C0, 0x00BBBBBB, 0x00B6B6B6, 0x00B1B1B1, 0x00ABABAB, 0x00A7A7A7, 0x00A2A3A1, 0x009FA09E, 0x009A9A9A, 
        0x00959595, 0x00929292, 0x008E8E8E, 0x00898989, 0x00878787, 0x00848385, 0x007C7B7D, 0x00818082, 0x00757476, 0x00737274, 0x00828183, 0x00A3A2A4, 0x00A8A7A9, 0x00AAAAAA, 0x00A7A7A7, 0x00A5A5A5, 0x00A3A3A3, 0x00A3A3A3, 0x26ADADAD, 0xB6BFBFBF, 
        0xFFD0D0D0, 0xFFDCDCDC, 0xFFE4E4E4, 0xFFEDEDED, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFE8E8E8, 0xFFDEDEDE, 0xFFD5D5D5, 0xFFC6C6C6, 0xDCE6E6E6, 0x49FAFAFA, 
        0x00FAFAFA, 0x00F8F8F8, 0x00F4F4F4, 0x00EDEDED, 0x00E9E9E9, 0x00E6E6E6, 0x005B5B5B, 0x002D2D2D, 0x002F2F2F, 0x00323232, 0x00373737, 0x00363636, 0x003A3A3A, 0x003B3A3C, 0x003F3E40, 0x00434244, 0x00454446, 0x00474648, 0x004B4A4C, 0x00504F51, 
        0x00535254, 0x00555456, 0x00585759, 0x005C5B5D, 0x00605F61, 0x00636264, 0x00686769, 0x006C6B6D, 0x006F6E70, 0x00737274, 0x00777678, 0x007C7B7D, 0x00807F81, 0x00848385, 0x0089888A, 0x008F8E90, 0x00939294, 0x00989898, 0x009C9C9C, 0x00A2A2A2, 
        0x00A7A7A7, 0x00ACACAC, 0x00B2B2B2, 0x00B7B7B7, 0x00BBBBBB, 0x00C1C1C1, 0x00C5C5C5, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00E0E0E0, 0x00E4E4E4, 0x00E9E9E9, 0x00EEEEEE, 0x00F4F4F4, 0x00F9F9F9, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FDFDFD, 0x00F6F6F6, 0x00F1F1F1, 0x00EBEBEB, 0x00E5E5E5, 0x00DFDFDF, 0x00D9D9D9, 0x00D3D3D3, 0x00CECECE, 0x00C8C8C8, 0x00C3C3C3, 0x00BEBEBE, 0x00B8B8B8, 0x00B3B3B3, 0x00AEAEAE, 0x00A8A8A8, 0x00A4A4A4, 0x00A0A19F, 0x009D9E9C, 0x00989898, 
        0x00939393, 0x008E8E8E, 0x008A8A8A, 0x00868686, 0x00838383, 0x007F7E80, 0x007C7B7D, 0x00757476, 0x00777678, 0x00737274, 0x00717072, 0x00848385, 0x00A9A8AA, 0x00AAAAAA, 0x00A8A8A8, 0x00A8A8A8, 0x00A7A7A7, 0x00A1A1A1, 0x00A0A0A0, 0x49B1B1B1, 
        0xDCC5C5C5, 0xFFD6D6D6, 0xFFDFDFDF, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFF6F6F6, 0xFFF6F6F6, 0xFFF4F4F4, 0xFFEBEBEB, 0xFFE3E3E3, 0xFFD9D9D9, 0xFFCBCBCB, 0xFFD4D4D4, 0x72FEFEFE, 0x00FBFBFB, 
        0x00FEFEFE, 0x00FCFCFC, 0x00F4F4F4, 0x00EDECEE, 0x00F4F3F5, 0x00747375, 0x00353436, 0x00272628, 0x002D2C2E, 0x002E2D2F, 0x00343335, 0x00333234, 0x00383739, 0x0039383A, 0x003C3B3D, 0x003F3E40, 0x00424143, 0x00454446, 0x00484749, 0x004D4C4E, 
        0x00504F51, 0x00535254, 0x00565557, 0x005A595B, 0x005D5C5E, 0x00616062, 0x00656466, 0x0069686A, 0x006C6B6D, 0x00717072, 0x00757476, 0x007A797B, 0x007E7D7F, 0x00828183, 0x00868587, 0x008C8B8D, 0x00908F91, 0x00979698, 0x009B9A9C, 0x00A1A1A1, 
        0x00A7A7A7, 0x00ABABAB, 0x00B1B1B1, 0x00B7B7B7, 0x00BBBBBB, 0x00C0C0C0, 0x00C5C5C5, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00E0E0E0, 0x00E5E5E5, 0x00EBEBEB, 0x00F0F0F0, 0x00F5F5F5, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 
        0x00FAFAFA, 0x00F4F4F4, 0x00EFEFEF, 0x00E7E7E7, 0x00E1E1E1, 0x00DCDCDC, 0x00D6D6D6, 0x00CFCFCF, 0x00CACACA, 0x00C5C5C5, 0x00C1C1C1, 0x00BABABA, 0x00B4B4B4, 0x00AFAFAF, 0x00AAAAAA, 0x00A5A5A5, 0x00A1A1A1, 0x009B9B9B, 0x00979797, 0x00939393, 
        0x008E8E8E, 0x008B8B8B, 0x00878787, 0x00838383, 0x00808080, 0x007C7C7C, 0x00767676, 0x00747474, 0x00737373, 0x006E6E6E, 0x00696969, 0x006F6F6F, 0x007B7B7B, 0x00AEAEAE, 0x00A8A8A8, 0x00A8A8A8, 0x00ADADAD, 0x009D9D9D, 0x00A7A7A7, 0x00A3A3A3, 
        0x72B8B8B8, 0xFFCDCDCD, 0xFFD5D5D5, 0xFFE0E0E0, 0xFFEAEAEA, 0xFFF1F1F1, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFE6E6E6, 0xFFD9D9D9, 0xFFD1D1D1, 0xFFCACACA, 0xA1EFEFEF, 0x08FFFFFF, 0x00FFFFFF, 
        0x00FBFBFB, 0x00FFFFFF, 0x00F9F9F9, 0x00FCFBFD, 0x00A3A2A4, 0x00383739, 0x00242325, 0x002E2D2F, 0x002E2D2F, 0x00282729, 0x00313032, 0x00323133, 0x00363537, 0x00383739, 0x003A393B, 0x003E3D3F, 0x00414042, 0x00434244, 0x00464547, 0x004A494B, 
        0x004D4C4E, 0x00515052, 0x00545355, 0x00575658, 0x005B5A5C, 0x005F5E60, 0x00636264, 0x00676668, 0x006A696B, 0x006F6E70, 0x00737274, 0x00787779, 0x007C7B7D, 0x00807F81, 0x00848385, 0x008A898B, 0x008E8D8F, 0x00969597, 0x009A999B, 0x00A0A0A0, 
        0x00A5A5A5, 0x00AAAAAA, 0x00B0B0B0, 0x00B5B5B5, 0x00BABABA, 0x00C0C0C0, 0x00C4C4C4, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00E1E1E1, 0x00E5E5E5, 0x00ECECEC, 0x00F1F1F1, 0x00F6F6F6, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 
        0x00F8F8F8, 0x00F2F2F2, 0x00ECECEC, 0x00E5E5E5, 0x00DFDFDF, 0x00D9D9D9, 0x00D3D3D3, 0x00CDCDCD, 0x00C8C8C8, 0x00C2C2C2, 0x00BEBEBE, 0x00B7B7B7, 0x00B1B1B1, 0x00ACACAC, 0x00A7A7A7, 0x00A1A1A1, 0x009E9E9E, 0x00989898, 0x00959595, 0x00909090, 
        0x008C8C8C, 0x00888888, 0x00848484, 0x00808080, 0x007D7D7D, 0x00787878, 0x00737373, 0x00717171, 0x00707070, 0x006C6C6C, 0x00656565, 0x00646464, 0x00696969, 0x008C8C8C, 0x00B1B1B1, 0x00AAAAAA, 0x00A7A7A7, 0x00ABABAB, 0x00A5A5A5, 0x00A1A1A1, 
        0x08A7A7A7, 0xA1C0C0C0, 0xFFCFCFCF, 0xFFDEDEDE, 0xFFE6E6E6, 0xFFEBEBEB, 0xFFF3F3F3, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFECECEC, 0xFFDFDFDF, 0xFFD0D0D0, 0xFFCCCCCC, 0xD6D2D2D2, 0x3BEFEFEF, 0x00FAFAFA, 0x00F9F9F9, 
        0x00FFFFFF, 0x00FFFFFF, 0x00F4F4F4, 0x00D9D8DA, 0x003E3D3F, 0x00313032, 0x002D2C2E, 0x00363537, 0x002F2E30, 0x0029282A, 0x00313032, 0x002F2E30, 0x002F2E30, 0x00353436, 0x00373638, 0x003B3A3C, 0x003E3D3F, 0x00403F41, 0x00434244, 0x00474648, 
        0x004A494B, 0x004E4D4F, 0x00504F51, 0x00545355, 0x00585759, 0x005C5B5D, 0x00605F61, 0x00646365, 0x00676668, 0x006C6B6D, 0x00706F71, 0x00757476, 0x0079787A, 0x007D7C7E, 0x00828183, 0x00888789, 0x008C8B8D, 0x00939294, 0x00979698, 0x009E9E9E, 
        0x00A3A3A3, 0x00A8A8A8, 0x00AEAEAE, 0x00B4B4B4, 0x00B8B8B8, 0x00BFBFBF, 0x00C4C4C4, 0x00CBCBCB, 0x00D0D0D0, 0x00D5D5D5, 0x00DADADA, 0x00E1E1E1, 0x00E6E6E6, 0x00EDEDED, 0x00F2F2F2, 0x00F8F8F8, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 
        0x00F6F6F6, 0x00EFEFEF, 0x00E9E9E9, 0x00E2E2E2, 0x00DBDBDB, 0x00D6D6D6, 0x00D0D0D0, 0x00C9C9C9, 0x00C4C4C4, 0x00BEBEBE, 0x00B9B9B9, 0x00B3B3B3, 0x00ADADAD, 0x00A8A8A8, 0x00A3A3A3, 0x009D9D9D, 0x00999999, 0x00949494, 0x00919191, 0x008C8C8C, 
        0x00888888, 0x00848484, 0x00808080, 0x007C7C7C, 0x00797979, 0x00757575, 0x00717171, 0x006E6E6E, 0x006C6C6C, 0x00696969, 0x00646464, 0x005F5F5F, 0x005C5C5C, 0x00636363, 0x009E9E9E, 0x00A9A9A9, 0x00AAAAAA, 0x00ABABAB, 0x00AAAAAA, 0x00A4A4A4, 
        0x00A1A1A1, 0x3BB1B1B1, 0xD6C5C5C5, 0xFFD8D8D8, 0xFFDFDFDF, 0xFFE5E5E5, 0xFFF0F0F0, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFEDEDED, 0xFFE4E4E4, 0xFFD9D9D9, 0xFFCACACA, 0xFFCBCBCB, 0x73DCDCDC, 0x00E4E4E4, 0x00ECECEC, 0x00FEFEFE, 
        0x00F6F6F6, 0x00FFFFFF, 0x00FFFFFF, 0x00565557, 0x00383739, 0x003B3A3C, 0x00313032, 0x002E2D2F, 0x002B2A2C, 0x002D2C2E, 0x00302F31, 0x002C2B2D, 0x00313032, 0x00323133, 0x00343335, 0x00373638, 0x003B3A3C, 0x003E3D3F, 0x00414042, 0x00444345, 
        0x00464547, 0x004B4A4C, 0x004E4D4F, 0x00515052, 0x00555456, 0x0059585A, 0x005D5C5E, 0x00626163, 0x00656466, 0x006A696B, 0x006D6C6E, 0x00737274, 0x00777678, 0x007B7A7C, 0x00807F81, 0x00868587, 0x008A898B, 0x00919092, 0x00959496, 0x009C9C9C, 
        0x00A2A2A2, 0x00A7A7A7, 0x00ADADAD, 0x00B3B3B3, 0x00B8B8B8, 0x00BEBEBE, 0x00C3C3C3, 0x00CACACA, 0x00D0D0D0, 0x00D5D5D5, 0x00DBDBDB, 0x00E2E2E2, 0x00E7E7E7, 0x00EEEEEE, 0x00F3F3F3, 0x00F9F9F9, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FAFAFA, 
        0x00F4F4F4, 0x00ECECEC, 0x00E7E7E7, 0x00DFDFDF, 0x00D8D8D8, 0x00D3D3D3, 0x00CCCCCC, 0x00C5C5C5, 0x00C0C0C0, 0x00BABABA, 0x00B6B6B6, 0x00AFAFAF, 0x00A9A9A9, 0x00A4A4A4, 0x009F9F9F, 0x00999999, 0x00969696, 0x00909090, 0x008D8D8D, 0x00888888, 
        0x00848484, 0x00808080, 0x007C7C7C, 0x00787878, 0x00757575, 0x00707070, 0x006E6E6E, 0x006A6A6A, 0x00666666, 0x00646464, 0x00636363, 0x005F5F5F, 0x005B5B5B, 0x00555555, 0x006A6A6A, 0x00A8A8A8, 0x00A9A9A9, 0x00ADADAD, 0x00A7A7A7, 0x00AFAFAF, 
        0x00A4A4A4, 0x00A6A6A6, 0x73B8B8B8, 0xFFCDCDCD, 0xFFDADADA, 0xFFE3E3E3, 0xFFECECEC, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF4F4F4, 0xFFF0F0F0, 0xFFE6E6E6, 0xFFDCDCDC, 0xFFD3D3D3, 0xFFC5C5C5, 0xB2C8C8C8, 0x12DADADA, 0x00DFDFDF, 0x00E5E5E5, 0x00F0F0F0, 
        0x00F8F8F8, 0x00FEFEFE, 0x00929292, 0x00434244, 0x0039383A, 0x00383739, 0x00343335, 0x00333234, 0x00323133, 0x00313032, 0x002C2B2D, 0x00282729, 0x00323133, 0x002F2E30, 0x00313032, 0x00343335, 0x00373638, 0x003B3A3C, 0x003F3E40, 0x00424143, 
        0x00444345, 0x00484749, 0x004B4A4C, 0x004F4E50, 0x00535254, 0x00565557, 0x005B5A5C, 0x005F5E60, 0x00626163, 0x00686769, 0x006B6A6C, 0x00717072, 0x00757476, 0x0079787A, 0x007F7E80, 0x00848385, 0x00888789, 0x008F8E90, 0x00939294, 0x009A9A9A, 
        0x00A0A0A0, 0x00A6A6A6, 0x00ACACAC, 0x00B3B3B3, 0x00B7B7B7, 0x00BEBEBE, 0x00C3C3C3, 0x00CACACA, 0x00D0D0D0, 0x00D5D5D5, 0x00DBDBDB, 0x00E2E2E2, 0x00E7E7E7, 0x00EEEEEE, 0x00F3F3F3, 0x00F9F9F9, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F8F8, 
        0x00F2F2F2, 0x00EAEAEA, 0x00E4E4E4, 0x00DDDDDD, 0x00D6D6D6, 0x00D0D0D0, 0x00C9C9C9, 0x00C2C2C2, 0x00BDBDBD, 0x00B7B7B7, 0x00B2B2B2, 0x00ACACAC, 0x00A6A6A6, 0x00A1A1A1, 0x009C9C9C, 0x00969696, 0x00929292, 0x008C8C8C, 0x00898989, 0x00848484, 
        0x00808080, 0x007C7C7C, 0x00787878, 0x00747474, 0x00717171, 0x006A6A6A, 0x00696969, 0x00656565, 0x00606060, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x00595959, 0x00585858, 0x00535353, 0x00838383, 0x00B1B1B1, 0x00A7A7A7, 0x00ADADAD, 0x00A9A9A9, 
        0x00A8A8A8, 0x00A4A4A4, 0x12ADADAD, 0xB2BFBFBF, 0xFFD4D4D4, 0xFFE1E1E1, 0xFFE8E8E8, 0xFFEFEFEF, 0xFFF5F5F5, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF2F2F2, 0xFFEBEBEB, 0xFFE2E2E2, 0xFFD9D9D9, 0xFFCDCDCD, 0xF6C0C0C0, 0x54C2C2C2, 0x00CFCFCF, 0x00D6D6D6, 0x00DDDDDD, 0x00E5E5E5, 
        0x00EEEEEE, 0x00D0D0D0, 0x00424242, 0x003B3A3C, 0x00403F41, 0x003B3A3C, 0x003E3D3F, 0x003C3B3D, 0x00363537, 0x00333234, 0x00302F31, 0x002B2A2C, 0x002B2A2C, 0x002D2C2E, 0x002E2D2F, 0x00302F31, 0x00333234, 0x00373638, 0x003B3A3C, 0x003F3E40, 
        0x00414042, 0x00454446, 0x00474648, 0x004B4A4C, 0x004F4E50, 0x00535254, 0x00575658, 0x005C5B5D, 0x005F5E60, 0x00656466, 0x00686769, 0x006E6D6F, 0x00737274, 0x00777678, 0x007C7B7D, 0x00828183, 0x00868587, 0x008D8C8E, 0x00919092, 0x00989898, 
        0x009E9E9E, 0x00A4A4A4, 0x00ABABAB, 0x00B2B2B2, 0x00B6B6B6, 0x00BDBDBD, 0x00C2C2C2, 0x00C9C9C9, 0x00D0D0D0, 0x00D5D5D5, 0x00DCDCDC, 0x00E3E3E3, 0x00E8E8E8, 0x00EFEFEF, 0x00F4F4F4, 0x00FAFAFA, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00F6F6F6, 
        0x00EFEFEF, 0x00E7E7E7, 0x00E1E1E1, 0x00D9D9D9, 0x00D2D2D2, 0x00CCCCCC, 0x00C5C5C5, 0x00BEBEBE, 0x00B9B9B9, 0x00B3B3B3, 0x00AEAEAE, 0x00A8A8A8, 0x00A2A2A2, 0x009D9D9D, 0x00979797, 0x00929292, 0x008E8E8E, 0x00878787, 0x00848484, 0x007F7F7F, 
        0x007B7B7B, 0x00777777, 0x00737373, 0x006F6F6F, 0x006D6D6D, 0x00666666, 0x00656565, 0x00636363, 0x005E5E5E, 0x005A5A5A, 0x00585858, 0x00575757, 0x00555555, 0x00595959, 0x00575757, 0x005B5B5B, 0x009D9D9D, 0x00ADADAD, 0x00B0B0B0, 0x00A7A7A7, 
        0x00AAAAAA, 0x00A7A7A7, 0x00A8A8A8, 0x54B4B4B4, 0xF6CACACA, 0xFFDCDCDC, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFF2F2F2, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFF0F0F0, 0xFFE7E7E7, 0xFFDEDEDE, 0xFFD2D2D2, 0xFFC1C1C1, 0x9CB7B7B7, 0x00BCBCBC, 0x00C5C5C5, 0x00D1D1D1, 0x00D2D2D2, 0x00DBDBDB, 
        0x00E3E3E3, 0x00686868, 0x00494949, 0x003D3C3E, 0x00424143, 0x003A393B, 0x003B3A3C, 0x00363537, 0x00323133, 0x00333234, 0x00353436, 0x00343335, 0x002E2D2F, 0x002C2B2D, 0x002D2C2E, 0x002D2C2E, 0x00302F31, 0x00333234, 0x00383739, 0x003B3A3C, 
        0x003D3C3E, 0x00414042, 0x00434244, 0x00474648, 0x004B4A4C, 0x004F4E50, 0x00545355, 0x00585759, 0x005B5A5C, 0x00616062, 0x00656466, 0x006A696B, 0x006F6E70, 0x00747375, 0x0079787A, 0x007F7E80, 0x00838284, 0x008A898B, 0x008F8E90, 0x00969696, 
        0x009D9D9D, 0x00A3A3A3, 0x00A9A9A9, 0x00B0B0B0, 0x00B5B5B5, 0x00BCBCBC, 0x00C2C2C2, 0x00C9C9C9, 0x00D0D0D0, 0x00D5D5D5, 0x00DCDCDC, 0x00E3E3E3, 0x00E9E9E9, 0x00F0F0F0, 0x00F6F6F6, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F3F3F3, 
        0x00EBEBEB, 0x00E3E3E3, 0x00DDDDDD, 0x00D5D5D5, 0x00CECECE, 0x00C8C8C8, 0x00C1C1C1, 0x00B9B9B9, 0x00B4B4B4, 0x00AEAEAE, 0x00A9A9A9, 0x00A2A2A2, 0x009C9C9C, 0x00989898, 0x00929292, 0x008D8D8D, 0x00898989, 0x00828282, 0x007F7F7F, 0x007B7B7B, 
        0x00767676, 0x00737373, 0x006F6F6F, 0x006B6B6B, 0x00686868, 0x00646464, 0x00616161, 0x005E5E5E, 0x005C5C5C, 0x00595959, 0x00575757, 0x00565656, 0x00575757, 0x00595959, 0x00575757, 0x005E5E5E, 0x006C6C6C, 0x00B0B0B0, 0x00A5A5A5, 0x00B2B2B2, 
        0x00AAAAAA, 0x00AAAAAA, 0x00A7A7A7, 0x00ADADAD, 0x9CBFBFBF, 0xFFD1D1D1, 0xFFDEDEDE, 0xFFE7E7E7, 0xFFEDEDED, 0xFFF5F5F5, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFEEEEEE, 0xFFE2E2E2, 0xFFD8D8D8, 0xFFC9C9C9, 0xEAB4B4B4, 0x42ADADAD, 0x00B7B7B7, 0x00BEBEBE, 0x00C2C2C2, 0x00D2D2D2, 0x00DADADA, 
        0x009B9B9B, 0x00414141, 0x00434343, 0x0049484A, 0x00414042, 0x00424143, 0x00414042, 0x003E3D3F, 0x003D3C3E, 0x00383739, 0x00333234, 0x00353436, 0x00323133, 0x002C2B2D, 0x002C2B2D, 0x002C2B2D, 0x002E2D2F, 0x00313032, 0x00353436, 0x00383739, 
        0x003A393B, 0x003E3D3F, 0x00414042, 0x00454446, 0x0049484A, 0x004C4B4D, 0x00515052, 0x00555456, 0x0059585A, 0x005E5D5F, 0x00626163, 0x00686769, 0x006D6C6E, 0x00717072, 0x00767577, 0x007C7B7D, 0x00818082, 0x0089888A, 0x008D8C8E, 0x00949494, 
        0x009B9B9B, 0x00A1A1A1, 0x00A8A8A8, 0x00AFAFAF, 0x00B4B4B4, 0x00BCBCBC, 0x00C1C1C1, 0x00C9C9C9, 0x00D0D0D0, 0x00D5D5D5, 0x00DCDCDC, 0x00E4E4E4, 0x00E9E9E9, 0x00F2F2F2, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FAFAFA, 0x00F1F1F1, 
        0x00E8E8E8, 0x00E0E0E0, 0x00DADADA, 0x00D2D2D2, 0x00CBCBCB, 0x00C5C5C5, 0x00BEBEBE, 0x00B6B6B6, 0x00B1B1B1, 0x00AAAAAA, 0x00A5A5A5, 0x009F9F9F, 0x00999999, 0x00949494, 0x008F8F8F, 0x00898989, 0x00858585, 0x007F7F7F, 0x007C7C7C, 0x00777777, 
        0x00737373, 0x006F6F6F, 0x006B6B6B, 0x00676767, 0x00646464, 0x00626262, 0x005C5C5C, 0x00575757, 0x00565656, 0x00565656, 0x00565656, 0x00575757, 0x005A5A5A, 0x005A5A5A, 0x00616161, 0x00626262, 0x00606060, 0x008C8C8C, 0x00AFAFAF, 0x00ABABAB, 
        0x00ADADAD, 0x00ABABAB, 0x00A9A9A9, 0x00ABABAB, 0x42B6B6B6, 0xEAC9C9C9, 0xFFDADADA, 0xFFE5E5E5, 0xFFEBEBEB, 0xFFF4F4F4, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFE3E3E3, 0xFFE4E4E4, 0xFFCFCFCF, 0xFFBEBEBE, 0x949E9E9E, 0x00A7A7A7, 0x00ABABAB, 0x00B6B6B6, 0x00C0C0C0, 0x00C2C2C2, 0x00BDBDBD, 
        0x00585858, 0x00494949, 0x00484848, 0x004D4C4E, 0x00444345, 0x00434244, 0x00424143, 0x003F3E40, 0x003D3C3E, 0x003B3A3C, 0x0039383A, 0x00363537, 0x00353436, 0x00323133, 0x00302F31, 0x002E2D2F, 0x002C2B2D, 0x002D2C2E, 0x002F2E30, 0x00333234, 
        0x00363537, 0x003B3A3C, 0x003E3D3F, 0x00424143, 0x00454446, 0x00484749, 0x004C4B4D, 0x00515052, 0x00555456, 0x005B5A5C, 0x005F5E60, 0x00646365, 0x006A696B, 0x006E6D6F, 0x00747375, 0x007B7A7C, 0x007F7E80, 0x00868587, 0x008B8A8C, 0x00929292, 
        0x00999999, 0x009F9F9F, 0x00A6A6A6, 0x00AEAEAE, 0x00B3B3B3, 0x00BABABA, 0x00C3C3C3, 0x00C9C9C9, 0x00CFCFCF, 0x00D7D7D7, 0x00DDDDDD, 0x00E3E3E3, 0x00EBEBEB, 0x00F3F3F3, 0x00F8F8F8, 0x00FEFEFE, 0x00FFFFFF, 0x00FDFDFD, 0x00F6F6F6, 0x00EDEDED, 
        0x00E6E6E6, 0x00DEDEDE, 0x00D6D6D6, 0x00D0D0D0, 0x00C9C9C9, 0x00C0C0C0, 0x00B9B9B9, 0x00B3B3B3, 0x00ABABAB, 0x00A5A5A5, 0x00A0A0A0, 0x009A9A9A, 0x00949494, 0x008F8F8F, 0x008A8A8A, 0x00848484, 0x00808080, 0x007A7A7A, 0x00777777, 0x00737373, 
        0x006F6F6F, 0x006B6B6B, 0x00676767, 0x00636363, 0x00616161, 0x005A5A5A, 0x00585858, 0x00565656, 0x00565656, 0x00585858, 0x005B5B5B, 0x005D5D5D, 0x005E5E5E, 0x005F5F5F, 0x005F5F5F, 0x00626262, 0x005D5D5D, 0x00686868, 0x00A9A9A9, 0x00ADADAD, 
        0x00B1B1B1, 0x00ADADAD, 0x00ABABAB, 0x00A8A8A8, 0x00A9A9A9, 0x94C5C5C5, 0xFFD0D0D0, 0xFFDDDDDD, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFECECEC, 0xFFE5E5E5, 0xFFDADADA, 0xFFCBCBCB, 0xECA7A7A7, 0x40959595, 0x009B9B9B, 0x00A7A7A7, 0x00ADADAD, 0x00B3B3B3, 0x00C2C2C2, 0x00818181, 
        0x00535353, 0x004F4F4F, 0x00505050, 0x00474648, 0x0049484A, 0x00474648, 0x00464547, 0x00434244, 0x00414042, 0x003F3E40, 0x003D3C3E, 0x003B3A3C, 0x0039383A, 0x00353436, 0x00333234, 0x00313032, 0x002E2D2F, 0x002D2C2E, 0x002F2E30, 0x00313032, 
        0x00333234, 0x00383739, 0x003A393B, 0x003E3D3F, 0x00424143, 0x00454446, 0x004A494B, 0x004F4E50, 0x00535254, 0x0059585A, 0x005C5B5D, 0x00626163, 0x00676668, 0x006C6B6D, 0x00727173, 0x00787779, 0x007D7C7E, 0x00848385, 0x0089888A, 0x00909090, 
        0x00979797, 0x009D9D9D, 0x00A4A4A4, 0x00ACACAC, 0x00B2B2B2, 0x00B9B9B9, 0x00C2C2C2, 0x00C8C8C8, 0x00CFCFCF, 0x00D7D7D7, 0x00DDDDDD, 0x00E4E4E4, 0x00EDEDED, 0x00F3F3F3, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 0x00F3F3F3, 0x00EAEAEA, 
        0x00E4E4E4, 0x00D9D9D9, 0x00D1D1D1, 0x00CBCBCB, 0x00C4C4C4, 0x00BBBBBB, 0x00B4B4B4, 0x00AEAEAE, 0x00A6A6A6, 0x00A0A0A0, 0x009B9B9B, 0x00949494, 0x008E8E8E, 0x008A8A8A, 0x00848484, 0x007F7F7F, 0x007B7B7B, 0x00767676, 0x00737373, 0x006F6F6F, 
        0x006A6A6A, 0x00666666, 0x00626262, 0x005E5E5E, 0x005C5C5C, 0x00575757, 0x00575757, 0x00565656, 0x00585858, 0x005A5A5A, 0x005C5C5C, 0x005E5E5E, 0x005E5E5E, 0x00606060, 0x00636363, 0x00626262, 0x005F5F5F, 0x006B6B6B, 0x00848484, 0x00B3B3B3, 
        0x00AEAEAE, 0x00ACACAC, 0x00AFAFAF, 0x00A8A8A8, 0x00A8A8A8, 0x40B6B6B6, 0xECCACACA, 0xFFD8D8D8, 0xFFE4E4E4, 0xFFEDEDED, 0xFFF3F3F3, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFEFEF, 0xFFE9E9E9, 0xFFE3E3E3, 0xFFD1D1D1, 0xFFBFBFBF, 0x9C8D8D8D, 0x008D8D8D, 0x00919191, 0x00A1A1A1, 0x00A3A3A3, 0x00ACACAC, 0x00A9A9A9, 0x00535353, 
        0x00515151, 0x00525252, 0x00555555, 0x00454446, 0x004F4E50, 0x004A494B, 0x00484749, 0x00464547, 0x00444345, 0x00424143, 0x00403F41, 0x003D3C3E, 0x003C3B3D, 0x0039383A, 0x00373638, 0x00343335, 0x00313032, 0x002F2E30, 0x002E2D2F, 0x002E2D2F, 
        0x002F2E30, 0x00343335, 0x00363537, 0x003A393B, 0x003D3C3E, 0x00414042, 0x00464547, 0x004B4A4C, 0x004F4E50, 0x00555456, 0x00585759, 0x005E5D5F, 0x00636264, 0x00686769, 0x006E6D6F, 0x00757476, 0x0079787A, 0x00818082, 0x00868587, 0x008D8D8D, 
        0x00949494, 0x009A9A9A, 0x00A2A2A2, 0x00AAAAAA, 0x00B0B0B0, 0x00B8B8B8, 0x00C0C0C0, 0x00C8C8C8, 0x00CECECE, 0x00D7D7D7, 0x00DEDEDE, 0x00E5E5E5, 0x00EEEEEE, 0x00F3F3F3, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00F0F0F0, 0x00E7E7E7, 
        0x00E0E0E0, 0x00D6D6D6, 0x00CECECE, 0x00C7C7C7, 0x00C0C0C0, 0x00B7B7B7, 0x00B0B0B0, 0x00AAAAAA, 0x00A2A2A2, 0x009B9B9B, 0x00969696, 0x00909090, 0x008A8A8A, 0x00858585, 0x00808080, 0x007A7A7A, 0x00767676, 0x00717171, 0x006E6E6E, 0x00696969, 
        0x00646464, 0x00606060, 0x005C5C5C, 0x00585858, 0x00565656, 0x00575757, 0x00575757, 0x00595959, 0x005B5B5B, 0x005E5E5E, 0x005F5F5F, 0x00606060, 0x00606060, 0x00636363, 0x00656565, 0x00656565, 0x00656565, 0x00686868, 0x00696969, 0x00A8A8A8, 
        0x00B2B2B2, 0x00ACACAC, 0x00B2B2B2, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x9CC3C3C3, 0xFFD3D3D3, 0xFFE0E0E0, 0xFFE9E9E9, 0xFFEFEFEF, 0xFFF6F6F6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDED, 0xFFE6E6E6, 0xFFDADADA, 0xFFCDCDCD, 0xFFA4A4A4, 0x4D7B7B7B, 0x00868686, 0x008B8B8B, 0x00969696, 0x009B9B9B, 0x00A7A7A7, 0x007A7A7A, 0x00555555, 
        0x00555555, 0x00505050, 0x00545454, 0x004B4A4C, 0x00515052, 0x004D4C4E, 0x004B4A4C, 0x0049484A, 0x00474648, 0x00454446, 0x00434244, 0x00414042, 0x003F3E40, 0x003D3C3E, 0x003B3A3C, 0x00383739, 0x00353436, 0x00323133, 0x002F2E30, 0x002D2C2E, 
        0x002C2B2D, 0x00302F31, 0x00323133, 0x00363537, 0x0039383A, 0x003D3C3E, 0x00424143, 0x00474648, 0x004A494B, 0x00515052, 0x00545355, 0x005A595B, 0x005F5E60, 0x00656466, 0x006B6A6C, 0x00727173, 0x00767577, 0x007E7D7F, 0x00838284, 0x008A8A8A, 
        0x00929292, 0x00989898, 0x00A0A0A0, 0x00A9A9A9, 0x00AFAFAF, 0x00B7B7B7, 0x00C0C0C0, 0x00C7C7C7, 0x00CECECE, 0x00D8D8D8, 0x00DFDFDF, 0x00E6E6E6, 0x00EFEFEF, 0x00F4F4F4, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00F6F6F6, 0x00ECECEC, 0x00E3E3E3, 
        0x00DDDDDD, 0x00D2D2D2, 0x00CACACA, 0x00C3C3C3, 0x00BCBCBC, 0x00B2B2B2, 0x00ABABAB, 0x00A5A5A5, 0x009D9D9D, 0x00969696, 0x00929292, 0x008B8B8B, 0x00858585, 0x00808080, 0x007B7B7B, 0x00767676, 0x00727272, 0x006D6D6D, 0x00696969, 0x00646464, 
        0x005F5F5F, 0x005B5B5B, 0x00585858, 0x00565656, 0x00555555, 0x00595959, 0x005A5A5A, 0x005C5C5C, 0x005F5F5F, 0x00616161, 0x00626262, 0x00636363, 0x00636363, 0x00676767, 0x00636363, 0x00696969, 0x006C6C6C, 0x00636363, 0x006B6B6B, 0x008B8B8B, 
        0x00B6B6B6, 0x00AFAFAF, 0x00B0B0B0, 0x00AEAEAE, 0x00ADADAD, 0x00AAAAAA, 0x4DBBBBBB, 0xFFCDCDCD, 0xFFDADADA, 0xFFE6E6E6, 0xFFEDEDED, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEAEAEA, 0xFFE2E2E2, 0xFFD3D3D3, 0xFFC8C8C8, 0xB4818181, 0x006F6F6F, 0x007B7B7B, 0x00848484, 0x00898989, 0x00959595, 0x00949494, 0x005C5C5C, 0x005F5F5F, 
        0x00595959, 0x00555555, 0x00545454, 0x00545355, 0x00515052, 0x00515052, 0x00504F51, 0x004D4C4E, 0x004B4A4C, 0x0049484A, 0x00474648, 0x00454446, 0x00444345, 0x00403F41, 0x003E3D3F, 0x003B3A3C, 0x00383739, 0x00353436, 0x00323133, 0x002F2E30, 
        0x002D2C2E, 0x002D2C2E, 0x002F2E30, 0x00323133, 0x00363537, 0x003A393B, 0x003F3E40, 0x00434244, 0x00464547, 0x004D4C4E, 0x00515052, 0x00565557, 0x005C5B5D, 0x00616062, 0x00686769, 0x006E6D6F, 0x00737274, 0x007B7A7C, 0x00807F81, 0x00888888, 
        0x00909090, 0x00979797, 0x009F9F9F, 0x00A8A8A8, 0x00AEAEAE, 0x00B7B7B7, 0x00BFBFBF, 0x00C7C7C7, 0x00CECECE, 0x00D8D8D8, 0x00DFDFDF, 0x00E6E6E6, 0x00EFEFEF, 0x00F6F6F6, 0x00FEFEFE, 0x00FFFFFF, 0x00FCFCFC, 0x00F2F2F2, 0x00E9E9E9, 0x00E0E0E0, 
        0x00D8D8D8, 0x00CDCDCD, 0x00C5C5C5, 0x00BDBDBD, 0x00B5B5B5, 0x00ACACAC, 0x00A5A5A5, 0x009F9F9F, 0x00979797, 0x00909090, 0x008B8B8B, 0x00858585, 0x007F7F7F, 0x007A7A7A, 0x00757575, 0x006F6F6F, 0x006B6B6B, 0x00686868, 0x00646464, 0x005F5F5F, 
        0x005A5A5A, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x005D5D5D, 0x005E5E5E, 0x005F5F5F, 0x00606060, 0x00626262, 0x00646464, 0x00656565, 0x00666666, 0x00676767, 0x00666666, 0x00696969, 0x006D6D6D, 0x00686868, 0x00707070, 0x00737373, 
        0x00ABABAB, 0x00B4B4B4, 0x00ADADAD, 0x00AFAFAF, 0x00ACACAC, 0x00ADADAD, 0x00B0B0B0, 0xB4C6C6C6, 0xFFD5D5D5, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE6E6E6, 0xFFDEDEDE, 0xFFD1D1D1, 0xFFB1B1B1, 0x6B666666, 0x00686868, 0x00717171, 0x007D7D7D, 0x00808080, 0x008E8E8E, 0x00767676, 0x005D5D5D, 0x00595959, 
        0x005A5A5A, 0x005D5D5D, 0x00575757, 0x0059585A, 0x00535254, 0x00545355, 0x00525153, 0x00504F51, 0x004E4D4F, 0x004C4B4D, 0x004A494B, 0x00484749, 0x00474648, 0x00444345, 0x00424143, 0x003F3E40, 0x003C3B3D, 0x003A393B, 0x00373638, 0x00333234, 
        0x00313032, 0x002C2B2D, 0x002D2C2E, 0x002F2E30, 0x00323133, 0x00363537, 0x003B3A3C, 0x00403F41, 0x00424143, 0x00484749, 0x004C4B4D, 0x00525153, 0x00585759, 0x005D5C5E, 0x00646365, 0x006A696B, 0x006F6E70, 0x00777678, 0x007C7B7D, 0x00858585, 
        0x008D8D8D, 0x00949494, 0x009D9D9D, 0x00A6A6A6, 0x00ADADAD, 0x00B6B6B6, 0x00BFBFBF, 0x00C7C7C7, 0x00CECECE, 0x00D8D8D8, 0x00DFDFDF, 0x00E7E7E7, 0x00F0F0F0, 0x00F8F8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00EEEEEE, 0x00E5E5E5, 0x00DBDBDB, 
        0x00D2D2D2, 0x00C9C9C9, 0x00C0C0C0, 0x00B8B8B8, 0x00B0B0B0, 0x00A6A6A6, 0x009F9F9F, 0x00999999, 0x00919191, 0x008B8B8B, 0x00868686, 0x007F7F7F, 0x00797979, 0x00747474, 0x006F6F6F, 0x006A6A6A, 0x00666666, 0x00616161, 0x005E5E5E, 0x005A5A5A, 
        0x00575757, 0x00575757, 0x00585858, 0x005A5A5A, 0x005B5B5B, 0x005F5F5F, 0x00606060, 0x00616161, 0x00626262, 0x00636363, 0x00646464, 0x00666666, 0x00686868, 0x00686868, 0x006E6E6E, 0x00696969, 0x006B6B6B, 0x00737373, 0x006B6B6B, 0x00707070, 
        0x00919191, 0x00B9B9B9, 0x00B1B1B1, 0x00B1B1B1, 0x00ACACAC, 0x00AFAFAF, 0x00AAAAAA, 0x6BBEBEBE, 0xFFD1D1D1, 0xFFDEDEDE, 0xFFE6E6E6, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE2E2E2, 0xFFD9D9D9, 0xFFCCCCCC, 0xDC838383, 0x23575757, 0x00616161, 0x006A6A6A, 0x00727272, 0x00797979, 0x00818181, 0x00646464, 0x00646464, 0x00595959, 
        0x005E5E5E, 0x00606060, 0x005C5C5C, 0x005C5B5D, 0x00575658, 0x00565557, 0x00555456, 0x00535254, 0x00515052, 0x004F4E50, 0x004D4C4E, 0x004B4A4C, 0x004A494B, 0x00484749, 0x00464547, 0x00434244, 0x00414042, 0x003F3E40, 0x003C3B3D, 0x00383739, 
        0x00353436, 0x00313032, 0x002F2E30, 0x002D2C2E, 0x002E2D2F, 0x00313032, 0x00353436, 0x003A393B, 0x003D3C3E, 0x00434244, 0x00474648, 0x004D4C4E, 0x00535254, 0x0059585A, 0x005F5E60, 0x00666567, 0x006B6A6C, 0x00737274, 0x00787779, 0x00818181, 
        0x00898989, 0x00919191, 0x009A9A9A, 0x00A4A4A4, 0x00AAAAAA, 0x00B5B5B5, 0x00BEBEBE, 0x00C6C6C6, 0x00CECECE, 0x00D8D8D8, 0x00E0E0E0, 0x00E8E8E8, 0x00F1F1F1, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00F5F5F5, 0x00EAEAEA, 0x00E1E1E1, 0x00D6D6D6, 
        0x00CCCCCC, 0x00C4C4C4, 0x00BBBBBB, 0x00B2B2B2, 0x00AAAAAA, 0x00A0A0A0, 0x00999999, 0x00939393, 0x008C8C8C, 0x00858585, 0x00818181, 0x007A7A7A, 0x00747474, 0x006F6F6F, 0x006A6A6A, 0x00646464, 0x00616161, 0x005A5A5A, 0x00595959, 0x00585858, 
        0x00585858, 0x00595959, 0x005C5C5C, 0x005E5E5E, 0x005F5F5F, 0x00626262, 0x00636363, 0x00656565, 0x00656565, 0x00666666, 0x00676767, 0x00696969, 0x006B6B6B, 0x006A6A6A, 0x00707070, 0x006D6D6D, 0x006E6E6E, 0x00757575, 0x006B6B6B, 0x00767676, 
        0x007C7C7C, 0x00B3B3B3, 0x00B5B5B5, 0x00B4B4B4, 0x00B1B1B1, 0x00B0B0B0, 0x00ACACAC, 0x23B7B7B7, 0xDCCBCBCB, 0xFFDADADA, 0xFFE2E2E2, 0xFFECECEC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDEDEDE, 0xFFD5D5D5, 0xFFC2C2C2, 0x99595959, 0x004F4F4F, 0x00595959, 0x00646464, 0x00686868, 0x00737373, 0x00727272, 0x00656565, 0x00626262, 0x00666666, 
        0x00646464, 0x005D5D5D, 0x005D5D5D, 0x005F5E60, 0x005B5A5C, 0x005A595B, 0x0059585A, 0x00575658, 0x00555456, 0x00535254, 0x00525153, 0x004F4E50, 0x004E4D4F, 0x004B4A4C, 0x0049484A, 0x00464547, 0x00434244, 0x00424143, 0x003F3E40, 0x003C3B3D, 
        0x0039383A, 0x00363537, 0x00333234, 0x002E2D2F, 0x002B2A2C, 0x002C2B2D, 0x00302F31, 0x00353436, 0x0039383A, 0x00403F41, 0x00444345, 0x004A494B, 0x00504F51, 0x00565557, 0x005C5B5D, 0x00636264, 0x00686769, 0x00706F71, 0x00757476, 0x007E7E7E, 
        0x00878787, 0x008F8F8F, 0x00989898, 0x00A2A2A2, 0x00A8A8A8, 0x00B3B3B3, 0x00BDBDBD, 0x00C5C5C5, 0x00CECECE, 0x00D8D8D8, 0x00E1E1E1, 0x00E9E9E9, 0x00F2F2F2, 0x00FDFDFD, 0x00FFFFFF, 0x00FDFDFD, 0x00F2F2F2, 0x00E7E7E7, 0x00DEDEDE, 0x00D2D2D2, 
        0x00C7C7C7, 0x00BEBEBE, 0x00B5B5B5, 0x00ACACAC, 0x00A4A4A4, 0x009A9A9A, 0x00939393, 0x008D8D8D, 0x00858585, 0x007F7F7F, 0x007B7B7B, 0x00747474, 0x006E6E6E, 0x00696969, 0x00646464, 0x005F5F5F, 0x005B5B5B, 0x00565656, 0x00565656, 0x00575757, 
        0x005A5A5A, 0x005D5D5D, 0x00606060, 0x00616161, 0x00626262, 0x00636363, 0x00656565, 0x00686868, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006C6C6C, 0x006D6D6D, 0x006E6E6E, 0x006D6D6D, 0x00737373, 0x00737373, 0x006D6D6D, 0x00737373, 0x00787878, 
        0x00737373, 0x00A6A6A6, 0x00B5B5B5, 0x00B4B4B4, 0x00B5B5B5, 0x00AFAEB0, 0x00AEAEAE, 0x00B0AFB1, 0x99C4C4C4, 0xFFD6D6D6, 0xFFDFDFDF, 0xFFEAEAEA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDBDB, 0xFFCDCDCD, 0xFFA2A2A2, 0x57414141, 0x00484848, 0x00525252, 0x00555555, 0x00656565, 0x00676767, 0x006D6D6D, 0x00686769, 0x00676668, 0x00666567, 
        0x00656466, 0x00646365, 0x00626163, 0x00605F61, 0x005F5E60, 0x005E5D5F, 0x005D5C5E, 0x005B5A5C, 0x0059585A, 0x00575658, 0x00555456, 0x00535254, 0x00525153, 0x004E4D4F, 0x004D4C4E, 0x004B4A4C, 0x00484749, 0x00464547, 0x00434244, 0x00414042, 
        0x003F3E40, 0x0039383A, 0x00383739, 0x00343335, 0x00302F31, 0x002C2B2D, 0x002D2C2E, 0x00313032, 0x00343335, 0x003B3A3C, 0x003E3D3F, 0x00454446, 0x004C4B4D, 0x00515052, 0x00565557, 0x005D5C5E, 0x00636264, 0x006C6B6D, 0x00747375, 0x007B7A7C, 
        0x00838284, 0x008D8C8E, 0x00939294, 0x009C9B9D, 0x00A8A7A9, 0x00AFAFAF, 0x00BABABA, 0x00C4C4C4, 0x00CDCDCD, 0x00D7D7D7, 0x00E0E0E0, 0x00EAEAEA, 0x00F4F4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FAFAFA, 0x00EEEEEE, 0x00E2E2E2, 0x00D8D8D8, 0x00CCCCCC, 
        0x00C2C2C2, 0x00B7B7B7, 0x00AFAFAF, 0x00A6A6A6, 0x009E9E9E, 0x00969696, 0x008D8D8D, 0x00858585, 0x00818181, 0x00787878, 0x00737373, 0x006D6D6D, 0x00686868, 0x00646464, 0x005E5E5E, 0x00595959, 0x00565656, 0x00575757, 0x00595959, 0x005B5B5B, 
        0x005E5E5E, 0x00606060, 0x00616161, 0x00636363, 0x00656565, 0x00676767, 0x00686868, 0x006A6A6A, 0x006B6B6B, 0x006C6C6C, 0x006D6D6D, 0x006F6F6F, 0x00707070, 0x00727272, 0x00727272, 0x00737274, 0x00747375, 0x00757476, 0x00767577, 0x00777678, 
        0x00787779, 0x0089888A, 0x00BBBABC, 0x00B5B4B6, 0x00B5B4B6, 0x00B5B4B8, 0x00AFAEB0, 0x00B3B2B6, 0x57BBBABC, 0xFFCFCFCF, 0xFFDDDDDD, 0xFFE9E9E9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD8D8D8, 0xFFCDCDCD, 0xD8727272, 0x17393939, 0x003F3F3F, 0x004B4B4B, 0x004F4F4F, 0x005D5D5D, 0x00606060, 0x006B6B6B, 0x006B6A6C, 0x006A696B, 0x0069686A, 
        0x00676668, 0x00666567, 0x00656466, 0x00636264, 0x00616062, 0x00616062, 0x00605F61, 0x005E5D5F, 0x005C5B5D, 0x005A595B, 0x00585759, 0x00565557, 0x00555456, 0x00525153, 0x00504F51, 0x004E4D4F, 0x004C4B4D, 0x004A494B, 0x00474648, 0x00444345, 
        0x00424143, 0x003E3D3F, 0x003C3B3D, 0x00383739, 0x00343335, 0x002F2E30, 0x002D2C2E, 0x002E2D2F, 0x002F2E30, 0x00363537, 0x003A393B, 0x00403F41, 0x00464547, 0x004B4A4C, 0x00515052, 0x005A595B, 0x00626163, 0x00666567, 0x006E6D6F, 0x00767577, 
        0x007E7D7F, 0x00888789, 0x008F8E90, 0x0099989A, 0x00A4A3A5, 0x00AEAEAE, 0x00B9B9B9, 0x00C3C3C3, 0x00CDCDCD, 0x00D8D8D8, 0x00E1E1E1, 0x00EBEBEB, 0x00F6F6F6, 0x00FFFFFF, 0x00FDFDFD, 0x00F5F5F5, 0x00E9E9E9, 0x00DDDDDD, 0x00D3D3D3, 0x00C6C6C6, 
        0x00BCBCBC, 0x00B2B2B2, 0x00A9A9A9, 0x009E9E9E, 0x00969696, 0x008F8F8F, 0x00868686, 0x007E7E7E, 0x007A7A7A, 0x00747474, 0x006D6D6D, 0x00666666, 0x00616161, 0x005E5E5E, 0x005A5A5A, 0x00585858, 0x00585858, 0x005A5A5A, 0x005C5C5C, 0x005E5E5E, 
        0x00606060, 0x00626262, 0x00646464, 0x00666666, 0x00676767, 0x00696969, 0x006A6A6A, 0x006C6C6C, 0x006D6D6D, 0x006E6E6E, 0x00707070, 0x00717171, 0x00737373, 0x00737373, 0x00747474, 0x00747375, 0x00757476, 0x00777678, 0x00787779, 0x00787779, 
        0x0079787A, 0x00838284, 0x00B1B0B2, 0x00B8B7BB, 0x00B7B6BA, 0x00B6B5B9, 0x00B1B0B4, 0x00B3B2B6, 0x17B8B7B9, 0xD8CCCBCD, 0xFFDBDBDB, 0xFFE7E7E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD9D9D9, 0xFFC8C8C8, 0x9D3C3C3C, 0x00323232, 0x00363636, 0x00424242, 0x00484848, 0x00535353, 0x00616161, 0x006F6F6F, 0x006E6D6F, 0x006D6C6E, 0x006C6B6D, 
        0x006B6A6C, 0x006A696B, 0x0069686A, 0x00676668, 0x00656466, 0x00656466, 0x00646365, 0x00626163, 0x00605F61, 0x005E5D5F, 0x005D5C5E, 0x005B5A5C, 0x0059585A, 0x00575658, 0x00555456, 0x00535254, 0x00515052, 0x004F4E50, 0x004C4B4D, 0x0049484A, 
        0x00474648, 0x00444345, 0x00414042, 0x003E3D3F, 0x003A393B, 0x00363537, 0x00323133, 0x002E2D2F, 0x002C2B2D, 0x00302F31, 0x00343335, 0x003A393B, 0x00403F41, 0x00454446, 0x004B4A4C, 0x00545355, 0x005C5B5D, 0x00616062, 0x0069686A, 0x00717072, 
        0x007A797B, 0x00858486, 0x008D8C8E, 0x00979698, 0x00A3A2A4, 0x00ADADAD, 0x00B8B8B8, 0x00C2C2C2, 0x00CCCCCC, 0x00D8D8D8, 0x00E2E2E2, 0x00EDEDED, 0x00F9F9F9, 0x00FFFFFF, 0x00FCFCFC, 0x00F1F1F1, 0x00E3E3E3, 0x00D8D8D8, 0x00CDCDCD, 0x00C0C0C0, 
        0x00B5B5B5, 0x00ABABAB, 0x00A1A1A1, 0x00969696, 0x008E8E8E, 0x00888888, 0x00808080, 0x00787878, 0x00737373, 0x006D6D6D, 0x00666666, 0x005E5E5E, 0x005A5A5A, 0x00585858, 0x00575757, 0x00595959, 0x005B5B5B, 0x005E5E5E, 0x00606060, 0x00626262, 
        0x00646464, 0x00666666, 0x00686868, 0x00696969, 0x006B6B6B, 0x006D6D6D, 0x006E6E6E, 0x006F6F6F, 0x00717171, 0x00727272, 0x00737373, 0x00747474, 0x00767676, 0x00757575, 0x00767676, 0x00777678, 0x00787779, 0x0079787A, 0x007A797B, 0x007A797B, 
        0x007B7A7C, 0x007D7C7E, 0x00A1A0A2, 0x00BBBABE, 0x00BAB9BD, 0x00B8B7BB, 0x00B3B2B6, 0x00B4B3B7, 0x00B4B3B5, 0x9DC7C6C8, 0xFFD6D6D6, 0xFFE3E3E3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD5D5D5, 0xFFABABAB, 0x631E1E1E, 0x002A2A2A, 0x00303030, 0x00383838, 0x003E3E3E, 0x00474747, 0x006B6B6B, 0x00757575, 0x00717072, 0x00717072, 0x006F6E70, 
        0x006E6D6F, 0x006E6D6F, 0x006C6B6D, 0x006B6A6C, 0x0069686A, 0x0069686A, 0x00676668, 0x00666567, 0x00646365, 0x00626163, 0x00616062, 0x005F5E60, 0x005E5D5F, 0x005B5A5C, 0x0059585A, 0x00575658, 0x00555456, 0x00535254, 0x00504F51, 0x004E4D4F, 
        0x004C4B4D, 0x00484749, 0x00464547, 0x00424143, 0x003F3E40, 0x003D3C3E, 0x00383739, 0x00333234, 0x002F2E30, 0x002D2C2E, 0x002F2E30, 0x00353436, 0x003C3B3D, 0x00424143, 0x00484749, 0x004E4D4F, 0x00535254, 0x005C5B5D, 0x00646365, 0x006D6C6E, 
        0x00767577, 0x00818082, 0x0089888A, 0x00949395, 0x00A09FA1, 0x00ABABAB, 0x00B7B7B7, 0x00C2C2C2, 0x00CCCCCC, 0x00D8D8D8, 0x00E3E3E3, 0x00EFEFEF, 0x00FBFBFB, 0x00FFFFFF, 0x00F9F9F9, 0x00EBEBEB, 0x00DCDCDC, 0x00D1D1D1, 0x00C6C6C6, 0x00B8B8B8, 
        0x00ADADAD, 0x00A3A3A3, 0x00999999, 0x008F8F8F, 0x00888888, 0x00828282, 0x007A7A7A, 0x00717171, 0x006C6C6C, 0x00646464, 0x005E5E5E, 0x00595959, 0x00575757, 0x00575757, 0x00595959, 0x005D5D5D, 0x00606060, 0x00626262, 0x00646464, 0x00666666, 
        0x00686868, 0x00696969, 0x006B6B6B, 0x006D6D6D, 0x006E6E6E, 0x006F6F6F, 0x00707070, 0x00727272, 0x00737373, 0x00747474, 0x00757575, 0x00777777, 0x00787878, 0x00787878, 0x00787878, 0x0079787A, 0x007A797B, 0x007B7A7C, 0x007C7B7D, 0x007C7B7D, 
        0x007D7C7E, 0x007A797B, 0x00939294, 0x00BCBBBF, 0x00BCBBBF, 0x00BAB9BD, 0x00B6B5B9, 0x00B5B4B8, 0x00B2B1B3, 0x63C2C1C3, 0xFFD2D2D2, 0xFFE0E0E0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCDCDCD, 0xF5777777, 0x2B141414, 0x001F1F1F, 0x002A2A2A, 0x002E2E2E, 0x00353535, 0x00424242, 0x00757575, 0x00767676, 0x00747375, 0x00737274, 0x00727173, 
        0x00717072, 0x00717072, 0x006F6E70, 0x006E6D6F, 0x006D6C6E, 0x006C6B6D, 0x006B6A6C, 0x0069686A, 0x00676668, 0x00666567, 0x00656466, 0x00636264, 0x00626163, 0x005E5D5F, 0x005D5C5E, 0x005B5A5C, 0x0059585A, 0x00575658, 0x00545355, 0x00525153, 
        0x00504F51, 0x004D4C4E, 0x004A494B, 0x00464547, 0x00434244, 0x00424143, 0x003E3D3F, 0x0039383A, 0x00353436, 0x002F2E30, 0x002E2D2F, 0x002F2E30, 0x00343335, 0x003C3B3D, 0x00424143, 0x00484749, 0x004D4C4E, 0x00565557, 0x005E5D5F, 0x00666567, 
        0x00706F71, 0x007B7A7C, 0x00848385, 0x008F8E90, 0x009C9B9D, 0x00A9A9A9, 0x00B5B5B5, 0x00C0C0C0, 0x00CCCCCC, 0x00D9D9D9, 0x00E4E4E4, 0x00F0F0F0, 0x00FCFCFC, 0x00FFFFFF, 0x00F4F4F4, 0x00E4E4E4, 0x00D5D5D5, 0x00C9C9C9, 0x00BEBEBE, 0x00B0B0B0, 
        0x00A5A5A5, 0x009A9A9A, 0x00919191, 0x00878787, 0x00808080, 0x00797979, 0x00707070, 0x00676767, 0x00626262, 0x005B5B5B, 0x00595959, 0x00585858, 0x00595959, 0x005B5B5B, 0x005D5D5D, 0x00606060, 0x00646464, 0x00666666, 0x00676767, 0x00696969, 
        0x006B6B6B, 0x006C6C6C, 0x006E6E6E, 0x006F6F6F, 0x00717171, 0x00727272, 0x00737373, 0x00747474, 0x00757575, 0x00767676, 0x00777777, 0x00797979, 0x007A7A7A, 0x007A7A7A, 0x007B7B7B, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 
        0x007F7E80, 0x007D7C7E, 0x008A898B, 0x00B7B6BA, 0x00BDBCC0, 0x00BBBABE, 0x00B9B8BC, 0x00B7B6BA, 0x00B3B2B4, 0x2BBEBDBF, 0xF5CECECE, 0xFFDDDDDD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC8C8C8, 0xC2454545, 0x00101010, 0x00141414, 0x00232323, 0x00262626, 0x002E2E2E, 0x004C4C4C, 0x007A7A7A, 0x00777777, 0x00777678, 0x00767577, 0x00757476, 
        0x00757476, 0x00747375, 0x00737274, 0x00717072, 0x00706F71, 0x00706F71, 0x006E6D6F, 0x006D6C6E, 0x006B6A6C, 0x006A696B, 0x0069686A, 0x00676668, 0x00666567, 0x00636264, 0x00626163, 0x00605F61, 0x005E5D5F, 0x005C5B5D, 0x0059585A, 0x00575658, 
        0x00555456, 0x00525153, 0x004F4E50, 0x004B4A4C, 0x00484749, 0x00464547, 0x00424143, 0x003E3D3F, 0x003B3A3C, 0x00363537, 0x00302F31, 0x002C2B2D, 0x002D2C2E, 0x00333234, 0x003B3A3C, 0x00424143, 0x00484749, 0x00515052, 0x0059585A, 0x00616062, 
        0x006B6A6C, 0x00767577, 0x00807F81, 0x008B8A8C, 0x00989799, 0x00A6A6A6, 0x00B2B2B2, 0x00BFBFBF, 0x00CBCBCB, 0x00DADADA, 0x00E6E6E6, 0x00F2F2F2, 0x00FEFEFE, 0x00FDFDFD, 0x00F1F1F1, 0x00DEDEDE, 0x00CFCFCF, 0x00C3C3C3, 0x00B6B6B6, 0x00A8A8A8, 
        0x009E9E9E, 0x00939393, 0x008A8A8A, 0x00808080, 0x00787878, 0x00707070, 0x00676767, 0x005F5F5F, 0x005B5B5B, 0x00575757, 0x00575757, 0x005A5A5A, 0x005E5E5E, 0x00616161, 0x00626262, 0x00656565, 0x00676767, 0x006A6A6A, 0x006B6B6B, 0x006D6D6D, 
        0x006F6F6F, 0x00707070, 0x00717171, 0x00737373, 0x00747474, 0x00747474, 0x00767676, 0x00777777, 0x00787878, 0x00797979, 0x007A7A7A, 0x007B7B7B, 0x007C7C7C, 0x007D7D7D, 0x007D7D7D, 0x007E7D7F, 0x007F7E80, 0x00807F81, 0x00818082, 0x00818082, 
        0x00818082, 0x00828183, 0x00868587, 0x00ACABAF, 0x00BEBDC1, 0x00BDBCC0, 0x00BBBABE, 0x00B8B7BB, 0x00B7B6B8, 0x00BAB9BB, 0xC2CBCBCB, 0xFFDADADA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C2C2, 0x921C1C1C, 0x00080808, 0x000E0E0E, 0x00181818, 0x001D1D1D, 0x00282828, 0x00606060, 0x007C7C7C, 0x007C7C7C, 0x007B7A7C, 0x007A797B, 0x0079787A, 
        0x00787779, 0x00787779, 0x00777678, 0x00757476, 0x00747375, 0x00747375, 0x00727173, 0x00717072, 0x00706F71, 0x006F6E70, 0x006D6C6E, 0x006C6B6D, 0x006B6A6C, 0x0069686A, 0x00676668, 0x00656466, 0x00636264, 0x00616062, 0x005F5E60, 0x005C5B5D, 
        0x005B5A5C, 0x00575658, 0x00555456, 0x00525153, 0x004F4E50, 0x004C4B4D, 0x00484749, 0x00444345, 0x00414042, 0x003D3C3E, 0x00383739, 0x00323133, 0x002F2E30, 0x002F2E30, 0x00333234, 0x003A393B, 0x00414042, 0x004A494B, 0x00525153, 0x005B5A5C, 
        0x00656466, 0x00717072, 0x007B7A7C, 0x00888789, 0x00959496, 0x00A1A1A1, 0x00AFAFAF, 0x00BDBDBD, 0x00CBCBCB, 0x00DBDBDB, 0x00E7E7E7, 0x00F4F4F4, 0x00FFFFFF, 0x00F8F8F8, 0x00EBEBEB, 0x00D8D8D8, 0x00C8C8C8, 0x00BABABA, 0x00ADADAD, 0x009F9F9F, 
        0x00959595, 0x00898989, 0x00818181, 0x00777777, 0x006E6E6E, 0x00666666, 0x005E5E5E, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005E5E5E, 0x00636363, 0x00666666, 0x00686868, 0x00696969, 0x006C6C6C, 0x006E6E6E, 0x006F6F6F, 0x00717171, 
        0x00737373, 0x00747474, 0x00757575, 0x00767676, 0x00777777, 0x00787878, 0x00797979, 0x007A7A7A, 0x007B7B7B, 0x007C7C7C, 0x007D7D7D, 0x007E7E7E, 0x007F7F7F, 0x00808080, 0x00808080, 0x00818082, 0x00828183, 0x00838284, 0x00838284, 0x00848385, 
        0x00848385, 0x00868587, 0x00858486, 0x009F9EA2, 0x00BDBCC0, 0x00BEBDC1, 0x00BCBBBF, 0x00B9B8BC, 0x00BBBABC, 0x00B8B7B9, 0x92C8C8C8, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B6B6, 0x64000000, 0x00000000, 0x000B0B0B, 0x000E0E0E, 0x00131313, 0x00202020, 0x006E6E6E, 0x00797979, 0x00808080, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 
        0x007B7A7C, 0x007B7A7C, 0x007A797B, 0x00787779, 0x00777678, 0x00767577, 0x00757476, 0x00747375, 0x00737274, 0x00727173, 0x00706F71, 0x006F6E70, 0x006E6D6F, 0x006D6C6E, 0x006B6A6C, 0x0069686A, 0x00676668, 0x00656466, 0x00636264, 0x00616062, 
        0x005F5E60, 0x005A595B, 0x0059585A, 0x00575658, 0x00555456, 0x00525153, 0x004E4D4F, 0x004A494B, 0x00474648, 0x00424143, 0x003F3E40, 0x003A393B, 0x00353436, 0x002F2E30, 0x002E2D2F, 0x00333234, 0x0039383A, 0x00434244, 0x004B4A4C, 0x00545355, 
        0x005F5E60, 0x006C6B6D, 0x00767577, 0x00838284, 0x00908F91, 0x009E9E9E, 0x00ACACAC, 0x00BCBCBC, 0x00CBCBCB, 0x00DBDBDB, 0x00E8E8E8, 0x00F5F5F5, 0x00FFFFFF, 0x00F1F1F1, 0x00E4E4E4, 0x00D1D1D1, 0x00C0C0C0, 0x00B1B1B1, 0x00A2A2A2, 0x00959595, 
        0x008C8C8C, 0x007F7F7F, 0x00777777, 0x006D6D6D, 0x00646464, 0x005D5D5D, 0x00585858, 0x00575757, 0x00595959, 0x005F5F5F, 0x00606060, 0x00636363, 0x00676767, 0x006A6A6A, 0x006B6B6B, 0x006D6D6D, 0x00707070, 0x00707070, 0x00727272, 0x00747474, 
        0x00757575, 0x00767676, 0x00787878, 0x00797979, 0x007A7A7A, 0x007A7A7A, 0x007B7B7B, 0x007D7D7D, 0x007E7E7E, 0x007E7E7E, 0x007F7F7F, 0x00818181, 0x00828282, 0x00828282, 0x00828282, 0x00838284, 0x00848385, 0x00848385, 0x00858486, 0x00868587, 
        0x00868587, 0x00878688, 0x00848385, 0x0097969A, 0x00BDBCC0, 0x00C0BFC3, 0x00BDBCC0, 0x00BAB9BD, 0x00BDBCBE, 0x00B6B5B7, 0x64C6C6C6, 0xFFD5D5D5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF858585, 0x38010101, 0x00000000, 0x00010101, 0x00070707, 0x000E0E0E, 0x001C1C1C, 0x007F7F7F, 0x00858585, 0x007F7F7F, 0x007F7E80, 0x007F7E80, 0x007E7D7F, 
        0x007E7D7F, 0x007D7C7E, 0x007C7B7D, 0x007C7B7D, 0x007B7A7C, 0x007A797B, 0x0079787A, 0x00777678, 0x00777678, 0x00767577, 0x00757476, 0x00747375, 0x00737274, 0x00717072, 0x00706F71, 0x006E6D6F, 0x006C6B6D, 0x006B6A6C, 0x0069686A, 0x00666567, 
        0x00656466, 0x00616062, 0x00605F61, 0x005D5C5E, 0x005A595B, 0x00575658, 0x00545355, 0x00515052, 0x004F4E50, 0x0049484A, 0x00464547, 0x00414042, 0x003B3A3C, 0x00353436, 0x00313032, 0x002F2E30, 0x002E2D2F, 0x0039383A, 0x00424143, 0x004B4A4C, 
        0x00565557, 0x00636264, 0x006F6E70, 0x007C7B7D, 0x0089888A, 0x00979797, 0x00ACACAC, 0x00B7B7B7, 0x00C9C9C9, 0x00DDDDDD, 0x00ECECEC, 0x00FCFCFC, 0x00FEFEFE, 0x00EDEDED, 0x00DADADA, 0x00C6C6C6, 0x00B5B5B5, 0x00A4A4A4, 0x00979797, 0x008B8B8B, 
        0x00808080, 0x00777777, 0x006C6C6C, 0x00606060, 0x005A5A5A, 0x00595959, 0x005A5A5A, 0x005E5E5E, 0x00626262, 0x00646464, 0x00666666, 0x00686868, 0x006B6B6B, 0x006D6D6D, 0x006F6F6F, 0x00717171, 0x00737373, 0x00757476, 0x00767577, 0x00787779, 
        0x0079787A, 0x007A797B, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007F7E80, 0x007F7E80, 0x00807F81, 0x00818082, 0x00828183, 0x00838284, 0x00838284, 0x00848385, 0x00858585, 0x00858585, 0x00868587, 0x00878688, 0x00878688, 0x00888789, 0x0089888A, 
        0x0089888A, 0x00868587, 0x008D8C8E, 0x008D8C90, 0x00BBBABE, 0x00C1C0C4, 0x00C0BFC3, 0x00BCBBBF, 0x00BDBCBE, 0x00BCBBBD, 0x38C4C4C4, 0xFFD0D0D0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE66B6B6B, 0x0E010101, 0x00000000, 0x00000000, 0x00020202, 0x00080808, 0x00262626, 0x00838383, 0x00878787, 0x00828282, 0x00828183, 0x00828183, 0x00818082, 
        0x00818082, 0x00807F81, 0x007F7E80, 0x007F7E80, 0x007F7E80, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 0x007A797B, 0x0079787A, 0x00787779, 0x00777678, 0x00757476, 0x00767577, 0x00757476, 0x00737274, 0x00727173, 0x00706F71, 0x006E6D6F, 0x006C6B6D, 
        0x006A696B, 0x00686769, 0x00666567, 0x00636264, 0x00616062, 0x005E5D5F, 0x005B5A5C, 0x00585759, 0x00565557, 0x004F4E50, 0x004C4B4D, 0x00484749, 0x00424143, 0x003D3C3E, 0x00373638, 0x00333234, 0x00302F31, 0x00302F31, 0x003A393B, 0x00434244, 
        0x004D4C4E, 0x005A595B, 0x00666567, 0x00767577, 0x00868587, 0x00929292, 0x00A7A7A7, 0x00B6B6B6, 0x00C9C9C9, 0x00DCDCDC, 0x00EEEEEE, 0x00FDFDFD, 0x00F8F8F8, 0x00E6E6E6, 0x00D2D2D2, 0x00BCBCBC, 0x00ABABAB, 0x009B9B9B, 0x008E8E8E, 0x00818181, 
        0x00757575, 0x00686868, 0x00616161, 0x005B5B5B, 0x00595959, 0x005B5B5B, 0x005E5E5E, 0x00626262, 0x00666666, 0x00696969, 0x006B6B6B, 0x006E6E6E, 0x00707070, 0x00727272, 0x00747474, 0x00767676, 0x00777777, 0x00787779, 0x0079787A, 0x007A797B, 
        0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x00818082, 0x00828183, 0x00828183, 0x00838284, 0x00838284, 0x00848385, 0x00858486, 0x00868587, 0x00868587, 0x00878787, 0x00878787, 0x00888789, 0x00888789, 0x0089888A, 0x008A898B, 0x008A898B, 
        0x008A898B, 0x00888789, 0x008E8D8F, 0x008C8B8F, 0x00B7B6BA, 0x00C1C0C4, 0x00C1C0C4, 0x00BDBCC0, 0x00BEBDBF, 0x00BCBBBD, 0x0EC3C3C3, 0xE6CFCFCF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xC2494949, 0x00040404, 0x00010101, 0x00000000, 0x00000000, 0x00030303, 0x00383838, 0x00898989, 0x00888888, 0x00878787, 0x00868587, 0x00868587, 0x00858486, 
        0x00858486, 0x00848385, 0x00848385, 0x00838284, 0x00838284, 0x00828183, 0x00818082, 0x007F7E80, 0x007E7D7F, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 0x0079787A, 0x007A797B, 0x0079787A, 0x00777678, 0x00767577, 0x00747375, 0x00737274, 0x00717072, 
        0x006F6E70, 0x006D6C6E, 0x006C6B6D, 0x0069686A, 0x00676668, 0x00646365, 0x00616062, 0x005E5D5F, 0x005D5C5E, 0x00575658, 0x00535254, 0x004F4E50, 0x004B4A4C, 0x00464547, 0x00403F41, 0x0039383A, 0x00343335, 0x002C2B2D, 0x00323133, 0x00383739, 
        0x00424143, 0x00504F51, 0x005D5C5E, 0x006D6C6E, 0x007C7B7D, 0x008D8D8D, 0x00A1A1A1, 0x00B6B6B6, 0x00CACACA, 0x00DBDBDB, 0x00F2F2F2, 0x00FFFFFF, 0x00F1F1F1, 0x00D9D9D9, 0x00C4C4C4, 0x00AFAFAF, 0x009E9E9E, 0x008E8E8E, 0x00808080, 0x00727272, 
        0x00666666, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005D5D5D, 0x00606060, 0x00646464, 0x00686868, 0x006C6C6C, 0x006E6E6E, 0x00707070, 0x00727272, 0x00747474, 0x00767676, 0x00787878, 0x00797979, 0x007B7B7B, 0x007B7A7C, 0x007C7B7D, 0x007E7D7F, 
        0x007F7E80, 0x00818082, 0x00828183, 0x00848385, 0x00858486, 0x00858486, 0x00858486, 0x00868587, 0x00878688, 0x00878688, 0x00888789, 0x0089888A, 0x0089888A, 0x008A8A8A, 0x008A8A8A, 0x008A898B, 0x008B8A8C, 0x008C8B8D, 0x008C8B8D, 0x008D8C8E, 
        0x008D8C8E, 0x008C8B8D, 0x008F8E90, 0x008D8C90, 0x00B1B0B4, 0x00C1C0C4, 0x00C3C2C6, 0x00BFBEC2, 0x00BFBEC0, 0x00BCBBBD, 0x00C2C2C2, 0xC2CDCDCD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA12F2F2F, 0x00090909, 0x00040404, 0x00030303, 0x00000000, 0x00000000, 0x004D4D4D, 0x008C8C8C, 0x00898989, 0x008A8A8A, 0x0089888A, 0x0089888A, 0x00888789, 
        0x00888789, 0x00878688, 0x00878688, 0x00868587, 0x00868587, 0x00858486, 0x00848385, 0x00838284, 0x00828183, 0x00818082, 0x00807F81, 0x007F7E80, 0x007E7D7F, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 0x007A797B, 0x0079787A, 0x00777678, 0x00757476, 
        0x00747375, 0x00727173, 0x00717072, 0x006F6E70, 0x006D6C6E, 0x006A696B, 0x00686769, 0x00656466, 0x00636264, 0x005E5D5F, 0x005B5A5C, 0x00575658, 0x00535254, 0x00504F51, 0x004B4A4C, 0x00434244, 0x003E3D3F, 0x00343335, 0x00323133, 0x00302F31, 
        0x00373638, 0x00474648, 0x00555456, 0x00636264, 0x00706F71, 0x00868686, 0x00999999, 0x00B3B3B3, 0x00C7C7C7, 0x00DBDBDB, 0x00F6F6F6, 0x00FDFDFD, 0x00E7E7E7, 0x00CCCCCC, 0x00B7B7B7, 0x00A1A1A1, 0x00909090, 0x007F7F7F, 0x00707070, 0x00646464, 
        0x005A5A5A, 0x005A5A5A, 0x005C5C5C, 0x00616161, 0x00656565, 0x00686868, 0x006B6B6B, 0x006F6F6F, 0x00717171, 0x00737373, 0x00747474, 0x00767676, 0x00787878, 0x007A7A7A, 0x007B7B7B, 0x007D7D7D, 0x007E7E7E, 0x007F7E80, 0x00818082, 0x00828183, 
        0x00838284, 0x00848385, 0x00858486, 0x00878688, 0x00888789, 0x00888789, 0x00888789, 0x0089888A, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008B8A8C, 0x008C8B8D, 0x008C8C8C, 0x008D8D8D, 0x008D8C8E, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008F8E90, 
        0x008F8E90, 0x008F8E90, 0x00908F91, 0x008E8D91, 0x00ABAAAE, 0x00C3C2C6, 0x00C5C4C8, 0x00C1C0C4, 0x00BFBEC0, 0x00BDBCBE, 0x00C1C1C1, 0xA1CACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x831F1F1F, 0x000B0B0B, 0x00070707, 0x00050505, 0x00010101, 0x00000000, 0x00626262, 0x008D8D8D, 0x008A8A8A, 0x008D8D8D, 0x008B8A8C, 0x008B8A8C, 0x008A898B, 
        0x008A898B, 0x0089888A, 0x0089888A, 0x0089888A, 0x00888789, 0x00878688, 0x00878688, 0x00868587, 0x00858486, 0x00858486, 0x00858486, 0x00848385, 0x00838284, 0x00828183, 0x00818082, 0x00807F81, 0x007F7E80, 0x007F7E80, 0x007D7C7E, 0x007C7B7D, 
        0x007A797B, 0x0079787A, 0x00777678, 0x00757476, 0x00747375, 0x00727173, 0x00706F71, 0x006D6C6E, 0x006B6A6C, 0x00686769, 0x00656466, 0x00605F61, 0x005D5C5E, 0x005A595B, 0x00555456, 0x004F4E50, 0x004A494B, 0x00403F41, 0x0039383A, 0x00302F31, 
        0x00302F31, 0x0039383A, 0x00454446, 0x00575658, 0x00686769, 0x007E7E7E, 0x00909090, 0x00AEAEAE, 0x00C4C4C4, 0x00DCDCDC, 0x00F9F9F9, 0x00F7F7F7, 0x00DBDBDB, 0x00BFBFBF, 0x00A9A9A9, 0x00919191, 0x007E7E7E, 0x006C6C6C, 0x00616161, 0x005C5C5C, 
        0x00595959, 0x00606060, 0x00646464, 0x00696969, 0x006C6C6C, 0x006F6F6F, 0x00717171, 0x00747474, 0x00767676, 0x00797979, 0x007A7A7A, 0x007C7C7C, 0x007E7E7E, 0x007F7F7F, 0x00808080, 0x00828282, 0x00838383, 0x00848385, 0x00858486, 0x00868587, 
        0x00878688, 0x00878688, 0x00888789, 0x0089888A, 0x008A898B, 0x008A898B, 0x008B8A8C, 0x008B8A8C, 0x008C8B8D, 0x008C8B8D, 0x008D8C8E, 0x008D8C8E, 0x008E8D8F, 0x008F8F8F, 0x008F8F8F, 0x008F8E90, 0x00908F91, 0x00908F91, 0x00919092, 0x00919092, 
        0x00929193, 0x00919092, 0x00919092, 0x00929195, 0x00A6A5A9, 0x00C5C4C8, 0x00C7C6CA, 0x00C3C2C6, 0x00C0BFC1, 0x00BFBEC0, 0x00C1C1C1, 0x83C8C8C8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x67191919, 0x000C0C0C, 0x000B0B0B, 0x00060606, 0x00040404, 0x00010101, 0x00767676, 0x00909090, 0x008E8E8E, 0x00909090, 0x008E8D8F, 0x008E8D8F, 0x008D8C8E, 
        0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008C8B8D, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x0089888A, 0x0089888A, 0x0089888A, 0x00888789, 0x00888789, 0x00868587, 0x00858486, 0x00848385, 0x00848385, 0x00838284, 0x00828183, 0x00818082, 
        0x007F7E80, 0x007E7D7F, 0x007C7B7D, 0x007B7A7C, 0x0079787A, 0x00787779, 0x00767577, 0x00747375, 0x00727173, 0x00717072, 0x006E6D6F, 0x0069686A, 0x00656466, 0x00626163, 0x005D5C5E, 0x00585759, 0x00545355, 0x004B4A4C, 0x00464547, 0x003B3A3C, 
        0x00323133, 0x00302F31, 0x00353436, 0x00484749, 0x005E5D5F, 0x00747474, 0x00868686, 0x00A8A8A8, 0x00C3C3C3, 0x00E2E2E2, 0x00FDFDFD, 0x00EDEDED, 0x00CBCBCB, 0x00AEAEAE, 0x00959595, 0x007C7C7C, 0x006B6B6B, 0x005E5E5E, 0x005A5A5A, 0x005E5E5E, 
        0x00606060, 0x00686868, 0x006C6C6C, 0x00707070, 0x00727272, 0x00757575, 0x00787878, 0x007A7A7A, 0x007A7A7A, 0x007E7E7E, 0x007F7F7F, 0x00818181, 0x00838383, 0x00848484, 0x00848484, 0x00868686, 0x00878787, 0x00888789, 0x0089888A, 0x008A898B, 
        0x008A898B, 0x008B8A8C, 0x008B8A8C, 0x008C8B8D, 0x008D8C8E, 0x008D8C8E, 0x008E8D8F, 0x008E8D8F, 0x008E8D8F, 0x008F8E90, 0x00908F91, 0x00908F91, 0x00908F91, 0x00929292, 0x00929292, 0x00929193, 0x00939294, 0x00939294, 0x00939294, 0x00949395, 
        0x00949395, 0x00949395, 0x00939294, 0x00959498, 0x00A1A0A4, 0x00C6C5C9, 0x00C9C8CC, 0x00C5C4C8, 0x00C2C1C3, 0x00C1C0C2, 0x00C1C1C1, 0x67C7C7C7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4F1A1A1A, 0x00121212, 0x00121212, 0x00080808, 0x000A0A0A, 0x00070707, 0x00898989, 0x00969696, 0x00949494, 0x00929292, 0x00929193, 0x00929193, 0x00919092, 
        0x00919092, 0x00919092, 0x00908F91, 0x00908F91, 0x00908F91, 0x008F8E90, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008C8B8D, 0x008A898B, 0x0089888A, 0x00888789, 0x00888789, 0x00888789, 0x00878688, 0x00858486, 
        0x00848385, 0x00838284, 0x00828183, 0x00818082, 0x007F7E80, 0x007E7D7F, 0x007D7C7E, 0x007B7A7C, 0x0079787A, 0x00787779, 0x00767577, 0x00737274, 0x006F6E70, 0x006B6A6C, 0x00676668, 0x00636264, 0x00605F61, 0x0059585A, 0x00555456, 0x004C4B4D, 
        0x00424143, 0x0039383A, 0x00333234, 0x003A393B, 0x004A494B, 0x00646464, 0x00797979, 0x009F9F9F, 0x00C0C0C0, 0x00E6E6E6, 0x00FBFBFB, 0x00DCDCDC, 0x00B6B6B6, 0x00959595, 0x007D7D7D, 0x00686868, 0x00606060, 0x005E5E5E, 0x00616161, 0x00686868, 
        0x006C6C6C, 0x00717171, 0x00757575, 0x00787878, 0x007A7A7A, 0x007D7D7D, 0x00808080, 0x00828282, 0x00818181, 0x00848484, 0x00858585, 0x00868686, 0x00888888, 0x00888888, 0x00898989, 0x008A8A8A, 0x008B8B8B, 0x008C8B8D, 0x008D8C8E, 0x008E8D8F, 
        0x008E8D8F, 0x008F8E90, 0x008F8E90, 0x00908F91, 0x00919092, 0x00919092, 0x00919092, 0x00919092, 0x00929193, 0x00929193, 0x00939294, 0x00939294, 0x00939294, 0x00949494, 0x00959595, 0x00959496, 0x00959496, 0x00969597, 0x00969597, 0x00969597, 
        0x00969597, 0x00979698, 0x00959496, 0x0098979B, 0x009D9CA0, 0x00C6C5C9, 0x00C9C8CC, 0x00C7C6CA, 0x00C5C4C6, 0x00C3C2C4, 0x00C1C1C1, 0x4FC6C6C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x391E1E1E, 0x001A1A1A, 0x001A1A1A, 0x000C0C0C, 0x000F0F0F, 0x000C0C0C, 0x00959595, 0x009B9B9B, 0x00989898, 0x00929292, 0x00959496, 0x00959496, 0x00959496, 
        0x00949395, 0x00949395, 0x00939294, 0x00939294, 0x00939294, 0x00939294, 0x00929193, 0x00919092, 0x00919092, 0x00908F91, 0x00908F91, 0x008F8E90, 0x008E8D8F, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 
        0x008A898B, 0x0089888A, 0x00888789, 0x00878688, 0x00868587, 0x00858486, 0x00838284, 0x00828183, 0x00807F81, 0x007D7C7E, 0x007D7C7E, 0x007C7B7D, 0x007A797B, 0x00767577, 0x00727173, 0x006E6D6F, 0x006C6B6D, 0x00656466, 0x00605F61, 0x00585759, 
        0x00515052, 0x0049484A, 0x003A393B, 0x00323133, 0x00353436, 0x00535353, 0x006B6B6B, 0x00949494, 0x00B9B9B9, 0x00E5E5E5, 0x00F5F5F5, 0x00CCCCCC, 0x00A3A3A3, 0x007F7F7F, 0x006A6A6A, 0x005C5C5C, 0x005E5E5E, 0x00656565, 0x006D6D6D, 0x00737373, 
        0x00757575, 0x00797979, 0x007C7C7C, 0x007F7F7F, 0x00818181, 0x00848484, 0x00888888, 0x00888888, 0x00878787, 0x00898989, 0x008B8B8B, 0x008C8C8C, 0x008D8D8D, 0x008E8E8E, 0x008E8E8E, 0x008F8F8F, 0x00909090, 0x008E8D8F, 0x008F8E90, 0x00908F91, 
        0x00919092, 0x00919092, 0x00929193, 0x00939294, 0x00949395, 0x00939294, 0x00939294, 0x00949395, 0x00949395, 0x00959496, 0x00959496, 0x00969597, 0x00969597, 0x00969696, 0x00969696, 0x00979698, 0x00979698, 0x00979698, 0x00989799, 0x00989799, 
        0x00989799, 0x00989799, 0x00969597, 0x009A999D, 0x009A999D, 0x00C6C5C9, 0x00C9C8CC, 0x00C8C7CB, 0x00C8C7CB, 0x00C5C4C6, 0x00C2C2C2, 0x39C6C6C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x27292929, 0x001B1B1B, 0x001B1A1C, 0x00161517, 0x00121113, 0x001F1E20, 0x00959496, 0x0099989A, 0x009B9A9C, 0x00969597, 0x00989799, 0x00979698, 0x00979698, 
        0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00969597, 0x00969597, 0x00969597, 0x00959496, 0x00959496, 0x00959496, 0x00949395, 0x00949395, 0x00939294, 0x00939294, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 0x00919092, 
        0x00919092, 0x008F8E90, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x00868587, 0x00858486, 0x00838284, 0x00818082, 0x007F7E80, 0x007C7B7D, 0x007A797B, 0x00787779, 0x00727173, 0x00717072, 0x006B6A6C, 
        0x00616062, 0x0059585A, 0x004F4E50, 0x00414042, 0x00353436, 0x003B3B3B, 0x00595959, 0x007F7F7F, 0x00B8B8B8, 0x00F0F0F0, 0x00E0E0E0, 0x00AEADAF, 0x007D7C7E, 0x005E5D5F, 0x00616062, 0x00676668, 0x006E6D6F, 0x00747375, 0x0079787A, 0x007D7C7E, 
        0x00807F81, 0x00828183, 0x00838284, 0x00868587, 0x00888789, 0x0089888A, 0x008B8A8C, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008F8E90, 0x00908F91, 0x00919092, 0x00929193, 0x00939294, 0x00949395, 0x00949395, 0x00949395, 0x00949395, 0x00959496, 
        0x00959496, 0x00969597, 0x00969597, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00989799, 0x00989799, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x009A999B, 
        0x009A999B, 0x0098999D, 0x0097989C, 0x0096979B, 0x009C9DA1, 0x00B9BABE, 0x00C4C5C9, 0x00C7C8CC, 0x00C6C7CB, 0x00C9C8CC, 0x00C7C6C8, 0x27C8C7C9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x182B2B2B, 0x001F1F1F, 0x001E1D1F, 0x001A191B, 0x00141315, 0x00262527, 0x00989799, 0x009C9B9D, 0x009C9B9D, 0x0099989A, 0x009A999B, 0x009A999B, 0x009A999B, 
        0x009A999B, 0x009A999B, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00989799, 0x00989799, 0x00979698, 0x00979698, 0x00969597, 0x00969597, 0x00969597, 0x00969597, 0x00959496, 0x00959496, 0x00959496, 
        0x00949395, 0x00939294, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 0x00908F91, 0x00908F91, 0x008F8E90, 0x008F8E90, 0x008E8D8F, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x00888789, 0x00868587, 0x00848385, 0x00818082, 0x00818082, 0x007D7C7E, 
        0x00767577, 0x006F6E70, 0x00686769, 0x005B5A5C, 0x004F4E50, 0x003C3C3C, 0x003B3B3B, 0x006C6C6C, 0x00ABABAB, 0x00E6E6E6, 0x00C6C6C6, 0x00838284, 0x005F5E60, 0x00676668, 0x006C6B6D, 0x00747375, 0x007C7B7D, 0x00828183, 0x00858486, 0x00878688, 
        0x0089888A, 0x008B8A8C, 0x008D8C8E, 0x008F8E90, 0x00908F91, 0x00919092, 0x00929193, 0x00949395, 0x00959496, 0x00949395, 0x00949395, 0x00959496, 0x00959496, 0x00969597, 0x00979698, 0x00979698, 0x00989799, 0x00979698, 0x00979698, 0x00989799, 
        0x00989799, 0x00989799, 0x0099989A, 0x0099989A, 0x0099989A, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009C9B9D, 0x009C9B9D, 
        0x009C9B9D, 0x009A9B9F, 0x00999A9E, 0x00999A9E, 0x009D9EA2, 0x00B7B8BC, 0x00C1C2C6, 0x00C5C6CA, 0x00C4C5C9, 0x00C9C8CC, 0x00C7C6CA, 0x18C9C8CA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0C2F2F2F, 0x00262626, 0x00232224, 0x001F1E20, 0x00171618, 0x002F2E30, 0x009B9A9C, 0x00A09FA1, 0x009C9B9D, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009D9C9E, 
        0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 
        0x009A999B, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00989799, 0x00989799, 0x00959496, 0x00949395, 0x00939294, 0x00939294, 0x00929193, 0x00919092, 0x00908F91, 0x008F8E90, 0x008D8C8E, 0x008D8C8E, 0x008B8A8C, 
        0x00878688, 0x00848385, 0x00818082, 0x007A797B, 0x00727173, 0x00616161, 0x004A4A4A, 0x003E3E3E, 0x00959595, 0x00DDDDDD, 0x00858585, 0x00646365, 0x00727173, 0x007B7A7C, 0x00807F81, 0x00878688, 0x008C8B8D, 0x008F8E90, 0x00919092, 0x00929193, 
        0x00929193, 0x00939294, 0x00949395, 0x00959496, 0x00969597, 0x00969597, 0x00969597, 0x00979698, 0x00989799, 0x009A999B, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 
        0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 
        0x009F9EA0, 0x009D9EA2, 0x009D9EA2, 0x009C9DA1, 0x009D9EA2, 0x00B5B6BA, 0x00BCBDC1, 0x00C1C2C6, 0x00C2C3C7, 0x00C9C8CC, 0x00C7C6CA, 0x0CC9C8CA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x04323232, 0x002B2B2B, 0x00272628, 0x00242325, 0x001B1A1C, 0x00363537, 0x009E9D9F, 0x00A3A2A4, 0x009D9C9E, 0x00A1A0A2, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 
        0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 
        0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009C9B9D, 0x009B9A9C, 0x009B9A9C, 0x009A999B, 0x00989799, 
        0x00969597, 0x00979698, 0x00989799, 0x00969597, 0x00929193, 0x008D8D8D, 0x007F7F7F, 0x00707070, 0x00696969, 0x00A3A3A3, 0x007C7C7C, 0x00888789, 0x00908F91, 0x00949395, 0x00979698, 0x009A999B, 0x009A999B, 0x009A999B, 0x009B9A9C, 0x009D9C9E, 
        0x009D9C9E, 0x009C9B9D, 0x009D9C9E, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009E9D9F, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 
        0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A1A0A2, 
        0x00A1A0A2, 0x009FA0A4, 0x009FA0A4, 0x009E9FA3, 0x009D9EA2, 0x00B2B3B7, 0x00B8B9BD, 0x00BDBEC2, 0x00BFC0C4, 0x00C7C6CA, 0x00C6C5C9, 0x04C9C8CA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x00353535, 0x002E2E2E, 0x002A292B, 0x00282729, 0x00201F21, 0x003A393B, 0x009F9EA0, 0x00A3A2A4, 0x009D9C9E, 0x00A2A1A3, 0x00A1A0A2, 0x00A1A0A2, 0x00A09FA1, 
        0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 
        0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009C9B9D, 0x009E9D9F, 0x009D9C9E, 0x009B9A9C, 
        0x009A999B, 0x009A999B, 0x009A999B, 0x00979698, 0x00949395, 0x00919191, 0x00898989, 0x007C7C7C, 0x00A3A3A3, 0x00686868, 0x00707070, 0x007E7D7F, 0x008D8C8E, 0x00908F91, 0x00949395, 0x00979698, 0x00969597, 0x00969597, 0x00989799, 0x009A999B, 
        0x009B9A9C, 0x009B9A9C, 0x009C9B9D, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 
        0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 0x00A09FA1, 
        0x00A09FA1, 0x009E9FA3, 0x009FA0A4, 0x009E9FA3, 0x009C9DA1, 0x00B0B1B5, 0x00B5B6BA, 0x00BABBBF, 0x00BDBEC2, 0x00C4C3C7, 0x00C4C3C7, 0x00C8C7C9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x04393939, 0x00323232, 0x002E2D2F, 0x002C2B2D, 0x00252426, 0x0039383A, 0x009F9EA0, 0x00A09FA1, 0x009C9B9D, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 
        0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 
        0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009A999B, 0x009A999B, 0x00989799, 0x00979698, 0x00969597, 0x00969597, 0x00969597, 0x00959496, 0x00949395, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 
        0x008E8D8F, 0x008B8A8C, 0x00868587, 0x007F7E80, 0x007A797B, 0x00727272, 0x00656565, 0x00868686, 0x00DDDDDD, 0x00959595, 0x003D3D3D, 0x0049484A, 0x00616062, 0x006F6E70, 0x00777678, 0x00807F81, 0x00838284, 0x00868587, 0x008B8A8C, 0x008D8C8E, 
        0x008D8C8E, 0x008F8E90, 0x00908F91, 0x00919092, 0x00929193, 0x00939294, 0x00939294, 0x00949395, 0x00959496, 0x00979698, 0x00979698, 0x00979698, 0x00989799, 0x00989799, 0x0099989A, 0x0099989A, 0x009A999B, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 
        0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 
        0x009E9D9F, 0x009B9CA0, 0x009C9DA1, 0x009B9CA0, 0x009A9B9F, 0x00ADAEB2, 0x00B1B2B6, 0x00B6B7BB, 0x00B8B9BD, 0x00C0BFC3, 0x00C0BFC3, 0x04C6C5C7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0C3F3F3F, 0x00373737, 0x00323133, 0x00313032, 0x002B2A2C, 0x00363537, 0x009E9D9F, 0x009C9B9D, 0x009B9A9C, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 
        0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009B9A9C, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00989799, 
        0x00979698, 0x00979698, 0x00979698, 0x00969597, 0x00969597, 0x00959496, 0x00949395, 0x00949395, 0x00939294, 0x00959496, 0x00949395, 0x00929193, 0x00919092, 0x00908F91, 0x008E8D8F, 0x008D8C8E, 0x008B8A8C, 0x0089888A, 0x00878688, 0x00858486, 
        0x00818082, 0x007B7A7C, 0x00747375, 0x006C6B6D, 0x00676668, 0x00606060, 0x00848484, 0x00C7C7C7, 0x00E6E6E6, 0x00AAAAAA, 0x006B6B6B, 0x003A393B, 0x003B3A3C, 0x004E4D4F, 0x005A595B, 0x00676668, 0x006F6E70, 0x00767577, 0x007D7C7E, 0x00818082, 
        0x00818082, 0x00848385, 0x00868587, 0x00888789, 0x008A898B, 0x008B8A8C, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008E8D8F, 0x008F8E90, 0x008F8E90, 0x00908F91, 0x00919092, 0x00929193, 0x00939294, 0x00949395, 0x00949395, 0x00959496, 0x00959496, 
        0x00959496, 0x00969597, 0x00969597, 0x00969597, 0x00969597, 0x00979698, 0x00979698, 0x00989799, 0x00989799, 0x00989799, 0x00989799, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 
        0x009A999B, 0x0098999D, 0x00999A9E, 0x0098999D, 0x0097989C, 0x00AAABAF, 0x00AEAFB3, 0x00B1B2B6, 0x00B3B4B8, 0x00BBBABE, 0x00BDBCC0, 0x0CC5C4C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x18434343, 0x003B3B3B, 0x00363537, 0x00343335, 0x00302F31, 0x00353436, 0x009D9C9E, 0x0099989A, 0x009B9A9C, 0x0099989A, 0x009A999B, 0x009A999B, 0x0099989A, 
        0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00969597, 0x00969597, 0x00959496, 0x00959496, 0x00949395, 
        0x00949395, 0x00949395, 0x00939294, 0x00939294, 0x00929193, 0x00919092, 0x00908F91, 0x008F8E90, 0x008E8D8F, 0x008E8D8F, 0x008C8B8D, 0x008B8A8C, 0x0089888A, 0x00878688, 0x00858486, 0x00838284, 0x00818082, 0x00807F81, 0x007C7B7D, 0x00787779, 
        0x00737274, 0x006D6C6E, 0x00676668, 0x00616062, 0x005E5D5F, 0x007E7E7E, 0x00AFAFAF, 0x00E1E1E1, 0x00F0F0F0, 0x00B8B8B8, 0x007E7E7E, 0x00585759, 0x003A393B, 0x00353436, 0x00424143, 0x00504F51, 0x005A595B, 0x00626163, 0x006C6B6D, 0x00717072, 
        0x00727173, 0x00787779, 0x007A797B, 0x007D7C7E, 0x007F7E80, 0x00818082, 0x00838284, 0x00858486, 0x00878688, 0x00888789, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008F8E90, 0x00908F91, 0x00908F91, 0x00908F91, 
        0x00919092, 0x00919092, 0x00929193, 0x00929193, 0x00929193, 0x00949395, 0x00949395, 0x00959496, 0x00959496, 0x00959496, 0x00969597, 0x00969597, 0x00969597, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 0x00979698, 
        0x00989799, 0x0096979B, 0x0097989C, 0x0095969A, 0x00949599, 0x00A8A9AD, 0x00ACADB1, 0x00AEAFB3, 0x00AFB0B4, 0x00B9B8BC, 0x00BBBABE, 0x18C4C3C5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x27454545, 0x003E3E3E, 0x003A393B, 0x00373638, 0x00323133, 0x00343335, 0x00949395, 0x009C9B9D, 0x00989799, 0x00989799, 0x00989799, 0x00989799, 0x00989799, 
        0x00979698, 0x00979698, 0x00979698, 0x00969597, 0x00969597, 0x00969597, 0x00969597, 0x00959496, 0x00959496, 0x00949395, 0x00949395, 0x00939294, 0x00939294, 0x00949395, 0x00939294, 0x00939294, 0x00929193, 0x00929193, 0x00929193, 0x00908F91, 
        0x008F8E90, 0x00908F91, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008A898B, 0x0089888A, 0x00878787, 0x00888888, 0x00888888, 0x00848484, 0x00818181, 0x007F7F7F, 0x007C7C7C, 0x00797979, 0x00767676, 0x00737373, 0x006C6C6C, 
        0x00636363, 0x005C5C5C, 0x005B5B5B, 0x006B6B6B, 0x00818181, 0x00A2A2A2, 0x00CCCCCC, 0x00F7F7F7, 0x00E6E6E6, 0x00BABABA, 0x00949494, 0x006B6A6C, 0x00545355, 0x00373638, 0x00333234, 0x003B3A3C, 0x0049484A, 0x00515052, 0x00575658, 0x005F5E60, 
        0x00656466, 0x006C6B6D, 0x006E6D6F, 0x00727173, 0x00767577, 0x007A797B, 0x007C7B7D, 0x007D7C7E, 0x007D7C7E, 0x00807F81, 0x00828183, 0x00838284, 0x00858486, 0x00868587, 0x00878688, 0x00888789, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008C8B8D, 
        0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008E8D8F, 0x008F8E90, 0x00908F91, 0x00908F91, 0x00919092, 0x00919092, 0x00929193, 0x00939294, 0x00939294, 0x00939294, 0x00939294, 0x00949395, 0x00949395, 0x00959496, 0x00959496, 
        0x00959496, 0x00939498, 0x00939498, 0x00929397, 0x0097989C, 0x00A2A3A7, 0x00A7A8AC, 0x00A9AAAE, 0x00AEAFB3, 0x00B3B2B6, 0x00B5B4B8, 0x27C4C3C5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x39494949, 0x00424242, 0x003F3E40, 0x003B3A3C, 0x00343335, 0x00353436, 0x008E8D8F, 0x0099989A, 0x00969597, 0x00969597, 0x00969597, 0x00969597, 0x00969597, 
        0x00969597, 0x00959496, 0x00959496, 0x00959496, 0x00949395, 0x00939294, 0x00939294, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 0x00919092, 0x00919092, 0x00919092, 0x00919092, 0x00908F91, 0x00908F91, 0x008F8E90, 0x008F8E90, 0x008D8C8E, 
        0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x00888789, 0x00878688, 0x00868587, 0x00848385, 0x00838284, 0x00818181, 0x00828282, 0x00808080, 0x007D7D7D, 0x007A7A7A, 0x00787878, 0x00757575, 0x00717171, 0x006D6D6D, 0x00686868, 0x00616161, 
        0x005D5D5D, 0x005F5F5F, 0x00686868, 0x007E7E7E, 0x00979797, 0x00B9B9B9, 0x00DDDDDD, 0x00FBFBFB, 0x00E5E5E5, 0x00BFBFBF, 0x009F9F9F, 0x007A797B, 0x00656466, 0x004B4A4C, 0x003B3A3C, 0x00333234, 0x0039383A, 0x00414042, 0x004B4A4C, 0x00545355, 
        0x0059585A, 0x00605F61, 0x00636264, 0x00676668, 0x006B6A6C, 0x006F6E70, 0x00737274, 0x00767577, 0x00787779, 0x0079787A, 0x007B7A7C, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x00818082, 0x00828183, 0x00838284, 0x00848385, 0x00858486, 0x00878688, 
        0x00888789, 0x00888789, 0x00888789, 0x0089888A, 0x008A898B, 0x008C8B8D, 0x008C8B8D, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x008F8E90, 0x00908F91, 0x00908F91, 0x00908F91, 0x00919092, 0x00919092, 0x00929193, 0x00929193, 
        0x00929193, 0x00919296, 0x00919296, 0x00909195, 0x0095969A, 0x009FA0A4, 0x00A4A5A9, 0x00A6A7AB, 0x00ABACB0, 0x00B1B0B4, 0x00B4B3B7, 0x39C5C4C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4F525252, 0x00474747, 0x00454446, 0x00403F41, 0x0039383A, 0x00383739, 0x00838284, 0x00969597, 0x00939294, 0x00949395, 0x00949395, 0x00949395, 0x00939294, 
        0x00939294, 0x00939294, 0x00929193, 0x00929193, 0x00929193, 0x00908F91, 0x00908F91, 0x00908F91, 0x008F8E90, 0x008E8D8F, 0x008E8D8F, 0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 
        0x00888789, 0x00878688, 0x00868587, 0x00848385, 0x00838284, 0x00828183, 0x00818082, 0x007F7E80, 0x007E7D7F, 0x007A7A7A, 0x007A7A7A, 0x00787878, 0x00757575, 0x00727272, 0x00707070, 0x006C6C6C, 0x00686868, 0x00606060, 0x005D5D5D, 0x005A5A5A, 
        0x005E5E5E, 0x006B6B6B, 0x007D7D7D, 0x00979797, 0x00B1B1B1, 0x00CECECE, 0x00EDEDED, 0x00FBFBFB, 0x00E0E0E0, 0x00C2C2C2, 0x00A9A9A9, 0x00878688, 0x00747375, 0x005F5E60, 0x0049484A, 0x00363537, 0x00302F31, 0x00323133, 0x003B3A3C, 0x00464547, 
        0x004B4A4C, 0x00545355, 0x00585759, 0x005D5C5E, 0x00626163, 0x00656466, 0x0069686A, 0x006E6D6F, 0x00717072, 0x00727173, 0x00747375, 0x00767577, 0x00787779, 0x0079787A, 0x007B7A7C, 0x007C7B7D, 0x007E7D7F, 0x007F7E80, 0x00818082, 0x00828183, 
        0x00838284, 0x00848385, 0x00848385, 0x00858486, 0x00868587, 0x00888789, 0x00888789, 0x0089888A, 0x0089888A, 0x0089888A, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008B8A8C, 0x008C8B8D, 0x008C8B8D, 0x008C8B8D, 0x008D8C8E, 0x008E8D8F, 0x008E8D8F, 
        0x008E8D8F, 0x008D8E92, 0x008D8E92, 0x008D8E92, 0x00929397, 0x009C9DA1, 0x00A0A1A5, 0x00A2A3A7, 0x00A7A8AC, 0x00ADACB0, 0x00B2B1B5, 0x4FC5C4C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x675D5D5D, 0x004C4C4C, 0x0049484A, 0x00444345, 0x003E3D3F, 0x003D3C3E, 0x00777678, 0x00939294, 0x00919092, 0x00919092, 0x00929193, 0x00919092, 0x00919092, 
        0x00908F91, 0x00908F91, 0x008F8E90, 0x008F8E90, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008C8B8D, 0x008B8A8C, 0x008B8A8C, 0x008A898B, 0x008A898B, 0x0089888A, 0x00888789, 0x00888789, 0x00878688, 0x00868587, 0x00858486, 
        0x00848385, 0x00838284, 0x00828183, 0x00807F81, 0x007F7E80, 0x007E7D7F, 0x007C7B7D, 0x007A797B, 0x0079787A, 0x00767676, 0x00747474, 0x00717171, 0x006F6F6F, 0x006C6C6C, 0x00696969, 0x00646464, 0x00606060, 0x00595959, 0x005C5C5C, 0x00616161, 
        0x006D6D6D, 0x007F7F7F, 0x00929292, 0x00AAAAAA, 0x00C1C1C1, 0x00DADADA, 0x00F7F7F7, 0x00F8F8F8, 0x00DCDCDC, 0x00C5C5C5, 0x00AEAEAE, 0x008F8E90, 0x007C7B7D, 0x0069686A, 0x00575658, 0x00454446, 0x0039383A, 0x002F2E30, 0x00302F31, 0x0039383A, 
        0x00403F41, 0x004A494B, 0x004F4E50, 0x00555456, 0x005A595B, 0x005D5C5E, 0x00605F61, 0x00656466, 0x00686769, 0x006B6A6C, 0x006D6C6E, 0x00706F71, 0x00727173, 0x00747375, 0x00757476, 0x00777678, 0x0079787A, 0x007A797B, 0x007C7B7D, 0x007D7C7E, 
        0x007F7E80, 0x007F7E80, 0x00807F81, 0x00818082, 0x00828183, 0x00838284, 0x00848385, 0x00858486, 0x00858486, 0x00858486, 0x00868587, 0x00878688, 0x00878688, 0x00888789, 0x00888789, 0x0089888A, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008B8A8C, 
        0x008B8A8C, 0x008A8B8F, 0x008B8C90, 0x008B8C90, 0x008F9094, 0x0098999D, 0x009C9DA1, 0x009FA0A4, 0x00A4A5A9, 0x00A8A7AB, 0x00B1B0B4, 0x67C7C6C8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x836C6C6C, 0x00505050, 0x004C4B4D, 0x00474648, 0x00444345, 0x00424143, 0x006B6A6C, 0x00919092, 0x008F8E90, 0x008F8E90, 0x008F8E90, 0x008F8E90, 0x008F8E90, 
        0x008E8D8F, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 0x008C8B8D, 0x008B8A8C, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x0089888A, 0x00888789, 0x00888789, 0x00878688, 0x00868587, 0x00858486, 0x00858486, 0x00848385, 0x00838284, 0x00818082, 
        0x00807F81, 0x007E7D7F, 0x007D7C7E, 0x007B7A7C, 0x007A797B, 0x00787779, 0x00767577, 0x00747375, 0x00727173, 0x00717171, 0x006F6F6F, 0x006B6B6B, 0x00686868, 0x00656565, 0x00616161, 0x005C5C5C, 0x005A5A5A, 0x005B5B5B, 0x00656565, 0x00717171, 
        0x00808080, 0x00919191, 0x00A2A2A2, 0x00B7B7B7, 0x00CCCCCC, 0x00E6E6E6, 0x00FDFDFD, 0x00F7F7F7, 0x00DBDBDB, 0x00C7C7C7, 0x00B2B2B2, 0x00989799, 0x00868587, 0x00706F71, 0x00636264, 0x00555456, 0x00464547, 0x00373638, 0x002F2E30, 0x00323133, 
        0x00343335, 0x003E3D3F, 0x00434244, 0x004B4A4C, 0x00504F51, 0x00535254, 0x00575658, 0x005B5A5C, 0x005E5D5F, 0x00636264, 0x00656466, 0x00686769, 0x006A696B, 0x006D6C6E, 0x006F6E70, 0x00717072, 0x00727173, 0x00747375, 0x00757476, 0x00777678, 
        0x0079787A, 0x007A797B, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x00807F81, 0x00818082, 0x00828183, 0x00838284, 0x00848385, 0x00858486, 0x00868587, 0x00868587, 0x00868587, 0x00878688, 0x00888789, 0x0089888A, 0x0089888A, 
        0x0089888A, 0x0087888C, 0x0088898D, 0x00898A8E, 0x008D8E92, 0x0096979B, 0x00999A9E, 0x009B9CA0, 0x00A0A1A5, 0x00A4A3A7, 0x00B1B0B4, 0x83C9C8CA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA1818181, 0x00555555, 0x00504F51, 0x004B4A4C, 0x0049484A, 0x00474648, 0x005F5E60, 0x008F8E90, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008D8C8E, 0x008C8B8D, 
        0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x008A898B, 0x008A898B, 0x0089888A, 0x0089888A, 0x00888789, 0x00878688, 0x00878688, 0x00868587, 0x00858486, 0x00858486, 0x00848385, 0x00838284, 0x00828183, 0x00818082, 0x00807F81, 0x007F7E80, 0x007D7C7E, 
        0x007C7B7D, 0x007B7A7C, 0x007A797B, 0x00787779, 0x00767577, 0x00747375, 0x00727173, 0x006F6E70, 0x006E6D6F, 0x006C6C6C, 0x00686868, 0x00646464, 0x00606060, 0x005D5D5D, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x00666666, 0x00737373, 0x00818181, 
        0x008F8F8F, 0x009F9F9F, 0x00AFAFAF, 0x00C4C4C4, 0x00D8D8D8, 0x00F2F2F2, 0x00FFFFFF, 0x00F3F3F3, 0x00DADADA, 0x00C7C7C7, 0x00B4B4B4, 0x00A1A0A2, 0x00908F91, 0x007C7B7D, 0x006D6C6E, 0x005D5C5E, 0x00504F51, 0x00424143, 0x00383739, 0x00333234, 
        0x002D2C2E, 0x00343335, 0x0039383A, 0x00403F41, 0x00464547, 0x004B4A4C, 0x004F4E50, 0x00535254, 0x00575658, 0x005D5C5E, 0x005E5D5F, 0x00616062, 0x00646365, 0x00676668, 0x0069686A, 0x006C6B6D, 0x006D6C6E, 0x006F6E70, 0x00717072, 0x00737274, 
        0x00747375, 0x00767577, 0x00777678, 0x0079787A, 0x007A797B, 0x0079787A, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x00818082, 0x00828183, 0x00838284, 0x00838284, 0x00838284, 0x00848385, 0x00858486, 0x00868587, 0x00868587, 
        0x00868587, 0x00848589, 0x0086878B, 0x0086878B, 0x008B8C90, 0x00929397, 0x0095969A, 0x0098999D, 0x009D9EA2, 0x00A1A0A4, 0x00B2B1B5, 0xA1CCCBCD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xC2979797, 0x005B5B5B, 0x00565557, 0x00504F51, 0x004E4D4F, 0x004A494B, 0x00545355, 0x008B8A8C, 0x008A898B, 0x008A898B, 0x008A898B, 0x008A898B, 0x008A898B, 
        0x0089888A, 0x00888789, 0x00888789, 0x00878688, 0x00878688, 0x00868587, 0x00868587, 0x00858486, 0x00848385, 0x00838284, 0x00838284, 0x00828183, 0x00828183, 0x00807F81, 0x007F7E80, 0x007E7D7F, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 0x0079787A, 
        0x00787779, 0x00787779, 0x00767577, 0x00747375, 0x00727173, 0x00706F71, 0x006E6D6F, 0x006B6A6C, 0x0069686A, 0x00666666, 0x00626262, 0x005E5E5E, 0x005B5B5B, 0x00595959, 0x005B5B5B, 0x00616161, 0x00686868, 0x00747474, 0x00818181, 0x008F8F8F, 
        0x009C9C9C, 0x00ACACAC, 0x00BDBDBD, 0x00D1D1D1, 0x00E5E5E5, 0x00FAFAFA, 0x00FEFEFE, 0x00EDEDED, 0x00DADADA, 0x00C8C8C8, 0x00B6B6B6, 0x00A8A7A9, 0x00949395, 0x00858486, 0x00757476, 0x00656466, 0x0059585A, 0x004D4C4E, 0x00444345, 0x003A393B, 
        0x00313032, 0x00302F31, 0x00333234, 0x00373638, 0x003D3C3E, 0x00424143, 0x00484749, 0x004C4B4D, 0x004F4E50, 0x00565557, 0x00585759, 0x005B5A5C, 0x005E5D5F, 0x00616062, 0x00636264, 0x00666567, 0x00686769, 0x006A696B, 0x006C6B6D, 0x006E6D6F, 
        0x00706F71, 0x00727173, 0x00737274, 0x00757476, 0x00767577, 0x00757476, 0x00777678, 0x00787779, 0x0079787A, 0x007A797B, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x007F7E80, 0x00807F81, 0x00818082, 0x00828183, 0x00828183, 
        0x00838284, 0x00808185, 0x00838488, 0x00838488, 0x0088898D, 0x008F9094, 0x00919296, 0x00949599, 0x00999A9E, 0x009F9EA2, 0x00B3B2B6, 0xC2CFCED0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE6A5A5A5, 0x0E5F5F5F, 0x005A595B, 0x00545355, 0x00515052, 0x004B4A4C, 0x004E4D4F, 0x0089888A, 0x00888789, 0x0089888A, 0x0089888A, 0x0089888A, 0x00888789, 
        0x00878688, 0x00878688, 0x00868587, 0x00858486, 0x00858486, 0x00848385, 0x00838284, 0x00838284, 0x00828183, 0x00818082, 0x00807F81, 0x007F7E80, 0x007F7E80, 0x007D7C7E, 0x007C7B7D, 0x007B7A7C, 0x007A797B, 0x0079787A, 0x00787779, 0x00767577, 
        0x00757476, 0x00737274, 0x00727173, 0x00706F71, 0x006D6C6E, 0x006B6A6C, 0x0069686A, 0x00666567, 0x00646365, 0x00626262, 0x005E5E5E, 0x005A5A5A, 0x00595959, 0x005A5A5A, 0x00606060, 0x006C6C6C, 0x00777777, 0x007E7E7E, 0x008A8A8A, 0x00989898, 
        0x00A6A6A6, 0x00B6B6B6, 0x00C7C7C7, 0x00DADADA, 0x00ECECEC, 0x00FFFFFF, 0x00FCFCFC, 0x00EBEBEB, 0x00DDDDDD, 0x00CBCBCB, 0x00B9B9B9, 0x00ACABAD, 0x00969597, 0x00888789, 0x007B7A7C, 0x006E6D6F, 0x00636264, 0x00555456, 0x004B4A4C, 0x00434244, 
        0x003A393B, 0x002E2D2F, 0x002F2E30, 0x00313032, 0x00353436, 0x003B3A3C, 0x00414042, 0x00464547, 0x0049484A, 0x004F4E50, 0x00515052, 0x00545355, 0x00575658, 0x005A595B, 0x005D5C5E, 0x00605F61, 0x00616062, 0x00656466, 0x00666567, 0x0069686A, 
        0x006B6A6C, 0x006C6B6D, 0x006E6D6F, 0x00706F71, 0x00717072, 0x00737274, 0x00747375, 0x00757476, 0x00767577, 0x00777678, 0x00777678, 0x0079787A, 0x007A797B, 0x007B7A7C, 0x007B7A7C, 0x007C7B7D, 0x007D7C7E, 0x007E7D7F, 0x007F7E80, 0x007F7E80, 
        0x007F7E80, 0x007E7F83, 0x00808185, 0x00818286, 0x0085868A, 0x008C8D91, 0x008F9094, 0x00919296, 0x0096979B, 0x009F9EA2, 0x0EB3B2B4, 0xE6D1D0D2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBEBEBE, 0x38616161, 0x005B5A5C, 0x00616062, 0x00525153, 0x00545355, 0x004B4A4C, 0x007B7A7C, 0x00868587, 0x00878688, 0x00868686, 0x00858585, 0x00858585, 
        0x00848484, 0x00848484, 0x00838383, 0x00838383, 0x00828282, 0x00828282, 0x00818181, 0x00808080, 0x007F7F7F, 0x007E7E7E, 0x007D7D7D, 0x007C7C7C, 0x007B7B7B, 0x00797979, 0x00787878, 0x00777777, 0x00767676, 0x00757575, 0x00747474, 0x00727272, 
        0x00717171, 0x00707070, 0x006D6D6D, 0x006B6B6B, 0x006A6A6A, 0x00676767, 0x00636363, 0x00606060, 0x005F5F5F, 0x00595959, 0x00595959, 0x00585858, 0x005B5B5B, 0x00656565, 0x006E6E6E, 0x00767676, 0x00808080, 0x008B8B8B, 0x00949494, 0x00A3A3A3, 
        0x00B1B1B1, 0x00C0C0C0, 0x00D0D0D0, 0x00E3E3E3, 0x00F0F0F0, 0x00FFFFFF, 0x00F5F5F5, 0x00E8E8E8, 0x00DBDBDB, 0x00CACACA, 0x00BBBBBB, 0x00ACACAC, 0x009E9E9E, 0x008F8E90, 0x00828183, 0x00757476, 0x006B6A6C, 0x005E5D5F, 0x00545355, 0x004B4A4C, 
        0x00434244, 0x003B3A3C, 0x00343335, 0x002E2D2F, 0x002E2D2F, 0x00333234, 0x0039383A, 0x003F3E40, 0x00434244, 0x00474648, 0x004A494B, 0x004E4D4F, 0x00525153, 0x00555456, 0x00575658, 0x0059585A, 0x005A595B, 0x005F5E60, 0x00616062, 0x00646365, 
        0x00666567, 0x00676668, 0x0069686A, 0x006C6B6D, 0x006D6C6E, 0x006E6D6F, 0x006F6E70, 0x00717072, 0x00727173, 0x00727173, 0x00737274, 0x00757476, 0x00767577, 0x00777678, 0x00787779, 0x0079787A, 0x007A797B, 0x007A797B, 0x007B7A7C, 0x007C7B7D, 
        0x007D7C7E, 0x007C7B7D, 0x00818082, 0x007F7E80, 0x00828183, 0x00888789, 0x008C8B8D, 0x00908F91, 0x00908F91, 0x00989799, 0x38C2C2C2, 0xFFD5D5D5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC4C4C4, 0x64717171, 0x00605F61, 0x00605F61, 0x00555456, 0x00545355, 0x00515052, 0x006E6D6F, 0x00838284, 0x00858486, 0x00848484, 0x00848484, 0x00838383, 
        0x00838383, 0x00828282, 0x00818181, 0x00818181, 0x00818181, 0x00808080, 0x007F7F7F, 0x007D7D7D, 0x007C7C7C, 0x007C7C7C, 0x007A7A7A, 0x00797979, 0x00787878, 0x00777777, 0x00767676, 0x00757575, 0x00737373, 0x00727272, 0x00717171, 0x006F6F6F, 
        0x006D6D6D, 0x006C6C6C, 0x00696969, 0x00686868, 0x00666666, 0x00636363, 0x005E5E5E, 0x005B5B5B, 0x005A5A5A, 0x00585858, 0x005B5B5B, 0x005D5D5D, 0x00636363, 0x006E6E6E, 0x00767676, 0x007F7F7F, 0x00898989, 0x00959595, 0x009E9E9E, 0x00ADADAD, 
        0x00BBBBBB, 0x00C8C8C8, 0x00D8D8D8, 0x00EAEAEA, 0x00F7F7F7, 0x00FFFFFF, 0x00F4F4F4, 0x00E7E7E7, 0x00DADADA, 0x00CBCBCB, 0x00BCBCBC, 0x00AEAEAE, 0x00A1A1A1, 0x00949395, 0x00878688, 0x007B7A7C, 0x00717072, 0x00646365, 0x005A595B, 0x00515052, 
        0x0049484A, 0x003F3E40, 0x0039383A, 0x00323133, 0x002F2E30, 0x00302F31, 0x00333234, 0x00383739, 0x003D3C3E, 0x00414042, 0x00444345, 0x00484749, 0x004C4B4D, 0x004F4E50, 0x00525153, 0x00555456, 0x00575658, 0x0059585A, 0x005C5B5D, 0x005F5E60, 
        0x00616062, 0x00626163, 0x00646365, 0x00666567, 0x00686769, 0x006B6A6C, 0x006C6B6D, 0x006D6C6E, 0x006F6E70, 0x00706F71, 0x00717072, 0x00727173, 0x00737274, 0x00757476, 0x00767577, 0x00777678, 0x00777678, 0x00787779, 0x00787779, 0x0079787A, 
        0x007A797B, 0x007D7C7E, 0x007D7C7E, 0x007D7C7E, 0x00818082, 0x00858486, 0x00888789, 0x008D8C8E, 0x00908F91, 0x009B9B9B, 0x64C5C5C5, 0xFFD8D8D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0x92898989, 0x00676668, 0x00616062, 0x005B5A5C, 0x00565557, 0x00585759, 0x00605F61, 0x007F7E80, 0x00838284, 0x00828282, 0x00818181, 0x00818181, 
        0x00808080, 0x007F7F7F, 0x007F7F7F, 0x007E7E7E, 0x007E7E7E, 0x007D7D7D, 0x007C7C7C, 0x007A7A7A, 0x00797979, 0x00787878, 0x00777777, 0x00767676, 0x00757575, 0x00747474, 0x00737373, 0x00717171, 0x00707070, 0x006E6E6E, 0x006C6C6C, 0x006A6A6A, 
        0x00686868, 0x00676767, 0x00656565, 0x00626262, 0x00616161, 0x005E5E5E, 0x005A5A5A, 0x00575757, 0x00575757, 0x005B5B5B, 0x00616161, 0x00676767, 0x006E6E6E, 0x00797979, 0x00808080, 0x00898989, 0x00949494, 0x009E9E9E, 0x00A9A9A9, 0x00B7B7B7, 
        0x00C3C3C3, 0x00CFCFCF, 0x00DFDFDF, 0x00F0F0F0, 0x00FDFDFD, 0x00FEFEFE, 0x00F2F2F2, 0x00E6E6E6, 0x00DADADA, 0x00CBCBCB, 0x00BEBEBE, 0x00B1B1B1, 0x00A5A5A5, 0x00989799, 0x008B8A8C, 0x00807F81, 0x00767577, 0x006A696B, 0x00605F61, 0x00575658, 
        0x004F4E50, 0x00464547, 0x00414042, 0x003A393B, 0x00343335, 0x002E2D2F, 0x002D2C2E, 0x00313032, 0x00363537, 0x003B3A3C, 0x003E3D3F, 0x00424143, 0x00464547, 0x00484749, 0x004B4A4C, 0x004F4E50, 0x00525153, 0x00555456, 0x00575658, 0x005A595B, 
        0x005D5C5E, 0x005E5D5F, 0x00605F61, 0x00626163, 0x00646365, 0x00666567, 0x00676668, 0x0069686A, 0x006A696B, 0x006B6A6C, 0x006D6C6E, 0x006F6E70, 0x00706F71, 0x00717072, 0x00727173, 0x00737274, 0x00747375, 0x00747375, 0x00757476, 0x00767577, 
        0x00777678, 0x007B7A7C, 0x00767577, 0x0079787A, 0x007F7E80, 0x00818082, 0x00838284, 0x008A898B, 0x008E8D8F, 0x00A2A2A2, 0x92C9C9C9, 0xFFDCDCDC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFCFCF, 0xC2A2A2A2, 0x0069686A, 0x00656466, 0x00626163, 0x005D5C5E, 0x005C5B5D, 0x0059585A, 0x007B7A7C, 0x00828183, 0x007F7F7F, 0x007F7F7F, 0x007E7E7E, 
        0x007D7D7D, 0x007D7D7D, 0x007C7C7C, 0x007B7B7B, 0x007B7B7B, 0x007A7A7A, 0x00797979, 0x00777777, 0x00767676, 0x00757575, 0x00747474, 0x00737373, 0x00727272, 0x00717171, 0x006F6F6F, 0x006E6E6E, 0x006C6C6C, 0x006B6B6B, 0x00696969, 0x00666666, 
        0x00656565, 0x00646464, 0x00606060, 0x005D5D5D, 0x005B5B5B, 0x00595959, 0x00585858, 0x00595959, 0x005B5B5B, 0x00626262, 0x006A6A6A, 0x00717171, 0x00787878, 0x00818181, 0x00888888, 0x00919191, 0x009C9C9C, 0x00A5A5A5, 0x00B0B0B0, 0x00BEBEBE, 
        0x00CACACA, 0x00D5D5D5, 0x00E4E4E4, 0x00F5F5F5, 0x00FFFFFF, 0x00FDFDFD, 0x00F1F1F1, 0x00E5E5E5, 0x00D9D9D9, 0x00CCCCCC, 0x00C0C0C0, 0x00B4B4B4, 0x00A9A9A9, 0x009C9B9D, 0x008F8E90, 0x00848385, 0x007B7A7C, 0x006F6E70, 0x00666567, 0x005E5D5F, 
        0x00565557, 0x004E4D4F, 0x0049484A, 0x00424143, 0x003A393B, 0x00333234, 0x002E2D2F, 0x002E2D2F, 0x00313032, 0x00353436, 0x0039383A, 0x003E3D3F, 0x00424143, 0x00434244, 0x00464547, 0x004A494B, 0x004D4C4E, 0x00515052, 0x00535254, 0x00565557, 
        0x0059585A, 0x005A595B, 0x005C5B5D, 0x005F5E60, 0x00605F61, 0x00616062, 0x00626163, 0x00646365, 0x00666567, 0x00686769, 0x0069686A, 0x006B6A6C, 0x006D6C6E, 0x006D6C6E, 0x006E6D6F, 0x006F6E70, 0x00706F71, 0x00717072, 0x00727173, 0x00737274, 
        0x00747375, 0x00777678, 0x00717072, 0x00777678, 0x007B7A7C, 0x007C7B7D, 0x00828183, 0x00868587, 0x0089888A, 0x00ADADAD, 0xC2CDCDCD, 0xFFDEDEDE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD5D5D5, 0xF5B8B8B8, 0x2B6E6D6F, 0x006A696B, 0x00666567, 0x00636264, 0x005B5A5C, 0x005A595B, 0x00767577, 0x007F7E80, 0x007D7D7D, 0x007C7C7C, 0x007C7C7C, 
        0x007B7B7B, 0x007A7A7A, 0x00797979, 0x00797979, 0x00787878, 0x00787878, 0x00777777, 0x00757575, 0x00747474, 0x00737373, 0x00727272, 0x00707070, 0x006F6F6F, 0x006D6D6D, 0x006C6C6C, 0x006A6A6A, 0x00696969, 0x00686868, 0x00666666, 0x00646464, 
        0x00626262, 0x00606060, 0x005D5D5D, 0x00595959, 0x00575757, 0x00575757, 0x00595959, 0x005E5E5E, 0x00646464, 0x006B6B6B, 0x00727272, 0x00787878, 0x007F7F7F, 0x00888888, 0x008E8E8E, 0x00979797, 0x00A3A3A3, 0x00ADADAD, 0x00B9B9B9, 0x00C7C7C7, 
        0x00D1D1D1, 0x00DDDDDD, 0x00EBEBEB, 0x00FAFAFA, 0x00FFFFFF, 0x00FBFBFB, 0x00F0F0F0, 0x00E4E4E4, 0x00D9D9D9, 0x00CCCCCC, 0x00C1C1C1, 0x00B6B6B6, 0x00ABABAB, 0x00A09FA1, 0x00939294, 0x0089888A, 0x00818082, 0x00767577, 0x006D6C6E, 0x00656466, 
        0x005D5C5E, 0x00555456, 0x004F4E50, 0x00474648, 0x00414042, 0x003A393B, 0x00343335, 0x00302F31, 0x002E2D2F, 0x002F2E30, 0x00333234, 0x00383739, 0x003D3C3E, 0x003F3E40, 0x00424143, 0x00464547, 0x00484749, 0x004B4A4C, 0x004E4D4F, 0x00515052, 
        0x00535254, 0x00555456, 0x00575658, 0x0059585A, 0x005B5A5C, 0x005D5C5E, 0x005E5D5F, 0x00605F61, 0x00626163, 0x00646365, 0x00666567, 0x00686769, 0x0069686A, 0x006A696B, 0x006B6A6C, 0x006C6B6D, 0x006D6C6E, 0x006E6D6F, 0x006F6E70, 0x00706F71, 
        0x00717072, 0x00737274, 0x006F6E70, 0x00767577, 0x00767577, 0x0079787A, 0x00818082, 0x00807F81, 0x00858486, 0x2BBBBBBB, 0xF5D2D2D2, 0xFFDEDEDE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD6D6D6, 0xFFC6C6C6, 0x637D7C7E, 0x006F6E70, 0x006A696B, 0x00686769, 0x005D5C5E, 0x005F5E60, 0x006D6C6E, 0x007A797B, 0x007A7A7A, 0x007A7A7A, 0x00797979, 
        0x00797979, 0x00787878, 0x00777777, 0x00767676, 0x00767676, 0x00757575, 0x00747474, 0x00737373, 0x00717171, 0x00707070, 0x006F6F6F, 0x006E6E6E, 0x006C6C6C, 0x006A6A6A, 0x00686868, 0x00676767, 0x00656565, 0x00646464, 0x00626262, 0x00606060, 
        0x005F5F5F, 0x005B5B5B, 0x00595959, 0x00575757, 0x00585858, 0x005A5A5A, 0x005E5E5E, 0x00666666, 0x006D6D6D, 0x00737373, 0x00797979, 0x007F7F7F, 0x00868686, 0x008F8F8F, 0x00969696, 0x00A0A0A0, 0x00ACACAC, 0x00B5B5B5, 0x00C0C0C0, 0x00CDCDCD, 
        0x00D7D7D7, 0x00E3E3E3, 0x00F1F1F1, 0x00FCFCFC, 0x00FFFFFF, 0x00F9F9F9, 0x00EEEEEE, 0x00E3E3E3, 0x00D8D8D8, 0x00CCCCCC, 0x00C2C2C2, 0x00B8B8B8, 0x00ADADAD, 0x00A2A1A3, 0x00969597, 0x008C8B8D, 0x00848385, 0x007A797B, 0x00717072, 0x0069686A, 
        0x00626163, 0x005A595B, 0x00535254, 0x004B4A4C, 0x00464547, 0x00414042, 0x003B3A3C, 0x00343335, 0x00302F31, 0x002C2B2D, 0x002E2D2F, 0x00323133, 0x00363537, 0x003A393B, 0x003E3D3F, 0x00414042, 0x00444345, 0x00474648, 0x004A494B, 0x004D4C4E, 
        0x004F4E50, 0x00515052, 0x00535254, 0x00555456, 0x00575658, 0x0059585A, 0x005A595B, 0x005C5B5D, 0x005E5D5F, 0x00605F61, 0x00626163, 0x00646365, 0x00656466, 0x00666567, 0x00676668, 0x0069686A, 0x006A696B, 0x006B6A6C, 0x006C6B6D, 0x006D6C6E, 
        0x006F6E70, 0x006F6E70, 0x006E6D6F, 0x00737274, 0x00717072, 0x00777678, 0x007D7C7E, 0x007B7A7C, 0x008B8A8C, 0x63C6C6C6, 0xFFD7D7D7, 0xFFE0E0E0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFCECECE, 0x9D989799, 0x00757476, 0x006F6E70, 0x006B6A6C, 0x00656466, 0x00636264, 0x00666567, 0x00767577, 0x00787878, 0x00787878, 0x00777777, 
        0x00767676, 0x00757575, 0x00747474, 0x00737373, 0x00737373, 0x00727272, 0x00717171, 0x006F6F6F, 0x006E6E6E, 0x006D6D6D, 0x006C6C6C, 0x006A6A6A, 0x00696969, 0x00676767, 0x00656565, 0x00646464, 0x00626262, 0x00606060, 0x005E5E5E, 0x005C5C5C, 
        0x005A5A5A, 0x00585858, 0x00585858, 0x005A5A5A, 0x005E5E5E, 0x00616161, 0x00666666, 0x006D6D6D, 0x00747474, 0x007B7B7B, 0x00818181, 0x00868686, 0x008E8E8E, 0x00989898, 0x009F9F9F, 0x00A9A9A9, 0x00B4B4B4, 0x00BCBCBC, 0x00C6C6C6, 0x00D2D2D2, 
        0x00DCDCDC, 0x00E8E8E8, 0x00F5F5F5, 0x00FDFDFD, 0x00FFFFFF, 0x00F7F7F7, 0x00ECECEC, 0x00E2E2E2, 0x00D8D8D8, 0x00CDCDCD, 0x00C3C3C3, 0x00B9B9B9, 0x00AEAEAE, 0x00A4A3A5, 0x0099989A, 0x008F8E90, 0x00888789, 0x007E7D7F, 0x00767577, 0x006E6D6F, 
        0x00666567, 0x00605F61, 0x0059585A, 0x00504F51, 0x004B4A4C, 0x00474648, 0x00403F41, 0x003A393B, 0x00363537, 0x002F2E30, 0x002E2D2F, 0x002D2C2E, 0x002F2E30, 0x00343335, 0x00383739, 0x003C3B3D, 0x003E3D3F, 0x00434244, 0x00454446, 0x0049484A, 
        0x004B4A4C, 0x004D4C4E, 0x004F4E50, 0x00515052, 0x00535254, 0x00555456, 0x00565557, 0x00585759, 0x005A595B, 0x005C5B5D, 0x005D5C5E, 0x005F5E60, 0x00616062, 0x00626163, 0x00646365, 0x00656466, 0x00666567, 0x00676668, 0x0069686A, 0x006A696B, 
        0x006B6A6C, 0x006B6A6C, 0x0069686A, 0x006E6D6F, 0x006D6C6E, 0x00757476, 0x00777678, 0x007A797B, 0x009D9C9E, 0x9DCDCDCD, 0xFFDBDBDB, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDADADA, 0xFFD4D4D4, 0xD8AEADAF, 0x177A797B, 0x00747375, 0x006D6C6E, 0x006E6D6F, 0x00666567, 0x00626163, 0x00737274, 0x00767676, 0x00767676, 0x00757575, 
        0x00747474, 0x00737373, 0x00727272, 0x00727272, 0x00717171, 0x00707070, 0x006F6F6F, 0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x00696969, 0x00686868, 0x00666666, 0x00656565, 0x00636363, 0x00616161, 0x005F5F5F, 0x005D5D5D, 0x005B5B5B, 0x00585858, 
        0x00565656, 0x00565656, 0x00595959, 0x005E5E5E, 0x00646464, 0x00686868, 0x006D6D6D, 0x00737373, 0x00787878, 0x00818181, 0x00868686, 0x008C8C8C, 0x00949494, 0x009E9E9E, 0x00A5A5A5, 0x00AEAEAE, 0x00B8B8B8, 0x00C2C2C2, 0x00CCCCCC, 0x00D7D7D7, 
        0x00E1E1E1, 0x00EDEDED, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00F5F5F5, 0x00EAEAEA, 0x00E1E1E1, 0x00D8D8D8, 0x00CDCDCD, 0x00C4C4C4, 0x00BABABA, 0x00AFAFAF, 0x00A8A7A9, 0x009D9C9E, 0x00949395, 0x008D8C8E, 0x00838284, 0x007B7A7C, 0x00737274, 
        0x006B6A6C, 0x00656466, 0x005E5D5F, 0x00555456, 0x004F4E50, 0x004A494B, 0x00444345, 0x003F3E40, 0x003C3B3D, 0x00343335, 0x00313032, 0x002D2C2E, 0x002C2B2D, 0x00302F31, 0x00343335, 0x00383739, 0x0039383A, 0x003E3D3F, 0x00403F41, 0x00434244, 
        0x00464547, 0x00484749, 0x004A494B, 0x004C4B4D, 0x004E4D4F, 0x00525153, 0x00545355, 0x00565557, 0x00575658, 0x0059585A, 0x005A595B, 0x005C5B5D, 0x005E5D5F, 0x00605F61, 0x00616062, 0x00626163, 0x00646365, 0x00656466, 0x00666567, 0x00686769, 
        0x0069686A, 0x00686769, 0x00646365, 0x0069686A, 0x006A696B, 0x00747375, 0x00737274, 0x007A797B, 0x17AEADAF, 0xD8D0D0D0, 0xFFDDDDDD, 0xFFE7E7E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDFDFDF, 0xFFD6D6D6, 0xFFC7C6C8, 0x57838284, 0x00787779, 0x00717072, 0x00706F71, 0x006D6C6E, 0x00666567, 0x0069686A, 0x00777777, 0x00757575, 0x00747474, 
        0x00737373, 0x00737373, 0x00727272, 0x00707070, 0x006F6F6F, 0x006C6C6C, 0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x00686868, 0x00676767, 0x00656565, 0x00646464, 0x00626262, 0x00616161, 0x00606060, 0x005D5D5D, 0x005A5A5A, 0x00575757, 0x00565656, 
        0x00565656, 0x005B5B5B, 0x005F5F5F, 0x00646464, 0x006A6A6A, 0x006F6F6F, 0x00757575, 0x007B7B7B, 0x00808080, 0x00878787, 0x008C8C8C, 0x00949494, 0x009B9B9B, 0x00A3A3A3, 0x00ADADAD, 0x00B7B7B7, 0x00BDBDBD, 0x00C7C7C7, 0x00D2D2D2, 0x00DEDEDE, 
        0x00E7E7E7, 0x00F2F2F2, 0x00FDFDFD, 0x00FFFFFF, 0x00FDFDFD, 0x00F2F2F2, 0x00EBEBEB, 0x00E1E1E1, 0x00D7D7D7, 0x00CFCFCF, 0x00C5C5C5, 0x00BBBBBB, 0x00B3B3B3, 0x00A9A8AA, 0x00A09FA1, 0x00979698, 0x008F8E90, 0x00868587, 0x007F7E80, 0x00787779, 
        0x006F6E70, 0x00686769, 0x00636264, 0x005C5B5D, 0x00555456, 0x004F4E50, 0x004A494B, 0x00444345, 0x00403F41, 0x0039383A, 0x00353436, 0x00302F31, 0x002C2B2D, 0x002B2A2C, 0x002E2D2F, 0x00333234, 0x00363537, 0x0039383A, 0x003C3B3D, 0x003F3E40, 
        0x00424143, 0x00434244, 0x00464547, 0x0049484A, 0x004B4A4C, 0x004E4D4F, 0x004F4E50, 0x00515052, 0x00535254, 0x00545355, 0x00565557, 0x00585759, 0x0059585A, 0x0059585A, 0x005E5D5F, 0x00605F61, 0x005B5A5C, 0x00666567, 0x00616062, 0x00636264, 
        0x00676668, 0x005E5D5F, 0x00636264, 0x00656466, 0x0069686A, 0x006B6A6C, 0x00706F71, 0x00818082, 0x57C2C1C3, 0xFFD5D5D5, 0xFFDFDFDF, 0xFFEAEAEA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE2E2E2, 0xFFDADADA, 0xFFCDCCCE, 0x999C9B9D, 0x007C7B7D, 0x0079787A, 0x00757476, 0x00706F71, 0x006B6A6C, 0x0069686A, 0x00727272, 0x00727272, 0x00727272, 
        0x00717171, 0x006F6F6F, 0x006D6D6D, 0x006D6D6D, 0x006C6C6C, 0x006C6C6C, 0x006B6B6B, 0x00696969, 0x00676767, 0x00666666, 0x00646464, 0x00636363, 0x00626262, 0x005F5F5F, 0x005E5E5E, 0x005C5C5C, 0x005A5A5A, 0x00585858, 0x00575757, 0x00585858, 
        0x005A5A5A, 0x00616161, 0x00656565, 0x006A6A6A, 0x006F6F6F, 0x00747474, 0x007A7A7A, 0x00818181, 0x00868686, 0x008D8D8D, 0x00929292, 0x009A9A9A, 0x00A2A2A2, 0x00A9A9A9, 0x00B3B3B3, 0x00BCBCBC, 0x00C3C3C3, 0x00CCCCCC, 0x00D6D6D6, 0x00E1E1E1, 
        0x00EAEAEA, 0x00F5F5F5, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 0x00F1F1F1, 0x00EAEAEA, 0x00E0E0E0, 0x00D7D7D7, 0x00CFCFCF, 0x00C6C6C6, 0x00BCBCBC, 0x00B5B5B5, 0x00ABAAAC, 0x00A1A0A2, 0x0099989A, 0x00919092, 0x00888789, 0x00818082, 0x007A797B, 
        0x00717072, 0x006B6A6C, 0x00666567, 0x005F5E60, 0x00585759, 0x00535254, 0x004D4C4E, 0x00474648, 0x00434244, 0x003D3C3E, 0x003A393B, 0x00353436, 0x00313032, 0x002E2D2F, 0x002D2C2E, 0x002F2E30, 0x00313032, 0x00353436, 0x00383739, 0x003C3B3D, 
        0x003F3E40, 0x00414042, 0x00434244, 0x00464547, 0x00484749, 0x004B4A4C, 0x004C4B4D, 0x004E4D4F, 0x00504F51, 0x00525153, 0x00545355, 0x00565557, 0x00575658, 0x00575658, 0x005C5B5D, 0x005B5A5C, 0x005C5B5D, 0x00605F61, 0x00605F61, 0x005D5C5E, 
        0x00636264, 0x005E5D5F, 0x005F5E60, 0x005F5E60, 0x00646365, 0x006B6A6C, 0x00686769, 0x00969597, 0x99CBCACC, 0xFFD9D9D9, 0xFFE2E2E2, 0xFFEDEDED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE6E6E6, 0xFFDFDFDF, 0xFFD1D0D2, 0xDCB7B6B8, 0x23828183, 0x007E7D7F, 0x00787779, 0x00737274, 0x00706F71, 0x0069686A, 0x006D6D6D, 0x006F6F6F, 0x00707070, 
        0x006E6E6E, 0x006C6C6C, 0x006A6A6A, 0x00696969, 0x006A6A6A, 0x00696969, 0x00686868, 0x00666666, 0x00646464, 0x00626262, 0x00616161, 0x00606060, 0x00606060, 0x005B5B5B, 0x005A5A5A, 0x00585858, 0x00575757, 0x00575757, 0x005A5A5A, 0x005E5E5E, 
        0x00606060, 0x00666666, 0x006A6A6A, 0x00707070, 0x00757575, 0x007A7A7A, 0x00808080, 0x00868686, 0x008B8B8B, 0x00929292, 0x00989898, 0x00A0A0A0, 0x00A7A7A7, 0x00AFAFAF, 0x00B8B8B8, 0x00C2C2C2, 0x00C8C8C8, 0x00D2D2D2, 0x00DBDBDB, 0x00E5E5E5, 
        0x00EEEEEE, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F8F8, 0x00F0F0F0, 0x00E9E9E9, 0x00DFDFDF, 0x00D7D7D7, 0x00CFCFCF, 0x00C6C6C6, 0x00BDBDBD, 0x00B6B6B6, 0x00ADACAE, 0x00A4A3A5, 0x009C9B9D, 0x00949395, 0x008B8A8C, 0x00848385, 0x007E7D7F, 
        0x00757476, 0x006F6E70, 0x006A696B, 0x00636264, 0x005D5C5E, 0x00575658, 0x00525153, 0x004C4B4D, 0x00484749, 0x00424143, 0x00403F41, 0x003B3A3C, 0x00363537, 0x00323133, 0x002F2E30, 0x002D2C2E, 0x002C2B2D, 0x00313032, 0x00333234, 0x00373638, 
        0x003A393B, 0x003C3B3D, 0x003F3E40, 0x00424143, 0x00444345, 0x00464547, 0x00484749, 0x004A494B, 0x004C4B4D, 0x004E4D4F, 0x00504F51, 0x00535254, 0x00545355, 0x00545355, 0x0059585A, 0x00555456, 0x005C5B5D, 0x005A595B, 0x005D5C5E, 0x0059585A, 
        0x00626163, 0x005F5E60, 0x005C5B5D, 0x005B5A5C, 0x00616062, 0x00676668, 0x00686769, 0x23B1B0B2, 0xDCD3D2D4, 0xFFDEDEDE, 0xFFE6E6E6, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFD5D4D6, 0xFFC7C6C8, 0x6B919092, 0x00807F81, 0x007C7B7D, 0x00777678, 0x00767577, 0x006D6C6E, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 
        0x006C6C6C, 0x006B6B6B, 0x00696969, 0x00686868, 0x00686868, 0x00656565, 0x00646464, 0x00636363, 0x00626262, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x005A5A5A, 0x005E5E5E, 0x00646464, 
        0x00686868, 0x006C6C6C, 0x006F6F6F, 0x00757575, 0x007A7A7A, 0x007F7F7F, 0x00858585, 0x008C8C8C, 0x00909090, 0x00989898, 0x009E9E9E, 0x00A5A5A5, 0x00ADADAD, 0x00B5B5B5, 0x00BDBDBD, 0x00C6C6C6, 0x00CDCDCD, 0x00D8D8D8, 0x00E0E0E0, 0x00E9E9E9, 
        0x00F2F2F2, 0x00FCFCFC, 0x00FFFFFF, 0x00FEFEFE, 0x00F6F6F6, 0x00EFEFEF, 0x00E8E8E8, 0x00DFDFDF, 0x00D6D6D6, 0x00CFCFCF, 0x00C7C7C7, 0x00BEBEBE, 0x00B7B7B7, 0x00AFAEB0, 0x00A6A5A7, 0x009F9EA0, 0x00979698, 0x008E8D8F, 0x00888789, 0x00818082, 
        0x0079787A, 0x00737274, 0x006E6D6F, 0x00676668, 0x00616062, 0x005C5B5D, 0x00565557, 0x00504F51, 0x004C4B4D, 0x00464547, 0x00434244, 0x003F3E40, 0x003A393B, 0x00363537, 0x00323133, 0x002F2E30, 0x002D2C2E, 0x002D2C2E, 0x002F2E30, 0x00323133, 
        0x00353436, 0x00383739, 0x003B3A3C, 0x003E3D3F, 0x00403F41, 0x00434244, 0x00444345, 0x00464547, 0x0049484A, 0x004B4A4C, 0x004D4C4E, 0x004F4E50, 0x00515052, 0x00525153, 0x00545355, 0x00545355, 0x0059585A, 0x00565557, 0x0059585A, 0x005C5B5D, 
        0x00656466, 0x00626163, 0x00605F61, 0x005B5A5C, 0x00605F61, 0x005E5D5F, 0x007E7D7F, 0x6BC6C5C7, 0xFFD5D4D6, 0xFFE2E2E2, 0xFFEAEAEA, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDED, 0xFFE6E6E6, 0xFFDBDADC, 0xFFCFCED0, 0xB4A9A8AA, 0x00858486, 0x00828183, 0x007D7C7E, 0x007A797B, 0x00757476, 0x006F6F6F, 0x006D6D6D, 0x006A6A6A, 
        0x00696969, 0x00696969, 0x00696969, 0x00676767, 0x00656565, 0x00626262, 0x00626262, 0x00616161, 0x00606060, 0x005E5E5E, 0x005C5C5C, 0x005A5A5A, 0x00595959, 0x00565656, 0x00575757, 0x00585858, 0x005B5B5B, 0x005F5F5F, 0x00646464, 0x00696969, 
        0x006D6D6D, 0x00727272, 0x00767676, 0x007B7B7B, 0x00818181, 0x00868686, 0x008C8C8C, 0x00929292, 0x00979797, 0x009F9F9F, 0x00A4A4A4, 0x00ACACAC, 0x00B4B4B4, 0x00BBBBBB, 0x00C3C3C3, 0x00CCCCCC, 0x00D2D2D2, 0x00DDDDDD, 0x00E3E3E3, 0x00ECECEC, 
        0x00F6F6F6, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F4F4F4, 0x00EEEEEE, 0x00E8E8E8, 0x00DEDEDE, 0x00D6D6D6, 0x00CFCFCF, 0x00C7C7C7, 0x00BEBEBE, 0x00B8B8B8, 0x00B0AFB1, 0x00A8A7A9, 0x00A1A0A2, 0x009A999B, 0x00919092, 0x008A898B, 0x00848385, 
        0x007D7C7E, 0x00767577, 0x00717072, 0x006A696B, 0x00646365, 0x005F5E60, 0x005A595B, 0x00545355, 0x00504F51, 0x004A494B, 0x00474648, 0x00424143, 0x003D3C3E, 0x0039383A, 0x00363537, 0x00323133, 0x00302F31, 0x002C2B2D, 0x002D2C2E, 0x002F2E30, 
        0x00323133, 0x00353436, 0x00383739, 0x003B3A3C, 0x003D3C3E, 0x00403F41, 0x00424143, 0x00444345, 0x00464547, 0x00474648, 0x0049484A, 0x004B4A4C, 0x004D4C4E, 0x004F4E50, 0x004F4E50, 0x00555456, 0x00525153, 0x00545355, 0x00565557, 0x00636264, 
        0x006A696B, 0x00656466, 0x00666567, 0x005C5B5D, 0x005D5C5E, 0x0059585A, 0x00A09FA1, 0xB4D0CFD1, 0xFFD8D7D9, 0xFFE5E5E5, 0xFFEDEDED, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFEFEF, 0xFFE9E9E9, 0xFFE1E0E2, 0xFFD3D2D4, 0xFFBFBEC0, 0x4D939294, 0x00868587, 0x00807F81, 0x007C7B7D, 0x00787779, 0x00747474, 0x006F6F6F, 0x00696969, 
        0x00666666, 0x00666666, 0x00666666, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x005F5F5F, 0x005E5E5E, 0x005B5B5B, 0x00595959, 0x00575757, 0x00565656, 0x00575757, 0x00595959, 0x005C5C5C, 0x00606060, 0x00646464, 0x00696969, 0x006E6E6E, 
        0x00717171, 0x00777777, 0x007B7B7B, 0x00808080, 0x00858585, 0x008A8A8A, 0x00909090, 0x00979797, 0x009B9B9B, 0x00A3A3A3, 0x00A9A9A9, 0x00B1B1B1, 0x00B8B8B8, 0x00BFBFBF, 0x00C7C7C7, 0x00D0D0D0, 0x00D6D6D6, 0x00E0E0E0, 0x00E7E7E7, 0x00F0F0F0, 
        0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 0x00F3F3F3, 0x00EDEDED, 0x00E7E7E7, 0x00DEDEDE, 0x00D6D6D6, 0x00D0D0D0, 0x00C8C8C8, 0x00BFBFBF, 0x00B9B9B9, 0x00B1B0B2, 0x00AAA9AB, 0x00A4A3A5, 0x009D9C9E, 0x00939294, 0x008D8C8E, 0x00888789, 
        0x00818082, 0x0079787A, 0x00747375, 0x006E6D6F, 0x00686769, 0x00636264, 0x005E5D5F, 0x00585759, 0x00545355, 0x004F4E50, 0x004B4A4C, 0x00464547, 0x00414042, 0x003D3C3E, 0x003A393B, 0x00363537, 0x00343335, 0x002F2E30, 0x002E2D2F, 0x002E2D2F, 
        0x002F2E30, 0x00313032, 0x00343335, 0x00373638, 0x0039383A, 0x003D3C3E, 0x003E3D3F, 0x00403F41, 0x00424143, 0x00444345, 0x00464547, 0x00484749, 0x0049484A, 0x004D4C4E, 0x004B4A4C, 0x00535254, 0x004D4C4E, 0x00535254, 0x0059585A, 0x006B6A6C, 
        0x006D6C6E, 0x006A696B, 0x0069686A, 0x005E5D5F, 0x005C5B5D, 0x006B6A6C, 0x4DBEBDBF, 0xFFD7D6D8, 0xFFDEDDDF, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF6F6F6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE4E3E5, 0xFFD8D7D9, 0xFFCDCCCE, 0x9CAAA9AB, 0x008A898B, 0x00838284, 0x00818082, 0x007B7A7C, 0x00797979, 0x00737373, 0x006C6C6C, 
        0x00666666, 0x00636363, 0x00626262, 0x00616161, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005C5C5C, 0x005A5A5A, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x005C5C5C, 0x005E5E5E, 0x00626262, 0x00666666, 0x006A6A6A, 0x006F6F6F, 0x00737373, 
        0x00757575, 0x007B7B7B, 0x007F7F7F, 0x00858585, 0x008A8A8A, 0x008F8F8F, 0x00959595, 0x009B9B9B, 0x00A0A0A0, 0x00A7A7A7, 0x00ADADAD, 0x00B5B5B5, 0x00BCBCBC, 0x00C3C3C3, 0x00CBCBCB, 0x00D3D3D3, 0x00D9D9D9, 0x00E4E4E4, 0x00EAEAEA, 0x00F3F3F3, 
        0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00F3F3F3, 0x00ECECEC, 0x00E6E6E6, 0x00DDDDDD, 0x00D6D6D6, 0x00D0D0D0, 0x00C9C9C9, 0x00C0C0C0, 0x00BABABA, 0x00B3B2B4, 0x00ACABAD, 0x00A6A5A7, 0x009F9EA0, 0x00959496, 0x008F8E90, 0x008A898B, 
        0x00848385, 0x007D7C7E, 0x00787779, 0x00717072, 0x006C6B6D, 0x00676668, 0x00616062, 0x005C5B5D, 0x00585759, 0x00535254, 0x004F4E50, 0x004A494B, 0x00454446, 0x00424143, 0x003E3D3F, 0x003A393B, 0x00383739, 0x00333234, 0x00313032, 0x002F2E30, 
        0x002D2C2E, 0x002E2D2F, 0x00313032, 0x00333234, 0x00353436, 0x00383739, 0x003A393B, 0x003C3B3D, 0x003E3D3F, 0x00403F41, 0x00424143, 0x00454446, 0x00464547, 0x0049484A, 0x0049484A, 0x004D4C4E, 0x004C4B4D, 0x00535254, 0x00656466, 0x00747375, 
        0x00727173, 0x006F6E70, 0x006A696B, 0x00656466, 0x00656466, 0x00949395, 0x9CCECDCF, 0xFFDBDADC, 0xFFE4E3E5, 0xFFEDEDED, 0xFFF3F3F3, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFE7E6E8, 0xFFDFDEE0, 0xFFD5D4D6, 0xECBEBDBF, 0x40908F91, 0x00888789, 0x00888789, 0x007F7E80, 0x007D7D7D, 0x00787878, 0x006F6F6F, 
        0x00676767, 0x00626262, 0x00606060, 0x00606060, 0x00616161, 0x005D5D5D, 0x005B5B5B, 0x00585858, 0x00565656, 0x00565656, 0x00575757, 0x00585858, 0x00595959, 0x00626262, 0x00646464, 0x00676767, 0x006B6B6B, 0x006F6F6F, 0x00737373, 0x00777777, 
        0x007A7A7A, 0x00818181, 0x00848484, 0x008A8A8A, 0x008F8F8F, 0x00949494, 0x009A9A9A, 0x00A1A1A1, 0x00A5A5A5, 0x00ACACAC, 0x00B2B2B2, 0x00BABABA, 0x00C2C2C2, 0x00C8C8C8, 0x00D0D0D0, 0x00D8D8D8, 0x00DDDDDD, 0x00E6E6E6, 0x00EDEDED, 0x00F6F6F6, 
        0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00F8F8F8, 0x00F3F3F3, 0x00EAEAEA, 0x00E4E4E4, 0x00DCDCDC, 0x00D6D6D6, 0x00D0D0D0, 0x00C9C9C9, 0x00C1C1C1, 0x00BBBBBB, 0x00B4B3B5, 0x00ADACAE, 0x00A7A6A8, 0x00A09FA1, 0x00979698, 0x00919092, 0x008C8B8D, 
        0x00868587, 0x007F7E80, 0x007A797B, 0x00747375, 0x006E6D6F, 0x0069686A, 0x00646365, 0x005F5E60, 0x005B5A5C, 0x00555456, 0x00515052, 0x004C4B4D, 0x00484749, 0x00454446, 0x00424143, 0x003E3D3F, 0x003B3A3C, 0x00363537, 0x00333234, 0x002F2E30, 
        0x002D2C2E, 0x002C2B2D, 0x002E2D2F, 0x00302F31, 0x00323133, 0x00353436, 0x00363537, 0x0039383A, 0x003B3A3C, 0x003E3D3F, 0x00403F41, 0x00434244, 0x00444345, 0x00464547, 0x00474648, 0x00474648, 0x004F4E50, 0x00545355, 0x00727173, 0x007C7B7D, 
        0x00777678, 0x00727173, 0x0069686A, 0x006E6D6F, 0x00706F71, 0x40BAB9BB, 0xECD3D2D4, 0xFFDEDDDF, 0xFFE6E5E7, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFF2F2F2, 0xFFECECEC, 0xFFE0E0E0, 0xFFDADADA, 0xFFCBCBCB, 0x94A8A8A8, 0x008E8E8E, 0x00878787, 0x00858585, 0x00828183, 0x007B7A7C, 0x0079787A, 
        0x006F6E70, 0x005E5D5F, 0x005C5B5D, 0x00605F61, 0x005A595B, 0x005C5C5C, 0x00595959, 0x00565656, 0x00575757, 0x00595959, 0x005B5B5B, 0x005E5F5D, 0x00616260, 0x00646464, 0x00676767, 0x006B6B6B, 0x006F6F6F, 0x00737373, 0x00787878, 0x007C7C7C, 
        0x007F7F7F, 0x00858585, 0x00898989, 0x008F8F8F, 0x00949494, 0x00999999, 0x009F9F9F, 0x00A5A5A5, 0x00AAAAAA, 0x00B1B1B1, 0x00B7B7B7, 0x00BEBEBE, 0x00C5C5C5, 0x00CBCBCB, 0x00D3D3D3, 0x00DBDBDB, 0x00E1E1E1, 0x00E8E8E8, 0x00F1F1F1, 0x00FBFBFB, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F6F6F6, 0x00F1F1F1, 0x00E9E9E9, 0x00E4E4E4, 0x00DCDCDC, 0x00D5D5D5, 0x00D0D0D0, 0x00C9C9C9, 0x00C1C1C1, 0x00BCBCBC, 0x00B4B4B4, 0x00AFAFAF, 0x00A8A8A8, 0x00A1A1A1, 0x009B9B9B, 0x00949494, 0x008D8D8D, 
        0x00888888, 0x00818082, 0x007D7C7E, 0x00777678, 0x00717072, 0x006C6B6D, 0x00676668, 0x00626163, 0x005E5D5F, 0x0059585A, 0x00555456, 0x00515052, 0x004C4B4D, 0x0049484A, 0x00454446, 0x00414042, 0x003E3D3F, 0x003A393B, 0x00383739, 0x00353436, 
        0x00313032, 0x002E2D2F, 0x002C2B2D, 0x002C2B2D, 0x002C2B2D, 0x00333234, 0x00343335, 0x00353436, 0x0039383A, 0x003D3C3E, 0x003C3B3D, 0x003C3B3D, 0x00414042, 0x00464547, 0x00464547, 0x00454446, 0x00474648, 0x006F6E70, 0x00858486, 0x00777678, 
        0x0079787A, 0x00757476, 0x006D6C6E, 0x00706F71, 0x00989799, 0x94CFCED0, 0xFFD2D1D3, 0xFFECEBED, 0xFFE6E5E7, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFEEEEEE, 0xFFE7E7E7, 0xFFDDDDDD, 0xFFD1D1D1, 0xEAB9B9B9, 0x429B9B9B, 0x008A8A8A, 0x008A8A8A, 0x00888789, 0x00818082, 0x007E7D7F, 
        0x00777678, 0x00656466, 0x005B5A5C, 0x005A595B, 0x00585759, 0x00585858, 0x00565656, 0x00565656, 0x00585858, 0x005B5B5B, 0x005D5D5D, 0x00616260, 0x00656664, 0x00676767, 0x006A6A6A, 0x006E6E6E, 0x00727272, 0x00767676, 0x007B7B7B, 0x00808080, 
        0x00838383, 0x00888888, 0x008C8C8C, 0x00929292, 0x00979797, 0x009C9C9C, 0x00A2A2A2, 0x00A8A8A8, 0x00ADADAD, 0x00B4B4B4, 0x00BABABA, 0x00C1C1C1, 0x00C8C8C8, 0x00CECECE, 0x00D6D6D6, 0x00DEDEDE, 0x00E3E3E3, 0x00EBEBEB, 0x00F3F3F3, 0x00FCFCFC, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F5F5F5, 0x00F0F0F0, 0x00E9E9E9, 0x00E3E3E3, 0x00DCDCDC, 0x00D5D5D5, 0x00D0D0D0, 0x00C9C9C9, 0x00C2C2C2, 0x00BCBCBC, 0x00B5B5B5, 0x00B0B0B0, 0x00A9A9A9, 0x00A2A2A2, 0x009C9C9C, 0x00959595, 0x008F8F8F, 
        0x008A8A8A, 0x00838284, 0x007F7E80, 0x0079787A, 0x00747375, 0x006F6E70, 0x006A696B, 0x00646365, 0x00616062, 0x005B5A5C, 0x00585759, 0x00545355, 0x004F4E50, 0x004B4A4C, 0x00474648, 0x00434244, 0x00414042, 0x003D3C3E, 0x003B3A3C, 0x00383739, 
        0x00333234, 0x00302F31, 0x002D2C2E, 0x002D2C2E, 0x002C2B2D, 0x00313032, 0x00323133, 0x00323133, 0x00323133, 0x00373638, 0x003E3D3F, 0x00403F41, 0x003F3E40, 0x00403F41, 0x00414042, 0x00484749, 0x00504F51, 0x008E8D8F, 0x007F7E80, 0x00888789, 
        0x007C7B7D, 0x007C7B7D, 0x00737274, 0x007D7C7E, 0x42BDBCBE, 0xEACDCCCE, 0xFFE2E1E3, 0xFFE4E3E5, 0xFFF2F1F3, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF2F2F2, 0xFFEEEEEE, 0xFFE2E2E2, 0xFFD8D8D8, 0xFFCDCDCD, 0x9CAEAEAE, 0x00929292, 0x008F8F8F, 0x008A898B, 0x00848385, 0x00818082, 
        0x007D7C7E, 0x00706F71, 0x005F5E60, 0x00575658, 0x00575658, 0x00565656, 0x00565656, 0x00595959, 0x005C5C5C, 0x005F5F5F, 0x00616161, 0x00656565, 0x006A6A6A, 0x006C6C6C, 0x006F6F6F, 0x00737373, 0x00777777, 0x007B7B7B, 0x00808080, 0x00848484, 
        0x00888888, 0x008D8D8D, 0x00919191, 0x00979797, 0x009C9C9C, 0x00A1A1A1, 0x00A7A7A7, 0x00ADADAD, 0x00B2B2B2, 0x00B9B9B9, 0x00BEBEBE, 0x00C6C6C6, 0x00CCCCCC, 0x00D2D2D2, 0x00DADADA, 0x00E1E1E1, 0x00E7E7E7, 0x00EFEFEF, 0x00F6F6F6, 0x00FEFEFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FAFAFA, 0x00F4F4F4, 0x00EEEEEE, 0x00E8E8E8, 0x00E3E3E3, 0x00DCDCDC, 0x00D5D5D5, 0x00D0D0D0, 0x00C9C9C9, 0x00C2C2C2, 0x00BDBDBD, 0x00B6B6B6, 0x00B1B1B1, 0x00AAAAAA, 0x00A4A4A4, 0x009E9E9E, 0x00989898, 0x00919191, 
        0x008C8C8C, 0x00878688, 0x00828183, 0x007C7B7D, 0x00777678, 0x00727173, 0x006D6C6E, 0x00686769, 0x00646365, 0x005F5E60, 0x005C5B5D, 0x00575658, 0x00535254, 0x004F4E50, 0x004B4A4C, 0x00474648, 0x00454446, 0x00414042, 0x003F3E40, 0x003B3A3C, 
        0x00373638, 0x00333234, 0x00302F31, 0x002E2D2F, 0x002D2C2E, 0x002C2B2D, 0x002C2B2D, 0x00302F31, 0x00333234, 0x00343335, 0x00383739, 0x003B3A3C, 0x0039383A, 0x003C3B3D, 0x00403F41, 0x00454446, 0x00807F81, 0x008A898B, 0x008E8D8F, 0x00848385, 
        0x00828183, 0x007F7E80, 0x00787779, 0x00A4A3A5, 0x9CCECDCF, 0xFFD7D6D8, 0xFFE6E5E7, 0xFFE7E6E8, 0xFFF5F4F6, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFF1F1F1, 0xFFE7E7E7, 0xFFDEDEDE, 0xFFD6D6D6, 0xF6BFBFBF, 0x54A1A1A1, 0x00909090, 0x008D8C8E, 0x008A898B, 0x00858486, 
        0x00828183, 0x007B7A7C, 0x0069686A, 0x0059585A, 0x00545355, 0x00585858, 0x005A5A5A, 0x005E5E5E, 0x00626262, 0x00646464, 0x00656565, 0x00696969, 0x006E6E6E, 0x00717171, 0x00747474, 0x00787878, 0x007C7C7C, 0x00808080, 0x00848484, 0x00898989, 
        0x008C8C8C, 0x00919191, 0x00959595, 0x009B9B9B, 0x00A1A1A1, 0x00A6A6A6, 0x00ABABAB, 0x00B2B2B2, 0x00B6B6B6, 0x00BDBDBD, 0x00C2C2C2, 0x00CACACA, 0x00D0D0D0, 0x00D6D6D6, 0x00DDDDDD, 0x00E5E5E5, 0x00EAEAEA, 0x00F2F2F2, 0x00F9F9F9, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FEFEFE, 0x00F9F9F9, 0x00F3F3F3, 0x00EEEEEE, 0x00E7E7E7, 0x00E2E2E2, 0x00DBDBDB, 0x00D5D5D5, 0x00D0D0D0, 0x00CACACA, 0x00C3C3C3, 0x00BEBEBE, 0x00B7B7B7, 0x00B2B2B2, 0x00ACACAC, 0x00A5A5A5, 0x00A0A0A0, 0x009A9A9A, 0x00939393, 
        0x008F8F8F, 0x0089888A, 0x00858486, 0x007F7E80, 0x007A797B, 0x00757476, 0x00706F71, 0x006B6A6C, 0x00676668, 0x00626163, 0x005F5E60, 0x005B5A5C, 0x00565557, 0x00535254, 0x004F4E50, 0x004B4A4C, 0x00484749, 0x00444345, 0x00424143, 0x003F3E40, 
        0x003B3A3C, 0x00373638, 0x00343335, 0x00313032, 0x002F2E30, 0x002C2B2D, 0x00282729, 0x002E2D2F, 0x00363537, 0x00333234, 0x00302F31, 0x00353436, 0x003A393B, 0x003C3B3D, 0x00383739, 0x006A696B, 0x00989799, 0x008D8C8E, 0x00908F91, 0x00888789, 
        0x00858486, 0x007E7D7F, 0x008C8B8D, 0x54C8C7C9, 0xF6CECDCF, 0xFFE1E0E2, 0xFFE6E5E7, 0xFFF0EFF1, 0xFFF2F1F3, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE3E3E3, 0xFFD8D8D8, 0xFFCDCDCD, 0xB2B5B5B5, 0x12979797, 0x00949395, 0x00919092, 0x008B8A8C, 
        0x00878688, 0x00838284, 0x00767577, 0x00626262, 0x00555555, 0x005C5C5C, 0x005E5E5E, 0x00626262, 0x00666666, 0x00686868, 0x00696969, 0x006D6D6D, 0x00717171, 0x00757575, 0x00787878, 0x007C7C7C, 0x00808080, 0x00848484, 0x00888888, 0x008D8D8D, 
        0x00909090, 0x00959595, 0x00999999, 0x009F9F9F, 0x00A4A4A4, 0x00A9A9A9, 0x00AFAFAF, 0x00B5B5B5, 0x00BABABA, 0x00C1C1C1, 0x00C6C6C6, 0x00CDCDCD, 0x00D3D3D3, 0x00D9D9D9, 0x00E0E0E0, 0x00E7E7E7, 0x00EDEDED, 0x00F5F5F5, 0x00FAFAFA, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FDFDFD, 0x00F8F8F8, 0x00F3F3F3, 0x00EEEEEE, 0x00E7E7E7, 0x00E2E2E2, 0x00DBDBDB, 0x00D5D5D5, 0x00D0D0D0, 0x00CACACA, 0x00C3C3C3, 0x00BEBEBE, 0x00B7B7B7, 0x00B3B3B3, 0x00ADADAD, 0x00A7A7A7, 0x00A1A1A1, 0x009B9B9B, 0x00959595, 
        0x00919191, 0x008A898B, 0x00868587, 0x00807F81, 0x007B7A7C, 0x00777678, 0x00727173, 0x006D6C6E, 0x0069686A, 0x00656466, 0x00626163, 0x005D5C5E, 0x0059585A, 0x00555456, 0x00515052, 0x004E4D4F, 0x004B4A4C, 0x00464547, 0x00444345, 0x00414042, 
        0x003E3D3F, 0x003B3A3C, 0x00373638, 0x00343335, 0x00323133, 0x00302F31, 0x002C2B2D, 0x002C2B2D, 0x002E2D2F, 0x002F2E30, 0x00313032, 0x00363537, 0x003A393B, 0x00353436, 0x00515052, 0x00969597, 0x00989799, 0x00989799, 0x008E8D8F, 0x00939294, 
        0x00888789, 0x00868587, 0x12B1B0B2, 0xB2D1D0D2, 0xFFDBDADC, 0xFFE2E1E3, 0xFFEFEEF0, 0xFFF1F0F2, 0xFFF8F7F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF4F4F4, 0xFFF2F2F2, 0xFFE9E9E9, 0xFFDCDCDC, 0xFFD7D7D7, 0xFFC6C6C6, 0x73A8A8A8, 0x00989799, 0x00929193, 0x008C8B8D, 
        0x00888789, 0x00878688, 0x00818082, 0x00727272, 0x00616161, 0x00606060, 0x00616161, 0x00646464, 0x00686868, 0x006B6B6B, 0x006D6D6D, 0x00717171, 0x00757575, 0x00797979, 0x007C7C7C, 0x00808080, 0x00848484, 0x00888888, 0x008C8C8C, 0x00919191, 
        0x00949494, 0x00999999, 0x009D9D9D, 0x00A3A3A3, 0x00A8A8A8, 0x00ADADAD, 0x00B3B3B3, 0x00B9B9B9, 0x00BEBEBE, 0x00C4C4C4, 0x00C9C9C9, 0x00D0D0D0, 0x00D6D6D6, 0x00DCDCDC, 0x00E2E2E2, 0x00EAEAEA, 0x00EFEFEF, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FCFCFC, 0x00F7F7F7, 0x00F2F2F2, 0x00EEEEEE, 0x00E6E6E6, 0x00E1E1E1, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C4C4C4, 0x00BFBFBF, 0x00B8B8B8, 0x00B4B4B4, 0x00AEAEAE, 0x00A8A8A8, 0x00A3A3A3, 0x009D9D9D, 0x00979797, 
        0x00939393, 0x008C8B8D, 0x00888789, 0x00828183, 0x007D7C7E, 0x0079787A, 0x00757476, 0x00706F71, 0x006C6B6D, 0x00676668, 0x00646365, 0x00605F61, 0x005C5B5D, 0x00585759, 0x00545355, 0x00504F51, 0x004E4D4F, 0x004A494B, 0x00474648, 0x00434244, 
        0x00403F41, 0x003E3D3F, 0x003B3A3C, 0x00373638, 0x00353436, 0x00302F31, 0x00333234, 0x002D2C2E, 0x00282729, 0x002E2D2F, 0x00323133, 0x002F2E30, 0x002C2B2D, 0x00403F41, 0x008D8C8E, 0x00A2A1A3, 0x009E9D9F, 0x00979698, 0x00979698, 0x00919092, 
        0x008B8A8C, 0x009F9EA0, 0x73C8C7C9, 0xFFD2D1D3, 0xFFE3E2E4, 0xFFEAE9EB, 0xFFF0EFF1, 0xFFF1F0F2, 0xFFFDFCFE, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFEDEDED, 0xFFE5E5E5, 0xFFDEDEDE, 0xFFD0D0D0, 0xD6BFBFBF, 0x3BA1A0A2, 0x00959496, 0x008E8D8F, 
        0x008D8C8E, 0x008A8A8A, 0x00878787, 0x00818181, 0x00747474, 0x00666666, 0x00666666, 0x00676767, 0x006B6B6B, 0x006F6F6F, 0x00727272, 0x00767676, 0x00797979, 0x007D7D7D, 0x00808080, 0x00848484, 0x00888888, 0x008C8C8C, 0x00909090, 0x00959595, 
        0x00989898, 0x009D9D9D, 0x00A1A1A1, 0x00A7A7A7, 0x00ACACAC, 0x00B1B1B1, 0x00B7B7B7, 0x00BDBDBD, 0x00C2C2C2, 0x00C8C8C8, 0x00CDCDCD, 0x00D4D4D4, 0x00DADADA, 0x00DFDFDF, 0x00E5E5E5, 0x00EDEDED, 0x00F2F2F2, 0x00F9F9F9, 0x00FDFDFD, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FBFBFB, 0x00F6F6F6, 0x00F1F1F1, 0x00EDEDED, 0x00E5E5E5, 0x00E1E1E1, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C4C4C4, 0x00C0C0C0, 0x00B9B9B9, 0x00B5B5B5, 0x00AFAFAF, 0x00AAAAAA, 0x00A5A5A5, 0x009F9F9F, 0x00999999, 
        0x00959595, 0x008E8D8F, 0x008A898B, 0x00858486, 0x00807F81, 0x007C7B7D, 0x00777678, 0x00727173, 0x006F6E70, 0x006A696B, 0x00676668, 0x00636264, 0x005F5E60, 0x005B5A5C, 0x00575658, 0x00545355, 0x00515052, 0x004D4C4E, 0x004A494B, 0x00464547, 
        0x00434244, 0x00414042, 0x003E3D3F, 0x003A393B, 0x00383739, 0x00313032, 0x00363537, 0x00302F31, 0x002C2B2D, 0x00313032, 0x002C2B2D, 0x002B2A2C, 0x0039383A, 0x0079787A, 0x00AAA9AB, 0x00A9A8AA, 0x009F9EA0, 0x009C9B9D, 0x00969597, 0x00959496, 
        0x009A999B, 0x3BBDBCBE, 0xD6CFCED0, 0xFFDAD9DB, 0xFFE4E3E5, 0xFFF3F2F4, 0xFFEFEEF0, 0xFFF6F5F7, 0xFFFAF9FB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFFCFCFC, 0xFFF4F4F4, 0xFFEEEEEE, 0xFFEDEDED, 0xFFE1E1E1, 0xFFD2D2D2, 0xFFD0D0D0, 0xA1B2B1B3, 0x089E9D9F, 0x00979698, 
        0x00969597, 0x008D8D8D, 0x00898989, 0x00888888, 0x00818181, 0x006D6D6D, 0x006B6B6B, 0x006B6B6B, 0x006E6E6E, 0x00727272, 0x00757575, 0x00797979, 0x007B7B7B, 0x007F7F7F, 0x00828282, 0x00868686, 0x008B8B8B, 0x008E8E8E, 0x00939393, 0x00989898, 
        0x009B9B9B, 0x00A0A0A0, 0x00A4A4A4, 0x00A9A9A9, 0x00AFAFAF, 0x00B4B4B4, 0x00BABABA, 0x00C0C0C0, 0x00C4C4C4, 0x00CBCBCB, 0x00D0D0D0, 0x00D6D6D6, 0x00DCDCDC, 0x00E1E1E1, 0x00E8E8E8, 0x00EFEFEF, 0x00F4F4F4, 0x00FBFBFB, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FEFEFE, 0x00FAFAFA, 0x00F5F5F5, 0x00F0F0F0, 0x00ECECEC, 0x00E5E5E5, 0x00E0E0E0, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C5C5C5, 0x00C0C0C0, 0x00BABABA, 0x00B6B6B6, 0x00B0B0B0, 0x00ABABAB, 0x00A6A6A6, 0x00A1A1A1, 0x009B9B9B, 
        0x00979797, 0x00908F91, 0x008C8B8D, 0x00878688, 0x00828183, 0x007E7D7F, 0x0079787A, 0x00747375, 0x00717072, 0x006C6B6D, 0x0069686A, 0x00656466, 0x00616062, 0x005D5C5E, 0x005A595B, 0x00565557, 0x00535254, 0x00504F51, 0x004D4C4E, 0x00484749, 
        0x00454446, 0x00424143, 0x003F3E40, 0x003C3B3D, 0x0039383A, 0x00363537, 0x00373638, 0x002F2E30, 0x00302F31, 0x00323133, 0x00242325, 0x00323133, 0x00616062, 0x00B5B4B6, 0x00A9A8AA, 0x00A7A6A8, 0x00ACABAD, 0x009A999B, 0x009F9EA0, 0x009B9A9C, 
        0x08B2B1B3, 0xA1D0CFD1, 0xFFD5D4D6, 0xFFE0DFE1, 0xFFE9E8EA, 0xFFF1F0F2, 0xFFF8F7F9, 0xFFFAF9FB, 0xFFF7F6F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF0F0F0, 0xFFE9E9E9, 0xFFDEDEDE, 0xFFD6D6D6, 0xFFC5C5C5, 0x72AFAFAF, 0x009A9A9A, 
        0x00949494, 0x00939393, 0x008F8F8F, 0x008A8A8A, 0x00888888, 0x00808080, 0x00757575, 0x006F6F6F, 0x00737373, 0x00787779, 0x007A797B, 0x007D7C7E, 0x00818082, 0x00858585, 0x00878787, 0x008A8A8A, 0x008E8E8E, 0x00929292, 0x00979797, 0x009C9C9C, 
        0x009F9F9F, 0x00A4A4A4, 0x00A8A8A8, 0x00AEAEAE, 0x00B3B3B3, 0x00B8B8B8, 0x00BDBDBD, 0x00C4C4C4, 0x00C8C8C8, 0x00CDCDCD, 0x00D2D2D2, 0x00D9D9D9, 0x00DFDFDF, 0x00E5E5E5, 0x00EBEBEB, 0x00F0F0F0, 0x00F4F4F4, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FDFDFD, 0x00F9F9F9, 0x00F5F5F5, 0x00EFEFEF, 0x00EAEAEA, 0x00E4E4E4, 0x00E0E0E0, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C5C5C5, 0x00C1C1C1, 0x00BBBBBB, 0x00B7B7B7, 0x00B1B1B1, 0x00ACACAC, 0x00A7A7A7, 0x00A2A2A2, 0x009C9C9C, 
        0x00989898, 0x00939294, 0x008F8E90, 0x0089888A, 0x00848385, 0x00807F81, 0x007C7B7D, 0x00777678, 0x00737274, 0x00706F71, 0x006D6C6E, 0x00686769, 0x00646365, 0x00605F61, 0x005D5C5E, 0x0059585A, 0x00565557, 0x00535254, 0x004F4E50, 0x0049484A, 
        0x00464547, 0x00464547, 0x00414042, 0x003D3C3E, 0x003F3E40, 0x003D3C3E, 0x00363537, 0x00363537, 0x00363537, 0x002D2C2E, 0x002D2C2E, 0x00565557, 0x00B8B7B9, 0x00B5B5B5, 0x00AFAFAF, 0x00ACACAC, 0x00AAAAAA, 0x00A2A2A2, 0x009E9E9E, 0x00B0B0B0, 
        0x72C8C8C8, 0xFFD6D6D6, 0xFFDEDEDE, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE3E3E3, 0xFFDBDBDB, 0xFFD1D1D1, 0xDCC0C0C0, 0x49AAAAAA, 
        0x009C9C9C, 0x00969696, 0x00939393, 0x008F8F8F, 0x008C8C8C, 0x00868686, 0x007F7F7F, 0x00777777, 0x00747474, 0x00787779, 0x007C7B7D, 0x00807F81, 0x00828183, 0x00868686, 0x00898989, 0x008D8D8D, 0x00919191, 0x00969696, 0x009A9A9A, 0x009E9E9E, 
        0x00A1A1A1, 0x00A7A7A7, 0x00ABABAB, 0x00B1B1B1, 0x00B6B6B6, 0x00BBBBBB, 0x00C0C0C0, 0x00C6C6C6, 0x00CBCBCB, 0x00D0D0D0, 0x00D4D4D4, 0x00DBDBDB, 0x00E1E1E1, 0x00E7E7E7, 0x00ECECEC, 0x00F3F3F3, 0x00F7F7F7, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FDFDFD, 0x00F9F9F9, 0x00F4F4F4, 0x00EEEEEE, 0x00EAEAEA, 0x00E4E4E4, 0x00E0E0E0, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C5C5C5, 0x00C1C1C1, 0x00BCBCBC, 0x00B8B8B8, 0x00B2B2B2, 0x00ADADAD, 0x00A8A8A8, 0x00A3A3A3, 0x009D9D9D, 
        0x00999999, 0x00949395, 0x00908F91, 0x008A898B, 0x00868587, 0x00828183, 0x007D7C7E, 0x00787779, 0x00757476, 0x00717072, 0x006E6D6F, 0x006A696B, 0x00656466, 0x00626163, 0x005E5D5F, 0x005A595B, 0x00585759, 0x00535254, 0x00545355, 0x00515052, 
        0x004A494B, 0x00454446, 0x00444345, 0x00444345, 0x00434244, 0x003C3B3D, 0x003E3D3F, 0x00373638, 0x00313032, 0x00333234, 0x00504F51, 0x00B6B5B7, 0x00BCBBBD, 0x00BABABA, 0x00B6B6B6, 0x00B1B1B1, 0x00ABABAB, 0x00A6A6A6, 0x00ACACAC, 0x49BFBFBF, 
        0xDCD2D2D2, 0xFFDBDBDB, 0xFFE3E3E3, 0xFFEDEDED, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF1F1F1, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFDADADA, 0xFFCFCFCF, 0xB6BCBCBC, 
        0x26A7A7A7, 0x009A9A9A, 0x00969696, 0x00939393, 0x00909090, 0x008C8C8C, 0x00888888, 0x00818082, 0x007A797B, 0x007B7A7C, 0x00807F81, 0x00848385, 0x00858486, 0x00898989, 0x008C8C8C, 0x00919191, 0x00959595, 0x00999999, 0x009E9E9E, 0x00A2A2A2, 
        0x00A5A5A5, 0x00ABABAB, 0x00AFAFAF, 0x00B5B5B5, 0x00BABABA, 0x00BEBEBE, 0x00C4C4C4, 0x00CACACA, 0x00CECECE, 0x00D4D4D4, 0x00D8D8D8, 0x00DEDEDE, 0x00E4E4E4, 0x00E9E9E9, 0x00EFEFEF, 0x00F6F6F6, 0x00FAFAFA, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F8F8F8, 0x00F3F3F3, 0x00EEEEEE, 0x00E9E9E9, 0x00E3E3E3, 0x00DFDFDF, 0x00DADADA, 0x00D5D5D5, 0x00D0D0D0, 0x00CBCBCB, 0x00C6C6C6, 0x00C2C2C2, 0x00BDBDBD, 0x00B9B9B9, 0x00B3B3B3, 0x00AEAEAE, 0x00AAAAAA, 0x00A5A5A5, 0x009F9F9F, 
        0x009B9B9B, 0x00969597, 0x00929193, 0x008C8B8D, 0x00888789, 0x00848385, 0x007F7E80, 0x007B7A7C, 0x00777678, 0x00737274, 0x00706F71, 0x006C6B6D, 0x00686769, 0x00646365, 0x00616062, 0x005D5C5E, 0x005A595B, 0x00575658, 0x00525153, 0x00504F51, 
        0x004F4E50, 0x004B4A4C, 0x0049484A, 0x00454446, 0x003D3C3E, 0x00444345, 0x00353436, 0x003E3D3F, 0x003C3B3D, 0x0049484A, 0x00BCBBBD, 0x00CAC9CB, 0x00C2C1C3, 0x00BDBDBD, 0x00BBBBBB, 0x00B5B5B5, 0x00ADADAD, 0x00AFAFAF, 0x26BDBDBD, 0xB6CECECE, 
        0xFFDADADA, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFF1F1F1, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF0F0F0, 0xFFEAEAEA, 0xFFDFDFDF, 0xFFD8D8D8, 0xFFC9C9C9, 
        0x96B5B5B5, 0x08A4A4A4, 0x009A9A9A, 0x00969696, 0x00959595, 0x00909090, 0x008D8D8D, 0x00888789, 0x00838284, 0x00818082, 0x00838284, 0x00878688, 0x00888789, 0x008D8D8D, 0x00919191, 0x00959595, 0x00999999, 0x009C9C9C, 0x00A0A0A0, 0x00A5A5A5, 
        0x00A9A9A9, 0x00AFAFAF, 0x00B3B3B3, 0x00B8B8B8, 0x00BDBDBD, 0x00C2C2C2, 0x00C7C7C7, 0x00CDCDCD, 0x00D1D1D1, 0x00D8D8D8, 0x00DCDCDC, 0x00E1E1E1, 0x00E6E6E6, 0x00ECECEC, 0x00F2F2F2, 0x00F8F8F8, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FBFBFB, 0x00F7F7F7, 0x00F2F2F2, 0x00EDEDED, 0x00E9E9E9, 0x00E3E3E3, 0x00DFDFDF, 0x00D9D9D9, 0x00D5D5D5, 0x00D0D0D0, 0x00CCCCCC, 0x00C6C6C6, 0x00C2C2C2, 0x00BDBDBD, 0x00B9B9B9, 0x00B4B4B4, 0x00AFAFAF, 0x00ABABAB, 0x00A6A6A6, 0x00A0A0A0, 
        0x009C9C9C, 0x00979698, 0x00939294, 0x008E8D8F, 0x0089888A, 0x00868587, 0x00818082, 0x007D7C7E, 0x0079787A, 0x00757476, 0x00727173, 0x006E6D6F, 0x006A696B, 0x00666567, 0x00636264, 0x005F5E60, 0x005C5B5D, 0x005C5B5D, 0x00515052, 0x004F4E50, 
        0x00535254, 0x004F4E50, 0x0049484A, 0x00464547, 0x00434244, 0x00414042, 0x003F3E40, 0x00383739, 0x00555456, 0x00C0BFC1, 0x00CAC9CB, 0x00CDCCCE, 0x00BDBCBE, 0x00C0C0C0, 0x00BDBDBD, 0x00B8B8B8, 0x00B6B6B6, 0x08BCBCBC, 0x96CBCBCB, 0xFFD8D8D8, 
        0xFFDFDFDF, 0xFFEAEAEA, 0xFFF0F0F0, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF3F3F3, 0xFFEFEFEF, 0xFFE6E6E6, 0xFFE0E0E0, 0xFFD5D5D5, 
        0xFFC7C7C7, 0x7CB4B4B4, 0x00A3A3A3, 0x00999999, 0x00979797, 0x00959496, 0x008F8E90, 0x008A898B, 0x0089888A, 0x00868587, 0x00848385, 0x00888789, 0x008E8D8F, 0x00929292, 0x00959595, 0x00999999, 0x009C9C9C, 0x009F9F9F, 0x00A3A3A3, 0x00A8A8A8, 
        0x00ADADAD, 0x00B2B2B2, 0x00B6B6B6, 0x00BBBBBB, 0x00C0C0C0, 0x00C4C4C4, 0x00C9C9C9, 0x00CFCFCF, 0x00D3D3D3, 0x00DADADA, 0x00DEDEDE, 0x00E4E4E4, 0x00E9E9E9, 0x00EEEEEE, 0x00F3F3F3, 0x00FAFAFA, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 
        0x00FAFAFA, 0x00F5F5F5, 0x00F1F1F1, 0x00ECECEC, 0x00E8E8E8, 0x00E3E3E3, 0x00DFDFDF, 0x00D9D9D9, 0x00D5D5D5, 0x00D0D0D0, 0x00CCCCCC, 0x00C6C6C6, 0x00C2C2C2, 0x00BDBDBD, 0x00B9B9B9, 0x00B4B4B4, 0x00AFAFAF, 0x00ABABAB, 0x00A7A7A7, 0x00A1A1A1, 
        0x009D9D9D, 0x00989799, 0x00959496, 0x008F8E90, 0x008B8A8C, 0x00878688, 0x00838284, 0x007F7E80, 0x007B7A7C, 0x00777678, 0x00747375, 0x00706F71, 0x006C6B6D, 0x0069686A, 0x00656466, 0x00616062, 0x005F5E60, 0x005D5C5E, 0x00585759, 0x00555456, 
        0x00535254, 0x004E4D4F, 0x004A494B, 0x004B4A4C, 0x004C4B4D, 0x00403F41, 0x00424143, 0x0059585A, 0x00C0BFC1, 0x00D1D0D2, 0x00D6D5D7, 0x00C9C8CA, 0x00C9C8CA, 0x00C7C7C7, 0x00C0C0C0, 0x00BCBCBC, 0x00C0C0C0, 0x7CCACACA, 0xFFD5D5D5, 0xFFDFDFDF, 
        0xFFE7E7E7, 0xFFEFEFEF, 0xFFF3F3F3, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFEDEDED, 0xFFE7E7E7, 0xFFDFDFDF, 
        0xFFD4D4D4, 0xF0C4C4C4, 0x68AFAFAF, 0x009F9F9F, 0x00989898, 0x009B9A9C, 0x00939294, 0x008D8C8E, 0x008B8A8C, 0x00888789, 0x00848385, 0x00888789, 0x00919092, 0x00949494, 0x00989898, 0x009C9C9C, 0x00A0A0A0, 0x00A2A2A2, 0x00A6A6A6, 0x00ACACAC, 
        0x00B0B0B0, 0x00B5B5B5, 0x00B9B9B9, 0x00BEBEBE, 0x00C3C3C3, 0x00C7C7C7, 0x00CCCCCC, 0x00D2D2D2, 0x00D6D6D6, 0x00DCDCDC, 0x00E0E0E0, 0x00E6E6E6, 0x00EBEBEB, 0x00F0F0F0, 0x00F5F5F5, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 
        0x00F9F9F9, 0x00F4F4F4, 0x00F0F0F0, 0x00ECECEC, 0x00E8E8E8, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D4D4D4, 0x00D1D1D1, 0x00CCCCCC, 0x00C7C7C7, 0x00C3C3C3, 0x00BDBDBD, 0x00BABABA, 0x00B4B4B4, 0x00B0B0B0, 0x00ACACAC, 0x00A8A8A8, 0x00A2A2A2, 
        0x009F9F9F, 0x009A999B, 0x00969597, 0x00919092, 0x008D8C8E, 0x0089888A, 0x00858486, 0x00818082, 0x007D7C7E, 0x0079787A, 0x00767577, 0x00727173, 0x006E6D6F, 0x006B6A6C, 0x00676668, 0x00646365, 0x00616062, 0x005B5A5C, 0x005E5D5F, 0x00575658, 
        0x00515052, 0x00535254, 0x00525153, 0x00484749, 0x00414042, 0x004A494B, 0x00605F61, 0x00D2D1D3, 0x00DCDBDD, 0x00D7D6D8, 0x00D1D0D2, 0x00D2D1D3, 0x00CDCCCE, 0x00CBCBCB, 0x00C2C2C2, 0x00BFBFBF, 0x68C8C8C8, 0xF0D3D3D3, 0xFFDBDBDB, 0xFFE4E4E4, 
        0xFFEEEEEE, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF2F3F1, 0xFFEDEEEC, 0xFFE5E5E5, 
        0xFFDDDDDD, 0xFFD2D2D2, 0xDFC2C2C2, 0x5AAFAFAF, 0x00A0A0A0, 0x009E9D9F, 0x0099989A, 0x00949395, 0x008F8E90, 0x008A898B, 0x00878688, 0x00888789, 0x008B8A8C, 0x00949494, 0x00999999, 0x009F9F9F, 0x00A4A4A4, 0x00A6A6A6, 0x00AAAAAA, 0x00AFAFAF, 
        0x00B3B3B3, 0x00B8B8B8, 0x00BCBCBC, 0x00C1C1C1, 0x00C6C6C6, 0x00CACACA, 0x00CFCFCF, 0x00D4D4D4, 0x00D8D8D8, 0x00DEDEDE, 0x00E2E2E2, 0x00E8E8E8, 0x00EDEDED, 0x00F2F2F2, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 
        0x00F8F8F8, 0x00F3F3F3, 0x00EFEFEF, 0x00EBEBEB, 0x00E7E7E7, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D4D4D4, 0x00D1D1D1, 0x00CCCCCC, 0x00C7C7C7, 0x00C3C3C3, 0x00BEBEBE, 0x00BBBBBB, 0x00B5B5B5, 0x00B1B1B1, 0x00ADADAD, 0x00A9A9A9, 0x00A4A4A4, 
        0x00A0A0A0, 0x009C9B9D, 0x00989799, 0x00939294, 0x008F8E90, 0x008B8A8C, 0x00878688, 0x00838284, 0x00807F81, 0x007B7A7C, 0x00787779, 0x00747375, 0x00706F71, 0x006D6C6E, 0x006A696B, 0x00666567, 0x00636264, 0x005C5B5D, 0x005E5D5F, 0x00555456, 
        0x00525153, 0x0059585A, 0x00535254, 0x004C4B4D, 0x00545355, 0x00767577, 0x00E1E0E2, 0x00E0DFE1, 0x00E4E3E5, 0x00E0DFE1, 0x00D5D4D6, 0x00D0CFD1, 0x00D1D0D2, 0x00CBCBCB, 0x00C5C5C5, 0x5AC6C6C6, 0xDFD1D1D1, 0xFFDCDCDC, 0xFFE3E3E3, 0xFFEBEBEB, 
        0xFFF2F2F2, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF4F5F3, 0xFFF2F3F1, 0xFFEBEBEB, 
        0xFFE2E2E2, 0xFFDCDCDC, 0xFFD4D4D4, 0xD4C0C0C0, 0x51ABABAB, 0x009E9D9F, 0x009E9D9F, 0x009B9A9C, 0x00949395, 0x008E8D8F, 0x008A898B, 0x00878688, 0x00838284, 0x00939393, 0x00999999, 0x00A1A1A1, 0x00A7A7A7, 0x00AAAAAA, 0x00ADADAD, 0x00B1B1B1, 
        0x00B5B5B5, 0x00BBBBBB, 0x00BEBEBE, 0x00C3C3C3, 0x00C8C8C8, 0x00CCCCCC, 0x00D1D1D1, 0x00D6D6D6, 0x00DBDBDB, 0x00DFDFDF, 0x00E3E3E3, 0x00E9E9E9, 0x00EFEFEF, 0x00F3F3F3, 0x00F8F8F8, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 
        0x00F7F7F7, 0x00F3F3F3, 0x00EFEFEF, 0x00EBEBEB, 0x00E7E7E7, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D4D4D4, 0x00D1D1D1, 0x00CCCCCC, 0x00C7C7C7, 0x00C3C3C3, 0x00BFBFBF, 0x00BBBBBB, 0x00B6B6B6, 0x00B2B2B2, 0x00AEAEAE, 0x00AAAAAA, 0x00A5A5A5, 
        0x00A1A1A1, 0x009D9C9E, 0x0099989A, 0x00949395, 0x00908F91, 0x008D8C8E, 0x0089888A, 0x00848385, 0x00818082, 0x007D7C7E, 0x007A797B, 0x00767577, 0x00727173, 0x006F6E70, 0x006B6A6C, 0x00686769, 0x00656466, 0x00605F61, 0x00616062, 0x00585759, 
        0x00575658, 0x00575658, 0x004A494B, 0x005C5B5D, 0x008D8C8E, 0x00EEEDEF, 0x00E7E6E8, 0x00EDECEE, 0x00DEDDDF, 0x00E0DFE1, 0x00DFDEE0, 0x00D5D4D6, 0x00D8D7D9, 0x00C9C9C9, 0x51C9C9C9, 0xD4CECECE, 0xFFDADADA, 0xFFE5E5E5, 0xFFECECEC, 0xFFF1F1F1, 
        0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFEFEFEF, 
        0xFFE9E9E9, 0xFFE3E3E3, 0xFFDBDBDB, 0xFFD0D0D0, 0xCEC6C6C6, 0x4EA9A9A9, 0x00A2A2A2, 0x009C9C9C, 0x00969696, 0x00919191, 0x00919191, 0x008E8E8E, 0x00868686, 0x00818181, 0x00909090, 0x00A1A1A1, 0x00AAAAAA, 0x00ACACAC, 0x00AEAEAE, 0x00B5B5B5, 
        0x00BBBBBB, 0x00C0C0C0, 0x00C0C0C0, 0x00C4C4C4, 0x00CBCBCB, 0x00D1D1D1, 0x00D4D4D4, 0x00D7D7D7, 0x00DBDBDB, 0x00E2E2E2, 0x00E6E6E6, 0x00EBEBEB, 0x00EFEFEF, 0x00F5F5F5, 0x00FBFBFB, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBFBFB, 
        0x00F7F7F7, 0x00F3F3F3, 0x00EEEEEE, 0x00E9E9E9, 0x00E7E7E7, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D5D5D5, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C4C4C4, 0x00BFBFBF, 0x00BCBCBC, 0x00B7B7B7, 0x00B3B3B3, 0x00AFAFAF, 0x00ABABAB, 0x00A7A7A7, 
        0x00A4A4A4, 0x009D9C9E, 0x009A999B, 0x00969597, 0x00919092, 0x008D8C8E, 0x0089888A, 0x00858486, 0x00828183, 0x007E7D7F, 0x007C7B7D, 0x0079787A, 0x00757476, 0x00717072, 0x006E6D6F, 0x006A696B, 0x00676668, 0x00636363, 0x005E5E5E, 0x00626262, 
        0x00535353, 0x00585858, 0x00616161, 0x00BBBBBB, 0x00F5F5F5, 0x00EFEFEF, 0x00EFEFEF, 0x00EBEBEB, 0x00E5E5E5, 0x00E3E3E3, 0x00E1E1E1, 0x00DADADA, 0x00D0D0D0, 0x4EC8C8C8, 0xCED1D1D1, 0xFFDCDCDC, 0xFFE4E4E4, 0xFFEAEAEA, 0xFFF1F1F1, 0xFFF6F6F6, 
        0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF5F5F5, 
        0xFFEFEFEF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFD9D9D9, 0xFFD0D0D0, 0xCEC3C3C3, 0x51ADADAD, 0x009E9E9E, 0x009D9D9D, 0x00999999, 0x00929292, 0x008F8F8F, 0x008E8E8E, 0x008B8B8B, 0x00818181, 0x00878787, 0x009F9F9F, 0x00B3B3B3, 0x00B7B7B7, 0x00B6B6B6, 
        0x00B8B8B8, 0x00C2C2C2, 0x00C3C3C3, 0x00C8C8C8, 0x00CECECE, 0x00D2D2D2, 0x00D4D4D4, 0x00DCDCDC, 0x00E4E4E4, 0x00E3E3E3, 0x00E7E7E7, 0x00ECECEC, 0x00F1F1F1, 0x00F7F7F7, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBFBFB, 
        0x00F7F7F7, 0x00F2F2F2, 0x00EDEDED, 0x00E9E9E9, 0x00E7E7E7, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D5D5D5, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C4C4C4, 0x00BFBFBF, 0x00BCBCBC, 0x00B8B8B8, 0x00B4B4B4, 0x00B0B0B0, 0x00ACACAC, 0x00A7A7A7, 
        0x00A4A4A4, 0x009F9EA0, 0x009B9A9C, 0x00979698, 0x00929193, 0x008F8E90, 0x008B8A8C, 0x00878688, 0x00848385, 0x00818082, 0x007B7A7C, 0x00747375, 0x00727173, 0x00737274, 0x00727173, 0x006C6B6D, 0x00676668, 0x00696969, 0x00646464, 0x005A5A5A, 
        0x00616161, 0x00757575, 0x00E8E8E8, 0x00F6F6F6, 0x00FFFFFF, 0x00F8F8F8, 0x00F5F5F5, 0x00F0F0F0, 0x00ECECEC, 0x00E8E8E8, 0x00E1E1E1, 0x00D3D3D3, 0x51C7C7C7, 0xCED0D0D0, 0xFFD9D9D9, 0xFFE2E2E2, 0xFFE9E9E9, 0xFFEFEFEF, 0xFFF4F4F4, 0xFFF8F8F8, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF7F7F7, 
        0xFFF4F4F4, 0xFFF0F0F0, 0xFFEBEBEB, 0xFFE2E2E2, 0xFFDADADA, 0xFFD2D2D2, 0xD4C1C1C1, 0x5AAFAFAF, 0x00A2A2A2, 0x00999999, 0x00989898, 0x00959595, 0x00909090, 0x008B8B8B, 0x00838383, 0x007F7F7F, 0x00888888, 0x00999999, 0x00ACACAC, 0x00BBBBBB, 
        0x00C3C3C3, 0x00C0C0C0, 0x00C7C7C7, 0x00CCCCCC, 0x00CCCCCC, 0x00D1D1D1, 0x00D9D9D9, 0x00DCDCDC, 0x00D9D9D9, 0x00E5E5E5, 0x00EAEAEA, 0x00EFEFEF, 0x00F4F4F4, 0x00F9F9F9, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FAFAFA, 
        0x00F6F6F6, 0x00F2F2F2, 0x00EDEDED, 0x00E9E9E9, 0x00E6E6E6, 0x00E1E1E1, 0x00DEDEDE, 0x00D9D9D9, 0x00D5D5D5, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C5C5C5, 0x00BFBFBF, 0x00BCBCBC, 0x00B8B8B8, 0x00B4B4B4, 0x00B0B0B0, 0x00ACACAC, 0x00A8A8A8, 
        0x00A5A5A5, 0x00A09FA1, 0x009D9C9E, 0x00989799, 0x00949395, 0x00908F91, 0x008C8B8D, 0x00888789, 0x00858486, 0x007D7C7E, 0x007E7D7F, 0x007E7D7F, 0x007A797B, 0x00737274, 0x006E6D6F, 0x006D6C6E, 0x006E6D6F, 0x00646464, 0x00666666, 0x00636363, 
        0x00AAAAAA, 0x00F9F9F9, 0x00FBFBFB, 0x00FFFFFF, 0x00F9F9F9, 0x00FCFCFC, 0x00F5F5F5, 0x00F3F3F3, 0x00F4F4F4, 0x00E9E9E9, 0x00D4D4D4, 0x5ACBCBCB, 0xD4CFCFCF, 0xFFDBDBDB, 0xFFE2E2E2, 0xFFEAEAEA, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 
        0xFFF6F6F6, 0xFFF4F4F4, 0xFFF0F0F0, 0xFFE9E9E9, 0xFFE2E2E2, 0xFFD8D8D8, 0xFFD2D2D2, 0xDFC5C5C5, 0x68B1B1B1, 0x00A1A1A1, 0x009C9C9C, 0x009A9A9A, 0x00919191, 0x008D8D8D, 0x008E8E8E, 0x00898989, 0x007F7F7F, 0x007E7E7E, 0x008F8F8F, 0x00AAAAAA, 
        0x00BEBEBE, 0x00C8C8C8, 0x00C5C5C5, 0x00CCCCCC, 0x00D7D7D7, 0x00D8D8D8, 0x00D5D5D5, 0x00DDDDDD, 0x00EBEBEB, 0x00E7E7E7, 0x00ECECEC, 0x00F2F2F2, 0x00F6F6F6, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00F9F9F9, 
        0x00F5F5F5, 0x00F1F1F1, 0x00EDEDED, 0x00E8E8E8, 0x00E5E5E5, 0x00E1E1E1, 0x00DDDDDD, 0x00D8D8D8, 0x00D5D5D5, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C5C5C5, 0x00C0C0C0, 0x00BDBDBD, 0x00B9B9B9, 0x00B5B5B5, 0x00B1B1B1, 0x00ADADAD, 0x00A9A9A9, 
        0x00A6A6A6, 0x00A1A0A2, 0x009E9D9F, 0x0099989A, 0x00959496, 0x00929193, 0x008E8D8F, 0x008A898B, 0x00878688, 0x00858486, 0x00807F81, 0x007A797B, 0x0079787A, 0x00787779, 0x00747375, 0x006C6B6D, 0x00666567, 0x006A6A6A, 0x00838383, 0x00CECECE, 
        0x00E3E3E3, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFDFD, 0x00FCFCFC, 0x00F8F8F8, 0x00ECECEC, 0x00D8D8D8, 0x68CACACA, 0xDFCFCFCF, 0xFFDCDCDC, 0xFFE3E3E3, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE5E5E5, 0xFFDADADA, 0xFFD3D3D3, 0xF0CACACA, 0x7CB8B8B8, 0x08A5A5A5, 0x009C9C9C, 0x00989898, 0x00979797, 0x008F8F8F, 0x008B8B8B, 0x008A8A8A, 0x00828282, 0x007D7D7D, 0x00878787, 
        0x00989898, 0x00C0C0C0, 0x00C7C7C7, 0x00CFCFCF, 0x00D3D3D3, 0x00D9D9D9, 0x00DFDFDF, 0x00E2E2E2, 0x00E2E2E2, 0x00E9E9E9, 0x00EEEEEE, 0x00F3F3F3, 0x00F8F8F8, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 0x00FCFCFC, 0x00F7F7F7, 
        0x00F4F4F4, 0x00F0F0F0, 0x00ECECEC, 0x00E7E7E7, 0x00E4E4E4, 0x00E1E1E1, 0x00DDDDDD, 0x00D8D8D8, 0x00D4D4D4, 0x00D1D1D1, 0x00CDCDCD, 0x00C9C9C9, 0x00C5C5C5, 0x00C1C1C1, 0x00BEBEBE, 0x00BABABA, 0x00B6B6B6, 0x00B2B2B2, 0x00AEAEAE, 0x00AAAAAA, 
        0x00A7A7A7, 0x00A2A1A3, 0x009F9EA0, 0x009A999B, 0x00969597, 0x00939294, 0x008F8E90, 0x008B8A8C, 0x00888789, 0x00878688, 0x00818082, 0x007B7A7C, 0x00777678, 0x00747375, 0x00737274, 0x00767577, 0x007A797B, 0x009D9D9D, 0x00D0D0D0, 0x00DDDDDD, 
        0x00E9E9E9, 0x00EFEFEF, 0x00F3F3F3, 0x00F5F5F5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F0F0F0, 0x08D5D5D5, 0x7CC8C8C8, 0xF0D2D2D2, 0xFFDEDEDE, 0xFFE0E0E0, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFF0F0F0, 0xFFECECEC, 0xFFE4E4E4, 0xFFDEDEDE, 0xFFD7D7D7, 0xFFCACACA, 0x96BBBBBB, 0x26ABABAB, 0x009C9C9C, 0x00999999, 0x00939393, 0x008E8E8E, 0x008E8E8E, 0x008A8A8A, 0x00818181, 0x007B7B7B, 
        0x007B7B7B, 0x00828282, 0x00A9A9A9, 0x00CDCDCD, 0x00D7D7D7, 0x00D8D8D8, 0x00DFDFDF, 0x00E5E5E5, 0x00E4E4E4, 0x00ECECEC, 0x00F0F0F0, 0x00F5F5F5, 0x00F9F9F9, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FBFBFB, 0x00F6F6F6, 
        0x00F2F2F2, 0x00EFEFEF, 0x00ECECEC, 0x00E7E7E7, 0x00E3E3E3, 0x00E0E0E0, 0x00DDDDDD, 0x00D8D8D8, 0x00D4D4D4, 0x00D1D1D1, 0x00CECECE, 0x00C9C9C9, 0x00C6C6C6, 0x00C1C1C1, 0x00BEBEBE, 0x00BABABA, 0x00B6B6B6, 0x00B3B3B3, 0x00AFAFAF, 0x00ABABAB, 
        0x00A8A8A8, 0x00A3A2A4, 0x00A09FA1, 0x009C9B9D, 0x00989799, 0x00949395, 0x00908F91, 0x008C8B8D, 0x008A898B, 0x00818082, 0x00848385, 0x00848385, 0x007D7C7E, 0x00767577, 0x007C7B7D, 0x00949395, 0x00ACABAD, 0x00CACACA, 0x00CECECE, 0x00D7D7D7, 
        0x00DDDDDD, 0x00E4E4E4, 0x00F0F0F0, 0x00FCFCFC, 0x00F1F1F1, 0x00FEFEFE, 0x00E9E9E9, 0x26D2D2D2, 0x96CACACA, 0xFFD1D1D1, 0xFFDDDDDD, 0xFFE5E5E5, 0xFFE8E8E8, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF4F4F4, 0xFFEFEFEF, 0xFFEEEEEE, 0xFFE9E9E9, 0xFFDEDEDE, 0xFFD5D5D5, 0xFFD1D1D1, 0xB6C2C2C2, 0x49ADADAD, 0x009E9E9E, 0x009C9C9C, 0x00969696, 0x008D8D8D, 0x008A8A8A, 0x00898989, 0x00848484, 
        0x007E7E7E, 0x007A7A7A, 0x00747474, 0x00858585, 0x00B0B0B0, 0x00D4D4D4, 0x00E0E0E0, 0x00E5E5E5, 0x00EDEDED, 0x00EEEEEE, 0x00F2F2F2, 0x00F6F6F6, 0x00FAFAFA, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FAFAFA, 0x00F5F5F5, 
        0x00F1F1F1, 0x00EFEFEF, 0x00EBEBEB, 0x00E6E6E6, 0x00E3E3E3, 0x00E0E0E0, 0x00DCDCDC, 0x00D8D8D8, 0x00D4D4D4, 0x00D1D1D1, 0x00CECECE, 0x00C9C9C9, 0x00C6C6C6, 0x00C2C2C2, 0x00BFBFBF, 0x00BBBBBB, 0x00B7B7B7, 0x00B3B3B3, 0x00B0B0B0, 0x00ABABAB, 
        0x00A8A8A8, 0x00A5A4A6, 0x00A2A1A3, 0x009D9C9E, 0x0099989A, 0x00969597, 0x00929193, 0x008E8D8F, 0x008B8A8C, 0x008A898B, 0x00838284, 0x007E7D7F, 0x00828183, 0x008B8A8C, 0x0099989A, 0x00ABAAAC, 0x00BAB9BB, 0x00BDBDBD, 0x00C2C2C2, 0x00CBCBCB, 
        0x00D8D8D8, 0x00DBDBDB, 0x00E8E8E8, 0x00EAEAEA, 0x00FFFFFF, 0x00E5E5E5, 0x49CFCFCF, 0xB6C7C7C7, 0xFFD5D5D5, 0xFFE3E3E3, 0xFFE5E5E5, 0xFFE9E9E9, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF0F0F0, 0xFFEDEDED, 0xFFEAEAEA, 0xFFE0E0E0, 0xFFD7D7D7, 0xFFD0D0D0, 0xDCCACACA, 0x72B0B0B0, 0x08A2A2A2, 0x00969696, 0x00959595, 0x00929292, 0x008A8A8A, 0x00868686, 
        0x00888888, 0x007E7E7E, 0x007E7E7E, 0x00747474, 0x006C6C6C, 0x007E7E7E, 0x00ABABAB, 0x00D7D7D7, 0x00ECECEC, 0x00F0F0F0, 0x00F3F3F3, 0x00F7F7F7, 0x00FAFAFA, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FAFAFA, 0x00F5F5F5, 
        0x00F1F1F1, 0x00EEEEEE, 0x00EBEBEB, 0x00E6E6E6, 0x00E2E2E2, 0x00E0E0E0, 0x00DCDCDC, 0x00D8D8D8, 0x00D4D4D4, 0x00D1D1D1, 0x00CECECE, 0x00C9C9C9, 0x00C6C6C6, 0x00C2C2C2, 0x00BFBFBF, 0x00BBBBBB, 0x00B7B7B7, 0x00B4B4B4, 0x00B0B0B0, 0x00ACACAC, 
        0x00A9A9A9, 0x00A6A5A7, 0x00A3A2A4, 0x009E9D9F, 0x009A999B, 0x00979698, 0x00939294, 0x008F8E90, 0x008D8C8E, 0x008A898B, 0x00848385, 0x00838284, 0x0089888A, 0x00929193, 0x009B9A9C, 0x00A5A4A6, 0x00AEADAF, 0x00B6B6B6, 0x00BCBCBC, 0x00C7C7C7, 
        0x00CACACA, 0x00D4D4D4, 0x00DDDDDD, 0x00E2E2E2, 0x08C9C9C9, 0x72C6C6C6, 0xDCCFCFCF, 0xFFDADADA, 0xFFE2E2E2, 0xFFE8E8E8, 0xFFEDEDED, 0xFFF2F2F2, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF2F2F2, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFDBDBDB, 0xFFD6D6D6, 0xFFCFCFCF, 0xA1BFBFBF, 0x3BAAAAAA, 0x00999999, 0x00939393, 0x00919191, 0x008D8D8D, 
        0x00878787, 0x00868686, 0x00838383, 0x00787878, 0x00767676, 0x00777777, 0x006A6A6A, 0x00717171, 0x00909090, 0x00CFCED0, 0x00E7E6E8, 0x00FEFDFF, 0x00FFFEFF, 0x00FEFDFF, 0x00FDFCFE, 0x00FFFEFF, 0x00FFFEFF, 0x00FBFAFC, 0x00F8F7F9, 0x00F4F3F5, 
        0x00F1F0F2, 0x00EFEEF0, 0x00ECEBED, 0x00E8E7E9, 0x00E5E4E6, 0x00E2E2E2, 0x00DEDEDE, 0x00D9D9D9, 0x00D5D5D5, 0x00D1D1D1, 0x00CECECE, 0x00CBCBCB, 0x00C9C9C9, 0x00C3C3C3, 0x00C0C0C0, 0x00BCBCBC, 0x00B8B8B8, 0x00B5B5B5, 0x00B2B2B2, 0x00ADADAD, 
        0x00AAAAAA, 0x00A5A5A5, 0x00A4A4A4, 0x00A0A0A0, 0x009B9B9B, 0x00999999, 0x00979797, 0x008D8D8D, 0x00828282, 0x00737373, 0x00737373, 0x00787878, 0x00858585, 0x00909090, 0x00939393, 0x00999999, 0x00A4A4A4, 0x00AEAEAE, 0x00B4B4B4, 0x00BCBCBC, 
        0x00C6C6C6, 0x00CDCDCD, 0x00CACACA, 0x3BC6C6C6, 0xA1CACACA, 0xFFD6D6D6, 0xFFDBDBDB, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 
        0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFEFEFEF, 0xFFEAEAEA, 0xFFE3E3E3, 0xFFDEDEDE, 0xFFD4D4D4, 0xFFD1D1D1, 0xD6C7C7C7, 0x73B6B6B6, 0x12A3A3A3, 0x00969696, 0x008E8E8E, 
        0x008B8B8B, 0x00808080, 0x00858585, 0x007F7F7F, 0x00797979, 0x00797979, 0x00727272, 0x006B6B6B, 0x00707070, 0x00626163, 0x00717072, 0x009B9A9C, 0x00D4D3D5, 0x00FCFBFD, 0x00FFFEFF, 0x00FDFCFE, 0x00F9F8FA, 0x00FDFCFE, 0x00FBFAFC, 0x00F8F7F9, 
        0x00F3F2F4, 0x00ECEBED, 0x00E7E6E8, 0x00E4E3E5, 0x00E3E2E4, 0x00DCDCDC, 0x00DADADA, 0x00D7D7D7, 0x00D4D4D4, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C5C5C5, 0x00C5C5C5, 0x00C0C0C0, 0x00BABABA, 0x00B6B6B6, 0x00B5B5B5, 0x00B2B2B2, 0x00AEAEAE, 
        0x00AAAAAA, 0x00A3A3A3, 0x00A8A8A8, 0x00A6A6A6, 0x00979797, 0x007D7D7D, 0x00656565, 0x00595959, 0x00575757, 0x00606060, 0x006C6C6C, 0x00747474, 0x00797979, 0x00818181, 0x008C8C8C, 0x00979797, 0x00A0A0A0, 0x00A4A4A4, 0x00ACACAC, 0x00B3B3B3, 
        0x00BBBBBB, 0x12C4C4C4, 0x73CACACA, 0xD6D1D1D1, 0xFFDADADA, 0xFFDEDEDE, 0xFFE3E3E3, 0xFFEAEAEA, 0xFFEFEFEF, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFEDEDED, 0xFFE9E9E9, 0xFFE2E2E2, 0xFFDFDFDF, 0xFFD7D7D7, 0xFFCCCCCC, 0xB2BEBEBE, 0x54AFAFAF, 0x009E9E9E, 
        0x00929292, 0x008C8C8C, 0x008C8C8C, 0x00858585, 0x007D7D7D, 0x007B7B7B, 0x007A7A7A, 0x00757575, 0x006E6E6E, 0x006C6B6D, 0x00686769, 0x00626163, 0x00605F61, 0x00676668, 0x00848385, 0x00B5B4B6, 0x00DDDCDE, 0x00F4F3F5, 0x00F5F4F6, 0x00F5F4F6, 
        0x00F0EFF1, 0x00EAE9EB, 0x00E6E5E7, 0x00E6E5E7, 0x00E7E6E8, 0x00E2E2E2, 0x00DEDEDE, 0x00DADADA, 0x00D6D6D6, 0x00D3D3D3, 0x00D0D0D0, 0x00CDCDCD, 0x00CBCBCB, 0x00C3C3C3, 0x00BFBFBF, 0x00BCBCBC, 0x00BABABA, 0x00B9B9B9, 0x00B3B3B3, 0x00AAAAAA, 
        0x00A2A2A2, 0x008B8B8B, 0x00696969, 0x00454545, 0x00363636, 0x003A3A3A, 0x00434343, 0x004B4B4B, 0x00515151, 0x00585858, 0x00626262, 0x00696969, 0x006F6F6F, 0x007A7A7A, 0x00858585, 0x008B8B8B, 0x008F8F8F, 0x009C9C9C, 0x00ABABAB, 0x00B8B8B8, 
        0x54C1C1C1, 0xB2CBCBCB, 0xFFD2D2D2, 0xFFDBDBDB, 0xFFE3E3E3, 0xFFE9E9E9, 0xFFEDEDED, 0xFFF1F1F1, 0xFFF5F5F5, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF3F3F3, 0xFFF0F0F0, 0xFFEDEDED, 0xFFE5E5E5, 0xFFDBDBDB, 0xFFD6D6D6, 0xFFD5D5D5, 0xF6CDCDCD, 0x9CBBBBBB, 
        0x42ABABAB, 0x00979797, 0x008C8C8C, 0x00888888, 0x00878787, 0x007E7E7E, 0x00777777, 0x00777777, 0x00767676, 0x006D6C6E, 0x0069686A, 0x00636264, 0x005E5D5F, 0x005C5B5D, 0x005C5B5D, 0x0059585A, 0x00545355, 0x00575658, 0x006A696B, 0x00888789, 
        0x00A6A5A7, 0x00BDBCBE, 0x00CECDCF, 0x00D8D7D9, 0x00DEDDDF, 0x00DDDDDD, 0x00DBDBDB, 0x00D8D8D8, 0x00D5D5D5, 0x00D1D1D1, 0x00CDCDCD, 0x00C8C8C8, 0x00C4C4C4, 0x00C0C0C0, 0x00B2B2B2, 0x009C9C9C, 0x00808080, 0x00616161, 0x00414141, 0x00242424, 
        0x00131313, 0x000E0E0E, 0x00161616, 0x00222222, 0x002C2C2C, 0x002F2F2F, 0x00333333, 0x003F3F3F, 0x004B4B4B, 0x00545454, 0x005A5A5A, 0x00636363, 0x006C6C6C, 0x00737373, 0x00767676, 0x00828282, 0x00929292, 0x00ABABAB, 0x42BCBCBC, 0x9CCACACA, 
        0xF6D2D2D2, 0xFFDBDBDB, 0xFFE0E0E0, 0xFFE4E4E4, 0xFFE8E8E8, 0xFFF0F0F0, 0xFFF3F3F3, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFEFEFEF, 0xFFEDEDED, 0xFFE8E8E8, 0xFFE3E3E3, 0xFFDFDFDF, 0xFFDBDBDB, 0xFFD3D3D3, 
        0xEACCCCCC, 0x94C2C2C2, 0x40A4A4A4, 0x00909090, 0x008D8D8D, 0x00868686, 0x00808080, 0x007B7B7B, 0x00737373, 0x00767577, 0x00727173, 0x006E6D6F, 0x006B6A6C, 0x00636264, 0x00585759, 0x00555456, 0x00585759, 0x00525153, 0x004E4D4F, 0x00484749, 
        0x00424143, 0x003D3C3E, 0x003A393B, 0x003A393B, 0x003A393B, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00424242, 0x00393939, 0x002F2F2F, 0x00282828, 0x00121212, 0x000E0E0E, 0x00070707, 0x00020202, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x000B0B0B, 0x00111111, 0x00191919, 0x00212121, 0x00292929, 0x00313131, 0x00393939, 0x003E3E3E, 0x004B4B4B, 0x00515151, 0x00555555, 0x005C5C5C, 0x00696969, 0x007E7E7E, 0x00A0A0A0, 0x40C0C0C0, 0x94C8C8C8, 0xEAD3D3D3, 0xFFD9D9D9, 
        0xFFDDDDDD, 0xFFE4E4E4, 0xFFEBEBEB, 0xFFEEEEEE, 0xFFF2F2F2, 0xFFF5F5F5, 0xFFF6F6F6, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF2F2F2, 0xFFEDEDED, 0xFFE7E7E7, 0xFFE2E2E2, 0xFFDEDEDE, 
        0xFFDADADA, 0xFFD3D3D3, 0xECCDCDCD, 0x9CC5C5C5, 0x4DB1B1B1, 0x00949494, 0x00858585, 0x00838383, 0x007F7F7F, 0x00767577, 0x00737274, 0x006E6D6F, 0x0069686A, 0x00676668, 0x00656466, 0x00616062, 0x005D5C5E, 0x00555456, 0x00525153, 0x004F4E50, 
        0x004B4A4C, 0x00484749, 0x00434244, 0x003C3B3D, 0x00383739, 0x00323232, 0x00303030, 0x002E2E2E, 0x002A2A2A, 0x00262626, 0x00202020, 0x00191919, 0x00151515, 0x00141414, 0x00111111, 0x000B0B0B, 0x00050505, 0x00000000, 0x00000000, 0x00000000, 
        0x00020202, 0x00000000, 0x00060606, 0x000E0E0E, 0x00151515, 0x001D1D1D, 0x00282828, 0x00313131, 0x00373737, 0x003E3E3E, 0x00484848, 0x00565656, 0x00727272, 0x009E9E9E, 0x4DC2C2C2, 0x9CCECECE, 0xECCECECE, 0xFFD9D9D9, 0xFFDFDFDF, 0xFFE2E2E2, 
        0xFFE5E5E5, 0xFFEDEDED, 0xFFF2F2F2, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFEFEFEF, 0xFFEDEDED, 0xFFE6E6E6, 
        0xFFE0E0E0, 0xFFDEDEDE, 0xFFD8D8D8, 0xFFD3D3D3, 0xFFCDCDCD, 0xB4C6C6C6, 0x6BBABABA, 0x23A1A1A1, 0x00848484, 0x00787779, 0x0079787A, 0x00757476, 0x006D6C6E, 0x006B6A6C, 0x006B6A6C, 0x00646365, 0x005A595B, 0x005B5A5C, 0x00575658, 0x00504F51, 
        0x004B4A4C, 0x00484749, 0x00454446, 0x00424143, 0x003F3E40, 0x003D3D3D, 0x00393939, 0x00323232, 0x002C2C2C, 0x00272727, 0x00242424, 0x00222222, 0x00202020, 0x00151515, 0x00131313, 0x00101010, 0x000C0C0C, 0x00090909, 0x00050505, 0x00010101, 
        0x00000000, 0x00000000, 0x00020202, 0x000C0C0C, 0x00151515, 0x001A1A1A, 0x001F1F1F, 0x00292929, 0x00323232, 0x00484848, 0x007C7C7C, 0x23B1B1B1, 0x6BC9C9C9, 0xB4CECECE, 0xFFD1D1D1, 0xFFD9D9D9, 0xFFE3E3E3, 0xFFE1E1E1, 0xFFE6E6E6, 0xFFEBEBEB, 
        0xFFF0F0F0, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFF4F4F4, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF4F4F4, 0xFFF3F3F3, 0xFFF0F0F0, 
        0xFFEDEDED, 0xFFE3E3E3, 0xFFE3E3E3, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFD6D6D6, 0xFFD1D1D1, 0xDCCCCCCC, 0x99C6C6C6, 0x57B7B6B8, 0x179A999B, 0x007F7E80, 0x00757476, 0x00717072, 0x0069686A, 0x00646365, 0x00666567, 0x005F5E60, 0x005C5B5D, 0x00585759, 
        0x00535254, 0x004E4D4F, 0x0049484A, 0x00444345, 0x00414042, 0x003A3A3A, 0x00383838, 0x00353535, 0x00313131, 0x002D2D2D, 0x00282828, 0x00222222, 0x001E1E1E, 0x001D1D1D, 0x00191919, 0x00131313, 0x000E0E0E, 0x000B0B0B, 0x00080808, 0x00030303, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030303, 0x000E0E0E, 0x002E2E2E, 0x00696969, 0x179C9C9C, 0x57C7C7C7, 0x99CBCBCB, 0xDCCFCFCF, 0xFFD5D5D5, 0xFFDCDCDC, 0xFFDEDEDE, 0xFFE1E1E1, 0xFFE7E7E7, 0xFFEDEDED, 0xFFEFEFEF, 0xFFF1F1F1, 
        0xFFF5F5F5, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF6F6F6, 0xFFF4F4F4, 
        0xFFF3F3F3, 0xFFF0F0F0, 0xFFEDEDED, 0xFFE9E9E9, 0xFFE5E5E5, 0xFFE1E1E1, 0xFFDDDDDD, 0xFFD8D8D8, 0xFFD4D4D4, 0xFFD2D2D2, 0xD8CDCDCD, 0x9DC4C4C4, 0x63B6B6B6, 0x2BA3A3A3, 0x008B8B8B, 0x00757575, 0x00676767, 0x00636363, 0x00606060, 0x005B5B5B, 
        0x00565656, 0x00515151, 0x004D4D4D, 0x00494949, 0x00464646, 0x00414141, 0x003E3E3E, 0x003A3A3A, 0x00363636, 0x00323232, 0x002D2D2D, 0x00272727, 0x00232323, 0x00202020, 0x001A1A1A, 0x00151515, 0x00141414, 0x00111111, 0x000B0B0B, 0x00050505, 
        0x00030303, 0x00000000, 0x00171717, 0x00404040, 0x00757575, 0x2BA9A9A9, 0x63C6C6C6, 0x9DCDCDCD, 0xD8CDCDCD, 0xFFD6D6D6, 0xFFD9D9D9, 0xFFDEDEDE, 0xFFE2E2E2, 0xFFE5E5E5, 0xFFE9E9E9, 0xFFEDEDED, 0xFFF1F1F1, 0xFFF4F4F4, 0xFFF5F5F5, 0xFFF7F7F7, 
        0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 
        0xFFF6F6F6, 0xFFF7F7F7, 0xFFF4F4F4, 0xFFF0F0F0, 0xFFEDEDED, 0xFFEBEBEB, 0xFFE7E7E7, 0xFFE3E3E3, 0xFFE0E0E0, 0xFFDDDDDD, 0xFFDBDBDB, 0xFFD8D8D8, 0xFFD4D4D4, 0xF5D0D0D0, 0xC2CACACA, 0x92C3C3C3, 0x64BFBFBF, 0x38A5A5A5, 0x0E989898, 0x00848484, 
        0x00707070, 0x00616161, 0x00565656, 0x004E4E4E, 0x004A4A4A, 0x00494949, 0x00444444, 0x003D3D3D, 0x00373737, 0x00343434, 0x00313131, 0x002E2E2E, 0x002C2C2C, 0x00222222, 0x00202020, 0x00212121, 0x00272727, 0x00373737, 0x00525252, 0x00737373, 
        0x0E8C8C8C, 0x38B5B5B5, 0x64C1C1C1, 0x92CBCBCB, 0xC2D0D0D0, 0xF5D4D4D4, 0xFFD5D5D5, 0xFFD8D8D8, 0xFFE0E0E0, 0xFFE0E0E0, 0xFFE3E3E3, 0xFFE7E7E7, 0xFFEAEAEA, 0xFFEDEDED, 0xFFF0F0F0, 0xFFF4F4F4, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF9F9F9, 
        0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF9F9F9, 
        0xFFF9F9F9, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF5F5F5, 0xFFF3F3F3, 0xFFF2F2F2, 0xFFEFEFEF, 0xFFECECEC, 0xFFEAEAEA, 0xFFE5E5E5, 0xFFE2E2E2, 0xFFDEDEDE, 0xFFDBDBDB, 0xFFDADADA, 0xFFD8D8D8, 0xFFD6D6D6, 0xFFD5D5D5, 0xFFD0D0D0, 0xE6CECECE, 0xC2CBCBCB, 
        0xA1CACACA, 0x83C8C8C8, 0x67C2C2C2, 0x4FB9B9B9, 0x39B1B1B1, 0x27A3A3A3, 0x189F9F9F, 0x0C999999, 0x04969696, 0x00959595, 0x04959595, 0x0C969696, 0x18969696, 0x27A5A5A5, 0x39B1B1B1, 0x4FC2C2C2, 0x67CCCCCC, 0x83CDCDCD, 0xA1CBCBCB, 0xC2CDCDCD, 
        0xE6D1D1D1, 0xFFD5D5D5, 0xFFDADADA, 0xFFDBDBDB, 0xFFDADADA, 0xFFDCDCDC, 0xFFDEDEDE, 0xFFE2E2E2, 0xFFEAEAEA, 0xFFE9E9E9, 0xFFEBEBEB, 0xFFEFEFEF, 0xFFF1F1F1, 0xFFF3F3F3, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_gray_trans_140x140 = {
  140, // xSize
  140, // ySize
  560, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_gray_trans_140x140,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       Knob 70x70
*/
static GUI_CONST_STORAGE unsigned long _acknob_gray_trans_70x70[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF5F5F5, 
        0xFFF1F1F1, 0xFFEBEBEB, 0xFFE5E5E5, 0xFFDDDDDD, 0xFFD5D5D5, 0xFFCBCBCB, 0xEDBBBABC, 0xBDB1B0B2, 0x8BAFAEB2, 0x59B0AFB3, 0x3BB4B3B7, 0x22B9B7BC, 0x10C1C0C4, 0x04C6C5C9, 0x01C7C6CA, 0x09C4C3C7, 0x18C2C1C5, 0x2EC0BFC3, 0x49BEBDC1, 0x6EBDBCBF, 
        0xA7BEBEBF, 0xD5C3C3C3, 0xFDCBCBCB, 0xFFD4D4D4, 0xFFDDDDDD, 0xFFE4E4E4, 0xFFEBEBEB, 0xFFF2F2F2, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF5F5F5, 0xFFF0F0F0, 0xFFE9E9E9, 
        0xFFE0E0E0, 0xFFD7D7D7, 0xFFC9C9C9, 0xDDACACAC, 0x91959496, 0x408B8A8C, 0x0B919092, 0x00969597, 0x009F9EA2, 0x00A5A4A8, 0x00ABA9AF, 0x00B2B1B6, 0x00BAB9BD, 0x00C0BFC3, 0x00C7C6CA, 0x00C7C6CA, 0x00C4C3C7, 0x00C1C0C4, 0x00BFBEC2, 0x00BBBABE, 
        0x00B9B8BA, 0x00B6B5B7, 0x24B0AFB1, 0x63B5B4B6, 0xBCBDBCBE, 0xF6CBCACC, 0xFFD7D6D8, 0xFFE2E1E3, 0xFFE9E9E9, 0xFFF1F1F1, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF3F3F3, 0xFFEBEBEB, 0xFFE1E1E1, 0xFFD4D4D4, 
        0xFABCBCBC, 0xBA8C8C8C, 0x48717171, 0x09737373, 0x0079787A, 0x00818082, 0x00888789, 0x008F8E90, 0x00959498, 0x009E9DA1, 0x00A6A5A9, 0x00ACABAE, 0x00B4B3B5, 0x00BBBABC, 0x00C2C1C3, 0x00C9C8CA, 0x00C8C7C9, 0x00C4C3C5, 0x00C1C0C2, 0x00BFBEC0, 
        0x00BCBBBD, 0x00B9B8BA, 0x00B5B4B6, 0x00B2B1B3, 0x00ADACAE, 0x24ACABAD, 0x80B4B3B5, 0xE2C4C3C5, 0xFFD4D4D4, 0xFFE0E0E0, 0xFFEAEAEA, 0xFFF2F2F2, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF5F5F5, 0xFFEEEEEE, 0xFFE3E3E3, 0xFFD7D7D7, 0xFDC1C1C1, 0xB28A8A8A, 
        0x35626262, 0x005E5E5E, 0x00646464, 0x006B6B6B, 0x00747375, 0x007A797B, 0x00858486, 0x00929193, 0x00A1A0A2, 0x00ACABAD, 0x00B8B7B9, 0x00C1C0C2, 0x00C9C9C9, 0x00D0D0D0, 0x00D6D6D6, 0x00DFDFDF, 0x00E4E4E4, 0x00E8E8E8, 0x00E6E6E6, 0x00E0E0E0, 
        0x00D4D3D5, 0x00C3C2C4, 0x00BAB9BB, 0x00B5B4B6, 0x00B0AFB1, 0x00B0AFB1, 0x00AAA9AB, 0x10A9A8AA, 0x70B1B1B1, 0xE4C5C5C5, 0xFFD6D6D6, 0xFFE4E4E4, 0xFFEEEEEE, 0xFFF5F5F5, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF3F3F3, 0xFFEAEAEA, 0xFFDDDDDD, 0xFFCDCDCD, 0xD2A4A4A4, 0x46777777, 0x006E6E6E, 
        0x00676767, 0x00616161, 0x005E5E5E, 0x006A696A, 0x007D7C7F, 0x008F8E92, 0x009D9C9E, 0x00A6A5A7, 0x00ACACAC, 0x00B3B3B3, 0x00B9B9B9, 0x00C1C1C0, 0x00C9C9C9, 0x00CFCFCF, 0x00D6D6D6, 0x00DDDDDD, 0x00E5E5E5, 0x00EBEBEB, 0x00F2F2F2, 0x00FBFBFB, 
        0x00FFFEFF, 0x00FEFDFE, 0x00EFEEF0, 0x00D2D1D3, 0x00BBBABC, 0x00B0AFB1, 0x00AFAEB0, 0x00ACABAD, 0x00A8A8A8, 0x15A6A6A6, 0x8EB5B5B5, 0xF5CDCDCD, 0xFFDDDDDD, 0xFFEAEAEA, 0xFFF3F3F3, 0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF7F7F7, 0xFFF1F1F1, 0xFFE6E6E6, 0xFFD8D8D8, 0xF6C0C0C0, 0x8799989A, 0x0F858486, 0x007E7D7F, 0x00757476, 
        0x006E6D6F, 0x0069686A, 0x00737274, 0x00858486, 0x008D8C8E, 0x00959496, 0x009C9B9D, 0x00A4A3A5, 0x00AAAAAA, 0x00B2B2B2, 0x00B9B9B9, 0x00C1C1C1, 0x00C8C8C8, 0x00D0D0D0, 0x00D6D6D6, 0x00DEDEDE, 0x00E5E5E5, 0x00EDEDED, 0x00F4F4F4, 0x00FDFDFD, 
        0x00FFFFFF, 0x00FEFEFE, 0x00F9F9F9, 0x00F1F1F1, 0x00E7E7E7, 0x00CECECE, 0x00B9B9B9, 0x00ADADAD, 0x00ABAAAC, 0x00AAA9AB, 0x00A4A3A5, 0x39A9A8AA, 0xD3C2C2C2, 0xFFD8D8D8, 0xFFE7E7E7, 0xFFF2F3F1, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF7F7F7, 0xFFF0F0F0, 0xFFE4E4E4, 0xFFD4D4D4, 0xE5B9B9B9, 0x499F9F9F, 0x00959496, 0x008D8C8E, 0x00878688, 0x007C7B7D, 
        0x00727173, 0x00777678, 0x007E7D7F, 0x00848385, 0x008B8A8C, 0x00929193, 0x009A999B, 0x00A1A0A2, 0x00A9A9A9, 0x00B1B1B1, 0x00B8B8B8, 0x00C0C0C0, 0x00C7C7C7, 0x00CFCFCF, 0x00D6D6D6, 0x00DFDFDF, 0x00E6E6E6, 0x00EFEFEF, 0x00F6F6F6, 0x00FEFEFE, 
        0x00FFFFFF, 0x00FEFEFE, 0x00F7F7F7, 0x00EDEDED, 0x00E3E3E3, 0x00DBDBDB, 0x00D1D1D1, 0x00C3C3C3, 0x00B0AFB1, 0x00ABAAAC, 0x00A8A7A9, 0x00A4A3A5, 0x12A3A3A3, 0x9CB9B9B9, 0xFFD4D4D4, 0xFFE3E3E3, 0xFFF0F0F0, 0xFFF8F8F8, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFF7F7F7, 0xFFF0F0F0, 0xFFE3E3E3, 0xFFD0D0D0, 0xCEBDBDBD, 0x21AAAAAA, 0x00A4A4A4, 0x009D9C9E, 0x00949395, 0x00787779, 0x00686769, 
        0x006E6D6F, 0x00747375, 0x007B7A7C, 0x00828183, 0x00888789, 0x00908F91, 0x00989799, 0x00A09FA1, 0x00A7A7A7, 0x00AFAFAF, 0x00B7B7B7, 0x00BEBEBE, 0x00C7C7C7, 0x00CFCFCF, 0x00D7D7D7, 0x00DFDFDF, 0x00E7E7E7, 0x00EFEFEF, 0x00F8F8F8, 0x00FEFEFE, 
        0x00FFFFFF, 0x00FCFCFC, 0x00F3F3F3, 0x00E9E9E9, 0x00E1E1E1, 0x00D7D7D7, 0x00CFCFCF, 0x00C6C6C6, 0x00BDBCBE, 0x00B1B0B2, 0x00ACABAD, 0x00A8A8A8, 0x00A6A6A6, 0x02A2A2A2, 0x75B2B2B2, 0xF7D0D0D0, 0xFFE2E2E2, 0xFFEFEFEF, 0xFFF7F7F7, 0xFFF9F9F9, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF0F0F0, 0xFFE2E2E2, 0xFFD1D1D1, 0xBDC3C3C3, 0x17BDBDBD, 0x00B3B3B3, 0x00ACACAC, 0x009D9C9E, 0x006B6A6C, 0x005C5B5D, 0x00656466, 
        0x0069686A, 0x00717072, 0x00767577, 0x007C7B7D, 0x00858486, 0x008D8C8E, 0x00959496, 0x009D9C9E, 0x00A6A6A6, 0x00AEAEAE, 0x00B6B6B6, 0x00BEBEBE, 0x00C6C6C6, 0x00CFCFCF, 0x00D7D7D7, 0x00E0E0E0, 0x00E9E9E9, 0x00F1F1F1, 0x00FAFAFA, 0x00FFFFFF, 
        0x00FFFFFF, 0x00F8F8F8, 0x00EEEEEE, 0x00E4E4E4, 0x00DBDBDB, 0x00D1D1D1, 0x00C9C9C9, 0x00C0C0C0, 0x00B8B7B9, 0x00B0AFB1, 0x00A9A9A9, 0x00ABABAB, 0x00A9A9A9, 0x00A7A7A7, 0x00A1A1A1, 0x60B0B0B0, 0xF3D0D0D0, 0xFFE3E3E3, 0xFFEFEFEF, 0xFFF7F7F7, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF1F1F1, 0xFFE4E4E4, 0xFFD0D0D0, 0xBDCDCDCD, 0x14CBCBCB, 0x00C4C4C4, 0x00BDBDBD, 0x009E9E9E, 0x005A595B, 0x00525153, 0x0059585A, 0x005F5E60, 
        0x00656466, 0x006C6B6D, 0x00737274, 0x007A797B, 0x00828183, 0x008A898B, 0x00929193, 0x009B9A9C, 0x00A4A4A4, 0x00ADADAD, 0x00B5B5B5, 0x00BEBEBE, 0x00C5C5C5, 0x00CFCFCF, 0x00D7D7D7, 0x00E0E0E0, 0x00E9E9E9, 0x00F1F1F1, 0x00FAFAFA, 0x00FFFFFF, 
        0x00FEFEFE, 0x00F5F5F5, 0x00EBEBEB, 0x00E1E1E1, 0x00D7D7D7, 0x00CDCDCD, 0x00C4C4C4, 0x00BABABA, 0x00B3B3B3, 0x00A9A9A9, 0x00A2A2A2, 0x009D9D9D, 0x00A6A6A6, 0x00A9A9A9, 0x00A7A6A8, 0x00A2A1A3, 0x5BAFAFAF, 0xF4D0D0D0, 0xFFE3E3E3, 0xFFF0F0F0, 
        0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF2F2F2, 0xFFE6E6E6, 0xFFD2D2D2, 0xCED1D1D1, 0x17DBDBDB, 0x00D3D3D3, 0x00CDCDCD, 0x00A0A0A0, 0x004A4A4A, 0x0049484A, 0x00504F51, 0x00555456, 0x005A595B, 
        0x00626163, 0x00686769, 0x006F6E70, 0x00777678, 0x007E7D7F, 0x00868587, 0x008E8D8F, 0x00979698, 0x00A1A1A1, 0x00AAAAAA, 0x00B3B3B3, 0x00BCBCBC, 0x00C5C5C5, 0x00CECECE, 0x00D7D7D7, 0x00E1E1E1, 0x00EAEAEA, 0x00F3F3F3, 0x00FCFCFC, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F2F2F2, 0x00E7E7E7, 0x00DDDDDD, 0x00D2D2D2, 0x00C8C8C8, 0x00BFBFBF, 0x00B5B5B5, 0x00ACACAC, 0x00A4A4A4, 0x009C9C9C, 0x00949494, 0x008F8F8F, 0x00A2A1A3, 0x00A9A8AA, 0x00A5A4A6, 0x00A1A1A1, 0x68B3B3B3, 0xFBD3D3D3, 0xFFE7E7E7, 
        0xFFF2F2F2, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF5F5F5, 0xFFEAEAEA, 0xFFD5D5D5, 0xE5D5D5D5, 0x21E9E9E9, 0x00E3E3E3, 0x00DBDBDB, 0x00ABABAB, 0x00414141, 0x00404040, 0x00444345, 0x0049484A, 0x00504F51, 0x00565557, 
        0x005D5C5E, 0x00646365, 0x006B6A6C, 0x00737274, 0x007A797B, 0x00838284, 0x008B8A8C, 0x00959496, 0x009E9E9E, 0x00A8A8A8, 0x00B1B1B1, 0x00BCBCBC, 0x00C4C4C4, 0x00CECECE, 0x00D7D7D7, 0x00E1E1E1, 0x00ECECEC, 0x00F6F6F6, 0x00FEFEFE, 0x00FFFFFF, 
        0x00F9F9F9, 0x00EDEDED, 0x00E3E3E3, 0x00D7D7D7, 0x00CDCDCD, 0x00C3C3C3, 0x00B9B9B9, 0x00AFAFAF, 0x00A5A5A5, 0x009D9D9D, 0x00969696, 0x008E8E8E, 0x00888789, 0x00818082, 0x009E9D9F, 0x00AAA9AB, 0x00A6A6A6, 0x00A1A1A1, 0x86B8B8B8, 0xFFD8D8D8, 
        0xFFEAEAEA, 0xFFF5F5F5, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF7F7F7, 0xFFEEEEEE, 0xFFDDDDDD, 0xF6D2D2D2, 0x49F5F5F5, 0x00F2F2F2, 0x00EAEAEA, 0x00BDBDBD, 0x00383838, 0x00343434, 0x003C3C3C, 0x003F3E40, 0x00464547, 0x004B4A4C, 0x00525153, 
        0x00585759, 0x005F5E60, 0x00666567, 0x006F6E70, 0x00767577, 0x007F7E80, 0x00878688, 0x00929193, 0x009B9B9B, 0x00A5A5A5, 0x00AFAFAF, 0x00BABABA, 0x00C3C3C3, 0x00CECECE, 0x00D8D8D8, 0x00E2E2E2, 0x00ECECEC, 0x00F7F7F7, 0x00FEFEFE, 0x00FEFEFE, 
        0x00F4F4F4, 0x00E9E9E9, 0x00DDDDDD, 0x00D2D2D2, 0x00C7C7C7, 0x00BCBCBC, 0x00B2B2B2, 0x00A8A8A8, 0x00A0A19F, 0x00979797, 0x008E8E8E, 0x00868686, 0x007F7E80, 0x0079787A, 0x00767577, 0x009E9D9F, 0x00A9A9A9, 0x00A6A6A6, 0x0AA4A4A4, 0xB7C1C1C1, 
        0xFFDDDDDD, 0xFFEEEEEE, 0xFFF7F7F7, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF4F4F4, 0xFFE3E3E3, 0xFFD0D0D0, 0x87F0F0F0, 0x00FDFDFD, 0x00FAFAFA, 0x00E0DFE1, 0x00414042, 0x002C2B2D, 0x002F2E30, 0x00353436, 0x003A393B, 0x00403F41, 0x00464547, 0x004D4C4E, 
        0x00545355, 0x005A595B, 0x00626163, 0x006A696B, 0x00727173, 0x007B7A7C, 0x00838284, 0x008D8C8E, 0x0099989A, 0x00A3A3A3, 0x00AEAEAE, 0x00B8B8B8, 0x00C2C2C2, 0x00CECECE, 0x00D8D8D8, 0x00E3E3E3, 0x00EEEEEE, 0x00F8F8F8, 0x00FFFFFF, 0x00FBFBFB, 
        0x00F0F0F0, 0x00E3E3E3, 0x00D8D8D8, 0x00CCCCCC, 0x00C2C2C2, 0x00B6B6B6, 0x00ABABAB, 0x00A1A1A1, 0x00989898, 0x008F8F8F, 0x00888888, 0x00808080, 0x00777777, 0x00727272, 0x006A6A6A, 0x006E6E6E, 0x00A5A5A5, 0x00AAAAAA, 0x00A5A5A5, 0x1FA9A9A9, 
        0xE8CCCCCC, 0xFFE4E4E4, 0xFFF1F1F1, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFF6F6F6, 0xFFECECEC, 0xFFD5D5D5, 0xD2D1D1D1, 0x0FEEEEEE, 0x00FBFBFB, 0x00FCFCFC, 0x0069686A, 0x00333234, 0x00302F31, 0x002E2D2F, 0x002F2E30, 0x00353436, 0x003B3A3C, 0x00414042, 0x00474648, 
        0x004E4D4F, 0x00555456, 0x005D5C5E, 0x00656466, 0x006D6C6E, 0x00767577, 0x007F7E80, 0x0089888A, 0x00949395, 0x00A0A0A0, 0x00ABABAB, 0x00B6B6B6, 0x00C1C1C1, 0x00CDCDCD, 0x00D8D8D8, 0x00E4E4E4, 0x00F0F0F0, 0x00FBFBFB, 0x00FFFFFF, 0x00F8F8F8, 
        0x00EBEBEB, 0x00DDDDDD, 0x00D1D1D1, 0x00C5C5C5, 0x00BABABA, 0x00AEAEAE, 0x00A4A4A4, 0x00999999, 0x00919191, 0x00888888, 0x00808080, 0x00797979, 0x00717171, 0x006B6B6B, 0x00656565, 0x005D5D5D, 0x00707070, 0x00A9A9A9, 0x00AAAAAA, 0x00A6A6A6, 
        0x61B5B5B5, 0xFFD8D8D8, 0xFFE9E9E9, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFFF0F0F0, 0xFFDFDFDF, 0xFDC9C9C9, 0x46CDCDCD, 0x00DEDEDE, 0x00EFEFEF, 0x00A9A9A9, 0x003E3D3F, 0x0039383A, 0x00363537, 0x00302F31, 0x002C2B2D, 0x002F2E30, 0x00343335, 0x003B3A3C, 0x00424143, 
        0x00484749, 0x004F4E50, 0x00575658, 0x005F5E60, 0x00686769, 0x00727173, 0x007B7A7C, 0x00858486, 0x00908F91, 0x009C9C9C, 0x00A8A8A8, 0x00B5B5B5, 0x00C0C0C0, 0x00CDCDCD, 0x00D8D8D8, 0x00E5E5E5, 0x00F1F1F1, 0x00FCFCFC, 0x00FFFFFF, 0x00F4F4F4, 
        0x00E6E6E6, 0x00D8D8D8, 0x00CBCBCB, 0x00BEBEBE, 0x00B3B3B3, 0x00A7A7A7, 0x009C9C9C, 0x00929292, 0x00888888, 0x00808080, 0x00787878, 0x00707070, 0x00686868, 0x00626262, 0x005B5B5B, 0x00585858, 0x00575757, 0x008B8B8B, 0x00ACACAC, 0x00A9A9A9, 
        0x05A8A8A8, 0xBFC4C4C4, 0xFFE2E2E2, 0xFFF0F0F0, 0xFFF9F9F9, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFEAEAEA, 0xFFD4D4D4, 0xB2B6B6B6, 0x00BEBEBE, 0x00CECECE, 0x00CDCDCD, 0x004D4D4D, 0x00424143, 0x003E3D3F, 0x0039383A, 0x00353436, 0x00323133, 0x002C2B2D, 0x002E2D2F, 0x00343335, 0x003B3A3C, 
        0x00414042, 0x00484749, 0x00504F51, 0x00585759, 0x00626163, 0x006C6B6D, 0x00757476, 0x00807F81, 0x008C8B8D, 0x00999999, 0x00A5A5A5, 0x00B2B2B2, 0x00BFBFBF, 0x00CDCDCD, 0x00D9D9D9, 0x00E6E6E6, 0x00F4F4F4, 0x00FEFEFE, 0x00FDFDFD, 0x00EEEEEE, 
        0x00DFDFDF, 0x00D0D0D0, 0x00C3C3C3, 0x00B5B5B5, 0x00AAAAAA, 0x009E9E9E, 0x00939393, 0x00898989, 0x007F7F7F, 0x00777777, 0x006F6F6F, 0x00686868, 0x00616161, 0x005A5A5A, 0x00575757, 0x00585858, 0x005B5B5B, 0x00636363, 0x00A4A4A4, 0x00ADADAD, 
        0x00A9A9A9, 0x38B3B3B3, 0xFAD5D5D5, 0xFFE9E9E9, 0xFFF6F6F6, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF0F0F0, 0xFFE2E2E2, 0xFAC0C0C0, 0x359D9D9D, 0x00ADADAD, 0x00BEBEBE, 0x007A7A7A, 0x004C4C4C, 0x00484749, 0x00454446, 0x00403F41, 0x003C3B3D, 0x00383739, 0x00333234, 0x002E2D2F, 0x002E2D2F, 0x00333234, 
        0x003B3A3C, 0x00424143, 0x0049484A, 0x00525153, 0x005C5B5D, 0x00666567, 0x00706F71, 0x007C7B7D, 0x00888789, 0x00959595, 0x00A2A2A2, 0x00B0B0B0, 0x00BEBEBE, 0x00CCCCCC, 0x00DADADA, 0x00E8E8E8, 0x00F6F6F6, 0x00FFFFFF, 0x00F8F8F8, 0x00E8E8E8, 
        0x00D8D8D8, 0x00CACACA, 0x00BABABA, 0x00ADADAD, 0x00A0A0A0, 0x00949494, 0x008A8A8A, 0x00808080, 0x00777777, 0x006F6F6F, 0x00676767, 0x00606060, 0x00585858, 0x00575757, 0x005A5A5A, 0x005E5E5E, 0x00606060, 0x00606060, 0x00808080, 0x00B0B0B0, 
        0x00ADADAD, 0x00A8A8A8, 0xB0C5C5C5, 0xFFE1E1E1, 0xFFF1F1F1, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFFD7D7D7, 0xBA9B9B9B, 0x008C8C8C, 0x009D9D9D, 0x009E9E9E, 0x00545454, 0x00535353, 0x004C4B4D, 0x004B4A4C, 0x00474648, 0x00434244, 0x003E3D3F, 0x003A393B, 0x00353436, 0x00302F31, 0x002E2D2F, 
        0x00333234, 0x003A393B, 0x00424143, 0x004B4A4C, 0x00555456, 0x005F5E60, 0x006A696B, 0x00767577, 0x00828183, 0x008F8F8F, 0x009D9D9D, 0x00ADADAD, 0x00BCBCBC, 0x00CBCBCB, 0x00DBDBDB, 0x00EAEAEA, 0x00F8F8F8, 0x00FFFFFF, 0x00F3F3F3, 0x00E2E2E2, 
        0x00D0D0D0, 0x00C2C2C2, 0x00B1B1B1, 0x00A4A4A4, 0x00969696, 0x008B8B8B, 0x00808080, 0x00767676, 0x006D6D6D, 0x00646464, 0x005C5C5C, 0x00565656, 0x00585858, 0x005C5C5C, 0x00606060, 0x00626262, 0x00656565, 0x00686868, 0x00686868, 0x00A7A7A7, 
        0x00AFAFAF, 0x00ACACAC, 0x3AB5B5B5, 0xFFD7D7D7, 0xFFEBEBEB, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFFC7C7C7, 0x48707070, 0x007B7B7B, 0x008B8B8B, 0x00717171, 0x005B5B5B, 0x00575757, 0x00545355, 0x00525153, 0x004E4D4F, 0x004A494B, 0x00464547, 0x00414042, 0x003C3B3D, 0x00363537, 0x00302F31, 
        0x002D2C2E, 0x00323133, 0x003B3A3C, 0x00434244, 0x004D4C4E, 0x00575658, 0x00636264, 0x006F6E70, 0x007C7B7D, 0x008B8B8B, 0x009A9A9A, 0x00AAAAAA, 0x00BBBBBB, 0x00CBCBCB, 0x00DCDCDC, 0x00EBEBEB, 0x00FBFBFB, 0x00FDFDFD, 0x00ECECEC, 0x00D9D9D9, 
        0x00C7C7C7, 0x00B7B7B7, 0x00A6A6A6, 0x00989898, 0x008B8B8B, 0x007F7F7F, 0x00757575, 0x006B6B6B, 0x00636363, 0x005B5B5B, 0x00575757, 0x00595959, 0x005F5F5F, 0x00616161, 0x00636363, 0x00666666, 0x00696969, 0x006B6B6B, 0x006E6E6E, 0x00888888, 
        0x00B3B3B3, 0x00AEAEAE, 0x00AEAEAE, 0xC7CBCBCB, 0xFFE4E4E4, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDCDCDC, 0xDD9B9B9B, 0x09585858, 0x006A6A6A, 0x00787878, 0x00646464, 0x00606060, 0x005E5E5E, 0x005B5A5C, 0x00585759, 0x00545355, 0x00504F51, 0x004D4C4E, 0x0049484A, 0x00434244, 0x003F3E40, 0x0039383A, 
        0x00323133, 0x002D2C2E, 0x00313032, 0x0039383A, 0x00444345, 0x004F4E50, 0x005B5A5C, 0x00676668, 0x00747375, 0x00848484, 0x00959595, 0x00A6A6A6, 0x00B9B9B9, 0x00CACACA, 0x00DCDCDC, 0x00EDEDED, 0x00FEFEFE, 0x00F9F9F9, 0x00E4E4E4, 0x00CFCFCF, 
        0x00BDBDBD, 0x00ABABAB, 0x009A9A9A, 0x008C8C8C, 0x00808080, 0x00747474, 0x006A6A6A, 0x00606060, 0x00585858, 0x00585858, 0x005D5D5D, 0x00606060, 0x00636363, 0x00676767, 0x00686868, 0x006B6B6B, 0x006D6D6D, 0x00707070, 0x00707070, 0x00777777, 
        0x00B1B1B1, 0x00B4B4B4, 0x00AEAEAF, 0x66BEBDBE, 0xFFDCDCDC, 0xFFF5F5F5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD3D3D3, 0x91646464, 0x00494949, 0x005A5A5A, 0x00686868, 0x0069686A, 0x00676668, 0x00646365, 0x00616062, 0x005F5E60, 0x005C5B5D, 0x00585759, 0x00545355, 0x004F4E50, 0x004B4A4C, 0x00474648, 0x00424143, 
        0x003B3A3C, 0x00343335, 0x002D2C2E, 0x00313032, 0x003A393B, 0x00464547, 0x00515052, 0x005F5E60, 0x006D6C6E, 0x007D7C7E, 0x008E8D8F, 0x00A09FA1, 0x00B4B4B4, 0x00C8C8C8, 0x00DCDCDC, 0x00F0F0F0, 0x00FFFFFF, 0x00F2F2F2, 0x00DBDBDB, 0x00C4C4C4, 
        0x00B0B0B0, 0x009E9E9E, 0x008E8E8E, 0x00808080, 0x00737373, 0x00676767, 0x005F5F5F, 0x00585858, 0x005A5A5A, 0x005E5E5E, 0x00626262, 0x00656565, 0x00696969, 0x006C6C6C, 0x006E6E6E, 0x00717171, 0x00737373, 0x00747375, 0x00777678, 0x00787779, 
        0x009E9D9F, 0x00B6B5B8, 0x00B3B2B5, 0x1CB6B5B8, 0xF5D5D5D5, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC8C8C8, 0x402E2E2E, 0x00383838, 0x00484848, 0x006C6C6C, 0x006F6E70, 0x006D6C6E, 0x006B6A6C, 0x00686769, 0x00666567, 0x00636264, 0x00605F61, 0x005C5B5D, 0x00585759, 0x00545355, 0x00504F51, 0x004B4A4C, 
        0x00454446, 0x003E3D3F, 0x00373638, 0x002F2E30, 0x00302F31, 0x003B3A3C, 0x00474648, 0x00545355, 0x00636264, 0x00747375, 0x00878688, 0x009C9B9D, 0x00B2B2B2, 0x00C7C7C7, 0x00DDDDDD, 0x00F4F4F4, 0x00FDFDFD, 0x00E7E7E7, 0x00CFCFCF, 0x00B7B7B7, 
        0x00A2A2A2, 0x008F8F8F, 0x00818181, 0x00727272, 0x00656565, 0x005A5A5A, 0x00585858, 0x005C5C5C, 0x00616161, 0x00656565, 0x00696969, 0x006C6C6C, 0x006F6F6F, 0x00717171, 0x00747474, 0x00767676, 0x00777777, 0x0079787A, 0x007B7A7C, 0x007C7B7D, 
        0x008B8A8C, 0x00BBBABE, 0x00B7B6BA, 0x00B4B3B6, 0xC0CCCCCD, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xED949494, 0x0B161616, 0x00282828, 0x003C3C3C, 0x00777777, 0x00757476, 0x00737274, 0x00727173, 0x006F6E70, 0x006D6C6E, 0x006A696B, 0x00686769, 0x00656466, 0x00605F61, 0x005D5C5E, 0x00585759, 0x00545355, 
        0x004E4D4F, 0x00474648, 0x00424143, 0x003A393B, 0x00313032, 0x002F2E30, 0x003B3A3C, 0x00484749, 0x00585759, 0x0069686A, 0x007D7C7E, 0x00949395, 0x00AEAEAE, 0x00C6C6C6, 0x00DFDFDF, 0x00F7F7F7, 0x00F8F8F8, 0x00DADADA, 0x00C0C0C0, 0x00A7A7A7, 
        0x00929292, 0x00808080, 0x00707070, 0x00616161, 0x00595959, 0x005A5A5A, 0x005F5F5F, 0x00646464, 0x00696969, 0x006C6C6C, 0x006F6F6F, 0x00727272, 0x00747474, 0x00767676, 0x00787878, 0x007B7B7B, 0x007C7C7C, 0x007D7C7E, 0x007F7E80, 0x00807F81, 
        0x00848385, 0x00B8B7BB, 0x00BBBABE, 0x00B6B5B8, 0x79C4C4C5, 0xFFEDEDED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xBD656565, 0x00080808, 0x00161616, 0x00464646, 0x007C7C7C, 0x007C7B7D, 0x007A797B, 0x0079787A, 0x00767577, 0x00747375, 0x00727173, 0x00706F71, 0x006D6C6E, 0x006A696B, 0x00666567, 0x00626163, 0x005E5D5F, 
        0x00585759, 0x00535254, 0x004D4C4E, 0x00464547, 0x003E3D3F, 0x00343335, 0x00302F31, 0x003A393B, 0x004B4A4C, 0x005D5C5E, 0x00747375, 0x008C8B8D, 0x00A7A7A7, 0x00C4C4C4, 0x00E1E1E1, 0x00FAFAFA, 0x00EEEEEE, 0x00CCCCCC, 0x00AFAFAF, 0x00959595, 
        0x00808080, 0x006E6E6E, 0x005E5E5E, 0x00595959, 0x005D5D5D, 0x00636363, 0x00696969, 0x006D6D6D, 0x00707070, 0x00737373, 0x00767676, 0x00787878, 0x007A7A7A, 0x007C7C7C, 0x007E7E7E, 0x00808080, 0x00818181, 0x00838284, 0x00848385, 0x00858486, 
        0x00868587, 0x00ACABAF, 0x00BEBDC1, 0x00BBBABD, 0x3EBFBFC0, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x8B3D3D3D, 0x00000000, 0x00080808, 0x00515151, 0x00838383, 0x00818082, 0x00807F81, 0x007E7D7F, 0x007D7C7E, 0x007B7A7C, 0x0079787A, 0x00777678, 0x00757476, 0x00737274, 0x00706F71, 0x006D6C6E, 0x00686769, 
        0x00646365, 0x005F5E60, 0x0059585A, 0x00545355, 0x004B4A4C, 0x00424143, 0x00373638, 0x00302F31, 0x0039383A, 0x004C4B4D, 0x00656466, 0x00807F81, 0x009F9F9F, 0x00C0C0C0, 0x00E5E5E5, 0x00FCFCFC, 0x00E0E0E0, 0x00B9B9B9, 0x00999999, 0x00808080, 
        0x006B6B6B, 0x005C5C5C, 0x005B5B5B, 0x00626262, 0x00686868, 0x006C6C6C, 0x00717171, 0x00747474, 0x00777678, 0x007A797B, 0x007C7B7D, 0x007E7D7F, 0x00818082, 0x00828183, 0x00848385, 0x00858486, 0x00868686, 0x00878688, 0x0089888A, 0x008A898B, 
        0x008A898B, 0x00A3A2A6, 0x00C1C0C4, 0x00BDBCBF, 0x12C0BFC0, 0xF9E7E7E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x59212121, 0x00020202, 0x00010101, 0x00676767, 0x00898989, 0x00888789, 0x00878688, 0x00868587, 0x00858486, 0x00838284, 0x00818082, 0x007F7E80, 0x007C7B7D, 0x007B7A7C, 0x0079787A, 0x00767577, 0x00727173, 
        0x006F6E70, 0x006B6A6C, 0x00666567, 0x00616062, 0x0059585A, 0x00515052, 0x00484749, 0x003C3B3D, 0x00313032, 0x00383739, 0x00525153, 0x006F6E70, 0x00939393, 0x00BFBFBF, 0x00E8E8E8, 0x00F5F5F5, 0x00C8C8C8, 0x00A0A0A0, 0x007F7F7F, 0x00666666, 
        0x005B5B5B, 0x005F5F5F, 0x00666666, 0x006D6D6D, 0x00717171, 0x00757575, 0x00797979, 0x007C7C7C, 0x007E7D7F, 0x00818082, 0x00838284, 0x00868587, 0x00878688, 0x00888789, 0x0089888A, 0x008A898B, 0x008B8B8B, 0x008C8B8D, 0x008D8C8E, 0x008E8D8F, 
        0x008F8E90, 0x009E9DA1, 0x00C3C2C6, 0x00C0BFC2, 0x00BFBFC0, 0xD8E5E5E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x3B141414, 0x00070707, 0x00020202, 0x007D7D7D, 0x008D8D8D, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x00878688, 0x00878688, 0x00868587, 0x00848385, 0x00828183, 0x00807F81, 0x007E7D7F, 
        0x007B7A7C, 0x00777678, 0x00747375, 0x00706F71, 0x006B6A6C, 0x00636264, 0x005C5B5D, 0x00515052, 0x00434244, 0x00333234, 0x0039383A, 0x0059585A, 0x00828282, 0x00B7B7B7, 0x00EDEDED, 0x00E3E3E3, 0x00ABABAB, 0x007E7E7E, 0x00616161, 0x005D5D5D, 
        0x00666666, 0x006E6E6E, 0x00737373, 0x00787878, 0x007C7C7C, 0x00808080, 0x00828282, 0x00858585, 0x00878688, 0x00888789, 0x0089888A, 0x008B8A8C, 0x008C8B8D, 0x008D8C8E, 0x008E8D8F, 0x008F8E90, 0x00919191, 0x00919092, 0x00929193, 0x00939294, 
        0x00929193, 0x009C9B9F, 0x00C7C6CA, 0x00C3C2C5, 0x00C1C0C1, 0xBAE3E3E3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x22191919, 0x00101010, 0x000B0B0B, 0x00949494, 0x00949494, 0x00949395, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 0x008F8E90, 0x008F8E90, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x00888789, 
        0x00868587, 0x00838284, 0x00818082, 0x007E7D7F, 0x007A797B, 0x00767577, 0x006F6E70, 0x00676668, 0x005D5C5E, 0x004E4D4F, 0x003C3B3D, 0x003B3A3C, 0x00676767, 0x00ABABAB, 0x00EFEFEF, 0x00C0C0C0, 0x007F7F7F, 0x00616161, 0x00646464, 0x006F6F6F, 
        0x00777777, 0x007D7D7D, 0x00828282, 0x00858585, 0x00878787, 0x008A8A8A, 0x008B8B8B, 0x008D8D8D, 0x008E8D8F, 0x008F8E90, 0x00908F91, 0x00929193, 0x00929193, 0x00939294, 0x00949395, 0x00959496, 0x00959595, 0x00969597, 0x00979698, 0x00979698, 
        0x00979698, 0x009A999D, 0x00C8C7CB, 0x00C7C6CA, 0x00C3C2C3, 0xA2E3E3E3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x10242424, 0x001A191B, 0x001B1A1C, 0x0099989A, 0x009A999B, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00989799, 0x00979698, 0x00979698, 0x00969597, 0x00959496, 0x00949395, 0x00939294, 0x00939294, 
        0x00919092, 0x00908F91, 0x008E8D8F, 0x008D8C8E, 0x008A898B, 0x00878688, 0x00838284, 0x007F7E80, 0x0079787A, 0x00706F71, 0x00605F61, 0x00484749, 0x00434343, 0x00949494, 0x00DFDFDF, 0x00838284, 0x00656466, 0x00717072, 0x007D7C7E, 0x00838284, 
        0x00878688, 0x008B8A8C, 0x008E8D8F, 0x00919092, 0x00929193, 0x00939294, 0x00959496, 0x00969597, 0x00969597, 0x00979698, 0x00979698, 0x00989799, 0x0099989A, 0x0099989A, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009B9A9C, 
        0x00999A9E, 0x009A9B9F, 0x00BDBEC2, 0x00C6C7CB, 0x00C8C7CB, 0x8FE4E3E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x042D2D2D, 0x00232224, 0x00262527, 0x009F9EA0, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009D9C9E, 0x009C9B9D, 0x009C9B9D, 0x009C9B9D, 
        0x009C9B9D, 0x009C9B9D, 0x009B9A9C, 0x009B9A9C, 0x0099989A, 0x00989799, 0x00979698, 0x00969597, 0x00949395, 0x00908F91, 0x008D8C8E, 0x00858486, 0x006E6E6E, 0x006B6B6B, 0x00A0A0A0, 0x007C7B7D, 0x008A898B, 0x00929193, 0x00959496, 0x00989799, 
        0x00989799, 0x009A999B, 0x009A999B, 0x009B9A9C, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x00A09FA1, 
        0x009E9FA3, 0x009D9EA2, 0x00B7B8BC, 0x00C0C1C5, 0x00C7C6CA, 0x84E4E4E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x01343434, 0x002B2A2C, 0x002E2D2F, 0x00A09FA1, 0x009F9EA0, 0x00A09FA1, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 
        0x009E9D9F, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009B9A9C, 0x009A999B, 0x009A999B, 0x00989799, 0x00989799, 0x00959496, 0x00919092, 0x0089888A, 0x007C7C7C, 0x00A1A1A1, 0x006B6B6B, 0x006D6C6E, 0x00838284, 0x008C8B8D, 0x00908F91, 0x00949395, 
        0x00969597, 0x00979698, 0x00989799, 0x0099989A, 0x009A999B, 0x009B9A9C, 0x009B9A9C, 0x009C9B9D, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009D9C9E, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009E9D9F, 0x009F9EA0, 0x009F9EA0, 0x009F9EA0, 
        0x009D9EA2, 0x009C9DA1, 0x00B1B2B6, 0x00B9BABE, 0x00C2C1C5, 0x81E3E3E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x093D3D3D, 0x00333234, 0x00323133, 0x009C9B9D, 0x009B9A9C, 0x009B9A9C, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x009A999B, 0x0099989A, 0x0099989A, 0x00989799, 0x00989799, 0x00979698, 0x00969597, 
        0x00959496, 0x00949395, 0x00939294, 0x00919092, 0x00919092, 0x008E8D8F, 0x008B8A8C, 0x00878688, 0x00838284, 0x007C7B7D, 0x00717072, 0x00656466, 0x00848484, 0x00E0E0E0, 0x00939393, 0x00424143, 0x00484749, 0x00605F61, 0x00706F71, 0x0079787A, 
        0x007F7E80, 0x00848385, 0x00878688, 0x008A898B, 0x008C8B8D, 0x008D8C8E, 0x00908F91, 0x00919092, 0x00929193, 0x00939294, 0x00949395, 0x00949395, 0x00969597, 0x00979698, 0x00979698, 0x00989799, 0x00989799, 0x00989799, 0x0099989A, 0x0099989A, 
        0x0098999D, 0x0096979B, 0x00ABACB0, 0x00B0B1B5, 0x00BBBABE, 0x89E2E1E2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x18444444, 0x003B3A3C, 0x00343335, 0x00969597, 0x00979698, 0x00979698, 0x00979698, 0x00969597, 0x00959496, 0x00959496, 0x00949395, 0x00939294, 0x00929193, 0x00929193, 0x00919092, 0x00919092, 0x008E8D8F, 
        0x008D8C8E, 0x008B8A8C, 0x008A898B, 0x00878688, 0x00858585, 0x00828282, 0x007D7D7D, 0x00777777, 0x00707070, 0x00636363, 0x00606060, 0x00808080, 0x00C1C1C1, 0x00EFEFEF, 0x00ABABAB, 0x00686769, 0x003C3B3D, 0x003C3B3D, 0x004D4C4E, 0x005C5B5D, 
        0x00676668, 0x006F6E70, 0x00767577, 0x007A797B, 0x007E7D7F, 0x00818082, 0x00838284, 0x00868587, 0x00888789, 0x008A898B, 0x008B8A8C, 0x008C8B8D, 0x008D8C8E, 0x008F8E90, 0x008F8E90, 0x00919092, 0x00929193, 0x00929193, 0x00939294, 0x00949395, 
        0x00929397, 0x00949599, 0x00A3A4A8, 0x00AAABAF, 0x00B3B2B6, 0x98E2E1E2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x2E515151, 0x00454446, 0x003B3A3C, 0x0089888A, 0x00929193, 0x00939294, 0x00929193, 0x00919092, 0x00919092, 0x008F8E90, 0x008E8D8F, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x00878688, 
        0x00858486, 0x00828183, 0x007F7E80, 0x007C7B7D, 0x00787878, 0x00737373, 0x006E6E6E, 0x00666666, 0x005D5D5D, 0x00626262, 0x007E7E7E, 0x00ADADAD, 0x00E3E3E3, 0x00ECECEC, 0x00B8B8B8, 0x00828183, 0x005A595B, 0x0039383A, 0x00333234, 0x00434244, 
        0x00515052, 0x005C5B5D, 0x00636264, 0x006B6A6C, 0x00706F71, 0x00747375, 0x00777678, 0x007B7A7C, 0x007E7D7F, 0x00807F81, 0x00828183, 0x00848385, 0x00868587, 0x00878688, 0x00878688, 0x0089888A, 0x008A898B, 0x008B8A8C, 0x008C8B8D, 0x008D8C8E, 
        0x008C8D91, 0x008E8F93, 0x009C9DA1, 0x00A3A4A8, 0x00AEADB1, 0xADE3E2E3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x49656565, 0x004C4B4D, 0x00464547, 0x007B7A7C, 0x008E8D8F, 0x008E8D8F, 0x008D8C8E, 0x008C8B8D, 0x008B8A8C, 0x008A898B, 0x0089888A, 0x00888789, 0x00878688, 0x00858486, 0x00838284, 0x00828183, 0x007F7E80, 
        0x007C7B7D, 0x0079787A, 0x00757476, 0x00717072, 0x006D6D6D, 0x00666666, 0x005F5F5F, 0x005B5B5B, 0x00666666, 0x00808080, 0x00A0A0A0, 0x00C8C8C8, 0x00F5F5F5, 0x00E8E8E8, 0x00BDBDBD, 0x00949395, 0x006F6E70, 0x00525153, 0x00383739, 0x00323133, 
        0x003C3B3D, 0x00484749, 0x00515052, 0x0059585A, 0x00616062, 0x00666567, 0x006B6A6C, 0x006F6E70, 0x00727173, 0x00767577, 0x0079787A, 0x007B7A7C, 0x007C7B7D, 0x007F7E80, 0x00818082, 0x00838284, 0x00858486, 0x00858486, 0x00878688, 0x00888789, 
        0x0086878B, 0x008A8B8F, 0x0096979B, 0x009C9DA1, 0x00AAA9AD, 0xC9E5E4E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6E7E7E7E, 0x00555456, 0x004D4C4E, 0x006E6D6F, 0x0089888A, 0x008A898B, 0x0089888A, 0x00878688, 0x00868587, 0x00858486, 0x00848385, 0x00828183, 0x00818082, 0x007E7D7F, 0x007C7B7D, 0x007A797B, 0x00777678, 
        0x00757476, 0x00717072, 0x006D6C6E, 0x00686769, 0x00626262, 0x005B5B5B, 0x005C5C5C, 0x006B6B6B, 0x007F7F7F, 0x009A9A9A, 0x00BABABA, 0x00DFDFDF, 0x00FDFDFD, 0x00E4E4E4, 0x00C1C1C1, 0x00A09FA1, 0x007F7E80, 0x00646365, 0x004C4B4D, 0x003A393B, 
        0x00302F31, 0x00373638, 0x00424143, 0x004B4A4C, 0x00545355, 0x0059585A, 0x005F5E60, 0x00646365, 0x00686769, 0x006D6C6E, 0x00706F71, 0x00737274, 0x00757476, 0x00777678, 0x0079787A, 0x007B7A7C, 0x007D7C7E, 0x007E7D7F, 0x00807F81, 0x00818082, 
        0x00808185, 0x00848589, 0x008F9094, 0x0095969A, 0x04A9A8AC, 0xEAE8E7E8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA7959595, 0x005F5E60, 0x00545355, 0x00616062, 0x00858486, 0x00858585, 0x00848484, 0x00838383, 0x00828282, 0x00818181, 0x007E7E7E, 0x007C7C7C, 0x007A7A7A, 0x00787878, 0x00757575, 0x00737373, 0x00707070, 
        0x006D6D6D, 0x00696969, 0x00636363, 0x005D5D5D, 0x00595959, 0x005D5D5D, 0x006E6E6E, 0x00808080, 0x00959595, 0x00AFAFAF, 0x00CCCCCC, 0x00EDEDED, 0x00FAFAFA, 0x00E1E1E1, 0x00C3C3C3, 0x00A6A6A6, 0x008B8A8C, 0x00737274, 0x005C5B5D, 0x004A494B, 
        0x003A393B, 0x002F2E30, 0x00343335, 0x003E3D3F, 0x00464547, 0x004D4C4E, 0x00535254, 0x00585759, 0x005D5C5E, 0x00636264, 0x00666567, 0x006A696B, 0x006D6C6E, 0x00706F71, 0x00727173, 0x00747375, 0x00777678, 0x00787779, 0x0079787A, 0x007B7A7C, 
        0x007E7D7F, 0x00807F81, 0x00888789, 0x008F8E90, 0x27AFAEAF, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xD5B1B1B1, 0x00666567, 0x005C5B5D, 0x005B5A5C, 0x00807F81, 0x00808080, 0x007F7F7F, 0x007E7E7E, 0x007D7D7D, 0x007B7B7B, 0x00787878, 0x00767676, 0x00747474, 0x00727272, 0x006F6F6F, 0x006C6C6C, 0x00676767, 
        0x00646464, 0x005F5F5F, 0x005A5A5A, 0x00595959, 0x00626262, 0x00707070, 0x00818181, 0x00939393, 0x00A7A7A7, 0x00C1C1C1, 0x00DADADA, 0x00F8F8F8, 0x00F8F8F8, 0x00E0E0E0, 0x00C5C5C5, 0x00ADADAD, 0x00949395, 0x007D7C7E, 0x00686769, 0x00575658, 
        0x00484749, 0x003B3A3C, 0x002F2E30, 0x00323133, 0x003A393B, 0x00424143, 0x00474648, 0x004E4D4F, 0x00545355, 0x005A595B, 0x005D5C5E, 0x00616062, 0x00646365, 0x00676668, 0x006A696B, 0x006E6D6F, 0x00706F71, 0x00727173, 0x00737274, 0x00757476, 
        0x00767577, 0x007B7A7C, 0x00818082, 0x008A898B, 0x55B9B9B9, 0xFFEEEEEE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFDCACACA, 0x24717072, 0x00676668, 0x005C5B5D, 0x00777678, 0x007B7B7B, 0x007A7A7A, 0x00797979, 0x00777777, 0x00767676, 0x00737373, 0x00717171, 0x006E6E6E, 0x006B6B6B, 0x00686868, 0x00656565, 0x00616161, 
        0x005C5C5C, 0x00585858, 0x005A5A5A, 0x00656565, 0x00727272, 0x007F7F7F, 0x008F8F8F, 0x00A2A2A2, 0x00B7B7B7, 0x00CFCFCF, 0x00E7E7E7, 0x00FDFDFD, 0x00F5F5F5, 0x00DEDEDE, 0x00C7C7C7, 0x00B2B2B2, 0x009B9A9C, 0x00878688, 0x00747375, 0x00636264, 
        0x00545355, 0x00464547, 0x003B3A3C, 0x00313032, 0x002F2E30, 0x00373638, 0x003E3D3F, 0x00454446, 0x004B4A4C, 0x00504F51, 0x00545355, 0x00585759, 0x005C5B5D, 0x005F5E60, 0x00636264, 0x00676668, 0x0069686A, 0x006B6A6C, 0x006D6C6E, 0x006F6E70, 
        0x00706F71, 0x00747375, 0x007C7B7D, 0x00838284, 0xA1CBCBCB, 0xFFEFEFEF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD5D5D5, 0x638D8C8E, 0x006F6E70, 0x00676668, 0x006C6B6D, 0x00777777, 0x00767676, 0x00747474, 0x00727272, 0x00717171, 0x006E6E6E, 0x006B6B6B, 0x00686868, 0x00656565, 0x00626262, 0x005E5E5E, 0x00595959, 
        0x00585858, 0x005F5F5F, 0x00676767, 0x00737373, 0x00818181, 0x008D8D8D, 0x009F9F9F, 0x00B1B1B1, 0x00C4C4C4, 0x00DADADA, 0x00F1F1F1, 0x00FFFFFF, 0x00F1F1F1, 0x00DDDDDD, 0x00C8C8C8, 0x00B4B4B4, 0x00A1A0A2, 0x008E8D8F, 0x007D7C7E, 0x006D6C6E, 
        0x005F5E60, 0x00504F51, 0x00454446, 0x003B3A3C, 0x00313032, 0x002D2C2E, 0x00343335, 0x003B3A3C, 0x00424143, 0x00474648, 0x004C4B4D, 0x00504F51, 0x00545355, 0x00585759, 0x005B5A5C, 0x005F5E60, 0x00626163, 0x00646365, 0x00676668, 0x006A696B, 
        0x00686769, 0x006C6B6D, 0x00757476, 0x06908F91, 0xDDD5D5D5, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDCDCDC, 0xBCADACAE, 0x00787779, 0x00717072, 0x0069686A, 0x00747474, 0x00737373, 0x00707070, 0x006E6E6E, 0x006C6C6C, 0x00696969, 0x00666666, 0x00646464, 0x00606060, 0x005D5D5D, 0x00585858, 0x00585858, 
        0x00606060, 0x006A6A6A, 0x00757575, 0x00818181, 0x008D8D8D, 0x009B9B9B, 0x00ABABAB, 0x00BDBDBD, 0x00CFCFCF, 0x00E4E4E4, 0x00F9F9F9, 0x00FEFEFE, 0x00EEEEEE, 0x00DCDCDC, 0x00CACACA, 0x00B8B8B8, 0x00A5A4A6, 0x00949395, 0x00848385, 0x00757476, 
        0x00676668, 0x005A595B, 0x004E4D4F, 0x00444345, 0x0039383A, 0x00313032, 0x002D2C2E, 0x00323133, 0x0039383A, 0x003F3E40, 0x00434244, 0x0049484A, 0x004D4C4E, 0x00515052, 0x00545355, 0x00585759, 0x005B5A5C, 0x005D5C5E, 0x00626163, 0x00636264, 
        0x00605F61, 0x00646365, 0x006C6B6D, 0x3CA9A8AA, 0xFFDCDCDC, 0xFFF5F5F5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE5E5E5, 0xF6C9C8CA, 0x24848385, 0x00787779, 0x006F6E70, 0x006E6E6E, 0x006E6E6E, 0x006B6B6B, 0x00696969, 0x00676767, 0x00646464, 0x00616161, 0x005F5F5F, 0x00595959, 0x00575757, 0x005A5A5A, 0x00636363, 
        0x006B6B6B, 0x00757575, 0x00808080, 0x008B8B8B, 0x00989898, 0x00A6A6A6, 0x00B6B6B6, 0x00C7C7C7, 0x00D9D9D9, 0x00ECECEC, 0x00FDFDFD, 0x00FBFBFB, 0x00ECECEC, 0x00DBDBDB, 0x00CBCBCB, 0x00BABABA, 0x00AAA9AB, 0x009A999B, 0x0089888A, 0x007B7A7C, 
        0x006F6E70, 0x00626163, 0x00575658, 0x004C4B4D, 0x00434244, 0x003B3A3C, 0x00323133, 0x002D2C2E, 0x00302F31, 0x00363537, 0x003C3B3D, 0x00414042, 0x00454446, 0x0049484A, 0x004E4D4F, 0x00525153, 0x00555456, 0x00585759, 0x005A595B, 0x005F5E60, 
        0x005F5E60, 0x005E5D5F, 0x006B6A6C, 0x9AC8C7C9, 0xFFE4E4E4, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFFD8D7D9, 0x80A09FA1, 0x00818082, 0x0079787A, 0x00707070, 0x00696969, 0x00686868, 0x00656565, 0x00626262, 0x00606060, 0x005C5C5C, 0x00585858, 0x00575757, 0x005C5C5C, 0x00646464, 0x006D6D6D, 
        0x00777777, 0x00808080, 0x008B8B8B, 0x00979797, 0x00A4A4A4, 0x00B2B2B2, 0x00C1C1C1, 0x00D1D1D1, 0x00E2E2E2, 0x00F3F3F3, 0x00FFFFFF, 0x00F8F8F8, 0x00EBEBEB, 0x00DADADA, 0x00CCCCCC, 0x00BCBCBC, 0x00ADACAE, 0x009F9EA0, 0x008F8E90, 0x00838284, 
        0x00757476, 0x0069686A, 0x005F5E60, 0x00545355, 0x004B4A4C, 0x00424143, 0x003A393B, 0x00333234, 0x002E2D2F, 0x00302F31, 0x00353436, 0x003A393B, 0x003F3E40, 0x00434244, 0x00474648, 0x004A494B, 0x004E4D4F, 0x00525153, 0x00565557, 0x0069686A, 
        0x00686769, 0x005D5C5E, 0x1389888A, 0xECD7D6D8, 0xFFEBEBEB, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF1F1F1, 0xFFE1E0E2, 0xE2C3C2C4, 0x1089888A, 0x00818082, 0x00787878, 0x006A6A6A, 0x00626262, 0x00616161, 0x005D5D5D, 0x00595959, 0x00575757, 0x00585858, 0x00606060, 0x00676767, 0x006F6F6F, 0x00767676, 
        0x00808080, 0x008A8A8A, 0x00959595, 0x00A0A0A0, 0x00ADADAD, 0x00BBBBBB, 0x00CACACA, 0x00D8D8D8, 0x00E8E8E8, 0x00F8F8F8, 0x00FFFFFF, 0x00F6F6F6, 0x00E8E8E8, 0x00D9D9D9, 0x00CDCDCD, 0x00BEBEBE, 0x00B0AFB1, 0x00A3A2A4, 0x00939294, 0x00888789, 
        0x007C7B7D, 0x00706F71, 0x00656466, 0x005C5B5D, 0x00525153, 0x0049484A, 0x00424143, 0x003B3A3C, 0x00333234, 0x002E2D2F, 0x002E2D2F, 0x00333234, 0x00373638, 0x003C3B3D, 0x00403F41, 0x00454446, 0x00484749, 0x004C4B4D, 0x00605F61, 0x00767577, 
        0x006D6C6E, 0x006A696B, 0x72BCBBBD, 0xFFE1E0E2, 0xFFF1F1F1, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFE8E8E8, 0xFFD5D5D5, 0x70A3A3A3, 0x00888888, 0x00828183, 0x00777678, 0x005F5E60, 0x005B5A5C, 0x00595959, 0x00575757, 0x005B5B5B, 0x00616260, 0x00676767, 0x006F6F6F, 0x00777777, 0x00808080, 
        0x00898989, 0x00939393, 0x009E9E9E, 0x00A9A9A9, 0x00B6B6B6, 0x00C3C3C3, 0x00D1D1D1, 0x00DFDFDF, 0x00EEEEEE, 0x00FDFDFD, 0x00FEFEFE, 0x00F3F3F3, 0x00E6E6E6, 0x00D9D9D9, 0x00CDCDCD, 0x00BFBFBF, 0x00B2B2B2, 0x00A5A5A5, 0x00989898, 0x008C8C8C, 
        0x00807F81, 0x00757476, 0x006B6A6C, 0x00616062, 0x00585759, 0x00504F51, 0x00484749, 0x00414042, 0x003B3A3C, 0x00343335, 0x002E2D2F, 0x002C2B2D, 0x00333234, 0x00353436, 0x003C3B3D, 0x003F3E40, 0x00434244, 0x0049484A, 0x00807F81, 0x007D7C7E, 
        0x00747375, 0x11919092, 0xDFD4D3D5, 0xFFEAE9EB, 0xFFF6F6F6, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8F8F8, 0xFFF1F1F1, 0xFFE0E0E0, 0xE4C4C4C4, 0x15959595, 0x0089888A, 0x00818082, 0x006D6C6E, 0x00575658, 0x00585858, 0x005D5D5D, 0x00626262, 0x006A6A6A, 0x00707070, 0x00787878, 0x00808080, 0x00888888, 
        0x00919191, 0x009C9C9C, 0x00A6A6A6, 0x00B2B2B2, 0x00BEBEBE, 0x00CBCBCB, 0x00D8D8D8, 0x00E6E6E6, 0x00F4F4F4, 0x00FFFFFF, 0x00FCFCFC, 0x00F1F1F1, 0x00E5E5E5, 0x00D8D8D8, 0x00CDCDCD, 0x00C0C0C0, 0x00B4B4B4, 0x00A8A8A8, 0x009C9C9C, 0x00909090, 
        0x00868587, 0x007B7A7C, 0x00717072, 0x00686769, 0x005F5E60, 0x00575658, 0x004F4E50, 0x00484749, 0x00424143, 0x003B3A3C, 0x00343335, 0x002F2E30, 0x002B2A2C, 0x00323133, 0x00343335, 0x0039383A, 0x003C3B3D, 0x00727173, 0x008D8C8E, 0x00858486, 
        0x00807F81, 0x7AC2C1C3, 0xFFE1E0E2, 0xFFF0EFF1, 0xFFF8F8F8, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFF6F6F6, 0xFFEBEBEB, 0xFFD6D6D6, 0x8EAFAFAF, 0x00949395, 0x008A898B, 0x00807F81, 0x00636363, 0x005F5F5F, 0x00656565, 0x006A6A6A, 0x00717171, 0x00797979, 0x00808080, 0x00888888, 0x00919191, 
        0x00999999, 0x00A4A4A4, 0x00AEAEAE, 0x00BABABA, 0x00C5C5C5, 0x00D2D2D2, 0x00DEDEDE, 0x00EBEBEB, 0x00F9F9F9, 0x00FFFFFF, 0x00FAFAFA, 0x00F0F0F0, 0x00E4E4E4, 0x00D8D8D8, 0x00CDCDCD, 0x00C1C1C1, 0x00B6B6B6, 0x00ABABAB, 0x009F9F9F, 0x00949494, 
        0x0089888A, 0x007F7E80, 0x00767577, 0x006D6C6E, 0x00656466, 0x005D5C5E, 0x00555456, 0x004E4D4F, 0x00474648, 0x00414042, 0x003B3A3C, 0x00353436, 0x00302F31, 0x002C2B2D, 0x00302F31, 0x00333234, 0x00555456, 0x009C9B9D, 0x00959496, 0x008E8D8F, 
        0x21A8A7A9, 0xECD8D7D9, 0xFFEBEAEC, 0xFFF6F5F7, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF1F1F1, 0xFFE4E4E4, 0xF5CCCCCC, 0x39A2A1A3, 0x00929193, 0x008A8A8A, 0x00808080, 0x00696969, 0x006B6B6B, 0x00727272, 0x00797979, 0x00808080, 0x00878787, 0x008F8F8F, 0x00989898, 
        0x00A1A1A1, 0x00ABABAB, 0x00B6B6B6, 0x00C1C1C1, 0x00CCCCCC, 0x00D8D8D8, 0x00E3E3E3, 0x00F1F1F1, 0x00FCFCFC, 0x00FFFFFF, 0x00F8F8F8, 0x00EFEFEF, 0x00E3E3E3, 0x00D8D8D8, 0x00CECECE, 0x00C2C2C2, 0x00B8B8B8, 0x00ADADAD, 0x00A3A3A3, 0x00989898, 
        0x008D8C8E, 0x00848385, 0x007B7A7C, 0x00727173, 0x006A696B, 0x00626163, 0x005A595B, 0x00545355, 0x004D4C4E, 0x00464547, 0x00403F41, 0x003A393B, 0x00353436, 0x002F2E30, 0x002D2C2E, 0x003E3D3F, 0x00A09FA1, 0x00A7A6A8, 0x009B9A9C, 0x029F9EA0, 
        0xACCCCBCD, 0xFFE2E1E3, 0xFFF3F2F4, 0xFFF8F7F9, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFF7F7F7, 0xFFEEEEEE, 0xFFDDDDDD, 0xD3C1C1C1, 0x129D9D9D, 0x00939393, 0x008B8B8B, 0x007F7F7F, 0x00737373, 0x007A797B, 0x00807F81, 0x00878787, 0x008E8E8E, 0x00969696, 0x009F9F9F, 
        0x00A8A8A8, 0x00B2B2B2, 0x00BCBCBC, 0x00C7C7C7, 0x00D1D1D1, 0x00DDDDDD, 0x00E9E9E9, 0x00F4F4F4, 0x00FFFFFF, 0x00FEFEFE, 0x00F7F7F7, 0x00ECECEC, 0x00E2E2E2, 0x00D8D8D8, 0x00CECECE, 0x00C3C3C3, 0x00BABABA, 0x00AFAFAF, 0x00A5A5A5, 0x009B9B9B, 
        0x00929193, 0x00878688, 0x007F7E80, 0x00767577, 0x006F6E70, 0x00676668, 0x005F5E60, 0x00585759, 0x00525153, 0x004B4A4C, 0x00444345, 0x00414042, 0x003B3A3C, 0x00353436, 0x00373638, 0x00A09FA1, 0x00B5B5B5, 0x00ADADAD, 0x00A5A5A5, 0x66C2C2C2, 
        0xFFDDDDDD, 0xFFEEEEEE, 0xFFF7F7F7, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF5F5F5, 0xFFEAEAEA, 0xFFD8D8D8, 0x9CB8B8B8, 0x029C9C9C, 0x00949494, 0x008C8C8C, 0x00828183, 0x00807F81, 0x00868587, 0x008D8D8D, 0x00959595, 0x009D9D9D, 0x00A5A5A5, 
        0x00AFAFAF, 0x00B9B9B9, 0x00C3C3C3, 0x00CECECE, 0x00D8D8D8, 0x00E2E2E2, 0x00EEEEEE, 0x00F9F9F9, 0x00FFFFFF, 0x00FDFDFD, 0x00F5F5F5, 0x00EBEBEB, 0x00E1E1E1, 0x00D7D7D7, 0x00CECECE, 0x00C4C4C4, 0x00BBBBBB, 0x00B1B1B1, 0x00A8A8A8, 0x009E9E9E, 
        0x00959496, 0x008B8A8C, 0x00838284, 0x007A797B, 0x00737274, 0x006B6A6C, 0x00646365, 0x005D5C5E, 0x00565557, 0x00504F51, 0x004B4A4C, 0x00434244, 0x003E3D3F, 0x00424143, 0x00A4A3A5, 0x00C6C5C7, 0x00BDBDBD, 0x00B4B4B4, 0x31BDBDBD, 0xEDD8D8D8, 
        0xFFEAEAEA, 0xFFF5F5F5, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF3F3F3, 0xFFE7E7E7, 0xFFD4D4D4, 0x75B3B3B3, 0x009A9A9A, 0x00959496, 0x008B8A8C, 0x00868587, 0x008C8B8D, 0x00959595, 0x009C9C9C, 0x00A3A3A3, 0x00ACACAC, 
        0x00B6B6B6, 0x00BFBFBF, 0x00C8C8C8, 0x00D3D3D3, 0x00DDDDDD, 0x00E8E8E8, 0x00F2F2F2, 0x00FDFDFD, 0x00FFFFFF, 0x00FCFCFC, 0x00F3F3F3, 0x00EAEAEA, 0x00E1E1E1, 0x00D7D7D7, 0x00CECECE, 0x00C5C5C5, 0x00BBBBBB, 0x00B2B2B2, 0x00AAAAAA, 0x00A0A0A0, 
        0x00979698, 0x008E8D8F, 0x00868587, 0x007E7D7F, 0x00777678, 0x006F6E70, 0x00686769, 0x00616062, 0x005C5B5D, 0x00545355, 0x004F4E50, 0x00484749, 0x004B4A4C, 0x00B2B1B3, 0x00D4D3D5, 0x00CCCBCD, 0x00C5C5C5, 0x1AC1C1C1, 0xDBD3D3D3, 0xFFE6E6E6, 
        0xFFF3F3F3, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF1F2F0, 0xFFE4E4E4, 0xF7D1D1D1, 0x60AFAFAF, 0x009D9C9E, 0x00959496, 0x008A898B, 0x00878688, 0x00969696, 0x00A3A3A3, 0x00AAAAAA, 0x00B2B2B2, 
        0x00BBBBBB, 0x00C5C5C5, 0x00CECECE, 0x00D7D7D7, 0x00E1E1E1, 0x00EBEBEB, 0x00F5F5F5, 0x00FEFEFE, 0x00FFFFFF, 0x00FAFAFA, 0x00F1F1F1, 0x00E9E9E9, 0x00E0E0E0, 0x00D7D7D7, 0x00CFCFCF, 0x00C5C5C5, 0x00BDBDBD, 0x00B4B4B4, 0x00ACACAC, 0x00A3A3A3, 
        0x009B9A9C, 0x00929193, 0x008A898B, 0x00828183, 0x007B7A7C, 0x00737274, 0x006C6B6D, 0x00666567, 0x005F5E60, 0x00565557, 0x00535254, 0x00626163, 0x00CBCACC, 0x00E4E3E5, 0x00DDDCDE, 0x00D4D3D5, 0x14C9C9C9, 0xC3D0D0D0, 0xFFE4E4E4, 0xFFF1F1F1, 
        0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFEFEFEF, 0xFFE3E3E3, 0xF3D0D0D0, 0x5BAFAFAF, 0x009B9B9B, 0x00939393, 0x008C8C8C, 0x00878787, 0x009C9C9C, 0x00B1B1B1, 0x00B8B8B8, 
        0x00C1C1C1, 0x00C9C9C9, 0x00D3D3D3, 0x00DDDDDD, 0x00E5E5E5, 0x00EEEEEE, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00F0F0F0, 0x00E8E8E8, 0x00E0E0E0, 0x00D7D7D7, 0x00CFCFCF, 0x00C6C6C6, 0x00BEBEBE, 0x00B6B6B6, 0x00AEAEAE, 0x00A6A6A6, 
        0x009C9B9D, 0x00949395, 0x008C8B8D, 0x00858486, 0x007E7D7F, 0x00757476, 0x00717072, 0x0069686A, 0x00646464, 0x005C5C5C, 0x00868686, 0x00E9E9E9, 0x00F3F3F3, 0x00EBEBEB, 0x00E3E3E3, 0x14D1D1D1, 0xBAD1D1D1, 0xFFE3E3E3, 0xFFF0F0F0, 0xFFF8F8F8, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF6F6F6, 0xFFF0F0F0, 0xFFE2E2E2, 0xF4CFCFCF, 0x68B2B2B2, 0x009C9C9C, 0x00949494, 0x008A8A8A, 0x00848484, 0x00959595, 0x00BABABA, 
        0x00C5C5C5, 0x00CFCFCF, 0x00D6D6D6, 0x00DFDFDF, 0x00E9E9E9, 0x00F3F3F3, 0x00FCFCFC, 0x00FFFFFF, 0x00FEFEFE, 0x00F8F8F8, 0x00EFEFEF, 0x00E7E7E7, 0x00DFDFDF, 0x00D7D7D7, 0x00CFCFCF, 0x00C7C7C7, 0x00BEBEBE, 0x00B7B7B7, 0x00AFAFAF, 0x00A7A7A7, 
        0x009F9EA0, 0x00979698, 0x008F8E90, 0x00888789, 0x00807F81, 0x007B7A7C, 0x00737274, 0x006B6A6C, 0x006E6E6E, 0x00B0B0B0, 0x00FBFBFB, 0x00FEFEFE, 0x00FBFBFB, 0x00F3F3F3, 0x1AD8D8D8, 0xC3D1D1D1, 0xFFE2E2E2, 0xFFF0F0F0, 0xFFF7F7F7, 0xFFFAFAFA, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFEFEFEF, 0xFFE4E4E4, 0xFBD5D5D5, 0x86B9B9B9, 0x0A9F9F9F, 0x00959595, 0x008C8C8C, 0x00838383, 0x00858585, 
        0x00ADADAD, 0x00D2D2D2, 0x00DCDCDC, 0x00E3E3E3, 0x00EDEDED, 0x00F6F6F6, 0x00FEFEFE, 0x00FFFFFF, 0x00FDFDFD, 0x00F5F5F5, 0x00EEEEEE, 0x00E5E5E5, 0x00DFDFDF, 0x00D6D6D6, 0x00CFCFCF, 0x00C7C7C7, 0x00C0C0C0, 0x00B8B8B8, 0x00B1B1B1, 0x00A9A9A9, 
        0x00A1A0A2, 0x0099989A, 0x00929193, 0x008A898B, 0x00838284, 0x007D7C7E, 0x00767577, 0x008C8B8D, 0x00C1C1C1, 0x00DFDFDF, 0x00EEEEEE, 0x00F8F8F8, 0x00F9F9F9, 0x31D8D8D8, 0xDBD2D2D2, 0xFFE3E3E3, 0xFFEFEFEF, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF1F1F1, 0xFFE8E8E8, 0xFFD7D7D7, 0xB7C2C2C2, 0x1FA3A3A3, 0x00949494, 0x008C8C8C, 0x00848484, 
        0x007B7B7B, 0x00858585, 0x00B7B7B7, 0x00E5E5E5, 0x00F1F1F1, 0x00F8F8F8, 0x00FEFEFE, 0x00FFFFFF, 0x00FCFCFC, 0x00F3F3F3, 0x00EDEDED, 0x00E4E4E4, 0x00DEDEDE, 0x00D6D6D6, 0x00D0D0D0, 0x00C8C8C8, 0x00C1C1C1, 0x00B9B9B9, 0x00B2B2B2, 0x00AAAAAA, 
        0x00A4A3A5, 0x009C9B9D, 0x00959496, 0x008D8C8E, 0x00878688, 0x00838284, 0x00949395, 0x00AEADAF, 0x00BCBCBC, 0x00CDCDCD, 0x00DDDDDD, 0x02E5E5E5, 0x66D2D2D2, 0xEDD6D6D6, 0xFFE7E7E7, 0xFFF1F1F1, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF3F3F3, 0xFFEAEAEA, 0xFFDDDDDD, 0xE8CDCDCD, 0x61B0B0B0, 0x05979797, 0x008B8B8B, 
        0x00848484, 0x007A7A7A, 0x00737373, 0x00777777, 0x00A2A1A3, 0x00DBDADC, 0x00FEFDFE, 0x00FDFCFE, 0x00FBFAFC, 0x00F4F3F5, 0x00ECEBED, 0x00E5E4E6, 0x00DEDEDE, 0x00D6D6D6, 0x00CFCFCF, 0x00C8C8C8, 0x00C2C2C2, 0x00B9B9B9, 0x00B4B4B4, 0x00ACACAC, 
        0x00A5A5A5, 0x009E9E9E, 0x00858585, 0x00707070, 0x006D6D6D, 0x007B7B7B, 0x008C8C8C, 0x009D9D9D, 0x00ADADAD, 0x00BCBCBC, 0x21C9C9C9, 0xACCFCFCF, 0xFFDDDDDD, 0xFFEAEAEA, 0xFFF3F3F3, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 
        0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF5F5F5, 0xFFEEEEEE, 0xFFE5E5E5, 0xFFD5D5D5, 0xBFC4C4C4, 0x38A6A6A6, 
        0x008F8F8F, 0x00848484, 0x007B7B7B, 0x00747474, 0x006B6A6C, 0x00616062, 0x0069686A, 0x00908F91, 0x00ABAAAC, 0x00C5C4C6, 0x00D7D6D8, 0x00E1E0E2, 0x00DEDEDE, 0x00D7D7D7, 0x00D0D0D0, 0x00C9C9C9, 0x00BDBDBD, 0x00A5A5A5, 0x00848484, 0x00616161, 
        0x00464646, 0x00323232, 0x00383838, 0x004A4A4A, 0x005A5A5A, 0x006A6A6A, 0x007A7A7A, 0x008C8C8C, 0x11ACACAC, 0x7AC5C5C5, 0xECD6D6D6, 0xFFE3E3E3, 0xFFEEEEEE, 0xFFF5F5F5, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF1F1F1, 0xFFEBEBEB, 0xFFE1E1E1, 0xFAD6D6D6, 
        0xB0C2C2C2, 0x3AA5A5A5, 0x00888888, 0x007C7C7C, 0x00747375, 0x006C6B6D, 0x00626163, 0x005B5A5C, 0x00525153, 0x0049484A, 0x00414042, 0x003A393B, 0x003B3B3B, 0x00393939, 0x00303030, 0x00212121, 0x00111111, 0x00060606, 0x00000000, 0x00010101, 
        0x00090909, 0x00171717, 0x00282828, 0x00383838, 0x00494949, 0x005E5E5E, 0x13929292, 0x72BFBFBF, 0xDFD5D5D5, 0xFFDFDFDF, 0xFFECECEC, 0xFFF3F3F3, 0xFFF7F7F7, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFF6F6F6, 0xFFF1F1F1, 0xFFE9E9E9, 
        0xFFDFDFDF, 0xFFD7D7D7, 0xC7CACACA, 0x66AEAEAE, 0x1C919092, 0x00767577, 0x006C6B6D, 0x00626163, 0x005B5A5C, 0x00525153, 0x0049484A, 0x00424143, 0x003A3A3A, 0x00313131, 0x00282828, 0x00212121, 0x00181818, 0x000F0F0F, 0x00080808, 0x00010101, 
        0x00010101, 0x00090909, 0x001D1D1D, 0x06585858, 0x3C969696, 0x9AC8C8C8, 0xECD6D6D6, 0xFFE1E1E1, 0xFFE9E9E9, 0xFFF0F0F0, 0xFFF6F6F6, 0xFFF7F7F7, 0xFFFAFAFA, 0xFFF9F9F9, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 
        0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF5F5F5, 
        0xFFF2F2F2, 0xFFEBEBEB, 0xFFE4E4E4, 0xFFDCDCDC, 0xF5D6D6D6, 0xC0CACACA, 0x79B2B2B2, 0x3E989898, 0x12808080, 0x00696969, 0x00555555, 0x004A4A4A, 0x00434343, 0x00393939, 0x00313131, 0x00292929, 0x001F1F1F, 0x001C1C1C, 0x00292929, 0x04424242, 
        0x27636363, 0x55949494, 0xA1C6C6C6, 0xDDD5D5D5, 0xFFDDDDDD, 0xFFE4E4E4, 0xFFEBEBEB, 0xFFF2F2F2, 0xFFF6F6F6, 0xFFF9F9F9, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 
        0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFCFCFC, 
        0xFFFCFCFC, 0xFFFAFAFA, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF1F1F1, 0xFFEEEEEE, 0xFFECECEC, 0xFFEAEAEA, 0xF9E7E7E7, 0xD8E5E5E5, 0xBAE2E2E2, 0xA2DADADA, 0x8FD0D0D0, 0x84CBCBCB, 0x81CACACA, 0x89CBCBCB, 0x98D5D5D5, 0xADE3E3E3, 0xC9E6E6E6, 0xEAE7E7E7, 
        0xFFEBEBEB, 0xFFEDEDED, 0xFFEEEEEE, 0xFFF3F3F3, 0xFFF5F5F5, 0xFFF8F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 
        0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP bmknob_gray_trans_70x70 = {
  70, // xSize
  70, // ySize
  280, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acknob_gray_trans_70x70,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       Backgound 480x272
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsBackGround_480x272[] = {
  0x000000, 0xE1DCDD, 0xDDD9D9, 0xE5E1E1,
  0xD9D5D5, 0xD6D1D1, 0xE9E5E5, 0xB5ADAD,
  0xB1A9A9, 0xE4DEE0, 0xE0DADC, 0xADA5A5,
  0xA9A1A1, 0xA19999, 0xA59D9D, 0xCEC8C8,
  0xBEB9B8, 0xCECAC8, 0xCCC8C6, 0xD0CCCA,
  0xCAC6C4, 0xCCC6C6, 0xE8E2E4, 0xD2CCCC,
  0xCAC4C4, 0xC4BEBE, 0xD0CACA, 0xD2CECC,
  0x9D9595, 0xD4CECE, 0xC8C2C2, 0xD4D0CE,
  0xC8C4C2, 0xC6C2C0, 0xC6C0C0, 0xDCD6D8,
  0xC5C0BE, 0xC0BABA, 0xC2BCBC, 0xB8B0B0,
  0xC2BEBC, 0xC1BCBA, 0x89807D, 0xBAB5B4,
  0xBAB2B2, 0x9A9191, 0xD8D4D2, 0x8D8481,
  0x867D7A, 0xD2CECE, 0x827875, 0x918886,
  0xBCB6B6, 0x7E7471, 0xBCB4B4, 0xD8D2D2,
  0xBDB8B6, 0x796E6C, 0xBEB6B6, 0x766A68,
  0x958C8A, 0xD8D2D4, 0x786C6A, 0x968D8C,
  0x746866, 0xB8B2B2, 0xD0CCCC, 0x7D7270,
  0xC0B8B8, 0x7C716E, 0x7A706D, 0x726664,
  0x908684, 0xB6B0B0, 0x807674, 0x948A89,
  0x706462, 0x8C8280, 0xB9B4B2, 0x887E7C,
  0x99908E, 0xEAE8E8, 0xECE9E9, 0x847A78,
  0x988E8D, 0xDCD6D6, 0x928988, 0x9C9492,
  0x6E6260, 0xC0BAB8, 0xBCB6B4, 0xE6E2E4,
  0x9C9292, 0x6C605E, 0xC2BABA, 0xDCD8D6,
  0xE6E4E4, 0xB8B2B0, 0xEAE6E8, 0xCECACA,
  0x766C69, 0xB6B0AE, 0xD4CED0, 0x807572,
  0x6A5E5C, 0xC4BEBC, 0xA09696, 0xA09896,
  0xE0DADA, 0xB2ACAC, 0x8E8584, 0xCCC8C8,
  0xECE6E8, 0xC4BCBC, 0x665A58, 0xD2CDCE,
  0xB2ACAA, 0xA49C9A, 0x726865, 0xD0CAC9,
  0xCBC6C6, 0xC3BEBE, 0x8A8180, 0xAEA8A8,
  0x685C5A, 0xC5C0C0, 0x9E9896, 0xC8C2C0,
  0xCAC4C3, 0x847976, 0xE8E2E2, 0x645856,
  0xD7D4D2, 0xE3DEE0, 0xD2CCCB, 0xC1BCBC,
  0xA49A9A, 0xDBD6D8, 0xAEA8A7, 0xC6BEBE,
  0xDFDADC, 0xAAA4A4, 0xC9C4C4, 0xA8A09E,
  0xC7C2C2, 0xCEC8C7, 0xE4DEDF, 0xA39C9A,
  0xB8AFAF, 0xCCC6C5, 0xBAB1B1, 0xE0DCDB,
  0xD7D2D4, 0x887E7B, 0x6E6461, 0xD0CBCC,
  0xD6D0CF, 0xD3D0CE, 0x625654, 0xA7A09E,
  0xB0A8A7, 0x877E7C, 0x908683, 0xDBD8D6,
  0x7F7674, 0x8C827F, 0x9F9898, 0xABA4A2,
  0xACA4A3, 0xB8AFB0, 0xBCB3B3, 0xBAB3B4,
  0xBCB5B6, 0xC0B9BA, 0xD1CECC, 0x605452,
  0x7C6F6D, 0xA39C9C, 0xABA3A4, 0xB0A7A7,
  0x837A78, 0x948A87, 0x97908D, 0x9B9492,
  0xA09798, 0xACA3A2, 0xACA3A4, 0xB4ABAB,
  0xBEB5B5, 0x746765, 0x998F90, 0x9F9798,
  0xA39B9C, 0xB4ABAC, 0xBAB1B2, 0x7B7270,
  0x988E8B, 0x9C9394, 0xA89E9E, 0xBCB3B4,
  0xBEB5B6, 0xC2B9BA, 0xE3E0E0, 0xA7A0A0,
  0xB6AFB0, 0xC8C1C0, 0xCEC9CA, 0xA49B9C,
  0xB8B0AE, 0xBAB2B1, 0xB8B1B2, 0xBEB7B8,
  0xC0B7B7, 0xC2B9B9, 0xE9E8E7, 0x786B69,
  0xA89FA0, 0x706361, 0xB4ACAB, 0xCAC2C2,
  0xD3CED0, 0xB2ABAC, 0xCCC7C8, 0xDBD8D8,
  0x958B8C, 0x9B9494, 0xA79FA0, 0xB0A7A8,
  0xBCB4B3, 0xCFCCCB, 0xE6E4E3, 0xECE6E7,
  0x6C5F5E, 0x807372, 0x938C89, 0x9B9394,
  0xBEB6B5, 0xC0B8B7, 0xC2BAB9, 0xC4BCBB,
  0xC1BBBC, 0xCDCAC9, 0xDFDCDB, 0xDFDCDC,
  0x5F5351, 0x8F8885, 0x918788, 0x979090,
  0xAFA7A8, 0xC0B7B8, 0xC1BEBD, 0xC5C2C0,
  0xCBC5C6, 0xD3D0D0, 0xD7D4D4, 0xE4E0DF
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalBackGround_480x272 = {
  256,  // Number of entries
  0,    // No transparency
  &_ColorsBackGround_480x272[0]
};

static GUI_CONST_STORAGE unsigned char _acBackGround_480x272[] = {
  0xAA, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0xD4, 0xD4, 0x44, 0xD5, 0xAD, 0x25, 0x25, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 
        0x12, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x80, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x1D, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x1D, 
        0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x17, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1B, 
        0x31, 0x9D, 0x1B, 0xAE, 0xAE, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x19, 
        0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0xED, 0x3A, 0x3A, 0xBC, 0x36, 0x36, 0xAA, 0xAA, 0x2C, 0xD1, 0xD1, 0x96, 0x27, 0x94, 0x07, 0x07, 0x07, 0xC1, 0x07, 0x07, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xB2, 
        0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0xC6, 0x75, 0x93, 0x0D, 0x6B, 0x6B, 0x6B, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0xB7, 0x2D, 0x2D, 0x5C, 0x5C, 0x2D, 0x57, 0x57, 0xB7, 0x57, 0x57, 0x2D, 0x5C, 0x5C, 0x57, 0x57, 0x2D, 0x2D, 0x50, 0x2D, 
        0x2D, 0x2D, 0x50, 0x2D, 0x50, 0xB6, 0xF7, 0xF7, 0xB6, 0x54, 0x3F, 0x3F, 0x54, 0x3F, 0xE0, 0x3C, 0x4B, 0x56, 0x56, 0x33, 0x33, 0x33, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x4F, 0x99, 0x30, 0x53, 0xB4, 0x32, 0x32, 0xA4, 0x35, 0x35, 0x43, 0xC3, 0x46, 
        0x46, 0xB0, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0xB0, 0xB0, 0xB0, 0x46, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 
        0x45, 0x45, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x39, 0x3E, 0x39, 0x3E, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0x3B, 0x3B, 0xD7, 0xD7, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x3B, 0x40, 0x40, 0x40, 0xBD, 0x40, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x36, 0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0xD4, 0x44, 0x10, 0xAD, 0xAD, 0x25, 0xF0, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x22, 0x21, 0x21, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x8E, 0x8E, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x13, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x1B, 0x1B, 0x17, 0x17, 0x1B, 
        0x1B, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0xAE, 0x42, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x11, 0x77, 0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 
        0x24, 0x24, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0xED, 0x10, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xAC, 0xBC, 0xEC, 0xAC, 0x36, 0x2B, 0xAB, 0xAA, 0xAB, 0xAB, 0x2C, 0x2C, 0x96, 0x27, 0x94, 0x07, 0x07, 
        0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x8A, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x9F, 0x9F, 0x9F, 0x0E, 0x75, 0x75, 0x93, 0x0D, 0x6B, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x5C, 0x2D, 0x50, 0x50, 0xC4, 0xC4, 
        0x3C, 0x3C, 0x4B, 0xB5, 0xB5, 0x33, 0x33, 0xF5, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0xB4, 0x53, 0x53, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 
        0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0xA4, 0x67, 0x67, 0x35, 0x35, 0x43, 0x43, 0x45, 0x46, 0x46, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x40, 
        0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x58, 0x9A, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x4C, 0x4C, 0x4C, 0xD9, 0x4C, 0x4C, 0x4C, 0xD9, 0xD9, 0xD9, 0x58, 
        0x58, 0x58, 0x58, 0x5D, 0x5D, 0x68, 0x68, 0x68, 0x68, 0x68, 0x7C, 0x7C, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83,
  0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0xD5, 0xD5, 0xD5, 0xC9, 0xC9, 0xC9, 0xEF, 0x26, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x24, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xCD, 0xCD, 0x7F, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x3D, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0xAE, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x90, 
        0x21, 0x22, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x34, 0xAC, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0x2C, 0x96, 0x96, 0x96, 0x27, 0x94, 0x94, 0x94, 0x07, 0x07, 
        0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0x0B, 0x0B, 0x0B, 0x0B, 0xB2, 0x0C, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0x93, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x57, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 
        0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0xB5, 0xB5, 0xB5, 0x56, 0x56, 0x33, 0x33, 0x33, 0xF5, 0x6E, 0x6E, 0x2F, 0x2F, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x53, 0x53, 0x30, 
        0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xB4, 0xB4, 0x32, 0x32, 0x4A, 0xA4, 0x67, 0x35, 0x35, 0x43, 0x43, 0x45, 0x45, 0xB0, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 
        0x3E, 0x3E, 0x3E, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x76, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0xD9, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 
        0x58, 0x58, 0x5D, 0x58, 0x58, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x7C, 0x7C, 0x7C, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0x44, 0x44, 0xAD, 0xD5, 0x25, 0x25, 0x5E, 0x5E, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x22, 0xCD, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 
        0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x84, 0x05, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0xAE, 0x17, 0x86, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 
        0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x29, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x34, 0x34, 0xAC, 0x2B, 0xAB, 0x2C, 0x2C, 0x2C, 0x96, 0x27, 0x27, 0xCC, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x93, 0x0D, 0x0D, 0xA6, 0x6B, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0x50, 
        0x54, 0xC4, 0x3C, 0x3C, 0x4B, 0x56, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0x53, 0x32, 0x32, 0x32, 0x32, 0x67, 0x35, 0x35, 0x43, 0x45, 0xB0, 0xB0, 0x39, 0x3E, 0x3E, 
        0xD7, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x40, 0x3B, 0x3B, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xBD, 0x40, 0x40, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9,
  0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0xAD, 0xD5, 0xD5, 0xD5, 0xAD, 0xAD, 0x25, 0x29, 0x26, 0x26, 0xEF, 0x26, 0x26, 0x26, 
        0x19, 0x19, 0x19, 0x8B, 0x22, 0x22, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 
        0x77, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x1D, 0x1B, 0x9D, 0x1D, 0x1B, 0x9D, 0x1D, 0x1B, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 
        0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x9D, 0x1D, 0x1B, 0x1B, 0x17, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x21, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 
        0x26, 0x29, 0x25, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x44, 0x44, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0xD3, 0x3A, 0x34, 0x34, 0x3A, 0x34, 0x34, 0x34, 0x38, 0xEC, 0x34, 0x34, 0xAC, 0x2B, 0x36, 0x36, 0xAA, 0xAB, 0xAB, 0x2C, 0x96, 0x96, 
        0x96, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x9F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x93, 0xC0, 0x93, 0x88, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0xB8, 0xB8, 0xB8, 0x7E, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x5C, 0x2D, 0x50, 0x50, 0x54, 0x54, 0xC4, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 
        0x2A, 0x2A, 0x99, 0x99, 0x30, 0x30, 0x53, 0x32, 0x32, 0x32, 0xA4, 0x35, 0x35, 0x45, 0x45, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0xD7, 0x64, 0xD7, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0x64, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0x47, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x40, 0x40, 
        0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47,
  0x44, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x44, 0x44, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x5E, 0x5E, 0xC9, 0xD5, 0x5E, 0x5E, 0xD5, 0x5E, 0x5E, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0xD5, 0x10, 0xD5, 0xD5, 0xD5, 0x5E, 0x5E, 0x5E, 0x5E, 0x29, 
        0x29, 0x29, 0xF0, 0xF0, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x79, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 0x86, 0xAE, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0x17, 0x17, 0x1B, 0x17, 0x1B, 0x1B, 
        0x9D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x17, 0x17, 0x17, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x80, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 
        0x26, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0xD4, 0x3A, 0x38, 0x34, 0xBC, 0xAC, 0xAC, 0x36, 0x36, 0xAC, 0x2B, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0xE4, 0xAA, 
        0xAA, 0x96, 0x96, 0x2C, 0x96, 0x27, 0x27, 0x27, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0x9F, 0x0E, 0xB1, 0x93, 0x0D, 0x0D, 0x6B, 0x6A, 0x1C, 0xEB, 0x2D, 
        0x2D, 0x50, 0x54, 0x3F, 0x3C, 0x3C, 0x4B, 0x4B, 0xEA, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x6E, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 
        0x2A, 0x2A, 0x2A, 0xA1, 0x30, 0x30, 0x30, 0xB4, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x46, 0x45, 0x45, 0x46, 0x46, 0xB0, 0x46, 0xB0, 0xB0, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x43, 0x35, 
        0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0xB0, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0xBD, 0xBD, 0xBD, 
        0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x58, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0x5D, 0x68, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x5D, 0x5D, 0x5D, 0x5D, 0x58,
  0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0x44, 0xD5, 0xD5, 0xAD, 0x5E, 0x26, 0x26, 0x5E, 0x5E, 0x5E, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x5E, 0x5E, 0x25, 0x25, 0x5E, 0x26, 0x5E, 0x25, 0x25, 0x5E, 0x26, 0x26, 0xEF, 0x26, 
        0x26, 0xEF, 0xEF, 0xEF, 0x26, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x22, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 
        0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x9D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1F, 0x1F, 0x9D, 0x1F, 0x1F, 
        0x1F, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x9D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x80, 0x90, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 
        0x19, 0x79, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0xEF, 0x29, 0x25, 0xAD, 0xAD, 0x44, 0x44, 0xD3, 0x34, 0x2B, 0xAA, 0xAA, 0x2C, 0x96, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 
        0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x75, 0xC0, 0x0D, 0xA6, 0xA6, 0x7E, 0x1C, 0x57, 0x57, 0x2D, 0x50, 0x50, 0xB6, 0x3F, 0x3C, 0x3C, 
        0x4B, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x48, 0x48, 0x33, 0x33, 0x48, 0x48, 0x48, 0x48, 0xA2, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 
        0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0xA4, 0xA4, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x43, 0x43, 0x43, 
        0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0xA4, 0x4A, 0x4A, 0xA4, 0xA4, 0xA4, 0x35, 0x67, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x45, 0x43, 0x45, 0x45, 0x45, 0x45, 0xB0, 0xB0, 0x39, 0x39, 0x39, 0x3E, 
        0x3E, 0xD7, 0xD7, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x4C, 0x4C, 0xD9, 0x58, 0x58, 0x58, 0xE8, 0xE8, 0xE8, 0x68, 0x68, 0x7C, 0x7C, 0x7C, 0x72, 0x72, 0x72,
  0x96, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0xD3, 0xD4, 0xD3, 0x10, 0x10, 0xAD, 0x25, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 
        0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x22, 0x7D, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1F, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 
        0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x18, 0x14, 
        0x80, 0x8E, 0x80, 0x20, 0x20, 0x1E, 0x80, 0x80, 0x90, 0x90, 0x90, 0x21, 0x21, 0xCD, 0x22, 0x22, 0x22, 0x24, 0x19, 0x19, 0x69, 0x69, 0x26, 0xEF, 0x26, 0x5E, 0xEE, 0xD5, 0xAD, 0x10, 0x44, 0xD3, 0xD3, 0x38, 0x34, 0x34, 0xAC, 0x2B, 0xAB, 0x4E, 0x41, 
        0x41, 0xD2, 0x27, 0x49, 0xCC, 0x07, 0x07, 0x6D, 0x6D, 0xDA, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0x9F, 0x9F, 0x0E, 0x0E, 0x0E, 0xB1, 0x93, 0x93, 0x93, 0x93, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 
        0x57, 0x57, 0x57, 0x57, 0x57, 0x2D, 0x50, 0x50, 0x50, 0x54, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0x33, 0x33, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x53, 0xB4, 0xB4, 
        0x32, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0xC3, 0x43, 0x43, 0x43, 0x45, 0x45, 0x43, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 
        0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x45, 0x46, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x76, 0xBD, 0xBD, 0xBD, 0x76, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 
        0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0xBD, 0xBD, 0x47, 0x47, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD,
  0xAD, 0xAD, 0xAD, 0xAD, 0x10, 0x44, 0x44, 0x10, 0x44, 0xD4, 0x44, 0x44, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0x44, 0xD5, 0xD5, 0xEE, 0x5E, 0x5E, 0x5E, 0x29, 0x87, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x79, 0x24, 0x24, 0x21, 0x21, 
        0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 
        0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x5F, 0x23, 0x23, 0x5F, 0xDF, 0x23, 
        0xDF, 0x5F, 0x5F, 0xA3, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0xFD, 0x1F, 0x9C, 0x1F, 0x1F, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 
        0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x29, 0x25, 0x25, 0x10, 0x10, 0x44, 0x10, 0xD3, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x36, 0x36, 0x36, 0x36, 0xE4, 0xE4, 
        0x2C, 0xAB, 0x2C, 0x2C, 0x2C, 0xD1, 0xD2, 0xD2, 0xD2, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x74, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xD8, 0xE2, 0x0E, 0x0E, 0x0E, 0xC0, 0x0D, 0x0D, 0x6B, 0x7E, 
        0x1C, 0x1C, 0xC5, 0x57, 0x5C, 0x2D, 0x50, 0x54, 0xB6, 0xC4, 0x3F, 0x3C, 0x3C, 0xEA, 0xEA, 0x4B, 0x4B, 0xEA, 0xB5, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x2F, 0x2F, 0x2F, 0x4D, 
        0xA5, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0x35, 0x35, 0x35, 0x43, 0x43, 0xC3, 0x45, 0x45, 0x45, 0x46, 0x45, 0x46, 0x46, 0x46, 0x46, 0x46, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 
        0x3E, 0x64, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0x76, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0xD9, 0xD9, 0xD9, 
        0x58, 0x58, 0x58, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x68, 0xE8, 0xE8, 0xE8, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68,
  0x2B, 0x2B, 0xBC, 0x2B, 0x2B, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x25, 0x25, 0x25, 0x5E, 0x25, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 
        0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x77, 0x77, 0x77, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x05, 0x05, 0x84, 0x05, 0x05, 0x2E, 0x2E, 0x2E, 0x05, 0x05, 0x05, 0x84, 0x84, 0x37, 0x37, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x9D, 0x1D, 0x1D, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x59, 0x10, 0x10, 0x10, 0x38, 0x34, 0xBC, 0x36, 
        0xAA, 0xAA, 0x2C, 0x96, 0x96, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0x6D, 0x6D, 0xDD, 0x08, 0x08, 0x08, 0x7B, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8D, 0xA7, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xD8, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 
        0xC0, 0x0D, 0x0D, 0x0D, 0x6A, 0x1C, 0x1C, 0xC5, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x54, 0x54, 0x3F, 0x3F, 0x3C, 0xEA, 0xB5, 0x56, 0x33, 0x33, 0x48, 0xA2, 0x6E, 0x6E, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0x7A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 
        0x99, 0x30, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0x53, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x43, 0x45, 0x45, 0x46, 
        0x39, 0x39, 0x3E, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 
        0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0xD9, 0x4C, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0xD9, 0x4C, 0x9A, 0x9A, 0x4C, 0x4C, 0x4C, 0x4C,
  0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0x36, 0x36, 0x36, 0x3A, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0x10, 0x10, 0x44, 0x10, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 
        0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x73, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x1D, 
        0x1F, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x9C, 0x9C, 0x1F, 0x1D, 0x9C, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x2E, 0xFE, 0x3D, 0x3D, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x37, 0x05, 0x05, 0x05, 0x1D, 0x9D, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x79, 0x26, 0x29, 0x29, 0x26, 0x26, 0x29, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0xAD, 0x44, 0x44, 0x10, 
        0x3A, 0xBC, 0x36, 0x36, 0x2B, 0xAB, 0x96, 0x27, 0x27, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0x9F, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0xBF, 0x6A, 0x7E, 
        0x1C, 0x1C, 0x1C, 0xC5, 0xB7, 0xEB, 0xEB, 0xB7, 0xEB, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0x5C, 0xB7, 0xB7, 0x2D, 0x5C, 0x2D, 0x5C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x50, 0xBE, 0x50, 0x3F, 0x3F, 0x3C, 0x3C, 0x4B, 0x56, 0x33, 0x33, 0x6E, 0x2F, 0x2F, 0x4D, 
        0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0x53, 0x53, 0x81, 0x81, 0x32, 0x32, 0x4A, 0x4A, 0x67, 0x67, 0x35, 0x35, 0x35, 0x43, 0x45, 0x45, 0x45, 0x46, 0x46, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x76, 0xBD, 0xBD, 0xBD, 0x47, 
        0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0xBD, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x64, 0x64, 0xD7, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x46, 0xB0, 0x46, 0x46, 0xB0, 0x46, 0x46, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 0xD7, 0xD7, 0x3B, 
        0x3B, 0x3B, 0x40, 0xBD, 0x47, 0x47, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0xE8, 0xE8, 0xE8, 0x68, 0x68, 0x68, 0x68, 0x68, 0x7C, 0x68, 0x7C, 0x68, 0x68, 0x7C,
  0xC1, 0x07, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x2C, 0x2C, 0x96, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x3A, 0x10, 0x10, 0x10, 0xAD, 0xAD, 0xAD, 0x29, 0x29, 0xEF, 
        0x26, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 
        0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x9D, 0x9D, 0x1D, 0x9C, 0x1D, 0x1D, 0x9C, 0x1D, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 
        0x1D, 0x1D, 0x1F, 0x1D, 0x1F, 0x1F, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x84, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x9C, 0x1F, 0x1F, 0x1D, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x78, 0x78, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 
        0x90, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x79, 0x79, 0x26, 0x26, 0x29, 0x29, 0x29, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0xD5, 0xAD, 0x25, 0x10, 0x44, 0x10, 0x44, 0x10, 0xED, 0xD4, 0xD4, 0xD3, 0xD3, 
        0x34, 0xAC, 0xAC, 0x36, 0xE4, 0xE4, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x94, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 
        0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0xB8, 0x6A, 0x6A, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0xC5, 0xC5, 0x57, 0x5C, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x54, 0x3F, 0x3F, 0x3C, 0x4B, 0x4B, 0x56, 0x33, 0x48, 0x6E, 0x6E, 0x2F, 0x4D, 0xA5, 
        0x7A, 0x2A, 0x99, 0x30, 0x53, 0xB4, 0x81, 0x32, 0x32, 0x4A, 0x4A, 0x67, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0xC3, 0x43, 0x43, 0xC3, 
        0x43, 0x43, 0x43, 0x45, 0x45, 0xC3, 0xC3, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0xC3, 0xC3, 0x45, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x40, 0xBD, 0xBD, 0x47, 0x47, 
        0x4C, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0xE8, 0x5D, 0x5D, 0xE8,
  0x27, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0xD4, 0x44, 0x44, 0x44, 0xD5, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x69, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 
        0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 
        0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x04, 0xA3, 0xA3, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 
        0x90, 0x90, 0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0x25, 0x25, 0xAD, 0xAD, 0xAD, 0x10, 0xAD, 0x10, 0x10, 0x10, 0xD3, 0x34, 0x34, 
        0xAC, 0xAC, 0xAC, 0x36, 0x2B, 0x4E, 0x96, 0x27, 0x94, 0xCC, 0x07, 0x07, 0x6D, 0xBB, 0xDD, 0x08, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0xBA, 0xB2, 0xB9, 0x0C, 0x0C, 0x0C, 0xCB, 0xD8, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x75, 0x75, 0xB1, 0x75, 0x93, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0x2D, 0x2D, 0x50, 0x50, 0x3F, 0x3F, 0x3C, 0xB5, 0x33, 0x48, 0xA2, 
        0x2F, 0x4D, 0xA5, 0x2A, 0x99, 0x30, 0x53, 0x53, 0x81, 0x32, 0x4A, 0x4A, 0x67, 0x35, 0x35, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46, 0x46, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x64, 0x3B, 0x3B, 0x64, 
        0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x64, 0xD7, 0xD7, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x46, 0x46, 0x46, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46, 0x46, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x40, 0x40, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47,
  0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0xCD, 0xCD, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x21, 0x21, 0x21, 
        0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x19, 0x19, 0x22, 0x24, 0x22, 0x22, 0x24, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x84, 
        0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 
        0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x22, 0x8B, 0x19, 0x19, 0x19, 0x26, 0x26, 0x29, 0x25, 0x25, 0x10, 0x10, 0x34, 0x34, 0x5A, 0x36, 0xE4, 0x4E, 
        0xC2, 0x96, 0x27, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0x08, 0xA0, 0x8A, 0x8A, 0x08, 0xA0, 0xA0, 0x8A, 0x8A, 0x7B, 0x7B, 0x8A, 0x8A, 0x8A, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0xA7, 
        0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0x93, 0x0D, 0x0D, 0xA6, 0x6A, 0x1C, 0x1C, 0x57, 0xB7, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x54, 0x54, 0x54, 0xC4, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x4D, 0x4D, 
        0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x67, 0x35, 0x35, 0x35, 0x43, 0x43, 0x45, 
        0xB0, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 
        0xBD, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0xBD, 0xBD, 0xBD, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0xD7, 0x39, 0x39, 0x39, 0x39, 0xB0, 0xB0,
  0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAD, 0x44, 0x44, 0xAD, 0xEE, 0xEE, 0xD5, 0x25, 0x25, 0x25, 0x25, 0x5E, 0x5E, 0x26, 0x26, 0x26, 0xEF, 0xEF, 0xEF, 0xEF, 0xEF, 0x71, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 
        0x19, 0x24, 0x22, 0x24, 0x7D, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x91, 
        0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 
        0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x9D, 0x9C, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x9C, 0x1F, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0xFE, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x98, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x9C, 0x1D, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x77, 0x0F, 0x0F, 0x12, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0xAD, 0x10, 0x10, 0x10, 0x38, 0xD3, 0x34, 0x34, 0x34, 0x34, 0xBC, 0xAC, 0x2B, 
        0x36, 0x36, 0xAA, 0x2C, 0x2C, 0x27, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0x6D, 0xBB, 0xBB, 0xDD, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0x7B, 0x8A, 0xB3, 0xF8, 0x0B, 0x8A, 0xB3, 0x0B, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 
        0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0xC0, 0x0D, 0xA6, 0xA6, 0x6A, 0x1C, 0x1C, 0xC5, 0xEB, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x54, 0xC4, 0xC4, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 0xA2, 0xA2, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0xB4, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0xC3, 0x46, 0x46, 0x39, 0x39, 0x3E, 0x64, 0x3B, 
        0x3B, 0x3B, 0xBD, 0xBD, 0x47, 0x47, 0x4C, 0x9A, 0x4C, 0x4C, 0x4C, 0xD9, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0xD7, 0xD7, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 
        0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x46, 0x46, 0xB0, 0xB0, 0xB0, 0x45, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35,
  0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0xD4, 0x10, 0x44, 0x44, 0xD5, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x24, 0x24, 
        0x19, 0x24, 0x8B, 0x8B, 0x8B, 0x8B, 0x24, 0x24, 0x22, 0x24, 0x7D, 0x7D, 0x21, 0xCD, 0x90, 0xCD, 0x90, 0x90, 0x1E, 0x1E, 0xDB, 0x80, 0x20, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0xAE, 0xAE, 0x17, 0x86, 0x17, 0x86, 0xAE, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 
        0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x9C, 0x9C, 0x1F, 0x1D, 0x1B, 0x9D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x9B, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0xCE, 0x0F, 0x91, 0x12, 0xDE, 0x12, 0x12, 0x78, 
        0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0xAD, 0xAD, 0x44, 
        0xED, 0xD3, 0x3A, 0xEC, 0x36, 0x36, 0xAB, 0x2C, 0xD2, 0xD2, 0x27, 0x94, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 
        0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0xB1, 0xC0, 0xC0, 0x0D, 0xB8, 0x6A, 0x1C, 0x1C, 0xB7, 0x2D, 0x2D, 0x50, 0xB6, 0xC4, 0x3C, 0x3C, 0x3C, 0x4B, 0xB5, 0x56, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0x6E, 0x2F, 0x2F, 0x2F, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 
        0x53, 0x53, 0x81, 0x32, 0x32, 0x4A, 0x4A, 0x67, 0x35, 0x35, 0x35, 0x43, 0xC3, 0x46, 0x46, 0xB0, 0x46, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x76, 0x76, 0xBD, 0x76, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x4C, 
        0x9A, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0xE8, 0x68, 0x68, 0x68, 0x68, 0x7C, 0x7C, 0x7C, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72,
  0xBC, 0x3A, 0x34, 0x34, 0x3A, 0xD4, 0xD3, 0xD3, 0xD4, 0xD4, 0xD4, 0x44, 0xED, 0x10, 0xAD, 0xAD, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xAD, 0x44, 0x44, 0x10, 0xED, 0xED, 0xD3, 0xD4, 0x10, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0xD4, 0xD4, 0x44, 
        0x44, 0x44, 0xD5, 0xAD, 0xAD, 0xD5, 0x25, 0x25, 0x5E, 0x29, 0x87, 0x26, 0x26, 0x71, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0xCD, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x55, 0x04, 0xA3, 0xA3, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 
        0x91, 0x91, 0x12, 0x78, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x24, 0x24, 0x19, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x38, 0x34, 0x36, 
        0x36, 0x2B, 0xE4, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x27, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x07, 0x07, 0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 
        0xA8, 0xB2, 0xB2, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x75, 0xC0, 0x0D, 0x0D, 0xA6, 0x6A, 0x1C, 0x57, 0x5C, 0x2D, 0x50, 0xC4, 0xC4, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0x81, 0x81, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x67, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 
        0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x45, 0xB0, 0xB0, 0x46, 0x46, 0x46, 0x46, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 
        0x39, 0x39, 0x39, 0xB0, 0x46, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0xD9, 0x58, 0x58, 0x58,
  0xAA, 0xAA, 0x2B, 0x2B, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2B, 0xBC, 0x36, 0x2B, 0x34, 0x34, 0xAC, 0x34, 0x34, 0xD3, 0xD3, 0x10, 0x44, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0xD5, 0xEE, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0xD5, 0xD5, 0x5E, 
        0xC9, 0xD5, 0x5E, 0x5E, 0xD5, 0xD5, 0x25, 0x25, 0xAD, 0x25, 0x25, 0x29, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x84, 0x2E, 0x2E, 0x37, 0x37, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x05, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 
        0x1F, 0x05, 0x05, 0x9C, 0x05, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1B, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x22, 0x22, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x26, 0x79, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0xD3, 0xD3, 
        0x38, 0x34, 0xAC, 0xAC, 0x2B, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0xE4, 0xE4, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 
        0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xB8, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 
        0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0xB6, 0x3F, 0xE0, 0x3C, 0xEA, 0x56, 0x56, 0x33, 0x33, 0x48, 0x6E, 0x6E, 0x4D, 0x4D, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x53, 0x32, 0x32, 0x32, 0x4A, 0x67, 0x35, 0x35, 0x35, 0x43, 0x45, 0x45, 0x45, 0x45, 0x46, 
        0x46, 0x46, 0x46, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x3E, 0x3E, 0x3E, 0x39, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3E, 0x3E, 0xD7, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 
        0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x4C, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x5D,
  0x08, 0x08, 0x08, 0xBB, 0xBB, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0xA9, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0x36, 0xBC, 0xBC, 0x3A, 0xD3, 0xD4, 0x44, 0x10, 0xAD, 0x25, 0x29, 0xF0, 0xF0, 0xF0, 0x26, 0x26, 0x69, 0x19, 
        0x19, 0x19, 0x24, 0x24, 0x22, 0x22, 0x21, 0xCD, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x14, 0x14, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 
        0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x17, 0x86, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0xAE, 
        0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x1D, 0x1F, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x3D, 0x2E, 0x2E, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x55, 0x04, 0x89, 0x89, 0xA3, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x11, 0xF1, 0x0F, 0x91, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x14, 0x14, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 
        0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x22, 0x22, 0x22, 0x22, 0x24, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0xEE, 0x44, 0x44, 0x38, 0x34, 0xAC, 0xAA, 0x2C, 0x2C, 0x96, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xB3, 0x0B, 0x0B, 0xA8, 0x0C, 0x0C, 0x0C, 
        0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x75, 0x75, 0xCF, 0xC0, 0x88, 0x88, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0x50, 0x54, 0x3F, 0x3C, 0x3C, 0xEA, 0x56, 0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x56, 0x33, 0x56, 0x56, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x56, 0x56, 0x56, 0x33, 0x33, 0x33, 0x48, 0x6E, 0x2F, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x53, 0x53, 0x32, 0x32, 0x4A, 0x4A, 0x67, 0x35, 0x35, 0x43, 0x43, 
        0x43, 0x45, 0x46, 0x46, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x64, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0xD7, 0xD7, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0xB0, 0xB0, 
        0x46, 0xB0, 0x46, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x40, 0xBD, 0x47, 0x47, 0x4C, 0xD9, 0x58, 0x58, 0x58, 0x5D, 0xE8, 0xE8, 0xE8, 0x68,
  0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x2C, 0xAA, 0x36, 0x36, 0xBC, 0x3A, 0xD4, 0xD4, 0xD4, 0x44, 0xD5, 0xD5, 0x5E, 0x26, 0xEF, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x80, 
        0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0xFC, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 
        0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x84, 0x84, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x9C, 0x1F, 0x9C, 
        0x1D, 0x1D, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 
        0x84, 0x84, 0x84, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x9D, 0x1F, 0x1F, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x17, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x21, 0x24, 0x19, 0x19, 0x19, 0x19, 0x28, 0x26, 
        0x26, 0x26, 0x26, 0x25, 0xD5, 0x44, 0x44, 0x44, 0xD4, 0x3A, 0xEC, 0xBC, 0x36, 0xAA, 0x2C, 0x2C, 0xD2, 0x27, 0x94, 0x94, 0x65, 0x07, 0x07, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 
        0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0x9F, 0x9F, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x75, 0x88, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0xB8, 0x7E, 0x1C, 0x1C, 0x1C, 0x57, 0xC5, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0xB6, 0x54, 0x54, 0xC4, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0xEA, 
        0x56, 0x33, 0x33, 0x33, 0x48, 0xA2, 0x6E, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x43, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x43, 0x45, 0x43, 0x43, 0x45, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0xD7, 0xD7, 
        0x64, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0xBD, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0xBD, 0x40,
  0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0x36, 0x36, 0x36, 0xBC, 0x3A, 0x3A, 0x3A, 0x10, 0x44, 0x44, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x24, 0x7D, 0x21, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x20, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x1A, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x9D, 0x1B, 0x9D, 0x1D, 0x9D, 0x9D, 0x1D, 0x9D, 0x1B, 0x1D, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x84, 0x84, 0x84, 0x84, 
        0x05, 0x05, 0x05, 0x9C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x9D, 0x1D, 0x9D, 0x9D, 0x9D, 0x31, 0x1B, 0x1B, 0xAE, 0xAE, 0x1B, 0xAE, 0xAE, 
        0x1B, 0x17, 0xAE, 0xAE, 0xAE, 0xAE, 0xAE, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x19, 0x19, 0x24, 0x19, 0x79, 0x79, 0x29, 0x29, 0x25, 0x25, 0x25, 
        0x25, 0x59, 0x10, 0x44, 0xED, 0xED, 0xD3, 0x34, 0x34, 0xEC, 0xEC, 0x36, 0x36, 0x36, 0xAA, 0x2C, 0x2C, 0xD1, 0xD2, 0x27, 0x27, 0x49, 0xCC, 0xCC, 0x07, 0x07, 0x07, 0x6D, 0x6D, 0xDD, 0xDD, 0xDD, 0x08, 0x08, 0x08, 0x08, 0x7B, 0x7B, 0xB3, 0xB3, 0xB3, 
        0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0xB2, 0xB2, 0x8D, 0x8D, 0xB2, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0x8F, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x75, 0x88, 0x0D, 0x6B, 0x6A, 0x6A, 0x1C, 0xC5, 0x2D, 
        0x50, 0x50, 0x54, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x48, 0x2F, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x53, 0x53, 0xB4, 0x81, 0x32, 0x32, 0x4A, 0x67, 0x35, 0x35, 0x35, 0x35, 0x43, 0x45, 0xB0, 0xB0, 0xB0, 0x39, 0x3E, 0x3E, 0x3E, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x46, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 
        0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x47,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0x36, 0xBC, 0x3A, 0xD4, 0x44, 0x25, 0x25, 0x26, 0x26, 0x69, 0x19, 0x24, 0x22, 0xCD, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x21, 0x22, 0x21, 0x7D, 0x24, 0x22, 0x22, 0x22, 0x24, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 
        0x86, 0x86, 0xAE, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x3D, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x55, 0xA3, 0xA3, 0x23, 0x5F, 0x5F, 0xDF, 0xDF, 0x23, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xA3, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x11, 0x77, 
        0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 
        0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x87, 0x29, 0xF0, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x2C, 0xD2, 0x27, 0x49, 0x65, 0x07, 0x07, 0x6D, 0x6D, 0xDD, 0x08, 0xA0, 0xB3, 
        0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xB9, 0xB9, 0x0C, 0x0C, 0x8F, 0x8F, 0xC6, 0x0E, 0x0E, 0x75, 0x93, 0x88, 0x0D, 0x6B, 0x7E, 0x1C, 0x57, 0x2D, 0x2D, 0x50, 0xB6, 0x3F, 0x3C, 0xEA, 0x56, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x7A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0xB4, 0x81, 0x32, 0x32, 0x4A, 0x4A, 0x35, 0x35, 0x43, 0x43, 0x45, 
        0x45, 0x45, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0xB0, 0xB0, 0x39, 0xB0, 0x46, 0x46, 0x45, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0xB0, 0x39, 
        0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x47, 0x47, 0x47, 0x47, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
  0x27, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0x36, 0x36, 0x36, 0xC8, 0x3A, 0x3A, 0xD3, 0x44, 0xAD, 0xAD, 0x25, 0x5E, 0x5E, 0x26, 0x69, 0x19, 
        0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0xFC, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 
        0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0x73, 
        0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 0x37, 0x37, 0x05, 0x37, 0x37, 
        0x05, 0x37, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1F, 0x1F, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 
        0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x14, 0x14, 0x14, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 
        0x1E, 0x90, 0x21, 0x21, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x44, 0xD4, 0xD3, 0x34, 0xBC, 0x36, 0xE4, 0x2B, 0xAB, 0xD1, 0xD1, 0xD2, 0x49, 0x49, 0x65, 0x07, 0x6D, 0xDA, 0x74, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 
        0xA8, 0xB2, 0xB9, 0x0C, 0x0C, 0x0C, 0xE2, 0xC6, 0x0E, 0x0E, 0x75, 0x75, 0x75, 0x88, 0x88, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0xB6, 0x3F, 0x3F, 0xC4, 0x3C, 0x3C, 0x3C, 
        0x4B, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x4A, 0xA4, 0x35, 0x35, 0x35, 
        0xC3, 0x45, 0x45, 0x45, 0xB0, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x64, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x46, 
        0x46, 0x45, 0x45, 0x43, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0xB0, 0xB0, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x40, 0xBD, 0xBD, 0x47, 0x4C, 0xD9, 0xD9, 0x58, 0x58, 0x5D,
  0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0x3A, 0x3A, 0x3A, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xED, 0xED, 0x44, 0xD5, 0xEE, 
        0xEE, 0x25, 0x29, 0x29, 0x87, 0x26, 0x19, 0x19, 0x19, 0x79, 0x79, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 
        0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 
        0x77, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x05, 0x05, 0x84, 
        0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0xFE, 0xFE, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x87, 0x26, 
        0x26, 0xF0, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0xAD, 0x44, 0x10, 0x10, 0x10, 0x10, 0xD3, 0x10, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x38, 0x34, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0xAC, 0x34, 0x2B, 0x2B, 0xAB, 0x2C, 0x2C, 0x27, 0x27, 
        0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0xA0, 0xB3, 0xF8, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0xE2, 0x9F, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0xBF, 0x6A, 0xBF, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0xB7, 
        0x2D, 0x2D, 0xBE, 0x50, 0x50, 0x50, 0x50, 0x54, 0x54, 0xC4, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0x3C, 0x4B, 0x4B, 0x4B, 0x4B, 0x56, 0x56, 0x33, 0x33, 0x33, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x4F, 0x99, 
        0x99, 0x30, 0x30, 0x53, 0x81, 0x32, 0x32, 0x4A, 0x67, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x45, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x76, 0x76, 0x76, 0x76, 0x76, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x64, 0x64, 0x64, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x40, 0xBD, 0x47, 0x47, 0x4C, 0x4C, 0xD9, 0x58,
  0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x96, 0x96, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xD4, 0xD4, 0xD4, 0xD5, 0x25, 0x25, 0x25, 0x26, 0xEF, 0x26, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x71, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x22, 0xCD, 0x90, 0x1E, 0x1E, 0x1E, 0x8E, 0x14, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 
        0x17, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x1F, 0x1D, 0x9C, 0x9C, 0x05, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 
        0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0xAE, 0xAE, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x84, 0x05, 0x84, 0x37, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 
        0xA3, 0xA3, 0xA3, 0xA3, 0x55, 0x04, 0x89, 0xA3, 0x04, 0x55, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 
        0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 
        0x90, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0xAA, 0xC2, 0x96, 
        0x94, 0x94, 0x07, 0xC1, 0xBB, 0x74, 0x08, 0xA0, 0xA0, 0x0B, 0x0B, 0x0B, 0xA8, 0xA7, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xB8, 0x6A, 0x6A, 0x1C, 0x1C, 0x5C, 0x2D, 0x2D, 0x50, 0xB6, 0x3F, 0x3F, 0x3C, 0x3C, 
        0x4B, 0x4B, 0x56, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x30, 0x30, 0x30, 0x53, 0x53, 0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 0xB4, 
        0x53, 0x53, 0xB4, 0xB4, 0xB4, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x67, 0x67, 0x67, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0xD7, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x36, 0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0xAA, 0xAA, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0xD4, 0xD4, 0xED, 0x44, 0x44, 0x44, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x29, 0x5E, 0x25, 0xEE, 0xEE, 0x25, 0x25, 0xEE, 0xEE, 
        0xAD, 0x44, 0x10, 0xAD, 0xAD, 0x44, 0x10, 0x10, 0x44, 0x44, 0xAD, 0xAD, 0x44, 0x25, 0xEE, 0x5E, 0x5E, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x20, 0x20, 0x14, 0x14, 0x14, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x9D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x2E, 0x84, 0x98, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1B, 0x1B, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x77, 0x77, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 
        0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x2B, 0xE4, 0x2C, 0xD2, 0x94, 0x07, 0xC1, 0xBB, 0x08, 0xA0, 0xB3, 0x0B, 
        0xA8, 0xB2, 0x0C, 0xCB, 0x9F, 0x9F, 0x9F, 0x0E, 0x0E, 0x75, 0x75, 0x75, 0x75, 0x75, 0x93, 0xC0, 0x75, 0x75, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0xA6, 0x6B, 0x6A, 0x7E, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0xB7, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x50, 0xBE, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x54, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x4B, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0xA5, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x53, 0xB4, 0xB4, 0xB4, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0xA4, 0x35, 
        0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46, 0xB0, 0x46, 0x46, 0x46, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x39, 0x39, 0x3E, 0xD7, 0xD7, 0xD7, 0xD7, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0x47, 0x47, 0x47, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D, 0x5D,
  0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0xEC, 0xEC, 0x38, 0x38, 0x10, 0x10, 0xD3, 0x10, 0x10, 0x10, 0xAD, 0xAD, 0x25, 0x25, 0x29, 0x29, 0xF0, 
        0xF0, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x21, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x80, 0x14, 0x14, 0x80, 0x18, 0x18, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0xAE, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x9D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 
        0x89, 0x89, 0x89, 0xA3, 0xA3, 0x89, 0x5F, 0x89, 0x89, 0xDF, 0x5F, 0xDF, 0x23, 0x5F, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x23, 0xA3, 0x55, 0x89, 0x89, 0xA3, 0xA3, 0xA3, 0xA3, 0x55, 0x55, 0x55, 0x55, 0xA3, 0xA3, 0xA3, 0xA3, 0x55, 0x04, 0x04, 0xA3, 0xA3, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x11, 0x77, 0x77, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x13, 0x77, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0xFC, 0xFC, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x79, 0x79, 0x79, 0x26, 0x29, 0x25, 0x25, 0x25, 0x10, 0x34, 0x34, 0x34, 0x2B, 0xAB, 0x2C, 0x2C, 0x27, 0x27, 0x65, 0x07, 0x6D, 0x74, 0x08, 
        0x08, 0x7B, 0x8A, 0x0B, 0x0B, 0xA8, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0xC6, 0x0E, 0x0E, 0xB1, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0x6B, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x5C, 0x2D, 0x2D, 0x2D, 0x50, 
        0x50, 0x54, 0xC4, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0xB5, 0x56, 0x56, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x4A, 0xA4, 0x35, 0x43, 0x43, 0x45, 0x46, 0x39, 0x3E, 0x64, 0x3B, 0x40, 0x76, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5D, 
        0x5D, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0xD9, 0xD9, 0xD9, 0xD9, 0x4C, 0xD9, 0xD9, 0xD9, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x5D, 0xE8, 0x68,
  0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0xD3, 0x10, 0x10, 0x44, 0x25, 0x29, 0x5E, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x24, 
        0x24, 0x24, 0x22, 0x22, 0x22, 0xCD, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x5F, 0xA3, 0x5F, 0x23, 0xDF, 0x5F, 0x5F, 0xDF, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x02, 0x23, 0x23, 0x89, 0x89, 
        0x89, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0xAE, 0xAE, 0x17, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x77, 0x77, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x78, 
        0x78, 0x78, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x79, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x3A, 0x38, 0x34, 
        0x34, 0x36, 0x2B, 0xAB, 0xAA, 0x2C, 0x96, 0x27, 0x27, 0x27, 0x07, 0x07, 0x07, 0x6D, 0xBB, 0xDD, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xB8, 0x6A, 0x1C, 0xC5, 0x5C, 0xBE, 
        0x50, 0x54, 0x3F, 0xE0, 0x3C, 0x4B, 0x56, 0x33, 0x48, 0xA2, 0x6E, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0x81, 0x81, 0x32, 
        0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x46, 0x46, 0x46, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x64, 0x64, 0x64, 0xD7, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x2C, 0x2C, 0xAB, 0x36, 0x36, 0xAA, 0xAA, 0xBC, 0xBC, 0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD4, 0x3A, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAD, 0x44, 0xEE, 0xEE, 0x25, 0x25, 0x5E, 0x26, 0x29, 0x26, 0xEF, 0x26, 0x79, 0x79, 
        0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x90, 0x90, 0x1E, 0x80, 0x80, 
        0x14, 0x14, 0x14, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x1F, 0x9C, 0x1D, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 
        0xA3, 0xA3, 0xA3, 0x55, 0x55, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1D, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x90, 0x21, 0x21, 0x21, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0xD4, 0x10, 0x38, 0x38, 0x10, 0xD3, 0xD3, 0x3A, 0x3A, 0xBC, 0xBC, 0xBC, 0xAC, 
        0x36, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0x27, 0x27, 0x27, 0xCC, 0x07, 0x07, 0x6D, 0xDD, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x9F, 0x9F, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 
        0xA6, 0x6B, 0x6A, 0x1C, 0x1C, 0x57, 0xB7, 0x5C, 0x5C, 0x2D, 0xB6, 0x54, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x4B, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x4A, 
        0x4A, 0x35, 0x43, 0x45, 0x46, 0x39, 0x3E, 0x64, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x76, 0x47, 0x47, 0x4C, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x47, 0x47, 0x47, 0x76, 0x76, 0x76, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0xBD, 0x47,
  0x2C, 0xAB, 0xAB, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x96, 0x2C, 0x96, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xC7, 0x36, 0x36, 0xBC, 0x3A, 0xD3, 0x44, 0xAD, 0xD5, 0xEE, 0x29, 0x26, 0x26, 0x28, 0x28, 
        0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x19, 0x79, 0x79, 0x19, 0x69, 0x26, 0x28, 0x71, 0x26, 0x69, 0x69, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x21, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x91, 0x0F, 0x0F, 
        0x0F, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1B, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x84, 0x05, 0x05, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 
        0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x55, 0x04, 0x89, 0xA3, 0x55, 0x55, 0xA3, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x5F, 0x23, 0xDF, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x02, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0xA3, 0x55, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 
        0x05, 0x1F, 0x1F, 0x1F, 0x1D, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 
        0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x79, 0x79, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0xAC, 0x36, 0xC7, 0x36, 0x36, 0x2B, 0xAB, 0xAB, 0xAB, 
        0x2C, 0x2C, 0x41, 0x96, 0x27, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0xA6, 
        0x7E, 0x1C, 0x57, 0xC5, 0x2D, 0x2D, 0x50, 0x50, 0xC4, 0x3C, 0x3C, 0xEA, 0xB5, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x53, 0x53, 0x81, 0x32, 0x32, 0x32, 0x4A, 0xA4, 0xA4, 
        0x67, 0x35, 0x35, 0x35, 0x43, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x67, 0x67, 0xA4, 0xA4, 0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x67, 0x67, 0x35, 
        0x35, 0x35, 0x43, 0x43, 0x45, 0x45, 0x46, 0x39, 0x39, 0x39, 0x3E, 0xD7, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0x47, 0x47, 0x4C, 0xD9, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58,
  0x07, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0xBC, 0xBC, 0xBC, 0x3A, 0xD3, 0xD4, 0x44, 0x44, 0xD5, 0x25, 0x25, 0x29, 0x25, 0xF0, 0x26, 0x26, 0x26, 0x87, 0x87, 0x26, 
        0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 
        0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x05, 0x05, 0x9C, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x9C, 
        0x05, 0x05, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x89, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x89, 0x55, 0x55, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0x84, 0x84, 
        0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0xAE, 0x17, 0xAE, 0x17, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x77, 0x13, 0x13, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x95, 0x78, 0x78, 0x14, 0x1E, 0x1E, 
        0x1E, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x4E, 0x2C, 0x2C, 
        0x96, 0x27, 0x27, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 
        0x7E, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x57, 0x50, 0x50, 0x50, 0x50, 0xC4, 0x3C, 0x3C, 0xB5, 0xB5, 0x33, 0x48, 0xA2, 0xA2, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x99, 0x99, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 
        0xA4, 0x35, 0x67, 0x67, 0x67, 0x67, 0x35, 0x67, 0x67, 0x67, 0x67, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0xB4, 
        0x32, 0x32, 0x32, 0x4A, 0xA4, 0xA4, 0x67, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x46, 0x46, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40,
  0x08, 0x08, 0xBB, 0xDA, 0xDA, 0x07, 0x07, 0x65, 0x27, 0x27, 0x27, 0x2C, 0x2C, 0xAA, 0x36, 0xBC, 0xBC, 0x3A, 0xD4, 0xD4, 0xD4, 0x44, 0xD5, 0xD5, 0xAD, 0xAD, 0xAD, 0xAD, 0x25, 0xD5, 0xD5, 0xD5, 0xD5, 0x44, 0x25, 0xD5, 0x5E, 0x5E, 0xD5, 0xAD, 0xAD, 0x25, 
        0x25, 0x25, 0x25, 0x29, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x69, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x24, 0x24, 0x24, 0x22, 0x22, 0x21, 0x21, 0x90, 0x90, 0x80, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 
        0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x86, 
        0x17, 0x17, 0x1B, 0x9D, 0x1D, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 
        0x55, 0x55, 0x55, 0x55, 0x89, 0x23, 0x89, 0x23, 0x23, 0x89, 0x23, 0xDF, 0xDF, 0xDF, 0xDF, 0x5F, 0xDF, 0x5F, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x23, 0x23, 0x5F, 0x5F, 0x89, 0x55, 0x55, 0x89, 0x23, 0x89, 0x89, 0x55, 0x55, 0x55, 
        0x55, 0x04, 0x55, 0x55, 0x55, 0x04, 0x04, 0x55, 0x55, 0x55, 0x55, 0xA3, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x5F, 0xDF, 0xDF, 0xDF, 0x5F, 0x23, 0xDF, 0xDF, 0xDF, 0x89, 0xA3, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x78, 0x14, 0x14, 0x80, 0x80, 0x90, 
        0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0xAB, 0x4E, 0x2C, 
        0x96, 0x96, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xC6, 0x0E, 0x0E, 0x0E, 0xCF, 0xCF, 0xCF, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0xA6, 0xA6, 0xBF, 0xBF, 0xBF, 0xBF, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0x50, 0x3F, 0x3F, 0x3C, 0x4B, 0x56, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0x81, 
        0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0xA4, 0x4A, 0x4A, 0xA4, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0x32, 
        0x32, 0x32, 0x32, 0x32, 0xA4, 0xA4, 0xA4, 0x35, 0x35, 0x35, 0x35, 0xC3, 0x45, 0x45, 0x46, 0x39, 0x39, 0x3E, 0x64, 0x64, 0x64, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x76, 0x47,
  0x27, 0x27, 0x27, 0x27, 0xD2, 0xD1, 0xD1, 0x4E, 0xAB, 0xAA, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0xD5, 0xD5, 0x5E, 0x5E, 0x25, 0x25, 0x29, 0x29, 0x25, 0x5E, 0x5E, 0x5E, 0x5E, 0x5E, 0x26, 0x5E, 0x5E, 0x5E, 0x29, 0x29, 0x5E, 0xEF, 
        0xEF, 0x26, 0xEF, 0xEF, 0xEF, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x19, 0x24, 0x22, 0x22, 0x22, 0x22, 0xCD, 0xCD, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 
        0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 0x55, 0x55, 
        0x55, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x55, 0x55, 0xA3, 0xA3, 0x55, 0x55, 0x55, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x3D, 0x3D, 0x2E, 0xFE, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0xFE, 0x3D, 0x3D, 0x2E, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x66, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0xAE, 0xAE, 0x13, 0x13, 0x77, 0x11, 
        0x11, 0x0F, 0x91, 0x91, 0x91, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x90, 0x90, 0x90, 0x21, 0x24, 0x19, 0x19, 0x79, 0x29, 0x26, 0x26, 0x25, 0x10, 0x10, 0x10, 0xD3, 0x34, 0x34, 0x34, 0x36, 0xAC, 0x2B, 0x2B, 0x2B, 0x2B, 0xAA, 0xAA, 0xAA, 0xAA, 
        0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x6D, 0x74, 0x08, 0xA0, 0x0B, 0x0B, 0xA8, 0x8D, 0xA7, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0x75, 0x75, 0x88, 0x0D, 0x0D, 0x0D, 0x6B, 0x6A, 0x6A, 0x6A, 
        0x6A, 0x1C, 0x57, 0x57, 0xB7, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0xB6, 0xB6, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0xEA, 0x4B, 0x4B, 0xEA, 0xEA, 0x4B, 0x4B, 0x4B, 0xB5, 0xB5, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 
        0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0x7A, 0x2A, 0x4F, 0x30, 0x30, 0x53, 0x32, 0x32, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0xC3, 0x45, 0x46, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x64, 0x64, 0x3B, 0x3B, 0x40, 0x40, 0x40, 0x40, 0x40, 0x76, 0x76, 
        0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0x9A, 0xD9, 0x4C, 0x4C, 0x4C, 0x4C, 0x47, 0x76, 0xBD, 0x40, 0x3B, 0x3B, 0x64, 0xD7, 0x3E, 0x39, 0x39,
  0xBC, 0xBC, 0xC8, 0xC8, 0xBC, 0xBC, 0xBC, 0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0xD2, 0x96, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xC7, 0x36, 0x36, 0x34, 0xD3, 0xED, 0x10, 
        0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x87, 0x26, 0x26, 0x28, 0x79, 0x19, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x22, 0x22, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 
        0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x13, 0xAE, 0x86, 0xAE, 0xAE, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x1F, 0x9D, 0x1D, 0x9C, 0x1F, 0x1F, 0x1F, 0x1D, 0x1F, 
        0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x89, 0x89, 0x23, 0x23, 0x5F, 0x02, 0xDF, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 
        0x89, 0x89, 0x89, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0xDF, 0xDF, 0x23, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x6C, 0x8C, 
        0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x5F, 0x23, 0x23, 0xA3, 0xA3, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 
        0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0xAE, 0x86, 0x86, 0x86, 
        0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x78, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x21, 0x22, 0x24, 0x24, 0x19, 0x19, 0x19, 0x26, 0x26, 0x26, 0x25, 0x25, 0x25, 0x25, 0xAD, 0xAD, 0x10, 0x10, 0x10, 0x44, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x3A, 0x3A, 0x34, 0x34, 0xAC, 0x36, 0xAA, 0x2C, 0x96, 0x96, 0x27, 0x07, 0x07, 0x07, 0x6D, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xE2, 0x0E, 0x0E, 0xB1, 0x75, 0x0D, 0x0D, 0x6B, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x5C, 
        0x2D, 0x50, 0x54, 0x3C, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x48, 0x48, 0xF5, 0x33, 0x33, 0x33, 0x33, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 
        0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0x53, 0x81, 0x32, 0x4A, 0x4A, 0xA4, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x45, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0x39, 0x39, 0x39, 
        0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x46, 0xB0, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x67, 0x67, 0x4A, 0x4A,
  0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x07, 0x07, 0x94, 0x07, 0x07, 0x07, 0x07, 0x94, 0xCC, 0x94, 0x27, 0x27, 0x27, 0xD2, 0x96, 0x96, 0x2C, 0xAB, 0xAA, 0xAA, 0x36, 0xBC, 0x34, 0x34, 0xD3, 0xED, 0x44, 0xAD, 
        0x25, 0x5E, 0x5E, 0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0xCD, 0x1E, 0x1E, 0x90, 0x90, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x80, 0x14, 0x14, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 
        0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x1F, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x5F, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x5F, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x9C, 0x9C, 0x1B, 0x1B, 0x1D, 0x1B, 0x17, 0x17, 0xAE, 0x17, 0x9B, 0x9B, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x24, 0x24, 0x19, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0xD3, 0x3A, 0xEC, 0x36, 0x36, 0xAB, 0x2C, 0x96, 0x96, 0x94, 0x94, 
        0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x74, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xE2, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0xCF, 0xCF, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0x5C, 0x2D, 0xBE, 0x54, 0x3F, 0x3C, 0xEA, 0xB5, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 
        0x99, 0x30, 0x30, 0x30, 0x53, 0x32, 0x32, 0x32, 0x32, 0x67, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0xB0, 0x45, 0xB0, 0x45, 
        0x45, 0x45, 0x45, 0x45, 0x45, 0x43, 0x43, 0xC3, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A,
  0xAA, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0x10, 0x10, 0x10, 0x10, 0x10, 0x59, 0x25, 0x29, 0xF0, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x19, 0x19, 
        0x19, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x20, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 
        0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x89, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x55, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0xA3, 0x04, 0x04, 0xA3, 0x04, 0x04, 0xA3, 0x04, 0x04, 0x04, 0x89, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 
        0x1F, 0x66, 0x1D, 0x1F, 0x1F, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x21, 0x24, 0x19, 0x79, 0x26, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x2B, 0xAA, 0xAB, 0x2C, 
        0x2C, 0x61, 0x27, 0x27, 0x49, 0x27, 0x27, 0xCC, 0xCC, 0x49, 0x65, 0x49, 0x49, 0xCC, 0x65, 0x65, 0xCC, 0xCC, 0xCC, 0x65, 0x07, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xDA, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xA8, 
        0xB2, 0x8D, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0x93, 0x93, 0x0D, 0x6B, 0xA6, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0xB6, 0xB6, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0xEA, 0xEA, 0x4B, 0xB5, 0xB5, 0xB5, 0xB5, 0xB5, 0x56, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x53, 0xB4, 0x32, 0x4A, 0xA4, 0x35, 0x43, 0x43, 0x45, 0x45, 0x46, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 
        0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0x4C, 0x9A, 0x9A, 0x9A, 0x9A,
  0x36, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x96, 0x2C, 0x2C, 0x96, 0x2C, 0x96, 0x96, 0xAA, 0xAA, 0x2C, 0xAB, 0x2B, 0x36, 0x36, 0xAC, 0x34, 0x3A, 0xD3, 0xD3, 0xD3, 0x44, 0x44, 0x44, 0xD5, 0x44, 0x44, 0x44, 0xAD, 0xD5, 0xD5, 0xEE, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x2E, 0x3D, 0xFE, 0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0x04, 0x55, 0xA3, 
        0x23, 0x23, 0x23, 0x89, 0xDF, 0x23, 0x5F, 0x5F, 0x5F, 0x5F, 0xDF, 0xDF, 0x23, 0xA3, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0xFE, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x04, 0xFE, 0xFE, 0x2E, 0xFE, 0xFE, 0xFE, 
        0xFE, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0xFE, 0x2E, 0xFE, 0xFE, 0x04, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x84, 0x84, 0x84, 0x84, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x31, 0x9D, 0x1B, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 
        0x17, 0xAE, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 
        0x79, 0x79, 0xFA, 0x87, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0xAB, 0x41, 0x27, 0x27, 0x49, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0xA8, 0xA7, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0xB7, 0x50, 0x50, 0x54, 0x3F, 0x3F, 0x3F, 0x3C, 0x3C, 0xEA, 0x4B, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0xB4, 0x32, 0x4A, 0xA4, 0x35, 0x43, 0x43, 0x45, 0x46, 0x39, 0x3E, 0x3E, 0x64, 0x64, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0xD7, 0x64, 
        0x64, 0xD7, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x64, 0x64, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x64, 0x64, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x64,
  0x07, 0x07, 0x07, 0x94, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x27, 0x94, 0x94, 0x27, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xC7, 0x36, 0x36, 0xBC, 0x36, 0xC8, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0x10, 0xD4, 0xED, 0x10, 0x10, 0x10, 0xAD, 0xAD, 
        0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x5E, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x22, 0x22, 0x21, 0xCD, 0xCD, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x98, 0x84, 0x84, 0x84, 0x2E, 0x84, 
        0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x1F, 0x9C, 0x1F, 0x1F, 0x9C, 0x9C, 0x1F, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0x23, 0x23, 0x02, 0x02, 0x23, 0xDF, 0x5F, 0xDF, 0xDF, 0xDF, 0xDF, 0x02, 0xDF, 0x02, 0x02, 0xDF, 0xDF, 0x23, 0xDF, 0x5F, 0x02, 0x23, 0xDF, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0xA3, 0x89, 0x89, 0x89, 
        0x55, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x89, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x9D, 0x1B, 0x17, 0xAE, 0xAE, 0xAE, 0x86, 0x13, 0x13, 
        0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x44, 0x10, 0x10, 0xD3, 0xD3, 0x38, 0x34, 0xAC, 0xAC, 
        0xAC, 0x36, 0x2B, 0xE4, 0xE4, 0x4E, 0x2C, 0x2C, 0x27, 0x27, 0x27, 0x49, 0x65, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0x6D, 0x6D, 0x6D, 0xBB, 0xDD, 0x74, 0x08, 0xA0, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 
        0xCB, 0xD8, 0xC6, 0x0E, 0x0E, 0xB1, 0x88, 0x0D, 0x0D, 0xA6, 0xBF, 0x1C, 0x1C, 0xC5, 0xB7, 0x2D, 0x50, 0xB6, 0x54, 0x54, 0x3F, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0xA2, 
        0xA2, 0xA2, 0x48, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA5, 0xA5, 0xA5, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x4A, 0xA4, 0x67, 0x35, 0x35, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0xB0, 0x46, 0xB0, 0x39, 
        0x39, 0x39, 0x39, 0x39, 0x39, 0x46, 0x46, 0x46, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46, 0x46, 0x46, 0x46, 0xB0, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39,
  0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0xD3, 0xD4, 0x44, 0x44, 0x44, 0x44, 0x25, 0xF0, 
        0x29, 0x29, 0x28, 0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x8E, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x78, 0x12, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x0F, 0x0F, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 
        0xFE, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x2E, 0x37, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1F, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x2E, 0x2E, 
        0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x23, 0x55, 0x89, 0x23, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x8E, 0x20, 0x1E, 0x1E, 0xCD, 0xCD, 0x90, 0xCD, 0xCD, 0xCD, 0x22, 
        0x22, 0x24, 0x24, 0x24, 0x19, 0x79, 0x26, 0x26, 0x26, 0x26, 0xF0, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x34, 0x34, 0x2B, 0xE4, 0x2C, 0xD2, 0x27, 0x27, 0x65, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0xA7, 0xB2, 0x0C, 0x0C, 0x0C, 
        0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0x75, 0xC0, 0x0D, 0x0D, 0x0D, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x2D, 0x50, 0x50, 0x54, 0x3F, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x48, 0xA2, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0xC3, 0x45, 0x45, 0xB0, 0xB0, 
        0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0xD7, 0xD7, 0x3B, 0x3B, 0x3B, 0x40, 0x40, 0xBD, 0xBD, 0xBD, 0x47, 0x47, 0x47, 0x4C, 0x4C, 0x4C, 0xD9, 0x58,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0xC7, 0x36, 0xBC, 0xBC, 0x34, 0x38, 0x10, 0x10, 0x10, 0xAD, 0x25, 0xF0, 0x29, 
        0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 
        0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x89, 0x23, 
        0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0x02, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x5F, 0x02, 0x23, 0x23, 0xDF, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x98, 0x37, 0x84, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x9D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x73, 0x1B, 0xAE, 0x17, 0x17, 0x86, 
        0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x21, 0xFB, 0x7D, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 
        0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0xF0, 0xF0, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x38, 0x34, 0x3A, 0xBC, 0xBC, 0x36, 0xAA, 0xAA, 0x2C, 0x96, 0x96, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 
        0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xD8, 0x9F, 0x9F, 0x0E, 0x75, 0x93, 0x93, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0x2D, 0x50, 0x50, 0xB6, 0xB6, 0xC4, 0x3C, 0x3C, 0xEA, 0xEA, 0x33, 0x33, 0x33, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 
        0x7A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x7A, 0x7A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x4A, 
        0x4A, 0xA4, 0xA4, 0x67, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 0xB0, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0xD7, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B, 0x3B,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0x36, 0xBC, 0xBC, 0x3A, 0x10, 0x44, 0x25, 0x26, 0xEF, 0x71, 0x19, 0x79, 0x19, 0x24, 
        0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0xDE, 0x91, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x98, 0x98, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 
        0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x55, 0x89, 0x89, 0xA3, 0x23, 0x23, 0x5F, 0x89, 0x23, 
        0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x55, 0x55, 0x89, 0x55, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x98, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x05, 0x05, 
        0x1F, 0x1F, 0x9D, 0x1D, 0x1B, 0xAE, 0x86, 0x86, 0x13, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x90, 0x90, 0x90, 0x21, 0x22, 0x19, 0x19, 0x24, 0x19, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 
        0x26, 0x29, 0x29, 0x26, 0x26, 0x5E, 0x5E, 0x25, 0x25, 0xAD, 0xAD, 0x44, 0x44, 0xED, 0x38, 0xD3, 0x34, 0x34, 0x34, 0xAC, 0xAC, 0x2B, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0x96, 0x96, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 
        0x0B, 0x0B, 0xBA, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xC0, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x6B, 0xA6, 0xA6, 0xA6, 0xA6, 0x6B, 0x6B, 0x6A, 0x7E, 0x7E, 0x6A, 0x1C, 0x57, 0x57, 0x57, 0x2D, 0x50, 0x50, 0xB6, 0x3F, 0x3C, 0x4B, 
        0x4B, 0x56, 0x33, 0x48, 0x6E, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x7A, 0x7A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x99, 0xA1, 0x30, 0x30, 0x30, 0x30, 0xB4, 0xB4, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0x43, 0x43, 0x46, 0x46, 0x46, 0xB0, 
        0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x96, 0x96, 0x96, 0x2C, 0x36, 0x36, 0x36, 0xBC, 0x3A, 0xD4, 0xD4, 0x44, 0x5E, 0xEF, 0xEF, 0x71, 0x26, 0x19, 0x24, 0x22, 0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 
        0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x86, 0x17, 0x1B, 0x17, 
        0x17, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x73, 0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x2E, 0x2E, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x02, 0x23, 0xDF, 0x5F, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x89, 0x89, 0x89, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0xFE, 0x2E, 0x3D, 0xFE, 0x3D, 0x2E, 0x2E, 0x3D, 0x2E, 0x2E, 0x3D, 0xFE, 0xFE, 0x3D, 0x2E, 0x84, 0x84, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x31, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x9B, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 
        0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0xED, 0x10, 0xD3, 0x34, 0x34, 0x36, 0x36, 0xAB, 0x2C, 0x61, 0x27, 0x49, 0x65, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0xE2, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0xA6, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0xB7, 0x2D, 0x50, 0x50, 0xB6, 0x3F, 
        0x3F, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x53, 0xB4, 0x32, 
        0x4A, 0x67, 0x35, 0x43, 0x45, 0x46, 0x39, 0x3E, 0xD7, 0x3B, 0x40, 0xBD, 0x47, 0x47, 0x47, 0x4C, 0x58, 0x58, 0x58, 0x58, 0x5D, 0xE8, 0xE8, 0xE8, 0x68, 0x68, 0x68, 0x68,
  0x07, 0x07, 0x07, 0x94, 0x94, 0x07, 0x94, 0x94, 0x94, 0x27, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD3, 0x10, 0x44, 0xAD, 0xEE, 0x25, 0x25, 0x26, 0xEF, 0x26, 0x79, 0x79, 0x19, 
        0x19, 0x24, 0x24, 0x7D, 0x21, 0xCD, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0xAE, 0x17, 0x1B, 0x17, 0x17, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 
        0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x97, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0xF2, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x89, 0x89, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xFD, 0x9C, 0xFD, 0xFD, 0x9C, 0x1F, 0xFD, 0xFD, 0x9C, 0xFD, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x98, 0x37, 0x37, 0x37, 0x37, 0x84, 0x2E, 0x2E, 0x98, 0x98, 0x84, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x73, 0x17, 0x86, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x29, 
        0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x34, 0x34, 0x34, 0x2B, 0x36, 0xE4, 0xAB, 0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0xA9, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0xB3, 0x0B, 
        0x0B, 0xB2, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xC0, 0xC0, 0x0D, 0x0D, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x54, 0xB6, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0xEA, 0xEA, 0xB5, 0xB5, 0x33, 0x33, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 
        0x2F, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x4F, 
        0x99, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0x67, 0x35, 0x43, 0x43, 0x45, 0x45, 0x45, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x64, 0x3B, 0x3B, 0x3B, 0x3B, 0x40, 0x40,
  0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0x2C, 0xAA, 0x2C, 0x2C, 0xAA, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0xD4, 0xD4, 0xD4, 0xD4, 0xAD, 0x25, 0x5E, 0x5E, 
        0xF0, 0x26, 0x28, 0x19, 0x19, 0x24, 0x22, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x5F, 0xDF, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0xA3, 0x55, 0x55, 0x04, 0x55, 0x55, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x55, 0x04, 0x55, 0x89, 0x89, 0x89, 0x23, 0x5F, 0x5F, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0xF2, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0xF2, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 
        0xDF, 0x23, 0x23, 0xDF, 0x5F, 0xA3, 0x23, 0x23, 0xA3, 0xA3, 0xA3, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0xFE, 0xFE, 0x2E, 0x2E, 
        0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x21, 0x21, 0x24, 0x19, 0x19, 
        0x19, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x4E, 0x2B, 0x4E, 0x2C, 0x2C, 0x96, 0x94, 0x27, 0x27, 0x07, 0x07, 0xC1, 0xBB, 
        0x08, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0x75, 0x75, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0xB6, 0x54, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0xB5, 0xB5, 
        0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0xA2, 0x48, 0x48, 0x6E, 0x6E, 0x6E, 0x2F, 0x2F, 0x4D, 0xA5, 0x7A, 0x7A, 0x7A, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0x30, 
        0x53, 0x53, 0x53, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0xC3, 0x46, 0x46, 0x46, 0x39, 0x64, 0x64, 0x64, 0x64, 0x64, 0x3B,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0xA9, 0xA9, 0x27, 0x27, 0xD2, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0xEC, 0x34, 0x34, 0x3A, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAD, 0xD5, 0xEE, 0x25, 0x5E, 
        0x5E, 0xEF, 0x26, 0x26, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x80, 0x80, 0x8E, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x77, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x17, 0x17, 0xAE, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x17, 
        0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x98, 0x84, 0x84, 0x84, 0x84, 0x37, 0x84, 0x84, 0x37, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 
        0x2E, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0xDF, 0xDF, 0x02, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x02, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x02, 0xDF, 0x23, 0x23, 0x89, 0xA3, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1D, 0x1B, 0x1B, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 
        0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x29, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x4E, 0x4E, 0x96, 0x96, 0x27, 0x94, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x74, 0x08, 0xA0, 0xA0, 0xB3, 
        0x8A, 0x8A, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xB8, 0x6A, 0x6A, 0x1C, 0x1C, 0xC5, 0x57, 0x2D, 0x50, 0x50, 0x50, 0x54, 0x54, 0xC4, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 
        0x4B, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x33, 0xF5, 0x48, 0x48, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x99, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x30, 
        0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0xC3, 0x43, 0x45, 0x45, 0x46, 0x46, 0x39, 0x39,
  0x34, 0x38, 0x38, 0xD3, 0xD3, 0x38, 0x10, 0x10, 0xD3, 0x44, 0x44, 0x44, 0x10, 0x44, 0x44, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0xEE, 0x29, 0x29, 
        0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0xF0, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x22, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 
        0x14, 0x78, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0xFE, 0xFE, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x5F, 0xA3, 0x5F, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x02, 
        0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x97, 0x97, 0x97, 0x0A, 0x97, 0xF2, 0xF2, 0x97, 0x97, 0x97, 0x97, 0xF2, 0xF2, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0xDF, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x5F, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x37, 0x84, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x9D, 0x1F, 0x1F, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 
        0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x19, 0x19, 0x79, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0xAC, 0x36, 0xAB, 0xD1, 0xD2, 0x27, 0x49, 0x65, 0x07, 0x6D, 0xDD, 0xDD, 0x08, 0x08, 0x08, 0xA0, 
        0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xBA, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0xA6, 0xA6, 0x7E, 0x1C, 0x1C, 0x57, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x54, 
        0x54, 0x54, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x2A, 0x2A, 0x2A, 0x2A, 0x99, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x4A, 0xA4, 0x67, 0x35, 0x43, 0x43, 0x43, 0x43, 0x45, 0xB0,
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x10, 0x10, 0x10, 0x10, 0x10, 0xD3, 0x10, 0xD4, 0xD4, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0xD3, 0x34, 0x34, 0x38, 0x38, 0x34, 0x34, 0x38, 0x38, 0xD3, 0xD3, 
        0xD3, 0xD3, 0xD3, 0x44, 0x44, 0x44, 0x10, 0x44, 0x44, 0x25, 0x25, 0x25, 0x5E, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x22, 0x22, 0xCD, 0xCD, 0xCD, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x91, 0x11, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x13, 0x86, 0xAE, 0x17, 0x17, 0xAE, 0x17, 0x1B, 
        0x1B, 0x1B, 0x9D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x37, 0x84, 0x84, 0x84, 0x37, 0x37, 0x84, 0x84, 0x84, 
        0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0x55, 0x23, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x89, 0xA3, 0x89, 0x89, 0x55, 0x89, 0x04, 0xA3, 0x55, 0x89, 0x89, 
        0x55, 0x55, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x98, 0x84, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0xAE, 0xAE, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 
        0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0x2C, 0x96, 0x96, 
        0xD2, 0x27, 0x27, 0x27, 0x94, 0xCC, 0x94, 0xCC, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0xCB, 0xE2, 0x0E, 0xB1, 0xC0, 0x0D, 0xA6, 0x6A, 0x1C, 
        0xB7, 0x2D, 0x50, 0x50, 0x3F, 0x3C, 0x3C, 0x4B, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0xA5, 0xA5, 0x2A, 0x2A, 0x99, 0x99, 0x30, 0x53, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0xA4, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0xC3, 0xC3, 
        0xC3, 0x43, 0x43, 0x43, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0x45, 0x45, 0xC3, 0x43, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0xC3, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35,
  0x96, 0x96, 0x2C, 0x2C, 0xAB, 0xAB, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0x10, 0x10, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x28, 0x79, 0x19, 0x19, 0x79, 0x24, 
        0x24, 0x22, 0x22, 0x22, 0x21, 0x7D, 0x7D, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x8E, 0x8E, 0x8E, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x13, 0x42, 
        0x17, 0x17, 0x1B, 0x1B, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 
        0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x3D, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x23, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0xF2, 0xF2, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x97, 0x97, 0x8C, 0xF2, 0x97, 0xF2, 
        0x8C, 0x02, 0x02, 0x02, 0x6C, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x2E, 
        0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 
        0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x14, 0x14, 0x1E, 0x1E, 0x90, 0x24, 0x24, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x41, 0x4E, 0x2C, 0x96, 0x96, 
        0xA9, 0x65, 0x07, 0x07, 0x07, 0x6D, 0xDD, 0x08, 0x7B, 0xB3, 0x0B, 0x0B, 0x8D, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xCF, 0x0D, 0x0D, 0x0D, 0xB8, 0x6A, 0xB8, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0xC5, 0x5C, 0x5C, 0x5C, 0x5C, 0x2D, 
        0x50, 0xB6, 0xB6, 0x54, 0x3F, 0x3C, 0x3C, 0x4B, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 0x30, 0x53, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0xA4, 0xA4, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0x45, 
        0x46, 0x45, 0x46, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x64, 0x64, 0x3B, 0x3B, 0x40, 0x3B, 0x40, 0xBD, 0x40, 0x40, 0x40, 0x40, 0xBD, 0x76, 0x40, 0x40, 0x40, 0x40, 0x76, 0x76,
  0xAA, 0x36, 0x36, 0x36, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD4, 0x44, 0x44, 0xD5, 0xD5, 0x25, 0x25, 0xD5, 0xD5, 0xD5, 0xEE, 0xD5, 0x5E, 0x25, 0x25, 0xF0, 0x26, 0x26, 0xEF, 0xEF, 0xEF, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 
        0x24, 0x24, 0x24, 0x22, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x21, 0x21, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0xAE, 0x17, 0xAE, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 
        0x98, 0x2E, 0x3D, 0x2E, 0x04, 0x2E, 0xFE, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x04, 0x89, 0x55, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x89, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x5F, 0x23, 0x02, 0x5F, 
        0x5F, 0x23, 0xDF, 0x5F, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x5F, 0xDF, 0x23, 0xDF, 0x5F, 0x5F, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x8C, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0xFD, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x9C, 0x1D, 0x9D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 
        0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 
        0x10, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x41, 0x41, 0x41, 0x27, 0x49, 0x07, 0x07, 0xC1, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x8D, 0xB2, 0xB9, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xA6, 0x6A, 0x1C, 0xC5, 
        0xEB, 0x2D, 0xBE, 0x54, 0x3C, 0x4B, 0x56, 0x33, 0xA2, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x30, 0x30, 0x30, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x81, 0x32, 0x81, 0x81, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 
        0xA4, 0x67, 0x35, 0x35, 0x43, 0x43, 0x43, 0x45, 0xB0, 0xB0, 0x46, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x3E, 0x39, 0x39, 0x39, 0x39,
  0x94, 0x27, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x38, 0x38, 0x38, 0x10, 0x44, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x87, 0x26, 0x28, 0x79, 0x79, 0x19, 0x19, 
        0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 
        0x18, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x17, 0x17, 0x17, 0x73, 
        0x1D, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x55, 0x55, 0x89, 0x23, 0x5F, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 
        0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x97, 0x97, 
        0x97, 0x0A, 0x0A, 0xF2, 0xF2, 0x0A, 0x97, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1D, 0x9D, 0x1B, 0x1B, 0xAE, 0x17, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x12, 0x12, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x95, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x10, 0x44, 0x38, 0x38, 0x3A, 0x34, 0x34, 0x36, 0x36, 0xAB, 
        0x2C, 0xD2, 0xD2, 0xD2, 0x27, 0xCC, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0xB2, 0xA7, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 
        0xC0, 0x0D, 0x0D, 0x0D, 0xBF, 0x1C, 0x1C, 0xC5, 0x5C, 0x2D, 0xBE, 0x54, 0x3F, 0x3F, 0x3C, 0x3C, 0xB5, 0xB5, 0x33, 0x33, 0xA2, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x30, 0x30, 0x53, 0xB4, 0xB4, 0x32, 0x4A, 
        0x4A, 0xA4, 0xA4, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x67,
  0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x94, 0x96, 0x96, 0x2C, 0x2C, 0xAA, 0x36, 0xBC, 0xBC, 0xD4, 0x44, 0x44, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 
        0x19, 0x19, 0x24, 0x19, 0x19, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x28, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x80, 0x14, 0x14, 
        0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 
        0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x92, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x04, 0x89, 0x89, 0x89, 0x5F, 0x5F, 0x23, 0x89, 0x23, 0xDF, 0xDF, 0xDF, 0xDF, 
        0x23, 0x02, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1F, 0x9D, 0x9D, 0x1B, 0x73, 0x17, 0x17, 0x17, 0x86, 0x17, 0x9B, 0x13, 0x13, 0x13, 0x13, 0x1A, 0x77, 0x77, 0x77, 0x0F, 0x11, 
        0x11, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x19, 0x26, 0x29, 0x29, 0x25, 0x25, 0x44, 0xD3, 0x34, 0x34, 0x36, 0x2B, 0x2B, 0x2C, 0x2C, 0x41, 0x27, 0x27, 0x49, 0x65, 0x07, 0x07, 0x6D, 0xDD, 
        0x74, 0x74, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x8D, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xE2, 0xE2, 0xCB, 0xE2, 0xE2, 0x0E, 0xE2, 0xE2, 0x0E, 
        0x0E, 0x0E, 0x75, 0xC0, 0xC0, 0xC0, 0x0D, 0x6B, 0x6A, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x5C, 0x50, 0x50, 0x54, 0xC4, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x30, 0x53, 
        0x53, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x67,
  0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x36, 0xBC, 0xBC, 0xBC, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0x34, 0x3A, 0x3A, 0xD4, 0xD4, 0x44, 0x10, 0x44, 0x25, 0x25, 0x29, 0x29, 
        0x79, 0x19, 0x19, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 0x17, 
        0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x1D, 0x05, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x05, 0x05, 0x84, 0x37, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 
        0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x97, 0xF2, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x97, 0x0A, 0x8C, 0x8C, 0x6C, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x6C, 0x6C, 0x8C, 0x6C, 0x6C, 0x02, 0x6C, 0x6C, 0x02, 0x6C, 0x6C, 0x02, 
        0x02, 0x02, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x6C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x84, 0x98, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x77, 0x0F, 
        0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0xEE, 0xAD, 0x44, 0x10, 0xD3, 0xD3, 0x38, 0x38, 0x34, 0xAC, 0xAC, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xAC, 
        0x2B, 0x2B, 0xE4, 0x2B, 0x36, 0x36, 0x4E, 0x4E, 0x2C, 0x41, 0x49, 0x49, 0xCC, 0x07, 0x6D, 0x74, 0x08, 0xA0, 0x8A, 0x0B, 0xB2, 0x0C, 0x0C, 0xD8, 0x0E, 0x0E, 0x0E, 0xCF, 0x88, 0x0D, 0x0D, 0xA6, 0xA6, 0xBF, 0xBF, 0xBF, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 
        0x57, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0x50, 0x54, 0xC4, 0xC4, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 
        0x99, 0x99, 0x30, 0x30, 0x53, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0xC3, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x43, 0x43,
  0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0xAC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0xD3, 0x44, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 
        0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1F, 0x1F, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x98, 0x2E, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x04, 0x04, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x23, 0x23, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0xF2, 0x6C, 0x8C, 0x0A, 0x0A, 0x97, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x5F, 0x5F, 0x89, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x3D, 
        0x3D, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x84, 0x98, 0x37, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x13, 0x13, 0x77, 
        0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x79, 0x26, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x10, 0x38, 0x38, 0xEC, 0x36, 0x2C, 0x2C, 0x27, 0x27, 0x07, 0x6D, 0x74, 0x08, 0xB3, 0x0B, 0xBA, 0x0C, 0xCB, 0x0E, 0x0E, 0x0D, 0x0D, 0xA6, 0x1C, 0x1C, 0xC5, 0xC5, 
        0x5C, 0x2D, 0x50, 0x54, 0x3F, 0x3C, 0xB5, 0x33, 0xF5, 0x48, 0x2F, 0x2F, 0x2F, 0x4D, 0x7A, 0x2A, 0x4F, 0x99, 0x99, 0x30, 0x30, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x4A, 0xA4, 0xA4, 0x35, 0x35, 0x35, 0x35, 0x35, 0x43, 0x43, 0x43, 0x43, 0x45, 0x45, 0x45, 
        0x45, 0x46, 0x46, 0x46, 0x46, 0xB0, 0x46, 0x46, 0x46, 0x46, 0xB0, 0x45, 0x45, 0x45, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x45, 0x45,
  0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xAC, 0xAC, 0x34, 0x34, 0xEC, 0xEC, 0x38, 0xD4, 0x10, 0x44, 0x44, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 
        0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x91, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x17, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x1F, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x23, 0x5F, 0x5F, 0x23, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x02, 0x5F, 0x23, 0xDF, 0x5F, 0x23, 0x89, 0x89, 0x89, 0xA3, 0x55, 0x55, 0x55, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x1D, 0x73, 0x17, 0x17, 0x86, 0x13, 
        0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x7D, 0x7D, 0x24, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x25, 0x25, 0x25, 0xAD, 0xED, 0xD4, 0x38, 0x38, 0xAC, 0xBC, 0xAC, 0xAC, 
        0x36, 0x36, 0xE4, 0x36, 0xAB, 0xE4, 0xAA, 0x36, 0x36, 0x2B, 0x2B, 0xAA, 0xAA, 0xAA, 0xAB, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x27, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0xA0, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x75, 0x93, 0x0D, 
        0xA6, 0xB8, 0x7E, 0x1C, 0x1C, 0x57, 0xB7, 0x2D, 0x2D, 0x2D, 0x50, 0xB6, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0x33, 0x33, 0x33, 0xA2, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x99, 0x30, 0x30, 0x53, 0x53, 0x53, 0x81, 0x81, 0x32, 0x32, 0x32, 0x32, 
        0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0xA4, 0x67, 0x67, 0x35, 0x35, 0x35, 0x35, 0x35,
  0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0xAC, 0xBC, 0xBC, 0xBC, 0xD4, 0xD4, 0xD4, 0x10, 0x25, 0xAD, 0x25, 0xF0, 0x29, 0x26, 0x26, 0x26, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 
        0x90, 0x90, 0x90, 0x1E, 0x90, 0x90, 0x21, 0x90, 0x90, 0x21, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0xCD, 0xCD, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 
        0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x55, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0x5F, 0x23, 0x23, 0x89, 0x89, 0xA3, 0x89, 0xA3, 0x89, 0x04, 0x04, 0xA3, 0x55, 0x55, 0xA3, 0x04, 0x55, 0x89, 0x55, 0x55, 0x89, 0x89, 
        0x89, 0x23, 0x23, 0x23, 0xDF, 0x5F, 0x23, 0x5F, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x92, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0xF2, 0xF2, 0xF2, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0xA3, 0x55, 0x04, 0x04, 0x04, 0x2E, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x9D, 0x1B, 0x73, 0x42, 0x9B, 0x77, 0x11, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 
        0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x22, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 
        0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x4E, 0x41, 0x41, 0x41, 0x96, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 
        0xB1, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0x6B, 0x6B, 0x6B, 0x7E, 0x7E, 0x6A, 0x57, 0x57, 0x57, 0x57, 0xB7, 0x2D, 0x50, 0xB6, 0x54, 0x3F, 0x3F, 0xE0, 0x4B, 0x4B, 0x33, 0xF5, 0x48, 0x48, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x30, 
        0x30, 0x30, 0x30, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
  0x08, 0x08, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x27, 0x96, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0x3A, 0xD4, 0x44, 0xAD, 0x25, 0x29, 0xF0, 0x26, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 
        0x22, 0x22, 0x21, 0x21, 0xCD, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0xAE, 0xAE, 0x73, 0x1B, 0x73, 0x1B, 0x73, 
        0x73, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0xDC, 0x1F, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x9C, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x1F, 0x1F, 0x9D, 0x1F, 0x1F, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0xAE, 0xAE, 
        0x86, 0xAE, 0x42, 0x86, 0x86, 0x42, 0xAE, 0x86, 0xAE, 0x17, 0xAE, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x37, 0x84, 0x84, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x23, 0x23, 0x5F, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x5F, 0x23, 0x5F, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0xF2, 0xF2, 0x8C, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 
        0x02, 0x02, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0xA3, 0xA3, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1B, 
        0x1B, 0x17, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x13, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x15, 0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0xCD, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 
        0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x2C, 0x2C, 0xD1, 0x41, 0x27, 0x27, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x6D, 0xC1, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 
        0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x6B, 0xBF, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0xEB, 0x57, 0x5C, 0xB7, 0x5C, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x54, 0xC4, 0x3F, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0xB5, 
        0x33, 0x33, 0x33, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x96, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD1, 
        0x2C, 0x2C, 0xE4, 0xE4, 0x36, 0x34, 0x38, 0xD3, 0x44, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x22, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x12, 0x91, 0x11, 0x11, 0x11, 0x1A, 0x13, 0x9B, 0x86, 0x17, 
        0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x98, 0x98, 0x84, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0xA3, 0x89, 0x89, 0x89, 0x5F, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0xFE, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 0x98, 0x2E, 0x2E, 0x37, 0x37, 0x37, 0x37, 0x37, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x78, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 
        0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x3A, 0xBC, 0x36, 0x36, 0x36, 0x36, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0xD2, 0xD2, 0x27, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 
        0xB2, 0x0C, 0xCB, 0xD8, 0xE2, 0x0E, 0x0E, 0x75, 0xC0, 0x93, 0x0D, 0xA6, 0xB8, 0x6A, 0x6A, 0x1C, 0x57, 0x1C, 0x57, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x50, 0x54, 0xC4, 0xC4, 0x3F, 0x3C, 0x3C, 0x4B, 0xB5, 0xB5, 0xB5, 0x33, 0x33, 0x48, 0x48, 
        0xA2, 0xA2, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53,
  0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0x44, 0xD5, 0xD5, 0xAD, 0x25, 0x29, 
        0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x24, 0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x22, 0x22, 0x24, 0x24, 0x24, 0x22, 0xCD, 0x7D, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x20, 0x80, 0x14, 0x14, 
        0x14, 0x12, 0x12, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0x77, 0x77, 0x1A, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x17, 0x1B, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x37, 0x05, 0x37, 0x84, 0x84, 0x84, 0x98, 0x37, 0x2E, 0x84, 0x2E, 0xFE, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 
        0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0xDF, 0xA3, 0x04, 0x04, 0x04, 0x84, 0x84, 0x05, 0x05, 0x1F, 0x9D, 0x31, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 0x21, 0x7D, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 
        0x26, 0x26, 0x87, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x34, 0x5A, 0x2B, 0x2B, 0x2B, 0x4E, 0x2C, 0x96, 0x96, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0xBB, 0x08, 0x08, 0x08, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 
        0xB1, 0x0D, 0xA6, 0xBF, 0x1C, 0x1C, 0xC5, 0xB7, 0x2D, 0x2D, 0x50, 0xBE, 0x54, 0x54, 0x54, 0xC4, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xC4, 0xC4, 0x3F, 0x54, 0x3F, 0xC4, 0xC4, 0xC4, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0x33, 0x33, 0xF5, 
        0x48, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x4F, 0x4F, 0x99, 0x99, 0x30, 0x30, 0x53, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0xA4,
  0xCC, 0xCC, 0xA9, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0xD4, 0xD3, 0x10, 0x25, 0x25, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x22, 0xCD, 0xCD, 0xCD, 0xCD, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 
        0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 
        0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x84, 0x84, 0x98, 0x37, 0x98, 0x98, 0x98, 0x37, 0x98, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 
        0xA3, 0xA3, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 0x89, 0x89, 0x04, 0x89, 
        0x89, 0x89, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x5F, 0x55, 0x04, 0x04, 0x04, 0x04, 
        0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x66, 0x9C, 0x1F, 0x1D, 0xDC, 0x1D, 0x1D, 0x1F, 0x9D, 
        0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x15, 0x15, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x21, 0x21, 0x22, 0x24, 0x19, 0x79, 0x26, 0x26, 0x25, 0x25, 0x25, 0x25, 
        0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x2C, 0x96, 0x27, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0xB3, 
        0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xD8, 0xE2, 0x0E, 0x0E, 0x93, 0x0D, 0x0D, 0x7E, 0x1C, 0x57, 0x57, 0x2D, 0xBE, 0x3F, 0x3F, 0x4B, 0x56, 0x48, 0x6E, 0x2F, 0x4D, 0x2A, 0x2A, 0x99, 0x30, 0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 
        0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A,
  0x25, 0x25, 0xEE, 0x25, 0x29, 0x25, 0x25, 0x5E, 0xD5, 0xD5, 0xD5, 0xD5, 0x44, 0x44, 0x44, 0x44, 0xD4, 0xD4, 0xD4, 0xD4, 0x3A, 0x3A, 0xD4, 0x3A, 0x3A, 0x3A, 0x3A, 0x44, 0x44, 0x10, 0x10, 0x10, 0x25, 0x29, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x12, 
        0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0xCE, 0xCE, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 
        0x05, 0x37, 0x37, 0x84, 0x84, 0x37, 0x3D, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x55, 0xA3, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x84, 0x2E, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0xCE, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 
        0x90, 0x21, 0x21, 0x21, 0x24, 0x79, 0x79, 0x26, 0x87, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34, 0x2B, 0x2B, 0x2B, 0x41, 0x96, 0x27, 0x94, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0xCB, 
        0x0E, 0x0E, 0x0E, 0x0E, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 0xBF, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x54, 
        0x3F, 0x3F, 0x3C, 0xB5, 0x33, 0x33, 0x33, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x4F,
  0x07, 0x07, 0x07, 0xCC, 0xCC, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xBC, 0x34, 0x34, 0x38, 0xD3, 0xD3, 0x10, 0xEE, 0x25, 0x5E, 0x26, 0x26, 0x26, 0x19, 0x19, 0x24, 0x22, 0xCD, 0x90, 0x90, 0x90, 0x1E, 0x80, 
        0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x17, 0x17, 0x73, 0x1B, 0x9D, 0x9D, 0x1D, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0xF2, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 
        0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 
        0x24, 0x19, 0x79, 0x26, 0x29, 0x29, 0x25, 0x10, 0x10, 0x3A, 0x34, 0x2B, 0x2B, 0x2B, 0xAB, 0x4E, 0x41, 0x27, 0x27, 0x94, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 
        0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0xB1, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xBF, 0x0D, 0x0D, 0xB8, 0xB8, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0xB7, 0xB7, 0x2D, 0x2D, 0x50, 0xB6, 
        0xC4, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x48, 0x48, 0x2F, 0x2F, 0x4D, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x30, 0x53, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0xA4, 0xA4, 0x67, 0x35, 0x35,
  0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0xEC, 0x38, 0xD3, 0x10, 0x25, 0xEE, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x18, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x9D, 0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x9D, 0x1F, 0x1F, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0xA3, 0xA3, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0xF2, 0x97, 0x97, 0xF2, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x85, 0x01, 0x01, 0x0A, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x3D, 0x2E, 0x98, 0x37, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 
        0x1F, 0x1D, 0x1B, 0x1B, 0x73, 0xAE, 0xAE, 0x17, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x78, 0x14, 0x80, 0x80, 0x1E, 0x90, 
        0x21, 0x21, 0x19, 0x19, 0x19, 0x79, 0x26, 0x29, 0xF0, 0x26, 0x5E, 0x25, 0x25, 0xAD, 0x10, 0x10, 0x10, 0x34, 0xEC, 0x2B, 0x2B, 0x36, 0x2B, 0x4E, 0x2C, 0xD2, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x6B, 0x7E, 0x1C, 0x1C, 0x57, 0x2D, 0x50, 0x50, 0xB6, 0x3F, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0x56, 0x33, 0x48, 
        0x48, 0x48, 0x6E, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x99, 0x99, 0x30, 0x99, 0x99, 0x30, 0x30, 0x30,
  0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0xAB, 0xAB, 0xAA, 0xAA, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x10, 0xED, 0xED, 0x44, 0xAD, 0xAD, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x87, 
        0x26, 0x26, 0x26, 0x26, 0x26, 0x28, 0x28, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 
        0x9D, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0xA3, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0xA3, 0xA3, 
        0x89, 0xA3, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 
        0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 
        0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0xFE, 0x3D, 0x3D, 0x2E, 0x2E, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x98, 0x98, 0x84, 0x98, 0x84, 0x37, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x13, 0x77, 0x0F, 0x12, 0x78, 0x78, 0x14, 0x1E, 0x1E, 0x21, 0x24, 0x24, 0x19, 
        0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x36, 0xAB, 0x4E, 0x4E, 0x4E, 0x41, 0x96, 0x27, 0x27, 0x94, 0x94, 0x65, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 
        0xB2, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0x0E, 0xC0, 0x93, 0x0D, 0x0D, 0x6B, 0x0D, 0x6B, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x50, 0xB6, 0xB6, 0x3F, 0xC4, 0x3F, 0xC4, 0xC4, 0x3C, 0x3C, 0x3F, 0x3C, 0x3C, 0x3C, 
        0x4B, 0x4B, 0x4B, 0xB5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x48, 0x48,
  0xBC, 0x34, 0x38, 0xD3, 0xED, 0xED, 0x44, 0xAD, 0xEE, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x5E, 0x29, 0xF0, 0xF0, 0x29, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0xD5, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x9B, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0xDF, 0xDF, 
        0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x97, 0x0A, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x97, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x04, 0x89, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x3D, 0x2E, 0x84, 0x98, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x66, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x29, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x2B, 0xE4, 0xAA, 0xAB, 0xD1, 0x96, 0x27, 0x94, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 
        0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xB8, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0xB7, 0x50, 0x50, 0x50, 0x50, 0xB6, 0x54, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x56, 0x33, 0x33, 0x48, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A,
  0x2B, 0x2B, 0xAC, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0xD3, 0xD3, 0xD3, 0x10, 0x10, 0x10, 0x38, 0x3A, 0x3A, 0x3A, 0xD3, 0xD3, 0xD4, 0xD4, 0xD4, 0x44, 0x44, 0x44, 0x44, 0xAD, 0xAD, 0xAD, 0xD5, 0x29, 0x25, 
        0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x24, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x0F, 0x0F, 0x77, 0x77, 0x86, 0x86, 0xAE, 
        0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x2E, 0x84, 0x3D, 0x3D, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 
        0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x1D, 0x1F, 0xFD, 0x9C, 0x05, 0x05, 0x84, 0x98, 0x98, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0xA3, 0x89, 0x89, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0xA3, 0x89, 0x89, 0xA3, 0x55, 0x04, 0x55, 0x55, 0x04, 0x55, 
        0xA3, 0xA3, 0xA3, 0x55, 0x89, 0x89, 0x89, 0x5F, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x0A, 0x01, 0x01, 0x97, 0x97, 0x0A, 0x0A, 0x0A, 0x97, 0x8C, 0x8C, 0x97, 0x0A, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x92, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x5F, 0x5F, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x55, 0x55, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0xFE, 0xFE, 0x98, 0x98, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1F, 0x1D, 0x1B, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x79, 0x26, 0x87, 0x29, 0x25, 0x25, 0x38, 0x34, 0x2B, 0xE4, 0x96, 0x27, 0x94, 0x07, 0xBB, 0x08, 0x08, 0xB3, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 
        0x0C, 0xCB, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0x75, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0xB7, 0xB7, 0xB7, 0xB7, 0x2D, 0x2D, 0x50, 0x50, 0x50, 
        0x50, 0x50, 0xBE, 0xBE, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0xBE, 0x50, 0x54, 0x54, 0x3F, 0x3F, 0x3C, 0x3C, 0x4B, 0xB5, 0x33, 0x33, 0x48, 0xA2, 0x2F, 0x2F, 0x2F, 0xA5,
  0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0xD4, 0x3A, 0x3A, 0xD4, 0xD4, 0x3A, 0x3A, 0x3A, 0x34, 0x34, 0x3A, 0x34, 0x34, 0xAC, 0xAC, 0x2B, 0x2B, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x36, 0x36, 0x2B, 0xAC, 0x34, 0x34, 0x34, 0x34, 0xD3, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 
        0x29, 0x29, 0x26, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 
        0x77, 0x77, 0x77, 0x13, 0x86, 0xAE, 0x17, 0x17, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x84, 0x84, 0x2E, 0xFE, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x89, 0x04, 0x04, 0x89, 0x89, 0x04, 0x55, 0x55, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x89, 0x23, 0x23, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0xF2, 0x0A, 0x97, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x92, 0x85, 0x85, 0x01, 0x01, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0xFE, 0xFE, 0xFE, 0x2E, 0x2E, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x37, 0x37, 0x2E, 0x2E, 0x84, 0x37, 0x05, 0x37, 0x37, 0x05, 0x05, 0x9C, 0x1D, 0x9D, 0x17, 0x17, 0x86, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x14, 0x80, 
        0x1E, 0x90, 0x90, 0x19, 0x79, 0x79, 0x79, 0x29, 0x25, 0x25, 0x10, 0x10, 0x38, 0x34, 0xEC, 0x2B, 0x2B, 0x2B, 0x2B, 0x2C, 0xD2, 0xD2, 0xD2, 0x27, 0x49, 0xCC, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0x9F, 0x9F, 0xC6, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0xA6, 0x6B, 0x6B, 0x7E, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x57, 0x2D, 0x2D, 0x2D, 0x50, 
        0x50, 0x50, 0x54, 0x54, 0xC4, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0x56, 0x33, 0x33, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0xA5, 0xA5, 0xA5, 0x2A, 0x2A, 0x4F,
  0x36, 0x36, 0xAC, 0xAC, 0xEC, 0xEC, 0xEC, 0x34, 0x34, 0x3A, 0xD4, 0xD4, 0xD4, 0x38, 0x3A, 0x44, 0x44, 0x10, 0x10, 0x10, 0xAD, 0xAD, 0xAD, 0xD5, 0x25, 0x25, 0x29, 0x29, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x21, 
        0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x0F, 0x0F, 0x91, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x11, 0x11, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x66, 0x9C, 0x9C, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 
        0x05, 0x05, 0x1F, 0x9C, 0x05, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x98, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x97, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0xF2, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x98, 0x37, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x9D, 0x1D, 0x1B, 0x73, 0xAE, 0x17, 0x9B, 0x9B, 0x13, 0x11, 0x11, 0xCE, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x1E, 
        0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x19, 0x26, 0x26, 0x19, 0x79, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0xF0, 0x25, 0x25, 0x25, 0x10, 0x10, 0x34, 0x34, 0x36, 0xAA, 0x2C, 0x27, 
        0x94, 0x07, 0xC1, 0x08, 0x08, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0xA6, 0xA6, 0xBF, 0x1C, 0x6A, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0x5C, 0x2D, 0x5C, 0x2D, 0x2D, 0x2D, 0xBE, 0x50, 0x50, 0xBE, 0x50, 0x50, 0x50, 
        0x54, 0x54, 0x54, 0xC4, 0xC4, 0xC4, 0x3F, 0x3F, 0x3C, 0x3C, 0xEA, 0xEA, 0xEA, 0xB5, 0x33, 0x33, 0x48, 0x48, 0x6E, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x99, 0x99,
  0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xC7, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0xD4, 0xD4, 0xD3, 0xD3, 0xD3, 0xD3, 0xED, 0xED, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAD, 0xAD, 
        0xAD, 0xEE, 0x25, 0x29, 0x26, 0xEF, 0x26, 0x26, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x77, 0x13, 0x77, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0xFD, 0xFD, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 
        0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x02, 0x02, 0x8C, 
        0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x5F, 0x89, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x37, 0x37, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x19, 0x19, 0x79, 0x26, 0x87, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x34, 0x34, 0x2B, 0xAB, 0xAB, 0x2C, 0x2C, 0x96, 
        0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x6D, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x75, 0x88, 0x88, 0x88, 0x0D, 0x0D, 
        0x0D, 0x6B, 0x6B, 0x6A, 0x6A, 0x1C, 0x1C, 0x57, 0xB7, 0xB7, 0x2D, 0x50, 0x50, 0x50, 0x54, 0x3F, 0x3C, 0x3C, 0x4B, 0x4B, 0x56, 0xF6, 0x33, 0x48, 0x48, 0xA2, 0x6E, 0x6E,
  0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0xD1, 0xD1, 0x2C, 0x2C, 0x2C, 0xAA, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x44, 0xAD, 0x29, 0x29, 0x26, 
        0x26, 0x79, 0x24, 0x22, 0x22, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 
        0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x1B, 0x9D, 0x9D, 0x9D, 0xFD, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x98, 0x84, 0x2E, 0x3D, 0x3D, 0x2E, 0xFE, 0x3D, 0x2E, 0x84, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x23, 0xDF, 0xDF, 0x02, 0x02, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0xCA, 0xCA, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0xFD, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 
        0x78, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x79, 0x79, 0x79, 0x26, 0x29, 0x29, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 
        0x34, 0x2B, 0x2B, 0x4E, 0x41, 0xD2, 0x49, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0x7B, 0x0B, 0x0B, 0xA8, 0x8D, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0x0E, 0xB1, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xBF, 0xB8, 0xB8, 0xBF, 0x6A, 
        0x6A, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0x5C, 0x2D, 0xBE, 0xBE, 0xB6, 0x3F, 0x3C, 0x3C, 0x3C, 0xEA, 0x4B, 0x56, 0x56, 0x33, 0xF5, 0x48, 0xA2, 0x6E, 0x2F,
  0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x3A, 0xED, 0x44, 0xAD, 0xEE, 0xEE, 0x5E, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x24, 0x24, 0x24, 0x22, 0xCD, 0xCD, 
        0xCD, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x86, 
        0xAE, 0xAE, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0xDC, 0x1D, 0x1D, 0x1D, 0x66, 0x66, 0x9C, 0x9C, 0x05, 0x05, 0x84, 0x84, 0x98, 0x2E, 0x2E, 0x3D, 0xFE, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x89, 0x55, 0x5F, 0x5F, 0x5F, 
        0xDF, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0xF2, 0xF2, 0x6C, 0x6C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 
        0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x5B, 0x16, 0xE6, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x03, 
        0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0xF2, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 
        0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1B, 0x1B, 0x1B, 0xAE, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x11, 0x11, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x0F, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x91, 0x12, 0x12, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x38, 0x34, 0x2B, 0xE4, 
        0x4E, 0x41, 0x94, 0xCC, 0x07, 0x6D, 0x74, 0x08, 0x08, 0x7B, 0x8A, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xC0, 0xC0, 0x0D, 0xA6, 0xBF, 0xBF, 0x6A, 
        0x1C, 0x1C, 0xEB, 0x5C, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0xB6, 0x54, 0x54, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0xEA, 0x4B, 0x4B, 0xB5, 0xB5, 0xB5, 0x56, 0x33, 0x33,
  0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x27, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0x36, 0x2B, 0x34, 0x38, 0xD3, 0x10, 0x25, 0x26, 0x26, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x7D, 0x7D, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 
        0x12, 0x12, 0x12, 0x91, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0xF1, 0xCE, 0x11, 0x11, 0x11, 0x77, 0x1A, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 
        0x2E, 0x84, 0x2E, 0x3D, 0x3D, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x2E, 0x2E, 0xFE, 0x3D, 0x3D, 0x3D, 0x2E, 0xFE, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 
        0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 
        0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x23, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x91, 0x12, 0x78, 0x78, 0x14, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x10, 
        0x38, 0x34, 0x2B, 0x2B, 0x36, 0x4E, 0x4E, 0x96, 0xD2, 0x27, 0x49, 0xCC, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x88, 
        0x88, 0x88, 0x0D, 0x0D, 0xB8, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x54, 0x3F, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xEA, 0xEA, 0xB5, 0xB5,
  0xAB, 0xAB, 0x2B, 0x36, 0x36, 0x36, 0x36, 0xAC, 0xAC, 0xBC, 0xBC, 0x34, 0x3A, 0xD4, 0xD3, 0xD3, 0xED, 0x44, 0xD3, 0x44, 0x44, 0x44, 0x44, 0xD4, 0x44, 0xD5, 0xD5, 0xD5, 0xEE, 0x25, 0x29, 0x29, 0x29, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 
        0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x86, 0xAE, 0x1B, 0x1B, 0x1B, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0xFD, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x98, 0x84, 0x2E, 0x3D, 0x2E, 0x3D, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0xDF, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 
        0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x92, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0xF2, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x84, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1B, 0x1B, 0x73, 0x17, 0xAE, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 
        0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 
        0x10, 0x38, 0x34, 0x2B, 0x2B, 0xAB, 0x41, 0x27, 0xA9, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xB8, 0x6A, 
        0x6A, 0x1C, 0x1C, 0xC5, 0x2D, 0x2D, 0x50, 0x54, 0x54, 0x3F, 0x3C, 0xEA, 0xEA, 0xEA, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3F, 0x3C,
  0x2B, 0x2B, 0x36, 0x36, 0x36, 0x36, 0x36, 0xC7, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0xBC, 0x34, 0x3A, 0xD3, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x24, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0x13, 0x13, 0x17, 0x17, 0xAE, 
        0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x84, 
        0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0x55, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x5F, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x23, 0x89, 0x89, 0x89, 0x89, 0xA3, 0x89, 0x89, 0x55, 
        0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x9C, 0x66, 0x1D, 0x1D, 
        0x1D, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x24, 0x19, 0x79, 0x79, 0x29, 0x29, 0x29, 0x25, 0xAD, 0xED, 0xD3, 0x3A, 0x34, 0xAC, 
        0x36, 0x2B, 0xAB, 0xC2, 0x27, 0x27, 0x94, 0xCC, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0x1C, 0x1C, 
        0x57, 0xC5, 0x57, 0x57, 0x5C, 0x2D, 0x2D, 0x50, 0x50, 0xBE, 0x50, 0x54, 0x54, 0x3F, 0xC4, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x4B, 0xB5, 0xB5, 0xB5, 0xB5, 0x33, 0x33,
  0x07, 0x07, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0xE4, 0x36, 0x36, 0x36, 0xAC, 0xBC, 0xEC, 0x34, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0xD3, 0x44, 0x44, 0x44, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 
        0x24, 0x24, 0x21, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x86, 0x13, 0x86, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x17, 0xAE, 0xAE, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x9D, 0x1D, 0x66, 0x66, 0x66, 0x66, 0x1F, 
        0x9C, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 
        0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x92, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x92, 0x92, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x97, 0x0A, 0x97, 
        0x02, 0x02, 0x02, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x1F, 
        0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x19, 0x79, 0x19, 0x19, 0x79, 0x79, 0x29, 0x29, 0x29, 0x25, 0x25, 
        0x10, 0x10, 0x38, 0xEC, 0x36, 0xAB, 0x2C, 0xD1, 0x96, 0x27, 0x27, 0xCC, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB9, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x8F, 0x8F, 0x9F, 
        0x0E, 0x0E, 0x75, 0x93, 0x88, 0x0D, 0x6B, 0x6A, 0x1C, 0x1C, 0x57, 0x2D, 0x2D, 0x50, 0x3F, 0xC4, 0x3C, 0x4B, 0x33, 0x33, 0x48, 0x2F, 0x2F, 0xA5, 0xA5, 0x2A, 0x4F, 0x99,
  0x38, 0xD3, 0x10, 0x44, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 
        0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0xDE, 0xDE, 0x12, 0xDE, 0xDE, 0x12, 0x91, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x11, 0x11, 0x1A, 0x77, 0x13, 0x9B, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0xFE, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0xFE, 0xFE, 0x3D, 0x3D, 0xFE, 0xFE, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x55, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x82, 0x82, 0x16, 0x5B, 0x03, 0x16, 0x16, 
        0x16, 0xE6, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x5B, 0x16, 0x16, 0x16, 0x60, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 
        0xFE, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x2E, 0x98, 0x84, 0x98, 0x98, 0x3D, 0xFE, 0xFE, 0xFE, 0x3D, 0x04, 0x2E, 0xFE, 0xFE, 0xFE, 0x3D, 0x04, 0x04, 0x84, 0x84, 0x2E, 
        0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 
        0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x34, 0x34, 0x2B, 0x2B, 0x41, 0x41, 0xCC, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xE2, 0x0E, 0x0E, 0x75, 0x93, 0x93, 0x0D, 0x0D, 0x6B, 0x6A, 0x6A, 0x1C, 0x57, 0x57, 0x2D, 0x2D, 0x2D, 
        0x50, 0x54, 0xB6, 0x3F, 0x3F, 0x3C, 0x3C, 0x4B, 0x4B, 0x56, 0x56, 0x33, 0x33, 0x33, 0x48, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0xC2, 0x2C, 0xAA, 0x36, 0x36, 0xBC, 0xBC, 0x3A, 0x3A, 0xD4, 0x44, 0x44, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x87, 0x26, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 
        0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x9B, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 
        0x1F, 0x05, 0x05, 0x05, 0x37, 0x05, 0x37, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x55, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0xFE, 0x2E, 0x2E, 0x84, 0x84, 
        0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x05, 0x37, 0x84, 0x84, 0x98, 0x37, 0x84, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0xF2, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x5B, 0x5B, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x51, 0x62, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 0x51, 0x51, 
        0x62, 0x62, 0x51, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x16, 0x16, 0xE6, 0xE6, 0xE6, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x97, 0x97, 0x97, 0xF2, 0x6C, 0x6C, 
        0x6C, 0x6C, 0x02, 0x02, 0xF2, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0xFE, 0x3D, 0x2E, 0x2E, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0xFD, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 
        0x9D, 0x1D, 0x1B, 0x1B, 0x73, 0x73, 0x17, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 
        0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x4E, 0x4E, 0x96, 0x27, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0xB3, 0xB3, 0x0B, 0x0B, 0xB3, 0xB3, 0x0B, 0xB3, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x8D, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0xC6, 0x0E, 0x0E, 0x75, 0x93, 0x75, 0x93, 0x88, 0x0D, 0x0D, 0x0D, 0x6B, 0x6B, 0x6B,
  0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x96, 0xAA, 0xAA, 0x36, 0x3A, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8E, 0x18, 0x18, 0x18, 0x14, 0x14, 0x14, 0x14, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 
        0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x9B, 0x9B, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x17, 0x17, 0x73, 0x73, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 
        0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x98, 0x2E, 0x2E, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x97, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 
        0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x5B, 0xE6, 0x16, 0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x60, 0x60, 0xE6, 0xE6, 0x16, 0xE6, 0xE6, 
        0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x03, 0x09, 0xCA, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0x03, 0x03, 0xCA, 0xCA, 0xFF, 
        0x92, 0x09, 0x92, 0x09, 0x85, 0x85, 0x85, 0x85, 0x92, 0x92, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x55, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 
        0x2E, 0x2E, 0x84, 0x37, 0x37, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x13, 0x0F, 0x0F, 0x91, 0x78, 0x78, 0x14, 0x1E, 0x1E, 0x90, 0x90, 0x24, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x38, 
        0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x36, 0xBC, 0xBC, 0xBC, 0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x96, 0x27, 0x27, 0x94, 0x07, 0x07, 0xC1, 0xDD, 0x08, 
        0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x75, 0x75, 0x93, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0xB7, 0xB7, 0x2D, 0x2D, 0x2D,
  0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xD0, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x36, 0x36, 0xEC, 0xD3, 0xD4, 0x44, 0x25, 0x29, 0x26, 0x26, 0x19, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x80, 
        0x80, 0x80, 0x78, 0x14, 0x14, 0x78, 0x14, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x24, 0x22, 0x22, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 
        0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x73, 0x73, 0x1D, 0x9D, 0x9D, 0x05, 0x05, 0x37, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x55, 0x55, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 
        0x6C, 0x8C, 0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x2E, 0xFE, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 
        0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x89, 0x89, 
        0x04, 0x04, 0x2E, 0x05, 0x05, 0x05, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x13, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x19, 
        0x19, 0x79, 0x26, 0x29, 0x29, 0x25, 0xAD, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x2B, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0xDA, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 
        0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x5C, 0x2D, 0x2D, 0xBE, 0x50, 0xB6, 0x54, 0x54, 0x54, 0x3F,
  0x8A, 0xA0, 0xA0, 0x08, 0x08, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x74, 0x74, 0x74, 0x74, 0x08, 0x08, 0x74, 0xBB, 0x74, 0x74, 0x74, 0xDA, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x96, 0x2C, 0xAA, 0x36, 0x34, 0x38, 0x38, 0x10, 0x25, 
        0x29, 0x26, 0x19, 0x19, 0x21, 0x90, 0x1E, 0x80, 0x14, 0x78, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 
        0x91, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x1F, 0x1F, 0x1F, 0x1F, 0x9C, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x89, 0x55, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x55, 0x55, 
        0x04, 0x89, 0x89, 0xA3, 0x55, 0xA3, 0xA3, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x09, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 
        0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x98, 0x05, 0x05, 0xFD, 0x9D, 0x1D, 0x73, 0x17, 0x86, 0x1A, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x15, 0xFC, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x90, 0x22, 
        0x24, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x87, 0xF0, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x34, 0xBC, 0x36, 0xAB, 0xAB, 0x2C, 0x2C, 0xD1, 0x96, 0x27, 0x94, 0xCC, 0x07, 0x07, 0xC1, 0x08, 0x08, 0x08, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 
        0xB2, 0x0C, 0x0C, 0xCB, 0xCB, 0xC6, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0xA6, 0xA6, 0x6A, 0x6A, 0x1C, 0x57, 0xB7, 0xB7, 0x50, 0x50, 0x50, 0x50, 0x50, 0x54, 0xB6, 0x3F, 0x3F,
  0xA7, 0xA8, 0x0B, 0xB3, 0xA0, 0x08, 0x74, 0x07, 0x07, 0x65, 0x27, 0x2C, 0x2C, 0x2B, 0x34, 0x38, 0x10, 0x10, 0xEE, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x22, 
        0x22, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 
        0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0x9D, 0x9D, 0x9D, 0x9D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x98, 0x98, 
        0x3D, 0x3D, 0xFE, 0xFE, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0xFE, 0x3D, 0xFE, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0x89, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x92, 0x09, 0x09, 0xCA, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x2E, 0x3D, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x1D, 0x1B, 0x73, 0x17, 0x86, 0x9B, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0xCD, 0x90, 0x90, 0x21, 0x21, 0x7D, 0x24, 0x24, 0x19, 0x19, 0x79, 0x28, 0x26, 0x25, 0x25, 0x25, 0x38, 0x34, 0x34, 0xE4, 0x4E, 0x61, 0x49, 0x07, 0x6D, 0x74, 0x08, 0xB3, 0x0B, 0x0B, 0xB2, 0x0C, 0xCB, 0x0E, 0x0E, 
        0xB1, 0xC0, 0x93, 0x0D, 0xA6, 0x6B, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
  0x07, 0x07, 0x07, 0x07, 0xCC, 0x94, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0xAA, 0x2B, 0x2B, 0x34, 0x38, 0xD3, 0x10, 0x25, 0x25, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 
        0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x73, 0x1D, 0x9D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x98, 0xFE, 0x04, 0x04, 0x04, 0x55, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 
        0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 
        0x70, 0x70, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0xF2, 0x8C, 0x6C, 0xF2, 0xF2, 0xF2, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x98, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0x1D, 0x1D, 0x17, 0x86, 0x86, 0x86, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 
        0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x44, 0x38, 0x34, 0xAC, 0x2B, 0xAB, 0x96, 0x27, 0x07, 0x07, 0x07, 0xBB, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 
        0xE2, 0x0E, 0x0E, 0xB1, 0xC0, 0x93, 0x0D, 0x6B, 0x6A, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x57, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x54, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0xEA, 0x4B,
  0xD2, 0xD1, 0xD1, 0x2C, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x44, 0x10, 0x10, 0xAD, 0x25, 0xEE, 0x29, 0x29, 0x25, 0xF0, 0x26, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 
        0x24, 0x21, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0x29, 0x29, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x77, 
        0x13, 0x86, 0x86, 0xAE, 0x1B, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x31, 0x9D, 0x9D, 0x1D, 0xDC, 0x1D, 0x9D, 0x1D, 0x9D, 0x9D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0xCA, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0xCA, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 
        0x97, 0x8C, 0xF2, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 
        0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x98, 0x05, 0x05, 0x9C, 0x66, 0x1D, 0x9D, 0x1B, 0x1B, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x87, 0x29, 0x25, 0x25, 0x10, 0x38, 0x34, 0x2B, 0xAB, 0x41, 0x27, 0x94, 0x07, 0x07, 0xDA, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0xA8, 0xA8, 0xB9, 0x0C, 0xCB, 0xCB, 0xE2, 0xC6, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xC0, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0x6B, 0x6A, 0x1C, 0x6A, 0x1C, 0x57, 0x57,
  0xAA, 0x36, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x3A, 0x3A, 0x3A, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x29, 0x29, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 
        0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x0F, 0x77, 0x11, 0x11, 0x77, 0x13, 0x13, 0x13, 0x86, 0xAE, 0xAE, 0x1B, 0x1D, 0x9D, 0x1F, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 
        0x23, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x55, 0xA3, 0x89, 0x55, 0x55, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x89, 0x89, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x8C, 0x0A, 0x97, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 
        0x16, 0xE6, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x62, 0xD6, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 
        0x55, 0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x1F, 0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 
        0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2C, 0x2C, 0xC2, 0x27, 0x27, 0x94, 0x94, 0x65, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0x7B, 0xB3, 
        0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xC6, 0x0E, 0x0E, 0x93, 0x93, 0x0D, 0x0D, 0xA6, 0x6A, 0x1C, 0x1C, 0x57, 0xC5, 0x57, 0x5C, 0x2D, 0x2D, 0x50, 0x50,
  0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x19, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 
        0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x12, 0x12, 0x12, 0x0F, 0x77, 0x13, 0x13, 0x9B, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 
        0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x23, 0xA3, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x05, 0x05, 0x9C, 0x1F, 0x9D, 0x1D, 0x73, 0x17, 
        0x17, 0x86, 0x13, 0x77, 0x11, 0x11, 0x11, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x21, 
        0x21, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0xAB, 0xAB, 0x2C, 0x2C, 0xD2, 0xD2, 0xD2, 0x27, 0x27, 0x27, 0x27, 0x27, 0x94, 0xCC, 0x65, 0x65, 0x07, 
        0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xE2, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0xA6, 0xBF, 0x1C, 0x1C, 0x57,
  0x27, 0x41, 0x4E, 0x4E, 0x2B, 0x2B, 0x34, 0xD3, 0x10, 0x25, 0x25, 0x26, 0x26, 0x19, 0x24, 0x7D, 0x21, 0x90, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 
        0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 
        0x0F, 0x77, 0x13, 0x13, 0x13, 0x86, 0xAE, 0xAE, 0xAE, 0x73, 0x73, 0x1B, 0x1D, 0x1D, 0x9D, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x55, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0xF2, 
        0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0x85, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 
        0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x55, 0x04, 0x04, 
        0x04, 0xFE, 0x84, 0x84, 0x37, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 
        0x12, 0x78, 0x78, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0xF0, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x2C, 0x41, 
        0x27, 0x94, 0x94, 0x07, 0xBB, 0x08, 0x08, 0xA0, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0x8F, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E,
  0xBB, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x2C, 0xAA, 0xAA, 0xAB, 0x36, 0x36, 0x34, 0x38, 0xD3, 0xD3, 0xD3, 0x44, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x80, 0x80, 0x80, 
        0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x12, 0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x11, 0x77, 0x13, 0x13, 0xAE, 0xAE, 0xAE, 0x73, 0x1B, 0x31, 0xDC, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1F, 
        0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0xA3, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x02, 0x02, 0x23, 
        0x23, 0x02, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x70, 0x51, 0x70, 0x51, 0x51, 0x51, 0x51, 0x51, 
        0x70, 0x70, 0x51, 0x51, 0xE7, 0x70, 0xE7, 0x51, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 
        0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 
        0x89, 0x04, 0x04, 0x04, 0x84, 0x84, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 
        0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x10, 0x10, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x4E, 0x4E, 0x2C, 0xD2, 0x27, 0x27, 0x49, 0xCC, 0x65, 0xCC, 0xCC, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x6D, 0x6D, 0x74, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0xE2, 0x0E, 0x0E, 0xB1, 0x0D, 0x0D, 0xA6, 0xB8,
  0x07, 0x07, 0x65, 0xCC, 0x94, 0x27, 0x27, 0x41, 0xD1, 0x4E, 0x4E, 0x36, 0x2B, 0x5A, 0xEC, 0x34, 0x10, 0x10, 0x10, 0xAD, 0x29, 0xF0, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x26, 0x26, 0x79, 0x79, 0x79, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x90, 0x90, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 
        0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 
        0xFE, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x02, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x02, 0x6C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x5B, 0x5B, 0x5B, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0xE7, 0xE7, 0xE7, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 
        0x02, 0xDF, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x1D, 0x1F, 0x1F, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x12, 0x12, 0x12, 0x78, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 
        0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x38, 0x38, 0x34, 0x38, 0xAC, 0x2B, 0x2B, 0x2C, 0x2C, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x6D, 0xBB, 0xBB, 0x08, 0x08, 0x08, 
        0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
  0x07, 0x07, 0x07, 0x07, 0xCC, 0x27, 0x27, 0x61, 0xD1, 0xD1, 0x2C, 0xE4, 0x36, 0x2B, 0x2B, 0xAC, 0xEC, 0x38, 0xD3, 0x10, 0x44, 0x44, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x26, 
        0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 
        0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0xAE, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9C, 0x66, 0x1D, 0x9C, 0x9C, 0x9C, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x98, 0x84, 0x2E, 0xFE, 
        0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 
        0x5B, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x1F, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 
        0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0xBC, 0x36, 0x36, 0xAA, 0x2C, 0x2C, 0x96, 0x27, 0x27, 
        0x94, 0x07, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0x08, 0xA0, 0xA0, 0x0B, 0x0B, 0xA8, 0xB2, 0x0C, 0x0C, 0xCB, 0x0E, 0x0E, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x6A, 0x6A, 0x1C, 0x57,
  0x44, 0x10, 0x10, 0x10, 0xD3, 0xD4, 0xED, 0xED, 0xD3, 0x3A, 0x3A, 0xD4, 0x3A, 0x3A, 0x3A, 0x3A, 0x38, 0x38, 0x38, 0x38, 0xD3, 0xD4, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1B, 0x1B, 0x73, 0x73, 0x17, 0x17, 0x17, 
        0x86, 0xAE, 0xAE, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0xE5, 0xE5, 0x13, 0x17, 0x17, 0x17, 0xAE, 0xAE, 0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x66, 0x9C, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x2E, 0x98, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x89, 
        0x89, 0xA3, 0xA3, 0x89, 0x04, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x51, 0x51, 0x51, 0x51, 
        0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x62, 0x62, 0x06, 0x06, 0x60, 0x60, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0xE7, 0xE7, 0x62, 0x62, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 0x51, 0xD6, 0x51, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0xD6, 0xD6, 0x62, 0x62, 0xD6, 0xD6, 0x51, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x23, 0x89, 0x55, 0x04, 0x04, 0x2E, 0x84, 0x05, 0x9C, 0x9D, 0x17, 0x17, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x14, 0x14, 0x1E, 0x90, 
        0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x5A, 0x36, 0xAB, 0xD1, 0xD2, 0x27, 0x65, 0x07, 0x07, 0xC1, 0xC1, 
        0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0xA6,
  0x27, 0x27, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0xD2, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0x36, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x79, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x73, 0x73, 0x17, 0x73, 0x17, 0xAE, 0xAE, 0x17, 
        0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 0x37, 0x2E, 0x37, 0x37, 0x37, 
        0x2E, 0x2E, 0x98, 0x98, 0x2E, 0xFE, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 
        0x23, 0x23, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x92, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x16, 0xE6, 0x16, 0x16, 0xE6, 0x5B, 0x5B, 0x5B, 0x16, 0x5B, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x60, 0xE6, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0x09, 0x09, 0x09, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0xDF, 0xA3, 0x04, 0x04, 0x04, 0x84, 0x05, 0x05, 0x9D, 0x1B, 0x17, 0x86, 0x13, 0x0F, 0x0F, 0x12, 0x12, 0x78, 0x14, 0x14, 0x80, 
        0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x41, 0x41, 0x27, 0x27, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 
        0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x8A, 0xF8, 0x0B, 0x0B, 0xA8, 0xA8, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0xCB, 0xE2,
  0x7B, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0x2B, 0xAC, 0x38, 0xD3, 0x10, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x80, 0x80, 0x14, 0x8E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x80, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x9B, 0x9B, 0x17, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x1D, 0xDC, 0x9C, 0x9C, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0xDF, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 
        0xE6, 0x5B, 0x60, 0x16, 0x16, 0x06, 0x06, 0x06, 0x62, 0x62, 0x62, 0xE7, 0xD6, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70, 0x70, 0x52, 0x70, 0x70, 0x51, 0xE7, 0x62, 0x62, 0xE7, 0xE7, 
        0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x23, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x98, 0x98, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x9C, 0x9C, 0x1D, 0x1F, 0x9D, 0xDC, 0xDC, 0x1D, 0x1B, 0x73, 0x1B, 0x1B, 0x1B, 0x17, 
        0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x14, 0x14, 0x8E, 0x8E, 0x80, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x44, 0x10, 0xD3, 0x34, 0x34, 0x2B, 0x2B, 
        0x2B, 0x4E, 0x41, 0x27, 0x27, 0x49, 0xCC, 0x07, 0x6D, 0x6D, 0xDD, 0x74, 0x08, 0x08, 0x7B, 0x7B, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA7, 0xA7, 0x8D, 0x8D, 0x0C,
  0x0B, 0x0B, 0xB3, 0xB3, 0x8A, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x27, 0x27, 0x96, 0x2C, 0xAB, 0x36, 0xAC, 0x34, 0x34, 0x3A, 0x44, 0xAD, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x22, 0xCD, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 
        0x8E, 0x78, 0x78, 0x95, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0xCE, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 
        0x91, 0x12, 0x12, 0x91, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x13, 0x13, 0x13, 0x13, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 
        0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 
        0xE7, 0x06, 0x06, 0x06, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0xF2, 0x97, 0x8C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0xFE, 0x84, 0x98, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0xFD, 0xFD, 0x1F, 0xDC, 0x9D, 0x9D, 0x1D, 0x31, 0xDC, 0x1D, 0x73, 0x1B, 0x1B, 0x17, 0x17, 
        0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x79, 
        0x28, 0x26, 0x29, 0x25, 0x25, 0x10, 0x38, 0x34, 0xE4, 0x2C, 0x27, 0x65, 0x07, 0xC1, 0xDD, 0x08, 0x7B, 0x8A, 0x0B, 0xB2, 0x0C, 0x0C, 0x9F, 0xC6, 0x0E, 0x75, 0x75, 0x93,
  0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x29, 0x29, 0x26, 0x29, 0x26, 0xEF, 0x26, 0x26, 0x79, 0x26, 0x26, 0x26, 
        0x79, 0x79, 0x28, 0x71, 0x79, 0x28, 0x28, 0x79, 0x19, 0x19, 0x19, 0x24, 0x7D, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x12, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x17, 0x9B, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x9D, 0x9D, 0x1F, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x02, 
        0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 0x60, 0x06, 0x06, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0xE7, 0xD6, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 
        0x51, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 0x98, 0x05, 0x05, 0x05, 0x1F, 
        0x9D, 0x1D, 0x1B, 0xAE, 0x86, 0x13, 0x77, 0xCE, 0x0F, 0x91, 0x12, 0x78, 0x14, 0x14, 0x1E, 0x1E, 0x90, 0x90, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x10, 0x10, 0x10, 0x10, 0xED, 0x38, 0x38, 0x3A, 0xBC, 0x36, 0xE4, 0xE4, 0xE4, 0x2C, 0x96, 0x27, 0x94, 0x07, 0x07, 0xC1, 0xBB, 0x74, 0x08, 0x08, 0xA0, 0xB3, 0x0B,
  0xDD, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0xA9, 0x27, 0x96, 0xD1, 0x2C, 0x2B, 0x2B, 0x2B, 0x34, 0x38, 0x38, 0x10, 0x10, 0x44, 0x10, 0x10, 0xAD, 0xAD, 0x25, 0x25, 0x10, 0x25, 0x25, 0x25, 0xAD, 0xAD, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x78, 0x78, 0x78, 0x95, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0xDC, 0x1D, 0x1F, 0x1D, 0x9C, 0x9C, 0x66, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x2E, 
        0x2E, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x23, 0x02, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x85, 0x85, 0xCA, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 
        0x03, 0x03, 0x09, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x89, 0x04, 0x89, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 
        0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x97, 0x97, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9D, 0x9D, 0x1B, 
        0x73, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x1A, 0x77, 0x77, 0xCE, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x34, 0x34, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x4E, 0x2C, 0x41, 0xD2, 0xD2, 0x49, 0x49, 0x49, 0x94, 0x94, 0x07, 0x07, 0x07,
  0xA8, 0x0B, 0x0B, 0xB3, 0x08, 0x08, 0x08, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x2C, 0xAA, 0xC7, 0x36, 0x36, 0x2B, 0x2B, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0xAC, 0x36, 0x34, 0x34, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x38, 0x10, 0x25, 
        0x25, 0x25, 0x29, 0x29, 0x79, 0x79, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 
        0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x1D, 0x1D, 0x1F, 0x1D, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1D, 0x1F, 0x9C, 0xFD, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x2E, 
        0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x55, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0xDF, 0x23, 0xDF, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x82, 0x82, 0x16, 0x16, 0x03, 0x03, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0xD6, 
        0xD6, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x37, 0x05, 0x05, 0x9C, 0x1F, 0x9D, 0x31, 0x73, 0x17, 0xAE, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x77, 
        0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0xCE, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x90, 0x90, 0x90, 0x21, 0x24, 0x79, 0x26, 0x29, 0x29, 0x25, 0x38, 0x34, 0x34, 
        0x2B, 0x41, 0xD2, 0x27, 0x07, 0x07, 0xC1, 0xBB, 0x08, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0xBA, 0xB2, 0x0C, 0x0C, 0x8F, 0x8F, 0x8F, 0xE2, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x0E,
  0xE4, 0x2B, 0xE4, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xAC, 0xAC, 0x5A, 0xEC, 0xAC, 0x34, 0x38, 0x38, 0x10, 0x10, 0x44, 0x25, 0x25, 0x25, 0xF0, 0x29, 0x26, 0x79, 0x79, 0x79, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x12, 0x91, 
        0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x78, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 
        0x1E, 0x80, 0x80, 0x78, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x11, 0x77, 0x77, 0x13, 0x9B, 0x13, 0x13, 0x17, 0x17, 0x9B, 0x17, 0x86, 0x86, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0x17, 
        0x1B, 0x1B, 0x9D, 0x9D, 0x1F, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x37, 0x2E, 0x84, 0x3D, 0x3D, 0x98, 0x2E, 0x3D, 0x04, 0x3D, 0x04, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x02, 0x23, 0x02, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x51, 
        0xE7, 0x51, 0x51, 0x51, 0x70, 0x70, 0x70, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70, 0x52, 0x52, 0x51, 0x70, 0x70, 0x51, 0xE7, 0x70, 0x70, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 
        0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x03, 0xE6, 0x5B, 
        0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x92, 0x92, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x66, 0x1D, 0x1D, 0x1D, 0x73, 0x17, 0x17, 0x17, 0x9B, 0x9B, 
        0x13, 0x1A, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x95, 0x78, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x25, 0x25, 0x10, 0x34, 
        0x36, 0xAB, 0xD2, 0x94, 0x07, 0xBB, 0x08, 0xB3, 0x0B, 0xB2, 0x0C, 0x0C, 0xE2, 0x0E, 0xB1, 0xC0, 0xC0, 0x0D, 0x6B, 0x6B, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57,
  0x27, 0x96, 0x2C, 0x36, 0x36, 0xAC, 0x34, 0xD3, 0x10, 0x10, 0x25, 0xF0, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x90, 0x1E, 0x20, 0x80, 0x78, 0x15, 0x91, 
        0x0F, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x86, 0xE5, 0x1A, 0x13, 0x13, 0x1A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x11, 0x77, 0x77, 
        0x13, 0x13, 0x13, 0x86, 0x17, 0x86, 0x17, 0x17, 0x1B, 0x1D, 0xDC, 0x66, 0x05, 0x05, 0x05, 0x98, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 
        0x06, 0x62, 0x51, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0x62, 0x70, 0x70, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 
        0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x05, 0x05, 0x05, 0x9C, 
        0x1F, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x59, 
        0x10, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x2C, 0x27, 0x27, 0x94, 0x94, 0x07, 0x07, 0xC1, 0x6D, 0xDD, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0x8A, 0x0B, 0x0B, 0xA8, 0xA8,
  0xBB, 0xDD, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x74, 0xBB, 0xBB, 0xBB, 0xDA, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0xD2, 0xD2, 0xD1, 0xAA, 0x36, 0x36, 0x36, 0x34, 0x34, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 
        0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 
        0x80, 0x8E, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0xDE, 0xDE, 0x0F, 0x0F, 0xCE, 0x13, 0x13, 0x9B, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0xDC, 0x9D, 0xFD, 0x05, 0x05, 0x05, 0x37, 0x98, 0x84, 0x37, 0x37, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x55, 0x04, 0x04, 0x89, 0x89, 0x55, 0x55, 0x55, 0x04, 0x55, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0xE6, 0x82, 0x03, 0x5B, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x51, 0x62, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0xE7, 0xE7, 0x62, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x23, 0x5F, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x2E, 0x2E, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x9D, 0x9D, 0x1B, 0x17, 0x17, 0x17, 
        0x86, 0x86, 0x9B, 0x13, 0x13, 0x77, 0x77, 0x77, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x1E, 0x90, 0x24, 
        0x19, 0x28, 0x29, 0x25, 0x10, 0x34, 0xAC, 0xAB, 0xD1, 0x27, 0x07, 0x6D, 0x08, 0x08, 0xA0, 0x0B, 0xA8, 0x0C, 0x0C, 0x8F, 0x9F, 0x0E, 0x75, 0x93, 0x0D, 0x0D, 0x6B, 0x6B,
  0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x96, 0x2C, 0xAB, 0xAA, 0xAA, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 
        0x29, 0x25, 0x25, 0x25, 0x29, 0xF0, 0xF0, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x73, 0x73, 0x73, 0x1D, 0x1B, 0x9D, 
        0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x66, 0x1D, 0x9C, 0x9C, 0x66, 0x66, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0xDF, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0xA3, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x03, 0x03, 0xE6, 0xE6, 0x16, 0xE6, 0xE6, 0x16, 0x5B, 0x16, 0x16, 0x5B, 0x16, 0x16, 
        0x5B, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x51, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 
        0x51, 0x52, 0x70, 0x70, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 0x51, 0xE7, 0xE7, 0xE7, 0x51, 0x51, 0xE7, 0x51, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 
        0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x9C, 0xFD, 0x1D, 0x1D, 0x1B, 0x1B, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 
        0x42, 0x17, 0x86, 0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x9B, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x80, 0x90, 0x90, 0x21, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 
        0x25, 0x25, 0x10, 0x38, 0x38, 0x34, 0x34, 0x2B, 0x4E, 0x4E, 0x4E, 0x41, 0x41, 0x41, 0xD2, 0x27, 0x27, 0x94, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1,
  0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x2C, 0x4E, 0xAB, 0xAB, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
        0x79, 0x19, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 
        0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x91, 0x77, 0x77, 0x13, 0x86, 0x17, 0x1B, 0x9D, 0x9D, 0xFD, 0x05, 0x05, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 
        0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x92, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x60, 0x06, 0x16, 0x60, 0x16, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x62, 0x51, 0x51, 0x51, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 
        0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x51, 0x51, 0x06, 0x06, 0x06, 0x06, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x16, 0xE6, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0xDF, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x3D, 0x3D, 0x98, 0x98, 0x37, 
        0x05, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x73, 0x73, 0x17, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x14, 0x14, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 
        0x79, 0x28, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x38, 0x34, 0x34, 0x2B, 0x2B, 0x2C, 0x96, 0x27, 0x94, 0x07, 0x07, 0xBB, 0xDD, 0x08, 0xA0, 0x0B, 0x0B, 0x0B, 0xA8,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0xC2, 0x2C, 0x2C, 0xAA, 0xAA, 0x36, 0xEC, 0x38, 0xD3, 0x10, 0x59, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 
        0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x87, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x12, 
        0x12, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x42, 0x17, 0x17, 0x1B, 0x1D, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x84, 0x37, 0x3D, 0x3D, 0x2E, 0xFE, 0xFE, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x62, 0x62, 0x06, 0x62, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0xE7, 0x62, 0x06, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x3D, 0x98, 0x84, 
        0x84, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x86, 0x86, 0x86, 0x13, 0x77, 0x0F, 0x0F, 0x12, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x26, 0x29, 0x29, 0x25, 0x25, 0x10, 
        0x10, 0x10, 0x3A, 0x34, 0x34, 0x34, 0xAC, 0x36, 0x2B, 0xAB, 0xAB, 0xD1, 0x96, 0x96, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0x08,
  0x07, 0x07, 0x07, 0xCC, 0x94, 0x27, 0x27, 0x96, 0x2C, 0x41, 0x2C, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x7D, 0x21, 0xCD, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 
        0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x8E, 0x14, 0x14, 0xFC, 0x78, 0x78, 0x95, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x91, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0xCE, 0x11, 0x77, 0x77, 0x1A, 0x9B, 0x9B, 0x9B, 0x86, 0xAE, 0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 
        0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 0x89, 0x89, 0x55, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x60, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0x06, 0x62, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 
        0x52, 0x52, 0x51, 0x70, 0x70, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x04, 0x04, 0xFE, 0x2E, 0x98, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0xAE, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x20, 0x1E, 0x1E, 0x21, 0x7D, 0x24, 0x19, 0x79, 0x26, 0x26, 0x29, 0x25, 0x10, 0x10, 
        0x38, 0x34, 0x34, 0x2B, 0x2B, 0x4E, 0x4E, 0x41, 0x49, 0x49, 0x07, 0x07, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B,
  0xDA, 0x74, 0x74, 0x6D, 0xDA, 0xDA, 0xDD, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0x6D, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0xCC, 0x94, 0x27, 0xD2, 0x96, 0x2C, 0x4E, 0xAB, 0xE4, 0x2B, 0x36, 0x34, 0x34, 0x34, 0xD3, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x87, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x11, 0x11, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x05, 0x05, 0x37, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x98, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x05, 0x37, 0x37, 0x84, 0x84, 0x3D, 0x3D, 0xFE, 0xFE, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 0x16, 0x60, 0x06, 0x06, 0x60, 0x16, 0x60, 0x60, 0x60, 0x60, 0x5B, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x16, 0xE6, 0x03, 0x5B, 0x5B, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x06, 0x06, 0x06, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0xE7, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x09, 
        0x09, 0x09, 0x92, 0x09, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0xA3, 0x89, 0x89, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x84, 0x05, 0x05, 
        0x9C, 0xFD, 0x1F, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x14, 0x14, 0x18, 0x18, 0x18, 0x18, 0x18, 0x14, 0x14, 0x14, 0xFC, 0xFC, 0x14, 0x14, 0x14, 0x14, 
        0x14, 0x18, 0x8E, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x19, 0x79, 0x26, 0x25, 0x44, 0xD4, 0x34, 0x36, 0xAB, 0x96, 0x27, 0xCC, 0x07, 0x07, 0xBB, 0x08, 0x08, 0x8A,
  0x10, 0x10, 0x10, 0xD3, 0x38, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x4E, 0x4E, 0x2C, 0x2C, 0x27, 0x27, 0x27, 0x27, 0xCC, 0xCC, 0x65, 0x65, 0x65, 0xCC, 0x65, 0x65, 0x27, 0x27, 0x27, 0xD2, 0x96, 0x4E, 0xAB, 0x36, 0x2B, 0xEC, 0x3A, 0xD3, 0x44, 0x10, 0x25, 0x25, 
        0x25, 0x29, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x95, 0x78, 0x78, 0x12, 0x12, 0x12, 
        0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0xAE, 0x1B, 0x1B, 0x9D, 0x1D, 0x9C, 0x9C, 0x05, 
        0x05, 0x3D, 0x3D, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x5F, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x16, 0x60, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0xE7, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x60, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 
        0x16, 0x16, 0x5B, 0x5B, 0x5B, 0x16, 0xE6, 0x5B, 0x16, 0xE6, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x16, 0x16, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0xD6, 0x62, 0xD6, 0x62, 
        0xD6, 0xD6, 0x62, 0xE7, 0xE7, 0x62, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x05, 
        0x9C, 0xFD, 0x1F, 0x1D, 0x1B, 0x1B, 0xAE, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0xDE, 0xDE, 0xDE, 0x12, 0x12, 0x15, 0x78, 0x78, 0x14, 0x80, 0x20, 0x1E, 0x90, 0x21, 0x22, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x29, 0xF0, 0x25, 0x25, 0x10, 0x10,
  0x65, 0xA9, 0xA9, 0x27, 0x27, 0x27, 0xD2, 0x41, 0x41, 0x4E, 0x4E, 0xAB, 0xAB, 0xAB, 0x36, 0x36, 0x36, 0x36, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0x4E, 0x4E, 0x4E, 0x2C, 0x2C, 0x2C, 0xD1, 0x96, 0x96, 0xD2, 0x41, 0x4E, 
        0xAB, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 
        0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0xCE, 0x0F, 0x0F, 0x0F, 0x11, 0x11, 0x77, 0x13, 0x9B, 0x13, 0x9B, 0x17, 0x17, 0x73, 0x73, 0x9D, 0x9D, 0x1F, 0x9C, 0x05, 0x05, 0x98, 0x98, 0x98, 0x2E, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x98, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0xFD, 0xFD, 0xFD, 0x1F, 0x9C, 0x9C, 0x66, 0x66, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x3D, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 
        0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x5B, 0x5B, 0x5B, 0x16, 0x16, 0x03, 0x5B, 0x16, 0x82, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0xE7, 0x62, 0x62, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 
        0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0xFE, 0x84, 0x84, 0x84, 0x37, 0x37, 0x05, 0x9C, 0x9C, 0x1D, 0x9D, 0x17, 0x17, 0x17, 0x86, 0x13, 0x13, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x80, 0x80, 0x20, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x21, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x87, 0x29, 0x25, 0x25, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x0C, 0x8D, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x74, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD1, 0x41, 0x41, 0x41, 0x2C, 0x4E, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 
        0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x7D, 0x21, 0x90, 0x1E, 0x80, 0x14, 
        0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x77, 0x77, 0x13, 0x9B, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0xAE, 0xAE, 0x17, 0x73, 0x17, 0x17, 0x1B, 0x9D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 
        0x04, 0x55, 0x55, 0x89, 0x89, 0xA3, 0x04, 0x89, 0x89, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 
        0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x60, 0x06, 0x06, 0x06, 0x16, 0x16, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x97, 0x8C, 0x6C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 
        0x5F, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x2E, 0x37, 0x37, 0x05, 0x05, 0xFD, 0x1F, 0x1D, 0x1B, 0xAE, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x19, 
        0x79, 0x79, 0x26, 0x29, 0x29, 0xEE, 0x44, 0xD3, 0x3A, 0xAC, 0xAC, 0x36, 0xAB, 0xD1, 0xD2, 0x27, 0x27, 0x27, 0x27, 0x27, 0x49, 0xCC, 0x65, 0x65, 0x07, 0x65, 0x65, 0x07,
  0xCC, 0xCC, 0x65, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0xE4, 0xE4, 0x36, 0x36, 0xAC, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x29, 0x26, 0x26, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 
        0x14, 0x12, 0x12, 0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0xAE, 0x73, 0xAE, 0x17, 0x17, 0x1B, 0xDC, 0xDC, 0x1D, 0x1D, 0x66, 0x66, 
        0x9C, 0x05, 0x05, 0x05, 0x98, 0x37, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 
        0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x60, 0x60, 0x60, 0x06, 0x60, 0x16, 0x60, 0x16, 0x60, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 
        0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0xA3, 0x55, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x98, 0x37, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x9D, 0x1B, 0x1B, 0x17, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x19, 0x79, 0x26, 
        0x29, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0xAB, 0xAA, 0xAB, 0x2B, 0x2B, 0x4E, 0x2B,
  0x94, 0x94, 0x27, 0x27, 0x27, 0x94, 0x27, 0x41, 0x41, 0x96, 0x2C, 0x2C, 0x2C, 0xAB, 0xAB, 0xE4, 0x36, 0x36, 0x36, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x21, 0x90, 0x80, 0x14, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x13, 
        0x13, 0x13, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x66, 0x9C, 0x9C, 0x9C, 0x1D, 0xDC, 0x66, 0x9C, 0x1D, 0x1D, 0x9C, 
        0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x2E, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x23, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 
        0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x82, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x5B, 0x16, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x5B, 
        0x03, 0x82, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x62, 0x06, 0xE7, 0xE7, 0x62, 0x62, 0x62, 0xE7, 0xE7, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x05, 
        0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9D, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x11, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 
        0x19, 0x19, 0x19, 0x19, 0x87, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0xAB, 0x41, 0x2C, 0xC2, 0xD2, 0x49, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x4E, 0x2C, 0x2C, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x79, 0x26, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0xAD, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x78, 0x78, 
        0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0xCE, 0x11, 0x11, 0x11, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x73, 0xAE, 0xAE, 0x73, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 
        0x1F, 0x66, 0x9C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x03, 0x16, 0x16, 0x16, 0xE6, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 
        0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 
        0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x60, 0x06, 0x16, 0x60, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x3D, 0x98, 0x05, 0x05, 0x05, 0xFD, 0x1F, 
        0x1D, 0xDC, 0x1D, 0x1D, 0x73, 0x73, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 0x21, 0x21, 0x21, 
        0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x19, 0x19, 0x79, 0x26, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0xD3, 0xD3, 0x38, 0x34, 0x34,
  0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0x08, 0x74, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x96, 0x96, 0x2C, 0x2C, 0x36, 0x36, 0x34, 0x38, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 
        0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 
        0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x1A, 0x1A, 0x86, 0x86, 0x86, 0x17, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x9D, 0xDC, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x37, 0x98, 0x84, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x23, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x51, 0x52, 0x52, 0x51, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0xD6, 0xD6, 0x51, 0x51, 0x51, 0x51, 
        0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x92, 0x92, 0x09, 0x09, 0x85, 0x85, 0x09, 0xCA, 0xCA, 0x09, 0xCA, 0xCA, 0xCA, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x8C, 0x02, 0x02, 
        0x02, 0x5F, 0x89, 0x55, 0x04, 0x04, 0x2E, 0x2E, 0x05, 0x05, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x90, 0x90, 0xCD, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 
        0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34, 0xAC, 0x2B, 0x2B, 0x36,
  0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0xAA, 0x2C, 0x2C, 0x96, 0x96, 0xD2, 0x96, 0x96, 0x27, 0x96, 0x96, 0x27, 0x27, 0xD2, 0xD2, 0x41, 0x2C, 0xAB, 0x2B, 0x4E, 0x2B, 0x2B, 0x34, 0x38, 
        0x38, 0x10, 0x10, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x80, 
        0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 
        0x2E, 0x2E, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x3D, 0xFE, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0xE7, 0xE7, 0x62, 0x51, 0xE7, 0x62, 0x51, 0xE7, 0x51, 0x51, 0x52, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x16, 0xE6, 0x03, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x62, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70, 0x51, 0x51, 0xE7, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x84, 0x37, 
        0x05, 0x1F, 0x9D, 0x1B, 0xAE, 0x86, 0x86, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x12, 0x12, 
        0x78, 0x14, 0x80, 0x20, 0x1E, 0x90, 0x21, 0x24, 0x19, 0x19, 0x28, 0x26, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x10,
  0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x2B, 0x2B, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x29, 0x29, 0x29, 0x26, 0x79, 0x24, 0x24, 0x24, 0x22, 0xCD, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 
        0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x77, 0x13, 0x1A, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x31, 0x1D, 0x1D, 0x9D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x84, 0x98, 0x98, 0x84, 0x84, 0x3D, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x5F, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 
        0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 
        0x51, 0x51, 0x51, 0x62, 0xE7, 0xD6, 0xD6, 0x62, 0xE7, 0x62, 0x62, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x02, 0x23, 
        0x23, 0x23, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0x37, 0x37, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x9C, 0x9C, 0x66, 0x66, 0x9C, 0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x12, 0x78, 
        0x80, 0x20, 0x90, 0x24, 0x19, 0x19, 0x26, 0x25, 0x25, 0x10, 0x38, 0xAC, 0x36, 0xAA, 0x4E, 0xD1, 0xD2, 0x94, 0x94, 0xCC, 0x07, 0x07, 0x07, 0x07, 0xC1, 0x07, 0x07, 0xC1,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x7B, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x6D, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x94, 0xD2, 0xD1, 0xD1, 0x4E, 0xE4, 0x36, 0xAC, 0xEC, 0xD3, 
        0x10, 0x10, 0x25, 0x25, 0x25, 0x26, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x17, 0x73, 0x73, 0x1B, 0x1B, 
        0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x9D, 0x9D, 0x1B, 0x1B, 0x9D, 0xAE, 0x17, 0x17, 0x86, 0x86, 0x9B, 0x1A, 0x13, 0x11, 0xCE, 0x0F, 0xCE, 0xCE, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x13, 0x13, 0x13, 0x13, 
        0xAE, 0xAE, 0x1B, 0x9D, 0xDC, 0x9D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 
        0x62, 0xE7, 0x51, 0x51, 0x51, 0x52, 0x52, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0xE6, 0xE6, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x9D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x9B, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x91, 
        0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x90, 0x24, 0x19, 0x19, 0x79, 0x26, 0x29, 0xEE, 0x44, 0x44, 0xD4, 0x3A, 0xBC, 0xBC, 0x36, 0xAA, 0x4E, 0xD1, 0x96, 0x27,
  0x0C, 0x0C, 0x0C, 0xB9, 0xB9, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0xD2, 0xD2, 0x4E, 0x4E, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 
        0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 
        0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x55, 0xA3, 0x23, 0x23, 0x5F, 0x5F, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x62, 0x62, 0x51, 0xD6, 0x62, 0x51, 0xD6, 0x51, 0xD6, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 0xD6, 0x62, 0x62, 0x06, 0x06, 0x60, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x62, 0x62, 0x62, 0x62, 0x06, 0x06, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 
        0x89, 0x89, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x2E, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x9D, 0x9D, 0x1D, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x17, 0x9B, 0x13, 0x13, 0x1A, 0x1A, 0xCE, 0xCE, 0xCE, 0x0F, 0x91, 0x12, 0x12, 0x15, 0x78, 0x78, 
        0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0xCD, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x21, 0x21, 0x24, 0x24, 0x19, 0x24, 0x24,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x07, 0x94, 0x94, 0xA9, 0x27, 0x27, 0x96, 0x96, 0x2C, 0xAA, 0xAB, 0x2B, 0x34, 0x34, 0xD3, 0xD3, 0x44, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x80, 
        0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x90, 0x90, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x86, 0x86, 0x17, 0x1B, 0x1D, 0xDC, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x3D, 0x04, 0x04, 
        0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x97, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x03, 0x5B, 0x5B, 0x03, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x5B, 0xE6, 0x16, 0xE6, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0xD6, 0x06, 0x51, 0xD6, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x92, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 
        0x8C, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x86, 0x86, 0x13, 0x13, 0x77, 
        0x91, 0x91, 0x12, 0x78, 0x14, 0x8E, 0x20, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x24, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25, 0x29, 0x25, 0x25,
  0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x8A, 0xA0, 0x08, 0x08, 0xDD, 0x6D, 0xC1, 0x07, 0x07, 0x65, 0x65, 0xCC, 0xD2, 0x41, 0x2C, 0x2C, 0x2C, 0xE4, 0xE4, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xEC, 0x34, 0xD3, 
        0xED, 0xED, 0x44, 0xAD, 0xAD, 0xAD, 0x25, 0x5E, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x89, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x84, 0x98, 0x98, 0x98, 0x37, 0x84, 0x84, 0x05, 0x98, 0x98, 0x37, 0x84, 0x84, 0x84, 0x3D, 0x3D, 0x84, 0x84, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x97, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 
        0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x06, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0xE6, 0xE6, 
        0x5B, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x16, 0x5B, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x82, 0x82, 0x82, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x03, 0x03, 
        0x82, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x82, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x60, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 
        0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x55, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x2E, 0x2E, 0x98, 0x37, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x73, 0x73, 0x17, 0x9B, 0x9B, 0x13, 0x77, 0x11, 
        0x91, 0x91, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 0x24, 0x24, 0x19, 0x19, 0x26, 0x26, 0x26, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34,
  0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0x4E, 0x41, 0x41, 0x27, 0x27, 0x27, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x94, 0x94, 0x27, 0x96, 0x96, 0x4E, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x21, 0x21, 0x1E, 0x80, 0x80, 0x8E, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x12, 0x12, 0x78, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x91, 0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x1A, 0x13, 0x13, 0x13, 0x13, 0x13, 0x17, 0x17, 0x86, 0x17, 0x17, 0x17, 0xAE, 0x1B, 0x1B, 0x1D, 0x1D, 0xDC, 0x9D, 0x1F, 0x1F, 0x9C, 
        0x05, 0x05, 0x05, 0x98, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x8C, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x5B, 0x5B, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0x06, 0x51, 0x70, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x70, 0x52, 0x51, 0x51, 0x51, 0x51, 0x06, 0x62, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x97, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x9C, 0x1F, 0x1D, 0x1B, 0x1B, 0x17, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x21, 0x19, 0x19, 0x79, 0x26, 0x29, 0x29, 0x29, 0x25, 0x25,
  0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0x96, 0x96, 0x96, 0x2C, 0xAB, 0xAB, 0x2C, 0x4E, 0x2B, 0x36, 0x36, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0x34, 0xBC, 0xAC, 0x34, 0xAC, 0x36, 0x36, 0x36, 0x36, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 
        0x2C, 0x2C, 0xAB, 0xAA, 0x36, 0x36, 0x36, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x22, 0x22, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0xDC, 
        0x1D, 0x9D, 0x1D, 0x66, 0x66, 0x66, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x98, 0x98, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x5B, 0x16, 0x5B, 0x16, 0x82, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x60, 0x06, 0x16, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x51, 0x51, 0xD6, 0xD6, 0xE7, 0xE7, 0x51, 0xE7, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0xE7, 0xE7, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0xD6, 0xD6, 0xE7, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x62, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x03, 0x03, 0x03, 0x03, 
        0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x09, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0xDF, 0xA3, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x9C, 0x1F, 0x1B, 0x1B, 0x1B, 0x17, 0xAE, 0x13, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x11, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0xCD, 0x22, 0x22,
  0x65, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0xD2, 0xD2, 0x96, 0xD1, 0x41, 0x41, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x41, 0x96, 0x96, 0xD2, 0xD2, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0x27, 0x49, 
        0x49, 0xCC, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x94, 0x94, 0xD2, 0x2C, 0x2C, 0xAB, 0x36, 0x2B, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x24, 0x24, 0x90, 0x90, 0x1E, 0x80, 
        0x80, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x66, 0xFD, 0xFD, 0xFD, 0x9C, 0x05, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x98, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0xFE, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 
        0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0xE7, 0x51, 0x62, 0x70, 0x70, 0x70, 0x51, 0xE7, 0xE7, 
        0x70, 0x51, 0x70, 0xE7, 0xE7, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 0x16, 0x5B, 0xE6, 0xE6, 0x16, 0x16, 
        0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x06, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0xE6, 
        0xE6, 0xE6, 0x5B, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x66, 0x1D, 0x1D, 0x1D, 0x17, 0x17, 0x17, 0x86, 0x13, 0x1A, 0x77, 0x0F, 0x0F, 
        0x91, 0xDE, 0xDE, 0x12, 0x12, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x22, 0x24, 0x24, 0x24, 0x24, 0x19,
  0xE2, 0xCB, 0x0C, 0x0C, 0xB9, 0xB2, 0xA7, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0xB3, 0x08, 0x08, 0x08, 0x74, 0xDD, 0xDA, 0x07, 0x07, 0x07, 0x07, 0x65, 0x65, 0xCC, 0x94, 0xCC, 0x94, 0x27, 0x27, 0x49, 0x94, 0xA9, 0xA9, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x96, 0xD1, 0xD1, 0xD1, 0x2C, 0x2C, 0xAA, 0xAB, 0x36, 0x34, 0xAC, 0x34, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x37, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x0A, 
        0x8C, 0x8C, 0x8C, 0x02, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x5B, 0x5B, 0x16, 0x16, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x62, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0xD6, 0x06, 0x06, 0x62, 0x62, 0x06, 0x62, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x16, 0x16, 0x60, 0x06, 0x06, 0x60, 0x60, 0x16, 0x16, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 
        0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x98, 0x05, 0x84, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0xDC, 0x1D, 0x1B, 0x17, 0x17, 0x13, 0x9B, 
        0x1A, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x28,
  0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0xD2, 0x96, 0xD2, 0xD2, 0xC2, 0x2C, 0xD1, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x4E, 0xD1, 0x2C, 0x2C, 0x2C, 0x2C, 0xAB, 0xE4, 0x36, 
        0x36, 0x5A, 0x34, 0x34, 0x38, 0xD3, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x19, 0x24, 0x24, 0x7D, 0x7D, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 
        0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x86, 0x17, 0x1B, 0x1D, 0x9C, 0x05, 0x05, 0x37, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x5F, 0x02, 0x02, 0x02, 0x5F, 0x5F, 0x02, 0x02, 0xDF, 
        0x23, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x31, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x66, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x89, 0x89, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x16, 0x06, 0x16, 0x06, 0x06, 
        0x62, 0x06, 0xE7, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x62, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x06, 0xE6, 0x5B, 0x16, 0x82, 0x03, 0x5B, 0x03, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 
        0x16, 0xE6, 0xE6, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x62, 0x62, 0x62, 0xE7, 0x51, 0x62, 0x62, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 
        0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x23, 0x89, 0x89, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x2E, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 
        0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0xCD,
  0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x96, 0x96, 0x41, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 
        0x25, 0x29, 0x26, 0x26, 0x19, 0x24, 0x7D, 0x21, 0x90, 0x90, 0x20, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 
        0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x11, 0x11, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x13, 0xAE, 0x1B, 
        0x1B, 0x1D, 0xDC, 0x1D, 0x1F, 0x66, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x98, 0x98, 0x98, 0x98, 0x98, 0x37, 0x84, 0x98, 0x84, 0x37, 0x37, 0x37, 0x84, 0x84, 0x37, 0x84, 0x98, 0x84, 0x37, 0x98, 0x98, 0x84, 0x2E, 0x3D, 0x3D, 0x3D, 
        0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0xE7, 0xE7, 0xE7, 0x70, 0x70, 
        0xE7, 0x70, 0x70, 0x51, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x51, 0x62, 0x62, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x06, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x82, 0x82, 0x16, 0x16, 0x16, 0x82, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0xD6, 0x51, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0xFE, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x9C, 0x9D, 0x9D, 0x17, 0x17, 0x86, 
        0x13, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x78, 0x78, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26,
  0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0x96, 0x96, 0x2C, 0xE4, 0xE4, 0xEC, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x20, 0x80, 0x80, 0x14, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x17, 0x17, 0x73, 0x73, 0x1B, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x73, 0x73, 0x73, 0x73, 0x17, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x73, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0xFD, 0x66, 0x05, 0x05, 0x05, 0x05, 0x3D, 0x3D, 0x04, 
        0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 
        0x23, 0xDF, 0xDF, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x62, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x62, 
        0xE7, 0xE7, 0xE7, 0x51, 0x70, 0x70, 0x70, 0x70, 0x70, 0x62, 0xD6, 0x62, 0x51, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 
        0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0x23, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x98, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x86, 
        0x13, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24,
  0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x94, 0x27, 0x96, 0x96, 0x2C, 0x2B, 0x2B, 0x36, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0xAD, 0x29, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 
        0x29, 0x29, 0xF0, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x1B, 0x1B, 0x9D, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x04, 0x55, 0x55, 0x55, 0x04, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x89, 0x89, 0x04, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x55, 0x89, 0x55, 0x89, 0xA3, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 
        0x98, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x98, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 
        0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x51, 
        0x51, 0xE7, 0x51, 0x51, 0x52, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0x51, 0x51, 0x52, 0x51, 0x51, 
        0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0xF2, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x89, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x05, 0x05, 0x9C, 0x1B, 0x1B, 0x17, 0x86, 
        0x13, 0x77, 0x0F, 0x91, 0x91, 0x12, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x26, 0x26, 0x25, 0x25, 0x25,
  0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0x07, 0x07, 0xC1, 0x07, 0x07, 0xC1, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0xA9, 0x27, 0x96, 0xC2, 0xC2, 0x2C, 0x4E, 
        0xAB, 0x4E, 0x2B, 0x36, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x20, 0x80, 0x80, 0x8E, 0x14, 0x14, 0x14, 0x78, 0x78, 
        0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x17, 0xAE, 0xAE, 0x17, 0x73, 0x73, 0x73, 0x73, 0x1B, 
        0xDC, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x3D, 0xFE, 0x2E, 0x3D, 0x2E, 0xFE, 0x3D, 0xFE, 0x2E, 0x3D, 0x3D, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x62, 0x06, 0x62, 0x62, 0x62, 0x62, 0x62, 0x51, 0x51, 0xE7, 0x62, 0x51, 0x51, 0x51, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x62, 0x62, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0xD6, 0xD6, 0x62, 0x06, 
        0x06, 0x06, 0x60, 0x16, 0xE6, 0xE6, 0x5B, 0x03, 0x03, 0xCA, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x97, 0x6C, 0x02, 0x02, 
        0x02, 0x02, 0xDF, 0x89, 0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x98, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x1D, 0x1B, 0x1B, 0x17, 
        0xAE, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0xB2, 0x8D, 0x0B, 0x0B, 0x8A, 0x7B, 0x08, 0x6D, 0xDA, 0x07, 0x65, 0x65, 0x27, 0xD2, 0xD2, 0x41, 0x4E, 0x2B, 0x36, 0x36, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x22, 0x21, 
        0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9C, 0x9C, 0x9D, 0x1F, 0x9C, 0xFD, 0x66, 0x05, 0x05, 0x05, 0x05, 0x66, 0xFD, 0xFD, 0x66, 0x9D, 0xDC, 0xDC, 
        0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x73, 0x17, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x84, 0x2E, 0x98, 0xFE, 0xFE, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 
        0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x82, 0x82, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x16, 0x16, 0x82, 0x82, 0x16, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x51, 0xE7, 0xE7, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x82, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 
        0x0A, 0x97, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x89, 0x89, 0x23, 0x89, 0x89, 0x23, 0x89, 0xA3, 0xA3, 0x89, 0x89, 0x89, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x3D, 0x98, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x9C, 0x66, 0x1D, 0x1D, 0x73, 0x1B, 0x1B, 0x86, 0x17, 0x9B, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78,
  0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xC6, 0xC6, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xE3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x74, 0xDA, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 
        0x65, 0xCC, 0x27, 0xD2, 0x96, 0x4E, 0xAB, 0x4E, 0x2B, 0x36, 0x34, 0x34, 0x34, 0x3A, 0x38, 0x10, 0x25, 0xAD, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x28, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x7D, 0x7D, 0x21, 0x90, 0x90, 0x20, 0x80, 0x8E, 0x14, 
        0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x66, 0x1D, 0x9C, 0x66, 0x66, 0x9C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x05, 0x37, 0x37, 0x98, 0x05, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x60, 0x60, 0x06, 0x06, 0x62, 0x62, 0x62, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x06, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0xE7, 0x06, 0x62, 0x06, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0xCA, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x55, 0xA3, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x2E, 0x05, 0x37, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x9B, 0x86, 0x86, 0x86, 0x13, 0x86, 0x9B,
  0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0xCC, 0x94, 0x27, 0x96, 0x2C, 0xAB, 0xAB, 0x36, 0x36, 0xEC, 0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0xAD, 0xAD, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x80, 0x14, 0x80, 0x80, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x20, 0x80, 0x80, 0x20, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x9D, 
        0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x37, 0x84, 0x84, 0x98, 0x37, 0x84, 0x98, 0x84, 0x84, 0x84, 0x98, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x05, 0x37, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x98, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 
        0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x03, 0x03, 0x09, 0x03, 0x09, 0x85, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x16, 
        0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x82, 0x5B, 0x5B, 0xE6, 0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x62, 0x62, 0x62, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0x62, 
        0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x01, 
        0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1F, 0x1D, 0x9D, 0x1B, 0x17, 
        0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x21,
  0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x49, 0x27, 0xD2, 0x41, 0x4E, 0xAB, 0x36, 0x2B, 0x2B, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 
        0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 
        0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x73, 0x17, 0x17, 0x17, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x73, 0x73, 0x73, 0x73, 
        0x73, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0xFD, 0xFD, 0xFD, 0xFD, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x98, 0x37, 0x37, 0x98, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x92, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x82, 0x82, 0x16, 0x16, 0x16, 
        0x60, 0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x51, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x27, 0x27, 0x41, 0x2C, 0x2C, 0x2B, 0x2B, 0x34, 
        0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0xFC, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0x77, 0x1A, 0x1A, 0x9B, 0x9B, 0x17, 0x17, 0x17, 0x17, 0x73, 0x1D, 0xDC, 0x1D, 0x9C, 0x9C, 0x9C, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x55, 0x55, 0xA3, 0xA3, 0x23, 0x23, 0xDF, 0xDF, 0x02, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0xA3, 
        0xA3, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x89, 0x89, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x01, 
        0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x51, 0x51, 0x70, 0x70, 0x52, 
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0xD6, 0xD6, 0xD6, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0x62, 0x06, 0xE7, 0xE7, 0xE7, 0x62, 0x62, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0xE7, 0x62, 0x06, 0x06, 0xE7, 0x62, 0xE7, 0x06, 0x62, 0x06, 0xE7, 0x62, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 0x37, 0x05, 0x05, 0x1F, 0x9D, 0x1B, 0x1B, 
        0x1B, 0x1B, 0xAE, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
  0xD8, 0x8F, 0x0C, 0x0C, 0x0C, 0xA7, 0xA7, 0xA8, 0x0B, 0x8A, 0x8A, 0xB3, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x94, 0x27, 0xD2, 0x41, 0x4E, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x2B, 0x34, 
        0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x26, 0x79, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x18, 0xFC, 0x12, 0x12, 0x91, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 
        0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0xCE, 0x77, 0x13, 0x13, 0x13, 0x17, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 
        0x13, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x17, 0x17, 0x1B, 0x9D, 0x9D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x84, 0x2E, 0x2E, 0xFE, 0x3D, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0x84, 0x98, 0x84, 
        0x37, 0x05, 0x98, 0x84, 0x05, 0x05, 0x05, 0x98, 0x98, 0x05, 0x05, 0x05, 0x37, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x16, 0x16, 0x16, 0x60, 0x60, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x70, 0x70, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 
        0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0xE7, 0xE7, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x97, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x9D, 
        0x1B, 0x17, 0x86, 0x86, 0x86, 0x13, 0x63, 0x11, 0x77, 0x0F, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x80, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x79, 0x79,
  0x8A, 0x8A, 0xB3, 0xB3, 0x8A, 0x8A, 0x8A, 0x8A, 0x8A, 0x8A, 0x8A, 0x8A, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x74, 0x08, 0xBB, 0xBB, 0xDA, 0x6D, 0x6D, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 
        0x94, 0x94, 0x27, 0xD2, 0xD2, 0x41, 0x41, 0x4E, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x29, 0x29, 0x79, 0x79, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1D, 0x9D, 0x1D, 0x66, 0xFD, 0x1F, 0x9C, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x1D, 0x9D, 0x9D, 0x1B, 0xAE, 0xAE, 0xAE, 0xAE, 0x13, 
        0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x3D, 0x2E, 0x2E, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x03, 
        0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x60, 0x06, 0x60, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x5B, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xD6, 0xE7, 0x06, 0xD6, 0xD6, 0xD6, 0xD6, 0x62, 0x62, 0xD6, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x60, 0x60, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x23, 0x23, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x2E, 
        0x3D, 0x3D, 0x84, 0x3D, 0x3D, 0x84, 0x84, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1B, 0x1B, 0x17, 0x86, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x78, 0x78,
  0x93, 0x0D, 0x93, 0x93, 0x0D, 0x0D, 0x93, 0x93, 0x93, 0x93, 0x93, 0x75, 0x0E, 0x9F, 0x9F, 0x8F, 0x8F, 0x0C, 0xA7, 0xA7, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0xDD, 0xBB, 0x6D, 0x07, 0x65, 0x49, 0x27, 0x27, 0xD2, 0xD1, 0xD1, 0x2C, 0x2C, 0x96, 0x2C, 0x2C, 
        0xAB, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x77, 0x77, 0xCE, 0x0F, 0x0F, 0x91, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 
        0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x95, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0xCE, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x73, 0x73, 0x1B, 0x9D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 
        0x89, 0x89, 0x89, 0x5F, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x16, 0x60, 0x60, 0x16, 0x5B, 0x16, 
        0x16, 0x16, 0x16, 0x60, 0x16, 0x16, 0x16, 0x60, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x06, 0xD6, 0x51, 0x62, 0x62, 0x51, 0xD6, 0xE7, 0x51, 0xE7, 0x62, 0x62, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 
        0x3D, 0x84, 0x84, 0x37, 0x05, 0x05, 0xFD, 0xFD, 0x9C, 0x1F, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F,
  0x0D, 0x0D, 0x88, 0x88, 0x0D, 0xC0, 0xC0, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xBA, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0xDD, 0xDD, 0x6D, 0x07, 0x65, 0x65, 0x27, 0x27, 0x41, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x36, 0xAC, 0x34, 0x38, 
        0x38, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0x87, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 
        0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x15, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x1A, 
        0x86, 0x86, 0x17, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 
        0x23, 0x23, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 
        0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x06, 0x06, 
        0x06, 0x62, 0x62, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x70, 0x51, 0x51, 0x62, 0x62, 0xD6, 0x51, 0x62, 0xD6, 0x51, 0x51, 0x62, 
        0x62, 0x62, 0x06, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x60, 
        0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x02, 
        0x02, 0xDF, 0x23, 0x89, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x84, 0x05, 0x05, 0x1F, 0x9D, 0x1B, 0xAE, 0x13, 0x13, 0x0F, 0x91, 0x91, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x21,
  0x6A, 0xB8, 0xB8, 0xB8, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0xB9, 0x8D, 0x0B, 0xB3, 0xA0, 0x08, 0xBB, 0xC1, 0x07, 0x94, 0x94, 0xD2, 0x2C, 0xE4, 0x2B, 0x34, 0x38, 0x10, 
        0x25, 0x25, 0x25, 0x29, 0x26, 0x28, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 
        0x1E, 0x80, 0x80, 0x78, 0x78, 0x78, 0x78, 0x12, 0x0F, 0x11, 0x11, 0x13, 0x13, 0x13, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x37, 0x37, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x31, 0x1D, 0x9D, 0x1D, 0x1D, 0xFD, 0x05, 0x05, 
        0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x89, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xD6, 0xD6, 0xE7, 0xE7, 0x51, 0x51, 0x52, 0x51, 0x70, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x52, 
        0x52, 0x51, 0x51, 0x52, 0x70, 0x70, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 
        0x89, 0x89, 0x04, 0x04, 0x3D, 0x2E, 0x98, 0x05, 0x9C, 0x1F, 0x1B, 0xAE, 0xAE, 0x86, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x78, 0x14, 0x20, 0x90, 0x90, 0x90, 0x21, 0x21, 0x24,
  0x8F, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0x27, 
        0x49, 0xD2, 0x27, 0xD2, 0xD2, 0xD2, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x4E, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x79, 
        0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x95, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x86, 0x17, 0x1B, 0x1B, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0xFE, 0xFE, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x73, 0x86, 0x17, 0x17, 0x86, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x9D, 0x1D, 0x05, 0x05, 0x05, 0x84, 0x84, 0x3D, 0x2E, 0x2E, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x03, 
        0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 
        0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x09, 0x09, 0x92, 0x09, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x16, 0x5B, 0x5B, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x62, 0x62, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 
        0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x84, 0x37, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x73, 0xAE, 0xAE, 0x86, 0xAE, 0xAE, 0xAE, 0x73, 0x73,
  0x7B, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xDD, 0xDD, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0x96, 0x27, 
        0xD2, 0xD2, 0xD2, 0xD1, 0xD1, 0x2C, 0x2C, 0xD1, 0xD1, 0x2C, 0x2C, 0x2C, 0xAB, 0xAA, 0xE4, 0x36, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x19, 0x21, 0x21, 0x90, 0x90, 0x80, 0x14, 
        0x14, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x98, 0x98, 0x2E, 0x2E, 0x2E, 0xFE, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x6C, 0x6C, 0x97, 0x97, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 
        0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x37, 0x84, 0x37, 0x05, 0x05, 0x84, 0x84, 0x84, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x70, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x06, 0x06, 0x06, 0x16, 0x06, 0x16, 0x16, 0x16, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86,
  0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xB3, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xB3, 0xA0, 0x08, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xDD, 0x74, 0x6D, 
        0xDA, 0x6D, 0x6D, 0x65, 0x65, 0x49, 0x49, 0x61, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 
        0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x11, 0x77, 0x13, 0x9B, 0x9B, 0x9B, 0x13, 0x9B, 0x9B, 0x9B, 0x9B, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x1B, 
        0x1B, 0x73, 0x1B, 0x1D, 0x9D, 0x1D, 0xFD, 0xFD, 0x1D, 0x9C, 0x9C, 0x66, 0x66, 0x05, 0x66, 0x66, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1F, 0x1D, 0x9D, 0x9D, 0xDC, 0xDC, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x9B, 0x86, 0x86, 0x86, 0x86, 0x86, 
        0x86, 0xAE, 0x17, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0x9D, 0x66, 0xFD, 0x05, 0x05, 0x98, 0x98, 0x37, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x5B, 
        0x5B, 0x5B, 0xE6, 0x16, 0x5B, 0x60, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x01, 0x85, 0x01, 0x92, 0x92, 0x92, 0x85, 0x85, 
        0x92, 0x92, 0x85, 0x09, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x16, 0x16, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0xE6, 0xE6, 0x16, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x62, 0xE7, 0x70, 0x70, 0x51, 0x70, 0x70, 0x51, 0x51, 0x70, 0x52, 0x52, 0x52, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x04, 0x04, 0x89, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x3D, 0x84, 0x84, 0x84, 0x37, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x9D, 0x9D, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F,
  0x75, 0x0E, 0x0E, 0x9F, 0x9F, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x49, 0x49, 0x41, 0x41, 0x41, 0x4E, 0x4E, 
        0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 
        0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x79, 0x24, 0x24, 0x24, 0x7D, 0x21, 0x90, 0x21, 0x90, 0x90, 0x90, 0x90, 0x20, 0x20, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x11, 0x11, 0x11, 0x13, 0x13, 
        0x13, 0x13, 0x17, 0x73, 0x1D, 0x73, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x9C, 0xFD, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 
        0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0xE6, 
        0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x60, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x62, 0x62, 0x51, 0xD6, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0xD6, 0x51, 0x51, 0xD6, 0x51, 0x51, 0x62, 0x62, 0x06, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x60, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x23, 0x23, 
        0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1B, 0x1D, 0x1D, 0x73, 0x1B, 0x1B,
  0x0D, 0x93, 0x93, 0x93, 0x93, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0xD2, 0xD2, 0x41, 0xD1, 0x4E, 0x2C, 0xAB, 
        0xAB, 0x2B, 0x2B, 0xE4, 0x2B, 0x2B, 0xE4, 0x2B, 0x2B, 0x36, 0x36, 0x36, 0xE4, 0x36, 0x36, 0xE4, 0xE4, 0xAB, 0xAB, 0xE4, 0x2B, 0x2B, 0x36, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x19, 
        0x24, 0x24, 0x22, 0xCD, 0x21, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x18, 0x18, 0x14, 0x78, 0x78, 0x78, 0x15, 0x12, 0x15, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 
        0x1A, 0x1A, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x9B, 0xAE, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x73, 0x73, 0x9D, 0x9D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x98, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x04, 
        0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x51, 0xD6, 0x51, 0x51, 
        0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0x51, 0xE7, 0x51, 0xD6, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x06, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 
        0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9D, 0x9D, 0x1D, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x1A, 0x77,
  0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xDA, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x27, 0x4E, 0xAB, 0xAB, 
        0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x10, 0x10, 0x10, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 0x24, 0x21, 0x1E, 0x1E, 0x14, 0x78, 0x12, 0x0F, 0x0F, 0x77, 0x13, 
        0x86, 0x17, 0x9D, 0x1F, 0x9C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x05, 0x98, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 
        0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x9D, 0x1F, 0x1F, 0xFD, 0x05, 0x37, 0x2E, 
        0xFE, 0x2E, 0x04, 0x04, 0x04, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0xE7, 0x51, 0xD6, 0xE7, 0xE7, 0xE7, 0xE7, 0xD6, 0xE7, 0xE7, 0xE7, 0x51, 0x51, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x55, 0x55, 0xA3, 0xA3, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x2E, 0x2E, 0x37, 0x98, 0x84, 0x84, 0x84, 0x37, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x9F, 0x9F, 0x9F, 0x9F, 0x9F, 0x8F, 0xCB, 0xCB, 0x0C, 0xB9, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x65, 0x49, 0x49, 0x61, 0x41, 0x4E, 0xAB, 0x2B, 0x34, 0x38, 0x38, 0x10, 0x10, 0x44, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xED, 0x10, 0x10, 0x44, 0x10, 0x10, 0x44, 0x44, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 
        0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x9B, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x84, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 
        0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x55, 0x55, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x5F, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x62, 0xE7, 
        0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x37, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 0x9C, 0x1F, 0x66, 0x9C, 0x9C, 0x1F, 0x9C, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05,
  0x57, 0x57, 0x1C, 0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x7E, 0x7E, 0x6B, 0x6B, 0x0D, 0x0D, 0x0D, 0x93, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x74, 0x6D, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x65, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x49, 0x27, 0x27, 0x27, 0x27, 0x41, 0x2C, 0x4E, 0x4E, 0x2B, 0xE4, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x1A, 0xE5, 0x9B, 0xAE, 0x73, 0x73, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 
        0x37, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x98, 0x37, 0x37, 0x37, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x66, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 
        0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x16, 0x16, 0x16, 0x03, 0x03, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0xE6, 
        0x60, 0x06, 0x06, 0x06, 0x06, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xD6, 0x06, 0x06, 0x16, 0x60, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0xDF, 0x23, 0x23, 0xA3, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0xAE, 0x1B, 0x1B, 0xAE, 0xAE, 0x17, 0x17,
  0x0E, 0x9F, 0x9F, 0x8F, 0x8F, 0x8F, 0x0C, 0xB2, 0xB2, 0xBA, 0xA8, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0x36, 0xBC, 0xBC, 0xEC, 0x38, 0x10, 0x44, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x38, 0x34, 0xAC, 0x36, 0x36, 0x2B, 0xAB, 0x4E, 0x4E, 0x2C, 0x41, 0xD2, 0x41, 0x41, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 
        0x25, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x19, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0xDC, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x66, 0x66, 0x1D, 0x1D, 0x73, 0x73, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x77, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x15, 0x15, 0x12, 0x95, 0x95, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x1A, 0x1A, 0x9B, 0x17, 0x17, 
        0x17, 0x73, 0x1D, 0x1D, 0x1D, 0x1F, 0x05, 0x05, 0x98, 0x98, 0x98, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x70, 0x70, 0x70, 0x51, 0x70, 0x70, 0x70, 0x70, 0x51, 0x51, 0x70, 0x70, 0x70, 0x70, 0x70, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 
        0x60, 0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0xD6, 0x06, 0xD6, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x23, 0x89, 0x23, 0x23, 0x55, 0x55, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x05, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D,
  0xCC, 0xCC, 0xCC, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x27, 0x96, 0x96, 0x96, 0x96, 0x96, 0x27, 0x96, 0x96, 0x96, 0x27, 0x27, 0x94, 0x27, 0x27, 0x27, 0x27, 0x96, 0x27, 0x96, 0x96, 0xC2, 0x2C, 0xAB, 0xAA, 0xAA, 0xAA, 0x36, 
        0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x24, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x78, 0x95, 0x95, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x13, 
        0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x73, 0x73, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 0x98, 0x98, 0x98, 0x98, 0x84, 0x05, 0x98, 
        0x98, 0x98, 0x98, 0x98, 0x84, 0x2E, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x55, 0x55, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 
        0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x03, 0x16, 0x16, 0x16, 0x16, 0x82, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x89, 0x23, 0x23, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xFD, 0xFD, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x73,
  0xB9, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x49, 0x49, 0x27, 
        0x27, 0x27, 0x27, 0x49, 0x49, 0x49, 0xCC, 0xCC, 0xCC, 0x65, 0x65, 0x65, 0xCC, 0x65, 0x65, 0xCC, 0x94, 0x27, 0x27, 0xD2, 0x41, 0xD1, 0x2C, 0x2C, 0x2B, 0x36, 0xAC, 0x34, 0x3A, 0x3A, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x28, 
        0x79, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0xCD, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x05, 0x37, 0x37, 0x37, 0x37, 0x37, 0x98, 0x98, 
        0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x3D, 0x3D, 0x3D, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x51, 0x51, 0x52, 0x51, 0x51, 0x52, 0x51, 
        0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0x62, 0x51, 0x62, 0x51, 0xE7, 0xE7, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x5F, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C,
  0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x27, 0x2C, 0x2C, 0xAA, 0x36, 0x36, 
        0xAC, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x28, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x24, 0x19, 0x19, 0x79, 0x19, 0x79, 0x19, 0x19, 
        0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 
        0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x86, 0xAE, 0x17, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 
        0x3D, 0x3D, 0x04, 0x98, 0x84, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x60, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x60, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x5B, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x60, 0x60, 0x60, 0x06, 0x06, 0x60, 0x60, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x92, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x0A, 0x8C, 
        0x8C, 0x6C, 0x6C, 0x02, 0x02, 0xA3, 0x89, 0x23, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x04, 0x3D, 0x3D, 0x3D, 0x2E, 0x2E, 0xFE, 0x2E,
  0xB2, 0x8D, 0x8D, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0xB3, 0x8A, 0x8A, 0x8A, 0x7B, 0xA0, 0xA0, 0xA0, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 
        0x6D, 0x6D, 0x6D, 0x65, 0xCC, 0x49, 0x27, 0x27, 0xD2, 0x41, 0x41, 0x4E, 0x4E, 0x4E, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x3A, 0xD3, 0xD3, 0x10, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 
        0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x11, 0x11, 0x77, 0x1A, 0x9B, 0x13, 0x13, 0x86, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0xAE, 0xAE, 0xAE, 0xAE, 0x86, 
        0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x3D, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x23, 0x23, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x5F, 0x23, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x55, 0xA3, 0xA3, 0x55, 0x89, 0x55, 0x55, 0x89, 0xA3, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x09, 0x09, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x92, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x16, 0x16, 0xE6, 0x60, 0x06, 0x06, 0x06, 0x62, 0x62, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x62, 0x62, 0x62, 0x06, 0x06, 0x06, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x60, 
        0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x5B, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x60, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 
        0x97, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x23, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0xFD, 0x1F, 0x9C, 0x9C, 0x1D, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x1D, 0x1F, 0x9C, 0xFD,
  0x0D, 0x0D, 0x0D, 0x0D, 0x93, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0x8F, 0x8F, 0xCB, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xDD, 
        0xDD, 0xDD, 0x6D, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0x27, 0x27, 0x27, 0x27, 0x2C, 0x41, 0x4E, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x20, 0x80, 
        0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x11, 0x77, 0x13, 0x13, 0x86, 0x17, 0x17, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x9D, 0x9D, 
        0x17, 0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x0F, 0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0xAE, 0x17, 0x1B, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x98, 0x37, 0x84, 0x84, 0x84, 0x98, 0x84, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x3D, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 
        0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x82, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0x70, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0xD6, 0xD6, 0x62, 
        0x62, 0x06, 0x06, 0x06, 0x06, 0x60, 0x60, 0x60, 0x16, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x89, 0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x3D, 0x3D, 0x37, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1F, 0xFD, 0x66,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x08, 0x08, 0x08, 0xC1, 0x07, 
        0x07, 0x07, 0xCC, 0x49, 0x27, 0xD2, 0x41, 0xAB, 0xAB, 0x2B, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x77, 
        0x13, 0x13, 0x17, 0x17, 0x17, 0x1B, 0x9D, 0x1F, 0x66, 0x9C, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x98, 0x98, 0x37, 0x37, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x2E, 0x98, 0x98, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0xCA, 0xCA, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0xCA, 0x09, 0x09, 0xCA, 0x09, 0x09, 0xCA, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x03, 0x03, 0xCA, 0x09, 0x09, 0x03, 0x03, 0x09, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 
        0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xA3, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x37,
  0x75, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0x6D, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x65, 0x65, 0x27, 0xD2, 0x41, 0x41, 0x4E, 0x2B, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0x79, 0x19, 0x24, 
        0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x86, 0x1B, 0x1B, 
        0x1B, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x55, 0x55, 0x55, 0x55, 0x89, 0x89, 0x89, 0x89, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0xFE, 
        0xFE, 0x2E, 0x2E, 0x3D, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x05, 0x05, 0x37, 0x98, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x37, 0x37, 0x05, 0x37, 0x05, 0x98, 0x98, 0x98, 0x98, 0x2E, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 
        0x89, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x06, 0x06, 0x16, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0xE6, 0x5B, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0xE6, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x97, 0x01, 0x01, 
        0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 
        0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0x6D, 0x6D, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x65, 0x49, 0xD2, 0x41, 0x4E, 0x4E, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x19, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 
        0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 
        0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x55, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0xFE, 0x3D, 0x2E, 0x2E, 0x2E, 0x84, 0x98, 0x2E, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 
        0x3D, 0x2E, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x3D, 0xFE, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x06, 0x06, 0x06, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xD6, 0xD6, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x60, 0x60, 0x60, 0x60, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 
        0xA3, 0x89, 0x89, 0x89, 0x04, 0x55, 0x89, 0x89, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x5F, 0x5F, 0x5F, 0xDF, 0xDF, 0xDF,
  0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0x0C, 0x0C, 0xB2, 0xB2, 0x8D, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0x07, 0x07, 0x94, 0x27, 0xD2, 0x41, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x29, 0x29, 0xF0, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 
        0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0xAE, 0x73, 0x73, 0x73, 0x1B, 0x1B, 
        0x73, 0x73, 0x1B, 0xAE, 0x17, 0x73, 0x73, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x31, 0x31, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xFD, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9D, 0x9D, 
        0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x73, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x17, 0x86, 0x17, 0x17, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x98, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x55, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x97, 
        0xF3, 0x01, 0xF3, 0x01, 0x01, 0x97, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x62, 0x51, 0xE7, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x62, 0xE7, 0x51, 0x51, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0xF2, 0x6C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 
        0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0x8A, 0x8A, 0xB3, 0x8A, 0x7B, 0x8A, 0x7B, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xDA, 0x6D, 0x07, 0x07, 0x07, 0xCC, 0x27, 0xD2, 0x2C, 0x4E, 0x2B, 0x2B, 0xAC, 0x38, 0x10, 0x44, 0xAD, 0x25, 0x25, 0x25, 0x29, 0x29, 0x87, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x28, 0x79, 
        0x79, 0x26, 0x26, 0x26, 0x29, 0x26, 0x29, 0x29, 0x26, 0x26, 0x29, 0x29, 0x26, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0xDE, 0xDE, 0x91, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x1A, 0x9B, 0x13, 0x9B, 0x9B, 0x86, 0x86, 0x17, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x9C, 0x66, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 
        0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x55, 0x89, 0x89, 0x55, 0x04, 0x89, 0x89, 0x89, 0x89, 
        0x55, 0x89, 0x89, 0xA3, 0xA3, 0x89, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0xCA, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xCA, 0xCA, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0xE6, 0xE6, 0x16, 0x16, 0x60, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 
        0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x92, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 
        0x0A, 0xF2, 0xF2, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 0x84, 0x05, 0x05,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xA7, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0xB3, 0x8A, 0x08, 0x08, 0x74, 0xDD, 0x6D, 0x6D, 0x6D, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x65, 0x07, 0x07, 0xCC, 0x49, 0x27, 0x27, 0x27, 0x49, 0x49, 0x27, 0x27, 0x27, 0x27, 0x49, 0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 
        0x2B, 0xAB, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 
        0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x73, 0x73, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1D, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x9C, 0x66, 0x66, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 
        0x37, 0x98, 0x3D, 0x37, 0x37, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0x51, 0x51, 0xE7, 0x70, 0xE7, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 
        0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x5F, 0x5F, 0x23, 0xA3, 0x5F, 0x23, 0x89, 0x5F, 0x5F, 0x02, 0x5F, 0x89, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x55, 0x55, 0x89, 0x04, 0x55, 0x55, 0x55, 0x55, 0x04,
  0x0E, 0x9F, 0x8F, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xA7, 0xA7, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0xCC, 0x27, 0x96, 0x96, 0x2C, 0xAA, 0xAA, 0x36, 0xC8, 0x3A, 0xD3, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x29, 0x25, 0xF0, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x34, 0x34, 0x34, 0x34, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xAC, 0xAC, 0x36, 0xBC, 0xBC, 0x34, 0x3A, 0xD3, 0x10, 0x10, 0x10, 
        0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 
        0x78, 0x91, 0x0F, 0x0F, 0x77, 0x13, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xFD, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0x73, 
        0x73, 0x73, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x66, 0x66, 0x66, 0x66, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0x62, 0x06, 0x06, 0x06, 0x06, 0x62, 0xD6, 0x62, 0x62, 0xD6, 0x62, 0xE7, 0xD6, 0x51, 0xE7, 0x51, 0x51, 0x51, 0x70, 0x51, 0x51, 0x51, 0x51, 0x70, 0xE7, 0xE7, 0x51, 0x70, 0xE7, 0x70, 0x51, 0x62, 0xE7, 
        0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xA3, 0x55, 0x55, 
        0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x3C, 0x3F, 0xB6, 0x50, 0x50, 0x2D, 0xB7, 0x57, 0x1C, 0x6A, 0xB8, 0xA6, 0x0D, 0xC0, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0x7B, 0x7B, 0x08, 0x08, 0x08, 0x08, 0x74, 0xDD, 0xDD, 0xDD, 0xDA, 0xDA, 0x6D, 
        0x6D, 0xBB, 0xDA, 0xDA, 0x6D, 0xDD, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0xB3, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x6D, 0xC1, 0x6D, 0xCC, 0x49, 0x49, 0x49, 0x41, 
        0x41, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x87, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x91, 0x0F, 0x77, 
        0x77, 0x13, 0x86, 0x86, 0x86, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x73, 0x1B, 0x1D, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 
        0x66, 0x66, 0x66, 0x66, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x37, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 
        0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x0A, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x89, 0x55, 0x55, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C,
  0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0x6B, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xC0, 0xC0, 0x93, 0x93, 0xC0, 0xC0, 0x93, 0xC0, 0x93, 0x88, 0x88, 0x75, 0x75, 0x75, 0x0E, 0x0E, 0x9F, 0x9F, 
        0x8F, 0x0C, 0x0C, 0x0C, 0x8D, 0x0B, 0x0B, 0x8A, 0x7B, 0x7B, 0x08, 0xDD, 0x6D, 0x6D, 0x07, 0x65, 0xCC, 0xCC, 0x27, 0xD2, 0xC2, 0x4E, 0x2C, 0xAB, 0xAB, 0x2B, 0x2B, 0x36, 0x2B, 0xAC, 0xAC, 0xAC, 0x34, 0x34, 0x34, 0x3A, 0x34, 0x38, 0x10, 0x10, 0x10, 
        0x25, 0x25, 0x25, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 
        0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x1B, 0x73, 0x73, 0x1B, 0x9D, 0x1D, 
        0x1D, 0xDC, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x09, 0x92, 0x92, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 
        0x01, 0x0A, 0x0A, 0x0A, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x23, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05,
  0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xDD, 0x6D, 0xC1, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x65, 0xCC, 0xCC, 0x49, 0x49, 0x49, 0x49, 0x27, 0x27, 0x27, 0x27, 0x27, 0x41, 0x41, 0xD1, 0xD1, 0x2C, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x2B, 0xE4, 0x36, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 
        0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x86, 0xAE, 0xAE, 0x1B, 0x1B, 0x9D, 0x1F, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 
        0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x84, 0x84, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x23, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x23, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0xF2, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x62, 0x51, 0x51, 0x62, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x60, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0xDF, 0xDF, 0xDF, 0x5F, 0x5F, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84,
  0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0x0D, 0xC0, 0xC0, 0xB1, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0xB3, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0xAA, 0xAA, 0x2B, 0x34, 0xBC, 0x3A, 0x10, 0x10, 0x25, 0x29, 0x29, 0x29, 0x26, 0x79, 
        0x24, 0x24, 0x7D, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 
        0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x11, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0xDE, 0x91, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 
        0xF1, 0xCE, 0x77, 0x77, 0x1A, 0x13, 0x86, 0x17, 0x73, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x37, 0x98, 0x98, 0x98, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0xCA, 0xCA, 0xCA, 
        0xCA, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x85, 0xCA, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x60, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x8C, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 
        0x23, 0x5F, 0xDF, 0x23, 0x23, 0xA3, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x37, 0x37, 0x05,
  0x4B, 0x3C, 0x3C, 0x54, 0xBE, 0x50, 0x2D, 0x57, 0x1C, 0x1C, 0x6A, 0x6B, 0x0D, 0x93, 0xCF, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x8A, 0x8A, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0xD2, 0x41, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0xF0, 0x26, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x28, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x19, 0x24, 0x21, 0x21, 0x1E, 0x80, 0x80, 0x14, 
        0x78, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x55, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x98, 0x05, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x9D, 0x73, 0x1B, 0x1B, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x9B, 0x86, 0x17, 0x17, 0x73, 0x73, 0x73, 0x1B, 0x1D, 0x9D, 0x1D, 
        0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x98, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 
        0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x97, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x97, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x54, 0x54, 0x54, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0xB7, 0x57, 0x57, 0x1C, 0x1C, 0x6A, 0x6B, 0x0D, 0x0D, 0x0D, 0xB1, 0x0E, 0xE2, 0x0C, 0x0C, 0x0C, 0xB2, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x65, 0xCC, 0xCC, 0xCC, 0xCC, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xDA, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x6D, 0x6D, 0xDA, 0x6D, 0x07, 0x65, 0x49, 0x27, 0x41, 0x4E, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x26, 0x26, 0x79, 
        0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x90, 0x80, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x13, 0x13, 0x86, 0x17, 0xAE, 0x73, 0x1B, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x98, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0xFE, 0x04, 0x2E, 0x84, 0x98, 0x2E, 0x2E, 0x84, 0x37, 0x37, 0x98, 0x84, 0x84, 0x98, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x98, 0x98, 0x3D, 0x3D, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x16, 0x60, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x5B, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x16, 0x16, 0x5B, 0x5B, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x8C, 
        0x97, 0xF2, 0x0A, 0x0A, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x5F, 0x5F, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E,
  0x50, 0xBE, 0x50, 0xB6, 0x3F, 0x54, 0x54, 0x3F, 0x3F, 0xB6, 0x54, 0xB6, 0x54, 0xB6, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0xB7, 0x57, 0x1C, 0x1C, 0xBF, 0xA6, 0x0D, 0x0D, 0xC0, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 
        0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x96, 0x96, 0x96, 0x2C, 0xAA, 0x2B, 0x36, 0x36, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xD3, 0xD3, 0xD3, 0xD4, 0xD4, 0x44, 0x10, 0x44, 0x10, 0xAD, 0xAD, 0x25, 0x25, 0x25, 0x25, 0xAD, 0xAD, 
        0x25, 0xF0, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x95, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x11, 0x13, 0x13, 0xAE, 0x1B, 0x1B, 0x9D, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 
        0x84, 0x84, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x5F, 0x5F, 0xDF, 0x02, 0x02, 0x02, 0x6C, 0xF2, 0x97, 0x97, 0xF2, 0x97, 0x97, 0x8C, 0x6C, 0x6C, 0x6C, 0x6C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x82, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 
        0xF2, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x23, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0xFE, 0x04, 0x04, 0xFE,
  0x50, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0x57, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x6B, 0x6B, 0x6B, 0x0D, 0x88, 0x93, 0x75, 0x75, 0x75, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 
        0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x74, 0x08, 0xBB, 0x74, 0x74, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x74, 0x74, 0xDD, 0xDA, 0xDA, 0x07, 0x65, 0xCC, 0x27, 0x27, 0x2C, 0x36, 0x36, 0xEC, 0x3A, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 
        0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0x73, 0x1D, 0x9D, 0x66, 0x66, 0x9C, 0x05, 0x05, 0x05, 
        0x84, 0x84, 0x2E, 0x2E, 0x3D, 0x3D, 0x84, 0x84, 0x3D, 0x3D, 0x98, 0x98, 0x98, 0x98, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x3D, 0x3D, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 
        0xA3, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 
        0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 
        0x09, 0x09, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0xF2, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x92, 0x01, 0x01, 0x92, 0x92, 0x85, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x6C, 0x6C, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E,
  0x8A, 0x7B, 0x7B, 0x7B, 0xA0, 0xA0, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x94, 0x96, 0xD1, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0xF0, 
        0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x19, 0x79, 0x19, 0x19, 0x19, 0x24, 0x22, 0xCD, 0xCD, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x21, 
        0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x86, 0x17, 0x17, 0x17, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x2E, 0x2E, 
        0x84, 0x2E, 0x37, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x98, 0x05, 0x05, 0x98, 0x98, 0x2E, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0xCA, 0x03, 0x09, 0x09, 
        0x09, 0x85, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xB8, 0xA6, 0xA6, 0xA6, 0xB8, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 
        0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x27, 0x96, 0x2C, 0xAB, 0xAB, 0xE4, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x44, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x34, 0x34, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 
        0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x95, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x9B, 0x17, 0x17, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x73, 0x73, 0x17, 0x17, 
        0x1B, 0x1B, 0x1B, 0x17, 0x73, 0x17, 0xAE, 0xAE, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0xDC, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xFD, 0xFD, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 
        0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x60, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x92, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0xF2, 0xF2, 0x97, 0x0A, 0x8C, 
        0x6C, 0xF2, 0xF2, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0xF2, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x7E, 0x1C, 0x6B, 0xA6, 0x6B, 0x0D, 0x0D, 0x0D, 0x93, 0x93, 0xC0, 0xB1, 0x0E, 0x0E, 0x9F, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x8D, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x7B, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0x07, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xDA, 0x6D, 0x6D, 0x07, 0x07, 
        0x65, 0xCC, 0xCC, 0x27, 0x27, 0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x41, 0x2C, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x79, 0x19, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x78, 0x12, 
        0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x73, 0x73, 0x1D, 0xDC, 0x1D, 0x1D, 0x66, 0x05, 0x05, 0x05, 0x37, 0x37, 0x84, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x04, 0x04, 0x04, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x2E, 0x2E, 0x84, 0x98, 0x05, 0x05, 0x05, 0x05, 0x9C, 
        0x05, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x03, 0x5B, 0x5B, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 
        0x5B, 0x60, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x02, 0x02, 0xDF, 0xDF, 0x02,
  0x6A, 0x6A, 0x6B, 0x6B, 0x6B, 0x6B, 0x0D, 0x88, 0xC0, 0xB1, 0xB1, 0x0E, 0xE2, 0x9F, 0xCB, 0x0C, 0x0C, 0xA8, 0xA8, 0x0B, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0xDD, 0xDA, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x08, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0xDD, 0xBB, 0x6D, 0x6D, 0x07, 0x65, 0xCC, 0xCC, 0x27, 0x41, 0x4E, 0xAB, 0xAA, 0x36, 0x2B, 0x34, 0x34, 0xD3, 0x38, 0x38, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x24, 
        0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0xCE, 0x1A, 0x9B, 0x86, 0x17, 0x73, 0x73, 0x9D, 0x9C, 0x9C, 0x05, 0x37, 0x84, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x37, 0x37, 0x05, 0x9C, 0x66, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x17, 0x17, 0x17, 0x13, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x73, 0xAE, 0xAE, 0x17, 0x17, 0x73, 
        0x1B, 0x1B, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0xFD, 0x05, 0x05, 0x37, 0x98, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x8C, 
        0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 
        0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x6C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x5F, 0x5F, 0x89, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04,
  0x6A, 0xB8, 0x6B, 0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0xB2, 0xB2, 0x8D, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 
        0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0x0C, 0xB2, 0xA8, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x49, 0x49, 0x49, 0x49, 0xD2, 0x41, 0x41, 0x41, 0x4E, 0xAB, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 
        0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x1A, 0x9B, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 
        0xDC, 0xDC, 0x1D, 0x1D, 0xDC, 0xDC, 0x66, 0x66, 0x66, 0x1D, 0x1D, 0x9C, 0x9C, 0x66, 0x1D, 0x1D, 0x9C, 0x66, 0x66, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xDC, 0x1D, 0x73, 0x73, 0x1B, 0x17, 0x17, 0xAE, 0x73, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1D, 0x9D, 
        0x1D, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x55, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 
        0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x55, 0xA3, 0xA3, 0x04, 0x04, 0x04,
  0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0xBF, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x93, 0xC0, 0xCF, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0xA7, 0xB2, 0xB2, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0xD2, 0x2C, 0x2C, 0x2C, 0x36, 0x36, 0x36, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 
        0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x24, 0x24, 0x7D, 0x21, 0x7D, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0xFC, 0x78, 0x78, 0x78, 0x12, 0x78, 0x78, 0x12, 0x78, 0x78, 0xDE, 0x12, 0x78, 0x78, 
        0x14, 0x14, 0x8E, 0x80, 0x80, 0x20, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x80, 0x18, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x13, 0x17, 0x73, 0x73, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x37, 
        0x84, 0x84, 0x2E, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0xFE, 0x2E, 0x3D, 0x3D, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0xFE, 0xFE, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 
        0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 
        0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x0D, 0x0D, 0xA6, 0xB8, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0xC5, 0x2D, 0x2D, 0x2D, 0x2D, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x5C, 0x5C, 0x57, 0x1C, 0x1C, 0x1C, 0xB8, 0x6B, 0x0D, 0x88, 0xCF, 0xCF, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 
        0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x27, 0x96, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 
        0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x2C, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0xAB, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x25, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x19, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x78, 
        0x91, 0x0F, 0x77, 0x77, 0x77, 0x86, 0x86, 0x86, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1B, 0x9D, 0x1D, 0x1B, 0x1B, 0x1B, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x17, 0x86, 0x17, 0x17, 0x17, 0x17, 0xAE, 0x13, 0x13, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0x66, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x05, 0x05, 0x37, 0x98, 
        0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x98, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x23, 0x23, 0x23, 0x23, 0x23, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0xE7, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x97, 0x0A, 0x97, 0x6C,
  0x8D, 0xB2, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0xB1, 0xCF, 0xC0, 0x0D, 0x0D, 0x0D, 0xA6, 0x6A, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x57, 0xC5, 0xC5, 0x57, 0x57, 0x5C, 0xC5, 0xC5, 0x1C, 0xC5, 0xC5, 0x1C, 0x1C, 0x7E, 0x6B, 
        0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xD8, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x8A, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x2C, 0x4E, 0x4E, 
        0x2B, 0x2B, 0x36, 0x36, 0x36, 0x2B, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0xD3, 0x10, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 
        0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x18, 0x18, 0xFC, 0x78, 0x14, 0x15, 0x15, 0xDE, 0x12, 0x91, 0x6F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x0F, 0x0F, 
        0xF1, 0xCE, 0x77, 0xCE, 0x9B, 0x9B, 0x9B, 0x9B, 0x17, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x98, 0x98, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x55, 0xA3, 0x5F, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x97, 0x0A, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x6C, 0x6C, 0x8C, 0x6C, 0x6C, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x97, 0x97, 0x01, 0x01, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 0xCB, 0xCB, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xA7, 0xA7, 0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x07, 0x94, 0x94, 0xA9, 0x27, 0x27, 0x27, 
        0xD2, 0x41, 0x2C, 0x2C, 0x4E, 0x4E, 0xAB, 0xAB, 0x36, 0x36, 0x36, 0x2B, 0xAC, 0xAC, 0x34, 0x34, 0x34, 0x34, 0xD3, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x19, 0x19, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x20, 0x14, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x86, 0x17, 0x73, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x37, 0x98, 0x98, 0x84, 
        0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x2E, 0x98, 0x98, 0x2E, 0x2E, 0x98, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 
        0x55, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x23, 
        0x89, 0x23, 0x89, 0x23, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 
        0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x0A, 0xF2, 0x6C, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x23, 0x23, 0x89,
  0x2D, 0x2D, 0xB7, 0xB7, 0x2D, 0xB7, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x6A, 0x6A, 0xB8, 0xB8, 0xB8, 0x0D, 0x0D, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x9F, 0xE2, 0x0E, 0xE2, 
        0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x8F, 0x8F, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 
        0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x96, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0xCE, 0xCE, 0xCE, 0xCE, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x77, 0x1A, 0x13, 0x17, 0x17, 0x17, 0x86, 0x17, 0x73, 0x1B, 0x1D, 0x1B, 0x73, 0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0xDC, 0x1D, 0x1D, 
        0x1D, 0x66, 0x66, 0x66, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x5B, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x0A, 0x8C, 0x0A, 0x0A, 0x97, 0x97, 0x97, 0x97, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x02,
  0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0xB6, 0x54, 0x50, 0x50, 0xBE, 0x2D, 0x2D, 0xB7, 0xEB, 0xEB, 0xEB, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xB8, 0x0D, 
        0xA6, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x27, 0xD2, 0x41, 0x4E, 0x4E, 0x2B, 0x34, 0x38, 
        0x10, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x26, 0x26, 0x26, 0x26, 0x29, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x24, 0x24, 0x24, 
        0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0xCD, 0xCD, 0x90, 0x90, 0x21, 0x90, 0x90, 0x21, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x95, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x17, 
        0xAE, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x37, 0x05, 0x05, 0x37, 0x2E, 0x37, 0x37, 0x84, 0x84, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 
        0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 
        0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 
        0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0xF2, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3,
  0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0xB7, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x7E, 0x6A, 0x6A, 0xB8, 0x6B, 0x0D, 0x0D, 0x88, 0x93, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 
        0x27, 0x27, 0xA9, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0x96, 0x96, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x96, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x34, 0xEC, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x24, 0x21, 0x90, 0x90, 
        0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x0F, 0x0F, 0x0F, 0x11, 0x11, 0x11, 0x63, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x1A, 0x1A, 0x1A, 0x13, 0x77, 0x1A, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x9B, 0x9B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x1B, 0x73, 0x1D, 0x73, 0x1D, 0x1D, 0x9D, 0x66, 0xFD, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x84, 
        0x84, 0x98, 0x98, 0x84, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0xFE, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x55, 0x55, 0x89, 0x89, 0x89, 0x23, 0x02, 0x23, 0xDF, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0xF2, 0x0A, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 
        0x03, 0x03, 0x09, 0x03, 0x03, 0x09, 0x03, 0x09, 0x09, 0x03, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0xCA, 0xCA, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x97, 0xF2, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xDF, 0xDF, 0x55, 0xA3, 0xA3,
  0x50, 0x50, 0x50, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x2D, 0x50, 0x2D, 0x2D, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0x57, 0x57, 0x1C, 0x1C, 0x6A, 0x6A, 0x6B, 0x6B, 0x0D, 0x88, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 
        0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xBB, 0xBB, 0xC1, 0xBB, 0xC1, 0xC1, 0xC1, 
        0xC1, 0xC1, 0xBB, 0xBB, 0xC1, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x49, 0x49, 0xD2, 0x41, 0x41, 0x41, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x26, 0x79, 0x79, 
        0x24, 0x22, 0xCD, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0xAE, 0xAE, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x11, 0x11, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x31, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x37, 0x37, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x23, 0x23, 0x23, 0x5F, 0xDF, 0x23, 0x02, 0x5F, 0x5F, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x97, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x03, 0x16, 0x16, 0x16, 0x03, 0x03, 
        0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x92, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x97, 
        0x0A, 0x97, 0x97, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x97, 0x97, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0xCF, 0xC0, 0xCF, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xC6, 
        0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0x0C, 0x0C, 0xE2, 0xE2, 0xCB, 0xCB, 0xE2, 0xE2, 0xCB, 0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0x8D, 
        0xA8, 0xA8, 0x0B, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x94, 0x94, 0x96, 0x2C, 0xAB, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x24, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x14, 0x14, 0x95, 0x91, 
        0x91, 0x77, 0x13, 0x13, 0x86, 0x17, 0x17, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x37, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x37, 0x84, 0x2E, 0x2E, 0x2E, 0x37, 0x2E, 0x37, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x9D, 0x9D, 0xDC, 
        0x1D, 0x1D, 0x66, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x98, 0x37, 0x3D, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x0A, 0x8C, 0x8C, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0xF2, 
        0x8C, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x6C, 0x6C, 0x02, 0x8C, 0x8C, 0x6C, 0x6C, 0xF2, 0x8C, 0xF2, 0x6C, 0x8C, 0xF2, 0x97, 0x0A, 0x0A,
  0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6B, 0x6B, 0xB8, 0xB8, 0xB8, 0x0D, 0x0D, 0x88, 0x88, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xE3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0x6D, 0xC1, 
        0xC1, 0xC1, 0x07, 0x07, 0xCC, 0x94, 0x27, 0x27, 0x96, 0x2C, 0x4E, 0xAB, 0xAB, 0x36, 0x36, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x3A, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 
        0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x0F, 0x0F, 
        0x77, 0x13, 0x86, 0x86, 0x17, 0x9D, 0x1F, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x55, 0xA3, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x37, 0x37, 0x37, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0x23, 0x23, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x6C, 0xF2, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 
        0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x23, 0x5F, 0x5F, 0x23, 0x5F, 0xA3, 0x89, 0x89,
  0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xB8, 0xB8, 0xBF, 0xBF, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0x88, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xE2, 0x9F, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xA7, 0xB2, 0xB2, 0xA7, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x94, 0x27, 0x41, 0x4E, 
        0x36, 0x34, 0x38, 0x44, 0x25, 0x29, 0x26, 0x19, 0x24, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x24, 0x24, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x13, 0x77, 0x77, 0x13, 0x13, 0x9B, 0x9B, 0x9B, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x17, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x17, 0x73, 0x73, 0x9D, 
        0x9D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x55, 0x55, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0xF2, 0x0A, 0x0A, 0x97, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x05, 0x05, 0x98, 0x98, 0x05, 0x05, 0x37, 0x84, 0x84, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 
        0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x5B, 0x5B, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 
        0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x06, 0x60, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x92, 0x92, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x0D, 0x88, 0x0D, 0x88, 0x88, 0x88, 0x88, 0x88, 0xC0, 0xC0, 0xC0, 0xC0, 0x88, 0x88, 0x88, 0xC0, 0xC0, 0x0D, 0x0D, 0xA6, 0xBF, 0xBF, 0x1C, 0x1C, 0x1C, 0xC5, 0xEB, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x50, 0x50, 0x50, 0x50, 0x2D, 0xBE, 0xF7, 
        0x50, 0x2D, 0x2D, 0xB7, 0x57, 0x1C, 0x1C, 0xBF, 0xA6, 0x0D, 0xC0, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0xA8, 0xA8, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0x6D, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0xD2, 0x96, 0x27, 0x96, 0x96, 0x2C, 0xAA, 0x2C, 0x2C, 0x2C, 
        0xAA, 0x36, 0x36, 0x36, 0xBC, 0x36, 0xBC, 0x2B, 0x34, 0x34, 0x34, 0xAC, 0xBC, 0xBC, 0x34, 0x34, 0x34, 0x34, 0x38, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x34, 0x38, 0x10, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x19, 0x19, 
        0x24, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x20, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x17, 0x17, 0x73, 0x1B, 0x1D, 0xDC, 0x1D, 0x66, 0x66, 0x9C, 0x9C, 0x9C, 0x9C, 0x66, 0xFD, 0x1F, 0x1D, 0x31, 0x17, 0x17, 
        0x17, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0xFC, 0x95, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x9B, 0x9B, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 
        0x17, 0x17, 0x86, 0x86, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x13, 0x13, 0xE5, 0x17, 0x17, 0x17, 0x17, 0x73, 0x1B, 0x9D, 0x9D, 0x66, 0x66, 0x05, 0x05, 0x05, 0x98, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x5B, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x09, 0x85, 
        0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x09, 0x09, 0x09, 0xCA, 0xCA, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x5B, 0x5B, 0xE6, 0xE6, 0x16, 0x16, 0x16, 0xE6, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x09, 0x03, 0x03, 0x85, 
        0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x8C, 0x02, 0xF2, 
        0x8C, 0x8C, 0xF2, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09,
  0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x5C, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xBF, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0xC0, 0xC0, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 
        0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0x6D, 0x6D, 0x6D, 0x6D, 0xDA, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0x6D, 0xDD, 0x74, 0x74, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0x8A, 0x8A, 
        0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x8A, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x74, 0xBB, 0xC1, 0x6D, 0x07, 0x07, 0x07, 0x65, 0x65, 0xCC, 0xCC, 0x27, 0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x4E, 0x2B, 0x4E, 0x2B, 0x2B, 0xAC, 0x38, 0x34, 0xD3, 0x10, 
        0x10, 0x44, 0x25, 0x25, 0x25, 0xF0, 0x26, 0x26, 0x79, 0x79, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 
        0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x17, 0xAE, 0x1B, 0x1B, 0x73, 0x1D, 0x1D, 0x66, 0x05, 0x05, 0x05, 0x98, 0x98, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x3D, 0x98, 0x98, 0x98, 0x98, 0x37, 0x98, 0x98, 0x2E, 0x98, 0x3D, 0x3D, 0x2E, 0x2E, 0x3D, 0x2E, 0x2E, 0x04, 0x04, 0x3D, 
        0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x97, 0x97, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x6C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x97, 0x97, 0x6C, 0x8C, 0x8C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0xB6, 0xB6, 0x50, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x57, 0x1C, 0x1C, 0x1C, 0x6A, 0xBF, 0xBF, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 
        0x0C, 0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x96, 0x96, 0x2C, 0x2C, 0xE4, 0x2B, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xAC, 0x34, 0x36, 0x36, 0x36, 0x2B, 0x2B, 
        0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0x36, 0xAC, 0xAC, 0x34, 0x2B, 0x34, 0x34, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0xEC, 0x38, 0x38, 0x34, 0x34, 
        0x3A, 0x38, 0xD3, 0x38, 0x34, 0x38, 0x3A, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x87, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x80, 0x14, 
        0x78, 0x78, 0x12, 0x0F, 0x11, 0x1A, 0x86, 0x86, 0xAE, 0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x1F, 0x1D, 0x9C, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x66, 0x66, 0x66, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x37, 0x37, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x8C, 0x8C, 0xF2, 0x97, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 
        0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x92, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x97, 
        0x97, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF,
  0x7A, 0x7A, 0xA5, 0xA5, 0x4D, 0x2F, 0x6E, 0x6E, 0x6E, 0x48, 0x48, 0x33, 0x56, 0x4B, 0x3C, 0x3C, 0x3F, 0x54, 0x50, 0x2D, 0x5C, 0x5C, 0xC5, 0x1C, 0x6A, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xBA, 0xBA, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0xA8, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0xA8, 0x0B, 0x0B, 
        0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x74, 0x08, 0xDD, 0xBB, 0xBB, 0xBB, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0x49, 0x27, 0x27, 0x49, 0x41, 0x4E, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x29, 0x26, 0x26, 0x79, 
        0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x1E, 0x20, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x9C, 0x66, 0x9C, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x66, 0x66, 0x9C, 0x66, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x73, 0x17, 0x17, 0x86, 0x86, 0x86, 
        0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x11, 0x11, 0x77, 0xCE, 0xCE, 0x77, 0x77, 0x9B, 0x86, 0x86, 0xAE, 0x73, 0x1D, 0x1D, 0x05, 0x05, 0x05, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 
        0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 
        0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x0A, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x89, 0x23, 0x89, 0x89, 0xA3, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A,
  0xA5, 0x4D, 0x4D, 0x4D, 0x2F, 0x6E, 0x6E, 0x48, 0xF5, 0x33, 0x4B, 0x4B, 0x4B, 0x3C, 0x3F, 0x3F, 0x50, 0x50, 0x2D, 0x5C, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x6A, 0xA6, 0x0D, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0x7B, 0x08, 
        0x08, 0x08, 0xDA, 0x07, 0x07, 0x07, 0x65, 0x65, 0x94, 0x27, 0x27, 0x2C, 0x2C, 0x2C, 0x36, 0x2B, 0x34, 0x34, 0x38, 0x38, 0x10, 0x44, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 
        0x80, 0x8E, 0x8E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 
        0x19, 0x19, 0x24, 0x24, 0x7D, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x15, 0x15, 0x95, 0x12, 0xDE, 0x12, 0x91, 0x0F, 0x0F, 0x11, 0x1A, 0x1A, 0x1A, 0x9B, 0x86, 0x17, 0x73, 0x1B, 
        0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 
        0x89, 0x89, 0x89, 0x89, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0xF2, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x97, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x6C, 0x6C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0xB6, 0x54, 0x50, 0xBE, 0x50, 0xBE, 0x2D, 0x2D, 0x2D, 0x5C, 0x5C, 0x5C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x1C, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 
        0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xC1, 0xC1, 0x07, 0x94, 0x96, 0x2C, 0xAA, 0x36, 0x36, 0x3A, 0xD3, 0x10, 0x44, 0xD5, 0x25, 0x25, 0xF0, 0x26, 0x26, 
        0x26, 0x28, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x25, 0x25, 0x59, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 
        0xAC, 0x34, 0x34, 0x34, 0x38, 0xD3, 0xD3, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 
        0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x86, 0xAE, 0x17, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x37, 0x05, 0x05, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0x04, 0x2E, 0x2E, 0x3D, 0x2E, 0x98, 0x98, 0x37, 0x37, 0x2E, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x3D, 0x3D, 0x98, 0x98, 0x84, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 
        0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x03, 0x09, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x8C, 0x97, 0x97, 0xF2, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0xF2, 0xF2, 0x8C, 0xF2, 0x0A, 0x0A, 0xF2, 0xF2, 0x0A, 0x97, 
        0x97, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x92, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01,
  0xA1, 0x4F, 0x2A, 0x7A, 0xA5, 0x2F, 0x6E, 0x6E, 0x48, 0x33, 0x56, 0x4B, 0x3C, 0x54, 0x50, 0x2D, 0x2D, 0x2D, 0x5C, 0xC5, 0x1C, 0x1C, 0x1C, 0x6A, 0xB8, 0xB8, 0x0D, 0x0D, 0x0D, 0x88, 0x88, 0x93, 0x93, 0x88, 0x93, 0x75, 0x75, 0x75, 0x93, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xBF, 0xA6, 0xA6, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 
        0x08, 0x74, 0x6D, 0x6D, 0x07, 0x65, 0xCC, 0x27, 0xD2, 0x41, 0x4E, 0xAB, 0x2B, 0x2B, 0xAC, 0xAC, 0x2B, 0xAC, 0x2B, 0x2B, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0xAA, 0xAA, 0xAA, 0xAA, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 
        0xAB, 0xAB, 0xE4, 0x36, 0x36, 0x36, 0x5A, 0x3A, 0x3A, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x17, 0x1B, 0x1D, 0x9C, 0x05, 
        0x05, 0x2E, 0x2E, 0x2E, 0x55, 0x55, 0xA3, 0x55, 0x55, 0xA3, 0x5F, 0x5F, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xA3, 0xA3, 0x55, 0x04, 0x04, 0x04, 0xFE, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1B, 0x17, 0x86, 0x1A, 0x0F, 
        0x91, 0x12, 0x12, 0x12, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x18, 0x14, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x17, 0x73, 0x1B, 0x1D, 0x1D, 0x1F, 0x05, 0x05, 0x05, 0x98, 0x84, 0x2E, 0xFE, 0xFE, 
        0x04, 0x04, 0x04, 0x55, 0x55, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 
        0x23, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x03, 0x03, 0x16, 0x03, 0x16, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x03, 0x16, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x16, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x97, 0x97, 0x97, 0x97, 0x97, 0xF2, 0xF2, 0x97, 0x0A, 0x8C, 0x0A, 0x0A, 0xF2, 0x97, 0x0A, 0x97, 
        0x97, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x97, 0x97, 0x8C,
  0x2F, 0x2F, 0x6E, 0x48, 0x33, 0x33, 0xB5, 0xB5, 0x4B, 0x4B, 0x3C, 0x3C, 0x3F, 0xC4, 0x54, 0x50, 0x50, 0x2D, 0x5C, 0x5C, 0xC5, 0x1C, 0x1C, 0x6A, 0x1C, 0x1C, 0x6A, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 0xA6, 0x0D, 0x0D, 0x88, 0x88, 0x0D, 0x93, 0xB1, 
        0xB1, 0xC0, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x9F, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xB2, 0xA8, 0xB2, 0xB2, 0xB2, 0xB2, 
        0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xB3, 0xB3, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x49, 0x96, 0x96, 0x4E, 0x4E, 0x2B, 
        0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x26, 0x19, 0x24, 0x24, 0x21, 0x90, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x12, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x91, 
        0x91, 0x12, 0x12, 0x12, 0x12, 0x91, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x1B, 0x9D, 0x31, 0x9D, 0x1D, 0x1B, 0x9D, 0x9D, 0x9D, 0x9D, 
        0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x1D, 0x1D, 0x73, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x9D, 0x9D, 0x9D, 0x1D, 0x9C, 0x05, 0x05, 0x37, 0x37, 
        0x98, 0x2E, 0x04, 0x04, 0x04, 0x89, 0x5F, 0xDF, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x97, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0xCA, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 
        0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x09, 0x09, 0x85, 0x85, 0x85, 0x09, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x0A, 0x0A, 0xF2, 0x6C, 0x6C, 0x8C, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x3C, 0x3C, 0x3C, 0x4B, 0x3C, 0x3C, 0x4B, 0x4B, 0x4B, 0x4B, 0xB5, 0xB5, 0xB5, 0x56, 0xB5, 0xB5, 0x4B, 0xEA, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0xEA, 0xEA, 0x3C, 0x3C, 0x3C, 0xE0, 0x3F, 0x3F, 0xB6, 0xB6, 0xBE, 0xBE, 0xF7, 0x2D, 0x2D, 0x2D, 0xC5, 0x1C, 
        0x1C, 0xBF, 0xA6, 0x0D, 0xC0, 0xB1, 0x0E, 0xE2, 0xCB, 0x0C, 0xB2, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0x0B, 0x0B, 0x0B, 0xA8, 0xB2, 0xB2, 
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0x07, 0x07, 0x07, 0x94, 0x27, 0x2C, 0x4E, 0x2B, 0x34, 0x38, 0x10, 0x25, 0x25, 0x26, 0x26, 0x79, 0x24, 0x22, 0x21, 0x90, 0x90, 
        0x80, 0x80, 0x14, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x77, 0x77, 0x0F, 0x91, 0x12, 0x12, 0x78, 0x14, 0x80, 0x1E, 0x1E, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 
        0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x9D, 0x1F, 0x1F, 0x9C, 
        0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x37, 0x37, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1F, 0x1D, 0x1D, 0x1D, 
        0x1D, 0xDC, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x1D, 0x1D, 0xDC, 0xDC, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0xA3, 0x55, 0x23, 0x89, 0x89, 0x23, 0x23, 0x23, 0x5F, 
        0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x85, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x85, 0x85, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x0A,
  0x3C, 0xE0, 0x3F, 0x54, 0x50, 0x50, 0x2D, 0x5C, 0x57, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xBF, 0x6B, 0xA6, 0xA6, 0xA6, 0x6B, 0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0x93, 0x93, 0xC0, 0xCF, 0x75, 0x75, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 
        0xB2, 0xB2, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0xA8, 0xA8, 0x8D, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xCB, 
        0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0x8A, 0xB3, 0xB3, 0x7B, 0xA0, 0x08, 0x08, 0x74, 0x6D, 0x6D, 0x07, 0x65, 
        0xCC, 0x27, 0x2C, 0x2C, 0x2B, 0xAC, 0x34, 0xD3, 0xED, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x15, 0x91, 0x91, 0x0F, 0x77, 0x1A, 0x9B, 0x17, 0xAE, 0x1B, 0x1D, 0x1F, 0x9C, 0x05, 0x05, 0x37, 0x84, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0x2E, 
        0x84, 0x2E, 0x2E, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9D, 0xDC, 0x1D, 0x1D, 0x9C, 0x9C, 0x66, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 
        0x98, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x04, 0x89, 0x89, 0x55, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0xF2, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xF2, 0xF2, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x8C, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x33, 0x33, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0x50, 0x50, 0x2D, 0x5C, 0xC5, 0x1C, 0x1C, 0x6A, 0xBF, 0xA6, 0x0D, 0x0D, 0x93, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 
        0xE2, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0x6B, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x6B, 0x6B, 0xA6, 0x0D, 0x6B, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x8A, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x27, 0x41, 0x41, 0xAB, 0x36, 
        0x36, 0xAC, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0xAD, 0x25, 0x25, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x24, 0x90, 
        0x90, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x86, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 
        0x05, 0x05, 0x9C, 0x1D, 0x1D, 0x1B, 0xAE, 0x86, 0x13, 0x1A, 0x63, 0xCE, 0x0F, 0x0F, 0xCE, 0xCE, 0x0F, 0x0F, 0xCE, 0x1A, 0x77, 0x1A, 0x9B, 0x13, 0x17, 0x1B, 0x1D, 0x9D, 0x66, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x84, 0x3D, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x55, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x23, 
        0x23, 0x23, 0x23, 0x89, 0x89, 0x04, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 
        0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x97, 0x97, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0xF2, 0x0A, 0x8C, 0xF2, 0x97,
  0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0x7A, 0xA5, 0xA5, 0x2F, 0x2F, 0x6E, 0xA2, 0x33, 0x33, 0xB5, 0x4B, 0x3C, 0x3F, 0x54, 0x50, 0x50, 0x5C, 0xC5, 0x57, 0x1C, 0x6A, 0xB8, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0x75, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0xB1, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0xBF, 0xBF, 0x1C, 0x1C, 0xBF, 0x1C, 0x1C, 0xBF, 0x1C, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xB1, 0xB1, 0x0E, 0x0E, 0xE2, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0xA0, 0x08, 0x08, 
        0xBB, 0xBB, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x96, 0x96, 0x2C, 0x4E, 0xAB, 0xAB, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x34, 0x34, 0x38, 0x34, 0x34, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x34, 0x34, 0xAC, 0x2B, 0xE4, 0x2B, 0xAB, 0x4E, 
        0x2C, 0x41, 0xD2, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x49, 0x27, 0x27, 0x49, 0x49, 0x49, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x79, 0x19, 0x19, 0x24, 
        0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x11, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x1A, 0x9B, 
        0x9B, 0x9B, 0x42, 0x17, 0x17, 0x73, 0x73, 0x73, 0x73, 0x73, 0x17, 0x17, 0x17, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x73, 0x17, 0x73, 0x17, 0x73, 0x1B, 0x17, 0x73, 0x31, 0x73, 0x73, 0x1D, 0x1D, 0x66, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x3D, 0x3D, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x55, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x02, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 
        0x16, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x85, 0x85, 0x01, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x92, 0x92, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x0A, 0x8C, 0xF2, 0x97, 0x97, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x97, 0x0A, 0x97, 0x97, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x97, 0x97, 0x97, 0x97, 0x0A, 0x97, 0x97, 0x97, 0xF2, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x6C, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xDF, 0xDF, 0xDF, 0x5F, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0xA3, 0xA3, 0x55, 0x04, 0x04,
  0x50, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0xB7, 0x57, 0x57, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x57, 0x1C, 0x57, 0xC5, 0x1C, 0x1C, 0xC5, 0xC5, 0x5C, 0x5C, 0x2D, 0x5C, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xBE, 0xBE, 0x50, 0x50, 
        0x50, 0x50, 0xBE, 0xBE, 0x50, 0x50, 0x2D, 0x2D, 0xB7, 0xB7, 0x57, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0xB3, 
        0xA0, 0x08, 0x08, 0xC1, 0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x36, 0x2B, 0x34, 0x3A, 0x10, 0x44, 0x10, 0x25, 0xEE, 0x29, 0x26, 0x26, 0x87, 0x26, 0x26, 0x79, 0x79, 0x28, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x79, 0x79, 0x79, 0x79, 0x79, 0x28, 0x26, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x10, 0x25, 0x10, 0x10, 0x25, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x19, 0x19, 0x24, 0x21, 0x21, 
        0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x13, 0x13, 0x86, 0x86, 0x1B, 0x1D, 
        0x1D, 0x9D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x98, 0x98, 0x05, 0x98, 0x37, 0x37, 0x37, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x66, 0x66, 0x66, 0x1D, 0x9D, 0x9D, 0x1D, 0x73, 0x1D, 0x1B, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 
        0xDC, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x37, 0x37, 0x84, 0x84, 0x98, 0x37, 0x37, 0x37, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x55, 0x55, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 
        0x09, 0x09, 0x85, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x97, 0xF2, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0xDF, 0x5F, 0x23, 0xDF, 0x23, 0x02, 0x23, 
        0xDF, 0x02, 0xDF, 0x5F, 0x02, 0xDF, 0x23, 0x5F, 0xDF, 0xDF, 0x5F, 0x5F, 0x5F, 0x5F, 0xA3, 0x5F, 0x23, 0x89, 0xA3, 0xA3, 0x5F, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x89,
  0x7A, 0x4D, 0x2F, 0x2F, 0x6E, 0x6E, 0x48, 0x33, 0x33, 0x56, 0x56, 0x4B, 0x4B, 0xE0, 0xE0, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x54, 0x3F, 0x3F, 0x3F, 0x3F, 0x3C, 0x3C, 0xEA, 0x4B, 0x4B, 0x4B, 0xB5, 0x56, 0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0x33, 0x56, 0x56, 0xB5, 0x4B, 0x4B, 0x3C, 0x3F, 0x3F, 0xF7, 0xBE, 0x2D, 0xEB, 0xC5, 0x1C, 0xBF, 0xA6, 0x0D, 0x0D, 0xC0, 0xC0, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xB2, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 
        0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x65, 0x94, 0x27, 0x27, 0x27, 0x96, 0x96, 0x41, 0x4E, 0x4E, 0x4E, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 
        0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 
        0x19, 0x19, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 
        0x0F, 0x0F, 0x77, 0x1A, 0x1A, 0x9B, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x73, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0x86, 0x17, 
        0x17, 0x73, 0x73, 0x1B, 0x31, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x66, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x37, 0x2E, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x04, 0x3D, 0x3D, 0x2E, 0x3D, 0x3D, 0x3D, 0x2E, 0x2E, 0xFE, 
        0xFE, 0x04, 0x3D, 0x04, 0x04, 0x04, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x02, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x85, 0x01, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x97, 0x97, 0x0A, 0x0A, 0x0A, 0x8C, 0xF2, 0x97, 0xF2, 0xF2, 0xF2, 0xF2, 0xF2, 0x97, 0x97, 0x97, 0x97, 0x97, 0x8C, 0xF2, 0xF2, 0x97, 0x0A, 0x0A,
  0x53, 0x53, 0x53, 0x53, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x4F, 0x2A, 0x2A, 0xA5, 0x2F, 0x2F, 0xA2, 0x48, 0x33, 0x56, 0x4B, 0x3C, 0x3C, 0x3F, 0xC4, 0x50, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D, 0xEB, 
        0xC5, 0x1C, 0x1C, 0x6A, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 
        0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0x8A, 0x8A, 0x7B, 0x8A, 0x8A, 0x7B, 0xB3, 0x8A, 0x8A, 0x0B, 0x0B, 0x0B, 0x8D, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 
        0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0xB3, 0x8A, 0x08, 0x08, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x49, 0x49, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x24, 0x21, 0x90, 0x1E, 0x14, 0x78, 
        0x12, 0x12, 0x12, 0x0F, 0xCE, 0x1A, 0x13, 0x86, 0x17, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x66, 0x1D, 0x1D, 0x1F, 0x1D, 0xDC, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0xDC, 0x31, 0x1B, 0x17, 0x1B, 0xAE, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x73, 0x1D, 0x1D, 0x1D, 0x31, 0x73, 0x31, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0xA3, 0x23, 0xDF, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x55, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x3D, 0x2E, 0x2E, 0x84, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 
        0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x97, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0xF2, 0xF2, 0x8C, 0xF2, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x89, 0xA3, 0x55, 0xA3, 0xA3, 0x04, 0x04, 0x55,
  0x4D, 0xA5, 0xA5, 0x2A, 0x7A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 0x7A, 0xA5, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x33, 0xB5, 0xB5, 0x4B, 0x3C, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 
        0x57, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xB8, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x74, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0x7B, 0x7B, 0x7B, 0x7B, 0x7B, 0xA0, 0x08, 0x08, 0x08, 0x08, 
        0x74, 0xDD, 0xDA, 0x07, 0x07, 0x07, 0x49, 0x27, 0xD2, 0xD1, 0xAB, 0x36, 0x36, 0x34, 0x38, 0x3A, 0x10, 0x10, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 
        0x21, 0x90, 0x90, 0x90, 0x21, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0xFC, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x78, 0x91, 0x12, 0x91, 
        0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 0x13, 0x86, 0x86, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x17, 0xAE, 0x17, 0x73, 0x73, 0x17, 0x73, 0x73, 
        0x73, 0x73, 0x73, 0x17, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x17, 0x73, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x9C, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x55, 0x55, 0x89, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x23, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x97, 0x8C, 0x0A, 0x0A, 0x8C, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 
        0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 
        0x8C, 0xF2, 0xF2, 0xF2, 0x8C, 0x8C, 0x6C, 0x6C, 0x6C, 0x6C, 0x02, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x6C, 0xF2, 0x0A, 0x97, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x2A, 0x2A, 0x2A, 0x4D, 0x2F, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x33, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x54, 0x54, 0x50, 
        0x50, 0x50, 0x50, 0x5C, 0x2D, 0x5C, 0x5C, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 
        0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xDA, 0x6D, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x65, 0x65, 0x49, 0x49, 0x49, 0x27, 0x27, 0x49, 0x27, 
        0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0x41, 0x41, 0x2C, 0x4E, 0xAB, 0x2B, 0x2B, 0x2B, 0xAC, 0x38, 0x38, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x19, 0x24, 0x21, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 
        0x13, 0x13, 0x77, 0xCE, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x8E, 0x8E, 0x80, 0x14, 0x14, 0x80, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x86, 0x86, 0x86, 0x1B, 0x1D, 0x9D, 0x1D, 0xFD, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 0x37, 
        0x37, 0x37, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x13, 0x13, 0xAE, 0x17, 0xAE, 0xAE, 0xAE, 0xAE, 0x17, 0x17, 0xAE, 0x17, 0x17, 0xAE, 0x73, 0x31, 0x31, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 
        0x1F, 0x66, 0xFD, 0xFD, 0x9C, 0x9C, 0x9C, 0x05, 0x37, 0x37, 0x05, 0x37, 0x37, 0xFE, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x03, 0x03, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x92, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x8C, 0x8C, 0x8C, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x5F, 0x5F, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x55, 0x04, 0xA3, 0x89, 0x89, 0x55, 0xA3, 0xA3, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0xF2, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xF6, 0x33, 0x33, 0x48, 0xF5, 0xF5, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4B, 0x4B, 0xEA, 0x3C, 0x3C, 0x3F, 0xC4, 0x54, 0xBE, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 
        0x5C, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0x6A, 0xB8, 0xB8, 0xB8, 0xB8, 0x0D, 0xB8, 0xB8, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0x0B, 
        0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x2C, 0x41, 0x2C, 0x2C, 0x4E, 0x2C, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0xAC, 0x34, 0x34, 0x34, 0x38, 
        0x3A, 0xD3, 0x10, 0x10, 0x10, 0x25, 0x25, 0xF0, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x19, 0x24, 0x19, 0x19, 0x24, 0x24, 0x24, 0x19, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x26, 0x28, 0x19, 0x19, 0x24, 0x24, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x9B, 0x1A, 0x77, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x77, 0x77, 0x11, 0x11, 0x77, 0x77, 0x77, 0x77, 0x77, 0x11, 0x1A, 0xCE, 0xCE, 0xCE, 0x77, 0x77, 0x1A, 0x1A, 0x1A, 0x1A, 0x9B, 0x9B, 0x9B, 0x9B, 0x17, 0x9B, 0x17, 0x42, 0x13, 0x9B, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 
        0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x37, 0x05, 0x37, 0x05, 0x37, 0x05, 0x05, 0x37, 
        0x05, 0x37, 0x37, 0x37, 0x37, 0x37, 0x05, 0x37, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x84, 0x98, 0x98, 0x05, 0x05, 0x98, 0x98, 0x84, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 
        0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x09, 0x09, 0x09, 0x85, 0x01, 
        0x85, 0x01, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0x5F, 0x5F, 0x5F, 0x89, 0x89, 0xA3, 
        0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x23, 0x23, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x23, 
        0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 0x23, 0x89, 0xA3, 0xA3, 0x23, 0x23, 0xDF, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x2F, 0x2F, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x48, 0x48, 0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x56, 0xB5, 0xB5, 0x56, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3F, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x3F, 0x54, 0x54, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0xF7, 0xBE, 0xBE, 0x2D, 0xEB, 0xEB, 0x1C, 0x1C, 0xA6, 0x0D, 0x0D, 0xC0, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0xB3, 0xB3, 
        0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0xBB, 0xBB, 0x6D, 0x6D, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x27, 0xD2, 0xD2, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x38, 
        0x10, 0x10, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x7D, 0x7D, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x26, 0x26, 0x87, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0xDE, 0x91, 
        0x91, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x66, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 
        0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x77, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x84, 0x98, 0x3D, 0x98, 0x2E, 0x98, 0x98, 0x37, 0x37, 0x05, 0x05, 0x05, 
        0x05, 0xFD, 0x66, 0xFD, 0x1D, 0x9D, 0x9D, 0x1B, 0x1B, 0xAE, 0xAE, 0xAE, 0xAE, 0x86, 0x13, 0x86, 0xAE, 0x73, 0x73, 0x1B, 0x1B, 0x1B, 0x31, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x84, 0x84, 0x2E, 0xFE, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x02, 0x02, 0x02, 
        0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x97, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0xDF, 0xDF, 0x5F, 0x5F, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0xDF, 0x5F, 0x5F, 0x23, 0x5F, 0x02, 0xDF, 0x02, 0x02, 0xDF, 0xDF, 0xDF, 0xDF, 0x02, 0x02, 0x02, 
        0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x5F, 0x5F, 0x02, 0x02, 0x5F, 0x02, 0xDF, 0xDF, 0x02, 0x5F, 0x5F, 0x02, 0x02,
  0x2F, 0x2F, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x48, 0x48, 0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x56, 0x56, 0xB5, 0xB5, 0xB5, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x50, 
        0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x5C, 0x5C, 0xB7, 0x57, 0x5C, 0x5C, 0x5C, 0xEB, 0xC5, 0x5C, 0x5C, 0x5C, 0x5C, 0xEB, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0x0E, 0x0E, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 
        0x0B, 0x0B, 0x0B, 0x8A, 0xB3, 0x7B, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x41, 0x96, 0x41, 0x41, 0xD1, 0x41, 
        0xD2, 0x27, 0x49, 0x49, 0x65, 0x65, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x65, 0x65, 0x65, 0x65, 0x49, 0x49, 0xD2, 0x41, 0x41, 0x2B, 0x2B, 0x34, 0x34, 0x10, 0x10, 0x25, 0x29, 0x29, 0x26, 0x19, 0x24, 0x22, 0x21, 0x90, 0x1E, 0x1E, 
        0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x15, 0x15, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0xCE, 0x1A, 0x1A, 0x1A, 
        0xE5, 0x9B, 0x9B, 0x17, 0x73, 0x73, 0x73, 0x73, 0x73, 0x1D, 0xDC, 0x1D, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9C, 0x66, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 
        0x1D, 0x9D, 0x9D, 0xDC, 0x1D, 0x1D, 0x1D, 0xDC, 0xDC, 0x66, 0x1D, 0x1F, 0x66, 0x66, 0x66, 0x1D, 0x66, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x66, 0x66, 0x1D, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0xFE, 0xFE, 
        0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x0A, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 
        0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x5F, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x5F, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x23, 0x89, 0x89, 0xA3, 0xA3, 0xA3, 0x55, 0x04, 0x04, 
        0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x84, 0x37, 0x98, 0x98, 0x84, 0x84, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0xFE, 0x3D, 0xFE, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0xA3, 0xA3, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 0x02, 0xDF, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C,
  0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0x7A, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x56, 0x56, 0x4B, 0x4B, 0x3C, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x3F, 0x3F, 0x3F, 0xBE, 
        0xBE, 0xBE, 0x2D, 0x2D, 0x5C, 0x5C, 0x5C, 0xEB, 0xC5, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0x1C, 0xC5, 0xC5, 0xC5, 0xE1, 0xC5, 0xEB, 0xEB, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xEB, 0xB7, 0x57, 0x57, 0x57, 0x1C, 0x1C, 
        0x1C, 0x1C, 0x6A, 0x6B, 0x6B, 0x6B, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB9, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 
        0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0x41, 0x41, 0xD1, 0x4E, 0xAB, 0x2B, 0x36, 0x34, 0x34, 0x34, 0x3A, 0xD3, 0x10, 0xAD, 0x29, 0x29, 0x26, 0x79, 0x19, 0x24, 0x24, 0x24, 0x90, 0x90, 
        0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x20, 0x80, 0x80, 0x80, 0x20, 0x20, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x9B, 0x9B, 0x9B, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 
        0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x84, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x23, 0x23, 
        0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x84, 0x84, 0x98, 
        0x37, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x3D, 0x3D, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x55, 0x89, 0x55, 0x89, 0x89, 0xA3, 0x89, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x23, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x8C, 
        0x8C, 0xF2, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x01, 0x01, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0xF2, 0x6C, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x5F, 0x5F, 
        0x5F, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3, 0x89, 0x23, 0x23, 0x23, 0xDF, 0x02, 0x02,
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0x32, 0xB4, 0xB4, 0x53, 0x53, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x4D, 0xA5, 0x4D, 0x2F, 0x2F, 0x6E, 0x48, 0x48, 0x48, 0x33, 0x56, 0x4B, 0x4B, 0xE0, 
        0x3F, 0x3F, 0x54, 0xBE, 0xBE, 0x2D, 0xC5, 0x1C, 0x1C, 0x7E, 0xA6, 0x0D, 0x0D, 0x88, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x8D, 0x8D, 0xB2, 0x8D, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 
        0x8A, 0x08, 0x08, 0x08, 0x74, 0x74, 0xDA, 0x6D, 0x07, 0x07, 0x65, 0xCC, 0xA9, 0x27, 0xD2, 0x41, 0x41, 0x41, 0x41, 0x2C, 0x2C, 0x4E, 0xAB, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x36, 0x36, 0x36, 0xE4, 0x36, 0x36, 
        0x2B, 0xAB, 0x2C, 0x2C, 0x2C, 0x41, 0x41, 0xD2, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x07, 0x07, 0x65, 0xCC, 0xCC, 0x94, 0x07, 0x94, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x96, 0x96, 0xC2, 0x2C, 0x4E, 0x4E, 0xAB, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 
        0x34, 0x34, 0x34, 0x38, 0xD3, 0x10, 0x10, 0xAD, 0x25, 0x25, 0x26, 0x26, 0x26, 0x79, 0x19, 0x24, 0x21, 0x90, 0x90, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 
        0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x1A, 0x1A, 0x86, 0x86, 0x9B, 0x9B, 0x9B, 0x17, 0x17, 0x17, 
        0x73, 0x73, 0x73, 0x73, 0x73, 0x73, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xFD, 0xFD, 0x9C, 0x9C, 0x9C, 0x66, 0x66, 0xFD, 0x9C, 0x9C, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x73, 0x73, 0x17, 0x17, 0x17, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x3D, 0x3D, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x84, 0x2E, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x84, 0x84, 
        0x84, 0xFE, 0xFE, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x55, 0xA3, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x5F, 0x23, 0x23, 
        0xA3, 0x89, 0x89, 0x55, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x04, 0x89, 0x89, 0x89, 0x89,
  0xA5, 0xA5, 0xA5, 0x4D, 0x4D, 0x4D, 0xA5, 0x4D, 0x4D, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0xA5, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x33, 0x33, 0xB5, 0x4B, 0x3C, 
        0x3F, 0x3F, 0x50, 0x50, 0x2D, 0x2D, 0xC5, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0x8D, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 
        0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0xCC, 0xCC, 0xCC, 0x49, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x49, 
        0x49, 0x49, 0x49, 0xCC, 0x65, 0x65, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x41, 0x4E, 0x41, 0x4E, 0x4E, 0x2B, 0x2B, 0xE4, 0x2B, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 
        0x2B, 0xAB, 0x2B, 0xAB, 0x4E, 0x2C, 0x4E, 0x4E, 0x2C, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x9B, 0x86, 0x17, 0x17, 0x73, 0xDC, 0x66, 0x66, 0x9C, 0x05, 0x05, 0x05, 0x98, 0x98, 0x98, 0x98, 0x98, 0x3D, 0x3D, 0x98, 
        0x98, 0x98, 0x37, 0x98, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x73, 0x73, 0x73, 0x17, 0x17, 0x17, 0x9B, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x9D, 
        0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x3D, 0xFE, 0xFE, 0x3D, 0x3D, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 0xA3, 0xA3, 0x89, 0x55, 0x55, 0x89, 0x89, 0x89, 0x55, 0x89, 0x04, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x55, 0x55, 0x55, 0x04, 0x89, 0x23, 0x23, 0x23, 
        0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x02, 0x02, 0xDF, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x55, 
        0x89, 0x89, 0x89, 0x89, 0x04, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x55, 0xA3, 0xA3, 0xA3, 0xA3, 0xA3, 0x5F, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x6C,
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x2A, 0x2A, 0xA5, 0x4D, 0x4D, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x48, 0x33, 0xB5, 0xB5, 0x3C, 
        0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0xBE, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 0x5C, 0xC5, 0xC5, 0x1C, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0xC0, 0xCF, 0xCF, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xB1, 
        0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x93, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x8D, 0x8D, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 
        0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x96, 0x41, 0x41, 0x4E, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x44, 0x25, 0x25, 
        0x25, 0x29, 0xF0, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 
        0x29, 0x29, 0x29, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0xDE, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0xCE, 0x77, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x73, 0x73, 0x73, 0x31, 0x9D, 0x1D, 0xDC, 0xDC, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1D, 0xDC, 0x9D, 0x1D, 0x9D, 0x1D, 0x1D, 0x66, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x84, 0x84, 0x84, 0x2E, 0x3D, 0x3D, 0x3D, 0xFE, 0x2E, 0x3D, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0xA3, 0x04, 0x89, 0x89, 0xA3, 0x23, 0x23, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x02, 0x02, 0x8C, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x85, 0x85, 0x85, 0x09, 0x09, 0x09, 0x85, 0x09, 0x09, 0x09, 0x09, 0x09, 0x85, 0x85, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8C, 0x8C, 0x8C, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x89, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0xA3, 
        0x5F, 0x5F, 0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x6C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x5F, 0x5F, 0x5F, 0x89, 0x89, 0x04,
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0x4D, 0x2F, 0x2F, 0xA2, 0x48, 0x48, 0x33, 0x33, 0xB5, 0xB5, 0xB5, 0x3C, 0x3C, 0x3F, 0x3F, 0x54, 
        0x50, 0xBE, 0xBE, 0x2D, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x5C, 0xC5, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xEB, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 
        0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xB3, 0x7B, 0x08, 0x74, 0xDD, 0xDD, 0xDD, 0xBB, 0xBB, 0xC1, 0x6D, 0x6D, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 
        0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xBB, 0x6D, 0x6D, 0x6D, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x6D, 0x6D, 0xDD, 0xDA, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x65, 0x65, 0x27, 0x27, 0x27, 0xD2, 0xD1, 0x2C, 0x2C, 0xAB, 0xAB, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x38, 
        0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0xF0, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x24, 0x22, 0x21, 0xCD, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 
        0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0xCE, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0xCE, 0x77, 0x77, 0x0F, 
        0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x23, 0x23, 0xDF, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x5F, 0x23, 0x23, 0x89, 0x23, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0xDF, 0x23, 
        0x5F, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xDF, 0x02, 0x02, 
        0x02, 0x02, 0xDF, 0x23, 0x23, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0xA3, 0x89, 0x23, 0x5F, 0xA3, 0x89, 0x89, 0x89, 0x89, 0x89, 0x5F, 0x5F, 0x02, 0x02, 0x5F, 0xDF, 0xDF, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0x89, 0x55, 0x55, 0x55, 0x04, 0x04,
  0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0xA5, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x33, 0x33, 0x33, 0x56, 0x56, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x54, 
        0xBE, 0xBE, 0xF7, 0xF7, 0x2D, 0x2D, 0xEB, 0xEB, 0xEB, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x93, 0x93, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 
        0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0x0C, 0x0C, 0x0C, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xDA, 0xC1, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0xCC, 0x94, 0x27, 0x49, 0x27, 0x27, 0x27, 0x41, 0x41, 0x4E, 0x4E, 0x2B, 0x36, 0x36, 0xAC, 0x34, 
        0x38, 0x38, 0x10, 0x10, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 
        0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0x13, 0x86, 0x86, 0x86, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x66, 0x9C, 0x9D, 
        0x1B, 0x17, 0x17, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x11, 0x11, 0x0F, 0x0F, 0x77, 0x11, 0x11, 0x77, 0x13, 0x13, 0x13, 0x13, 0x9B, 0x9B, 0x13, 0x13, 0x9B, 0x1A, 0x86, 0x86, 
        0x13, 0x42, 0x42, 0xAE, 0x73, 0x73, 0x73, 0x73, 0x73, 0x9D, 0x9D, 0x66, 0x66, 0x05, 0x05, 0x05, 0x84, 0x84, 0x3D, 0xFE, 0xFE, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x3D, 0x2E, 0x2E, 0x2E, 0x98, 0x98, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x66, 0x66, 0x9C, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x84, 0x84, 0x98, 0x2E, 0x3D, 0x2E, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
  0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0x53, 0x53, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0xA5, 0xA5, 0x2F, 0x6E, 0xA2, 0x48, 0x33, 0x33, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x3F, 0x3F, 0x54, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0xB7, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 
        0xA8, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xB2, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0xCB, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0x8D, 0xB2, 0xBA, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xF8, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 
        0x07, 0x07, 0x65, 0x65, 0x27, 0xD2, 0xD2, 0xD2, 0x41, 0x2B, 0x36, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 
        0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x12, 0x12, 0x12, 0x91, 0x12, 0x91, 
        0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x98, 0x37, 0x98, 0x98, 0x3D, 0x98, 0x98, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x23, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x89, 
        0x89, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x23, 0xDF, 0xDF, 0x23, 0x23, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x23, 0x02, 0x02, 0x02, 0x23, 0xDF, 0xDF, 0xDF, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x89, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
  0x45, 0xC3, 0xC3, 0x43, 0x35, 0x35, 0xA4, 0x4A, 0x4A, 0x32, 0xB4, 0x53, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 
        0xA2, 0xA2, 0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0xB5, 0x4B, 0x3C, 0x3C, 0x3F, 0x54, 0x50, 0x50, 0x2D, 0x5C, 0xC5, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0xE2, 0xE2, 
        0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xCB, 0xE2, 0xCB, 0xCB, 0xE2, 0xE2, 0xE2, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0x0E, 0xE2, 0xCB, 
        0x0C, 0x0C, 0xB2, 0x0B, 0xB3, 0xA0, 0x08, 0xBB, 0xC1, 0x07, 0x65, 0x65, 0x49, 0x27, 0xD2, 0x41, 0x4E, 0x2B, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x36, 0x36, 0x34, 0x34, 0x2B, 0x34, 0x34, 0x2B, 0x34, 0x34, 0xAC, 0x2B, 0x34, 0x34, 0x34, 
        0x34, 0x34, 0x34, 0xAC, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 
        0x21, 0x21, 0x90, 0x90, 0x90, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x1B, 0x1B, 0x1D, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x2E, 0x04, 0x2E, 
        0x2E, 0xFE, 0x2E, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x73, 0x73, 0x73, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x73, 0x73, 0x73, 0x1D, 
        0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 0x04, 0xFE, 0x04, 0x2E, 0xFE, 0x2E, 0x2E, 0x2E, 0xFE, 0xFE, 0x2E, 0x3D, 0x3D, 
        0xFE, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 
        0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F, 0xA3, 0x89, 0x23, 0x89, 0x55, 0xA3, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x84, 0x05, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x55, 0x55, 0xA3,
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x4D, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 
        0x33, 0x33, 0x33, 0x33, 0x56, 0xEA, 0x3C, 0x3C, 0x3F, 0x3F, 0x54, 0x50, 0xBE, 0xBE, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xC5, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 
        0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x8A, 0x8A, 0x7B, 0x7B, 0x08, 0x08, 0x08, 0x08, 0x08, 0xDA, 0x07, 0x07, 0x07, 0x07, 0x65, 0xCC, 0x27, 0x27, 0x27, 0x27, 0x27, 0xD2, 0x96, 0x2C, 0x2C, 0x2C, 0xE4, 0x36, 0x36, 
        0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 
        0x90, 0x90, 0x1E, 0x1E, 0x14, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x9B, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x86, 0xAE, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 
        0x17, 0x1B, 0x1B, 0x73, 0x73, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x55, 0x89, 0x89, 0x55, 0x89, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x98, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x3D, 0x3D, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55, 0x55, 0x89, 0x89, 0x23, 0x23, 0x23, 0x23, 0x89, 
        0x89, 0x23, 0x89, 0x89, 0x89, 0x89, 0x89, 0x55, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x3D, 0x3D, 0x2E, 0x2E, 0x2E, 0x3D, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x2E, 0x84, 0x2E, 0x84, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x37, 0x37, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x98, 0x3D, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 
        0x23, 0x5F, 0x23, 0x5F, 0x5F, 0x5F, 0x5F, 0x23, 0x23, 0x5F, 0x23, 0x23, 0x89, 0x89, 0xA3, 0x55, 0x55, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x05,
  0x30, 0x30, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0x6E, 0x48, 0x48, 0x6E, 0x48, 0x48, 0x48, 0xF5, 0x48, 0x48, 0x48, 0x33, 0x33, 0x48, 
        0x48, 0x33, 0x33, 0x33, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x4B, 0xE0, 0xE0, 0x3F, 0x3F, 0x54, 0xBE, 0xBE, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0xB7, 0x2D, 0xB7, 0xB7, 0x2D, 0x2D, 0x2D, 0xB7, 0x5C, 0xB7, 0xB7, 0xB7, 0xB7, 
        0x57, 0xC5, 0xC5, 0x57, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0x1C, 0x6A, 0xBF, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 
        0xA8, 0x0B, 0x0B, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x27, 0x27, 0x96, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xD1, 0x2C, 0x2C, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2C, 0x4E, 0xAA, 0x2C, 0x4E, 0x4E, 0x4E, 0xAA, 0xE4, 
        0x2B, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0xF0, 0x26, 0x26, 0x26, 0x26, 0x26, 0x28, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x79, 0x79, 0x19, 0x79, 0x79, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
        0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 
        0x05, 0x05, 0x9C, 0x66, 0x1D, 0x1F, 0x1D, 0xDC, 0x1D, 0x1D, 0x9D, 0x9D, 0xDC, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x66, 0x66, 0x1F, 0xFD, 0x66, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x73, 0x73, 0x17, 0xAE, 0xAE, 0x13, 0x13, 
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x42, 0x17, 0x73, 0x1B, 0xAE, 0x73, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x98, 0x2E, 0x2E, 0x84, 0xFE, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x23, 0x02, 0x02, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x84, 0x84, 0x37, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x37, 0x37, 0x84, 0x84, 0x05, 0x84, 0x84, 
        0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
  0x7A, 0x7A, 0x7A, 0x7A, 0x2A, 0x2A, 0x4F, 0x4F, 0x99, 0x4F, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 0x7A, 0x7A, 0x4D, 0x4D, 0x2F, 0x2F, 0x6E, 0x6E, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 0x48, 
        0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x48, 0x33, 0x33, 0xF6, 0x33, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x54, 0xB6, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x57, 0x57, 0x57, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 
        0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0xA6, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 
        0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x41, 0x41, 0x4E, 0x4E, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x12, 
        0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x2E, 0x84, 0x84, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0xFE, 
        0xFE, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x23, 0x23, 0xDF, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x6C, 0x6C, 0x6C, 0x6C, 0x8C, 0x8C, 0x6C, 0x6C, 0x8C, 0x8C, 0x02, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x23, 0x23, 0x23, 0x89, 0x89, 0x89, 0x89, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x04, 0x04, 0x2E, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x55,
  0x7A, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x6E, 0xA2, 0x48, 0x48, 
        0x33, 0x33, 0x56, 0x4B, 0x3C, 0x3C, 0x3F, 0x54, 0x54, 0x50, 0x50, 0x50, 0x50, 0x2D, 0x5C, 0x5C, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xB8, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 
        0xE2, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 
        0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x94, 0x94, 0x27, 0x27, 0x27, 0x94, 0x94, 0x94, 0x94, 0x94, 0x94, 0xCC, 0x65, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x96, 0xD2, 0x2C, 0x2C, 0x2C, 0x2B, 0x36, 0xAC, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 
        0x11, 0x1A, 0x1A, 0x13, 0x86, 0x17, 0x73, 0x73, 0x1B, 0x1D, 0x73, 0x1B, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x1F, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x98, 0x2E, 0x2E, 0x3D, 0x04, 0x04, 0x55, 0x55, 0x89, 0x02, 0x02, 0x02, 
        0x8C, 0x8C, 0x6C, 0x97, 0x01, 0x01, 0x0A, 0x0A, 0x01, 0x0A, 0x01, 0x0A, 0x0A, 0x0A, 0x0A, 0x6C, 0xF2, 0x02, 0x02, 0xDF, 0x23, 0x89, 0x55, 0x55, 0x04, 0x04, 0x2E, 0x37, 0x98, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0xFD, 0xFD, 
        0x1F, 0x1F, 0xFD, 0x1F, 0xFD, 0xFD, 0x1D, 0xDC, 0xDC, 0x1D, 0x1D, 0x1D, 0xFD, 0xFD, 0xFD, 0xFD, 0x66, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x04, 0x04, 
        0x04, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0xFE, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0xA3, 0xA3, 0xDF, 0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x8C, 0x8C, 0x02, 0x8C, 0x8C, 0x8C, 0x8C, 0x8C, 0x0A, 0x0A,
  0x30, 0x30, 0x99, 0xA1, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xB5, 0x4B, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x54, 0x54, 0xBE, 0xBE, 
        0x50, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x50, 0xBE, 0xBE, 0x54, 0x54, 0x3F, 0x3F, 0x3C, 0x3C, 0x3C, 0x4B, 0x3C, 0x3C, 0x4B, 0xEA, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3F, 0xB6, 0xB6, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 
        0x5C, 0xEB, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 
        0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x96, 0x94, 0x94, 0x94, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x94, 0x94, 0x94, 0x96, 0x96, 0xD2, 0x41, 0x4E, 0x4E, 0x4E, 0x34, 0x34, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 
        0x26, 0x26, 0x79, 0x79, 0x26, 0x26, 0x79, 0x79, 0x19, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x12, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x77, 0x77, 
        0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x78, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x0F, 0xF1, 0x77, 0x13, 0x86, 0x17, 0x1B, 
        0x1B, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x37, 0x37, 0x37, 0x2E, 0x3D, 0x3D, 0x3D, 0xFE, 0xFE, 0x3D, 0x04, 0x04, 0x2E, 0x2E, 0x3D, 0x3D, 0xFE, 0xFE, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x2E, 0x98, 0x98, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x98, 0x98, 0x37, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x05, 0x05, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0x89, 0x89, 0x23, 0x23, 0xDF, 0xDF,
  0x35, 0x35, 0x67, 0x67, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x99, 0x99, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 
        0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0xA2, 0x48, 0x33, 0x33, 0x33, 0xF6, 0x33, 0x33, 0x33, 0x33, 0x33, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x56, 0x4B, 0xB5, 0x4B, 0xEA, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0xB6, 0xBE, 0x50, 
        0x2D, 0x2D, 0x2D, 0xEB, 0xC5, 0xC5, 0x1C, 0x1C, 0xBF, 0xBF, 0xBF, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0xC1, 0xC1, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x27, 
        0x27, 0x27, 0x96, 0x2C, 0x4E, 0x2B, 0xE4, 0x36, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 
        0x14, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x26, 0x79, 
        0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 
        0x37, 0x37, 0x84, 0x84, 0x98, 0x98, 0x84, 0x2E, 0x2E, 0x2E, 0x98, 0x98, 0x2E, 0x2E, 0x37, 0x98, 0x98, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1F, 
        0x1F, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x9D, 0x9D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x37, 0x98, 0x2E, 0xFE, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 
        0x55, 0x89, 0x89, 0xA3, 0xA3, 0xA3, 0x04, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x05, 0x05, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 
        0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x45, 0x45, 0x46, 0xC3, 0xC3, 0x35, 0x35, 0x35, 0x67, 0x4A, 0x4A, 0x4A, 0x32, 0xB4, 0x53, 0x53, 0x30, 0x99, 0x4F, 0x2A, 0x2A, 0xA5, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 0x33, 0x33, 0x33, 
        0x33, 0x33, 0xB5, 0xB5, 0x33, 0xB5, 0xB5, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0xE0, 0x3C, 0x3C, 0x3C, 0x3F, 0x54, 0x50, 0xBE, 0x50, 0x2D, 0x2D, 0x5C, 0xB7, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x6A, 0xBF, 0xB8, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
        0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x27, 0x27, 0x2C, 
        0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0x36, 0x36, 0x36, 0xEC, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 
        0x14, 0x14, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x21, 0x90, 0x21, 0x21, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 
        0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x12, 0x0F, 0x0F, 0x77, 0x13, 0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9C, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x1D, 
        0x9D, 0x9D, 0x1D, 0x1B, 0x17, 0x17, 0x86, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x77, 0x13, 0x13, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x9D, 0x1D, 0x1D, 0x66, 0x1F, 0xFD, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x37, 0x84, 0x84, 0x05, 0x84, 0x84, 0x05, 0x84, 0x05, 0x37, 0x37, 0x05, 0x37, 0x37, 0x05, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 
        0x1D, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x84, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x55, 0x89, 0x89, 0x89, 0x23, 
        0x23, 0x5F, 0x5F, 0xA3, 0x89, 0xA3, 0xA3, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x2E, 0x84, 0x2E, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1B, 0x73, 0x17, 0x17, 
        0xAE, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C,
  0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x81, 0xB4, 0x53, 0x53, 0x30, 0x30, 0x99, 0x4F, 0x2A, 0x7A, 0x7A, 0x4D, 0x4D, 0x6E, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x56, 0x56, 0x56, 0x56, 0x56, 
        0x56, 0x4B, 0x4B, 0x56, 0x56, 0x56, 0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xF5, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x4B, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0xB6, 0xB6, 0x50, 
        0x50, 0x2D, 0x2D, 0x2D, 0x57, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x0D, 0x0D, 0x0D, 0x88, 0xCF, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 
        0x07, 0x07, 0x94, 0x27, 0x96, 0x2C, 0x4E, 0x4E, 0xE4, 0x2B, 0x2B, 0xAC, 0x34, 0x34, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x26, 0x28, 0x28, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x14, 0x78, 
        0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x12, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 
        0xDC, 0x9D, 0x1D, 0x1D, 0x1F, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x98, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1D, 0x9D, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0xAE, 0x17, 0xAE, 0xAE, 0x1B, 0x1B, 0x1B, 0x31, 0x9D, 0x9D, 0x9D, 0x9D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x2E, 0x2E, 
        0x84, 0x2E, 0x2E, 0x84, 0x98, 0x98, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x2E,
  0xA4, 0xA4, 0x4A, 0x32, 0x32, 0xB4, 0xB4, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x2A, 0xA5, 0xA5, 0x4D, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x48, 0x33, 0x33, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x56, 0x56, 0x56, 0x56, 0x56, 0x4B, 0xB5, 0x56, 
        0x56, 0x33, 0x33, 0x33, 0x33, 0x33, 0x48, 0x48, 0xA2, 0xA2, 0xA2, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0xA2, 0x48, 0xF5, 0xF5, 0x33, 0x56, 
        0x56, 0x4B, 0x4B, 0xEA, 0xEA, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0x50, 0xBE, 0xBE, 0x2D, 0x2D, 0x5C, 0xEB, 0xEB, 0xB7, 0x1C, 0x1C, 0xBF, 0xBF, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 
        0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0x08, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x27, 0x27, 0xD2, 0xD1, 0x2C, 0x4E, 0x2B, 0x36, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x36, 0x2B, 0xAB, 0xAB, 0xAB, 0x2C, 0x2C, 
        0x4E, 0x4E, 0x4E, 0x4E, 0x2C, 0x4E, 0xAB, 0x36, 0x36, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x10, 0x25, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x1E, 0x1E, 0x80, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x0F, 0x77, 0x77, 0x86, 
        0x86, 0x86, 0x17, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x1B, 0x1D, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 
        0x13, 0x86, 0x86, 0x86, 0x13, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x13, 0x13, 0x77, 0x77, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x9B, 
        0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1D, 0x1D, 0x66, 0x66, 0x1F, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x9C, 0x1D, 0x1D, 0x66, 0x66, 0x1F, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x9D, 0x9D, 
        0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1B, 0x9D, 0x1B, 0x1B, 0x31, 0x9D, 0x9D, 0x1B, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x2E, 0xFE, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0xA3, 0x55, 0x55, 0x55, 0x55, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xFE, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x1F, 0x9C, 0x9C, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
  0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0xA4, 0x4A, 0x4A, 0x67, 0x67, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x81, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 0xA5, 0x4D, 0x2F, 0x6E, 0x6E, 0x6E, 0x48, 0xF6, 0x56, 0x4B, 0x4B, 0x3C, 0x3F, 0x54, 0x50, 0x2D, 0xB7, 0x57, 0x1C, 0xB8, 0x0D, 0x0D, 0x93, 0xCF, 0x0E, 0x0E, 0x0E, 0x9F, 0x8F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xD8, 
        0xD8, 0x9F, 0x0E, 0x0E, 0x0E, 0x0E, 0xC0, 0x0D, 0x0D, 0x0D, 0xA6, 0xBF, 0x1C, 0x1C, 0x1C, 0xC5, 0xC5, 0xEB, 0xB7, 0x2D, 0x2D, 0x2D, 0x2D, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xB1, 0xB1, 
        0x0E, 0x0E, 0x0E, 0xC6, 0xC6, 0x0E, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xE2, 0xCB, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 
        0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x96, 0x27, 0x96, 0x96, 0xC2, 0x4E, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 
        0x34, 0x38, 0x38, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 
        0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0xFC, 0xFC, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 
        0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x9D, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x1D, 0xDC, 0x9D, 0xDC, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x37, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x2E, 0x2E, 0x04, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x04, 0x2E, 0x2E, 0x3D, 0xFE, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84,
  0x43, 0x43, 0xC3, 0xC3, 0xC3, 0xC3, 0x43, 0x43, 0x43, 0x45, 0x43, 0xC3, 0xC3, 0xC3, 0x43, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x67, 0xA4, 0xA4, 0x32, 0x32, 0x32, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x4F, 
        0x4F, 0x2A, 0x2A, 0xA5, 0x4D, 0x2F, 0x2F, 0xA2, 0x48, 0x33, 0x33, 0x4B, 0x4B, 0x3C, 0x3C, 0x3F, 0x3F, 0x54, 0x54, 0x50, 0x50, 0x50, 0x50, 0x2D, 0x2D, 0x5C, 0x57, 0x57, 0x57, 0x5C, 0xB7, 0xB7, 0x5C, 0xB7, 0xB7, 0xB7, 0x5C, 0x2D, 0x5C, 0xB7, 0x2D, 
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xEB, 0xEB, 0xEB, 0xEB, 0xEB, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x6A, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 
        0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 
        0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x27, 0x27, 0x96, 0x96, 0xAA, 0x36, 0x36, 0xBC, 0x38, 0x38, 0x10, 0x25, 0x25, 0x26, 0x29, 0x29, 0x87, 0x26, 0x28, 0x28, 0x28, 0x79, 0x79, 0x79, 0x79, 
        0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x26, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0xAE, 0xAE, 0x17, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 
        0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x37, 0x98, 0x2E, 0x2E, 0x3D, 0x3D, 0x3D, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3D, 0x2E, 0x98, 0x84, 0x84, 0x37, 0x05, 0x05, 0x05, 0x9C, 0x1D, 
        0x9D, 0x9D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x86, 0x17, 0x1B, 0x17, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x1F, 0x9C, 0x1F, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xA3, 0xA3, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
  0x53, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0x2A, 0xA5, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 
        0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x7A, 0xA5, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0x6E, 0xA2, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x48, 0x48, 0x33, 0x33, 0x33, 0x56, 0x4B, 
        0x3C, 0xE0, 0x3F, 0x54, 0x54, 0xBE, 0x2D, 0x5C, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x7E, 0x7E, 0x1C, 0xBF, 0x7E, 0x1C, 0x1C, 0xBF, 0xBF, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xC5, 0x1C, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0x0D, 0x0D, 0x0D, 
        0xB1, 0x0E, 0x0E, 0xCB, 0x0C, 0x0C, 0xB2, 0x0B, 0x0B, 0xB3, 0xB3, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0xC1, 0x07, 0xC1, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x65, 0xCC, 0xCC, 0x27, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0xF0, 0xF0, 0x29, 0x26, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 
        0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x14, 0x14, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x78, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 
        0x77, 0x77, 0x77, 0x1A, 0x13, 0x77, 0x1A, 0x13, 0x13, 0x1A, 0x1A, 0x11, 0xCE, 0xCE, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0xDE, 0xDE, 0x12, 0x15, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x91, 0x91, 
        0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x9B, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x77, 0x77, 0x13, 0x1A, 0x13, 0x86, 0x86, 
        0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1D, 0x9C, 0xFD, 0x9C, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xFD, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 
        0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x9D, 0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x05, 0x84, 0x84, 0x84, 0x2E, 
        0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x2E, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C,
  0x64, 0x64, 0x64, 0x3E, 0x64, 0x64, 0x3E, 0x39, 0x39, 0x39, 0x46, 0x46, 0x46, 0xC3, 0x43, 0x43, 0x35, 0x35, 0xA4, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0xB4, 0xB4, 0x53, 0x53, 0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0x4D, 
        0x4D, 0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0xB6, 0x50, 0x50, 0x50, 0x50, 0x2D, 0xB7, 0xB7, 0x57, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x6A, 0xB8, 0xB8, 0xB8, 0x0D, 0x0D, 0x88, 
        0x0D, 0x93, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 0x6B, 0x6B, 0x7E, 0x1C, 0x57, 0x57, 0xC5, 0xC5, 0x57, 0x57, 0xB7, 0xB7, 0xB7, 0x2D, 0xB7, 0xB7, 0xC5, 0xC5, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0xA6, 0x0D, 
        0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0xC1, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x94, 0x94, 0x27, 0x96, 0x96, 
        0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x96, 0x96, 0x96, 0x27, 0x27, 0x27, 0x94, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0xCC, 0x94, 0x27, 0x49, 0x27, 
        0x27, 0x41, 0x41, 0x41, 0x4E, 0x36, 0x36, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x79, 0x79, 0x79, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x80, 
        0x80, 0x1E, 0x1E, 0x1E, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x14, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0xCE, 0xCE, 0x77, 0x77, 0x13, 
        0x13, 0x13, 0x86, 0x17, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x66, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1B, 0x17, 0xAE, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0xAE, 0x17, 0xAE, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0xAE, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1D, 0x1D, 
        0x1D, 0x1D, 0x9D, 0x1D, 0x1F, 0x9C, 0x9C, 0xFD, 0xFD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0xFD, 0xFD, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x9C, 0x9C, 
        0xFD, 0x9C, 0x9C, 0x66, 0x66, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1F, 0x1D, 0x1D, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05,
  0x45, 0x43, 0x35, 0x35, 0x35, 0x67, 0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0xB4, 0xB4, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0x4D, 0x4D, 0x2F, 0x2F, 0xA2, 0xA2, 0x48, 0x48, 0x33, 0x33, 0x33, 
        0x33, 0xB5, 0xB5, 0x4B, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x3F, 0x54, 0x54, 0x54, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE0, 0xE0, 0xE0, 0x4B, 0x4B, 0x4B, 0x4B, 0x56, 0x56, 0x56, 0x33, 0xF6, 0x33, 0x56, 0x56, 0x56, 0x4B, 
        0x4B, 0xEA, 0xEA, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0xBE, 0xBE, 0xF7, 0xF7, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0xB7, 0x57, 0x57, 0x1C, 0x1C, 0x57, 0x57, 0x57, 0x57, 0x1C, 0x6A, 0x6A, 0x7E, 0x6A, 0xB8, 0x6A, 0x6A, 0xBF, 0xBF, 0xBF, 0xA6, 0x6B, 
        0xBF, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 0xCB, 0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0xB3, 0xB3, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x94, 0x94, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x07, 0x07, 
        0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xDA, 0xDA, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0xC1, 0x6D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x27, 0xD2, 0x41, 
        0x2C, 0x2C, 0xAB, 0x4E, 0x4E, 0xAB, 0x36, 0x36, 0x36, 0xAC, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 
        0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x17, 0x86, 0x17, 0x17, 0x86, 
        0x17, 0x17, 0x17, 0x1B, 0x1B, 0x73, 0x17, 0x17, 0x17, 0x73, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0xAE, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x17, 0x86, 0x86, 
        0x86, 0x17, 0x17, 0x17, 0x86, 0x86, 0xAE, 0x86, 0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x9C, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1F, 0x1F, 0x9D, 0x9D, 0x9D, 0x1B, 0x9D, 0x9D, 0x1B, 0x9D, 0x9D, 0x1B, 0x9D, 0x9D, 0x9D, 0x1B, 0x1B, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x2E, 0x3D, 0x98, 0x84, 0x2E, 0x84, 0x84, 0x84, 
        0x05, 0x37, 0x05, 0x05, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E,
  0x45, 0x45, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x67, 0x35, 0xA4, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0xB4, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0xA2, 0xA2, 0x33, 0x33, 0x33, 
        0xB5, 0xB5, 0xB5, 0x4B, 0x3C, 0x3C, 0x3F, 0x54, 0x3F, 0x54, 0xBE, 0x50, 0x50, 0x2D, 0x2D, 0x2D, 0x2D, 0xEB, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0x0E, 0x0E, 
        0xE2, 0xCB, 0x0C, 0x0C, 0x0C, 0xA8, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x94, 0x94, 0x94, 0x27, 0x96, 0x96, 0x96, 0x96, 0x2C, 0x2C, 0xAA, 0xAA, 0x2C, 
        0xAA, 0x2C, 0xAA, 0xAA, 0xAB, 0x2B, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xBC, 0xBC, 0xBC, 0x3A, 0x3A, 0x3A, 0x3A, 0x3A, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x38, 0x38, 0x34, 0x34, 0x34, 0x2B, 0x2B, 0x2B, 0x2B, 
        0x4E, 0x41, 0xD2, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xCC, 0xCC, 0xCC, 0x49, 0x49, 0x49, 0x49, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x26, 0x26, 0x79, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x90, 0x90, 0x80, 0x80, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 
        0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0xAE, 0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 
        0x13, 0x86, 0x86, 0x17, 0x17, 0x86, 0xAE, 0xAE, 0xAE, 0x86, 0x17, 0x17, 0x17, 0xAE, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x11, 0xCE, 
        0x77, 0x77, 0x77, 0x13, 0x1A, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x17, 0x17, 0xAE, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 
        0xFD, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x98, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0xFE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2E, 0x2E, 0x04, 0x2E, 0x3D, 0x2E, 0x2E, 0x04, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x9C, 
        0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x3B, 0x3B, 0x3B, 0xD7, 0xD7, 0x3E, 0x3E, 0x39, 0x46, 0x46, 0x45, 0x43, 0x43, 0x35, 0x67, 0x67, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x81, 0x81, 0xB4, 0x53, 0x53, 0x53, 0x30, 0x30, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0x53, 0x53, 
        0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0xA1, 0x2A, 0x2A, 0x2A, 0x7A, 0x7A, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x3C, 0x3F, 0x3F, 0x54, 0xBE, 0x2D, 0x2D, 0x57, 0xC5, 
        0x1C, 0x6A, 0x6A, 0xBF, 0x0D, 0x0D, 0x88, 0x93, 0x93, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 0xB1, 0xB1, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x93, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 
        0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xE2, 0xE2, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 
        0xBB, 0xBB, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x07, 0x07, 0x07, 0xCC, 0x27, 0x27, 0x27, 0x27, 0x27, 0x41, 0x41, 0x2B, 
        0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x10, 0xAD, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x25, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
        0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 
        0x78, 0x12, 0x12, 0x12, 0x91, 0x12, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x05, 0x9C, 
        0x9C, 0xFD, 0x66, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x1F, 0x1D, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x0F, 
        0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x86, 0x17, 0x17, 0xAE, 0x73, 0x1B, 0x1B, 0x1B, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x9C, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0xFD, 0x05, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1B, 0x1B, 0x9D, 0x31, 0x73, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1D, 0x9D, 0x9D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x1F, 0x9C, 
        0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x45, 0x45, 0x46, 0xC3, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x67, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x81, 0x81, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x4D, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x48, 0x48, 0x48, 0x48, 0x33, 0x33, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x56, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3C, 0x4B, 0x3C, 0x3C, 0x4B, 0xEA, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 
        0x4B, 0x4B, 0xB5, 0x4B, 0x4B, 0x4B, 0x4B, 0xB5, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0x4B, 0xE0, 0xE0, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0xBE, 0xBE, 0x50, 0x2D, 0x5C, 0xC5, 0x1C, 0x1C, 0x6A, 0x6A, 0xA6, 0xA6, 0x0D, 0x0D, 0xC0, 
        0xC0, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0xB1, 0x0E, 0x0E, 0x0E, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xB2, 0xA8, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0x08, 0xBB, 
        0xBB, 0xC1, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x94, 0x49, 0x27, 0x49, 0x94, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0x27, 0x27, 0x27, 0x49, 0x27, 0x49, 0x49, 
        0x27, 0x27, 0x49, 0x27, 0x94, 0xCC, 0xCC, 0xCC, 0xCC, 0x65, 0x07, 0x94, 0x49, 0xCC, 0x27, 0xD2, 0xD2, 0x41, 0x41, 0x41, 0x2C, 0x2C, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x34, 0x38, 0x10, 0x10, 0x10, 0x10, 0x25, 0x25, 0x25, 0x25, 
        0x25, 0x25, 0x29, 0x29, 0x29, 0x29, 0x29, 0x79, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x19, 0x19, 0x24, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 
        0x90, 0x1E, 0x1E, 0x90, 0x1E, 0x1E, 0x80, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 
        0x77, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x86, 0x86, 0x86, 
        0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1D, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0xFD, 0xFD, 0x05, 0x9C, 0x05, 0x05, 
        0x05, 0x9C, 0x9C, 0x05, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x84, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x04, 0x2E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x2E, 0x04, 0x04, 0x84, 0x84, 0x2E, 0x2E, 0x2E, 0x84, 0x84, 0x84, 0x84, 0x84, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C,
  0xA4, 0x4A, 0x4A, 0x32, 0x32, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0xB4, 0x32, 0xB4, 0xB4, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 
        0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x81, 0x32, 0xB4, 0xB4, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x2A, 0x2A, 0x2A, 0x4D, 0x4D, 0x2F, 0x2F, 
        0x48, 0x33, 0x33, 0x4B, 0x3C, 0x3C, 0x3F, 0x54, 0x50, 0x2D, 0x2D, 0xB7, 0x57, 0x1C, 0x1C, 0x1C, 0x6A, 0x6A, 0xB8, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x88, 0x88, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0xC0, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 
        0x0E, 0xE2, 0xCB, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 
        0x08, 0x08, 0xA0, 0x08, 0xA0, 0x08, 0xA0, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 
        0xC1, 0x07, 0x07, 0x07, 0x94, 0x94, 0x27, 0x96, 0x41, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0xE4, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x10, 0x10, 0x10, 0x25, 0x25, 0x29, 0x26, 0x26, 0x79, 0x79, 0x24, 0x21, 0x21, 0x21, 0x90, 
        0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 
        0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x79, 0x79, 0x79, 0x79, 0x26, 0x26, 0x28, 0x79, 0x19, 0x79, 0x79, 0x19, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x13, 0x42, 0x17, 0x73, 0x1B, 0x73, 0x1D, 
        0x1B, 0x9D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x84, 0x84, 0x84, 0x05, 0x37, 0x37, 0x37, 0x84, 0x84, 0x84, 0x37, 0x84, 0x84, 0x37, 0x37, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x1F, 0x9D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x86, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x1B, 0x1B, 0x9D, 0x1D, 0x1D, 0x9D, 0x1F, 0x1F, 0x9C, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C,
  0x64, 0x64, 0x39, 0x39, 0x46, 0x46, 0x46, 0x46, 0x43, 0x35, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x4A, 0x4A, 0x32, 0x32, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0x53, 0x30, 0x30, 0x30, 
        0x30, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x2F, 0x2F, 0x2F, 0xA2, 0x48, 0x48, 0xF5, 0xF5, 0x33, 0x33, 0x56, 0xB5, 0xEA, 0x4B, 0x4B, 0xEA, 0x3C, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3C, 0x54, 0x54, 0x3F, 0x3F, 0x3F, 0x3F, 
        0x3F, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0xBE, 0xBE, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D, 0x5C, 0x5C, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x7E, 0x7E, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x0D, 
        0xC0, 0x88, 0x88, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xE2, 0xCB, 0xCB, 0x0C, 0xB2, 0xB2, 0x0B, 0x0B, 0x0B, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xC1, 0xC1, 0xC1, 0xC1, 
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0xA0, 0xA0, 0xA0, 0xA0, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0xBB, 0xBB, 0xC1, 0x07, 
        0x07, 0xCC, 0x94, 0x27, 0x27, 0x27, 0xD2, 0x41, 0x2C, 0x41, 0x2C, 0x41, 0x4E, 0x2C, 0x2C, 0x2C, 0x2C, 0x2C, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0xAB, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 
        0x10, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 0x26, 0x26, 0x26, 0x79, 0x79, 0x79, 0x79, 0x19, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 
        0x19, 0x19, 0x24, 0x24, 0x24, 0x21, 0x21, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x78, 0x78, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x77, 0x13, 0x1A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 
        0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x13, 0x13, 0x13, 0x86, 0x86, 0xAE, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x9D, 0x1F, 0x1F, 0x9C, 0x9C, 
        0x1F, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1F, 0x1F, 0x1D, 
        0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x13, 0x86, 0x13, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x9D, 0x9D, 0x1B, 0x1D, 0x1B, 0x1D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x86, 0x86, 0x13, 0x13,
  0x64, 0x64, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x46, 0x45, 0x45, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0x32, 0x32, 0x32, 0x32, 0xB4, 0x53, 0x30, 0x30, 0x30, 0x30, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0xA5, 
        0xA5, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0xA2, 0x48, 0x48, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x3C, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0xBE, 0xBE, 
        0xBE, 0xBE, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0xBE, 0x2D, 0x2D, 0x5C, 0x2D, 0x5C, 0x5C, 0xC5, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0x1C, 0xBF, 0x6A, 0xBF, 0xA6, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xA6, 
        0x0D, 0x0D, 0xB8, 0xB8, 0x6A, 0xBF, 0xBF, 0x6A, 0x6A, 0x1C, 0x6A, 0xBF, 0xBF, 0xBF, 0xA6, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xB1, 0x0E, 0x0E, 0x0E, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0xA8, 0x0B, 0x0B, 0xB3, 0xA0, 0x08, 0x08, 0xBB, 0xC1, 0x07, 
        0x07, 0x07, 0x94, 0x27, 0x27, 0x96, 0x96, 0x96, 0x96, 0x2C, 0x96, 0x96, 0x2C, 0x96, 0x96, 0x96, 0x96, 0x96, 0x27, 0x27, 0x94, 0x94, 0x94, 0x07, 0x07, 0x07, 0x07, 0xC1, 0xC1, 0xBB, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xBB, 
        0xBB, 0x6D, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0x65, 0x49, 0x49, 0x27, 0x27, 0xD2, 0xD2, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x34, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x29, 
        0x26, 0x79, 0x79, 0x19, 0x19, 0x19, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x90, 0x90, 0x1E, 0x90, 0x90, 0x1E, 0x1E, 0x1E, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x0F, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x0F, 
        0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x12, 0x78, 0x14, 0x14, 0x8E, 0x8E, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x14, 0x14, 0x14, 0x78, 0x95, 0x95, 0x78, 0x12, 0x12, 0x12, 0x91, 0x0F, 0x91, 0x91, 0x0F, 0x11, 0x77, 0x77, 
        0x0F, 0x11, 0x0F, 0x11, 0x0F, 0x0F, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 
        0x1B, 0x1D, 0x1D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x9D, 0x9D, 0x1D, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x86, 
        0x13, 0x86, 0x13, 0x86, 0x86, 0x9B, 0x86, 0x86, 0x86, 0x86, 0xAE, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
  0x47, 0x47, 0x47, 0x76, 0x76, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x64, 0x64, 0x64, 0x64, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x46, 0x46, 0xC3, 0x43, 0x43, 0x35, 0xA4, 0xA4, 0x4A, 0x32, 0xB4, 0x53, 0x30, 0x30, 0x4F, 0x2A, 0xA5, 0x4D, 0x2F, 0x2F, 0xA2, 
        0x48, 0x33, 0x33, 0xB5, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0xE0, 0x3C, 0x3C, 0xE0, 0x3C, 0x3C, 0x4B, 0x4B, 0x56, 0x33, 0x33, 0x33, 0x48, 0x6E, 0x2F, 0x2F, 0x4D, 0xA5, 0x2A, 0x2A, 0x2A, 0x2A, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 
        0x30, 0x30, 0x99, 0x4F, 0x2A, 0x2A, 0x7A, 0xA5, 0x4D, 0x2F, 0x6E, 0x48, 0x48, 0x33, 0x56, 0x4B, 0x3C, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0xBE, 0xF7, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE0, 0x3C, 0x3C, 
        0x3C, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0xB6, 0xB6, 0x50, 0xBE, 0x2D, 0x2D, 0x2D, 0xEB, 0xC5, 0xC5, 0x1C, 0x1C, 0x1C, 0xBF, 0xBF, 0xA6, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xB1, 0x0E, 0x0E, 0xE2, 0xCB, 0x0C, 
        0x0C, 0x0C, 0xB2, 0xA8, 0x0B, 0xB3, 0xB3, 0xA0, 0x08, 0xBB, 0xBB, 0xBB, 0x07, 0x07, 0x07, 0x94, 0x94, 0x94, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x49, 0x49, 0x27, 0x27, 0x27, 0x27, 
        0x27, 0x27, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x27, 0x27, 0x27, 0x49, 0x49, 0x49, 0x49, 0x49, 0x27, 0xD2, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0x2B, 0x4E, 0x2B, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x10, 
        0x25, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x19, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x21, 0x90, 0x90, 0x90, 0x1E, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x12, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 
        0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 
        0x77, 0x77, 0x77, 0x77, 0x0F, 0x0F, 0x91, 0x91, 0x91, 0x12, 0x91, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x95, 0x95, 0x78, 
        0x78, 0x12, 0x78, 0x12, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x1A, 0x13, 0x13, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x13, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0xAE, 
        0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x9D, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1F, 0x9C, 0x9C, 0x9C, 0x05, 0x1F, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x9C, 0x9C, 0x05, 
        0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77,
  0xBD, 0x76, 0x40, 0x40, 0x40, 0x40, 0x3B, 0x3B, 0x3B, 0x3B, 0x64, 0x64, 0x3E, 0x3E, 0x39, 0x39, 0xB0, 0xB0, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0xA4, 0x4A, 0xA4, 0x4A, 0xA4, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 0x4A, 
        0x4A, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0xB4, 0xB4, 0xB4, 0xB4, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x99, 0xA1, 0xA1, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x30, 0x30, 0x30, 0x30, 0x30, 0x53, 0x53, 0x53, 0xB4, 0xB4, 0xB4, 0x53, 0x53, 0x53, 0x30, 
        0x30, 0x30, 0x30, 0x99, 0x4F, 0x4F, 0x2A, 0x2A, 0xA5, 0xA5, 0x2F, 0x6E, 0x6E, 0x48, 0x48, 0x33, 0x33, 0x33, 0x56, 0x56, 0x56, 0x4B, 0x4B, 0x3C, 0x3C, 0x3C, 0x3F, 0x3F, 0x54, 0x54, 0x50, 0x50, 0x2D, 0x2D, 0x57, 0xC5, 0x57, 0x1C, 0x1C, 0x6A, 0xB8, 
        0x0D, 0x0D, 0x93, 0xB1, 0x0E, 0x0E, 0xE2, 0x9F, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0xA8, 0xB2, 0xB2, 0xB2, 0xB2, 0xB2, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xA8, 0xA8, 
        0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xA8, 0xB2, 0xA8, 0xA8, 0xA8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0x7B, 0x08, 0x08, 0x08, 
        0xDD, 0xDD, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0x49, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0x41, 0xD1, 0x2C, 0x2C, 0x2C, 0x2C, 0xAA, 0xAA, 0xAA, 0xAA, 0x36, 0x2B, 0x2B, 0x2B, 0xAC, 0x34, 0xBC, 0x34, 0x38, 0x34, 0x38, 0x10, 0x38, 0x10, 0x10, 0x10, 
        0x25, 0x25, 0x29, 0x29, 0x26, 0x26, 0x26, 0x19, 0x19, 0x24, 0x24, 0x21, 0x90, 0x90, 0x1E, 0x1E, 0x80, 0x80, 0x80, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x78, 0x12, 0x12, 0x78, 0x78, 0x78, 0x78, 0x14, 0x78, 0x78, 0x14, 0x14, 
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x14, 0x14, 0x14, 0x14, 0x80, 0x80, 0x80, 0x80, 0x1E, 0x1E, 0x90, 0x90, 0x90, 0x90, 0x90, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x90, 0x21, 0x90, 0x90, 
        0x90, 0x1E, 0x1E, 0x1E, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x91, 0x91, 0xDE, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x77, 0x13, 0x13, 0x13, 
        0xAE, 0x17, 0x17, 0x1B, 0x1B, 0x1D, 0x1F, 0x9D, 0x9D, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x05, 0x05, 0x05, 0x05, 0x1F, 0x1F, 0x1D, 0x9D, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x17, 0x86, 0x86, 0x86, 0x86, 0x13, 0x13, 0x1A, 0x1A, 
        0x13, 0x13, 0x77, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0F, 0x11, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x11, 0x11, 0x11, 0x77, 0x77, 0x77, 0x13, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x1B, 0x1B, 
        0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x86, 0x17, 0x17, 0x17, 0x17,
  0x39, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x39, 0x3E, 0x3E, 0x3E, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0xB0, 0x45, 0x45, 0x45, 0x43, 0x43, 0x35, 0x35, 0x35, 0xA4, 0xA4, 0x4A, 0x4A, 0x4A, 0x32, 0x32, 0x32, 0x32, 0xB4, 0x53, 0x53, 0x53, 0x30, 
        0x30, 0x30, 0x99, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0x4D, 0x2F, 
        0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x6E, 0x2F, 0x2F, 0x2F, 0x2F, 0x4D, 0x4D, 0x4D, 0x4D, 0x2F, 0x2F, 0x2F, 0xA2, 0xA2, 0xA2, 0x48, 0x48, 0x33, 0xB5, 0x4B, 0xE0, 0x3F, 0x3F, 0x54, 0xBE, 0x2D, 
        0x2D, 0xEB, 0xC5, 0x1C, 0x1C, 0xBF, 0xA6, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x0D, 0xC0, 0xC0, 0xC0, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0xC0, 0xC0, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0xB1, 0x0E, 0x0E, 
        0xB1, 0x0E, 0x0E, 0x0E, 0x0E, 0xCB, 0xCB, 0xE2, 0xCB, 0xCB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xB2, 0xB2, 0xB2, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0xB3, 0xB3, 0xA0, 0xA0, 0xA0, 0x08, 0x08, 0x08, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 
        0x6D, 0xC1, 0xC1, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCC, 0xCC, 0xCC, 0xCC, 0x49, 0x27, 0x27, 0x27, 0xD2, 0xD2, 0xD2, 0x96, 0x96, 0x96, 0xD1, 0x41, 0x41, 0x41, 0x41, 0x41, 0x4E, 0xAB, 0xAB, 0x2B, 0x36, 0x36, 0x2B, 0x2B, 0x2B, 0x2B, 0x34, 0x34, 0x34, 
        0x38, 0x38, 0x38, 0x10, 0x25, 0x25, 0x25, 0x25, 0x29, 0x29, 0x26, 0x79, 0x79, 0x19, 0x19, 0x24, 0x21, 0x21, 0x21, 0x90, 0x1E, 0x1E, 0x1E, 0x80, 0x14, 0x80, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 
        0x91, 0x91, 0x91, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x91, 0x91, 0x12, 0x12, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x91, 0x12, 0x78, 0x12, 0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 
        0x78, 0x78, 0x78, 0x78, 0x78, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x18, 0x18, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x12, 0x12, 0x91, 0x91, 0x0F, 0x77, 0x77, 0x77, 0x77, 0x13, 
        0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x1B, 0x1B, 0x1B, 0x1B, 0x17, 0x17, 0x17, 0x86, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x77, 0x77, 0x77, 0x77, 0x77, 0x11, 0x77, 0x77, 0x77, 0x77, 
        0x77, 0x13, 0x13, 0x86, 0x86, 0x13, 0x86, 0x86, 0x86, 0x86, 0x86, 0x17, 0x17, 0x17, 0x17, 0x17, 0x1B, 0x1B, 0x1B, 0x9D, 0x9D, 0x1F, 0x1F, 0x1D, 0x1F, 0x1F, 0x9D, 0x1F, 0x1D, 0x1D, 0x1F, 0x1F, 0x1F, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1D, 0x1B, 0x1B, 
        0x1B, 0x17, 0x17, 0x17, 0x17, 0x86, 0x86, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x86, 0x13, 0x13, 0x13, 0x86, 0x86, 0x86,
  0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x43, 0x35, 0x35, 0x35, 0x35, 0x35, 0x67, 0xA4, 0x4A, 0x32, 0x32, 0x32, 0xB4, 
        0xB4, 0xB4, 0x53, 0x53, 0x53, 0x30, 0x30, 0x30, 0x30, 0x30, 0x99, 0x99, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x4F, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0x2A, 0xA5, 0xA5, 0xA5, 0x2F, 0x2F, 0x2F, 0x6E, 0x6E, 0x48, 0x33, 0x33, 0x33, 0x56, 0x4B, 0x4B, 0x4B, 
        0xE0, 0x3F, 0x3F, 0x3C, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x54, 0x54, 0x54, 0x54, 0xBE, 0xBE, 0x54, 0x50, 0xF7, 0x50, 0xBE, 0x2D, 0x2D, 0x2D, 0x2D, 0xB7, 0x57, 0xC5, 0x1C, 0x6A, 0x6A, 0x6B, 0x0D, 0x0D, 0x93, 0xB1, 0xB1, 0x0E, 0x0E, 0xE2, 0xE2, 
        0xCB, 0x0C, 0x0C, 0