/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : SKINNING_Notepad.c
Purpose     : Animated notepad using skinning and window effects
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stddef.h>
#include "DIALOG.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define COLOR_BACK0            0xFF3333
#define COLOR_BACK1            0x550000
#define COLOR_BORDER           0x444444
#define COLOR_KEYPAD0          0xAAAAAA
#define COLOR_KEYPAD1          0x555555
#define BUTTON_COLOR0          0xEEEEEE
#define BUTTON_COLOR1          0xCCCCCC
#define BUTTON_COLOR2          0xCCCCCC
#define BUTTON_COLOR3          0xAAAAAA
#define BUTTON_SKINFLEX_RADIUS 4
#define ID_BUTTON              (GUI_ID_USER + 0)
#define APP_INIT_LOWERCASE     (WM_USER + 0)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  int          xPos;
  int          yPos;
  int          xSize;
  int          ySize;
  const char * acLabel;
  void (* pfDraw)(WM_HWIN hWin);
} BUTTON_DATA;

typedef struct {
  int x;
  int y;
  int Delay;
} EVENT;

typedef struct {
  BUTTON_SKINFLEX_PROPS * pProp;
  int                     Index;
  BUTTON_SKINFLEX_PROPS   PropOld;
} BUTTON_PROP;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       GUI_Font20_AA4
*/
static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0020[  1] = { // Code 0020, SPACE
  0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0021[ 26] = { // Code 0021, EXCLAMATION MARK
  0x4B, 0x50,
  0xBF, 0xB0,
  0xBF, 0xB0,
  0xBF, 0xB0,
  0x9F, 0xA0,
  0x7F, 0x80,
  0x5F, 0x60,
  0x3F, 0x40,
  0x06, 0x10,
  0x27, 0x20,
  0xBF, 0xC0,
  0x7F, 0x90,
  0x01, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0022[ 18] = { // Code 0022, QUOTATION MARK
  0x1A, 0x60, 0xA7,
  0x4F, 0xC3, 0xFD,
  0x4F, 0xD4, 0xFD,
  0x4F, 0xD4, 0xFD,
  0x2F, 0xA2, 0xEB,
  0x01, 0x00, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0023[ 65] = { // Code 0023, NUMBER SIGN
  0x00, 0x03, 0x30, 0x24, 0x00,
  0x00, 0x0B, 0xD0, 0xBD, 0x00,
  0x00, 0x0E, 0xB0, 0xDC, 0x00,
  0x00, 0x2F, 0xA2, 0xFA, 0x10,
  0x09, 0xFF, 0xFF, 0xFF, 0xD0,
  0x03, 0xAF, 0x9A, 0xFA, 0x50,
  0x00, 0x7F, 0x36, 0xF3, 0x00,
  0x09, 0xCF, 0xAC, 0xFA, 0x30,
  0x1D, 0xFF, 0xDF, 0xFD, 0x50,
  0x00, 0xDB, 0x0C, 0xC0, 0x00,
  0x00, 0xF9, 0x0F, 0xA0, 0x00,
  0x02, 0xF7, 0x1F, 0x70, 0x00,
  0x00, 0x30, 0x02, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0024[ 75] = { // Code 0024, DOLLAR SIGN
  0x00, 0x00, 0x21, 0x00, 0x00,
  0x00, 0x04, 0xA9, 0x30, 0x00,
  0x03, 0xDF, 0xFF, 0xFD, 0x40,
  0x1E, 0xF8, 0x98, 0x9F, 0xF2,
  0x5F, 0xA0, 0x76, 0x09, 0xE2,
  0x5F, 0xE3, 0x76, 0x00, 0x00,
  0x0D, 0xFF, 0xEC, 0x61, 0x00,
  0x01, 0x9F, 0xFF, 0xFF, 0x60,
  0x00, 0x00, 0x9A, 0xBF, 0xF2,
  0x4B, 0x30, 0x76, 0x0B, 0xF6,
  0x9F, 0xA0, 0x76, 0x0B, 0xF5,
  0x3F, 0xFA, 0xBA, 0xBF, 0xD1,
  0x04, 0xCF, 0xFF, 0xFB, 0x20,
  0x00, 0x01, 0x97, 0x10, 0x00,
  0x00, 0x00, 0x53, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0025[ 91] = { // Code 0025, PERCENT SIGN
  0x01, 0x55, 0x10, 0x00, 0x07, 0x60, 0x00,
  0x2E, 0xEF, 0xD1, 0x00, 0x2F, 0x50, 0x00,
  0x9F, 0x34, 0xF7, 0x00, 0x9C, 0x00, 0x00,
  0xBF, 0x02, 0xF9, 0x02, 0xF4, 0x00, 0x00,
  0xAF, 0x13, 0xF9, 0x0A, 0xB0, 0x00, 0x00,
  0x5F, 0xBB, 0xF3, 0x3F, 0x30, 0x00, 0x00,
  0x05, 0xBA, 0x50, 0xBA, 0x07, 0xDD, 0x80,
  0x00, 0x00, 0x04, 0xF2, 0x5F, 0xA9, 0xF6,
  0x00, 0x00, 0x0C, 0x90, 0x9F, 0x21, 0xFA,
  0x00, 0x00, 0x5F, 0x10, 0x9F, 0x20, 0xFB,
  0x00, 0x00, 0xD8, 0x00, 0x7F, 0x65, 0xF8,
  0x00, 0x06, 0xE1, 0x00, 0x1C, 0xFF, 0xC1,
  0x00, 0x04, 0x50, 0x00, 0x00, 0x33, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0026[ 78] = { // Code 0026, AMPERSAND
  0x00, 0x03, 0x89, 0x71, 0x00, 0x00,
  0x00, 0x4F, 0xFF, 0xFE, 0x20, 0x00,
  0x00, 0xCF, 0x70, 0x9F, 0x80, 0x00,
  0x00, 0xDF, 0x50, 0x7F, 0x90, 0x00,
  0x00, 0x8F, 0xE7, 0xEF, 0x40, 0x00,
  0x00, 0x2F, 0xFF, 0xF6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xE2, 0x1A, 0x50,
  0x0E, 0xFB, 0x2D, 0xFC, 0x9F, 0xA0,
  0x3F, 0xF1, 0x02, 0xEF, 0xFF, 0x30,
  0x3F, 0xF3, 0x00, 0x9F, 0xFB, 0x00,
  0x0D, 0xFE, 0x9C, 0xFF, 0xFF, 0x70,
  0x03, 0xCF, 0xFF, 0xC4, 0x6F, 0x90,
  0x00, 0x02, 0x31, 0x00, 0x01, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0027[ 12] = { // Code 0027, APOSTROPHE
  0x3B, 0x30,
  0x7F, 0x90,
  0x7F, 0x90,
  0x7F, 0x90,
  0x6F, 0x70,
  0x01, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0028[ 32] = { // Code 0028, LEFT PARENTHESIS
  0x00, 0x97,
  0x05, 0xFA,
  0x0B, 0xF5,
  0x2F, 0xE0,
  0x7F, 0xB0,
  0xAF, 0x80,
  0xDF, 0x60,
  0xDF, 0x60,
  0xDF, 0x60,
  0xCF, 0x70,
  0x8F, 0x90,
  0x4F, 0xD0,
  0x0E, 0xF2,
  0x07, 0xF7,
  0x01, 0xEB,
  0x00, 0x21
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0029[ 48] = { // Code 0029, RIGHT PARENTHESIS
  0x3B, 0x20, 0x00,
  0x4F, 0x90, 0x00,
  0x0E, 0xF1, 0x00,
  0x0A, 0xF7, 0x00,
  0x06, 0xFB, 0x00,
  0x03, 0xFF, 0x00,
  0x00, 0xFF, 0x30,
  0x00, 0xFF, 0x40,
  0x00, 0xFF, 0x30,
  0x02, 0xFF, 0x10,
  0x04, 0xFD, 0x00,
  0x08, 0xF9, 0x00,
  0x0C, 0xF4, 0x00,
  0x3F, 0xC0, 0x00,
  0x5F, 0x40, 0x00,
  0x03, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002A[ 24] = { // Code 002A, ASTERISK
  0x00, 0x0A, 0x30, 0x00,
  0x01, 0x0F, 0x60, 0x00,
  0x3F, 0xBF, 0xCE, 0xA0,
  0x04, 0xBF, 0xE6, 0x10,
  0x01, 0xDC, 0xF6, 0x00,
  0x06, 0xD1, 0x8C, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002B[ 50] = { // Code 002B, PLUS SIGN
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xE9, 0x00, 0x00,
  0x00, 0x02, 0xFB, 0x00, 0x00,
  0x00, 0x02, 0xFB, 0x00, 0x00,
  0x37, 0x78, 0xFD, 0x77, 0x70,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x27, 0x78, 0xFD, 0x77, 0x60,
  0x00, 0x02, 0xFB, 0x00, 0x00,
  0x00, 0x02, 0xFB, 0x00, 0x00,
  0x00, 0x01, 0xD8, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002C[ 12] = { // Code 002C, COMMA
  0x27, 0x20,
  0xCF, 0xC0,
  0x9F, 0xF0,
  0x05, 0xC0,
  0x8E, 0x40,
  0x41, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002D[  9] = { // Code 002D, HYPHEN-MINUS
  0x17, 0x77, 0x73,
  0x5F, 0xFF, 0xFD,
  0x19, 0xBB, 0xB5
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002E[  8] = { // Code 002E, FULL STOP
  0x27, 0x20,
  0xCF, 0xA0,
  0x9F, 0x70,
  0x01, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002F[ 39] = { // Code 002F, SOLIDUS
  0x00, 0x00, 0x97,
  0x00, 0x03, 0xFA,
  0x00, 0x08, 0xF4,
  0x00, 0x0E, 0xE0,
  0x00, 0x5F, 0x80,
  0x00, 0xAF, 0x20,
  0x01, 0xFC, 0x00,
  0x07, 0xF6, 0x00,
  0x0C, 0xF1, 0x00,
  0x3F, 0xA0, 0x00,
  0x9F, 0x40, 0x00,
  0xCD, 0x00, 0x00,
  0x22, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0030[ 65] = { // Code 0030, DIGIT ZERO
  0x00, 0x02, 0x55, 0x20, 0x00,
  0x00, 0x9F, 0xFF, 0xF7, 0x00,
  0x08, 0xFF, 0x9A, 0xFF, 0x40,
  0x0E, 0xF7, 0x00, 0xAF, 0xB0,
  0x3F, 0xF2, 0x00, 0x5F, 0xF0,
  0x6F, 0xF0, 0x00, 0x3F, 0xF2,
  0x6F, 0xF0, 0x00, 0x2F, 0xF2,
  0x5F, 0xF0, 0x00, 0x3F, 0xF2,
  0x2F, 0xF2, 0x00, 0x5F, 0xE0,
  0x0D, 0xF8, 0x00, 0xBF, 0xA0,
  0x05, 0xFF, 0xCD, 0xFF, 0x30,
  0x00, 0x7E, 0xFF, 0xE4, 0x00,
  0x00, 0x00, 0x33, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0031[ 52] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x25, 0x00,
  0x00, 0x00, 0xDF, 0x20,
  0x00, 0x2A, 0xFF, 0x20,
  0x1D, 0xFF, 0xFF, 0x20,
  0x1A, 0xBC, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x04, 0xFF, 0x20,
  0x00, 0x02, 0xFE, 0x10,
  0x00, 0x00, 0x22, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0032[ 60] = { // Code 0032, DIGIT TWO
  0x00, 0x03, 0x65, 0x20, 0x00,
  0x02, 0xCF, 0xFF, 0xF9, 0x00,
  0x1D, 0xFE, 0x8A, 0xFF, 0x80,
  0x5F, 0xF2, 0x00, 0xAF, 0xD0,
  0x4F, 0x90, 0x00, 0x8F, 0xD0,
  0x01, 0x00, 0x03, 0xEF, 0x90,
  0x00, 0x00, 0x7F, 0xFD, 0x10,
  0x00, 0x3C, 0xFF, 0x81, 0x00,
  0x04, 0xEF, 0xB2, 0x00, 0x00,
  0x2E, 0xF7, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xC0,
  0x4E, 0xFF, 0xFF, 0xFF, 0xC0
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0033[ 65] = { // Code 0033, DIGIT THREE
  0x00, 0x03, 0x65, 0x10, 0x00,
  0x04, 0xEF, 0xFF, 0xF6, 0x00,
  0x1E, 0xFC, 0x8C, 0xFF, 0x30,
  0x3F, 0xD1, 0x00, 0xEF, 0x60,
  0x05, 0x20, 0x01, 0xEF, 0x40,
  0x00, 0x03, 0xBE, 0xFA, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x20,
  0x00, 0x00, 0x14, 0xEF, 0x90,
  0x29, 0x30, 0x00, 0xAF, 0xB0,
  0x7F, 0xD1, 0x01, 0xDF, 0x90,
  0x3F, 0xFE, 0xBE, 0xFF, 0x30,
  0x04, 0xDF, 0xFF, 0xD4, 0x00,
  0x00, 0x02, 0x31, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0034[ 65] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x01, 0x61, 0x00,
  0x00, 0x00, 0x1D, 0xFA, 0x00,
  0x00, 0x00, 0xAF, 0xFB, 0x00,
  0x00, 0x07, 0xFE, 0xFB, 0x00,
  0x00, 0x4F, 0x99, 0xFB, 0x00,
  0x01, 0xEC, 0x19, 0xFB, 0x00,
  0x0B, 0xF3, 0x09, 0xFB, 0x00,
  0x8F, 0xB6, 0x6B, 0xFD, 0x51,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x27, 0x77, 0x7C, 0xFD, 0x71,
  0x00, 0x00, 0x09, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x30, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0035[ 65] = { // Code 0035, DIGIT FIVE
  0x00, 0x22, 0x22, 0x21, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0x20,
  0x0C, 0xFD, 0xDD, 0xDC, 0x10,
  0x0E, 0xF0, 0x00, 0x00, 0x00,
  0x2F, 0xC3, 0x66, 0x20, 0x00,
  0x4F, 0xEF, 0xFF, 0xF8, 0x00,
  0x4F, 0xE7, 0x6B, 0xFF, 0x50,
  0x01, 0x00, 0x00, 0xCF, 0xA0,
  0x02, 0x00, 0x00, 0xAF, 0xB0,
  0x5F, 0xA0, 0x01, 0xEF, 0x80,
  0x5F, 0xFC, 0xAE, 0xFE, 0x20,
  0x07, 0xEF, 0xFF, 0xB3, 0x00,
  0x00, 0x02, 0x31, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0036[ 65] = { // Code 0036, DIGIT SIX
  0x00, 0x01, 0x56, 0x40, 0x00,
  0x00, 0x7F, 0xFF, 0xFD, 0x20,
  0x06, 0xFE, 0x76, 0xEF, 0x90,
  0x0D, 0xF6, 0x00, 0x2B, 0x40,
  0x2F, 0xF1, 0x34, 0x30, 0x00,
  0x4F, 0xFB, 0xFF, 0xFC, 0x10,
  0x6F, 0xFE, 0x88, 0xEF, 0xB0,
  0x6F, 0xF4, 0x00, 0x5F, 0xF1,
  0x3F, 0xF2, 0x00, 0x3F, 0xF2,
  0x0E, 0xF6, 0x00, 0x7F, 0xF1,
  0x07, 0xFF, 0xAA, 0xFF, 0x80,
  0x00, 0x7E, 0xFF, 0xF8, 0x00,
  0x00, 0x00, 0x33, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0037[ 65] = { // Code 0037, DIGIT SEVEN
  0x12, 0x22, 0x22, 0x22, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x8D, 0xDD, 0xDD, 0xFF, 0x90,
  0x00, 0x00, 0x04, 0xFC, 0x10,
  0x00, 0x00, 0x2E, 0xE2, 0x00,
  0x00, 0x00, 0xAF, 0x70, 0x00,
  0x00, 0x03, 0xFE, 0x10, 0x00,
  0x00, 0x0B, 0xF9, 0x00, 0x00,
  0x00, 0x2F, 0xF3, 0x00, 0x00,
  0x00, 0x7F, 0xE0, 0x00, 0x00,
  0x00, 0xBF, 0xA0, 0x00, 0x00,
  0x00, 0xAF, 0x50, 0x00, 0x00,
  0x00, 0x13, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0038[ 65] = { // Code 0038, DIGIT EIGHT
  0x00, 0x03, 0x65, 0x20, 0x00,
  0x02, 0xCF, 0xFF, 0xFB, 0x10,
  0x0C, 0xFD, 0x67, 0xEF, 0x90,
  0x0F, 0xF4, 0x00, 0x7F, 0xD0,
  0x0E, 0xF5, 0x00, 0x8F, 0xB0,
  0x05, 0xEF, 0xBC, 0xFD, 0x20,
  0x07, 0xFF, 0xDE, 0xFE, 0x40,
  0x2F, 0xF6, 0x00, 0x9F, 0xE0,
  0x6F, 0xF0, 0x00, 0x3F, 0xF2,
  0x4F, 0xF3, 0x00, 0x6F, 0xF1,
  0x0C, 0xFE, 0xAB, 0xFF, 0xA0,
  0x01, 0xAF, 0xFF, 0xF9, 0x10,
  0x00, 0x01, 0x33, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0039[ 65] = { // Code 0039, DIGIT NINE
  0x00, 0x03, 0x65, 0x20, 0x00,
  0x02, 0xDF, 0xFF, 0xF8, 0x00,
  0x0D, 0xFD, 0x89, 0xFF, 0x60,
  0x4F, 0xF2, 0x00, 0x8F, 0xD0,
  0x6F, 0xF0, 0x00, 0x6F, 0xF1,
  0x4F, 0xF3, 0x00, 0x9F, 0xF2,
  0x0C, 0xFE, 0xAB, 0xFF, 0xF2,
  0x02, 0xBF, 0xFE, 0x8F, 0xF1,
  0x00, 0x01, 0x20, 0x4F, 0xE0,
  0x08, 0xC1, 0x00, 0xBF, 0x90,
  0x0B, 0xFD, 0x8B, 0xFE, 0x20,
  0x02, 0xCF, 0xFF, 0xC3, 0x00,
  0x00, 0x02, 0x31, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003A[ 20] = { // Code 003A, COLON
  0x15, 0x10,
  0xBF, 0xA0,
  0xAF, 0x90,
  0x03, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x27, 0x20,
  0xCF, 0xA0,
  0x9F, 0x70,
  0x01, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003B[ 24] = { // Code 003B, SEMICOLON
  0x15, 0x10,
  0xBF, 0xA0,
  0xAF, 0x90,
  0x03, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x27, 0x20,
  0xCF, 0xC0,
  0x9F, 0xF0,
  0x05, 0xC0,
  0x8E, 0x40,
  0x41, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003C[ 45] = { // Code 003C, LESS-THAN SIGN
  0x00, 0x00, 0x00, 0x17, 0x91,
  0x00, 0x00, 0x18, 0xEF, 0xF3,
  0x00, 0x29, 0xFF, 0xFA, 0x30,
  0x2A, 0xFF, 0xE8, 0x10, 0x00,
  0x9F, 0xFC, 0x10, 0x00, 0x00,
  0x2A, 0xFF, 0xE9, 0x20, 0x00,
  0x00, 0x28, 0xEF, 0xFA, 0x40,
  0x00, 0x00, 0x17, 0xEF, 0xF3,
  0x00, 0x00, 0x00, 0x06, 0x80
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003D[ 35] = { // Code 003D, EQUALS SIGN
  0x26, 0x66, 0x66, 0x66, 0x50,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x37, 0x77, 0x77, 0x77, 0x71,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x49, 0x99, 0x99, 0x99, 0x81,
  0xAF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x15, 0x66, 0x66, 0x66, 0x40
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003E[ 45] = { // Code 003E, GREATER-THAN SIGN
  0x49, 0x40, 0x00, 0x00, 0x00,
  0x8F, 0xFC, 0x50, 0x00, 0x00,
  0x06, 0xCF, 0xFD, 0x70, 0x00,
  0x00, 0x04, 0xAF, 0xFE, 0x70,
  0x00, 0x00, 0x05, 0xFF, 0xF3,
  0x00, 0x05, 0xBF, 0xFE, 0x60,
  0x07, 0xDF, 0xFC, 0x60, 0x00,
  0x8F, 0xFB, 0x40, 0x00, 0x00,
  0x39, 0x30, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_003F[ 65] = { // Code 003F, QUESTION MARK
  0x00, 0x49, 0xBA, 0x50, 0x00,
  0x08, 0xFF, 0xFF, 0xFB, 0x00,
  0x2F, 0xF7, 0x26, 0xFF, 0x50,
  0x3F, 0xB0, 0x00, 0xFF, 0x70,
  0x03, 0x00, 0x07, 0xFF, 0x30,
  0x00, 0x00, 0x8F, 0xF8, 0x00,
  0x00, 0x07, 0xFE, 0x50, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x02, 0x60, 0x00, 0x00,
  0x00, 0x03, 0x71, 0x00, 0x00,
  0x00, 0x0D, 0xF9, 0x00, 0x00,
  0x00, 0x0A, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0040[ 91] = { // Code 0040, COMMERCIAL AT
  0x00, 0x01, 0x6A, 0xBB, 0x83, 0x00, 0x00,
  0x00, 0x4D, 0xFC, 0x9B, 0xEF, 0x90, 0x00,
  0x03, 0xFD, 0x30, 0x00, 0x08, 0xF7, 0x00,
  0x0D, 0xE2, 0x2B, 0xD9, 0x68, 0xAF, 0x10,
  0x4F, 0x81, 0xEF, 0xDF, 0xFB, 0x4F, 0x40,
  0x7F, 0x47, 0xF6, 0x05, 0xF8, 0x2F, 0x40,
  0x7F, 0x4B, 0xF0, 0x03, 0xF6, 0x3F, 0x20,
  0x6F, 0x5A, 0xF4, 0x09, 0xF3, 0x9B, 0x00,
  0x2F, 0xB6, 0xFF, 0xFF, 0xFE, 0xD2, 0x00,
  0x09, 0xF7, 0x7B, 0x86, 0xB8, 0x30, 0x00,
  0x00, 0xBF, 0xB5, 0x33, 0x6D, 0xB0, 0x00,
  0x00, 0x06, 0xDF, 0xFF, 0xF9, 0x10, 0x00,
  0x00, 0x00, 0x02, 0x43, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0041[ 78] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x00, 0x9B, 0x70, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x2F, 0xFB, 0xFE, 0x00, 0x00,
  0x00, 0x7F, 0xD3, 0xFF, 0x40, 0x00,
  0x00, 0xDF, 0x80, 0xDF, 0xA0, 0x00,
  0x04, 0xFF, 0x30, 0x8F, 0xE0, 0x00,
  0x09, 0xFE, 0x44, 0x7F, 0xF5, 0x00,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x6F, 0xFA, 0x99, 0x9C, 0xFF, 0x10,
  0xBF, 0xD0, 0x00, 0x03, 0xFF, 0x60,
  0xBF, 0x70, 0x00, 0x00, 0xDF, 0x60,
  0x03, 0x00, 0x00, 0x00, 0x13, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0042[ 60] = { // Code 0042, LATIN CAPITAL LETTER B
  0x27, 0x77, 0x77, 0x73, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xA0,
  0xBF, 0xE6, 0x67, 0xDF, 0xF5,
  0xBF, 0xD0, 0x00, 0x3F, 0xF7,
  0xBF, 0xD0, 0x00, 0x6F, 0xF3,
  0xBF, 0xFB, 0xBC, 0xFF, 0x60,
  0xBF, 0xFD, 0xDE, 0xFF, 0xD2,
  0xBF, 0xD0, 0x00, 0x3F, 0xFA,
  0xBF, 0xD0, 0x00, 0x0C, 0xFD,
  0xBF, 0xD0, 0x00, 0x5F, 0xFB,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x7F, 0xFF, 0xFF, 0xEB, 0x30
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0043[ 78] = { // Code 0043, LATIN CAPITAL LETTER C
  0x00, 0x01, 0x7B, 0xBB, 0x71, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFE, 0x30,
  0x02, 0xEF, 0xE8, 0x68, 0xEF, 0xE0,
  0x09, 0xFF, 0x40, 0x00, 0x5F, 0xF1,
  0x0E, 0xFB, 0x00, 0x00, 0x04, 0x40,
  0x2F, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x0D, 0xFD, 0x00, 0x00, 0x2E, 0xD1,
  0x07, 0xFF, 0xA1, 0x01, 0xCF, 0xF1,
  0x01, 0xCF, 0xFF, 0xDF, 0xFF, 0x80,
  0x00, 0x18, 0xEF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x03, 0x43, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0044[ 72] = { // Code 0044, LATIN CAPITAL LETTER D
  0x27, 0x77, 0x77, 0x52, 0x00, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0xBF, 0xE9, 0x9A, 0xEF, 0xF7, 0x00,
  0xBF, 0xD0, 0x00, 0x1D, 0xFE, 0x10,
  0xBF, 0xD0, 0x00, 0x07, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x04, 0xFF, 0x60,
  0xBF, 0xD0, 0x00, 0x04, 0xFF, 0x60,
  0xBF, 0xD0, 0x00, 0x05, 0xFF, 0x50,
  0xBF, 0xD0, 0x00, 0x0A, 0xFF, 0x20,
  0xBF, 0xD2, 0x22, 0x8F, 0xFA, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0x7F, 0xFF, 0xFF, 0xC7, 0x10, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0045[ 60] = { // Code 0045, LATIN CAPITAL LETTER E
  0x17, 0x77, 0x77, 0x77, 0x70,
  0xAF, 0xFF, 0xFF, 0xFF, 0xF4,
  0xBF, 0xE9, 0x99, 0x99, 0x81,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xFD, 0xDD, 0xDD, 0x50,
  0xBF, 0xFF, 0xFF, 0xFF, 0x70,
  0xBF, 0xD2, 0x22, 0x21, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD2, 0x22, 0x22, 0x10,
  0xBF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x6F, 0xFF, 0xFF, 0xFF, 0xE3
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0046[ 65] = { // Code 0046, LATIN CAPITAL LETTER F
  0x17, 0x77, 0x77, 0x77, 0x40,
  0xAF, 0xFF, 0xFF, 0xFF, 0xD0,
  0xBF, 0xE9, 0x99, 0x99, 0x50,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xFB, 0xBB, 0xB9, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0x10,
  0xBF, 0xE4, 0x44, 0x42, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0x8F, 0xB0, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0047[ 78] = { // Code 0047, LATIN CAPITAL LETTER G
  0x00, 0x01, 0x7A, 0xBB, 0x93, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0x70,
  0x02, 0xEF, 0xE8, 0x66, 0xCF, 0xF3,
  0x0A, 0xFF, 0x40, 0x00, 0x1D, 0xF3,
  0x0E, 0xFB, 0x00, 0x00, 0x00, 0x10,
  0x2F, 0xF8, 0x00, 0x01, 0x22, 0x20,
  0x2F, 0xF7, 0x00, 0x4F, 0xFF, 0xFC,
  0x1F, 0xF8, 0x00, 0x3D, 0xDE, 0xFD,
  0x0D, 0xFD, 0x00, 0x00, 0x0A, 0xFD,
  0x07, 0xFF, 0x90, 0x00, 0x5F, 0xFD,
  0x00, 0xCF, 0xFE, 0xBD, 0xFF, 0xFD,
  0x00, 0x19, 0xFF, 0xFF, 0xD3, 0xEC,
  0x00, 0x00, 0x13, 0x43, 0x00, 0x11
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0048[ 78] = { // Code 0048, LATIN CAPITAL LETTER H
  0x4B, 0x50, 0x00, 0x01, 0xA9, 0x00,
  0xBF, 0xD0, 0x00, 0x05, 0xFF, 0x30,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD2, 0x22, 0x27, 0xFF, 0x40,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0xBF, 0xD2, 0x22, 0x27, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0x9F, 0xA0, 0x00, 0x03, 0xFE, 0x20,
  0x03, 0x00, 0x00, 0x00, 0x21, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0049[ 26] = { // Code 0049, LATIN CAPITAL LETTER I
  0x4B, 0x50,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0xBF, 0xD0,
  0x9F, 0xA0,
  0x03, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004A[ 52] = { // Code 004A, LATIN CAPITAL LETTER J
  0x00, 0x00, 0x03, 0xB6,
  0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x09, 0xFF,
  0x27, 0x20, 0x09, 0xFF,
  0xAF, 0xA0, 0x0A, 0xFF,
  0xAF, 0xD0, 0x0D, 0xFD,
  0x5F, 0xFD, 0xDF, 0xF7,
  0x08, 0xFF, 0xFF, 0x90,
  0x00, 0x14, 0x41, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004B[ 65] = { // Code 004B, LATIN CAPITAL LETTER K
  0x4B, 0x50, 0x00, 0x09, 0x90,
  0xBF, 0xD0, 0x00, 0x9F, 0xF3,
  0xBF, 0xD0, 0x08, 0xFF, 0x80,
  0xBF, 0xD0, 0x7F, 0xF9, 0x00,
  0xBF, 0xD5, 0xFF, 0xA0, 0x00,
  0xBF, 0xFF, 0xFF, 0x60, 0x00,
  0xBF, 0xFF, 0xFF, 0xE2, 0x00,
  0xBF, 0xFA, 0x5F, 0xFB, 0x00,
  0xBF, 0xE0, 0x0A, 0xFF, 0x60,
  0xBF, 0xD0, 0x01, 0xEF, 0xE2,
  0xBF, 0xD0, 0x00, 0x5F, 0xFA,
  0x9F, 0xA0, 0x00, 0x0B, 0xFA,
  0x03, 0x00, 0x00, 0x00, 0x30
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004C[ 60] = { // Code 004C, LATIN CAPITAL LETTER L
  0x4B, 0x50, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xE4, 0x44, 0x43, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0x70,
  0x7F, 0xFF, 0xFF, 0xFF, 0x50
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004D[ 78] = { // Code 004D, LATIN CAPITAL LETTER M
  0x5B, 0xB4, 0x00, 0x00, 0x2A, 0xB7,
  0xDF, 0xFC, 0x00, 0x00, 0x9F, 0xFF,
  0xDF, 0xFF, 0x20, 0x00, 0xEF, 0xFF,
  0xDF, 0xFF, 0x70, 0x03, 0xFF, 0xFF,
  0xDF, 0xBF, 0xB0, 0x08, 0xFA, 0xFF,
  0xDF, 0x7E, 0xF1, 0x0C, 0xF6, 0xFF,
  0xDF, 0x79, 0xF6, 0x2F, 0xC4, 0xFF,
  0xDF, 0x74, 0xFB, 0x7F, 0x74, 0xFF,
  0xDF, 0x70, 0xEF, 0xCF, 0x24, 0xFF,
  0xDF, 0x70, 0xAF, 0xFD, 0x04, 0xFF,
  0xDF, 0x70, 0x5F, 0xF8, 0x04, 0xFF,
  0xBF, 0x50, 0x0E, 0xF3, 0x02, 0xFD,
  0x03, 0x00, 0x01, 0x20, 0x00, 0x21
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004E[ 78] = { // Code 004E, LATIN CAPITAL LETTER N
  0x4B, 0x80, 0x00, 0x00, 0x99, 0x00,
  0xCF, 0xF7, 0x00, 0x04, 0xFF, 0x40,
  0xDF, 0xFE, 0x20, 0x04, 0xFF, 0x40,
  0xDF, 0xFF, 0xB0, 0x04, 0xFF, 0x40,
  0xDF, 0xDF, 0xF5, 0x04, 0xFF, 0x40,
  0xDF, 0xB7, 0xFD, 0x14, 0xFF, 0x40,
  0xDF, 0xB0, 0xDF, 0x84, 0xFF, 0x40,
  0xDF, 0xB0, 0x4F, 0xF7, 0xFF, 0x40,
  0xDF, 0xB0, 0x09, 0xFE, 0xFF, 0x40,
  0xDF, 0xB0, 0x01, 0xEF, 0xFF, 0x40,
  0xDF, 0xB0, 0x00, 0x5F, 0xFF, 0x40,
  0xBF, 0x90, 0x00, 0x0B, 0xFE, 0x20,
  0x03, 0x00, 0x00, 0x00, 0x31, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_004F[ 91] = { // Code 004F, LATIN CAPITAL LETTER O
  0x00, 0x02, 0x8B, 0xBB, 0x82, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0xE7, 0x67, 0xDF, 0xF5, 0x00,
  0x0C, 0xFE, 0x20, 0x00, 0x1E, 0xFD, 0x00,
  0x2F, 0xF9, 0x00, 0x00, 0x07, 0xFF, 0x30,
  0x4F, 0xF6, 0x00, 0x00, 0x04, 0xFF, 0x50,
  0x4F, 0xF6, 0x00, 0x00, 0x04, 0xFF, 0x60,
  0x3F, 0xF7, 0x00, 0x00, 0x06, 0xFF, 0x30,
  0x0E, 0xFB, 0x00, 0x00, 0x0B, 0xFE, 0x00,
  0x08, 0xFF, 0x80, 0x00, 0x8F, 0xF8, 0x00,
  0x01, 0xDF, 0xFE, 0xDE, 0xFF, 0xB0, 0x00,
  0x00, 0x19, 0xFF, 0xFF, 0xE8, 0x00, 0x00,
  0x00, 0x00, 0x13, 0x43, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0050[ 65] = { // Code 0050, LATIN CAPITAL LETTER P
  0x27, 0x77, 0x77, 0x74, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xBF, 0xE7, 0x78, 0xDF, 0xF7,
  0xBF, 0xD0, 0x00, 0x1E, 0xFB,
  0xBF, 0xD0, 0x00, 0x0E, 0xFB,
  0xBF, 0xE4, 0x44, 0x9F, 0xF8,
  0xBF, 0xFF, 0xFF, 0xFF, 0xD1,
  0xBF, 0xFB, 0xBB, 0xB7, 0x10,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0xBF, 0xD0, 0x00, 0x00, 0x00,
  0x9F, 0xA0, 0x00, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0051[ 91] = { // Code 0051, LATIN CAPITAL LETTER Q
  0x00, 0x02, 0x8B, 0xBB, 0x82, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0xE7, 0x67, 0xDF, 0xF5, 0x00,
  0x0C, 0xFE, 0x20, 0x00, 0x1E, 0xFD, 0x00,
  0x2F, 0xF9, 0x00, 0x00, 0x07, 0xFF, 0x30,
  0x4F, 0xF6, 0x00, 0x00, 0x04, 0xFF, 0x50,
  0x4F, 0xF6, 0x00, 0x00, 0x04, 0xFF, 0x60,
  0x3F, 0xF7, 0x00, 0x03, 0x06, 0xFF, 0x30,
  0x0E, 0xFB, 0x00, 0x7F, 0x8B, 0xFE, 0x00,
  0x08, 0xFF, 0x80, 0x2D, 0xFF, 0xF8, 0x00,
  0x01, 0xDF, 0xFE, 0xDE, 0xFF, 0xE1, 0x00,
  0x00, 0x19, 0xFF, 0xFF, 0xED, 0xFB, 0x00,
  0x00, 0x00, 0x13, 0x43, 0x01, 0xAA, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0052[ 78] = { // Code 0052, LATIN CAPITAL LETTER R
  0x27, 0x77, 0x77, 0x76, 0x10, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0xBF, 0xE7, 0x77, 0xAF, 0xFD, 0x00,
  0xBF, 0xD0, 0x00, 0x0A, 0xFF, 0x10,
  0xBF, 0xD0, 0x00, 0x09, 0xFE, 0x00,
  0xBF, 0xE6, 0x66, 0x9F, 0xF7, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0xBF, 0xE7, 0x77, 0xCF, 0xF7, 0x00,
  0xBF, 0xD0, 0x00, 0x1E, 0xF9, 0x00,
  0xBF, 0xD0, 0x00, 0x0C, 0xFB, 0x00,
  0xBF, 0xD0, 0x00, 0x0B, 0xFE, 0x00,
  0x9F, 0xA0, 0x00, 0x07, 0xFE, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x31, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0053[ 78] = { // Code 0053, LATIN CAPITAL LETTER S
  0x00, 0x38, 0xBB, 0xA6, 0x00, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x1F, 0xFC, 0x44, 0x8F, 0xFA, 0x00,
  0x4F, 0xF4, 0x00, 0x05, 0xD7, 0x00,
  0x3F, 0xFC, 0x51, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xD9, 0x30, 0x00,
  0x01, 0x7D, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x26, 0x9F, 0xFF, 0x10,
  0x1A, 0x70, 0x00, 0x07, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x09, 0xFF, 0x20,
  0x0D, 0xFF, 0xC9, 0xCF, 0xFB, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0x91, 0x00,
  0x00, 0x01, 0x34, 0x31, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0054[ 78] = { // Code 0054, LATIN CAPITAL LETTER T
  0x37, 0x77, 0x77, 0x77, 0x77, 0x10,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x4A, 0xBB, 0xFF, 0xEB, 0xB9, 0x20,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x13, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0055[ 78] = { // Code 0055, LATIN CAPITAL LETTER U
  0x4B, 0x50, 0x00, 0x01, 0xA9, 0x00,
  0xBF, 0xD0, 0x00, 0x05, 0xFF, 0x30,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xD0, 0x00, 0x06, 0xFF, 0x40,
  0xBF, 0xE0, 0x00, 0x07, 0xFF, 0x30,
  0x8F, 0xF6, 0x00, 0x2D, 0xFE, 0x00,
  0x1E, 0xFF, 0xED, 0xFF, 0xF7, 0x00,
  0x02, 0xBF, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x01, 0x44, 0x30, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0056[ 78] = { // Code 0056, LATIN CAPITAL LETTER V
  0x5B, 0x40, 0x00, 0x00, 0xA9, 0x00,
  0xDF, 0xC0, 0x00, 0x05, 0xFF, 0x30,
  0x9F, 0xF2, 0x00, 0x0A, 0xFE, 0x00,
  0x3F, 0xF6, 0x00, 0x0E, 0xF9, 0x00,
  0x0D, 0xFB, 0x00, 0x5F, 0xF3, 0x00,
  0x08, 0xFF, 0x10, 0x9F, 0xD0, 0x00,
  0x03, 0xFF, 0x50, 0xEF, 0x70, 0x00,
  0x00, 0xCF, 0xA3, 0xFF, 0x20, 0x00,
  0x00, 0x7F, 0xE9, 0xFB, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x23, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0057[104] = { // Code 0057, LATIN CAPITAL LETTER W
  0x5B, 0x30, 0x00, 0x7B, 0x50, 0x00, 0x4B, 0x30,
  0xDF, 0xA0, 0x01, 0xFF, 0xD0, 0x00, 0xCF, 0x90,
  0xAF, 0xD0, 0x04, 0xFF, 0xF1, 0x00, 0xFF, 0x70,
  0x6F, 0xF1, 0x07, 0xFF, 0xF5, 0x03, 0xFF, 0x30,
  0x2F, 0xF4, 0x0B, 0xFA, 0xF8, 0x07, 0xFE, 0x00,
  0x0D, 0xF7, 0x0E, 0xF3, 0xFC, 0x0A, 0xFA, 0x00,
  0x09, 0xFA, 0x3F, 0xB0, 0xEF, 0x1C, 0xF7, 0x00,
  0x06, 0xFD, 0x7F, 0x80, 0xAF, 0x5F, 0xF3, 0x00,
  0x01, 0xFF, 0xBF, 0x40, 0x7F, 0xBF, 0xE0, 0x00,
  0x00, 0xDF, 0xFF, 0x10, 0x3F, 0xFF, 0xA0, 0x00,
  0x00, 0x9F, 0xFC, 0x00, 0x0E, 0xFF, 0x60, 0x00,
  0x00, 0x4F, 0xF6, 0x00, 0x09, 0xFE, 0x10, 0x00,
  0x00, 0x02, 0x20, 0x00, 0x00, 0x31, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0058[ 65] = { // Code 0058, LATIN CAPITAL LETTER X
  0x1A, 0x70, 0x00, 0x1A, 0x80,
  0x7F, 0xF3, 0x00, 0x8F, 0xF2,
  0x2E, 0xFC, 0x03, 0xFF, 0xA0,
  0x06, 0xFF, 0x6C, 0xFE, 0x10,
  0x00, 0xBF, 0xFF, 0xF5, 0x00,
  0x00, 0x2E, 0xFF, 0x90, 0x00,
  0x00, 0x1E, 0xFF, 0x80, 0x00,
  0x00, 0xBF, 0xFF, 0xF3, 0x00,
  0x06, 0xFF, 0x8E, 0xFD, 0x00,
  0x2E, 0xFC, 0x06, 0xFF, 0x80,
  0xAF, 0xF3, 0x00, 0xCF, 0xF2,
  0xAF, 0x90, 0x00, 0x3F, 0xF2,
  0x03, 0x00, 0x00, 0x02, 0x20
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0059[ 65] = { // Code 0059, LATIN CAPITAL LETTER Y
  0x5B, 0x30, 0x00, 0x05, 0xB3,
  0xCF, 0xD0, 0x00, 0x1E, 0xF9,
  0x6F, 0xF7, 0x00, 0x8F, 0xF3,
  0x0C, 0xFE, 0x12, 0xFF, 0x90,
  0x03, 0xFF, 0x8A, 0xFE, 0x10,
  0x00, 0x9F, 0xFF, 0xF6, 0x00,
  0x00, 0x1E, 0xFF, 0xC0, 0x00,
  0x00, 0x07, 0xFF, 0x50, 0x00,
  0x00, 0x06, 0xFF, 0x40, 0x00,
  0x00, 0x06, 0xFF, 0x40, 0x00,
  0x00, 0x06, 0xFF, 0x40, 0x00,
  0x00, 0x04, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0x21, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005A[ 72] = { // Code 005A, LATIN CAPITAL LETTER Z
  0x04, 0x77, 0x77, 0x77, 0x77, 0x10,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x07, 0xBB, 0xBB, 0xCF, 0xFE, 0x20,
  0x00, 0x00, 0x01, 0xCF, 0xF4, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x8F, 0xF9, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x4F, 0xFD, 0x10, 0x00, 0x00,
  0x02, 0xEF, 0xE2, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0x84, 0x44, 0x42, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x4E, 0xFF, 0xFF, 0xFF, 0xFE, 0x40
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005B[ 45] = { // Code 005B, LEFT SQUARE BRACKET
  0x17, 0x77, 0x30,
  0x9F, 0xFF, 0x80,
  0x9F, 0x93, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0x70, 0x00,
  0x9F, 0xDB, 0x50,
  0x5E, 0xFE, 0x70
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005C[ 39] = { // Code 005C, REVERSE SOLIDUS
  0x88, 0x00, 0x00,
  0xBF, 0x20, 0x00,
  0x6F, 0x70, 0x00,
  0x1E, 0xD0, 0x00,
  0x09, 0xF3, 0x00,
  0x04, 0xF9, 0x00,
  0x00, 0xDE, 0x00,
  0x00, 0x7F, 0x50,
  0x00, 0x2F, 0xB0,
  0x00, 0x0B, 0xF2,
  0x00, 0x05, 0xF7,
  0x00, 0x00, 0xEB,
  0x00, 0x00, 0x21
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005D[ 45] = { // Code 005D, RIGHT SQUARE BRACKET
  0x67, 0x76, 0x00,
  0xEF, 0xFF, 0x30,
  0x24, 0xEF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x00, 0xDF, 0x40,
  0x9B, 0xFF, 0x40,
  0xBF, 0xFC, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005E[ 32] = { // Code 005E, CIRCUMFLEX ACCENT
  0x00, 0x01, 0x10, 0x00,
  0x00, 0x3F, 0xC0, 0x00,
  0x00, 0xCF, 0xF6, 0x00,
  0x05, 0xFC, 0xFE, 0x00,
  0x0D, 0xF3, 0x8F, 0x70,
  0x7F, 0x90, 0x1E, 0xE1,
  0xDE, 0x10, 0x07, 0xF7,
  0x32, 0x00, 0x00, 0x31
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_005F[  5] = { // Code 005F, LOW LINE
  0x5B, 0xBB, 0xBB, 0xBB, 0xB5
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0060[  8] = { // Code 0060, GRAVE ACCENT
  0x11, 0x00,
  0xED, 0x30,
  0x7F, 0xF4,
  0x03, 0xB5
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0061[ 50] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x16, 0x98, 0x61, 0x00,
  0x05, 0xEF, 0xFF, 0xFE, 0x30,
  0x0B, 0xF9, 0x34, 0xDF, 0x90,
  0x03, 0x40, 0x01, 0xBF, 0xB0,
  0x02, 0x8C, 0xEF, 0xFF, 0xB0,
  0x1E, 0xFD, 0x86, 0xAF, 0xB0,
  0x5F, 0xF1, 0x00, 0xBF, 0xB0,
  0x3F, 0xF8, 0x6A, 0xFF, 0xC0,
  0x08, 0xFF, 0xFA, 0x5F, 0xC0,
  0x00, 0x13, 0x10, 0x02, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0062[ 65] = { // Code 0062, LATIN SMALL LETTER B
  0x08, 0xA1, 0x00, 0x00, 0x00,
  0x1F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x59, 0x71, 0x00,
  0x2F, 0xFC, 0xFF, 0xFE, 0x20,
  0x2F, 0xFE, 0x55, 0xEF, 0xB0,
  0x2F, 0xF6, 0x00, 0x5F, 0xF1,
  0x2F, 0xF2, 0x00, 0x2F, 0xF3,
  0x2F, 0xF3, 0x00, 0x3F, 0xF2,
  0x2F, 0xF8, 0x00, 0x8F, 0xE0,
  0x2F, 0xFF, 0xBB, 0xFF, 0x80,
  0x1E, 0xE6, 0xFF, 0xF9, 0x00,
  0x02, 0x20, 0x13, 0x10, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0063[ 50] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x16, 0x98, 0x40, 0x00,
  0x03, 0xEF, 0xFF, 0xFB, 0x00,
  0x0E, 0xFC, 0x46, 0xEF, 0x30,
  0x5F, 0xF1, 0x00, 0x48, 0x00,
  0x7F, 0xD0, 0x00, 0x00, 0x00,
  0x7F, 0xD0, 0x00, 0x01, 0x00,
  0x4F, 0xF3, 0x00, 0xBF, 0x30,
  0x0C, 0xFE, 0xAC, 0xFF, 0x20,
  0x02, 0xBF, 0xFF, 0xD4, 0x00,
  0x00, 0x01, 0x32, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0064[ 65] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0x2B, 0x60,
  0x00, 0x00, 0x00, 0x7F, 0xD0,
  0x00, 0x00, 0x00, 0x7F, 0xD0,
  0x00, 0x38, 0x84, 0x7F, 0xD0,
  0x05, 0xFF, 0xFF, 0xDF, 0xD0,
  0x0E, 0xFC, 0x47, 0xFF, 0xD0,
  0x4F, 0xF2, 0x00, 0x9F, 0xD0,
  0x6F, 0xE0, 0x00, 0x6F, 0xD0,
  0x6F, 0xE0, 0x00, 0x6F, 0xD0,
  0x3F, 0xF5, 0x00, 0xBF, 0xD0,
  0x0B, 0xFF, 0xAC, 0xFF, 0xD0,
  0x01, 0xBF, 0xFE, 0x6F, 0xC0,
  0x00, 0x02, 0x30, 0x03, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0065[ 50] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x06, 0x88, 0x50, 0x00,
  0x02, 0xDF, 0xFF, 0xFC, 0x10,
  0x0C, 0xFA, 0x22, 0xBF, 0xB0,
  0x3F, 0xF3, 0x22, 0x3F, 0xF2,
  0x6F, 0xFF, 0xFF, 0xFF, 0xF3,
  0x6F, 0xE4, 0x44, 0x44, 0x30,
  0x2F, 0xF4, 0x00, 0x1A, 0x60,
  0x0A, 0xFF, 0xAA, 0xEF, 0xA0,
  0x00, 0x8F, 0xFF, 0xFA, 0x10,
  0x00, 0x00, 0x33, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0066[ 39] = { // Code 0066, LATIN SMALL LETTER F
  0x00, 0x4B, 0xB5,
  0x02, 0xFF, 0xFB,
  0x05, 0xFF, 0x21,
  0x39, 0xFF, 0x63,
  0xBF, 0xFF, 0xFB,
  0x17, 0xFF, 0x21,
  0x06, 0xFF, 0x00,
  0x06, 0xFF, 0x00,
  0x06, 0xFF, 0x00,
  0x06, 0xFF, 0x00,
  0x06, 0xFF, 0x00,
  0x04, 0xFD, 0x00,
  0x00, 0x21, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0067[ 65] = { // Code 0067, LATIN SMALL LETTER G
  0x00, 0x27, 0x95, 0x08, 0x40,
  0x04, 0xFF, 0xFF, 0xBF, 0xD0,
  0x0E, 0xFB, 0x46, 0xEF, 0xD0,
  0x4F, 0xF2, 0x00, 0x8F, 0xD0,
  0x6F, 0xE0, 0x00, 0x6F, 0xD0,
  0x6F, 0xF0, 0x00, 0x7F, 0xD0,
  0x2F, 0xF8, 0x02, 0xDF, 0xD0,
  0x09, 0xFF, 0xFF, 0xEF, 0xD0,
  0x00, 0x6B, 0xB7, 0x6F, 0xD0,
  0x03, 0x60, 0x00, 0x9F, 0xB0,
  0x0C, 0xFB, 0x47, 0xFF, 0x50,
  0x04, 0xEF, 0xFF, 0xF8, 0x00,
  0x00, 0x15, 0x65, 0x20, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0068[ 65] = { // Code 0068, LATIN SMALL LETTER H
  0x08, 0xA1, 0x00, 0x00, 0x00,
  0x1F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x48, 0x83, 0x00,
  0x2F, 0xFB, 0xFF, 0xFF, 0x40,
  0x2F, 0xFE, 0x77, 0xEF, 0xB0,
  0x2F, 0xF6, 0x00, 0x8F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x0E, 0xF2, 0x00, 0x6F, 0xB0,
  0x01, 0x20, 0x00, 0x03, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0069[ 26] = { // Code 0069, LATIN SMALL LETTER I
  0x7B, 0x20,
  0xEF, 0x60,
  0x68, 0x10,
  0x58, 0x10,
  0xEF, 0x50,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xCF, 0x40,
  0x13, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006A[ 48] = { // Code 006A, LATIN SMALL LETTER J
  0x00, 0x7B, 0x20,
  0x00, 0xEF, 0x60,
  0x00, 0x68, 0x10,
  0x00, 0x58, 0x10,
  0x00, 0xEF, 0x50,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x00, 0xFF, 0x60,
  0x17, 0xFF, 0x50,
  0x3F, 0xFE, 0x10,
  0x03, 0x41, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006B[ 65] = { // Code 006B, LATIN SMALL LETTER K
  0x08, 0xA1, 0x00, 0x00, 0x00,
  0x1F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x00, 0x00, 0x00,
  0x2F, 0xF4, 0x01, 0x74, 0x00,
  0x2F, 0xF4, 0x0A, 0xFD, 0x00,
  0x2F, 0xF4, 0x9F, 0xF4, 0x00,
  0x2F, 0xFB, 0xFF, 0x50, 0x00,
  0x2F, 0xFF, 0xFE, 0x20, 0x00,
  0x2F, 0xFE, 0xDF, 0xC0, 0x00,
  0x2F, 0xF4, 0x4F, 0xF9, 0x00,
  0x2F, 0xF4, 0x08, 0xFF, 0x40,
  0x0E, 0xF2, 0x00, 0xCF, 0x50,
  0x01, 0x20, 0x00, 0x02, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006C[ 26] = { // Code 006C, LATIN SMALL LETTER L
  0x7A, 0x20,
  0xEF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xFF, 0x60,
  0xCF, 0x40,
  0x13, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006D[ 70] = { // Code 006D, LATIN SMALL LETTER M
  0x06, 0x70, 0x38, 0x82, 0x04, 0x88, 0x40,
  0x1F, 0xF9, 0xFF, 0xFE, 0x7F, 0xFF, 0xF6,
  0x2F, 0xFE, 0x77, 0xFF, 0xF9, 0x6E, 0xFC,
  0x2F, 0xF6, 0x00, 0xCF, 0xB0, 0x08, 0xFD,
  0x2F, 0xF4, 0x00, 0xBF, 0x90, 0x07, 0xFD,
  0x2F, 0xF4, 0x00, 0xBF, 0x90, 0x07, 0xFD,
  0x2F, 0xF4, 0x00, 0xBF, 0x90, 0x07, 0xFD,
  0x2F, 0xF4, 0x00, 0xBF, 0x90, 0x07, 0xFD,
  0x0E, 0xF2, 0x00, 0xAF, 0x70, 0x05, 0xFC,
  0x01, 0x20, 0x00, 0x03, 0x00, 0x00, 0x31
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006E[ 50] = { // Code 006E, LATIN SMALL LETTER N
  0x07, 0x60, 0x48, 0x83, 0x00,
  0x1F, 0xF8, 0xFF, 0xFF, 0x40,
  0x2F, 0xFE, 0x77, 0xEF, 0xB0,
  0x2F, 0xF6, 0x00, 0x8F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x0E, 0xF2, 0x00, 0x6F, 0xB0,
  0x01, 0x20, 0x00, 0x03, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006F[ 50] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x16, 0x88, 0x50, 0x00,
  0x03, 0xEF, 0xFF, 0xFC, 0x10,
  0x0D, 0xFB, 0x34, 0xDF, 0xA0,
  0x4F, 0xF2, 0x00, 0x5F, 0xF1,
  0x6F, 0xE0, 0x00, 0x2F, 0xF3,
  0x6F, 0xE0, 0x00, 0x3F, 0xF3,
  0x3F, 0xF4, 0x00, 0x7F, 0xE0,
  0x0B, 0xFE, 0x99, 0xFF, 0x80,
  0x01, 0xAF, 0xFF, 0xE8, 0x00,
  0x00, 0x01, 0x33, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0070[ 65] = { // Code 0070, LATIN SMALL LETTER P
  0x07, 0x70, 0x69, 0x61, 0x00,
  0x1F, 0xFB, 0xFF, 0xFE, 0x20,
  0x2F, 0xFE, 0x55, 0xEF, 0xB0,
  0x2F, 0xF5, 0x00, 0x6F, 0xF1,
  0x2F, 0xF2, 0x00, 0x2F, 0xF3,
  0x2F, 0xF3, 0x00, 0x3F, 0xF3,
  0x2F, 0xF8, 0x00, 0x8F, 0xE0,
  0x2F, 0xFF, 0xBA, 0xFF, 0x80,
  0x2F, 0xF8, 0xFF, 0xFA, 0x00,
  0x2F, 0xF4, 0x13, 0x10, 0x00,
  0x2F, 0xF4, 0x00, 0x00, 0x00,
  0x1F, 0xF3, 0x00, 0x00, 0x00,
  0x02, 0x30, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0071[ 65] = { // Code 0071, LATIN SMALL LETTER Q
  0x00, 0x27, 0x95, 0x08, 0x40,
  0x04, 0xFF, 0xFF, 0xBF, 0xD0,
  0x0E, 0xFC, 0x46, 0xFF, 0xD0,
  0x4F, 0xF2, 0x00, 0x9F, 0xD0,
  0x6F, 0xE0, 0x00, 0x6F, 0xD0,
  0x6F, 0xF0, 0x00, 0x6F, 0xD0,
  0x3F, 0xF4, 0x00, 0xBF, 0xD0,
  0x0C, 0xFE, 0xAC, 0xFF, 0xD0,
  0x01, 0xCF, 0xFD, 0xAF, 0xD0,
  0x00, 0x02, 0x30, 0x7F, 0xD0,
  0x00, 0x00, 0x00, 0x7F, 0xD0,
  0x00, 0x00, 0x00, 0x6F, 0xC0,
  0x00, 0x00, 0x00, 0x04, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0072[ 30] = { // Code 0072, LATIN SMALL LETTER R
  0x57, 0x06, 0x81,
  0xEF, 0x8F, 0xF5,
  0xFF, 0xEC, 0xA2,
  0xFF, 0xA0, 0x00,
  0xFF, 0x60, 0x00,
  0xFF, 0x60, 0x00,
  0xFF, 0x60, 0x00,
  0xFF, 0x60, 0x00,
  0xCF, 0x40, 0x00,
  0x13, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0073[ 40] = { // Code 0073, LATIN SMALL LETTER S
  0x00, 0x58, 0x86, 0x20,
  0x1C, 0xFF, 0xFF, 0xF4,
  0x5F, 0xE4, 0x39, 0xF8,
  0x5F, 0xF7, 0x30, 0x30,
  0x1D, 0xFF, 0xFE, 0x91,
  0x00, 0x59, 0xDF, 0xFC,
  0x3D, 0x50, 0x06, 0xFF,
  0x5F, 0xF9, 0x6C, 0xFC,
  0x07, 0xEF, 0xFF, 0xB2,
  0x00, 0x02, 0x31, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0074[ 36] = { // Code 0074, LATIN SMALL LETTER T
  0x04, 0xE9, 0x00,
  0x07, 0xFD, 0x00,
  0x3A, 0xFE, 0x62,
  0xBF, 0xFF, 0xF9,
  0x18, 0xFD, 0x20,
  0x07, 0xFD, 0x00,
  0x07, 0xFD, 0x00,
  0x07, 0xFD, 0x00,
  0x07, 0xFD, 0x00,
  0x07, 0xFF, 0xA4,
  0x02, 0xDF, 0xF8,
  0x00, 0x03, 0x30
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0075[ 50] = { // Code 0075, LATIN SMALL LETTER U
  0x06, 0x80, 0x00, 0x19, 0x40,
  0x1F, 0xF3, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x2F, 0xF4, 0x00, 0x7F, 0xD0,
  0x1F, 0xF7, 0x01, 0xCF, 0xD0,
  0x0D, 0xFF, 0xBD, 0xEF, 0xD0,
  0x03, 0xEF, 0xFC, 0x4F, 0xB0,
  0x00, 0x03, 0x20, 0x02, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0076[ 40] = { // Code 0076, LATIN SMALL LETTER V
  0x48, 0x10, 0x01, 0x84,
  0xDF, 0x70, 0x07, 0xFD,
  0xAF, 0xB0, 0x0B, 0xFA,
  0x4F, 0xF1, 0x1F, 0xF4,
  0x0E, 0xF5, 0x5F, 0xE0,
  0x08, 0xFA, 0xAF, 0x80,
  0x03, 0xFE, 0xEF, 0x30,
  0x00, 0xDF, 0xFD, 0x00,
  0x00, 0x7F, 0xF7, 0x00,
  0x00, 0x03, 0x30, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0077[ 70] = { // Code 0077, LATIN SMALL LETTER W
  0x38, 0x10, 0x06, 0x91, 0x00, 0x67, 0x00,
  0xBF, 0x70, 0x2F, 0xF9, 0x01, 0xFF, 0x30,
  0x9F, 0xB0, 0x5F, 0xFD, 0x04, 0xFF, 0x10,
  0x4F, 0xE0, 0x8F, 0xEF, 0x17, 0xFB, 0x00,
  0x0E, 0xF3, 0xBE, 0x7F, 0x4B, 0xF6, 0x00,
  0x0A, 0xF7, 0xFA, 0x4F, 0x8E, 0xF2, 0x00,
  0x05, 0xFD, 0xF7, 0x0E, 0xDF, 0xC0, 0x00,
  0x01, 0xFF, 0xF3, 0x0B, 0xFF, 0x80, 0x00,
  0x00, 0xBF, 0xD0, 0x06, 0xFF, 0x30, 0x00,
  0x00, 0x03, 0x10, 0x00, 0x32, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0078[ 40] = { // Code 0078, LATIN SMALL LETTER X
  0x18, 0x30, 0x04, 0x81,
  0x7F, 0xD1, 0x1E, 0xF5,
  0x2F, 0xF8, 0xAF, 0xD1,
  0x07, 0xFF, 0xFF, 0x40,
  0x00, 0xCF, 0xF9, 0x00,
  0x03, 0xFF, 0xFD, 0x10,
  0x0C, 0xFB, 0xEF, 0x90,
  0x7F, 0xE2, 0x6F, 0xF3,
  0xAF, 0x70, 0x0B, 0xF4,
  0x03, 0x00, 0x00, 0x30
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0079[ 52] = { // Code 0079, LATIN SMALL LETTER Y
  0x38, 0x10, 0x01, 0x83,
  0xBF, 0x90, 0x08, 0xFB,
  0x8F, 0xD0, 0x0C, 0xF8,
  0x3F, 0xF2, 0x1F, 0xF3,
  0x0D, 0xF6, 0x5F, 0xC0,
  0x08, 0xFA, 0x9F, 0x70,
  0x02, 0xFE, 0xDF, 0x20,
  0x00, 0xCF, 0xFB, 0x00,
  0x00, 0x7F, 0xF6, 0x00,
  0x00, 0x3F, 0xF1, 0x00,
  0x0A, 0xCF, 0xA0, 0x00,
  0x2F, 0xFE, 0x20, 0x00,
  0x02, 0x41, 0x00, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007A[ 45] = { // Code 007A, LATIN SMALL LETTER Z
  0x04, 0x66, 0x66, 0x65, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0x30,
  0x06, 0x77, 0x8F, 0xFD, 0x10,
  0x00, 0x00, 0xBF, 0xD1, 0x00,
  0x00, 0x0A, 0xFE, 0x20, 0x00,
  0x00, 0x9F, 0xE3, 0x00, 0x00,
  0x08, 0xFF, 0x40, 0x00, 0x00,
  0x5F, 0xFF, 0xDD, 0xDC, 0x30,
  0x5F, 0xFF, 0xFF, 0xFF, 0x40
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007B[ 45] = { // Code 007B, LEFT CURLY BRACKET
  0x00, 0x37, 0x73,
  0x03, 0xFF, 0xE7,
  0x06, 0xFC, 0x00,
  0x06, 0xFB, 0x00,
  0x06, 0xFB, 0x00,
  0x06, 0xFB, 0x00,
  0x08, 0xFA, 0x00,
  0xDF, 0xC2, 0x00,
  0x6C, 0xF7, 0x00,
  0x06, 0xFB, 0x00,
  0x06, 0xFB, 0x00,
  0x06, 0xFB, 0x00,
  0x06, 0xFB, 0x00,
  0x05, 0xFE, 0x83,
  0x00, 0xAE, 0xF7
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007C[ 26] = { // Code 007C, VERTICAL LINE
  0x0B, 0x60,
  0x3F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x4F, 0xB0,
  0x2F, 0xA0,
  0x03, 0x10
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007D[ 45] = { // Code 007D, RIGHT CURLY BRACKET
  0x67, 0x71, 0x00,
  0xCE, 0xFC, 0x00,
  0x03, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x01, 0xFF, 0x30,
  0x00, 0x6E, 0xF8,
  0x00, 0xDF, 0x93,
  0x02, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x02, 0xFF, 0x00,
  0x6A, 0xFE, 0x00,
  0xDF, 0xD6, 0x00
};

static GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007E[ 15] = { // Code 007E, TILDE
  0x08, 0xFE, 0xA3, 0x07, 0xB0,
  0x3F, 0xFE, 0xFF, 0xFF, 0xC0,
  0x3B, 0x20, 0x5B, 0xFC, 0x20
};

static GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font20_AA4_CharInfo[95] = {
   {   1,   1,   0,  16,   5, acGUI_Font20_AA4_0020 } // Code 0020, SPACE
  ,{   3,  13,   1,   4,   5, acGUI_Font20_AA4_0021 } // Code 0021, EXCLAMATION MARK
  ,{   6,   6,   1,   4,   9, acGUI_Font20_AA4_0022 } // Code 0022, QUOTATION MARK
  ,{   9,  13,   0,   4,  10, acGUI_Font20_AA4_0023 } // Code 0023, NUMBER SIGN
  ,{  10,  15,   0,   3,  10, acGUI_Font20_AA4_0024 } // Code 0024, DOLLAR SIGN
  ,{  14,  13,   1,   4,  16, acGUI_Font20_AA4_0025 } // Code 0025, PERCENT SIGN
  ,{  11,  13,   0,   4,  11, acGUI_Font20_AA4_0026 } // Code 0026, AMPERSAND
  ,{   3,   6,   1,   4,   5, acGUI_Font20_AA4_0027 } // Code 0027, APOSTROPHE
  ,{   4,  16,   1,   4,   5, acGUI_Font20_AA4_0028 } // Code 0028, LEFT PARENTHESIS
  ,{   5,  16,   0,   4,   5, acGUI_Font20_AA4_0029 } // Code 0029, RIGHT PARENTHESIS
  ,{   7,   6,   0,   4,   7, acGUI_Font20_AA4_002A } // Code 002A, ASTERISK
  ,{  10,  10,   0,   6,  10, acGUI_Font20_AA4_002B } // Code 002B, PLUS SIGN
  ,{   3,   6,   1,  13,   5, acGUI_Font20_AA4_002C } // Code 002C, COMMA
  ,{   6,   3,   0,  10,   7, acGUI_Font20_AA4_002D } // Code 002D, HYPHEN-MINUS
  ,{   3,   4,   1,  13,   5, acGUI_Font20_AA4_002E } // Code 002E, FULL STOP
  ,{   6,  13,   0,   4,   6, acGUI_Font20_AA4_002F } // Code 002F, SOLIDUS
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0030 } // Code 0030, DIGIT ZERO
  ,{   7,  13,  -1,   4,   7, acGUI_Font20_AA4_0031 } // Code 0031, DIGIT ONE
  ,{   9,  12,   0,   4,   9, acGUI_Font20_AA4_0032 } // Code 0032, DIGIT TWO
  ,{   9,  13,   0,   4,   9, acGUI_Font20_AA4_0033 } // Code 0033, DIGIT THREE
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0034 } // Code 0034, DIGIT FOUR
  ,{   9,  13,   0,   4,   9, acGUI_Font20_AA4_0035 } // Code 0035, DIGIT FIVE
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0036 } // Code 0036, DIGIT SIX
  ,{   9,  13,   0,   4,   9, acGUI_Font20_AA4_0037 } // Code 0037, DIGIT SEVEN
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0038 } // Code 0038, DIGIT EIGHT
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0039 } // Code 0039, DIGIT NINE
  ,{   3,  10,   1,   7,   5, acGUI_Font20_AA4_003A } // Code 003A, COLON
  ,{   3,  12,   1,   7,   5, acGUI_Font20_AA4_003B } // Code 003B, SEMICOLON
  ,{  10,   9,   0,   7,  10, acGUI_Font20_AA4_003C } // Code 003C, LESS-THAN SIGN
  ,{  10,   7,   0,   8,  10, acGUI_Font20_AA4_003D } // Code 003D, EQUALS SIGN
  ,{  10,   9,   0,   7,  10, acGUI_Font20_AA4_003E } // Code 003E, GREATER-THAN SIGN
  ,{   9,  13,   0,   4,   9, acGUI_Font20_AA4_003F } // Code 003F, QUESTION MARK
  ,{  13,  13,   0,   4,  13, acGUI_Font20_AA4_0040 } // Code 0040, COMMERCIAL AT
  ,{  11,  13,   0,   4,  11, acGUI_Font20_AA4_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{  10,  12,   1,   4,  12, acGUI_Font20_AA4_0042 } // Code 0042, LATIN CAPITAL LETTER B
  ,{  12,  13,   0,   4,  12, acGUI_Font20_AA4_0043 } // Code 0043, LATIN CAPITAL LETTER C
  ,{  11,  12,   1,   4,  12, acGUI_Font20_AA4_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{  10,  12,   1,   4,  11, acGUI_Font20_AA4_0045 } // Code 0045, LATIN CAPITAL LETTER E
  ,{   9,  13,   1,   4,  10, acGUI_Font20_AA4_0046 } // Code 0046, LATIN CAPITAL LETTER F
  ,{  12,  13,   0,   4,  13, acGUI_Font20_AA4_0047 } // Code 0047, LATIN CAPITAL LETTER G
  ,{  11,  13,   1,   4,  12, acGUI_Font20_AA4_0048 } // Code 0048, LATIN CAPITAL LETTER H
  ,{   3,  13,   1,   4,   5, acGUI_Font20_AA4_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{   8,  13,   0,   4,   9, acGUI_Font20_AA4_004A } // Code 004A, LATIN CAPITAL LETTER J
  ,{  10,  13,   1,   4,  11, acGUI_Font20_AA4_004B } // Code 004B, LATIN CAPITAL LETTER K
  ,{   9,  12,   1,   4,  10, acGUI_Font20_AA4_004C } // Code 004C, LATIN CAPITAL LETTER L
  ,{  12,  13,   1,   4,  14, acGUI_Font20_AA4_004D } // Code 004D, LATIN CAPITAL LETTER M
  ,{  11,  13,   1,   4,  12, acGUI_Font20_AA4_004E } // Code 004E, LATIN CAPITAL LETTER N
  ,{  13,  13,   0,   4,  13, acGUI_Font20_AA4_004F } // Code 004F, LATIN CAPITAL LETTER O
  ,{  10,  13,   1,   4,  11, acGUI_Font20_AA4_0050 } // Code 0050, LATIN CAPITAL LETTER P
  ,{  13,  13,   0,   4,  13, acGUI_Font20_AA4_0051 } // Code 0051, LATIN CAPITAL LETTER Q
  ,{  11,  13,   1,   4,  12, acGUI_Font20_AA4_0052 } // Code 0052, LATIN CAPITAL LETTER R
  ,{  11,  13,   0,   4,  11, acGUI_Font20_AA4_0053 } // Code 0053, LATIN CAPITAL LETTER S
  ,{  11,  13,   0,   4,  11, acGUI_Font20_AA4_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{  11,  13,   1,   4,  12, acGUI_Font20_AA4_0055 } // Code 0055, LATIN CAPITAL LETTER U
  ,{  11,  13,   0,   4,  10, acGUI_Font20_AA4_0056 } // Code 0056, LATIN CAPITAL LETTER V
  ,{  15,  13,   0,   4,  15, acGUI_Font20_AA4_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{  10,  13,   0,   4,   9, acGUI_Font20_AA4_0058 } // Code 0058, LATIN CAPITAL LETTER X
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0059 } // Code 0059, LATIN CAPITAL LETTER Y
  ,{  11,  12,   0,   4,  11, acGUI_Font20_AA4_005A } // Code 005A, LATIN CAPITAL LETTER Z
  ,{   5,  15,   1,   4,   6, acGUI_Font20_AA4_005B } // Code 005B, LEFT SQUARE BRACKET
  ,{   6,  13,   0,   4,   6, acGUI_Font20_AA4_005C } // Code 005C, REVERSE SOLIDUS
  ,{   5,  15,   0,   4,   6, acGUI_Font20_AA4_005D } // Code 005D, RIGHT SQUARE BRACKET
  ,{   8,   8,   1,   4,  10, acGUI_Font20_AA4_005E } // Code 005E, CIRCUMFLEX ACCENT
  ,{  10,   1,  -1,  17,   8, acGUI_Font20_AA4_005F } // Code 005F, LOW LINE
  ,{   4,   4,   0,   3,   4, acGUI_Font20_AA4_0060 } // Code 0060, GRAVE ACCENT
  ,{   9,  10,   0,   7,  10, acGUI_Font20_AA4_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{  10,  13,   0,   4,  10, acGUI_Font20_AA4_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{   9,  10,   0,   7,   9, acGUI_Font20_AA4_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{   9,  13,   0,   4,  10, acGUI_Font20_AA4_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{  10,  10,   0,   7,  10, acGUI_Font20_AA4_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   6,  13,   0,   4,   6, acGUI_Font20_AA4_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{   9,  13,   0,   7,  10, acGUI_Font20_AA4_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{   9,  13,   0,   4,  10, acGUI_Font20_AA4_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   3,  13,   1,   4,   4, acGUI_Font20_AA4_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   5,  16,  -1,   4,   4, acGUI_Font20_AA4_006A } // Code 006A, LATIN SMALL LETTER J
  ,{   9,  13,   0,   4,   9, acGUI_Font20_AA4_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   3,  13,   1,   4,   4, acGUI_Font20_AA4_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  14,  10,   0,   7,  15, acGUI_Font20_AA4_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   9,  10,   0,   7,  10, acGUI_Font20_AA4_006E } // Code 006E, LATIN SMALL LETTER N
  ,{  10,  10,   0,   7,  10, acGUI_Font20_AA4_006F } // Code 006F, LATIN SMALL LETTER O
  ,{  10,  13,   0,   7,  10, acGUI_Font20_AA4_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{   9,  13,   0,   7,  10, acGUI_Font20_AA4_0071 } // Code 0071, LATIN SMALL LETTER Q
  ,{   6,  10,   1,   7,   7, acGUI_Font20_AA4_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{   8,  10,   0,   7,   9, acGUI_Font20_AA4_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{   6,  12,   0,   5,   6, acGUI_Font20_AA4_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{   9,  10,   0,   7,  10, acGUI_Font20_AA4_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{   8,  10,   0,   7,   8, acGUI_Font20_AA4_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  13,  10,   0,   7,  12, acGUI_Font20_AA4_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{   8,  10,   0,   7,   8, acGUI_Font20_AA4_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{   8,  13,   0,   7,   8, acGUI_Font20_AA4_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{   9,   9,   0,   7,   9, acGUI_Font20_AA4_007A } // Code 007A, LATIN SMALL LETTER Z
  ,{   6,  15,   0,   4,   6, acGUI_Font20_AA4_007B } // Code 007B, LEFT CURLY BRACKET
  ,{   3,  13,   0,   4,   4, acGUI_Font20_AA4_007C } // Code 007C, VERTICAL LINE
  ,{   6,  15,   0,   4,   6, acGUI_Font20_AA4_007D } // Code 007D, RIGHT CURLY BRACKET
  ,{   9,   3,   0,  10,  10, acGUI_Font20_AA4_007E } // Code 007E, TILDE
};

static GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop1 = {
   0x0020 // first character
  ,0x007E // last character 
  ,&GUI_Font20_AA4_CharInfo[  0] // address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // pointer to next GUI_FONT_PROP_EXT
};

static GUI_CONST_STORAGE GUI_FONT GUI_Font20_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,20 // height of font 
  ,20 // space of font y
  ,1 // magnification x
  ,1 // magnification y
  ,{&GUI_Font20_AA4_Prop1}
  ,20 // Baseline
  ,10 // Height of lowercase characters
  ,13 // Height of capital characters
};

/*********************************************************************
*
*       bmSeggerLogo_160x80
*/
static GUI_CONST_STORAGE unsigned long acSeggerLogo_160x80[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00BCBCBC, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00CACACA, 0x00CACACA, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00444444, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00878787, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00515151, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x005F5F5F, 0x006C6C6C, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x005F5F5F, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00878787, 0x00BCBCBC, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x006C6C6C, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00797979, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00A1A1A1, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00515151, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00878787, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00363636, 0x00515151, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 
        0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00AFAFAF, 0x00D7D7D7, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00797979, 0x00BCBCBC, 0x00CACACA, 0x00BCBCBC, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x006C6C6C, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00797979, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BCBCBC, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x006C6C6C, 0x005F5F5F, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 
        0x00AFAFAF, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00E4E4E4, 0x00FFFFFF, 0x00D7D7D7, 0x005F5F5F, 0x005F5F5F, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00A1A1A1, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00949494, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00949494, 0x006C6C6C, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo_160x80 = {
  160, // XSize
  80, // YSize
  640, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)acSeggerLogo_160x80,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       bmReturn, bmBackSpace, bmUp: Bitmaps used for keyboard
*/
static GUI_CONST_STORAGE unsigned long acReturn[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x50505050, 0x50505050,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000,
  0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x50505050,
  0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP bmReturn = {
  16, // XSize
  8, // YSize
  64, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)acReturn,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

static GUI_CONST_STORAGE unsigned long acBackSpace[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA0A0A0A0, 0x20202020, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP bmBackSpace = {
  16, // XSize
  8, // YSize
  64, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)acBackSpace,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

static GUI_CONST_STORAGE unsigned long acUp[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x60606060, 0x60606060, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0x60606060, 0x30303030, 0x30303030, 0x60606060, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0x60606060, 0x30303030, 0xEFEFEFEF, 0xEFEFEFEF, 0x30303030, 0x60606060, 0xFFFFFFFF,
  0x60606060, 0x10101010, 0xAFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xAFAFAFAF, 0x10101010, 0x60606060,
  0x40404040, 0x40404040, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x40404040, 0x40404040,
  0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP bmUp = {
  8, // XSize
  8, // YSize
  32, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)acUp,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       _aEvent: Keyboard events for animation
*/
static EVENT _aEvent[] = {
  { 198, 136, 100 }, // I
  {  16, 192, 100 }, // Shift
  { 120, 136, 100 }, // T
  {  52, 164, 100 }, // S
  {  94, 220, 100 }, //  
  {  16, 136, 100 }, // Q
  { 172, 136, 100 }, // U
  { 198, 136, 100 }, // I
  { 120, 136, 100 }, // T
  {  68, 136, 100 }, // E
  {  94, 220, 100 }, //  
  {  68, 136, 100 }, // E
  {  26, 164, 100 }, // A
  {  52, 164, 100 }, // S
  {  42, 192, 100 }, // Y
  {  94, 220, 100 }, //  
  { 120, 136, 100 }, // T
  { 224, 136, 100 }, // O
  {  94, 220, 100 }, //  
  { 146, 192, 100 }, // B
  { 172, 136, 100 }, // U
  { 198, 136, 100 }, // I
  { 234, 164, 100 }, // L
  {  78, 164, 100 }, // D
  {  94, 220, 100 }, //  
  {  94, 192, 100 }, // C
  { 224, 136, 100 }, // O
  { 198, 192, 100 }, // M
  { 250, 136, 100 }, // P
  { 234, 164, 100 }, // L
  {  68, 136, 100 }, // E
  {  68, 192, 100 }, // X
  {  94, 220, 100 }, //  
  {  26, 164, 100 }, // A
  { 250, 136, 100 }, // P
  { 250, 136, 100 }, // P
  { 234, 164, 100 }, // L
  { 198, 136, 100 }, // I
  {  94, 192, 100 }, // C
  {  26, 164, 100 }, // A
  { 120, 136, 100 }, // T
  { 198, 136, 100 }, // I
  { 224, 136, 100 }, // O
  { 172, 192, 100 }, // N
  {  52, 164, 100 }, // S
  {  94, 220, 100 }, //  
  {  42, 136, 100 }, // W
  { 198, 136, 100 }, // I
  { 120, 136, 100 }, // T
  { 156, 164, 100 }, // H
  {  94, 220, 100 }, //  
  {  68, 136, 100 }, // E
  { 198, 192, 100 }, // M
  {  16, 192, 100 }, // Shift
  {  42, 136, 100 }, // W
  {  16, 192, 100 }, // Shift
  { 198, 136, 100 }, // I
  { 172, 192, 100 }, // N
  {  16, 192, 100 }, // Shift
  { 250, 192, 100 }, // .
};

/*********************************************************************
*
*       _aButtonProp: Colors for close button of notepad
*/
static BUTTON_SKINFLEX_PROPS _PropsPressed = {
  { 0x008B622C, 0x00BAB09E, 0x00EFD198 },
  { 0x00FCF4E5, 0x00F6E5C4 },
  { 0x00EFD198, 0x00DBB368 },
  BUTTON_SKINFLEX_RADIUS
};

static BUTTON_SKINFLEX_PROPS _PropsFocussed = {
  { 0x00B17F3C, 0x00FBD846, 0x00DFDFDF },
  { 0x00F3F3F3, 0x00ECECEC },
  { 0x00DFDFDF, 0x00D0D0D0 },
  BUTTON_SKINFLEX_RADIUS
};

static BUTTON_SKINFLEX_PROPS _PropsEnabled = {
  { 0x00221443, 0x00CCD3F4, 0x008795DF },
  { 0x009CA9E9, 0x008795DF },
  { 0x006F7ED3, 0x008795DF },
  BUTTON_SKINFLEX_RADIUS
};

static BUTTON_SKINFLEX_PROPS _PropsDisabled = {
  { 0x00B5B2AD, 0x00FCFCFC, 0x00F4F4F4 },
  { 0x00F4F4F4, 0x00F4F4F4 },
  { 0x00F4F4F4, 0x00F4F4F4 },
  BUTTON_SKINFLEX_RADIUS
};

static BUTTON_PROP _aButtonProp[] = {
  { &_PropsPressed,  BUTTON_SKINFLEX_PI_PRESSED  },
  { &_PropsFocussed, BUTTON_SKINFLEX_PI_FOCUSSED },
  { &_PropsEnabled,  BUTTON_SKINFLEX_PI_ENABLED  },
  { &_PropsDisabled, BUTTON_SKINFLEX_PI_DISABLED },
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawCentered
*
* Function description
*   Draws the button bitmap
*/
static void _DrawCentered(WM_HWIN hWin, const GUI_BITMAP * pBM) {
  int xSizeWin;
  int ySizeWin;
  int xSizeBMP;
  int ySizeBMP;
  int xPos;
  int yPos;

  xSizeWin = WM_GetWindowSizeX(hWin);
  ySizeWin = WM_GetWindowSizeY(hWin);
  xSizeBMP = pBM->XSize;
  ySizeBMP = pBM->YSize;
  xPos = (xSizeWin - xSizeBMP) >> 1;
  yPos = (ySizeWin - ySizeBMP) >> 1;
  GUI_DrawBitmap(pBM, xPos, yPos);
}

/*********************************************************************
*
*       _DrawBkSpc
*       _DrawReturn
*       _DrawShift
*/
static void _DrawBkSpc (WM_HWIN hWin) {  _DrawCentered(hWin, &bmBackSpace); }
static void _DrawReturn(WM_HWIN hWin) {  _DrawCentered(hWin, &bmReturn); }
static void _DrawShift (WM_HWIN hWin) {  _DrawCentered(hWin, &bmUp); }

/*********************************************************************
*
*       Static data using function pointers
*
**********************************************************************
*/
static const BUTTON_DATA _aButtonData[] = {
  {   6,   6,  24, 24, "Q" },
  {  32,   6,  24, 24, "W" },
  {  58,   6,  24, 24, "E" },
  {  84,   6,  24, 24, "R" },
  { 110,   6,  24, 24, "T" },
  { 136,   6,  24, 24, "Z" },
  { 162,   6,  24, 24, "U" },
  { 188,   6,  24, 24, "I" },
  { 214,   6,  24, 24, "O" },
  { 240,   6,  24, 24, "P" },
  { 266,   6,  24, 24, "" },
  { 292,   6,  24, 24, "\x8", _DrawBkSpc },
  {  16,  34,  24, 24, "A" },
  {  42,  34,  24, 24, "S" },
  {  68,  34,  24, 24, "D" },
  {  94,  34,  24, 24, "F" },
  { 120,  34,  24, 24, "G" },
  { 146,  34,  24, 24, "H" },
  { 172,  34,  24, 24, "J" },
  { 198,  34,  24, 24, "K" },
  { 224,  34,  24, 24, "L" },
  { 250,  34,  24, 24, "" },
  { 276,  34,  40, 24, "\x0d", _DrawReturn },
  {   6,  62,  24, 24, "\x19", _DrawShift },
  {  32,  62,  24, 24, "Y" },
  {  58,  62,  24, 24, "X" },
  {  84,  62,  24, 24, "C" },
  { 110,  62,  24, 24, "V" },
  { 136,  62,  24, 24, "B" },
  { 162,  62,  24, 24, "N" },
  { 188,  62,  24, 24, "M" },
  { 214,  62,  24, 24, "," },
  { 240,  62,  24, 24, "." },
  { 266,  62,  24, 24, "" },
  { 292,  62,  24, 24, "\x19", _DrawShift },
  {   6,  90,  37, 24, "Ctrl" },
  {  45,  90,  37, 24, "Alt" },
  {  84,  90, 154, 24, " " },
  { 240,  90,  37, 24, "Alt Gr" },
  { 279,  90,  37, 24, "Ctrl" },
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawSkinFlex_BUTTON
*
* Function description
*   Skinning routine for keypad buttons
*/
static int _DrawSkinFlex_BUTTON(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  static GUI_MEMDEV_Handle ahMemEdges[4];
  GUI_MEMDEV_Handle        hMem;
  WM_HWIN                  hWin;
  unsigned                 i;
  int                      xPos;
  int                      yPos;
  int                      xSize;
  int                      ySize;
  int                      x;
  int                      y;
  int                      Id;
  int                      IsPressed;
  void (* pfDraw)(WM_HWIN hWin);

  x = 0;
  y = 0;
  switch (pDrawItemInfo->Cmd) {
  case WIDGET_ITEM_CREATE:
    if (ahMemEdges[0] == 0) {
      //
      // Create small helper window which never becomes visible
      //
      hWin = WM_CreateWindowAsChild(0, 0, 32, 32, WM_HBKWIN, WM_CF_SHOW | WM_CF_STAYONTOP, NULL, 0);
      WM_SelectWindow(hWin);
      //
      // Create memory devices for the edges of the buttons
      //
      for (i = 0; i < GUI_COUNTOF(ahMemEdges); i++) {
        switch (i) {
        case 0:
          x = 0;
          y = 0;
          break;
        case 1:
          x = -16;
          y = 0;
          break;
        case 2:
          x = -16;
          y = -16;
          break;
        case 3:
          x = 0;
          y = -16;
          break;
        }
        //
        // Create magnified device
        //
        hMem = GUI_MEMDEV_CreateFixed(0, 0, 16, 16, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
        GUI_MEMDEV_Select(hMem);
        GUI_SetBkColor(GUI_TRANSPARENT);
        GUI_Clear();
        GUI_SetColor(COLOR_BORDER);
        GUI_DrawRoundedFrame(x, y, x + 31, y + 31, 16, 4);
        //
        // Shrink to required size
        //
        ahMemEdges[i] = GUI_MEMDEV_CreateFixed(0, 0, 4, 4, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
        GUI_MEMDEV_Select(ahMemEdges[i]);
        GUI_SetBkColor(GUI_TRANSPARENT);
        GUI_Clear();
        GUI_MEMDEV_RotateHQ(hMem, ahMemEdges[i], -6, -6, 0, 250);
        GUI_MEMDEV_Delete(hMem);
        GUI_MEMDEV_Select(0);
      }
      WM_DeleteWindow(hWin);
    }
    break;
  case WIDGET_ITEM_DRAW_TEXT:
    //
    // Use private or default function for drawing bitmap or text
    //
    hWin = pDrawItemInfo->hWin;
    Id   = WM_GetId(hWin);
    i    = Id - ID_BUTTON;
    pfDraw = _aButtonData[i].pfDraw;
    if (pfDraw) {
      pfDraw(hWin);
    } else {
      BUTTON_DrawSkinFlex(pDrawItemInfo);
    }
    break;
  case WIDGET_ITEM_DRAW_BACKGROUND:
    //
    // Draw background of button
    //
    IsPressed = BUTTON_IsPressed(pDrawItemInfo->hWin);
    xPos      = WM_GetWindowOrgX(pDrawItemInfo->hWin);
    yPos      = WM_GetWindowOrgY(pDrawItemInfo->hWin);
    xSize     = WM_GetWindowSizeX(pDrawItemInfo->hWin);
    ySize     = WM_GetWindowSizeY(pDrawItemInfo->hWin);
    if (IsPressed) {
      GUI_DrawGradientRoundedV(0, 0, xSize - 1, ySize - 1, 4, BUTTON_COLOR2, BUTTON_COLOR3);
    } else {
      GUI_DrawGradientRoundedV(0, 0, xSize - 1, ySize - 1, 4, BUTTON_COLOR0, BUTTON_COLOR1);
    }
    GUI_SetColor(COLOR_BORDER);
    GUI_DrawHLine(        0, 4, xSize - 5);
    GUI_DrawHLine(ySize - 1, 4, xSize - 5);
    GUI_DrawVLine(        0, 4, ySize - 5);
    GUI_DrawVLine(xSize - 1, 4, ySize - 5);
    GUI_MEMDEV_WriteAt(ahMemEdges[0], xPos +  0, yPos +  0);
    GUI_MEMDEV_WriteAt(ahMemEdges[1], xPos + xSize - 4, yPos +  0);
    GUI_MEMDEV_WriteAt(ahMemEdges[2], xPos + xSize - 4, yPos + 20);
    GUI_MEMDEV_WriteAt(ahMemEdges[3], xPos +  0, yPos + 20);
    break;
  default:
    //
    // Use the default skinning routine for processing all other commands
    //
    return BUTTON_DrawSkinFlex(pDrawItemInfo);
  }
  return 0;
}

/*********************************************************************
*
*       _cbKeyPad
*
* Function description
*   Callback routine of keypad window
*/
static void _cbKeyPad(WM_MESSAGE * pMsg) {
  static int LowerCase;
  WM_HWIN    hWin;
  WM_HWIN    hButton;
  char       c;
  int        Id;
  int        NCode;
  int        xSize;
  int        ySize;
  unsigned   i;

  hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case APP_INIT_LOWERCASE:
    LowerCase = 0;
    break;
  case WM_CREATE:
    //
    // Create the keyboard buttons
    //
    for (i = 0; i < GUI_COUNTOF(_aButtonData); i++) {
      hButton = BUTTON_CreateEx(_aButtonData[i].xPos, _aButtonData[i].yPos, _aButtonData[i].xSize, _aButtonData[i].ySize, 
                                hWin, WM_CF_SHOW | WM_CF_HASTRANS, 0, ID_BUTTON + i);
      BUTTON_SetText(hButton, _aButtonData[i].acLabel);
      BUTTON_SetFocussable(hButton, 0);
    }
    break;
  case WM_PAINT:
    //
    // Draw background
    //
    xSize = WM_GetWindowSizeX(hWin);
    ySize = WM_GetWindowSizeY(hWin);
    GUI_SetColor(COLOR_BORDER);
    GUI_DrawRect(0, 0, xSize - 1, ySize - 1);
    GUI_DrawGradientV(1, 1, xSize - 2, ySize - 2, COLOR_KEYPAD0, COLOR_KEYPAD1);
    break;
  case WM_NOTIFY_PARENT:
    //
    // Send key message to currently focused window
    //
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch (NCode) {
    case WM_NOTIFICATION_RELEASED:
      if (_aButtonData[Id - ID_BUTTON].acLabel) {
        c = _aButtonData[Id - ID_BUTTON].acLabel[0];
        if (c == GUI_KEY_SHIFT) {
          LowerCase ^= 1;
        } else {
          if (LowerCase) {
            c |= 0x20;
          }
          GUI_StoreKeyMsg(c, 1);
          GUI_StoreKeyMsg(c, 0);
        }
      }
      break;
    }
  }
}

/*********************************************************************
*
*       _cbAnimation
*
* Function description
*   Keyboard animation
*/
static void _cbAnimation(WM_MESSAGE * pMsg) {
  GUI_PID_STATE   State = {0};
  static int      Index;
  static int      Pressed;
  WM_HWIN         hWin;
  EVENT         * pEvent;
  int             Delay;

  hWin = pMsg->hWin;
  pEvent = &_aEvent[Index];
  switch (pMsg->MsgId) {
  case WM_TIMER:
    State.x = pEvent->x;
    State.y = pEvent->y;
    Pressed ^= 1;
    State.Pressed = Pressed;
    if (Pressed == 0) {
      Index = (Index == GUI_COUNTOF(_aEvent)) ? 0 : Index + 1;
      Delay = 10;
    } else {
      Delay = pEvent->Delay;
    }
    GUI_PID_StoreState(&State);
    if (Index == GUI_COUNTOF(_aEvent)) {
      //
      // End of animation
      //
      WM_DeleteWindow(hWin);
    } else {
      //
      // Continue...
      //
      WM_RestartTimer(pMsg->Data.v, Delay);
    }
    break;
  case WM_CREATE:
    //
    // Create timer to keep animation alive...
    //
    Index = Pressed = 0;
    WM_CreateTimer(hWin, 0, 1500, 0);
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _cbBk
*
* Function description
*   Drawing of background window
*/
static void _cbBk(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawGradientV(0, 0, 319, 239, COLOR_BACK0, COLOR_BACK1);
    GUI_DrawBitmap(&bmSeggerLogo_160x80, 80, 30);
    GUI_SetFont(&GUI_Font20_AA4);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_SetColor(GUI_WHITE);
    GUI_DispStringHCenterAt("Window effects are the easy to use\n"
                            "solution for animating windows...", 160, 140);
    break;
  }
}

/*********************************************************************
*
*       _BUTTON_DrawSkinFlex
*
* Function description
*   Skinning routine of close button. Uses the default skin but with its own colors
*/
static int _BUTTON_DrawSkinFlex(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  unsigned i;
  int      r;

  //
  // Set user colors
  //
  for (i = 0; i < GUI_COUNTOF(_aButtonProp); i++) {
    BUTTON_GetSkinFlexProps(&_aButtonProp[i].PropOld, _aButtonProp[i].Index);
    BUTTON_SetSkinFlexProps(_aButtonProp[i].pProp,    _aButtonProp[i].Index);
  }
  r = BUTTON_DrawSkinFlex(pDrawItemInfo);
  //
  // Restore colors
  //
  for (i = 0; i < GUI_COUNTOF(_aButtonProp); i++) {
    BUTTON_SetSkinFlexProps(&_aButtonProp[i].PropOld, _aButtonProp[i].Index);
  }
  return r;
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  WM_HWIN hKeypad;
  WM_HWIN hFrame;
  WM_HWIN hMulti;
  WM_HWIN hAnim;
  
  hMulti = 0;
  //
  // Initialize emWin
  //
  WM_SetCreateFlags(WM_CF_MEMDEV);
  GUI_Init();
  WM_SetCallback(WM_HBKWIN, _cbBk);
  GUI_CURSOR_Show();
  //
  // Set widget default settings for keypad
  //
  BUTTON_SetDefaultSkin(_DrawSkinFlex_BUTTON);
  //
  // Create keypad
  //
  hKeypad = WM_CreateWindowAsChild(0, 120, 320, 120, WM_HBKWIN, WM_CF_HIDE | WM_CF_STAYONTOP, _cbKeyPad, 0);
  hFrame = 0;
  while (1) {
    GUI_Delay(2500);
    //
    // Create notepad window on demand
    //
    if (hFrame == 0) {
      //
      // Set widget default settings for notepad
      //
      //BUTTON_SetDefaultSkin(BUTTON_SKIN_FLEX);
      BUTTON_SetDefaultSkin(_BUTTON_DrawSkinFlex);
      FRAMEWIN_SetDefaultSkin(FRAMEWIN_SKIN_FLEX);
      FRAMEWIN_SetDefaultTextAlign(GUI_TA_HCENTER);
      //
      // Create frame window
      //
      hFrame = FRAMEWIN_CreateEx(0, 0, 320, 240, WM_HBKWIN, WM_CF_HIDE, 0, 0, "Notepad", 0);
      FRAMEWIN_SetTextColor(hFrame, GUI_BLACK);
      FRAMEWIN_SetFont(hFrame, &GUI_Font20_AA4);
      FRAMEWIN_SetClientColor(hFrame, GUI_WHITE);
      FRAMEWIN_AddCloseButton(hFrame, FRAMEWIN_BUTTON_RIGHT, 0);
      //
      // Create multi edit widget
      //
      hMulti = MULTIEDIT_CreateEx(0, 0, 0, 0, WM_GetClientWindow(hFrame), WM_CF_SHOW, 0, GUI_ID_MULTIEDIT0, 100, NULL);
      MULTIEDIT_SetWrapWord(hMulti);
      MULTIEDIT_SetFont(hMulti, GUI_FONT_16B_ASCII);
      WM_SetFocus(hMulti);
    }
    //
    // Use effect functions to make editor and keypad visible
    //
    GUI_MEMDEV_ShiftInWindow(hFrame, 500, GUI_MEMDEV_EDGE_LEFT);
    GUI_MEMDEV_ShiftInWindow(hKeypad, 500, GUI_MEMDEV_EDGE_BOTTOM);
    GUI_Delay(500);
    //
    // Do keyboard animation by a hidden animation window which emits PID events
    //
    WM_SendMessageNoPara(hKeypad, APP_INIT_LOWERCASE);
    hAnim = WM_CreateWindowAsChild(0, 0, 1, 1, WM_HBKWIN, WM_CF_HIDE, _cbAnimation, 0);
    do {
      GUI_Delay(100);
    } while (WM_IsWindow(hAnim));
    GUI_Delay(500);
    //
    // Shift out keyboard and notepad window (if exist)
    //
    GUI_MEMDEV_ShiftOutWindow(hKeypad, 500, GUI_MEMDEV_EDGE_BOTTOM);
    if (WM_IsWindow(hFrame)) {
      GUI_MEMDEV_ShiftOutWindow(hFrame, 500, GUI_MEMDEV_EDGE_RIGHT);
      MULTIEDIT_SetText(hMulti, "");
    } else {
      hFrame = 0;
    }
  }
}

/*************************** End of file ****************************/
