/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : MainTask.c
Purpose     : Shows use of Custom Bitmap view.
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stddef.h>
#include "GUI.h"
#include "MainTask.h"

#if GUI_WINSUPPORT
  #include "WM.h"
#endif

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define COLOR_SKY    0xd8aa5d
#define COLOR_GROUND 0x2d93c7
#define AA_FACTOR 6
#define SPEED_MAX_PITCH  (500 * 25)
#define SPEED_MAX_ROLL  (1200 * 25)
#define BUTTON_UP    0
#define BUTTON_DOWN  1
#define BUTTON_LEFT  2
#define BUTTON_RIGHT 3

#define INDEX_LEFT   0
#define INDEX_RIGHT  1
#define INDEX_UP     2
#define INDEX_DOWN   3
#define INDEX_END    4

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  GUI_MEMDEV_Handle hMemMask;          // Mask device for punch operation
  GUI_MEMDEV_Handle hMemScale;         // Content of complete scale
  GUI_MEMDEV_Handle hMemWork;          // Destination device
  GUI_POINT         aPointSrc[3];      // Source points for roll indicator triangle
  GUI_POINT         aPointDst[3];      // Destination points for roll indicator
  GUI_POINT         aPointSrcCL[4];    // Initial coordinates of clearing polygon left
  GUI_POINT         aPointSrcCR[4];    // Initial coordinates of clearing polygon left
  GUI_POINT         aPointDstCL[4];    // Initial coordinates of clearing polygon right
  GUI_POINT         aPointDstCR[4];    // Initial coordinates of clearing polygon right
  GUI_RECT          RectUD;            // Up/down touch area
  GUI_RECT          RectLR;            // Left/right touch area
  I32               Pitch;
  I32               Roll;
  int               xSizeDisplay;
  int               ySizeDisplay;
  int               r;
  int               d;
  int               xm;
  int               ym;
} ANIM_CONTEXT;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
static int _State;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0041[198] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x0E, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xBB, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0x66, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xFF, 0x11, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFB, 0x00, 0xBF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xF7, 0x00, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xF2, 0x00, 0x2F, 0xFD, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xC0, 0x00, 0x0C, 0xFF, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0x00, 0x0D, 0xFF, 0x20, 0x00, 0x02, 0xFF, 0xD0, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x00,
  0x03, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0x30,
  0x08, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x08, 0xFF, 0x80,
  0x0D, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xD0,
  0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xF3,
  0x8F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF8,
  0xDF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0042[176] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFF, 0xEC, 0x93, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x26, 0xEF, 0xFC, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x1F, 0xFB, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x6F, 0xF5, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x38, 0xFF, 0xA0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x50, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x14, 0xAF, 0xFF, 0x40,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xB0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x01, 0x36, 0xDF, 0xFF, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x60, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0043[176] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x03, 0x8C, 0xFF, 0xFD, 0xA5, 0x10,
  0x00, 0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8,
  0x00, 0x1D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xCF, 0xFF, 0xB5, 0x10, 0x03, 0x6B, 0xFF,
  0x07, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x4C,
  0x1E, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x3C,
  0x01, 0xDF, 0xFF, 0xB5, 0x10, 0x03, 0x6B, 0xFF,
  0x00, 0x2E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x02, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0x00, 0x00, 0x03, 0x9C, 0xFF, 0xFD, 0x95, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0049[110] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0056[198] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFC,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7,
  0x2F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xF2,
  0x0C, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xC0,
  0x07, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0x70,
  0x02, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0x20,
  0x00, 0xCF, 0xF4, 0x00, 0x00, 0x00, 0x5F, 0xFC, 0x00,
  0x00, 0x7F, 0xF9, 0x00, 0x00, 0x00, 0x9F, 0xF7, 0x00,
  0x00, 0x2F, 0xFE, 0x00, 0x00, 0x00, 0xEF, 0xF2, 0x00,
  0x00, 0x0B, 0xFF, 0x40, 0x00, 0x04, 0xFF, 0xB0, 0x00,
  0x00, 0x07, 0xFF, 0x90, 0x00, 0x09, 0xFF, 0x70, 0x00,
  0x00, 0x02, 0xFF, 0xE0, 0x00, 0x0E, 0xFF, 0x20, 0x00,
  0x00, 0x00, 0xBF, 0xF4, 0x00, 0x4F, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF9, 0x00, 0x9F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFD, 0x00, 0xEF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0x33, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x88, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xDD, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xFF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6F, 0xFF, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0xFF, 0xB0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0061[112] = { /* code 0061, LATIN SMALL LETTER A */
  0x04, 0x8B, 0xEF, 0xFF, 0xDA, 0x40, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x0D, 0x95, 0x20, 0x01, 0x5D, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x02, 0x69, 0xBC, 0xDF, 0xFF, 0xF0,
  0x02, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x2E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xAF, 0xFF, 0xA6, 0x42, 0x20, 0xFF, 0xF0,
  0xEF, 0xF4, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x03, 0xFF, 0xF0,
  0xDF, 0xFA, 0x30, 0x03, 0x9F, 0xFF, 0xF0,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0B, 0xFF, 0xFF, 0xFF, 0xD3, 0xFF, 0xF0,
  0x00, 0x7C, 0xFF, 0xC7, 0x10, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0063[ 96] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x01, 0x8C, 0xFF, 0xEB, 0x61,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFE,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x1E, 0xFF, 0xE6, 0x10, 0x13, 0x7D,
  0x6F, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0xBF, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0x1E, 0xFF, 0xD6, 0x10, 0x13, 0x7C,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE,
  0x00, 0x02, 0x8C, 0xFF, 0xEB, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0064[161] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x01, 0x8C, 0xFF, 0xD9, 0x2F, 0xFF,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x0D, 0xFF, 0xE6, 0x10, 0x02, 0x4F, 0xFF,
  0x6F, 0xFE, 0x20, 0x00, 0x00, 0x0F, 0xFF,
  0xBF, 0xF7, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x8F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFF,
  0x3F, 0xFF, 0xA3, 0x01, 0x49, 0xFF, 0xFF,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x01, 0xBF, 0xFF, 0xFF, 0xFE, 0x4F, 0xFF,
  0x00, 0x07, 0xCF, 0xFD, 0x81, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0065[112] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x71, 0x00,
  0x00, 0x3D, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1,
  0x0D, 0xFE, 0x73, 0x00, 0x14, 0xCF, 0xF7,
  0x5F, 0xF3, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xF8, 0x31, 0x00, 0x25, 0x8D,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x00, 0x00, 0x6A, 0xDF, 0xFE, 0xC8, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0068[161] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x17, 0xCF, 0xFC, 0x60, 0x00,
  0xFF, 0xF4, 0xDF, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xFF, 0xFF, 0xB5, 0x10, 0x4E, 0xFF, 0xA0,
  0xFF, 0xF7, 0x00, 0x00, 0x05, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0x02, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0069[ 44] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_006D[176] = { /* code 006D, LATIN SMALL LETTER M */
  0xFF, 0xF0, 0x29, 0xEF, 0xD7, 0x10, 0x02, 0x9E, 0xFD, 0x81, 0x00,
  0xFF, 0xF3, 0xEF, 0xFF, 0xFF, 0xB0, 0x3E, 0xFF, 0xFF, 0xFB, 0x00,
  0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xF8, 0xEF, 0xFF, 0xFF, 0xFF, 0x60,
  0xFF, 0xFF, 0x92, 0x02, 0xCF, 0xFF, 0xF9, 0x20, 0x2C, 0xFF, 0xB0,
  0xFF, 0xF3, 0x00, 0x00, 0x4F, 0xFF, 0x30, 0x00, 0x04, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_006E[112] = { /* code 006E, LATIN SMALL LETTER N */
  0xFF, 0xF0, 0x17, 0xCF, 0xFC, 0x60, 0x00,
  0xFF, 0xF4, 0xDF, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xFF, 0xFF, 0xB5, 0x10, 0x4E, 0xFF, 0xA0,
  0xFF, 0xF7, 0x00, 0x00, 0x05, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0x02, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_006F[112] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x02, 0x9D, 0xFF, 0xD9, 0x30, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x1E, 0xFF, 0xC3, 0x00, 0x3C, 0xFF, 0xF1,
  0x7F, 0xFC, 0x10, 0x00, 0x01, 0xCF, 0xF7,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x5F, 0xFB,
  0xEF, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xFE,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x5F, 0xFB,
  0x7F, 0xFD, 0x10, 0x00, 0x01, 0xCF, 0xF7,
  0x1E, 0xFF, 0xC3, 0x00, 0x3C, 0xFF, 0xF1,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x9D, 0xFF, 0xD9, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0070[154] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0xF0, 0x17, 0xCF, 0xFC, 0x71, 0x00,
  0xFF, 0xF5, 0xEF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xFF, 0xFF, 0xA4, 0x10, 0x2A, 0xFF, 0xF3,
  0xFF, 0xF3, 0x00, 0x00, 0x00, 0xBF, 0xF9,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x5F, 0xFC,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x1F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x7F, 0xFA,
  0xFF, 0xF0, 0x00, 0x00, 0x01, 0xEF, 0xF5,
  0xFF, 0xF8, 0x31, 0x01, 0x6D, 0xFF, 0xD0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0x00,
  0xFF, 0xF3, 0x9D, 0xFF, 0xD8, 0x20, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0072[ 80] = { /* code 0072, LATIN SMALL LETTER R */
  0xFF, 0xF0, 0x06, 0xBF, 0xF0,
  0xFF, 0xF2, 0xBF, 0xFF, 0xF0,
  0xFF, 0xFE, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xB5, 0x10, 0x00,
  0xFF, 0xF6, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0073[ 96] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x5B, 0xEF, 0xEC, 0x72, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xCF, 0xFA, 0x20, 0x03, 0x7C, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xFE, 0x95, 0x20, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xFD, 0x81, 0x00,
  0x04, 0xDF, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0x04, 0x7A, 0xEF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x06, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xD8, 0x41, 0x00, 0x39, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x16, 0xAD, 0xFF, 0xEA, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0074[105] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0xDF, 0xFB, 0x20, 0x2B,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF,
  0x00, 0x2E, 0xFF, 0xFF, 0xFF,
  0x00, 0x02, 0x9D, 0xFF, 0xC8
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0075[112] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF1, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF5, 0x00, 0x00, 0x04, 0xFF, 0xF0,
  0xAF, 0xFD, 0x30, 0x14, 0xAF, 0xFF, 0xF0,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xF0,
  0x09, 0xFF, 0xFF, 0xFF, 0xD3, 0xFF, 0xF0,
  0x00, 0x6C, 0xFF, 0xC7, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font36_AA4_0077[176] = { /* code 0077, LATIN SMALL LETTER W */
  0xDF, 0xF3, 0x00, 0x00, 0x03, 0xFF, 0x60, 0x00, 0x00, 0x3F, 0xFD,
  0x9F, 0xF7, 0x00, 0x00, 0x08, 0xFF, 0xB0, 0x00, 0x00, 0x6F, 0xF9,
  0x5F, 0xFA, 0x00, 0x00, 0x0D, 0xFF, 0xF1, 0x00, 0x00, 0x9F, 0xF5,
  0x1F, 0xFE, 0x00, 0x00, 0x3F, 0xFF, 0xF6, 0x00, 0x00, 0xCF, 0xF1,
  0x0C, 0xFF, 0x20, 0x00, 0x8F, 0xBB, 0xFB, 0x00, 0x01, 0xFF, 0xC0,
  0x08, 0xFF, 0x50, 0x00, 0xDF, 0x66, 0xFF, 0x10, 0x03, 0xFF, 0x80,
  0x04, 0xFF, 0x90, 0x03, 0xFF, 0x11, 0xFF, 0x60, 0x07, 0xFF, 0x40,
  0x00, 0xEF, 0xC0, 0x07, 0xFB, 0x00, 0xBF, 0xB0, 0x0A, 0xFF, 0x00,
  0x00, 0xBF, 0xF1, 0x0C, 0xF6, 0x00, 0x6F, 0xF1, 0x0D, 0xFB, 0x00,
  0x00, 0x7F, 0xF4, 0x2F, 0xF1, 0x00, 0x1F, 0xF6, 0x1F, 0xF7, 0x00,
  0x00, 0x2F, 0xF7, 0x7F, 0xB0, 0x00, 0x0B, 0xFB, 0x4F, 0xF3, 0x00,
  0x00, 0x0E, 0xFB, 0xCF, 0x60, 0x00, 0x06, 0xFF, 0x8F, 0xE0, 0x00,
  0x00, 0x09, 0xFE, 0xFF, 0x10, 0x00, 0x01, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x05, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x60, 0x00,
  0x00, 0x01, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x20, 0x00,
  0x00, 0x00, 0xCF, 0xF2, 0x00, 0x00, 0x00, 0x1F, 0xFD, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font36_AA4_CharInfo[21] = {
   {   1,   1,   0,  30,   9, acGUI_Font36_AA4_0020 } /* code 0020, SPACE */
  ,{  18,  22,   0,   8,  18, acGUI_Font36_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  15,  22,   2,   8,  18, acGUI_Font36_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  16,  22,   1,   8,  18, acGUI_Font36_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{   9,  22,   1,   8,  11, acGUI_Font36_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  18,  22,   0,   8,  18, acGUI_Font36_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  13,  16,   1,  14,  16, acGUI_Font36_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  12,  16,   1,  14,  14, acGUI_Font36_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  14,  23,   1,   7,  17, acGUI_Font36_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  14,  16,   1,  14,  16, acGUI_Font36_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{  13,  23,   2,   7,  17, acGUI_Font36_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  22,   2,   8,   7, acGUI_Font36_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{  21,  16,   2,  14,  25, acGUI_Font36_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  13,  16,   2,  14,  17, acGUI_Font36_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  14,  16,   1,  14,  16, acGUI_Font36_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  14,  22,   2,  14,  17, acGUI_Font36_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{   9,  16,   2,  14,  11, acGUI_Font36_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  11,  16,   1,  14,  13, acGUI_Font36_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{  10,  21,   0,   9,  10, acGUI_Font36_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  13,  16,   2,  14,  17, acGUI_Font36_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  22,  16,   0,  14,  22, acGUI_Font36_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop10 = {
   0x0077 /* first character */
  ,0x0077 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[ 20] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop9 = {
   0x0072 /* first character */
  ,0x0075 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[ 16] /* address of first character */
  ,&GUI_Font36_AA4_Prop10 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop8 = {
   0x006D /* first character */
  ,0x0070 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[ 12] /* address of first character */
  ,&GUI_Font36_AA4_Prop9 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop7 = {
   0x0068 /* first character */
  ,0x0069 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[ 10] /* address of first character */
  ,&GUI_Font36_AA4_Prop8 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop6 = {
   0x0063 /* first character */
  ,0x0065 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  7] /* address of first character */
  ,&GUI_Font36_AA4_Prop7 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop5 = {
   0x0061 /* first character */
  ,0x0061 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  6] /* address of first character */
  ,&GUI_Font36_AA4_Prop6 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop4 = {
   0x0056 /* first character */
  ,0x0056 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  5] /* address of first character */
  ,&GUI_Font36_AA4_Prop5 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop3 = {
   0x0049 /* first character */
  ,0x0049 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  4] /* address of first character */
  ,&GUI_Font36_AA4_Prop4 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop2 = {
   0x0041 /* first character */
  ,0x0043 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  1] /* address of first character */
  ,&GUI_Font36_AA4_Prop3 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font36_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_Font36_AA4_CharInfo[  0] /* address of first character */
  ,&GUI_Font36_AA4_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font36_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,36 /* height of font  */
  ,36 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font36_AA4_Prop1}
  ,30 /* Baseline */
  ,16 /* Height of lowercase characters */
  ,22 /* Height of capital characters */
};

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0045[ 48] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0050[ 48] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xEA, 0x30,
  0xF0, 0x00, 0x27, 0xE4,
  0xF0, 0x00, 0x00, 0x5C,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0x79,
  0xF0, 0x00, 0x27, 0xC1,
  0xFF, 0xFF, 0xC7, 0x10,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0052[ 60] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xD7, 0x00, 0x00,
  0xF0, 0x00, 0x39, 0x80, 0x00,
  0xF0, 0x00, 0x02, 0xE0, 0x00,
  0xF0, 0x00, 0x00, 0xF0, 0x00,
  0xF0, 0x00, 0x04, 0xC0, 0x00,
  0xF0, 0x01, 0x4D, 0x40, 0x00,
  0xFF, 0xFF, 0xE3, 0x00, 0x00,
  0xF0, 0x00, 0x97, 0x00, 0x00,
  0xF0, 0x00, 0x0B, 0x40, 0x00,
  0xF0, 0x00, 0x01, 0xC2, 0x00,
  0xF0, 0x00, 0x00, 0x3C, 0x00,
  0xF0, 0x00, 0x00, 0x06, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0063[ 27] = { /* code 0063, LATIN SMALL LETTER C */
  0x04, 0xCF, 0xB1,
  0x3D, 0x30, 0x38,
  0xA6, 0x00, 0x00,
  0xE1, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xE1, 0x00, 0x00,
  0xB5, 0x00, 0x00,
  0x4E, 0x30, 0x37,
  0x05, 0xCF, 0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0064[ 52] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x0F,
  0x00, 0x00, 0x00, 0x0F,
  0x00, 0x00, 0x00, 0x0F,
  0x00, 0x00, 0x00, 0x0F,
  0x01, 0x8E, 0xFE, 0x9F,
  0x1C, 0x71, 0x00, 0x6F,
  0x97, 0x00, 0x00, 0x0F,
  0xE2, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x0F,
  0xA5, 0x00, 0x00, 0x1F,
  0x3D, 0x40, 0x16, 0xDF,
  0x04, 0xBF, 0xFB, 0x3F
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0065[ 36] = { /* code 0065, LATIN SMALL LETTER E */
  0x02, 0xAD, 0xC6, 0x00,
  0x2D, 0x40, 0x2C, 0x50,
  0xA6, 0x00, 0x03, 0xC0,
  0xE1, 0x00, 0x00, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xE0, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0x00, 0x00,
  0x3D, 0x40, 0x04, 0xB0,
  0x03, 0xBF, 0xFC, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0066[ 39] = { /* code 0066, LATIN SMALL LETTER F */
  0x01, 0xBF, 0xF0,
  0x09, 0x80, 0x00,
  0x0E, 0x10, 0x00,
  0x0F, 0x00, 0x00,
  0xFF, 0xFF, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0067[ 48] = { /* code 0067, LATIN SMALL LETTER G */
  0x01, 0x8E, 0xFE, 0x9F,
  0x1C, 0x71, 0x03, 0x3F,
  0x87, 0x00, 0x00, 0x0F,
  0xD2, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x0F,
  0xB5, 0x00, 0x00, 0x0F,
  0x3D, 0x40, 0x15, 0xCF,
  0x04, 0xCF, 0xFC, 0x5F,
  0x00, 0x00, 0x00, 0x1B,
  0x0C, 0x51, 0x02, 0xB5,
  0x05, 0x9F, 0xFB, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0068[ 52] = { /* code 0068, LATIN SMALL LETTER H */
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF2, 0x9E, 0xFD, 0x70,
  0xFC, 0x62, 0x01, 0xA7,
  0xF0, 0x00, 0x00, 0x2E,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0069[ 12] = { /* code 0069, LATIN SMALL LETTER I */
  0xF0,
  0xF0,
  0x00,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006C[ 13] = { /* code 006C, LATIN SMALL LETTER L */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006E[ 36] = { /* code 006E, LATIN SMALL LETTER N */
  0xF2, 0x9E, 0xFD, 0x70,
  0xFC, 0x62, 0x01, 0xA7,
  0xF0, 0x00, 0x00, 0x2E,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006F[ 36] = { /* code 006F, LATIN SMALL LETTER O */
  0x03, 0xBF, 0xFB, 0x30,
  0x3E, 0x50, 0x05, 0xE3,
  0xA6, 0x00, 0x00, 0x6A,
  0xE1, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x1E,
  0xA6, 0x00, 0x00, 0x6A,
  0x3E, 0x50, 0x05, 0xE3,
  0x03, 0xBF, 0xFB, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0070[ 48] = { /* code 0070, LATIN SMALL LETTER P */
  0xF3, 0xAE, 0xFC, 0x40,
  0xFB, 0x51, 0x04, 0xD3,
  0xF0, 0x00, 0x00, 0x5B,
  0xF0, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x2D,
  0xF0, 0x00, 0x00, 0x78,
  0xF5, 0x10, 0x17, 0xC1,
  0xF9, 0xEF, 0xE9, 0x10,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0072[ 27] = { /* code 0072, LATIN SMALL LETTER R */
  0xF1, 0x8E, 0xF0,
  0xFA, 0x40, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0074[ 36] = { /* code 0074, LATIN SMALL LETTER T */
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0xFF, 0xFF, 0xF0,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0C, 0x60, 0x00,
  0x03, 0xDF, 0xE0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0075[ 36] = { /* code 0075, LATIN SMALL LETTER U */
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xF0, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x1F,
  0x48, 0x10, 0x13, 0xBF,
  0x05, 0xDF, 0xE9, 0x2F
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0077[ 54] = { /* code 0077, LATIN SMALL LETTER W */
  0xD2, 0x00, 0x0A, 0x00, 0x02, 0xD0,
  0x96, 0x00, 0x3F, 0x30, 0x05, 0xA0,
  0x69, 0x00, 0x9A, 0x90, 0x08, 0x60,
  0x2D, 0x00, 0xD1, 0xD1, 0x0C, 0x30,
  0x0D, 0x26, 0x80, 0x86, 0x1E, 0x00,
  0x09, 0x5B, 0x30, 0x3C, 0x4A, 0x00,
  0x05, 0xBC, 0x00, 0x0C, 0xA7, 0x00,
  0x01, 0xF6, 0x00, 0x06, 0xF3, 0x00,
  0x00, 0xC1, 0x00, 0x01, 0xE0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0078[ 36] = { /* code 0078, LATIN SMALL LETTER X */
  0xA5, 0x00, 0x05, 0xA0,
  0x1D, 0x10, 0x1D, 0x10,
  0x05, 0xA0, 0x95, 0x00,
  0x00, 0xA9, 0xA0, 0x00,
  0x00, 0x2F, 0x20, 0x00,
  0x00, 0xA9, 0xA0, 0x00,
  0x05, 0xA0, 0xA5, 0x00,
  0x1D, 0x10, 0x1D, 0x10,
  0xA5, 0x00, 0x05, 0xA0
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font20_AA4_CharInfo[20] = {
   {   1,   1,   0,  17,   5, acGUI_Font20_AA4_0020 } /* code 0020, SPACE */
  ,{   8,  12,   0,   5,   9, acGUI_Font20_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{   8,  12,   0,   5,   9, acGUI_Font20_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{   9,  12,   0,   5,  10, acGUI_Font20_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{   6,   9,   0,   8,   7, acGUI_Font20_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{   8,  13,   0,   4,   9, acGUI_Font20_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{   7,   9,   0,   8,   8, acGUI_Font20_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   5,  13,   0,   4,   5, acGUI_Font20_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{   8,  12,   0,   8,   9, acGUI_Font20_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   8,  13,   0,   4,   9, acGUI_Font20_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   1,  12,   1,   5,   4, acGUI_Font20_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   1,  13,   1,   4,   4, acGUI_Font20_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{   8,   9,   0,   8,   9, acGUI_Font20_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{   8,   9,   0,   8,   9, acGUI_Font20_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{   8,  12,   0,   8,   9, acGUI_Font20_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{   5,   9,   0,   8,   6, acGUI_Font20_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   5,  12,   0,   5,   5, acGUI_Font20_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   8,   9,   0,   8,   9, acGUI_Font20_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  11,   9,   0,   8,  12, acGUI_Font20_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   7,   9,   0,   8,   8, acGUI_Font20_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop10 = {
   0x0077 /* first character */
  ,0x0078 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[ 18] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop9 = {
   0x0074 /* first character */
  ,0x0075 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[ 16] /* address of first character */
  ,&GUI_Font20_AA4_Prop10 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop8 = {
   0x0072 /* first character */
  ,0x0072 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[ 15] /* address of first character */
  ,&GUI_Font20_AA4_Prop9 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop7 = {
   0x006E /* first character */
  ,0x0070 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[ 12] /* address of first character */
  ,&GUI_Font20_AA4_Prop8 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop6 = {
   0x006C /* first character */
  ,0x006C /* last character  */
  ,&GUI_Font20_AA4_CharInfo[ 11] /* address of first character */
  ,&GUI_Font20_AA4_Prop7 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop5 = {
   0x0063 /* first character */
  ,0x0069 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[  4] /* address of first character */
  ,&GUI_Font20_AA4_Prop6 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop4 = {
   0x0052 /* first character */
  ,0x0052 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[  3] /* address of first character */
  ,&GUI_Font20_AA4_Prop5 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop3 = {
   0x0050 /* first character */
  ,0x0050 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[  2] /* address of first character */
  ,&GUI_Font20_AA4_Prop4 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop2 = {
   0x0045 /* first character */
  ,0x0045 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[  1] /* address of first character */
  ,&GUI_Font20_AA4_Prop3 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_Font20_AA4_CharInfo[  0] /* address of first character */
  ,&GUI_Font20_AA4_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font20_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,20 /* height of font  */
  ,20 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font20_AA4_Prop1}
  ,17 /* Baseline */
  ,9 /* Height of lowercase characters */
  ,13 /* Height of capital characters */
};

static GUI_CONST_STORAGE unsigned long _acSeggerLogo_120x60[] = {
  0xFF000000, 0xFF000000, 0x7F000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x7F000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0x60000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x60000000, 0xFF000000,
  0x9F000000, 0x00000000, 0x00000000, 0x00101010, 0x00707070, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00707070, 0x00101010, 0x00000000, 0x00000000, 0x9F000000,
  0x30000000, 0x00000000, 0x00101010, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00101010, 0x00000000, 0x30000000,
  0x00000000, 0x00000000, 0x00707070, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00707070, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00B85858, 0x00B85858, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DBABAB, 0x00B85858, 0x00BE6666, 0x00F9F1F1, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D59D9D, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00D59D9D, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BE6666, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F9F1F1, 0x00B24A4A, 0x00A02020, 0x00A02020, 0x00A02020, 0x00AC3C3C, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00EDD5D5, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B85858, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00DBABAB, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00D09090, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CA8282, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C47474, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B24A4A, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00D09090, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E1B9B9, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00C47474, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A62E2E, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00B85858, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00D09090, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 
        0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00E7C7C7, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00D09090, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00B85858, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A62E2E, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 
        0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00B85858, 0x00C47474, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E1B9B9, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B24A4A, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CA8282, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C47474, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E7C7C7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00DFDFDF, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00DBABAB, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00D09090, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00505050, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00606060, 
        0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00808080, 
        0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00303030, 0x008F8F8F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00808080, 0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00404040, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFDFDF, 0x00505050, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00707070, 0x00FFFFFF, 0x00FFFFFF, 0x008F8F8F, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x008F8F8F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00EDD5D5, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B85858, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00101010, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00505050, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00505050, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00303030, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00303030, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00101010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00404040, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00303030, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F9F1F1, 0x00B24A4A, 0x00A02020, 0x00A02020, 0x00A02020, 0x00AC3C3C, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00606060, 0x00CFCFCF, 0x00FFFFFF, 0x00AFAFAF, 0x00303030, 0x00000000, 
        0x00000000, 0x00707070, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00606060, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00303030, 0x00000000, 0x00000000, 
        0x00101010, 0x00808080, 0x00BFBFBF, 0x00BFBFBF, 0x00808080, 0x00000000, 0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00101010, 0x00000000, 0x00000000, 0x00101010, 0x008F8F8F, 0x00BFBFBF, 0x00BFBFBF, 0x00505050, 
        0x00000000, 0x00000000, 0x00000000, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00404040, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00505050, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BE6666, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00505050, 
        0x00404040, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x009F9F9F, 0x00000000, 0x00000000, 0x00000000, 
        0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x009F9F9F, 0x00101010, 0x00000000, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x008F8F8F, 0x00000000, 0x00000000, 0x00101010, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x009F9F9F, 0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00303030, 0x00000000, 0x00000000, 0x008F8F8F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D59D9D, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00D59D9D, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00101010, 0x00606060, 0x009F9F9F, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x008F8F8F, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00606060, 0x00000000, 0x00000000, 0x00505050, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00707070, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00606060, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00202020, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00A02020, 0x00C47474, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00505050, 
        0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00808080, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00101010, 0x00000000, 0x00000000, 0x00303030, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F1F1, 0x00A62E2E, 0x00A02020, 
        0x00A02020, 0x00A02020, 0x00B24A4A, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFDFDF, 0x00606060, 0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00606060, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00404040, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00808080, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00101010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00202020, 0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00E1B9B9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00A62E2E, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFDFDF, 0x00AFAFAF, 0x00707070, 0x00101010, 0x00000000, 
        0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00505050, 0x00000000, 0x00000000, 0x00606060, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00404040, 0x00404040, 0x00101010, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00303030, 0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00707070, 0x00404040, 
        0x00404040, 0x00101010, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00808080, 0x00808080, 0x00808080, 0x00707070, 0x00101010, 0x00000000, 0x00000000, 0x00303030, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7C7C7, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D09090, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00A02020, 0x00DBABAB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00404040, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00202020, 
        0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x008F8F8F, 0x00000000, 0x00000000, 0x00101010, 
        0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00101010, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00707070, 0x00000000, 0x00000000, 0x00202020, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00DFDFDF, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A02020, 0x00A02020, 0x00A02020, 0x00A02020, 
        0x00CA8282, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00606060, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFDFDF, 0x00101010, 
        0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x008F8F8F, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00DFDFDF, 0x00FFFFFF, 0x00EFEFEF, 0x00101010, 0x00000000, 0x00000000, 
        0x00202020, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00303030, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00DFDFDF, 0x00000000, 0x00000000, 0x00000000, 0x00303030, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 
        0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00606060, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00000000, 0x00000000, 0x00000000, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B85858, 0x00A02020, 0x00A02020, 0x00A62E2E, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A02020, 0x00A02020, 0x00A02020, 0x00B24A4A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x009F9F9F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00303030, 0x00202020, 0x00000000, 0x00000000, 
        0x00000000, 0x00303030, 0x00FFFFFF, 0x00FFFFFF, 0x00404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00101010, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x009F9F9F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00000000, 
        0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDD5D5, 0x00B85858, 0x00B85858, 0x00EDD5D5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DBABAB, 0x00B85858, 0x00BE6666, 0x00F9F1F1, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00606060, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00202020, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x00404040, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00202020, 0x00AFAFAF, 0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00202020, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00404040, 0x009F9F9F, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00101010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00101010, 0x00CFCFCF, 0x00FFFFFF, 0x00202020, 
        0x00000000, 0x00101010, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00505050, 0x00000000, 0x00000000, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x009F9F9F, 0x00808080, 0x00808080, 0x00BFBFBF, 0x00DFDFDF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00DFDFDF, 0x00AFAFAF, 0x00808080, 0x008F8F8F, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFCFCF, 0x009F9F9F, 0x00808080, 0x009F9F9F, 0x00CFCFCF, 
        0x00FFFFFF, 0x00FFFFFF, 0x009F9F9F, 0x00BFBFBF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 
        0x00BFBFBF, 0x00DFDFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BFBFBF, 0x00CFCFCF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00808080, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00808080, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00707070, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00707070, 0x00000000, 0x00000000,
  0x30000000, 0x00000000, 0x00101010, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00101010, 0x00000000, 0x30000000,
  0x9F000000, 0x00000000, 0x00000000, 0x00101010, 0x00707070, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 
        0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00707070, 0x00101010, 0x00000000, 0x00000000, 0x9F000000,
  0xFF000000, 0x60000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x60000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x7F000000, 0x20000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20000000, 0x7F000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo_120x60 = {
  120, // xSize
  60, // ySize
  480, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acSeggerLogo_120x60,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _CreateMask
*/
static GUI_MEMDEV_Handle _CreateMask(int xPos, int yPos, int xSize, int ySize, int r) {
  GUI_MEMDEV_Handle hMem;
  int               xm;
  int               ym;

  xm = xPos + xSize / 2;
  ym = yPos + ySize / 2;
  hMem = GUI_MEMDEV_CreateFixed(xPos, yPos, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_8, GUICC_8);
  GUI_MEMDEV_Select(hMem);
  GUI_SetColor(GUI_WHITE);
  GUI_AA_FillCircle(xm, ym, r);
  GUI_MEMDEV_Select(0);
  return hMem;
}

/*********************************************************************
*
*       _CreateScale
*/
static GUI_MEMDEV_Handle _CreateScale(int xm, int r) {
  GUI_MEMDEV_Handle hMemScale;
  GUI_RECT          Rect;
  char              acBuffer[] = "90\0";
  int               x0;
  int               x1;
  int               yPosLine;
  int               xEndLine;
  int               xSizeText;
  int               ySizeText;
  int               xPosScale;
  int               xSizeScale;
  int               ySizeScale;
  int               ym;
  int               i;
  
  xEndLine   = 0;
  xPosScale  = xm - r;
  xSizeScale = r * 2 + 1;
  ySizeScale = (r * 2 + 1) * 3;
  ym         = ySizeScale / 2;
  hMemScale  = GUI_MEMDEV_CreateFixed(xPosScale, 0, xSizeScale, ySizeScale, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUICC_8888);
  GUI_MEMDEV_Select(hMemScale);
  //
  // Sky
  //
  GUI_SetColor(COLOR_SKY);
  GUI_FillRect(xPosScale, 0, xPosScale + xSizeScale - 1, ySizeScale / 2 - 1);
  //
  // Ground
  //
  GUI_SetColor(COLOR_GROUND);
  GUI_FillRect(xPosScale, ySizeScale / 2, xPosScale + xSizeScale - 1, ySizeScale - 1);
  //
  // Scale
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetTextMode(GUI_TM_TRANS);
  xSizeText = GUI_GetStringDistX("XXX");
  ySizeText = GUI_GetFontSizeY();
  GUI_DrawHLine(ym + 0, xPosScale, xPosScale + xSizeScale - 1);
  GUI_DrawHLine(ym + 1, xPosScale, xPosScale + xSizeScale - 1);
  GUI_DrawVLine(xm, 0, ySizeScale - 1);
  for (i = 1; i <= 9 * 4; i++) {
    yPosLine = (i * r) / 12;
    switch (i % 4) {
    case 0:
      xEndLine = r / 3;
      Rect.x0 = xPosScale + xSizeScale / 2 - xEndLine - xSizeText;
      Rect.y0 = ym - yPosLine - ySizeText / 2;
      Rect.x1 = Rect.x0 + xSizeText - 1;
      Rect.y1 = Rect.y0 + ySizeText - 1;
      acBuffer[0] = '0' + i / 4;
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, xEndLine * 2 + xSizeText, 0);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, 0, yPosLine * 2);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, -xEndLine * 2 - xSizeText, 0);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      break;
    case 1:
    case 3:
      xEndLine = r / 12;
      break;
    case 2:
      xEndLine = r / 6;
      break;
    }
    x0 = xPosScale + xSizeScale / 2 - xEndLine;
    x1 = xPosScale + xSizeScale / 2 + xEndLine;
    GUI_DrawHLine(ym + yPosLine + 0, x0, x1);
    GUI_DrawHLine(ym + yPosLine + 1, x0, x1);
    GUI_DrawHLine(ym - yPosLine - 0, x0, x1);
    GUI_DrawHLine(ym - yPosLine - 1, x0, x1);
  }
  GUI_MEMDEV_Select(0);
  return hMemScale;
}

/*********************************************************************
*
*       _InitAnimContext
*/
static int _InitAnimContext(ANIM_CONTEXT * pContext) {
  int xPosWork;
  int yPosWork;
  int xSizeWork;
  int ySizeWork;
  int d;
  I32 SinHQ;
  I32 CosHQ;

  pContext->xSizeDisplay = LCD_GetXSize();
  pContext->ySizeDisplay = LCD_GetYSize();
  pContext->xm           = pContext->xSizeDisplay / 2;
  pContext->ym           = pContext->ySizeDisplay / 2;
  pContext->r            = pContext->ySizeDisplay / 3;
  pContext->d            = pContext->r / 14;
  xPosWork               = pContext->xm - pContext->r * 6 / 7;
  xSizeWork              = (pContext->r * 6 / 7) * 2 + 1;
  yPosWork               = pContext->ym - pContext->r;
  ySizeWork              = pContext->r * 2 + 1;
  pContext->hMemMask     = _CreateMask(xPosWork, yPosWork, xSizeWork, ySizeWork, pContext->r);
  if (pContext->hMemMask == 0) {
    return 1;
  }
  pContext->hMemWork = GUI_MEMDEV_CreateFixed(xPosWork, yPosWork, xSizeWork, ySizeWork, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUICC_8888);
  if (pContext->hMemWork == 0) {
    GUI_MEMDEV_Delete(pContext->hMemMask);
    return 1;
  }
  pContext->hMemScale = _CreateScale(pContext->xm, pContext->r);
  if (pContext->hMemScale == 0) {
    GUI_MEMDEV_Delete(pContext->hMemWork);
    GUI_MEMDEV_Delete(pContext->hMemMask);
    return 1;
  }
  pContext->aPointSrc[0].x = 0;
  pContext->aPointSrc[0].y = (pContext->r + pContext->d * 2) * AA_FACTOR;
  SinHQ = GUI__SinHQ(60000);
  CosHQ = GUI__CosHQ(60000);
  //
  // Roll indicator
  //
  pContext->aPointSrc[1].x = pContext->aPointSrc[0].x - (((CosHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[1].y = pContext->aPointSrc[0].y - (((SinHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[2].x = pContext->aPointSrc[0].x + (((CosHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[2].y = pContext->aPointSrc[1].y;
  //
  // Polygon for clearing left side of indicator
  //
  pContext->aPointSrcCL[0].x = pContext->aPointSrc[0].x;
  pContext->aPointSrcCL[0].y = pContext->aPointSrc[0].y;
  pContext->aPointSrcCL[1].x = pContext->aPointSrc[1].x;
  pContext->aPointSrcCL[1].y = pContext->aPointSrc[1].y - 4;
  pContext->aPointSrcCL[2].x = pContext->aPointSrcCL[1].x - AA_FACTOR * 4;
  pContext->aPointSrcCL[2].y = pContext->aPointSrcCL[1].y;
  pContext->aPointSrcCL[3].x = pContext->aPointSrcCL[0].x - AA_FACTOR * 4;
  pContext->aPointSrcCL[3].y = pContext->aPointSrcCL[0].y;
  //
  // Polygon for clearing right side of indicator
  //
  pContext->aPointSrcCR[0].x = pContext->aPointSrc[0].x;
  pContext->aPointSrcCR[0].y = pContext->aPointSrc[0].y;
  pContext->aPointSrcCR[1].x = pContext->aPointSrc[2].x;
  pContext->aPointSrcCR[1].y = pContext->aPointSrc[2].y - 4;
  pContext->aPointSrcCR[2].x = pContext->aPointSrcCR[1].x + AA_FACTOR * 4;
  pContext->aPointSrcCR[2].y = pContext->aPointSrcCR[1].y;
  pContext->aPointSrcCR[3].x = pContext->aPointSrcCR[0].x + AA_FACTOR * 4;
  pContext->aPointSrcCR[3].y = pContext->aPointSrcCR[0].y;
  //
  // Calculate button areas
  //
  d                   = pContext->xSizeDisplay / 16;
  pContext->RectLR.x0 = d * 0 + 10;
  pContext->RectLR.x1 = pContext->RectLR.x0 + d * 3;
  pContext->RectUD.x1 = pContext->xSizeDisplay - pContext->RectLR.x0 - 1;
  pContext->RectUD.x0 = pContext->RectUD.x1 - (pContext->RectLR.x1 - pContext->RectLR.x0);
  d                   = pContext->ySizeDisplay / 16;
  pContext->RectLR.y0 = d * 4;
  pContext->RectLR.y1 = pContext->RectLR.y0 + d * 4;
  pContext->RectUD.y1 = pContext->RectLR.y1;
  pContext->RectUD.y0 = pContext->RectLR.y0;
  return 0;
}

/*********************************************************************
*
*       _ShowAttitudeIndicator
*/
static void _ShowAttitudeIndicator(ANIM_CONTEXT * pContext) {
  float a;
  int   dx;
  int   dy;
  int   mx;
  int   my;
  int   mxCross;
  int   myCross;
  int   xSizeScale;
  int   ySizeScale;
  int   xPosWork;
  int   yPosWork;
  int   xSizeWork;
  int   ySizeWork;
  I32   sinHQ;
  I32   cosHQ;

  //
  // Rotate memory device in HR mode
  //
  xSizeScale = GUI_MEMDEV_GetXSize(pContext->hMemScale);
  ySizeScale = GUI_MEMDEV_GetYSize(pContext->hMemScale);
  xPosWork   = GUI_MEMDEV_GetXPos(pContext->hMemWork);
  yPosWork   = GUI_MEMDEV_GetYPos(pContext->hMemWork);
  xSizeWork  = GUI_MEMDEV_GetXSize(pContext->hMemWork);
  ySizeWork  = GUI_MEMDEV_GetYSize(pContext->hMemWork);
  sinHQ      = GUI__SinHQ(pContext->Roll);
  cosHQ      = GUI__CosHQ(pContext->Roll);
  dx         = ((((ySizeScale * 4) * (I32)pContext->Pitch) / 90000) * sinHQ) >> 16;
  dy         = ((((ySizeScale * 4) * (I32)pContext->Pitch) / 90000) * cosHQ) >> 16;
  mx         = -(xSizeScale - xSizeWork) * 4;
  my         = -(ySizeScale - ySizeWork) * 4;
  mxCross    = xPosWork + xSizeWork / 2;
  myCross    = yPosWork + ySizeWork / 2;
  GUI_MEMDEV_RotateHQHR(pContext->hMemScale, pContext->hMemWork, mx + dx, my + dy, pContext->Roll, 1000);
  //
  // Punch out area defined in mask device
  //
  GUI_SetBkColor(GUI_BLACK);
  GUI_MEMDEV_PunchOutDevice(pContext->hMemWork, pContext->hMemMask);
  //
  // Draw black cross in center of device
  //
  GUI_MEMDEV_Select(pContext->hMemWork);
  GUI_SetColor(GUI_BLACK);
  GUI_SetPenSize(3);
  GUI_DrawLine(mxCross - 10, myCross, mxCross + 10, myCross);
  GUI_DrawLine(mxCross, myCross - 10, mxCross, myCross + 10);
  //
  // Show the result
  //
  GUI_MEMDEV_Select(0);
  GUI_MEMDEV_Write(pContext->hMemWork);
  //
  // Enable hires antialiasing
  //
  GUI_AA_EnableHiRes();
  GUI_AA_SetFactor(AA_FACTOR);
  a = (pContext->Roll * 3.1415926f) / 180000;
  //
  // Clear right, left and top side of roll indicator
  //
  GUI_SetColor(GUI_BLACK);
  GUI_RotatePolygon(pContext->aPointDstCL, pContext->aPointSrcCL, GUI_COUNTOF(pContext->aPointDstCL), a);
  GUI_AA_FillPolygon(pContext->aPointDstCL, GUI_COUNTOF(pContext->aPointDstCL), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
  GUI_RotatePolygon(pContext->aPointDstCR, pContext->aPointSrcCR, GUI_COUNTOF(pContext->aPointDstCR), a);
  GUI_AA_FillPolygon(pContext->aPointDstCR, GUI_COUNTOF(pContext->aPointDstCR), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
  mx = pContext->xSizeDisplay / 2 * AA_FACTOR;
  my = pContext->ySizeDisplay / 2 * AA_FACTOR;
  GUI_SetColor(GUI_BLACK);
  GUI_SetPenSize(2);
  GUI_AA_DrawLine(mx + pContext->aPointDstCL[1].x, my + pContext->aPointDstCL[1].y, mx + pContext->aPointDstCR[1].x, my + pContext->aPointDstCR[1].y);
  //
  // Draw roll indicator
  //
  GUI_SetColor(GUI_WHITE);
  GUI_RotatePolygon(pContext->aPointDst, pContext->aPointSrc, GUI_COUNTOF(pContext->aPointDst), (pContext->Roll * 3.1415926f) / 180000);
  GUI_AA_FillPolygon(pContext->aPointDst, GUI_COUNTOF(pContext->aPointDst), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
}

/*********************************************************************
*
*       _DrawScale
*/
static void _DrawScale(ANIM_CONTEXT * pAnim) {
  int i, a, xm, ym, rm, x0, y0, x1, x2, y1, r0, r1, s; 
  I32 SinHQ;
  I32 CosHQ;

  GUI_AA_EnableHiRes();
  GUI_AA_SetFactor(AA_FACTOR);
  //
  // Draw markers
  //
  GUI_SetPenSize(3);
  r0 = pAnim->r + pAnim->d * 2 + 2;
  r1 = pAnim->r + pAnim->d * 4;
  for (i = 10; i <= 60; i += 10) {
    a = (270 + i) * 1000;
    SinHQ = GUI__SinHQ(a);
    CosHQ = GUI__CosHQ(a);
    y0    = pAnim->ym - ((SinHQ * r0) >> 16);
    y1    = pAnim->ym - ((SinHQ * r1) >> 16);
    x0    = pAnim->xm + ((CosHQ * r0) >> 16);
    x1    = pAnim->xm + ((CosHQ * r1) >> 16);
    GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
    x0 = pAnim->xm - ((CosHQ * r0) >> 16);
    x1 = pAnim->xm - ((CosHQ * r1) >> 16);
    GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
  }
  //
  // Draw center
  //
  GUI_SetPenSize(2);
  SinHQ = GUI__SinHQ(60000);
  CosHQ = GUI__CosHQ(60000);
  s     = (pAnim->d * 3) / 2;
  x0    = pAnim->xm;
  y0    = pAnim->ym + r0;
  y1    = y0 + ((SinHQ * s) >> 16);
  x1    = x0 + ((CosHQ * s) >> 16);
  x2    = x0 - ((CosHQ * s) >> 16);
  GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x2 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DrawLine(x1 * AA_FACTOR, y1 * AA_FACTOR, x2 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DisableHiRes();
  //
  // Draw text
  //
  GUI_SetPenSize(4);
  GUI_SetTextMode(GUI_TM_TRANS);
  rm = r1 + pAnim->d * 3;
  for (i = 30; i <= 60; i += 30) {
    a = (270 + i) * 1000;
    SinHQ = GUI__SinHQ(a);
    CosHQ = GUI__CosHQ(a);
    ym    = pAnim->ym - ((SinHQ * rm) >> 16);
    xm    = pAnim->xm + ((CosHQ * rm) >> 16);
    GUI_GotoXY(xm, ym);
    GUI_SetTextAlign(GUI_TA_HCENTER | GUI_TA_VCENTER);
    GUI_DispDecMin(i);
    xm = pAnim->xm - ((CosHQ * rm) >> 16);
    GUI_GotoXY(xm, ym);
    GUI_SetTextAlign(GUI_TA_HCENTER | GUI_TA_VCENTER);
    GUI_DispDecMin(i);
  }
}

/*********************************************************************
*
*       APP_cbKey
*/
void APP_cbKey(int KeyIndex, int State) {
  if (State) {
    _State |= (1 << KeyIndex);
  } else {
    _State &= ~(1 << KeyIndex);    
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  ANIM_CONTEXT  Context;
  I32           SpeedPitch;
  I32           SpeedRoll;
  int           Step;
  int           t0;
  int           tNow;
  int           tUsed;
  int           tNext;

  GUI_Init();
  GUI_SetFont(GUI_FONT_20_ASCII);
  if (_InitAnimContext(&Context)) {
    return;
  }
  _DrawScale(&Context);
  GUI_DrawBitmap(&bmSeggerLogo_120x60, 675, 415);
  GUI_SetFont(&GUI_Font36_AA4);
  GUI_SetTextAlign(GUI_TA_VCENTER);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("Attitude Indicator with Custom Bitmap View", Context.xSizeDisplay / 2, 5 + bmSeggerLogo_120x60.YSize / 2);
  GUI_SetFont(&GUI_Font20_AA4);
  GUI_DispStringAt("Roll left",  5, 56);
  GUI_DispStringAt("Roll right", 5, 144);
  GUI_DispStringAt("Pitch down", 5, 232);
  GUI_DispStringAt("Pitch up",   5, 320);
  GUI_DispStringAt("Exit",       5, 452);
  #if GUI_WINSUPPORT
    WM_SetWindowPos(WM_HBKWIN, 0, 0, Context.xSizeDisplay, Context.ySizeDisplay);
  #endif
  Step          = 50;
  Context.Pitch = 0;
  Context.Roll  = 0;
  SpeedPitch    = 750;  // Millidegrees / s
  SpeedRoll     = 1250; // Millidegrees / s
  t0            = GUI_GetTime();
  do {
    //
    // Draw attitude indicator
    //
    tNext = t0 + 40;
    GUI_MULTIBUF_Begin();
    _ShowAttitudeIndicator(&Context);
    GUI_MULTIBUF_End();
    tNow = GUI_GetTime();
    if (tNext > tNow) {
      GUI_X_Delay(tNext - tNow);
    }
    tUsed = GUI_GetTime() - t0;
    //
    // Manage hardkey input
    //
    if (_State & (1 << INDEX_LEFT)) {
      SpeedRoll  -= Step;
    }
    if (_State & (1 << INDEX_RIGHT)) {
      SpeedRoll  += Step;
    }
    if (_State & (1 << INDEX_UP)) {
      SpeedPitch -= Step;
    }
    if (_State & (1 << INDEX_DOWN)) {
      SpeedPitch += Step;
    }
    //
    // Check boundaries
    //
    if (SpeedRoll > +SPEED_MAX_ROLL) {
      SpeedRoll = +SPEED_MAX_ROLL;
    }
    if (SpeedRoll < -SPEED_MAX_ROLL) {
      SpeedRoll = -SPEED_MAX_ROLL;
    }
    if (SpeedPitch > +SPEED_MAX_PITCH) {
      SpeedPitch = +SPEED_MAX_PITCH;
    }
    if (SpeedPitch < -SPEED_MAX_PITCH) {
      SpeedPitch = -SPEED_MAX_PITCH;
    }
    //
    // Change pitch and roll in dependence of speed
    //
    Context.Pitch += SpeedPitch * tUsed / 1000;
    Context.Roll  += SpeedRoll  * tUsed / 1000;
    if (Context.Pitch < -60000) {
      Context.Pitch = -60000;
      SpeedPitch    = -SpeedPitch;
    }
    if (Context.Pitch > +60000) {
      Context.Pitch = +60000;
      SpeedPitch    = -SpeedPitch;
    }
    if (Context.Roll < -60000) {
      Context.Roll = -60000;
      SpeedRoll    = -SpeedRoll;
    }
    if (Context.Roll > 60000) {
      Context.Roll = 60000;
      SpeedRoll    = -SpeedRoll;
    }
    t0 = tNow;
  } while (!(_State & (1 << INDEX_END)));
}

/*************************** End of file ****************************/
