/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : MULTILAYER_AlphaChromaMove.c
Purpose     : Multi layer sample
Requirements: WindowManager - (x)
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"
#include "DIALOG.h"
#include "LCD_SIM.h"

#ifdef WIN32
  #include "SIM.h"
#endif

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  int LayerIndex;
  int xMin;
  int yMin;
  int xMax;
  int yMax;
  int xPos;
  int yPos;
  int xAdd;
  int yAdd;
  int Alpha;
  int AlphaAdd;
} ANIMATION_CONTEXT;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmToucan
*
* Function description
*   Toucan with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acToucan[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x2D447278, 0x3422384A, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x0027154C, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x006D627D, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x004A4062, 0x004A4062, 0x004A4062, 0x002E3255, 
        0x004A4062, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00222248, 0x0022003D, 0x001C003B, 0x002B0048, 0x00383B5F, 
        0x1B2B3B55, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x3422384A, 0x004A4062, 0x002E3255, 0x00485263, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 
        0x00575970, 0x00485263, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220040, 0x001C003B, 0x001C003B, 0x002E3255, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x3422384A, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002B0048, 
        0x001C0046, 0x00220042, 0x001C003D, 0x0015002E, 0x001C0035, 0x002B0048, 0x1B2B3B55, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x2D447278, 0x00575970, 0x004A4062, 0x006D627D, 0x00787283, 0x00787283, 0x00787283, 0x00485263, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x00485263, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x002E3255, 0x006D627D, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00787283, 0x00787283, 0x002E3255, 0x00575970, 0x00B6A7AC, 0x00787283, 0x00575970, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 
        0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00575970, 0x00485263, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x0022003D, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003B, 0x003D5783, 0x8B224040, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x2D447278, 0x00575970, 0x00383B5F, 0x0027154C, 0x00948490, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x001C0046, 
        0x00220042, 0x001C003D, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x003D5783, 0x8B224040, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 
        0x37001535, 0x00948490, 0x002E3255, 0x00222248, 0x0027154C, 0x00383B5F, 0x004A4062, 0x00575970, 0x00485263, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x0027154C, 0x00220040, 0x00220042, 
        0x00220042, 0x00220042, 0x001C003B, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0035, 0x001C003B, 0x00272E90, 0x8B224040, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x004A4062, 0x0027154C, 0x00220042, 
        0x002E3255, 0x00274057, 0x0027154C, 0x0027154C, 0x002E3255, 0x00383B5F, 0x0027154C, 0x002E3255, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00485263, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00485263, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x001C003D, 0x001C003B, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00220035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0038, 0x00220040, 0x00B6A7AC, 0xF5000000, 0xF6000000, 0xF8000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x002B0048, 0x00220040, 0x00220040, 0x0027154C, 0x0022003D, 
        0x002276A3, 0x002287AD, 0x00225A6F, 0x00383B5F, 0x00485263, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x004A4062, 0x00575970, 0x00575970, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x006D627D, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002B0048, 0x00220040, 0x0022003D, 0x001C003B, 0x001C003B, 0x37001535, 0x37001535, 
        0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x1515153D, 0x001C0066, 0xED000000, 0xEF000000, 0xF1000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xF9000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x001C003D, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x001C7EC8, 0x001CD2FC, 0x0046BED8, 0x00427B7F, 0x00575970, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00383B5F, 0x002B0048, 0x002B0048, 0x01273250, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x74000015, 0xCB000000, 0xCB000000, 
        0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD8000000, 0xDA000000, 0x37001535, 0xE2000000, 0xE4000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF1000000, 0xF4000000, 
        0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x1515153D, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003D, 0x002E3255, 0x002E3255, 
        0x001C7EC8, 0x001CE0FB, 0x0032E6FA, 0x0046BED8, 0x004C9987, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x004A4062, 0x00222248, 0x0027154C, 0x1515153D, 0x37001535, 0xCD000000, 0xCB000000, 0xC6000000, 0xC3000000, 0xC0000000, 0xBD000000, 0xBB000000, 0xBB000000, 0xB9000000, 0xB7000000, 0xB7000000, 
        0xB6000000, 0xB6000000, 0xB6000000, 0xB7000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCD000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE4000000, 0xE8000000, 0xEC000000, 
        0xF0000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00220042, 0x001C003D, 0x001C0038, 0x001C003D, 0x001C0066, 0x01221C8D, 0x001C0066, 0x0027154C, 0x001C003D, 0x00220040, 0x00575970, 
        0x001C7EC8, 0x0022E4FC, 0x0040EDFC, 0x007AF0F5, 0x006DEDD4, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00383B5F, 0x00222248, 0x00222248, 0x37001535, 0xCB000000, 0xC6000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB6000000, 0xB1000000, 0xAF000015, 0xAB000000, 0xAB000000, 0xA7000000, 0xA4000000, 0xA4000000, 0xA2000015, 0xA2000015, 
        0xA1000000, 0xA1000000, 0xA1000000, 0xA2000015, 0xA4000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD5000000, 0xDB000000, 0xE2000000, 
        0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x94001C15, 0x00220040, 0x001C003D, 0x001C003B, 0x001C0046, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x01221C8D, 0x001C0066, 0x00575970, 
        0x001C7EC8, 0x0022E9FF, 0x0040EDFC, 0x007AF0F5, 0x007AF0F5, 0x00C6BEC2, 0x00B6A7AC, 0x00C6BEC2, 0x006D627D, 0x00485263, 0x004A4062, 0x004A4062, 0x004A4062, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00575970, 0x002E3255, 
        0x1515153D, 0x74000015, 0xC8000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB3000015, 0xAE000000, 0xAB000000, 0xA4000000, 0xA1000000, 0x9E000015, 0x9A000015, 0x98000000, 0x95000000, 0x91000000, 0x91000000, 0x8E000000, 0x8E000000, 0x8E000000, 
        0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000000, 0x98000000, 0x9C000000, 0xA1000000, 0xA7000015, 0xAB000000, 0xB1000000, 0xB7000000, 0xBD000000, 0xC4000000, 0xCC000000, 0xD3000000, 
        0xDB000000, 0xE2000000, 0xE9000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x00222248, 0x001C003D, 0x001C0035, 0x001C003B, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x002B387A, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222E8D, 0x00787283, 
        0x002287AD, 0x0032EBFF, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00575970, 0x004A4062, 0x0027154C, 0x1515153D, 0x3422384A, 0xC8000000, 
        0xC1000000, 0xBB000000, 0xB5000000, 0xAF000015, 0xA7000015, 0xA4000000, 0x9E000015, 0x98000000, 0x95000000, 0x91000000, 0x8E000000, 0x8B000000, 0x88000000, 0x85000000, 0x83000000, 0x80000000, 0x80000000, 0x7D000000, 0x7D000000, 0x7D000000, 
        0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x80000000, 0x83000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x94001515, 0x98000000, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC4000000, 
        0xCD000000, 0xD8000000, 0xDF000000, 0xE7000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0027154C, 0x001C003D, 0x00150038, 0x00150035, 0x0027154C, 0x001C7EC8, 0x001C7EC8, 0x001C0066, 0x00575970, 0x006D627D, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x001C0066, 
        0x003D5783, 0x002BC5F0, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x00787283, 0x00485263, 0x004A4062, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x1515153D, 0x37001535, 0xCB000000, 0xC4000000, 0xBB000000, 0xB5000000, 
        0xAE000000, 0xA7000015, 0xA2000015, 0x9A000015, 0x95000000, 0x90000015, 0x8B000000, 0x88000000, 0x83000000, 0x80000000, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x73000000, 0x73000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 
        0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x7D000000, 0x80000000, 0x83000000, 0x88000015, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB5000000, 
        0xC0000000, 0xCB000000, 0xD3000000, 0xDE000000, 0xE7000000, 0xEF000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x00220042, 0x001C0035, 0x00150035, 0x0015002E, 0x001C0066, 0x001C7EC8, 0x00222B99, 0x001C005A, 0x00575970, 0x006D627D, 0x00222E8D, 0x001C7EC8, 0x00222B99, 0x001C005A, 
        0x00383B5F, 0x0046BED8, 0x001CD2FC, 0x002BC5F0, 0x001CCCFA, 0x002BC5F0, 0x0040818E, 0x00383B5F, 0x002B0048, 0x002B0048, 0x002B0048, 0x001C0046, 0x1515153D, 0x74000015, 0xCB000000, 0xC3000000, 0xB9000000, 0xB1000000, 0xA7000015, 0xA2000015, 
        0x9A000015, 0x94001515, 0x8E000000, 0x88000000, 0x83000000, 0x7F001515, 0x7A000015, 0x79000000, 0x74000015, 0x70000000, 0x70000000, 0x6C000000, 0x6C000000, 0x6A000000, 0x69000000, 0x67000000, 0x67000000, 0x66000000, 0x66000000, 0x66000000, 
        0x66000000, 0x67000000, 0x67000000, 0x69000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x7A000015, 0x7D000000, 0x81000015, 0x88000015, 0x8E000000, 0x94001515, 0x9E000015, 0xA7000015, 
        0xB1000000, 0xBD000000, 0xC9000000, 0xD5000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x1515153D, 0x001C0038, 0x0015002E, 0x0015002E, 0x00150035, 0x001C0066, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x001C0066, 0x00223D66, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x002E3255, 0x0046BED8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x0046BED8, 0x003B7E72, 0x00575970, 0x002E3255, 0x002B0048, 0x1515153D, 0x74000015, 0xC0000000, 0xB9000000, 0xAF000015, 0xA7000015, 0x9E000015, 0x95000015, 0x8E000000, 
        0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x19222250, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x00575970, 0x00575970, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 
        0x63000000, 0x63000000, 0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x94001515, 0x9E000015, 
        0xA7000015, 0xB3000015, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x19222250, 0x00220040, 0x001C0035, 0x00150035, 0x0015002E, 0x00150035, 0x001C0066, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x0027154C, 0x001C7EC8, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x00575970, 0x002E3255, 0x1515153D, 0xBD000000, 0xB5000000, 0xAE000000, 0x292E675C, 0x003D5783, 0x00222E8D, 0x00272E90, 0x00272E90, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00272E90, 0x00272E90, 0x00222E8D, 0x00222E8D, 0x00222E8D, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x003D5783, 0x003D5783, 0x003D5783, 0x003D5783, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 
        0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x90000015, 0x98000000, 
        0xA2000015, 0xAB000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xE0000000, 0xEA000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x0015002E, 0x0015002E, 0x0015002E, 0x00150035, 0x002B387A, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x00272E90, 
        0x001C0046, 0x001C7EC8, 0x001CE0FB, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x003D5783, 0x00223D66, 0x002B387A, 0x002276A3, 0x002276A3, 0x001C7EC8, 0x002276A3, 0x00222B99, 0x00222E8D, 0x002B387A, 0x001C0066, 0x00383B5F, 0x00383B5F, 0x00485263, 
        0x00575970, 0x00575970, 0x00485263, 0x004A4062, 0x00485263, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C005A, 0x002B387A, 0x003D5783, 
        0x003D5783, 0x003D5783, 0x1B2B3B55, 0x2D447278, 0x292E675C, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x81000015, 0x83000000, 0x85000000, 0x88000000, 0x8B001515, 0x90000015, 0x94001515, 0x9A000015, 
        0xA2000015, 0xAB000015, 0xB9000000, 0xC4000000, 0xD0000000, 0xDD000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C0038, 0x00150035, 0x0015002E, 0x0015002E, 0x001C0046, 0x00222B99, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 
        0x02221C46, 0x00222B99, 0x007AF0F5, 0x0378C6BE, 0x0040818E, 0x00223D66, 0x00223D66, 0x001C005A, 0x00223D66, 0x00383B5F, 0x00575970, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x002E3255, 
        0x002B0048, 0x00220042, 0x00220040, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 
        0x001C003D, 0x0027154C, 0x002E3255, 0x00223D66, 0x002B387A, 0x00226D89, 0x00575970, 0x59224244, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x90000015, 0x91000000, 0x95000000, 0x95000000, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 
        0xAB000015, 0xB3000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xDE000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x00220040, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x00226D89, 0x001C005A, 0x00223D66, 0x00383B5F, 0x002B545D, 0x00787283, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x004A4062, 0x0027003D, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 
        0x001C0035, 0x001C0038, 0x001C0038, 0x00220035, 0x00220035, 0x00220035, 0x001C0038, 0x00220035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x001C0035, 0x001C0035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 
        0x0015002E, 0x0015002E, 0x001C0035, 0x0015002E, 0x001C0038, 0x001C003B, 0x00383B5F, 0x00485263, 0x00575970, 0x59224244, 0x9E000015, 0xA1000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xA7000000, 0xAB000000, 0xAB000000, 0xAE000000, 0xB1000000, 
        0xB5000000, 0xBB000000, 0xC4000000, 0xCD000000, 0xD8000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x00220042, 0x001C0038, 0x001C0038, 0x00150035, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CADF5, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 
        0x002287AD, 0x00787283, 0x0378C6BE, 0x00C6BEC2, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x003D5783, 0x00222248, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0038, 0x00220035, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0035, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x001C0035, 0x001C0035, 0x002B0048, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x0015002E, 0x001C0038, 0x00150035, 
        0x00150035, 0x00150035, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0046, 0x00383B5F, 0x3422384A, 0xB5000000, 0xB7000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xBD000000, 0xC1000000, 
        0xC4000000, 0xC9000000, 0xCE000000, 0xD6000000, 0xDD000000, 0xE5000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x00220040, 0x001C0035, 0x001C0066, 0x001C7EC8, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0032E6FA, 0x0032EBFF, 0x0022E6FE, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 
        0x002287AD, 0x004A4062, 0x001C7EC8, 0x007AF0F5, 0x007AF0F5, 0x001CADF5, 0x001CADF5, 0x001C7EC8, 0x00226D89, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0038, 
        0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003D, 0x001C003D, 0x001C003D, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00222248, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 
        0x00383B5F, 0x00383B5F, 0x00274057, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x01273250, 0x00222248, 0x00220040, 0x00222248, 0x19222250, 0xC9000000, 0xCB000000, 0xCC000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD0000000, 
        0xD3000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE5000000, 0xEB000000, 0xF0000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x001C0035, 0x00150038, 0x00222B99, 0x001C84E6, 0x001CADF5, 0x001CCBFB, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0040EDFC, 0x0040EDFC, 0x0022E9FF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 
        0x002EC3B9, 0x00220042, 0x00222B99, 0x001CD2FC, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00274057, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x0027003D, 0x001C0038, 
        0x0022003D, 0x001C003B, 0x00220040, 0x0022003D, 0x00220040, 0x00220042, 0x001C0046, 0x0027154C, 0x00383B5F, 0x004A4062, 0x004A4062, 0x00485263, 0x292E675C, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x1B2B3B55, 0x1B2B3B55, 0xAE000000, 
        0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0x74000015, 0x3422384A, 0x00274057, 0x3422384A, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDD000000, 0xDE000000, 0xDF000000, 
        0xE2000000, 0xE3000000, 0xE5000000, 0xE9000000, 0xED000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x0022003D, 0x001C0038, 0x001C0038, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x0022E4FC, 
        0x0046BED8, 0x001C0046, 0x001C005A, 0x001C84E6, 0x002BC5F0, 0x002BC5F0, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00225A6F, 0x001C003D, 0x001C003D, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003B, 0x00220042, 
        0x00220040, 0x0027154C, 0x002E3255, 0x004A4062, 0x00575970, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x81000015, 0x88000000, 0x8E000000, 0x91000000, 0x98000000, 0x9E000015, 0xA2000015, 0xAB000000, 0xAE000000, 0xB3000015, 0xB9000000, 
        0xBB000000, 0xC0000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF3000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C0035, 0x001C0035, 0x001C003B, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0022E4FC, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 0x001CD2FC, 
        0x002BC5F0, 0x00225565, 0x00220040, 0x00222E8D, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001CADF5, 0x00225A6F, 0x00220040, 0x001C0038, 0x0022003D, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x002B0048, 0x002E3255, 0x002E3255, 
        0x19222250, 0x1B2B3B55, 0x3422384A, 0x66000000, 0x6C000000, 0x70000015, 0x79000000, 0x7F001515, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0xA1000000, 0xA4000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBB000000, 
        0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCC000000, 0xD0000000, 0xD3000000, 0xD5000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xE9000000, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xF1000000, 0xF2000000, 0xF4000000, 0xF5000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C003B, 0x001C0035, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CCCFA, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 
        0x001CCCFA, 0x0046BED8, 0x003D5783, 0x0027154C, 0x001C005A, 0x002276A3, 0x0046BED8, 0x001CADF5, 0x002BC5F0, 0x0046BED8, 0x0040818E, 0x00225565, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x19222250, 0x37001535, 0x59000000, 0x5A000000, 
        0x5D000000, 0x60000000, 0x65000000, 0x6A000000, 0x70000015, 0x79000000, 0x7D000000, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB5000000, 0xB9000000, 
        0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDF000000, 0xE2000000, 0xE4000000, 0xE7000000, 0xE9000000, 0xEC000000, 0xEE000000, 0xF0000000, 
        0xF2000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x1515153D, 0x00220042, 0x0027154C, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CD2FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002276A3, 0x002B387A, 0x001C0066, 0x002E3255, 0x00223D5A, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x66000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x88000000, 0x8B001515, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000015, 0xAB000015, 0xAF000015, 
        0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xD8000000, 0xDC000000, 0xDF000000, 0xE3000000, 0xE6000000, 0xE9000000, 0xEC000000, 
        0xEF000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CE0FC, 0x0022E6FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00226D89, 0x00223D66, 0x19222250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x85000000, 0x8B000000, 0x8E000000, 0x90000015, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9A000015, 0x9C000000, 0x9E000015, 0x9E000015, 0xA2000015, 
        0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE5000000, 
        0xEA000000, 0xEE000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0038, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CD2FC, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x73000000, 0x79000000, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x88000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x8E000000, 0x8E000000, 0x90000015, 0x90000015, 0x90000015, 
        0x94001515, 0x94001515, 0x95000015, 0x9A000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB3000015, 0xB7000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xD0000000, 0xD5000000, 0xDB000000, 
        0xE2000000, 0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0035, 0x001C0066, 0x001C84E6, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E9FF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x62000000, 0x65000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7D000000, 0x7F001515, 0x7F001515, 0x80000000, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x83000000, 0x83000000, 
        0x85000000, 0x88000015, 0x88000015, 0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA4000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB7000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xD0000000, 
        0xD8000000, 0xDE000000, 0xE5000000, 0xEB000000, 0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x004C9987, 0x0035C397, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x37001535, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CC1F8, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x001CD2FC, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 
        0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x63000000, 0x66000000, 0x6A000000, 0x6E000000, 0x70000000, 0x73000000, 0x74000015, 0x75000000, 0x75000000, 0x75000000, 0x75000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7A000015, 
        0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 0xC6000000, 
        0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00427B7F, 0x002EC3AC, 0x0E4C9C84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x1515153D, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E9FF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 
        0x5C000000, 0x5F000000, 0x62000000, 0x65000000, 0x67000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x73000000, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x88000015, 0x88000015, 0x8B001515, 0x90000015, 0x94001515, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 
        0xC8000000, 0xCE000000, 0xD8000000, 0xE0000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x292E675C, 0x0027B498, 0x002EE4BA, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x90000015, 0x00220042, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E1FE, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CCBFB, 0x001CADF5, 
        0x001CADF5, 0x001C84E6, 0x001C84E6, 0x002276A3, 0x0027154C, 0x02221C46, 0x1515153D, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 
        0x7F001515, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x94001515, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBD000000, 
        0xC4000000, 0xCC000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x8B224040, 0x0027B498, 0x002EC3AC, 0x0146C3A8, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x1515153D, 0x002B387A, 0x001CADF5, 0x001CCBFB, 0x001CCBFB, 0x0022E4FC, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x00223D66, 0x00220042, 0x0027154C, 0x02221C46, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 
        0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x67000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 0x81000015, 0x81000015, 0x85000000, 0x88000015, 
        0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9C000000, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBD000000, 0xC3000000, 
        0xC8000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x00449582, 0x0035C397, 0x002EC3B9, 0x004CAE84, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x001C003B, 0x001C7EC8, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x0022E1FE, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x00220042, 0x00220042, 0x002B0048, 0x02221C46, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5F000000, 0x62000000, 
        0x63000000, 0x66000000, 0x69000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000015, 0x98000000, 
        0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000000, 0xAE000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC1000000, 0xC4000000, 0xC6000000, 0xCB000000, 
        0xCE000000, 0xD3000000, 0xD9000000, 0xE0000000, 0xE6000000, 0xED000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 
        0x002EE1AD, 0x0035C397, 0x002EE4C8, 0x004CAE84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x0027154C, 0x001C84E6, 0x001CC1F8, 0x001CCCFA, 0x001CCCFA, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002276A3, 0x00220042, 0x00220040, 0x001C0046, 0x0027154C, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x60000000, 0x63000000, 0x67000000, 
        0x6A000000, 0x6E000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 
        0xAE000000, 0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xC0000000, 0xC1000000, 0xC3000000, 0xC6000000, 0xC8000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD5000000, 
        0xD8000000, 0xDB000000, 0xDF000000, 0xE4000000, 0xEA000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0035A48F, 0x0022786F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x0027B498, 
        0x0046D69A, 0x002EC3B9, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0x00222B99, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E1FE, 0x0022E1FE, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0032E6FA, 0x001CE0FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002E3255, 0x00220040, 0x0022003D, 0x0027003D, 0x002B0048, 0x002E3255, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x70000000, 
        0x75000000, 0x7A000015, 0x80000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 
        0xC3000000, 0xC4000000, 0xC8000000, 0xC9000000, 0xCB000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD6000000, 0xD8000000, 0xDA000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE0000000, 
        0xE2000000, 0xE4000000, 0xE7000000, 0xEB000000, 0xEF000000, 0xF3000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EC3AC, 0x00229A7E, 0x00276B62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x0035A48F, 0x002EE4BA, 
        0x0035C397, 0x002EE6D4, 0x002EE1AD, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0x001C7EC8, 0x001CCCFA, 0x001CE0FC, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E9FF, 0x001CE0FB, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x003D5783, 0x00220040, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x02221C46, 0x59000000, 0x5B000000, 0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 
        0x83000000, 0x88000000, 0x8E000000, 0x95000000, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC4000000, 0xC9000000, 0xCC000000, 0xCE000000, 0xD3000000, 
        0xD3000000, 0xD8000000, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE2000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 0xE9000000, 0xEA000000, 0xEA000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF1000000, 0xF3000000, 0xF6000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EE4C8, 0x002EE4BA, 0x002EC3AC, 0x00229A7E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0E4C9C84, 0x002EE4BA, 0x0046D69A, 
        0x002EC3B9, 0x0032EADC, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0022E1FE, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E9FF, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x002276A3, 0x001C0046, 0x0022003D, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 0x02221C46, 0x5D000000, 0x62000000, 0x66000000, 0x6C000000, 0x75000000, 0x7D000000, 0x88000000, 
        0x91000000, 0x98000000, 0xA1000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC6000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDA000000, 0xDD000000, 0xDF000000, 0xE2000000, 
        0xE3000000, 0xE5000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xEA000000, 0xEB000000, 0xEC000000, 0xED000000, 0xEE000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF3000000, 
        0xF3000000, 0xF3000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x002EE1AD, 0x00277D62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x0046B497, 
        0x002EE6D4, 0x0032EADC, 0x003BBA87, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF7000000, 0x90000015, 
        0x001C7EC8, 0x001CE0FC, 0x001CCBFB, 0x001CCCFA, 0x001CE0FC, 0x0022E1FE, 0x0022E9FF, 0x0022E1FE, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0022E4FC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x00224060, 0x00220040, 0x00220042, 0x0022003D, 0x0027003D, 0x00220040, 0x002B0048, 0x0027154C, 0x65000000, 0x6A000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 
        0xA1000000, 0xAB000000, 0xB3000015, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xEA000000, 0xEB000000, 0xED000000, 
        0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF3000000, 0xF3000000, 0xF4000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF6000000, 0xF7000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xF8000000, 0xF8000000, 
        0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x002EE4BA, 0x0046D69A, 0x002EC3AC, 
        0x002EE6D4, 0x002EE6D4, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xED000000, 0xEB000000, 0xEB000000, 0xEC000000, 0xEF000000, 0xF3000000, 0x1515153D, 
        0x0046BED8, 0x0022E1FE, 0x001CCBFB, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E4FC, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x00222E8D, 0x00220040, 0x00220042, 0x0022003D, 0x00220042, 0x0022003D, 0x00220042, 0x0027154C, 0x00383B5F, 0x6E000000, 0x79000000, 0x85000000, 0x94001515, 0xA1000000, 
        0xAE000000, 0xB9000000, 0xC3000000, 0xCB000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE6000000, 0xE8000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF5000000, 
        0xF6000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 
        0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0046D69A, 0x002EE4BA, 0x002EE6D4, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x002EB1A3, 0x002EE4BA, 0x0046B497, 0x002EE4C8, 
        0x0042EBDA, 0x004CEAC9, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF3000000, 0xEE000000, 0xE9000000, 0xE5000000, 0xE3000000, 0xE3000000, 0xE5000000, 0xE9000000, 0x88000015, 0x001C003D, 
        0x001C7EC8, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CCCFA, 0x001CC1F8, 0x001CD2FC, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x001C0046, 0x00220042, 0x001C003D, 0x00220042, 0x00220042, 0x001C0038, 0x0027154C, 0x002B0048, 0x002E3255, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 
        0xB9000000, 0xC4000000, 0xCE000000, 0xD8000000, 0xDE000000, 0xE3000000, 0xE7000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFA000000, 
        0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EE1AD, 0x002EE1AD, 0x0027D297, 0x002EE4BA, 0x002EE6D4, 0x002EE1AD, 0x2D447278, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0x003B7E72, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x0032EADC, 
        0x0032EADC, 0x002EE1AD, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF3000000, 0xED000000, 0xE6000000, 0xE0000000, 0xDB000000, 0xD9000000, 0xD9000000, 0xDD000000, 0xE2000000, 0x37001535, 0x001C0038, 
        0x0046BED8, 0x0022E9FF, 0x001CC1F8, 0x001CD2FC, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x001CE0FC, 0x0022E9FF, 0x0022E9FF, 0x0022E6FE, 0x0022E9FF, 0x0022E9FF, 0x001CE0FC, 0x001CD2FC, 
        0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x001C005A, 0x00220042, 0x00220040, 0x00220042, 0x00220040, 0x0022003D, 0x002B0048, 0x00220040, 0x0027154C, 0x37001535, 0x8E000000, 0x9C000000, 0xAE000000, 
        0xBD000000, 0xCB000000, 0xD6000000, 0xDF000000, 0xE6000000, 0xEC000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x04274655, 0x002EC3AC, 0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4C8, 0x002EE4BA, 0x003BBA87, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0x0035A48F, 0x002EC3B9, 0x0027B498, 0x002EC3B9, 0x0032EADC, 
        0x0032EADC, 0x0022BC83, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xED000000, 0xE5000000, 0xDD000000, 0xD6000000, 0xD0000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xDC000000, 0x37001535, 0x001C003B, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x0022E4FC, 0x0022E1FE, 0x0022E6FE, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x001C0046, 0x0027003D, 0x00220042, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00383B5F, 0x8B000000, 0x9C000000, 0xAB000000, 
        0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEA000000, 0xF0000000, 0xF4000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x002EE4C8, 0x002EE1AD, 0x2D447278, 0xFB000000, 0xFA000000, 0x3422384A, 0x002EB1A3, 0x0146C3A8, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 
        0x002EE4C8, 0x8B224040, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x8B224040, 0x292E675C, 0x003B7E72, 0x003B7E72, 0x00449582, 0x00229A7E, 0x00229A7E, 0x00449582, 0x00449582, 0x003B7E72, 0x003B7E72, 0x292E675C, 0x0022384C, 0x0015002E, 
        0x001C7EC8, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x0022E1FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FC, 0x001CE0FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x00272E90, 0x0027154C, 0x00220042, 0x00220042, 0x001C0038, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x95000000, 0xA7000000, 
        0xB7000000, 0xC6000000, 0xD3000000, 0xDF000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x8B224040, 0x002EB1A3, 0x002EE1AD, 0x002EE4BA, 0x0027D297, 0x002EC3AC, 0x002EC3B9, 0x0035A48F, 0xF9000000, 0xF6000000, 0x3422384A, 0x002EB1A3, 0x0027B498, 0x002EB1A3, 0x002EE6D4, 0x002EE6D4, 
        0x0027D297, 0xF7000000, 0xF9000000, 0x8B224040, 0x00226760, 0x00449582, 0x0035A48F, 0x0027B498, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x002EB1A3, 0x0035A48F, 0x0022384C, 0x0015002E, 
        0x002276A3, 0x001CD2FC, 0x001CE0FC, 0x001CADF5, 0x001CADF5, 0x0022E1FE, 0x001CD2FC, 0x0022E1FE, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E6FE, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CE0FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x00222B99, 0x001C0066, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x0022003D, 0x0022003D, 0x00220042, 0x002B0048, 0x0027154C, 0x8E000000, 0x9C000000, 
        0xAE000000, 0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEB000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE4BA, 0x002EE1AD, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x8B224040, 0xF1000000, 0x292E675C, 0x0027B498, 0x002BA485, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 
        0x2D447278, 0x8B224040, 0x2D447278, 0x00449582, 0x002EB1A3, 0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x01223D4C, 0x0015002E, 
        0x00222E8D, 0x0022E4FC, 0x001CD2FC, 0x001CADF5, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E1FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 
        0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 0x002BC5F0, 0x002276A3, 0x01221C8D, 0x001C0046, 0x0027003D, 0x00220040, 0x00220040, 0x00220042, 0x00220042, 0x00220040, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x91000000, 
        0xA1000000, 0xB1000000, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0027B498, 0x002EC3AC, 0x0E4C9C84, 0xEB000000, 0x292E675C, 0x0035A48F, 0x00229A7E, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0xE5000000, 0x0027B498, 0x0042EBDA, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x00356762, 0x001C0038, 
        0x001C0066, 0x001CCCFA, 0x001CD2FC, 0x001CADF5, 0x001CCBFB, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x0032E6FA, 0x001CE0FB, 0x001CCCFA, 0x002276A3, 0x01221C8D, 0x001C0066, 0x00220040, 0x0022003D, 0x0022003D, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C0046, 0x0027154C, 0x002E3255, 0x85000000, 
        0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x0027B498, 0x002EB1A3, 0x0027B498, 0x8B224040, 0x292E675C, 0x00229A7E, 0x00449582, 0x0042EBDA, 0x002EC3B9, 0x8B224040, 
        0x0022757D, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x0032EADC, 0x002EE6D4, 0x002EE4BA, 0x002EC3B9, 0x002EB1A3, 0x00227575, 0x002E3255, 0x00220042, 
        0x00150040, 0x0046BED8, 0x0022E1FE, 0x001CCCFA, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0022E6FE, 0x001CE0FB, 
        0x0022E4FC, 0x0022E4FC, 0x0022E4FC, 0x001CE0FB, 0x0032E6FA, 0x0032E6FA, 0x001C84E6, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C005A, 0x0022003D, 0x0022003D, 0x00220040, 0x00220042, 0x0027154C, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 
        0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE5000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00449582, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0035A48F, 0x002EB1A3, 0x00276B62, 0x292E675C, 0x00449582, 0x004C9987, 0x0042EBDA, 0x2D447278, 0x70000015, 
        0x0035A48F, 0x0022B180, 0x002EE1AD, 0x0040EDFC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EC3B9, 0x002EB1A3, 0x002EB1A3, 0x0022A489, 0x00449582, 0x003B7E72, 0x00276B62, 0x01223D4C, 0x011C2B48, 0x00223D66, 0x002B545D, 0x00274057, 0x00220042, 
        0x001C0035, 0x001C7EC8, 0x0032EBFF, 0x0022E1FE, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x0022E4FC, 0x001CE0FB, 0x0022E6FE, 0x0032E6FA, 0x001CCCFA, 0x002276A3, 0x00222B99, 0x00222B99, 0x01221C8D, 0x001C0066, 0x0027154C, 0x0027003D, 0x002B0048, 0x00220042, 0x00220042, 0x002B0048, 0x001C0046, 0x002B0048, 0x002E3255, 
        0x7A000015, 0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC1000000, 0xCE000000, 0xDB000000, 0xE6000000, 0xEE000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x3422384A, 0x292E675C, 0x2D447278, 0x292E675C, 0x00225A6F, 0x00449582, 0x002EC3AC, 0x002EC3B9, 0x0027B498, 0x0035A48F, 0x00449582, 0x002B545D, 0x00227575, 0x0035A48F, 0x0146C3A8, 0xB1000000, 0x00449582, 
        0x002EE6D4, 0x0035C397, 0x0046D69A, 0x002EE4C8, 0x004CEAC9, 0x00276B62, 0x00274057, 0x011C2B48, 0x011C2B48, 0x01273250, 0x0022384C, 0x00222248, 0x0022384C, 0x01223D4C, 0x00225459, 0x002B545D, 0x002B545D, 0x00223D5A, 0x01273250, 0x002B0048, 
        0x001C0035, 0x002B387A, 0x001CD2FC, 0x0032EBFF, 0x001CD2FC, 0x001CADF5, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 
        0x0032E6FA, 0x0022E4FC, 0x0032E6FA, 0x0032EBFF, 0x001CE0FB, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x001C0046, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002E3255, 
        0x70000000, 0x7A000015, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xC3000000, 0xD0000000, 0xDD000000, 0xE7000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0046D69A, 0x0046D69A, 0x0035C397, 0x0035C397, 0x0046B497, 0x002BA485, 0x002B8669, 0x00276B62, 0x0022757D, 0x00449582, 0x0035A48F, 0x00276B62, 0x00227575, 0x002EC3AC, 0x002B8669, 0x0040818E, 0x002EE6D4, 
        0x002EE6D4, 0x0035A48F, 0x0027D297, 0x0042E4B3, 0x0042EBDA, 0x002B8669, 0x0022384C, 0x01273250, 0x011C2B48, 0x01273250, 0x00383B5F, 0x00383B5F, 0x00274057, 0x01273250, 0x011C2B48, 0x00222248, 0x00274057, 0x00274057, 0x002E3255, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x001C7EC8, 0x0032E6FA, 0x0022E9FF, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x001CE0FC, 0x001CE0FC, 0x0022E4FC, 0x0032E6FA, 
        0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C005A, 0x00220042, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 
        0x37001535, 0x70000000, 0x7A000015, 0x88000000, 0x95000000, 0xA4000000, 0xB5000000, 0xC4000000, 0xD3000000, 0xDF000000, 0xE9000000, 0xF1000000, 0xF7000000, 0xFB000000, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x0042E4B3, 0x003BBA87, 0x00276B62, 0x00227575, 0x0035A48F, 0x00449582, 0x002EC3AC, 0x0040818E, 0x002EE4C8, 0x0035A48F, 
        0x00226760, 0x003B7E72, 0x002BC98C, 0x002EE1AD, 0x002EE4C8, 0x006DEDD4, 0x0046B497, 0x0027B498, 0x002BA485, 0x002BA485, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x0022786F, 0x002B545D, 0x0022384C, 0x00222248, 0x002E3255, 0x01273250, 
        0x001C003D, 0x00150035, 0x001C005A, 0x001C7EC8, 0x0040EDFC, 0x0022E9FF, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x0022E4FC, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 
        0x0040EDFC, 0x0040EDFC, 0x002BC5F0, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x001C003D, 0x00220042, 0x00220040, 0x00220040, 0x00220042, 
        0x19222250, 0x69000000, 0x70000000, 0x7A000015, 0x88000000, 0x98000000, 0xA7000000, 0xB7000000, 0xC8000000, 0x292E675C, 0x292E675C, 0x3422384A, 0xF4000000, 0x8B224040, 0x0050A689, 0x002B545D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0035A48F, 0x0035A48F, 0x002EC3AC, 0x002EE4BA, 0x002EE4C8, 0x0146C3A8, 0x0035A48F, 
        0x0027B498, 0x0035C397, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x0042EBDA, 0x004CEAC9, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0022B180, 0x00229A7E, 0x002B8669, 0x00226760, 0x01273250, 
        0x00220042, 0x0015002E, 0x001C0046, 0x002B387A, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 
        0x0032E6FA, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x00220042, 0x001C0038, 0x001C003D, 0x0022003D, 0x00220042, 0x001C003D, 
        0x1515153D, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 0x59224244, 0x0050A689, 0x0050A689, 0x002B8669, 0x00356762, 0x0046B497, 0x004CAE84, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 
        0x002EE1AD, 0x0027D297, 0x003BBA87, 0x0046D69A, 0x0027D297, 0x002EE4C8, 0x007AF0F5, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EC3AC, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0146C3A8, 0x0027B498, 0x0022B180, 
        0x002B8669, 0x011C3B4A, 0x00150038, 0x001C0066, 0x00222B99, 0x001C84E6, 0x001CCCFA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0032E6FA, 0x0040EDFC, 0x002BC5F0, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x002BC5F0, 0x001CADF5, 
        0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x0022003D, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C003D, 
        0x0027154C, 0x5F000000, 0x63000000, 0x6A000000, 0x73000000, 0x80000000, 0x8E000000, 0x9E000015, 0x59224244, 0xC1000000, 0x8B224040, 0x0046B497, 0x00449582, 0x0046D69A, 0x004CAE84, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE4C8, 0x00229A7E, 0x002287AD, 0x0027B498, 0x04274655, 0x00225A6F, 
        0x002EC3B9, 0x002EE4BA, 0x0022BC83, 0x0027D297, 0x0027CA7E, 0x002EE1AD, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0042EBDA, 
        0x002EE6D4, 0x002EC3B9, 0x00229A7E, 0x00222248, 0x002B387A, 0x00222B99, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x0046BED8, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x0022003D, 0x001C003D, 0x001C003D, 0x00220042, 
        0x001C0046, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x83000000, 0x94001515, 0xA4000000, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x00449582, 0x004CAE84, 0x0046B497, 0x0046B497, 0x0046B497, 0x2D447278, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3B9, 0x0027B498, 0x003B7E72, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EC3B9, 0x004C9987, 0x00274057, 
        0x00222248, 0x0040818E, 0x002BA485, 0x0027CA7E, 0x0027D297, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x002EE6D4, 0x002EC3B9, 0x002EC3B9, 0x0035A48F, 0x0022757D, 
        0x00227575, 0x00225A6F, 0x0022757D, 0x00356762, 0x0027154C, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00272E90, 0x002B387A, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C003D, 0x00220040, 0x001C003D, 0x001C003D, 0x00220042, 
        0x00220042, 0x1515153D, 0x5C000000, 0x60000000, 0x3422384A, 0x2D447278, 0x0E4C9C84, 0x2D447278, 0x2D447278, 0x004CAE84, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x004CAE84, 0x0050A689, 0x0E4C9C84, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 
        0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0E4C9C84, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x002EE1AD, 0x0046B497, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EE6D4, 0x002EC3AC, 0x0040818E, 
        0x002B545D, 0x00220042, 0x002B545D, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002EC3AC, 0x002EE4C8, 0x007AF0F5, 0x0046B497, 0x0022757D, 0x00225A6F, 0x00225459, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x00274057, 0x00274057, 0x00274057, 0x04274655, 
        0x00225459, 0x01223D4C, 0x0022384C, 0x0022003D, 0x001C003B, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x002B387A, 0x001C0066, 0x001C0046, 0x001C003D, 0x0015003D, 0x001C003D, 0x001C003D, 
        0x0027154C, 0x1515153D, 0x1B2B3B55, 0x00225459, 0x0022786F, 0x004C9987, 0x0046B497, 0x0046B497, 0x0046B497, 0x002EB1A3, 0x0050A689, 0x004CAE84, 0x00225A6F, 0x00449582, 0x00449582, 0x0046B497, 0x0146C3A8, 0x0E4C9C84, 0x2D447278, 0x2D447278, 
        0x2D447278, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 
        0x004C9987, 0x0035A48F, 0x002287AD, 0x002EB1A3, 0x0035A48F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00227575, 0x0022786F, 0x0022786F, 0x00226760, 0x00449582, 0x002EE4C8, 0x004CEAC9, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x004CEAC9, 0x002EC3B9, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0x0040818E, 0x00225459, 0x002B545D, 0x0022B180, 0x0027CA7E, 0x0027CA7E, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x006DEDD4, 0x002B545D, 0x011C2B48, 0x001C153B, 0x00150040, 0x00225459, 0x00226760, 0x00274057, 0x00274057, 0x01273250, 0x0022384C, 
        0x00274057, 0x00225459, 0x00274057, 0x0022384C, 0x001C153B, 0x001C0046, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x001C0038, 0x001C003D, 0x00222248, 0x01273250, 
        0x00224060, 0x00225565, 0x00227575, 0x00227575, 0x00227575, 0x0022757D, 0x00427B7F, 0x0022757D, 0x004C9987, 0x00449582, 0x004C9987, 0x00276B62, 0x00225565, 0x00225A6F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x0035A48F, 
        0x002EB1A3, 0x002EB1A3, 0x0027B498, 0x0035A48F, 0x2D447278, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0x8B224040, 0x2D447278, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x004C9987, 0x0035A48F, 0x0035A48F, 0x004C9987, 
        0x004C9987, 0x0040818E, 0x0040818E, 0x0040818E, 0x002EB1A3, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00427B7F, 0x003B7E72, 0x002BA485, 0x002BA485, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x0042E4B3, 0x004CEAC9, 0x0042EBDA, 0x0042EBDA, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0032EADC, 0x002EE4C8, 
        0x00449582, 0x0022757D, 0x002B545D, 0x00229A7E, 0x0022BC83, 0x0027CA7E, 0x0022B180, 0x002EE4BA, 0x004CEAC9, 0x007AF0F5, 0x0050A689, 0x00223D5A, 0x00274057, 0x0022384C, 0x00225459, 0x00356762, 0x00274057, 0x00274057, 0x002B545D, 0x0022786F, 
        0x00449582, 0x0050A689, 0x0046B497, 0x0046B497, 0x0050A689, 0x004C9987, 0x0022786F, 0x00225565, 0x001C0066, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 
        0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C005A, 0x0027154C, 0x00222248, 0x00223D5A, 0x00223D66, 0x00225A6F, 
        0x00227575, 0x00225A6F, 0x00356762, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00227575, 0x00227575, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x0040818E, 0x0035A48F, 0x00449582, 0x0022786F, 0x00227575, 0x0040818E, 
        0x00449582, 0x0040818E, 0x0035A48F, 0x002EB1A3, 0x0027B498, 0x00449582, 0x00449582, 0x00449582, 0x0027B498, 0x0027B498, 0x0027B498, 0x002EB1A3, 0x002EC3AC, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x00449582, 0x0022757D, 0x004C9987, 0x00427B7F, 
        0x00427B7F, 0x00226D89, 0x00427B7F, 0x003D5783, 0x002287AD, 0x0035A48F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0035C397, 0x00229A7E, 0x002EC3B9, 0x004CEAC9, 0x002EE1AD, 0x0042E4B3, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0035A48F, 0x004C9987, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3AC, 0x0040818E, 0x00225565, 0x00276B62, 0x0022BC83, 0x0022BC83, 0x0022BC83, 0x0035C397, 0x002EE4C8, 0x0042EBDA, 0x0378C6BE, 0x00224060, 0x00274057, 0x00274057, 0x00274057, 0x0022384C, 0x002B545D, 0x0035A48F, 0x0046D69A, 0x002EE4BA, 
        0x004CEAC9, 0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x006DEDD4, 0x0378C6BE, 0x0035A48F, 0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x00223D5A, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00225565, 
        0x00227575, 0x00225A6F, 0x0022786F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x0022757D, 0x00225A6F, 0x00225565, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00227575, 0x002B545D, 0x0022757D, 
        0x0022757D, 0x0022757D, 0x0022757D, 0x0035A48F, 0x0040818E, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0027B498, 0x0035A48F, 0x002EC3B9, 0x0035A48F, 0x004C9987, 0x0040818E, 0x0035A48F, 0x00449582, 0x00356762, 0x0040818E, 0x00225A6F, 
        0x00225A6F, 0x002B387A, 0x00225A6F, 0x00225565, 0x00226D89, 0x0040818E, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4BA, 0x002EE1AD, 0x002EE4BA, 0x006DEDD4, 0x006DEDD4, 0x0146C3A8, 0x004C9987, 0x00227575, 0x002B545D, 0x003B7E72, 0x00276B62, 0x002B545D, 0x00225459, 0x00225565, 
        0x0040818E, 0x00449582, 0x0022757D, 0x01223D4C, 0x0022A474, 0x0022BC83, 0x0022BC83, 0x002BAF7D, 0x002EE4BA, 0x002EE6D4, 0x006DEDD4, 0x002B8669, 0x00274057, 0x00274057, 0x002B545D, 0x00225A6F, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x004CEAC9, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00449582, 0x002B545D, 0x00225565, 0x00427B7F, 0x0040818E, 0x00226D89, 0x00272E90, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00222B99, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 0x01221C8D, 0x00272E90, 0x01221C8D, 0x006D627D, 0x00787283, 0x001C0066, 0x001C0066, 0x002E3255, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00227575, 0x00225A6F, 
        0x00225A6F, 0x0022757D, 0x00227575, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x00224060, 0x00224060, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x002B545D, 0x00223D5A, 
        0x00225A6F, 0x00225A6F, 0x0022757D, 0x0022757D, 0x00427B7F, 0x0022757D, 0x00427B7F, 0x00427B7F, 0x0040818E, 0x0040818E, 0x0022757D, 0x0040818E, 0x0022757D, 0x0022757D, 0x00225A6F, 0x002287AD, 0x00427B7F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x00383B5F, 0x00383B5F, 0x002E3255, 0x00383B5F, 0x00225A6F, 0x003D5783, 0x2D447278, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x0042E4B3, 0x002EC3AC, 0x002EE4BA, 0x002EE1AD, 0x004CEAC9, 0x002EE4BA, 0x002B8669, 0x00485263, 0x00225A6F, 0x00223D5A, 0x00220040, 0x00226760, 0x00229A7E, 0x002B8669, 0x00356762, 0x00225459, 
        0x00274057, 0x002287AD, 0x00427B7F, 0x00226760, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0027B498, 0x002EE4BA, 0x0042EBDA, 0x0378C6BE, 0x01273250, 0x00274057, 0x00225A6F, 0x0035C397, 0x002EE1AD, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 
        0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x006DEDD4, 0x003B7E72, 0x00356762, 0x00356762, 0x01223D4C, 0x001C0038, 0x001C0046, 0x0027154C, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00C6BEC2, 0x0022384C, 0x00274057, 0x01273250, 0x00223D5A, 0x00224060, 0x00226760, 0x00225A6F, 0x00225A6F, 0x0022786F, 0x00225A6F, 
        0x00227575, 0x0022757D, 0x00276B62, 0x00227575, 0x00226760, 0x00225565, 0x00227575, 0x0022757D, 0x00226760, 0x00223D5A, 0x00274057, 0x00224060, 0x00224060, 0x00225A6F, 0x00223D5A, 0x0022757D, 0x00225A6F, 0x00274057, 0x002E3255, 0x00223D5A, 
        0x00223D5A, 0x00224060, 0x0022757D, 0x0022757D, 0x00227575, 0x002B545D, 0x00227575, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00226D89, 0x00225A6F, 0x00226D89, 0x00227575, 0x0040818E, 0x00427B7F, 0x00223D5A, 0x00225A6F, 0x01273250, 
        0x00224060, 0x1B2B3B55, 0x2D447278, 0x00274057, 0x00383B5F, 0x00225A6F, 0x2D447278, 0xFA000000, 0xF8000000, 0xF7000000, 0xF6000000, 0xF6000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFE000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0046D69A, 0x002EC3AC, 0x0046D69A, 0x004CEAC9, 0x0042E4B3, 0x0035C397, 0x002B8669, 0x00274057, 0x00225A6F, 0x00222248, 0x001C003D, 0x01273250, 0x002B8669, 0x002B8669, 0x002B8669, 0x00427B7F, 
        0x00229A7E, 0x0022A489, 0x00229A7E, 0x00229A7E, 0x00226760, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BA485, 0x002EE4C8, 0x0042EBDA, 0x005FE4B6, 0x01223D4C, 0x00274057, 0x00427B7F, 0x0035C397, 0x0035C397, 0x0035C397, 0x002EC3B9, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x002B545D, 0x01223D4C, 0x01223D4C, 0x002B545D, 0x01223D4C, 0x001C0038, 0x001C003B, 0x001C005A, 0x001C0066, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x01221C8D, 0x00222B99, 0x002B387A, 0x01221C8D, 0x001C0066, 0x001C005A, 0x00575970, 0x00948490, 0x004A4062, 0x00948490, 0x00225459, 0x002B545D, 0x00223D5A, 0x00225565, 0x00224060, 0x00225A6F, 0x00276B62, 0x00225565, 0x0022757D, 0x0022786F, 
        0x00225A6F, 0x0022757D, 0x00225565, 0x00225A6F, 0x00227575, 0x01273250, 0x00224060, 0x00225A6F, 0x00227575, 0x001C0046, 0x01273250, 0x001C0046, 0x0027154C, 0x00223D5A, 0x001C0046, 0x00223D66, 0x00224060, 0x0027154C, 0x00220042, 0x00223D5A, 
        0x00224060, 0x00224060, 0x00225A6F, 0x0022757D, 0x00225A6F, 0x0022384C, 0x00225565, 0x00276B62, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x003D5783, 0x00225A6F, 0x0027154C, 0x00225A6F, 0x3422384A, 
        0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x00225565, 0x00383B5F, 0x292E675C, 0xF4000000, 0xF2000000, 0xF0000000, 0xEE000000, 0xED000000, 0xED000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF5000000, 0xF7000000, 0xFA000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x00229A7E, 0x002EC3AC, 0x002EE1AD, 0x002EE4BA, 0x00229A7E, 0x00449582, 0x002BA485, 0x00225459, 0x002B545D, 0x00274057, 0x00276B62, 0x00229A7E, 0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 
        0x002EB1A3, 0x0027B498, 0x0027B498, 0x0027B498, 0x00277D62, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002EC3AC, 0x002EE4C8, 0x006DEDD4, 0x00277D62, 0x00274057, 0x00229A7E, 0x002BA485, 0x0027B498, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x011C2B48, 0x001C003D, 0x00274057, 0x00356762, 0x00274057, 0x00274057, 0x0022384C, 0x001C003D, 0x001C003D, 0x0027154C, 0x001C0066, 0x002B387A, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 
        0x001C0066, 0x001C0066, 0x01273250, 0x0027154C, 0x001C0046, 0x02221C46, 0x004A4062, 0x00948490, 0x002E3255, 0x00948490, 0x00356762, 0x002B545D, 0x00226760, 0x00225565, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225565, 0x0040818E, 0x00225A6F, 0x00224060, 0x0022757D, 0x00274057, 0x00274057, 0x00225A6F, 0x00227575, 0x001C0046, 0x0027154C, 0x001C0046, 0x0027154C, 0x00222248, 0x001C003D, 0x01273250, 0x00222248, 0x00220042, 0x001C0046, 0x002E3255, 
        0x00224060, 0x00225565, 0x00225A6F, 0x00225565, 0x00223D66, 0x01273250, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x00223D66, 0x00485263, 0x00225A6F, 0x002B545D, 0x00485263, 0x292E675C, 0xFB000000, 
        0xFB000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF3000000, 0x8B224040, 0xEC000000, 0xE9000000, 0xE6000000, 0xE3000000, 0xE2000000, 0xE2000000, 0xE4000000, 0xE6000000, 0xEA000000, 0xEE000000, 0xF2000000, 0xF6000000, 0xF9000000, 
        0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022A474, 0x0022384C, 0x0035C397, 0x002EE1AD, 0x003BBA87, 0x00274057, 0x00225A6F, 0x0035A48F, 0x00276B62, 0x00229A7E, 0x0035C397, 0x002EC3AC, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x0146C3A8, 
        0x0027B498, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x002B8669, 0x00225459, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0035A48F, 0x002EE4C8, 0x006DEDD4, 0x0022A474, 0x01273250, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x002EC3B9, 0x002EE6D4, 0x0042EBDA, 
        0x0042EBDA, 0x0050A689, 0x02221C46, 0x011C2B48, 0x002B545D, 0x00356762, 0x01223D4C, 0x002B545D, 0x00575970, 0x00485263, 0x00787283, 0x01223D4C, 0x00220040, 0x001C0046, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 0x00222248, 0x01273250, 
        0x00274057, 0x00274057, 0x00224060, 0x01273250, 0x01273250, 0x011C2B48, 0x002E3255, 0x00948490, 0x00485263, 0x00787283, 0x003B7E72, 0x00226760, 0x00225565, 0x00225565, 0x002B545D, 0x00225565, 0x002B545D, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225A6F, 0x00226D89, 0x0022757D, 0x00222248, 0x0022757D, 0x00274057, 0x00222248, 0x00223D66, 0x0022757D, 0x001C0046, 0x0015003D, 0x00150040, 0x00222248, 0x01273250, 0x00222248, 0x00222248, 0x001C0046, 0x001C003D, 0x00150040, 0x0027154C, 
        0x002E3255, 0x00225565, 0x00225565, 0x002B545D, 0x002E3255, 0x002E3255, 0x00223D5A, 0x00383B5F, 0x00223D5A, 0x00223D66, 0x002B545D, 0x00223D5A, 0x00225565, 0x0027154C, 0x001C0046, 0x00223D66, 0x00225A6F, 0x8B224040, 0xF6000000, 0xF7000000, 
        0xF7000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE2000000, 0xDC000000, 0xD8000000, 0xD5000000, 0xD3000000, 0xD3000000, 0xD5000000, 0xD9000000, 0xDE000000, 0xE4000000, 0xEA000000, 0xF0000000, 0xF5000000, 
        0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002B8669, 0x00229A7E, 0x002EE1AD, 0x0022786F, 0x002B545D, 0x0022757D, 0x0027B498, 0x002EE1AD, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x002EE4BA, 
        0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002BC98C, 0x00277D62, 0x00226760, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x002EC3AC, 0x002EE4C8, 0x0046D69A, 0x002B8669, 0x0022786F, 0x002B8669, 0x0035A48F, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 
        0x0146C3A8, 0x0022384C, 0x04274655, 0x00225459, 0x002B545D, 0x01223D4C, 0x00222248, 0x004A4062, 0x00B6A7AC, 0x00787283, 0x00C6BEC2, 0x00485263, 0x00224060, 0x01273250, 0x00223D5A, 0x00224060, 0x0022384C, 0x00223D5A, 0x0022384C, 0x01273250, 
        0x00223D5A, 0x00223D5A, 0x00224060, 0x00225565, 0x002B545D, 0x00225565, 0x0027154C, 0x00787283, 0x00485263, 0x00948490, 0x00449582, 0x0022786F, 0x00276B62, 0x00226760, 0x00274057, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x01273250, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00224060, 0x01273250, 0x00222248, 0x00225A6F, 0x00485263, 0x1B2B3B55, 0x79000000, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xBB000000, 0xC0000000, 0xC0000000, 0x3422384A, 0x1515153D, 
        0x001C0046, 0x0027154C, 0x00225565, 0x0040818E, 0x00227575, 0x01273250, 0x0027154C, 0x0027154C, 0x001C0046, 0x00223D66, 0x00222248, 0x001C005A, 0x00225A6F, 0x004A4062, 0x00225A6F, 0x8B224040, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xEF000000, 0xEE000000, 0xEC000000, 0xE9000000, 0xE5000000, 0xDF000000, 0xD9000000, 0xD3000000, 0xCC000000, 0xC8000000, 0xC3000000, 0xC1000000, 0xC1000000, 0xC4000000, 0xC9000000, 0xD0000000, 0xD8000000, 0xE2000000, 0xE9000000, 0xF0000000, 
        0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x0046D69A, 0x00427B7F, 0x002EE1AD, 0x002BA485, 0x0027B498, 0x0027D297, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x002EE4BA, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002B8669, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0035A48F, 0x002EE4BA, 0x002EE1AD, 0x002BA485, 0x0022786F, 0x002B8669, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x004CEAC9, 
        0x00276B62, 0x00274057, 0x002B545D, 0x00225459, 0x00356762, 0x00225459, 0x011C2B48, 0x004A4062, 0x00C6BEC2, 0x006D627D, 0x00948490, 0x002B545D, 0x002E3255, 0x00274057, 0x00223D5A, 0x002B545D, 0x00274057, 0x00223D5A, 0x00274057, 0x00274057, 
        0x002E3255, 0x00223D66, 0x00274057, 0x00225565, 0x00225565, 0x00225565, 0x01273250, 0x004A4062, 0x00485263, 0x004A4062, 0x00948490, 0x00427B7F, 0x0022786F, 0x00226760, 0x00225459, 0x00225A6F, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x0022757D, 
        0x00222248, 0x00223D66, 0x0022757D, 0x01273250, 0x01273250, 0x011C2B48, 0x00222248, 0x3422384A, 0x62000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x98000000, 0xA2000015, 0xAB000015, 0xAF000015, 0xAF000015, 0xAB000015, 0xA7000015, 
        0x00274057, 0x011C2B48, 0x002E3255, 0x00227575, 0x0040818E, 0x00227575, 0x1B2B3B55, 0x3422384A, 0x3422384A, 0x3422384A, 0x00485263, 0x00427B7F, 0x2D447278, 0x8B224040, 0xD6000000, 0xDA000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 
        0xE4000000, 0xE3000000, 0xE0000000, 0xDC000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC1000000, 0xBB000000, 0xB5000000, 0xB1000000, 0xAE000000, 0xAE000000, 0xB1000000, 0xB9000000, 0xC1000000, 0xCB000000, 0xD6000000, 0xE0000000, 0xEA000000, 
        0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x002EB1A3, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0022A474, 0x00277D62, 0x00356762, 0x003B7E72, 0x0035C397, 0x002EE1AD, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 
        0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x0042E4B3, 0x002EE1AD, 0x002BAF7D, 0x00277D62, 0x04274655, 0x00229A7E, 0x0022A474, 0x00229A7E, 0x002EE4BA, 0x005FE4B6, 0x0027D297, 0x00277D62, 0x00449582, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x0046B497, 
        0x01223D4C, 0x00225459, 0x00225459, 0x00225459, 0x00225459, 0x0022384C, 0x00150040, 0x00383B5F, 0x00B6A7AC, 0x00575970, 0x00787283, 0x04274655, 0x0022384C, 0x00274057, 0x00274057, 0x002B545D, 0x00224060, 0x01273250, 0x0027154C, 0x00222248, 
        0x00222248, 0x00223D5A, 0x00224060, 0x00225A6F, 0x002B545D, 0x002E3255, 0x00225A6F, 0x01273250, 0x004A4062, 0x00383B5F, 0x00948490, 0x00226760, 0x00226760, 0x00226760, 0x002B545D, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00223D66, 0x00224060, 
        0x00220042, 0x0022757D, 0x00227575, 0x0022384C, 0x04274655, 0x37001535, 0x59000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x80000000, 0x8B000000, 0x94001515, 0x9A000015, 0x9E000015, 0x9E000015, 0x9A000015, 0x94001C15, 
        0x57000000, 0x1B2B3B55, 0x001C0046, 0x002E3255, 0x00383B5F, 0x00226D89, 0x003D5783, 0x2D447278, 0x94001C15, 0x9E000015, 0xA7000015, 0xAF000015, 0xB7000000, 0xBD000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD3000000, 0xD5000000, 
        0xD5000000, 0xD3000000, 0xD0000000, 0xCC000000, 0xC6000000, 0xC0000000, 0xB7000000, 0xAF000015, 0xA7000015, 0xA2000015, 0x9E000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000015, 0xB3000015, 0xBD000000, 0xCB000000, 0xD8000000, 0xE3000000, 
        0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x011C2B48, 0x0035A48F, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x002BA485, 0x0035C397, 0x0027D297, 0x002BA485, 0x002B8669, 0x00225459, 0x00225459, 0x00226760, 0x003B7E72, 0x00449582, 0x00229A7E, 0x004CAE84, 
        0x004CAE84, 0x002BAF7D, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x00277D62, 0x00225459, 0x01223D4C, 0x00225459, 0x0022A474, 0x002B8669, 0x002EC3AC, 0x005FE4B6, 0x002BC98C, 0x00276B62, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x01223D4C, 
        0x01223D4C, 0x00225459, 0x04274655, 0x04274655, 0x00274057, 0x011C2B48, 0x00220040, 0x004A4062, 0x00948490, 0x00787283, 0x00948490, 0x003B7E72, 0x00225459, 0x00274057, 0x0022384C, 0x01273250, 0x0027154C, 0x00220040, 0x001C0046, 0x02221C46, 
        0x00220040, 0x002E3255, 0x00223D66, 0x00225565, 0x00225565, 0x00356762, 0x00224060, 0x002B545D, 0x00383B5F, 0x00383B5F, 0x00787283, 0x00225565, 0x00227575, 0x00427B7F, 0x002B545D, 0x00224060, 0x00225A6F, 0x011C2B48, 0x001C005A, 0x0027154C, 
        0x001C003B, 0x0027154C, 0x0022384C, 0x04274655, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x67000000, 0x6E000000, 0x75000000, 0x7F001515, 0x85000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x81001C15, 
        0x81001C15, 0x7A000015, 0x1B2B3B55, 0x002E3255, 0x00383B5F, 0x00223D66, 0x00383B5F, 0x003D5783, 0x0040818E, 0x8B001515, 0x94001C15, 0x9E000015, 0xA4000015, 0xAB000015, 0xB1000000, 0xB7000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC3000000, 
        0xC3000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB3000015, 0xAB000000, 0xA4000015, 0x9C000000, 0x94001515, 0x90000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x9A000015, 0xA4000015, 0xB3000015, 0xC0000000, 0xCE000000, 0xDC000000, 
        0xE8000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x0046D69A, 0x003BBA87, 0x0022B180, 0x0046D69A, 0x01223D4C, 0x00226760, 0x0022B180, 0x002EE1AD, 0x002EE1AD, 0x0146C3A8, 0x0022A474, 0x002B8669, 0x00226760, 0x01223D4C, 0x04274655, 0x00226760, 
        0x0022786F, 0x002B8669, 0x002B8669, 0x00277D62, 0x00277D62, 0x00277D62, 0x00225459, 0x011C2B48, 0x001C003D, 0x00225459, 0x002B8669, 0x0022A489, 0x0042E4B3, 0x00277D62, 0x00226760, 0x002EC3AC, 0x002EE4BA, 0x002EC3B9, 0x00226760, 0x0022384C, 
        0x01223D4C, 0x04274655, 0x01223D4C, 0x04274655, 0x00356762, 0x00356762, 0x00427B7F, 0x0035A48F, 0x0378C6BE, 0x0378C6BE, 0x005FE4B6, 0x0146C3A8, 0x0046B497, 0x0035A48F, 0x00449582, 0x002B545D, 0x01273250, 0x01273250, 0x002B545D, 0x00224060, 
        0x0022384C, 0x00222248, 0x0027154C, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00224060, 0x00225A6F, 0x0022384C, 0x0027154C, 0x01273250, 0x00225565, 0x00225565, 0x0022757D, 0x011C2B48, 0x00223D66, 0x00223D66, 0x00222248, 0x001C0038, 0x0027154C, 
        0x001C153B, 0x00220042, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x63000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7F001515, 0x7A000015, 0x7A000015, 0x74000015, 
        0x74000015, 0x70000015, 0x68001515, 0x37001535, 0x1B2B3B55, 0x04274655, 0x002B545D, 0x01273250, 0x00225A6F, 0x0040818E, 0x81001C15, 0x8B001515, 0x94001C15, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xAF000015, 
        0xAF000015, 0xAE000000, 0xAB000000, 0xA7000015, 0xA1000000, 0x9A000015, 0x94001515, 0x8B001515, 0x85000000, 0x81000015, 0x7F001515, 0x7F001515, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA7000015, 0xB9000000, 0xC8000000, 0xD8000000, 
        0xE4000000, 0xEE000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002BAF7D, 0x002EE1AD, 0x00276B62, 0x00276B62, 0x0046B497, 0x002BC98C, 0x011C2B48, 0x01223D4C, 0x002B8669, 0x0022B180, 0x002EC3AC, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0027B498, 0x0022A474, 0x002BAF7D, 
        0x002BAF7D, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002B8669, 0x01223D4C, 0x00274057, 0x00229A7E, 0x002EC3B9, 0x00277D62, 0x0022757D, 0x002EC3B9, 0x002EB1A3, 0x00225459, 0x011C2B48, 0x00356762, 
        0x00449582, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0050A689, 0x00356762, 
        0x00223D5A, 0x01273250, 0x0027154C, 0x00223D5A, 0x00225A6F, 0x003D5783, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x001C0046, 0x00222248, 0x00224060, 0x002B545D, 0x00225A6F, 0x011C3B4A, 0x00220042, 0x01223D4C, 0x001C0035, 0x001C0035, 0x001C003D, 
        0x02221C46, 0x0015003D, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x6C000000, 0x70000015, 0x70000015, 0x70000015, 0x6E000000, 0x6C000000, 
        0x68001515, 0x68001515, 0x65000000, 0x6200001C, 0x6200001C, 0x6200001C, 0x37001535, 0x00485263, 0x00223D5A, 0x00225A6F, 0x0040818E, 0x2D447278, 0x81001C15, 0x85000000, 0x8B001515, 0x8E000000, 0x94001515, 0x98000000, 0x98000000, 0x9C000000, 
        0x9C000000, 0x98000000, 0x98000000, 0x94001515, 0x8E000000, 0x88000015, 0x83000000, 0x7F001515, 0x7A000015, 0x7A000015, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x95000015, 0xA4000015, 0xB3000015, 0xC4000000, 0xD3000000, 
        0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022BC83, 0x0042E4B3, 0x00225459, 0x00225459, 0x002B8669, 0x002EE1AD, 0x0022A474, 0x00222248, 0x00225459, 0x00229A7E, 0x00229A7E, 0x0035C397, 0x0042E4B3, 0x004CEAC9, 0x006DEDD4, 0x005FE4B6, 0x0035C397, 
        0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00226760, 0x00276B62, 0x0146C3A8, 0x002BAF7D, 0x0027B498, 0x0035A48F, 0x004C9987, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 
        0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 
        0x0146C3A8, 0x003B7E72, 0x0022384C, 0x01273250, 0x00225565, 0x00225A6F, 0x0022384C, 0x00224060, 0x00225A6F, 0x01273250, 0x001C0046, 0x01273250, 0x00223D5A, 0x01273250, 0x011C2B48, 0x001C003B, 0x001C153B, 0x001C0035, 0x001C0038, 0x001C0038, 
        0x0027154C, 0x001C003B, 0x37001535, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x68001515, 
        0x65000000, 0x63000000, 0x62000000, 0x62000000, 0x62000000, 0x63000000, 0x65000000, 0x68001515, 0x00274057, 0x00223D5A, 0x0040818E, 0x0040818E, 0x002287AD, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 
        0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7F001515, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x75000000, 0x79000000, 0x7A000015, 0x7F001515, 0x85000000, 0x8B001515, 0x98000000, 0xA4000015, 0xB3000015, 0xC3000000, 0xD3000000, 
        0xDF000000, 0xEB000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x004CEAC9, 0x0027B498, 0x00226760, 0x002B8669, 0x0035C397, 0x005FE4B6, 0x00276B62, 0x001C003D, 0x00226760, 0x0022A474, 0x0022A474, 0x002BA485, 0x0027D297, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 
        0x004CEAC9, 0x002BC98C, 0x0027D297, 0x0027D297, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0022BC83, 0x0022BC83, 0x0022B180, 0x0046D69A, 0x0042E4B3, 0x0042E4B3, 0x005FE4B6, 0x005FE4B6, 0x0046B497, 0x004CAE84, 0x004CAE84, 
        0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002BA485, 0x002BA485, 0x003BBA87, 0x0035C397, 0x0046D69A, 
        0x002EE1AD, 0x006DEDD4, 0x0378C6BE, 0x003B7E72, 0x00225A6F, 0x0022757D, 0x00274057, 0x001C005A, 0x00225565, 0x001C0046, 0x00220035, 0x0022003D, 0x001C153B, 0x0015003D, 0x011C2B48, 0x00150035, 0x001C003B, 0x00150035, 0x001C003B, 0x00150035, 
        0x001C0046, 0x001C003D, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x62000000, 0x63000000, 0x63000000, 0x63000000, 
        0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x00223D66, 0x00356762, 0x00225565, 0x00224060, 0x002276A3, 0x70000015, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7A000015, 0x7A000015, 0x79000000, 0x75000000, 0x74000015, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x88000015, 0x8B001515, 0x94001515, 0x9E000015, 0xAB000015, 0xB7000000, 0xC4000000, 0xD3000000, 
        0xE0000000, 0xEB000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x004CEAC9, 0x0027D297, 0x002B8669, 0x00277D62, 0x00229A7E, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x00225459, 0x002B8669, 0x002BA485, 0x002BAF7D, 0x00229A7E, 0x0027B498, 0x002EE1AD, 0x0042E4B3, 
        0x004CEAC9, 0x006DEDD4, 0x0042E4B3, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002B8669, 0x00226760, 0x011C3B4A, 0x011C3B4A, 0x00226760, 0x005FE4B6, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0035C397, 0x0035C397, 0x00276B62, 0x011C2B48, 0x00220042, 
        0x0022384C, 0x002B545D, 0x002B8669, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0022B180, 0x0022B180, 0x002BAF7D, 0x0022A474, 
        0x00229A7E, 0x0022A489, 0x0035C397, 0x005FE4B6, 0x0146C3A8, 0x00276B62, 0x001C003D, 0x001C0046, 0x00225565, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0046, 0x001C003D, 
        0x001C003D, 0x002B0048, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x65000000, 0x65000000, 
        0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x6E000000, 0x6E000000, 0x6C000000, 0x19222250, 0x04274655, 0x00274057, 0x00224060, 0x002287AD, 0x6A000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 
        0x70000015, 0x70000015, 0x70000015, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB3000015, 0xC0000000, 0xCB000000, 0xD8000000, 
        0xE3000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4BA, 0x005FE4B6, 0x0027B498, 0x0022A474, 0x00277D62, 0x002B8669, 0x0035C397, 0x0042E4B3, 0x0046D69A, 0x00276B62, 0x00225459, 0x002B8669, 0x0022B180, 0x0022B180, 0x0022A474, 0x002BA485, 0x0027D297, 
        0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 0x00229A7E, 0x011C3B4A, 0x01223D4C, 0x00225459, 0x00276B62, 0x0022A474, 0x0046D69A, 0x0027D297, 0x00427B7F, 0x002EC3AC, 0x0046D69A, 0x00225459, 0x00276B62, 0x0046B497, 0x0146C3A8, 0x0046B497, 
        0x003B7E72, 0x01223D4C, 0x011C2B48, 0x01223D4C, 0x00225459, 0x00277D62, 0x002B8669, 0x00229A7E, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x003BBA87, 0x002BC98C, 0x0035C397, 0x002BC98C, 0x0035C397, 
        0x0035C397, 0x003BBA87, 0x0022B180, 0x0022B180, 0x0027B498, 0x0146C3A8, 0x004CAE84, 0x01223D4C, 0x011C2B48, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x00150038, 0x0027154C, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x6C000000, 
        0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x75000000, 0x73000000, 0x70000000, 0x37001535, 0x00274057, 0x00226D89, 0x2D447278, 0x67000000, 0x67000000, 0x68001515, 0x6A000000, 
        0x6C000000, 0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x75000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xB9000000, 0xC0000000, 0xC9000000, 0xD3000000, 0xDD000000, 
        0xE7000000, 0xEF000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x004CEAC9, 0x0046D69A, 0x0022A474, 0x002B8669, 0x00276B62, 0x00277D62, 0x00229A7E, 0x0027D297, 0x005FE4B6, 0x003BBA87, 0x00225459, 0x00225459, 0x00229A7E, 0x0022BC83, 0x0022BC83, 0x003BBA87, 0x002BA485, 
        0x0022B180, 0x0046D69A, 0x002EE1AD, 0x0042E4B3, 0x006DEDD4, 0x0035C397, 0x0022786F, 0x002BC98C, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x0022A474, 0x011C2B48, 0x00226760, 0x0046B497, 0x0046D69A, 0x0022384C, 0x00225459, 0x0022A474, 0x002BAF7D, 
        0x0146C3A8, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00225459, 0x011C2B48, 0x00274057, 0x00225459, 0x00225459, 0x00276B62, 0x00276B62, 0x00276B62, 0x003B7E72, 0x002B8669, 0x002B8669, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00229A7E, 0x00229A7E, 
        0x00229A7E, 0x00229A7E, 0x002BA485, 0x0022B180, 0x0022B180, 0x0022B180, 0x0035C397, 0x0146C3A8, 0x002B8669, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C005A, 0x001C005A, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x67000000, 0x6C000000, 0x70000000, 0x75000000, 
        0x7A000015, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7D000000, 0x79000000, 0x73000000, 0x3422384A, 0x00224060, 0x0040818E, 0x67000000, 0x67000000, 0x68001515, 0x68001515, 
        0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA7000015, 0xAF000015, 0xB6000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE4000000, 
        0xEC000000, 0xF2000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0035C397, 0x002B8669, 0x002B8669, 0x00276B62, 0x00277D62, 0x002B8669, 0x0022BC83, 0x0046D69A, 0x004CEAC9, 0x0022A474, 0x00226760, 0x00225459, 0x0022A474, 0x002BC98C, 0x0022BC83, 0x003BBA87, 
        0x0022B180, 0x002BA485, 0x0027D297, 0x002EE1AD, 0x002EE1AD, 0x004CEAC9, 0x0046D69A, 0x002BAF7D, 0x002BC98C, 0x002EE1AD, 0x0042E4B3, 0x00226760, 0x011C3B4A, 0x0022384C, 0x002B8669, 0x005FE4B6, 0x0050A689, 0x01223D4C, 0x00226760, 0x00229A7E, 
        0x0022A474, 0x002BA485, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00356762, 0x01223D4C, 0x00224060, 0x00226760, 0x00274057, 0x002B545D, 0x002B545D, 0x00274057, 0x002B545D, 0x00223D5A, 0x00224060, 0x002B545D, 0x00274057, 
        0x00225565, 0x002B545D, 0x0022384C, 0x0022384C, 0x01223D4C, 0x002B545D, 0x0022786F, 0x00229A7E, 0x0046B497, 0x00277D62, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003B, 0x001C0038, 0x00150040, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 
        0x001C0038, 0x001C003D, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x60000000, 0x65000000, 0x69000000, 0x70000000, 0x75000000, 0x7D000000, 0x83000000, 
        0x8B000000, 0x90000015, 0x95000000, 0x98000000, 0x9C000000, 0x9C000000, 0x9C000000, 0x9A000015, 0x98000000, 0x91000000, 0x8B000000, 0x85000000, 0x80000000, 0x79000000, 0x3422384A, 0x292E675C, 0x6C000000, 0x6A000000, 0x6C000000, 0x6C000000, 
        0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x94001515, 0x9C000000, 0xA7000015, 0xAF000015, 0xB9000000, 0xC1000000, 0xC8000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE6000000, 0xEC000000, 
        0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0022A474, 0x00225459, 0x002B8669, 0x00277D62, 0x002B8669, 0x002B8669, 0x0022A474, 0x002BC98C, 0x0042E4B3, 0x005FE4B6, 0x002B8669, 0x00225459, 0x00226760, 0x0022B180, 0x002BC98C, 0x0035C397, 
        0x003BBA87, 0x0022B180, 0x002BA485, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x005FE4B6, 0x0046D69A, 0x003BBA87, 0x0042E4B3, 0x002BC98C, 0x04274655, 0x011C2B48, 0x00222248, 0x00277D62, 0x0035A48F, 0x005FE4B6, 0x00277D62, 0x0022384C, 0x00276B62, 
        0x002B8669, 0x002B8669, 0x00229A7E, 0x002BA485, 0x0046B497, 0x0146C3A8, 0x0378C6BE, 0x005FE4B6, 0x0050A689, 0x00226760, 0x00225A6F, 0x00225459, 0x00225565, 0x00225565, 0x00274057, 0x00225A6F, 0x00224060, 0x00274057, 0x00223D5A, 0x00225565, 
        0x00225A6F, 0x00225A6F, 0x00223D5A, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C0038, 0x00220040, 0x00223D5A, 0x0022786F, 0x011C2B48, 0x001C003B, 0x001C003B, 0x001C003D, 0x00150040, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x00150035, 0x004A4062, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5D000000, 0x60000000, 0x65000000, 0x6C000000, 0x73000000, 0x7A000015, 0x83000000, 0x8B000000, 0x95000000, 
        0x9C000000, 0xA4000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB1000000, 0xB1000000, 0xAE000000, 0xAB000000, 0xA4000000, 0x9E000015, 0x95000000, 0x8E000000, 0x85000000, 0x7F001515, 0x79000000, 0x74000015, 0x74000015, 0x74000015, 0x74000015, 
        0x74000015, 0x7A000015, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA2000015, 0xAE000000, 0xB7000000, 0xC1000000, 0xCB000000, 0xD3000000, 0xD8000000, 0xDD000000, 0xE2000000, 0xE5000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF2000000, 
        0xF5000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x00276B62, 0x00220042, 0x01223D4C, 0x00277D62, 0x002B8669, 0x002B8669, 0x002B8669, 0x0022BC83, 0x0027D297, 0x004CEAC9, 0x002BC98C, 0x011C3B4A, 0x001C0038, 0x002B545D, 0x0022B180, 0x002BC98C, 
        0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022BC83, 0x0027D297, 0x0046D69A, 0x005FE4B6, 0x002EE1AD, 0x003BBA87, 0x00276B62, 0x00274057, 0x01223D4C, 0x00222248, 0x00276B62, 0x0022786F, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x01223D4C, 
        0x00277D62, 0x002B8669, 0x0022A474, 0x0022A474, 0x002B8669, 0x0022A474, 0x003BBA87, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x0050A689, 0x00356762, 0x002B545D, 0x00274057, 0x00225565, 0x00274057, 0x00225565, 0x00224060, 0x04274655, 0x00223D5A, 
        0x00274057, 0x002E3255, 0x00223D5A, 0x011C2B48, 0x00220042, 0x00220042, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C003D, 0x001C003B, 0x00220042, 0x0027154C, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x001C0035, 0x001C005A, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x73000000, 0x7D000000, 0x88000000, 0x91000000, 0x9C000000, 0xA7000000, 
        0xAF000015, 0xB6000000, 0xBB000000, 0xC1000000, 0xC4000000, 0xC4000000, 0xC4000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB1000000, 0xA7000000, 0x9E000015, 0x95000000, 0x8B001515, 0x85000000, 0x81000015, 0x7A000015, 0x7A000015, 0x7F001515, 
        0x81001C15, 0x88000015, 0x90000015, 0x94001C15, 0x9E000015, 0xA7000015, 0xB3000015, 0xBD000000, 0xC8000000, 0xD0000000, 0xD9000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xED000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 
        0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x005FE4B6, 0x01223D4C, 0x00220042, 0x001C0046, 0x00277D62, 0x00277D62, 0x002B8669, 0x002B8669, 0x00229A7E, 0x0035C397, 0x0146C3A8, 0x005FE4B6, 0x002B8669, 0x011C3B4A, 0x011C2B48, 0x00225459, 0x002BA485, 
        0x0027D297, 0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022B180, 0x002BC98C, 0x0027D297, 0x0042E4B3, 0x0046D69A, 0x00226760, 0x0022384C, 0x0022384C, 0x011C2B48, 0x00276B62, 0x00277D62, 0x00229A7E, 0x005FE4B6, 0x0046D69A, 0x00225459, 
        0x00225459, 0x00226760, 0x002B8669, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x0022A474, 0x0022B180, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x00449582, 0x002B545D, 0x00274057, 0x01273250, 0x00274057, 0x0022384C, 0x00274057, 0x00222248, 
        0x00222248, 0x0027154C, 0x01273250, 0x002E3255, 0x00220040, 0x001C0046, 0x0027154C, 0x0027154C, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x001C0038, 0x0015002E, 0x00220042, 0x3422384A, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 0xA2000015, 0xAE000000, 0xB9000000, 
        0xC3000000, 0xC9000000, 0xCE000000, 0xD3000000, 0xD6000000, 0xD8000000, 0xD6000000, 0xD3000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBB000000, 0xB1000000, 0xA7000000, 0x9E000015, 0x95000015, 0x8E000000, 0x8B001515, 0x88000015, 0x8B001515, 
        0x8B001515, 0x94001C15, 0x9A000015, 0xA2000015, 0xAB000015, 0xB6000000, 0xC1000000, 0xCB000000, 0xD5000000, 0xDD000000, 0xE4000000, 0xEA000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFB000000, 
        0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0046D69A, 0x002B8669, 0x001C0046, 0x01223D4C, 0x0022A474, 0x002B8669, 0x002B8669, 0x002B8669, 0x002B8669, 0x0027B498, 0x0027B498, 0x0146C3A8, 0x0046D69A, 0x00276B62, 0x00225459, 0x0022384C, 0x00274057, 
        0x00229A7E, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x0027B498, 0x00229A7E, 0x0022BC83, 0x002BC98C, 0x0046D69A, 0x005FE4B6, 0x00225459, 0x00225459, 0x002B545D, 0x00225459, 0x002B8669, 0x00276B62, 0x002BC98C, 0x005FE4B6, 0x004CAE84, 
        0x002B545D, 0x00356762, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x002B8669, 0x0022A474, 0x0022B180, 0x0035C397, 0x005FE4B6, 0x0046B497, 0x011C3B4A, 0x00220042, 0x001C003B, 0x001C0046, 0x00220042, 0x00220042, 
        0x00222248, 0x0022384C, 0x00485263, 0x01223D4C, 0x00222248, 0x001C003D, 0x001C0046, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x0027154C, 
        0x001C003D, 0x0015002E, 0x001C003B, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x5A000000, 0x5C000000, 0x60000000, 0x66000000, 0x70000000, 0x7A000015, 0x88000000, 0x95000000, 0xA4000000, 0xB1000000, 0xC0000000, 0xC9000000, 
        0xD3000000, 0xD9000000, 0xDF000000, 0xE2000000, 0xE4000000, 0xE5000000, 0xE5000000, 0xE3000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCC000000, 0xC3000000, 0xB9000000, 0xAF000015, 0xA7000015, 0x9E000015, 0x9A000015, 0x95000015, 0x94001C15, 
        0x95000015, 0x9E000015, 0xA2000015, 0xAB000015, 0xB5000000, 0xC0000000, 0xCB000000, 0xD5000000, 0xDE000000, 0xE6000000, 0xED000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022A474, 0x0035A48F, 0x0022786F, 0x00276B62, 0x002BAF7D, 0x0022BC83, 0x002B8669, 0x002B8669, 0x002B8669, 0x00229A7E, 0x0022B180, 0x002BA485, 0x0046B497, 0x00229A7E, 0x00276B62, 0x00226760, 0x00276B62, 
        0x00276B62, 0x003B7E72, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x0027B498, 0x00229A7E, 0x0022B180, 0x002BC98C, 0x0146C3A8, 0x0046D69A, 0x04274655, 0x00274057, 0x00225459, 0x002B8669, 0x00276B62, 0x00229A7E, 0x0046D69A, 0x005FE4B6, 
        0x00277D62, 0x57000000, 0x37001535, 0x04274655, 0x00277D62, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0022B180, 0x0035C397, 0x0046D69A, 0x0046D69A, 0x00225459, 0x1515153D, 0x1515153D, 0x1515153D, 0x1515153D, 
        0x3422384A, 0x57000000, 0x57000000, 0x57000000, 0x04274655, 0x00220040, 0x00220040, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x001C0046, 
        0x0022003D, 0x001C0035, 0x001C0035, 0x002E3255, 0x57000000, 0x57000000, 0x58000000, 0x59000000, 0x5A000000, 0x5D000000, 0x62000000, 0x6A000000, 0x74000015, 0x81000015, 0x91000000, 0xA1000000, 0xB1000000, 0xC0000000, 0xCD000000, 0xD8000000, 
        0xE0000000, 0xE6000000, 0xEB000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xF0000000, 0xEE000000, 0xEB000000, 0xE7000000, 0xE2000000, 0xDA000000, 0xD3000000, 0xC9000000, 0xC0000000, 0xB7000000, 0xAF000015, 0xA7000015, 0xA4000015, 0xA2000015, 
        0xA2000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC6000000, 0xD0000000, 0xDB000000, 0xE4000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x002EB1A3, 0x002EC3AC, 0x00229A7E, 0x0027CA7E, 0x0022A474, 0x00276B62, 0x002B8669, 0x002B8669, 0x003B7E72, 0x0022A489, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00226760, 0x00277D62, 0x0022BC83, 
        0x002BAF7D, 0x00226760, 0x0022786F, 0x0022B180, 0x0035C397, 0x0035C397, 0x0027B498, 0x0035A48F, 0x00229A7E, 0x002BA485, 0x0022BC83, 0x0146C3A8, 0x003BBA87, 0x011C3B4A, 0x00274057, 0x002B8669, 0x00277D62, 0x00276B62, 0x002BC98C, 0x0046D69A, 
        0x0046D69A, 0x3422384A, 0x57000000, 0x57000000, 0x04274655, 0x00276B62, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x002BAF7D, 0x0035C397, 0x0046D69A, 0x0046D69A, 0x292E675C, 0x57000000, 0x57000000, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x001C0038, 0x001C0046, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 0x001C003D, 
        0x001C003D, 0x00220040, 0x001C0035, 0x001C003D, 0x3422384A, 0x57000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x98000000, 0xAB000000, 0xBB000000, 0xCC000000, 0xD9000000, 0xE3000000, 
        0xEA000000, 0xF0000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF6000000, 0xF4000000, 0xF0000000, 0xEC000000, 0xE7000000, 0xE0000000, 0xD8000000, 0xD0000000, 0xC8000000, 0xC0000000, 0xB9000000, 0xB3000015, 0xAF000015, 
        0xAF000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xC0000000, 0xC9000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x003B7E72, 0x002EB1A3, 0x002EC3AC, 0x003BBA87, 0x0022A474, 0x0022384C, 0x00225459, 0x002B8669, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00277D62, 0x00276B62, 0x00276B62, 0x00226760, 0x002BAF7D, 0x0027CA7E, 
        0x0027CA7E, 0x0022A474, 0x00226760, 0x00226760, 0x0022A489, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x002BA485, 0x003BBA87, 0x0146C3A8, 0x0022A474, 0x011C2B48, 0x002B8669, 0x002B8669, 0x00277D62, 0x00229A7E, 0x0027D297, 
        0x005FE4B6, 0x0022A474, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x002BA485, 0x0035C397, 0x0042E4B3, 0x0146C3A8, 0x292E675C, 0x57000000, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x001C003D, 0x001C0038, 0x001C0046, 0x0027154C, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x001C0046, 0x001C003B, 
        0x001C003D, 0x00220042, 0x0015002E, 0x00150035, 0x19222250, 0x57000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB3000015, 0xC4000000, 0xD3000000, 0xE2000000, 0xEB000000, 
        0xF1000000, 0xF6000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xEB000000, 0xE5000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC3000000, 0xBD000000, 
        0xBB000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xC3000000, 0xCB000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00277D62, 0x002EB1A3, 0x002EC3AC, 0x002EC3B9, 0x002B8669, 0x02221C46, 0x011C2B48, 0x00276B62, 0x002B8669, 0x002B8669, 0x00276B62, 0x00356762, 0x00225459, 0x00225459, 0x002BAF7D, 0x0027CA7E, 0x0027CA7E, 
        0x0027D297, 0x0042E4B3, 0x002BC98C, 0x00276B62, 0x002B8669, 0x0022786F, 0x00229A7E, 0x0146C3A8, 0x002EC3AC, 0x002EC3AC, 0x0027B498, 0x00229A7E, 0x0022B180, 0x0035C397, 0x0022A474, 0x00277D62, 0x002B8669, 0x002B8669, 0x002B8669, 0x0035C397, 
        0x0027D297, 0x005FE4B6, 0x292E675C, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0035C397, 0x002EE4BA, 0x0046D69A, 0x292E675C, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x1515153D, 0x001C003B, 0x001C0035, 0x001C003B, 0x00220042, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C005A, 0x001C005A, 0x0027154C, 0x001C0046, 0x001C003D, 0x001C0038, 
        0x001C0038, 0x00220042, 0x001C003B, 0x001C0035, 0x002E3255, 0x57000000, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x80000000, 0x91000000, 0xA4000000, 0xB9000000, 0xCB000000, 0xDA000000, 0xE7000000, 0xF0000000, 
        0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF6000000, 0xF3000000, 0xEE000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xCB000000, 
        0xC4000000, 0xC3000000, 0xC1000000, 0xC3000000, 0xC6000000, 0xCC000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x0035A48F, 0x002EE6D4, 0x002EE4C8, 0x0146C3A8, 0x0022384C, 0x0022384C, 0x00274057, 0x002B8669, 0x002B8669, 0x00225459, 0x00225459, 0x01223D4C, 0x00229A7E, 0x0027CA7E, 0x0027CA7E, 0x002EE1AD, 
        0x0042E4B3, 0x004CEAC9, 0x0042E4B3, 0x003BBA87, 0x00449582, 0x011C2B48, 0x011C2B48, 0x00227575, 0x0027B498, 0x002EC3AC, 0x002EC3B9, 0x002EB1A3, 0x00229A7E, 0x0022B180, 0x0035C397, 0x00229A7E, 0x002B8669, 0x002B8669, 0x002B8669, 0x00229A7E, 
        0x0027D297, 0x0046D69A, 0x0035C397, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x19222250, 0x00226760, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0027B498, 0x002EE4BA, 0x0035C397, 0x3422384A, 
        0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x011C2B48, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C003B, 0x00220042, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x001C0038, 0x001C0038, 
        0x001C0038, 0x001C003D, 0x002B0048, 0x001C0035, 0x00220042, 0x3422384A, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x69000000, 0x73000000, 0x81000015, 0x94001515, 0xA7000000, 0xBB000000, 0xCD000000, 0xDD000000, 0xEA000000, 0xF2000000, 
        0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEE000000, 0xE9000000, 0xE3000000, 0xDD000000, 0xD8000000, 
        0xD0000000, 0xCC000000, 0xC9000000, 0xC9000000, 0xCB000000, 0xCE000000, 0xD6000000, 0xDD000000, 0xE6000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x00229A7E, 0x002EC3B9, 0x002EE4C8, 0x004CEAC9, 0x00225459, 0x0022384C, 0x01273250, 0x00356762, 0x00276B62, 0x002B545D, 0x01223D4C, 0x0022786F, 0x0027CA7E, 0x0027CA7E, 0x0046D69A, 0x002EE4BA, 
        0x004CEAC9, 0x004CEAC9, 0x006DEDD4, 0x0050A689, 0x37001535, 0x57000000, 0x57000000, 0x011C3B4A, 0x00225459, 0x00427B7F, 0x002EC3AC, 0x002EC3B9, 0x002EC3AC, 0x002BA485, 0x002BA485, 0x0035C397, 0x0022A474, 0x002B8669, 0x002B8669, 0x00277D62, 
        0x0027B498, 0x0027D297, 0x005FE4B6, 0x292E675C, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x1B2B3B55, 0x00276B62, 0x002BA485, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x0027B498, 0x002EE4BA, 0x0022A474, 
        0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x37001535, 0x00220040, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x00220035, 0x001C0035, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C0035, 0x001C0038, 
        0x001C003D, 0x001C003D, 0x001C0046, 0x00150035, 0x001C0038, 0x19222250, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x81000015, 0x94001515, 0xA7000000, 0xBB000000, 0xCE000000, 0xDE000000, 0xEB000000, 0xF4000000, 
        0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF5000000, 0xF1000000, 0xED000000, 0xE7000000, 0xE2000000, 
        0xDC000000, 0xD8000000, 0xD3000000, 0xD0000000, 0xD0000000, 0xD3000000, 0xD9000000, 0xDF000000, 0xE7000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x0022A474, 0x002EB1A3, 0x002EE4C8, 0x002EE4C8, 0x002BA485, 0x0022384C, 0x011C2B48, 0x0022384C, 0x002B545D, 0x01223D4C, 0x00225459, 0x0022BC83, 0x0027CA7E, 0x002EE1AD, 0x002EE4BA, 0x004CEAC9, 
        0x004CEAC9, 0x006DEDD4, 0x004C9987, 0x37001535, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x02221C46, 0x00225459, 0x00229A7E, 0x002EC3AC, 0x002EE1AD, 0x003BBA87, 0x0022B180, 0x0035C397, 0x0022A474, 0x002B8669, 0x002B8669, 
        0x00229A7E, 0x0035C397, 0x0146C3A8, 0x0046B497, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x04274655, 0x0022786F, 0x00229A7E, 0x002BAF7D, 0x0022A474, 0x0027B498, 0x002EE1AD, 
        0x002B8669, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x011C2B48, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C003D, 
        0x001C0038, 0x001C003D, 0x00220042, 0x001C003B, 0x0015002E, 0x00383B5F, 0x58000000, 0x59000000, 0x5B000000, 0x60000000, 0x67000000, 0x70000000, 0x80000000, 0x91000000, 0xA4000000, 0xBB000000, 0xCD000000, 0xDE000000, 0xEA000000, 0xF3000000, 
        0xF9000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xEB000000, 
        0xE6000000, 0xE2000000, 0xDD000000, 0xDA000000, 0xD9000000, 0xDA000000, 0xDE000000, 0xE3000000, 0xE9000000, 0xEF000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x002BAF7D, 0x00229A7E, 0x002EC3B9, 0x002EE4C8, 0x0146C3A8, 0x0022384C, 0x011C2B48, 0x011C2B48, 0x0022384C, 0x0022384C, 0x0022A474, 0x0027CA7E, 0x002EE1AD, 0x002EE4BA, 0x004CEAC9, 0x006DEDD4, 
        0x005FE4B6, 0x003B7E72, 0x37001535, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x002B545D, 0x00229A7E, 0x0146C3A8, 0x0027D297, 0x0022BC83, 0x002BC98C, 0x00229A7E, 0x002B8669, 
        0x002B8669, 0x0035C397, 0x0035C397, 0x005FE4B6, 0x1B2B3B55, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x37001535, 0x00226760, 0x002B8669, 0x002BAF7D, 0x0022A474, 0x0035C397, 
        0x0035C397, 0x3422384A, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5C000000, 0x011C2B48, 0x001C0038, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0038, 0x00220035, 0x001C003B, 0x001C003B, 0x001C0038, 0x001C003D, 
        0x00220040, 0x001C003D, 0x00220042, 0x00220042, 0x00150035, 0x001C0046, 0x3422384A, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA4000000, 0xB7000000, 0xCB000000, 0xDC000000, 0xE9000000, 0xF2000000, 
        0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF8000000, 0xF6000000, 0xF2000000, 
        0xEE000000, 0xEA000000, 0xE6000000, 0xE3000000, 0xE2000000, 0xE2000000, 0xE4000000, 0xE8000000, 0xEC000000, 0xF1000000, 0xF6000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x0022BC83, 0x002BAF7D, 0x002EB1A3, 0x002EC3B9, 0x005FE4B6, 0x04274655, 0x01273250, 0x0022384C, 0x00274057, 0x0022A474, 0x0027CA7E, 0x0042E4B3, 0x0042E4B3, 0x006DEDD4, 0x006DEDD4, 0x006DEDD4, 
        0x00276B62, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x00274057, 0x003B7E72, 0x003BBA87, 0x0022BC83, 0x0022BC83, 0x00229A7E, 
        0x002B8669, 0x002BA485, 0x0035C397, 0x002EC3B9, 0x003BBA87, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x5F000000, 0x37001535, 0x00276B62, 0x0022A474, 0x0022A474, 
        0x0035C397, 0x0022B180, 0x59000000, 0x59000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x1515153D, 0x001C003B, 0x001C003D, 0x001C0038, 0x001C003D, 0x001C0038, 0x00150035, 0x001C0035, 0x00150040, 0x001C0038, 0x00220040, 
        0x001C003D, 0x0022003D, 0x001C003B, 0x001C0046, 0x001C0035, 0x00150038, 0x19222250, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6E000000, 0x7A000015, 0x8B000000, 0x9E000015, 0xB5000000, 0xC8000000, 0xD9000000, 0xE7000000, 0xF1000000, 
        0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF7000000, 
        0xF4000000, 0xF1000000, 0xEE000000, 0xEC000000, 0xEA000000, 0xEA000000, 0xEB000000, 0xED000000, 0xF1000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x0022B180, 0x002BAF7D, 0x0027B498, 0x002EE4C8, 0x002EE4C8, 0x00225459, 0x0022384C, 0x0022384C, 0x00276B62, 0x0027CA7E, 0x002EE1AD, 0x004CEAC9, 0x006DEDD4, 0x004CEAC9, 0x002EE4BA, 0x004CEAC9, 
        0x003BBA87, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x37001535, 0x02221C46, 0x00225459, 0x002B8669, 0x0022A474, 0x003BBA87, 
        0x00449582, 0x003B7E72, 0x0027B498, 0x002EB1A3, 0x0146C3A8, 0x37001535, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x292E675C, 0x00229A7E, 
        0x0022A474, 0x0035C397, 0x00277D62, 0x5A000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x67000000, 0x02221C46, 0x001C0038, 0x00220042, 0x0015003D, 0x001C0038, 0x001C0035, 0x00150035, 0x001C003D, 0x001C003D, 0x0022003D, 
        0x001C003D, 0x001C003D, 0x001C003B, 0x001C0046, 0x0022003D, 0x001C003B, 0x00223D5A, 0x58000000, 0x5A000000, 0x5D000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9C000000, 0xB1000000, 0xC3000000, 0xD5000000, 0xE4000000, 0xEF000000, 
        0xF6000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 
        0xF9000000, 0xF7000000, 0xF5000000, 0xF3000000, 0xF1000000, 0xF1000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x8B224040, 0x00229A7E, 0x0022BC83, 0x002BA485, 0x002EC3B9, 0x002EE4C8, 0x00277D62, 0x0022384C, 0x00274057, 0x0022A474, 0x002EE1AD, 0x004CEAC9, 0x006DEDD4, 0x005FE4B6, 0x0027B498, 0x002EC3AC, 0x0042E4B3, 
        0x005FE4B6, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x1515153D, 0x01223D4C, 0x00276B62, 
        0x00229A7E, 0x0022786F, 0x0035A48F, 0x002EB1A3, 0x002EC3B9, 0x292E675C, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x65000000, 0x67000000, 0x68001515, 0x68001515, 0x67000000, 0x65000000, 0x3422384A, 
        0x00229A7E, 0x0022B180, 0x002BA485, 0x3422384A, 0x5D000000, 0x5F000000, 0x60000000, 0x65000000, 0x68001515, 0x6E000000, 0x74000015, 0x001C153B, 0x001C003B, 0x001C0038, 0x001C0038, 0x00220035, 0x001C0035, 0x001C0038, 0x001C003D, 0x0022003D, 
        0x0015003D, 0x00220042, 0x001C003D, 0x001C0046, 0x002B0048, 0x001C0035, 0x001C0046, 0x3422384A, 0x5A000000, 0x5D000000, 0x62000000, 0x6A000000, 0x75000000, 0x83000000, 0x98000000, 0xAB000000, 0xC0000000, 0xD0000000, 0xE0000000, 0xEC000000, 
        0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 
        0xFC000000, 0xFB000000, 0xF9000000, 0xF8000000, 0xF7000000, 0xF6000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x0022786F, 0x0022BC83, 0x0022A474, 0x002EC3B9, 0x002EE4C8, 0x00277D62, 0x0022384C, 0x00276B62, 0x0027D297, 0x004CEAC9, 0x004CEAC9, 0x0050A689, 0x0027B498, 0x0027B498, 0x0027B498, 0x002EE4BA, 
        0x006DEDD4, 0x292E675C, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5A000000, 0x00274057, 0x00356762, 
        0x00276B62, 0x002B8669, 0x0040818E, 0x002EB1A3, 0x002EB1A3, 0x002B8669, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x63000000, 0x68001515, 0x6C000000, 0x6E000000, 0x70000015, 0x70000015, 0x70000015, 0x6C000000, 0x6A000000, 
        0x1B2B3B55, 0x00229A7E, 0x003BBA87, 0x00276B62, 0x60000000, 0x62000000, 0x65000000, 0x68001515, 0x70000015, 0x75000000, 0x7D000000, 0x02221C46, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C003D, 0x001C0046, 
        0x001C003D, 0x001C003D, 0x00150040, 0x00220040, 0x001C0046, 0x001C0038, 0x001C003D, 0x19222250, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x80000000, 0x91000000, 0xA4000000, 0xB9000000, 0xCC000000, 0xDC000000, 0xE9000000, 
        0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 
        0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x3422384A, 0x002BAF7D, 0x0022BC83, 0x002EC3AC, 0x002EE4C8, 0x00277D62, 0x04274655, 0x003BBA87, 0x004CEAC9, 0x005FE4B6, 0x00356762, 0x3422384A, 0x0022757D, 0x0027B498, 0x0035A48F, 0x002EC3AC, 
        0x004CEAC9, 0x003BBA87, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x37001535, 0x00227575, 
        0x00449582, 0x00449582, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x004C9987, 0x59000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x66000000, 0x6C000000, 0x70000015, 0x74000015, 0x7A000015, 0x7A000015, 0x7A000015, 0x79000000, 0x74000015, 
        0x70000000, 0x1B2B3B55, 0x00229A7E, 0x0022A474, 0x65000000, 0x66000000, 0x68001515, 0x6E000000, 0x74000015, 0x7F001515, 0x88000015, 0x57000000, 0x001C003D, 0x001C003D, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C0035, 0x00150035, 0x00220042, 
        0x00220042, 0x00220042, 0x00220042, 0x00220042, 0x001C0046, 0x00220042, 0x001C003B, 0x00224060, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x70000000, 0x7D000000, 0x8B000000, 0xA1000000, 0xB5000000, 0xC8000000, 0xD8000000, 0xE6000000, 
        0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x002B8669, 0x0022BC83, 0x0027B498, 0x002EE4C8, 0x00277D62, 0x002B8669, 0x004CEAC9, 0x0046B497, 0x04274655, 0xB6000000, 0xA1000000, 0x57000000, 0x00276B62, 0x0022B180, 0x0035A48F, 
        0x002EE1AD, 0x0146C3A8, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x62000000, 0x62000000, 0x63000000, 0x63000000, 0x00225565, 
        0x00229A7E, 0x00449582, 0x0022786F, 0x00449582, 0x002EB1A3, 0x0046B497, 0x5A000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x62000000, 0x68001515, 0x70000015, 0x75000000, 0x7D000000, 0x81000015, 0x85000000, 0x85000000, 0x83000000, 0x81000015, 
        0x7D000000, 0x79000000, 0x37001535, 0x00229A7E, 0x6C000000, 0x6C000000, 0x6E000000, 0x74000015, 0x7D000000, 0x85000000, 0x90000015, 0x9A000015, 0x5C000000, 0x001C153B, 0x00220040, 0x0022003D, 0x001C0035, 0x001C0038, 0x001C0035, 0x00220040, 
        0x00150040, 0x00220042, 0x00150040, 0x001C0046, 0x001C0046, 0x00220042, 0x001C003B, 0x001C0046, 0x3422384A, 0x5A000000, 0x5F000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 0xD3000000, 0xE2000000, 
        0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x00226760, 0x0022BC83, 0x0027B498, 0x002EE4BA, 0x00276B62, 0x0035C397, 0x00449582, 0x7F001515, 0xCB000000, 0xB6000000, 0xA1000000, 0x8E000000, 0x37001535, 0x003B7E72, 0x002BA485, 
        0x002EC3AC, 0x005FE4B6, 0x1B2B3B55, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5C000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x37001535, 
        0x0022757D, 0x00229A7E, 0x003B7E72, 0x00449582, 0x002EB1A3, 0x002EB1A3, 0x1B2B3B55, 0x5C000000, 0x5D000000, 0x5F000000, 0x63000000, 0x6A000000, 0x70000015, 0x7A000015, 0x81001C15, 0x8B001515, 0x90000015, 0x91000000, 0x91000000, 0x8E000000, 
        0x8B000000, 0x83000000, 0x7F001515, 0x7A000015, 0x74000015, 0x74000015, 0x74000015, 0x7A000015, 0x81001C15, 0x8B001515, 0x94001C15, 0xA2000015, 0xAB000015, 0x37001535, 0x001C003D, 0x00220042, 0x001C0038, 0x001C0038, 0x00150035, 0x001C0038, 
        0x001C0046, 0x001C0046, 0x001C0046, 0x00150040, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x1B2B3B55, 0x5A000000, 0x5C000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 0xCD000000, 0xDD000000, 
        0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x3422384A, 0x002BAF7D, 0x0027B498, 0x002EE1AD, 0x00276B62, 0x003B7E72, 0x88000015, 0xDC000000, 0xCB000000, 0xB6000000, 0xA1000000, 0x8E000000, 0x7D000000, 0x04274655, 0x00229A7E, 
        0x0027B498, 0x004CEAC9, 0x292E675C, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x60000000, 0x65000000, 0x69000000, 0x6C000000, 0x73000000, 0x75000000, 0x79000000, 0x79000000, 0x75000000, 
        0x00225565, 0x00229A7E, 0x00449582, 0x0040818E, 0x0035A48F, 0x002EB1A3, 0x1B2B3B55, 0x5F000000, 0x5F000000, 0x60000000, 0x65000000, 0x6C000000, 0x74000015, 0x7F001515, 0x88000015, 0x90000015, 0x98000000, 0x9E000015, 0x9E000015, 0x9E000015, 
        0x98000000, 0x95000000, 0x8E000000, 0x85000000, 0x81000015, 0x7F001515, 0x7F001515, 0x81001C15, 0x85000000, 0x90000015, 0x9A000015, 0xA7000015, 0xAF000015, 0xB9000000, 0x02221C46, 0x001C003D, 0x001C003B, 0x001C003B, 0x001C0038, 0x0015002E, 
        0x001C0046, 0x00220042, 0x00220042, 0x001C0046, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x00223D5A, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 0xC8000000, 0xD8000000, 
        0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x0035C397, 0x0027D297, 0x1515153D, 0xF3000000, 0xE9000000, 0xDC000000, 0xCB000000, 0xB7000000, 0xA2000015, 0x8E000000, 0x7D000000, 0x6E000000, 0x00225A6F, 
        0x0035A48F, 0x005FE4B6, 0x0022A474, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x65000000, 0x69000000, 0x70000000, 0x79000000, 0x7D000000, 0x83000000, 0x85000000, 0x88000000, 0x85000000, 
        0x57000000, 0x0022757D, 0x00229A7E, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x292E675C, 0x63000000, 0x62000000, 0x62000000, 0x66000000, 0x6C000000, 0x74000015, 0x7F001515, 0x8B001515, 0x94001C15, 0x9E000015, 0xA7000015, 0xAB000000, 0xAB000000, 
        0xAB000000, 0xA4000000, 0x9C000000, 0x95000000, 0x8E000000, 0x8B001515, 0x88000015, 0x88000015, 0x8B001515, 0x94001C15, 0x9E000015, 0xA7000015, 0xB3000015, 0xBB000000, 0x37001535, 0x001C003D, 0x001C0046, 0x001C003B, 0x001C0038, 0x0015002E, 
        0x001C003D, 0x001C0046, 0x002B0048, 0x001C0046, 0x00220042, 0x00220042, 0x001C0046, 0x001C0038, 0x002E3255, 0x59000000, 0x5A000000, 0x5F000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 0xD3000000, 
        0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x0035C397, 0x002BA485, 0xF9000000, 0xF3000000, 0xE9000000, 0xDC000000, 0xCB000000, 0xB7000000, 0xA2000015, 0x8E000000, 0x7D000000, 0x70000000, 0x37001535, 
        0x0022757D, 0x002EB1A3, 0x004CAE84, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x62000000, 0x69000000, 0x70000000, 0x7A000015, 0x83000000, 0x8B000000, 0x94001515, 0x98000000, 0x98000000, 0x98000000, 
        0x94001515, 0x04274655, 0x0040818E, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x292E675C, 0x69000000, 0x67000000, 0x66000000, 0x67000000, 0x6C000000, 0x74000015, 0x7F001515, 0x8B001515, 0x98000000, 0xA2000015, 0xAE000000, 0xB5000000, 0xB9000000, 
        0xB9000000, 0xB5000000, 0xAF000015, 0xA7000000, 0x9E000015, 0x9A000015, 0x94001515, 0x94001C15, 0x94001C15, 0x98000000, 0x9E000015, 0xA7000015, 0xB3000015, 0xBD000000, 0xC4000000, 0x011C2B48, 0x001C003D, 0x001C003D, 0x001C003D, 0x001C0035, 
        0x0015002E, 0x001C003D, 0x001C0046, 0x001C0046, 0x001C0046, 0x00220042, 0x0027154C, 0x001C003D, 0x00150040, 0x3422384A, 0x5A000000, 0x5C000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 0xCE000000, 
        0xDD000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x002B8669, 0x0035C397, 0x00225459, 0xF9000000, 0xF3000000, 0xEA000000, 0xDD000000, 0xCC000000, 0xB9000000, 0xA4000000, 0x8E000000, 0x7D000000, 0x70000000, 0x66000000, 
        0x19222250, 0x0035A48F, 0x0046B497, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x67000000, 0x6E000000, 0x79000000, 0x83000000, 0x90000015, 0x9C000000, 0xA4000000, 0xAB000000, 0xAB000000, 0xAB000000, 
        0xA7000000, 0x9E000015, 0x0022757D, 0x00427B7F, 0x0035A48F, 0x0035A48F, 0x1B2B3B55, 0x73000000, 0x6E000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x74000015, 0x7D000000, 0x88000015, 0x94001C15, 0xA4000015, 0xB1000000, 0xBB000000, 0xC3000000, 
        0xC4000000, 0xC4000000, 0xC0000000, 0xB9000000, 0xB1000000, 0xA7000015, 0xA2000015, 0x9E000015, 0x9C000000, 0x9E000015, 0xA2000015, 0xAB000015, 0xB3000015, 0xBD000000, 0xC4000000, 0x37001535, 0x001C003B, 0x001C003B, 0x001C003D, 0x001C0038, 
        0x001C0035, 0x00150038, 0x001C0046, 0x0027154C, 0x0027154C, 0x00220042, 0x001C0046, 0x001C0046, 0x001C003D, 0x19222250, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 0xC8000000, 
        0xD9000000, 0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x002BA485, 0x1515153D, 0xFA000000, 0xF4000000, 0xEB000000, 0xDE000000, 0xCE000000, 0xBB000000, 0xA4000000, 0x91000000, 0x80000000, 0x70000000, 0x67000000, 
        0x60000000, 0x00226D89, 0x0046B497, 0x5A000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x65000000, 0x6C000000, 0x74000015, 0x80000000, 0x8E000000, 0x9C000000, 0xAB000000, 0xB3000015, 0xBB000000, 0xBD000000, 0xBD000000, 
        0xB9000000, 0xB3000015, 0x00227575, 0x00449582, 0x0035A48F, 0x0050A689, 0x88000000, 0x80000000, 0x79000000, 0x73000000, 0x70000000, 0x70000000, 0x74000015, 0x7A000015, 0x85000000, 0x94001C15, 0xA2000015, 0xB3000015, 0xC0000000, 0xC9000000, 
        0xCE000000, 0xD0000000, 0xCE000000, 0xC9000000, 0xC3000000, 0xBB000000, 0xB1000000, 0xAB000000, 0xA7000015, 0xA7000015, 0xA7000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC4000000, 0xCB000000, 0x1515153D, 0x001C003B, 0x00220042, 0x001C0038, 
        0x001C0038, 0x001C003D, 0x00220042, 0x0027154C, 0x0027154C, 0x00220042, 0x001C0046, 0x0027154C, 0x00220040, 0x1515153D, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 
        0xD3000000, 0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x00276B62, 0xFD000000, 0xFA000000, 0xF5000000, 0xEC000000, 0xE0000000, 0xD0000000, 0xBD000000, 0xA7000000, 0x95000000, 0x83000000, 0x74000015, 0x69000000, 
        0x62000000, 0x19222250, 0x003B7E72, 0x5C000000, 0x5C000000, 0x5F000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x70000015, 0x7A000015, 0x88000015, 0x98000000, 0xA7000015, 0xB5000000, 0xC1000000, 0xC9000000, 0xCE000000, 0xCE000000, 
        0xCB000000, 0xC4000000, 0x3422384A, 0x00449582, 0x0035A48F, 0x002B8669, 0x98000000, 0x8E000000, 0x85000000, 0x7D000000, 0x79000000, 0x74000015, 0x74000015, 0x7A000015, 0x83000000, 0x90000015, 0xA2000015, 0xB1000000, 0xC1000000, 0xCD000000, 
        0xD6000000, 0xDA000000, 0xDA000000, 0xD8000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBB000000, 0xB5000000, 0xB1000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xBB000000, 0xC4000000, 0xCB000000, 0x74000015, 0x001C003B, 0x001C003D, 0x00220040, 
        0x001C0038, 0x001C0046, 0x002B0048, 0x00220042, 0x0027154C, 0x00222248, 0x001C003D, 0x002B0048, 0x001C003D, 0x1515153D, 0x59000000, 0x5A000000, 0x5D000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 
        0xCE000000, 0xDD000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x003B7E72, 0x37001535, 0xFD000000, 0xFB000000, 0xF6000000, 0xED000000, 0xE2000000, 0xD3000000, 0xC0000000, 0xAB000000, 0x98000000, 0x85000000, 0x79000000, 0x6C000000, 
        0x65000000, 0x62000000, 0x60000000, 0x60000000, 0x62000000, 0x63000000, 0x65000000, 0x67000000, 0x69000000, 0x6E000000, 0x74000015, 0x81001C15, 0x8E000000, 0x9E000015, 0xAF000015, 0xBD000000, 0xCC000000, 0xD5000000, 0xDB000000, 0xDC000000, 
        0xDA000000, 0xD6000000, 0x3422384A, 0x00449582, 0x0035A48F, 0x292E675C, 0xAB000000, 0x9E000015, 0x95000000, 0x8B000000, 0x81000015, 0x7A000015, 0x79000000, 0x7A000015, 0x83000000, 0x8E000000, 0x9E000015, 0xAF000015, 0xC0000000, 0xCE000000, 
        0xD9000000, 0xE0000000, 0xE3000000, 0xE2000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC4000000, 0xCC000000, 0xD3000000, 0x1515153D, 0x001C003D, 0x00220042, 
        0x001C003B, 0x002B0048, 0x00220042, 0x0027154C, 0x1B2B3B55, 0x04274655, 0x011C3B4A, 0x0022384C, 0x00274057, 0x37001535, 0x5A000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 
        0xC8000000, 0xD9000000, 0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xEF000000, 0xE5000000, 0xD6000000, 0xC4000000, 0xB1000000, 0x9C000000, 0x8B000000, 0x7A000015, 0x70000000, 
        0x69000000, 0x66000000, 0x65000000, 0x66000000, 0x69000000, 0x6A000000, 0x6C000000, 0x70000000, 0x70000015, 0x74000015, 0x7D000000, 0x85000000, 0x94001C15, 0xA2000015, 0xB5000000, 0xC4000000, 0xD3000000, 0xDD000000, 0xE4000000, 0xE7000000, 
        0xE6000000, 0xE3000000, 0x3422384A, 0x0035A48F, 0x00277D62, 0xC6000000, 0xBB000000, 0xB1000000, 0xA4000000, 0x98000000, 0x8B000000, 0x83000000, 0x7D000000, 0x7D000000, 0x81000015, 0x8B001515, 0x9A000015, 0xAB000000, 0xBD000000, 0xCE000000, 
        0xDB000000, 0xE4000000, 0xE9000000, 0xEA000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC4000000, 0xC1000000, 0xC1000000, 0xC3000000, 0xC8000000, 0xCE000000, 0xD5000000, 0xD8000000, 0x1515153D, 0x001C003D, 
        0x001C003D, 0x001C0046, 0x01273250, 0x59000000, 0x8B000000, 0x7D000000, 0x70000000, 0x67000000, 0x62000000, 0x5D000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 
        0xC3000000, 0xD3000000, 0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF1000000, 0xE8000000, 0xDA000000, 0xC9000000, 0xB6000000, 0xA4000000, 0x90000015, 0x81000015, 0x75000000, 
        0x70000000, 0x6C000000, 0x6C000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x7F001515, 0x81001C15, 0x8B001515, 0x98000000, 0xA7000015, 0xB9000000, 0xC8000000, 0xD8000000, 0xE2000000, 0xEA000000, 0xEE000000, 
        0xEF000000, 0xED000000, 0xEA000000, 0x292E675C, 0xDE000000, 0xD6000000, 0xCC000000, 0xC1000000, 0xB5000000, 0xA7000000, 0x98000000, 0x8E000000, 0x83000000, 0x80000000, 0x83000000, 0x8B001515, 0x98000000, 0xA7000015, 0xBB000000, 0xCC000000, 
        0xDB000000, 0xE6000000, 0xED000000, 0xF0000000, 0xF0000000, 0xEE000000, 0xE9000000, 0xE3000000, 0xDD000000, 0xD6000000, 0xD0000000, 0xCB000000, 0xC9000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD9000000, 0xDD000000, 0x7F001515, 0x001C0046, 
        0x00222248, 0x37001535, 0x59224244, 0xA7000000, 0x95000000, 0x85000000, 0x79000000, 0x6C000000, 0x65000000, 0x5F000000, 0x5C000000, 0x5A000000, 0x5A000000, 0x5D000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000015, 
        0xBB000000, 0xCE000000, 0xDE000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xF9000000, 0xF3000000, 0xEB000000, 0xDE000000, 0xCE000000, 0xBD000000, 0xAB000000, 0x98000000, 0x88000000, 0x7D000000, 
        0x79000000, 0x75000000, 0x75000000, 0x7A000015, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 0x88000015, 0x8B001515, 0x94001C15, 0x9C000000, 0xA7000015, 0xB9000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xED000000, 0xF2000000, 
        0xF4000000, 0xF4000000, 0xF2000000, 0xEE000000, 0xE9000000, 0xE2000000, 0xDA000000, 0xCE000000, 0xC3000000, 0xB5000000, 0xA4000000, 0x98000000, 0x8B000000, 0x85000000, 0x83000000, 0x88000015, 0x94001515, 0xA4000000, 0xB7000000, 0xC9000000, 
        0xD9000000, 0xE6000000, 0xEF000000, 0xF3000000, 0xF5000000, 0xF4000000, 0xF1000000, 0xED000000, 0xE7000000, 0xE2000000, 0xDB000000, 0xD8000000, 0xD3000000, 0xD3000000, 0xD5000000, 0xD9000000, 0xDE000000, 0xE2000000, 0xE4000000, 0xE2000000, 
        0xDB000000, 0xD0000000, 0xC3000000, 0xB1000000, 0xA1000000, 0x8E000000, 0x80000000, 0x73000000, 0x69000000, 0x62000000, 0x5D000000, 0x5B000000, 0x5A000000, 0x5C000000, 0x60000000, 0x66000000, 0x70000000, 0x7F001515, 0x8E000000, 0xA2000015, 
        0xB5000000, 0xC9000000, 0xD9000000, 0xE7000000, 0xF1000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE3000000, 0xD3000000, 0xC3000000, 0xB1000000, 0x9E000015, 0x90000015, 0x85000000, 
        0x80000000, 0x80000000, 0x83000000, 0x88000000, 0x8E000000, 0x94001515, 0x98000000, 0x98000000, 0x98000000, 0x95000015, 0x95000015, 0x9A000015, 0xA2000015, 0xAB000015, 0xBB000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF5000000, 
        0xF8000000, 0xF9000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEC000000, 0xE5000000, 0xDB000000, 0xCE000000, 0xC0000000, 0xB1000000, 0xA1000000, 0x95000000, 0x8B001515, 0x88000015, 0x8B001515, 0x94001515, 0xA4000000, 0xB5000000, 0xC8000000, 
        0xD8000000, 0xE5000000, 0xEF000000, 0xF5000000, 0xF8000000, 0xF8000000, 0xF7000000, 0xF4000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE2000000, 0xDE000000, 0xDD000000, 0xDE000000, 0xE2000000, 0xE4000000, 0xE8000000, 0xE9000000, 0xE8000000, 
        0xE2000000, 0xD9000000, 0xCC000000, 0xBB000000, 0xAB000000, 0x98000000, 0x88000000, 0x7A000015, 0x70000000, 0x66000000, 0x60000000, 0x5C000000, 0x5B000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x7A000015, 0x88000000, 0x9C000000, 
        0xB1000000, 0xC3000000, 0xD5000000, 0xE4000000, 0xEE000000, 0xF6000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xF0000000, 0xE7000000, 0xD9000000, 0xCB000000, 0xB9000000, 0xA7000000, 0x9A000015, 0x90000015, 
        0x8B000000, 0x8B000000, 0x91000000, 0x98000000, 0x9E000015, 0xA4000000, 0xA7000000, 0xAB000000, 0xA7000015, 0xA4000015, 0xA2000015, 0xA2000015, 0xA7000015, 0xAF000015, 0xBB000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF6000000, 
        0xF9000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF7000000, 0xF3000000, 0xED000000, 0xE5000000, 0xDA000000, 0xCC000000, 0xBB000000, 0xAB000000, 0x9E000015, 0x91000000, 0x8B001515, 0x8E000000, 0x94001515, 0xA2000015, 0xB3000015, 0xC4000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEE000000, 0xEA000000, 0xE7000000, 0xE6000000, 0xE6000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xEF000000, 0xEE000000, 
        0xE9000000, 0xE2000000, 0xD6000000, 0xC8000000, 0xB6000000, 0xA4000000, 0x94001515, 0x83000000, 0x75000000, 0x6C000000, 0x63000000, 0x5F000000, 0x5C000000, 0x5C000000, 0x5F000000, 0x62000000, 0x6A000000, 0x75000000, 0x85000000, 0x98000000, 
        0xAB000000, 0xC0000000, 0xD0000000, 0xE0000000, 0xEC000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF3000000, 0xEA000000, 0xDE000000, 0xD0000000, 0xC0000000, 0xB1000000, 0xA4000000, 0x9C000000, 
        0x98000000, 0x9A000015, 0xA1000000, 0xA7000000, 0xB1000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xB9000000, 0xB3000015, 0xAE000000, 0xAB000015, 0xAF000015, 0xB3000015, 0xC0000000, 0xCC000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF6000000, 
        0xFA000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xEC000000, 0xE2000000, 0xD5000000, 0xC6000000, 0xB6000000, 0xA7000015, 0x9A000015, 0x91000000, 0x90000015, 0x98000000, 0xA2000015, 0xB3000015, 0xC4000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF2000000, 0xEF000000, 0xEE000000, 0xEE000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF4000000, 0xF3000000, 
        0xEF000000, 0xE8000000, 0xDE000000, 0xD0000000, 0xC1000000, 0xAF000015, 0x9C000000, 0x8B000000, 0x7D000000, 0x70000000, 0x69000000, 0x62000000, 0x5F000000, 0x5D000000, 0x5F000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x94001515, 
        0xA7000015, 0xBB000000, 0xCD000000, 0xDE000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xED000000, 0xE3000000, 0xD6000000, 0xC8000000, 0xB9000000, 0xAE000000, 0xA7000000, 
        0xA4000000, 0xA7000000, 0xAF000015, 0xB9000000, 0xC1000000, 0xC8000000, 0xCB000000, 0xCB000000, 0xC8000000, 0xC1000000, 0xBB000000, 0xB7000000, 0xB7000000, 0xBB000000, 0xC3000000, 0xCE000000, 0xDA000000, 0xE6000000, 0xEF000000, 0xF6000000, 
        0xFA000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF1000000, 0xE9000000, 0xDD000000, 0xCE000000, 0xC0000000, 0xB1000000, 0xA2000015, 0x9A000015, 0x98000000, 0x9A000015, 0xA7000015, 0xB5000000, 0xC6000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF4000000, 0xF4000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF7000000, 
        0xF4000000, 0xEE000000, 0xE6000000, 0xDA000000, 0xCB000000, 0xBB000000, 0xA7000000, 0x95000000, 0x85000000, 0x79000000, 0x6C000000, 0x65000000, 0x62000000, 0x5F000000, 0x60000000, 0x63000000, 0x6A000000, 0x74000015, 0x81000015, 0x91000000, 
        0xA4000015, 0xB9000000, 0xCB000000, 0xDC000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xF0000000, 0xE7000000, 0xDB000000, 0xCE000000, 0xC3000000, 0xB9000000, 0xB3000015, 
        0xB1000000, 0xB6000000, 0xBD000000, 0xC8000000, 0xD0000000, 0xD6000000, 0xD9000000, 0xD8000000, 0xD5000000, 0xCE000000, 0xC8000000, 0xC3000000, 0xC0000000, 0xC3000000, 0xC9000000, 0xD3000000, 0xDD000000, 0xE7000000, 0xF0000000, 0xF6000000, 
        0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE4000000, 0xD8000000, 0xC8000000, 0xB9000000, 0xAB000000, 0xA2000015, 0x9E000015, 0xA2000015, 0xAB000015, 0xB9000000, 0xC8000000, 
        0xD8000000, 0xE5000000, 0xEF000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFA000000, 
        0xF8000000, 0xF3000000, 0xEC000000, 0xE2000000, 0xD3000000, 0xC4000000, 0xB1000000, 0xA1000000, 0x8E000000, 0x80000000, 0x74000015, 0x6C000000, 0x66000000, 0x63000000, 0x65000000, 0x67000000, 0x6C000000, 0x75000000, 0x83000000, 0x94001515, 
        0xA4000015, 0xB9000000, 0xCB000000, 0xDB000000, 0xE8000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF3000000, 0xEA000000, 0xE2000000, 0xD5000000, 0xCB000000, 0xC3000000, 0xBD000000, 
        0xC0000000, 0xC4000000, 0xCB000000, 0xD3000000, 0xDC000000, 0xE2000000, 0xE4000000, 0xE4000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCE000000, 0xCB000000, 0xCB000000, 0xD0000000, 0xD8000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF7000000, 
        0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF2000000, 0xE9000000, 0xDE000000, 0xD0000000, 0xC3000000, 0xB5000000, 0xAB000015, 0xA7000015, 0xA7000015, 0xAF000015, 0xBD000000, 0xCC000000, 
        0xDA000000, 0xE7000000, 0xF0000000, 0xF7000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 
        0xFA000000, 0xF7000000, 0xF1000000, 0xE8000000, 0xDC000000, 0xCE000000, 0xBD000000, 0xAB000000, 0x9A000015, 0x8B000000, 0x7D000000, 0x73000000, 0x6C000000, 0x6A000000, 0x6C000000, 0x6E000000, 0x73000000, 0x7D000000, 0x88000000, 0x98000000, 
        0xA7000000, 0xBB000000, 0xCC000000, 0xDB000000, 0xE8000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xF9000000, 0xF5000000, 0xEE000000, 0xE5000000, 0xDC000000, 0xD3000000, 0xCC000000, 0xC9000000, 
        0xCB000000, 0xCE000000, 0xD8000000, 0xDF000000, 0xE6000000, 0xEB000000, 0xED000000, 0xED000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD9000000, 0xD5000000, 0xD5000000, 0xD8000000, 0xDE000000, 0xE5000000, 0xEC000000, 0xF3000000, 0xF8000000, 
        0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE4000000, 0xD8000000, 0xCB000000, 0xC0000000, 0xB5000000, 0xAF000015, 0xB1000000, 0xB9000000, 0xC3000000, 0xD0000000, 
        0xDE000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFC000000, 0xF9000000, 0xF5000000, 0xED000000, 0xE3000000, 0xD6000000, 0xC8000000, 0xB6000000, 0xA4000000, 0x95000000, 0x88000000, 0x7D000000, 0x79000000, 0x74000015, 0x75000000, 0x79000000, 0x7D000000, 0x85000000, 0x91000000, 0x9E000015, 
        0xAE000000, 0xC0000000, 0xCE000000, 0xDD000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF1000000, 0xEA000000, 0xE2000000, 0xDB000000, 0xD6000000, 0xD3000000, 
        0xD5000000, 0xDA000000, 0xE0000000, 0xE7000000, 0xED000000, 0xF2000000, 0xF3000000, 0xF3000000, 0xF1000000, 0xEC000000, 0xE7000000, 0xE3000000, 0xDF000000, 0xDF000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xF0000000, 0xF5000000, 0xF9000000, 
        0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF2000000, 0xE9000000, 0xDF000000, 0xD3000000, 0xC8000000, 0xC0000000, 0xBB000000, 0xBB000000, 0xC3000000, 0xCB000000, 0xD8000000, 
        0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFD000000, 0xFB000000, 0xF8000000, 0xF2000000, 0xEA000000, 0xDF000000, 0xD0000000, 0xC3000000, 0xB1000000, 0xA2000015, 0x95000000, 0x8B000000, 0x85000000, 0x83000000, 0x83000000, 0x85000000, 0x8B000000, 0x94001515, 0x9C000000, 0xAB000000, 
        0xB7000000, 0xC6000000, 0xD3000000, 0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF4000000, 0xEE000000, 0xE8000000, 0xE3000000, 0xDF000000, 0xDE000000, 
        0xDF000000, 0xE3000000, 0xE9000000, 0xEE000000, 0xF3000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF6000000, 0xF3000000, 0xEF000000, 0xEB000000, 0xE8000000, 0xE7000000, 0xE8000000, 0xEB000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE5000000, 0xDC000000, 0xD3000000, 0xCB000000, 0xC6000000, 0xC8000000, 0xCC000000, 0xD3000000, 0xDE000000, 
        0xE7000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFE000000, 0xFD000000, 0xFA000000, 0xF6000000, 0xEF000000, 0xE6000000, 0xDA000000, 0xCD000000, 0xC0000000, 0xB1000000, 0xA4000000, 0x9C000000, 0x95000000, 0x94001515, 0x94001515, 0x98000000, 0x9C000000, 0xA4000000, 0xAE000000, 0xB7000000, 
        0xC3000000, 0xCE000000, 0xDB000000, 0xE6000000, 0xEF000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF2000000, 0xEE000000, 0xEA000000, 0xE7000000, 0xE6000000, 
        0xE8000000, 0xEB000000, 0xEF000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF2000000, 0xF0000000, 0xEF000000, 0xEF000000, 0xF1000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFC000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF2000000, 0xEB000000, 0xE3000000, 0xDB000000, 0xD5000000, 0xD3000000, 0xD3000000, 0xD6000000, 0xDD000000, 0xE4000000, 
        0xEC000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF4000000, 0xEC000000, 0xE3000000, 0xD8000000, 0xCB000000, 0xC0000000, 0xB5000000, 0xAB000000, 0xA7000000, 0xA4000000, 0xA7000000, 0xAB000000, 0xAF000015, 0xB6000000, 0xBD000000, 0xC6000000, 
        0xD0000000, 0xDA000000, 0xE3000000, 0xEB000000, 0xF2000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF3000000, 0xF0000000, 0xEE000000, 0xEE000000, 
        0xEF000000, 0xF1000000, 0xF4000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF5000000, 0xF0000000, 0xEA000000, 0xE4000000, 0xDF000000, 0xDD000000, 0xDD000000, 0xE0000000, 0xE5000000, 0xEB000000, 
        0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF2000000, 0xEA000000, 0xE2000000, 0xD8000000, 0xCE000000, 0xC4000000, 0xBD000000, 0xBB000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC8000000, 0xCE000000, 0xD5000000, 
        0xDC000000, 0xE4000000, 0xEB000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF4000000, 0xF4000000, 
        0xF5000000, 0xF6000000, 0xF8000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF0000000, 0xEC000000, 0xE9000000, 0xE7000000, 0xE7000000, 0xE9000000, 0xED000000, 0xF1000000, 
        0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF1000000, 0xEA000000, 0xE3000000, 0xDB000000, 0xD3000000, 0xCE000000, 0xCC000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDD000000, 0xE2000000, 
        0xE7000000, 0xED000000, 0xF1000000, 0xF6000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF8000000, 0xF8000000, 
        0xF9000000, 0xFA000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xF0000000, 0xEF000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF6000000, 
        0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF1000000, 0xEC000000, 0xE7000000, 0xE2000000, 0xDE000000, 0xDC000000, 0xDB000000, 0xDD000000, 0xDF000000, 0xE2000000, 0xE6000000, 0xE9000000, 0xED000000, 
        0xF0000000, 0xF3000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFB000000, 0xFB000000, 
        0xFC000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF6000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF8000000, 0xFA000000, 
        0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF7000000, 0xF3000000, 0xF0000000, 0xEC000000, 0xEA000000, 0xE9000000, 0xE8000000, 0xE9000000, 0xEB000000, 0xED000000, 0xF0000000, 0xF2000000, 0xF4000000, 
        0xF7000000, 0xF9000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF4000000, 0xF3000000, 0xF2000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF5000000, 0xF7000000, 0xF8000000, 0xFA000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000
};

static GUI_CONST_STORAGE GUI_BITMAP _bmToucan = {
  158, // XSize
  150, // YSize
  632, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acToucan,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

static GUI_COLOR _aColor[] = {
  GUI_RED, 
  GUI_GREEN, 
  GUI_BLUE, 
  0x4080c0, 
  GUI_WHITE, 
  GUI_BLACK, 
  GUI_YELLOW, 
  GUI_MAGENTA, 
  GUI_CYAN, 
  0xc04080
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _FillLayer
*/
static void _FillLayer(int LayerIndex) {
  WM_HWIN hWin;
  int     xSize;
  int     ySize;

  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_SetBkColor(0x000000);
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  GUI_DrawRect(0, 0, xSize - 1, ySize - 1);
  GUI_DrawLine(0, 0, xSize - 1, ySize - 1);
  GUI_DrawLine(0, ySize - 1, xSize - 1, 0);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_DispStringHCenterAt("Layer ", xSize / 2, 5);
  GUI_DispDecMin(LayerIndex);
  hWin = BUTTON_CreateEx(xSize / 2 - 20, ySize - 30, 40, 20, WM_HBKWIN, WM_CF_SHOW, 0, 0);
  BUTTON_SetText(hWin, "Button");
}

/*********************************************************************
*
*       _DrawStripes
*/
static void _DrawStripes(int LayerIndex) {
  int xSize;
  int ySize;
  int x;
  int Cnt;

  Cnt = 0;
  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  for (x = 0; x < xSize; x += 8) {
    GUI_SetColor(_aColor[Cnt]);
    GUI_FillRect(x, 0, x + 7, ySize - 1);
    if (++Cnt == GUI_COUNTOF(_aColor)) {
      Cnt = 0;
    }
  }
  GUI_SetColor(GUI_WHITE);
  GUI_DrawRect(0, 0, xSize - 1, ySize - 1);
}

/*********************************************************************
*
*       _DrawToucan
*/
static void _DrawToucan(int LayerIndex) {
  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  GUI_SetBkColor(0xff000000);
  GUI_Clear();
  GUI_DrawBitmap(&_bmToucan, 0, 0);
}

/*********************************************************************
*
*       _DoAnimation
*/
static void _DoAnimation(ANIMATION_CONTEXT * pContext) {
  pContext->xPos += pContext->xAdd;
  pContext->yPos += pContext->yAdd;
  GUI_SetLayerPosEx(pContext->LayerIndex, pContext->xPos, pContext->yPos);
  pContext->Alpha += pContext->AlphaAdd;
  GUI_SetLayerAlphaEx(pContext->LayerIndex, pContext->Alpha);
  if ((pContext->xPos == pContext->xMax) || (pContext->xPos == pContext->xMin)) {
    pContext->xAdd *= -1;
  }
  if ((pContext->yPos == pContext->yMax) || (pContext->yPos == pContext->yMin)) {
    pContext->yAdd *= -1;
  }
  if ((pContext->Alpha == 255) || (pContext->Alpha == 0)) {
    pContext->AlphaAdd *= -1;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  ANIMATION_CONTEXT aContext[2] = {{0}};
  int               TimeNextChroma;
  int               IndexChroma;

  IndexChroma = 0;

  #ifdef WIN32
    SIM_GUI_SetTransMode(1, GUI_TRANSMODE_CHROMA);
  #endif

  GUI_Init();
  _FillLayer(0);
  _DrawStripes(1);
  _DrawToucan(2);
  aContext[0].LayerIndex = 1;
  aContext[0].xMax = 220;
  aContext[0].xAdd = 1;
  aContext[0].AlphaAdd = 5;
  aContext[0].yPos = 50;

  aContext[1].LayerIndex = 2;
  aContext[1].yMax = 100;
  aContext[1].yAdd = 2;

  TimeNextChroma = GUI_GetTime() + 1000;
  while (1) {
    _DoAnimation(&aContext[0]);
    _DoAnimation(&aContext[1]);
    if (GUI_GetTime() > TimeNextChroma) {
      TimeNextChroma += 1000;
      IndexChroma++;
      if (IndexChroma == GUI_COUNTOF(_aColor)) {
        IndexChroma = 0;
      }
      SIM_GUI_SetChroma(1, _aColor[IndexChroma], _aColor[IndexChroma]);
    }
    GUI_Delay(20);
  }
}

/*************************** End of file ****************************/
