/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2014  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.24 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software has been licensed to  ARM LIMITED whose registered office
is situated at  110 Fulbourn Road,  Cambridge CB1 9NJ,  England solely
for  the  purposes  of  creating  libraries  for  ARM7, ARM9, Cortex-M
series,  and   Cortex-R4   processor-based  devices,  sublicensed  and
distributed as part of the  MDK-ARM  Professional  under the terms and
conditions  of  the   End  User  License  supplied  with  the  MDK-ARM
Professional. 
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : 2DGL_DrawPNG.c
Purpose     : Example for drawing PNG images
Requirements: WindowManager - ( )
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - (x)
              TrueTypeFonts - ( )

              Can be used in a MS Windows environment only!
----------------------------------------------------------------------
*/

#ifndef SKIP_TEST

#include <windows.h>
#include "GUI.h"

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
static unsigned char _acPNG[] = {
  0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A,
  0x1A, 0x0A,
  0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x96, 0x08, 0x03, 0x00, 0x00, 0x01, 0x1D, 0xC0, 0x93, 0x04, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x01, 0x86, 0xA0, 0x31, 0xE8, 0x96,
  0x5F, 0x00, 0x00, 0x03, 0x00, 0x50, 0x4C, 0x54, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x02, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x51, 0x77, 0x0F, 0xCB, 0x3C, 0x02, 0x2E, 0x2E, 0x03, 0x3F, 0x53, 0x12, 0xFE, 0xD1, 0x03, 0x1B, 0x23, 0x06, 0x20, 0x15, 0x10, 0x12, 0x0B,
  0x03, 0x6B, 0x8E, 0x06, 0x0F, 0x02, 0x03, 0x12, 0x09, 0x03, 0xF0, 0x8A, 0x02, 0x18, 0x0C, 0x04, 0xFE, 0xD5, 0x07, 0xA9, 0xDA, 0x27, 0x7A, 0xC8, 0x1D, 0x45, 0x02, 0x03, 0x6C, 0x3F, 0x03, 0x3D, 0x61, 0x05, 0x24, 0x3E, 0x05, 0x19, 0x16, 0x03,
  0x51, 0x8E, 0x08, 0x45, 0x06, 0x03, 0x21, 0x17, 0x03, 0xF5, 0x9C, 0x02, 0xEA, 0xE0, 0x32, 0x3B, 0x2B, 0x31, 0x3A, 0x4E, 0x0E, 0x01, 0x00, 0x00, 0xE0, 0x91, 0x05, 0x85, 0x92, 0x31, 0x1F, 0x0C, 0x11, 0x32, 0x09, 0x05, 0xB1, 0x86, 0x0F, 0x00,
  0x00, 0x00, 0x1D, 0x0A,
  0x09, 0xF8, 0xDA, 0x0C, 0x1F, 0x35, 0x04, 0x80, 0xC7, 0x06, 0x48, 0x3C, 0x4D, 0x2A, 0x19, 0x18, 0x41, 0x60, 0x03, 0x14, 0x07, 0x04, 0x41, 0x27, 0x03, 0x00, 0x00, 0x00, 0x7E, 0x8E, 0x06, 0x2D, 0x60, 0x03, 0x31, 0x2B, 0x0E, 0x01, 0x00, 0x00,
  0x38, 0x72, 0x03, 0x35, 0x2E, 0x03, 0x00, 0x00, 0x00, 0x52, 0x77, 0x04, 0x0E, 0x0D, 0x03, 0x00, 0x00, 0x00, 0x2B, 0x36, 0x0A,
  0x75, 0xC8, 0x0D, 0x96, 0xC8, 0x06, 0xF5, 0xCB, 0x07, 0x08, 0x01, 0x00, 0x5F, 0x72, 0x06, 0x1E, 0x23, 0x03, 0x12, 0x01, 0x04, 0x17, 0x07, 0x06, 0x36, 0x54, 0x03, 0x6D, 0xC2, 0x06, 0x29, 0x1A, 0x03, 0x95, 0x36, 0x02, 0x29, 0x31, 0x03, 0x66,
  0x8E, 0x0F, 0x5F, 0x2F, 0x03, 0x1C, 0x16, 0x05, 0xE9, 0x6D, 0x02, 0x3C, 0x57, 0x12, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x1A, 0x0B, 0x03, 0xF6, 0xC0, 0x02, 0x10, 0x03, 0x03, 0x0C, 0x0C, 0x03, 0x17, 0x0F, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x22, 0x00, 0x02, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x02, 0x10, 0x00, 0x05, 0x0F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x03, 0x00, 0x00, 0x00, 0x09, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x0C, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x05, 0x02, 0x01, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x06, 0x04, 0x01, 0x00, 0x00, 0xF9, 0xBF, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x26, 0x04, 0x6B, 0x65, 0x79, 0x37, 0x33, 0x0D, 0x3B, 0x82, 0x03, 0x01, 0x02, 0x00, 0x35, 0x70, 0x05, 0x47, 0x60, 0x08, 0xAA, 0xCB, 0x06, 0x1E, 0x0C, 0x03,
  0x51, 0xA6, 0x04, 0xF7, 0x9A, 0x02, 0x36, 0x99, 0x04, 0x97, 0xD4, 0x12, 0x3B, 0x18, 0x0B, 0xFC, 0xC1, 0x03, 0x11, 0x09, 0x03, 0x01, 0x00, 0x00, 0x0B, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x14, 0x03, 0x03, 0x02, 0x00, 0x00, 0x17, 0x0A,
  0x05, 0xFC, 0xCC, 0x03, 0x35, 0x1F, 0x27, 0xB5, 0xD6, 0x0D, 0x44, 0x97, 0x05, 0xF9, 0xA6, 0x02, 0x54, 0xAE, 0x0F, 0x22, 0x0B, 0x03, 0xB8, 0xD4, 0x07, 0x41, 0x63, 0x14, 0x3C, 0x6E, 0x12, 0x01, 0x02, 0x00, 0x3F, 0x80, 0x0A,
  0x46, 0x39, 0x0C, 0x8C, 0x85, 0x92, 0x1F, 0x23, 0x08, 0x11, 0x0A,
  0x02, 0x00, 0x00, 0x00, 0x53, 0x05, 0x03, 0x01, 0x00, 0x00, 0xF9, 0xC8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x00, 0x00, 0x00, 0x09, 0x00, 0x01, 0x08,
  0x00, 0x03, 0x0A,
  0x01, 0x02, 0xDD, 0x3B, 0xFD, 0x78, 0x00, 0x00, 0x01, 0x00, 0x74, 0x52, 0x4E, 0x53, 0x00, 0x01, 0xA7, 0x02, 0x03, 0xA8, 0x04, 0xFF, 0xFF, 0x05, 0x06, 0x07, 0x08, 0xFF, 0x0A,
  0xA6, 0x09, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0xFF, 0xFE, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8B, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0x44, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xA5, 0xFF, 0xFF, 0xD2, 0x61, 0xFF, 0xFF, 0x3C, 0xFF, 0xA6, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0xC8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xF1, 0x58, 0x97,
  0xFF, 0xFF, 0xFF, 0x74, 0xFB, 0x4E, 0xA0, 0x6F, 0x3B, 0x34, 0x2C, 0x1D, 0x85, 0x80, 0x8F, 0xFF, 0x77, 0xFF, 0x9D, 0x0D, 0x93, 0xFF, 0x25, 0xFF, 0xFF, 0xFF, 0x2A, 0x27, 0x11, 0x6A, 0x82, 0x3F, 0x86, 0x31, 0xFF, 0x10, 0x71, 0xFF, 0x5B, 0x0E,
  0x16, 0x2F, 0xFE, 0x0F, 0xFF, 0x8A, 0xA4, 0x12, 0x15, 0x63, 0x54, 0xFF, 0xFF, 0x13, 0x7C, 0x9A, 0x1B, 0x44, 0x14, 0xFF, 0x19, 0xA3, 0x21, 0x46, 0x22, 0x18, 0x1A, 0x96, 0x48, 0xFF, 0x37, 0x1C, 0xA2, 0x8C, 0xFE, 0x74, 0x6B, 0x58, 0x6A, 0x26,
  0xFF, 0x65, 0xFF, 0x5D, 0x4A, 0x49, 0x54, 0x7E, 0x32, 0x5E, 0x67, 0xFF, 0xFF, 0xFF, 0xFF, 0x6B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCB, 0x8F, 0xEA, 0x74, 0x39, 0x77, 0x5B, 0x50, 0xE6, 0x9D, 0xE4, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x51, 0xFF, 0x4C, 0xFF, 0x6E, 0x17, 0x42, 0x29, 0x99, 0x98, 0x9F, 0x24, 0x7F, 0x1F, 0x20, 0x23, 0x3E, 0x9C, 0x7A, 0xFF, 0x36, 0x33, 0x95, 0xFF, 0x91, 0xFF, 0xFF,
  0xFF, 0x3B, 0x5C, 0xEC, 0x3A, 0x00, 0x00, 0x20, 0x00, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xEC, 0x7B, 0x0B, 0x38, 0xD4, 0xF9, 0xFE, 0x3F, 0x06, 0x33, 0x2E, 0x23, 0xE3, 0x92, 0xCB, 0xC4, 0xB8, 0xAC, 0x31, 0x8D, 0x5B, 0x91, 0x19, 0xC3, 0x8A,
  0xA1, 0x31, 0x07, 0x13, 0xE6, 0x4A, 0x33, 0x6B, 0x5D, 0x92, 0x6B, 0x86, 0x10, 0x4F, 0xEE, 0xC3, 0x86, 0xC7, 0x23, 0x65, 0xC7, 0xE5, 0x49, 0x51, 0x8A, 0x0A,
  0x25, 0x54, 0x8A, 0xB4, 0x06, 0x25, 0xD2, 0x45, 0x07, 0x35, 0x54, 0x9B, 0x6C, 0x28, 0xDD, 0x74, 0xB3, 0xD5, 0xD3, 0xD9, 0xF3, 0xFF, 0x7C, 0x47, 0xB5, 0xDA, 0xEC, 0xE6, 0xEC, 0xE9, 0x9C, 0xF3, 0xFB, 0x3F, 0xCF, 0xBE, 0xD3, 0x18, 0x5F, 0x5F,
  0xEF, 0x79, 0x7D, 0xDE, 0xB7, 0xCF, 0xFB, 0xFD, 0xFE, 0xBC, 0xBF, 0x52, 0x52, 0x7F, 0x82, 0x82, 0xAC, 0x4F, 0xDB, 0xD3, 0x63, 0x8F, 0x4A, 0xCF, 0xBF, 0x86, 0x1A, 0x36, 0xA7, 0x1F, 0x8B, 0x39, 0x14, 0x3D, 0x73, 0x4C, 0x71, 0xDE, 0xD5, 0x04,
  0x03, 0x73, 0x38, 0x1C, 0x15, 0x44, 0xB8, 0x9A, 0xA7, 0xF2, 0xFE, 0x52, 0xB0, 0x94, 0x94, 0x41, 0xE0, 0x84, 0xDC, 0xB6, 0xA8, 0x96, 0xBA, 0x2B, 0x79, 0xB2, 0xEF, 0xAF, 0x6A, 0xC3, 0x60, 0x43, 0x5A, 0xBC, 0x65, 0x51, 0x87, 0xC3, 0x9E, 0x94,
  0x6D, 0x97, 0x9F, 0xBB, 0x46, 0xF2, 0x0E, 0x46, 0xC7, 0xF6, 0x36, 0x89, 0x85, 0x3B, 0x94, 0xE7, 0xB1, 0xF4, 0x43, 0x8F, 0xE0, 0x1C, 0x87, 0x88, 0x13, 0xC6, 0xA8, 0x22, 0xD8, 0xAF, 0x57, 0x59, 0x1E, 0xBA, 0x58, 0x12, 0xD7, 0xF8, 0x68, 0x02,
  0x9B, 0x42, 0xA1, 0x8C, 0xB1, 0x61, 0x73, 0x8C, 0x47, 0x7C, 0x98, 0x68, 0x5D, 0x6B, 0x47, 0x3C, 0x9E, 0xBE, 0xAD, 0x8E, 0xE1, 0xEA, 0xB6, 0xE3, 0x8A, 0x84, 0x73, 0x9B, 0x29, 0xCB, 0x87, 0x39, 0xCE, 0xD5, 0x83, 0xD3, 0x65, 0xF6, 0xB5, 0xCE,
  0xC6, 0xEF, 0x48, 0x96, 0xDC, 0x8C, 0x35, 0x6D, 0x63, 0xE2, 0xBC, 0x70, 0x72, 0x74, 0xF8, 0x92, 0x4A, 0x98, 0x6A, 0xF8, 0x9E, 0x39, 0xBE, 0xCE, 0x37, 0xE5, 0x64, 0xC6, 0x97, 0x5C, 0x68, 0x5B, 0xC6, 0xBF, 0xBA, 0x55, 0x5A, 0x4A, 0xFA, 0x1D,
  0x32, 0x93, 0xAD, 0x4E, 0x56, 0xD3, 0x33, 0x3F, 0xBC, 0x3A, 0x01, 0xA7, 0x67, 0xA8, 0xFC, 0x0A,
  0x22, 0xEF, 0xF0, 0x09, 0xD5, 0xE2, 0x50, 0xD5, 0x38, 0xF7, 0x8B, 0x9B, 0x2A, 0x7E, 0xBD, 0xAA, 0xAA, 0xA4, 0x0C, 0x93, 0xDE, 0x03, 0xB0, 0x46, 0x4E, 0xE7, 0x48, 0xFD, 0x37, 0x28, 0xD4, 0x61, 0xF8, 0xCE, 0xB0, 0x20, 0x56, 0x76, 0xFE, 0x35,
  0x4E, 0x82, 0x8E, 0x57, 0x63, 0x54, 0xB4, 0x55, 0xFD, 0x3C, 0x60, 0x02, 0xFD, 0x40, 0x0E, 0x02, 0x2E, 0x60, 0x38, 0x9E, 0x7C, 0x36, 0x5F, 0x63, 0x3C, 0x19, 0x99, 0x7D, 0x33, 0x25, 0x47, 0xF6, 0xEF, 0x9C, 0x13, 0x80, 0x14, 0x49, 0x4A, 0x5E,
  0x9F, 0xD8, 0x24, 0xDC, 0x94, 0x7A, 0x3C, 0xE2, 0x59, 0xEE, 0xBB, 0x15, 0x88, 0x3A, 0xA9, 0x22, 0x5E, 0x6F, 0xD3, 0x84, 0x20, 0xF9, 0xD7, 0xBF, 0xEC, 0x46, 0x8B, 0xD0, 0x6B, 0x6C, 0xCC, 0x88, 0x13, 0xF0, 0x43, 0xD8, 0x5F, 0xF5, 0xE2, 0x87,
  0xEF, 0x60, 0x9B, 0xAF, 0x9E, 0x30, 0x66, 0xB3, 0xD9, 0x01, 0xED, 0x5F, 0x11, 0x24, 0x02, 0xAC, 0x35, 0xB9, 0xA5, 0x2B, 0x5A, 0xEF, 0xB1, 0x8C, 0xDB, 0xB5, 0xFE, 0xED, 0x8F, 0xE7, 0xF7, 0xDB, 0xD6, 0x3D, 0x07, 0x17, 0x0D, 0x47, 0x6E, 0x77,
  0x18, 0x19, 0x61, 0x30, 0xCC, 0xEF, 0xE5, 0xB6, 0x95, 0x34, 0x6A, 0x6F, 0x7C, 0x51, 0x0C, 0x2E, 0xDA, 0x61, 0xCF, 0xF9, 0xD9, 0xC9, 0x91, 0xE5, 0x90, 0x89, 0x88, 0x43, 0xF9, 0xB0, 0x32, 0xB7, 0x39, 0xDB, 0x6A, 0x23, 0xC9, 0x38, 0x79, 0xBF,
  0x7C, 0xF3, 0x2D, 0x42, 0xF8, 0x28, 0x57, 0x4A, 0x4A, 0x7E, 0xCE, 0x0E, 0x77, 0x3E, 0x3A, 0x58, 0x64, 0x19, 0xFD, 0xAA, 0x28, 0x9C, 0xBE, 0xED, 0xC5, 0x87, 0x8F, 0x57, 0xDC, 0x61, 0xFB, 0x1A, 0x76, 0x3C, 0x4C, 0x36, 0x2B, 0x6F, 0x53, 0xFD,
  0x07, 0x6B, 0x91, 0x4E, 0x81, 0xA9, 0x4A, 0xE5, 0x83, 0xE5, 0xC9, 0x4F, 0x6F, 0x91, 0x96, 0xFA, 0x6F, 0x92, 0xC3, 0xF0, 0xE9, 0xD3, 0xC3, 0xD6, 0x8C, 0xA4, 0xD8, 0xE0, 0x3F, 0xB8, 0x09, 0x09, 0x67, 0xAC, 0x72, 0x70, 0xB0, 0xB7, 0x1F, 0xEE,
  0xBF, 0x64, 0xBB, 0x7F, 0xBF, 0xED, 0xAB, 0xCD, 0xC5, 0x0A,
  0x0B, 0xDF, 0x18, 0xAB, 0xA1, 0x71, 0x94, 0x38, 0xCA, 0xB1, 0xD1, 0xB1, 0x66, 0x30, 0x92, 0xCE, 0xBB, 0x14, 0xCC, 0xC4, 0x34, 0x86, 0xE5, 0x2F, 0xB4, 0x20, 0x24, 0xCF, 0x60, 0x4A, 0x4C, 0xE7, 0xE1, 0x19, 0x4E, 0x6F, 0x4A, 0x1A, 0x4F, 0x54,
  0x86, 0xE5, 0x3D, 0xDF, 0x9B, 0xAF, 0x04, 0xFB, 0xCD, 0x4D, 0x7E, 0xD0, 0xCB, 0x59, 0x2D, 0xE2, 0x94, 0x3E, 0x67, 0x99, 0x8C, 0xCC, 0xC1, 0xD2, 0xF8, 0x82, 0xB4, 0xCB, 0xF7, 0x1A, 0xAF, 0x84, 0xB8, 0xED, 0x99, 0xE7, 0x7D, 0xAC, 0x4E, 0x29,
  0x6D, 0x9A, 0x94, 0x6C, 0xCA, 0x01, 0x94, 0x78, 0xC8, 0x40, 0xAB, 0x49, 0xCC, 0x17, 0x30, 0x8A, 0x92, 0xB7, 0xC7, 0x29, 0x2B, 0xC8, 0xC2, 0xA4, 0x01, 0xCD, 0xE7, 0x67, 0x29, 0xB2, 0xBC, 0x40, 0x74, 0xB6, 0xAC, 0x15, 0xF4, 0x8A, 0xC5, 0xE2,
  0xC0, 0xA1, 0x09, 0xBA, 0x80, 0xD1, 0xFC, 0x44, 0x71, 0x01, 0x74, 0x54, 0x34, 0x49, 0x6F, 0xEC, 0x0C, 0x8D, 0xCD, 0x5D, 0x5F, 0x6E, 0x3C, 0x61, 0x33, 0x31, 0x31, 0x61, 0xCC, 0x47, 0x99, 0xAA, 0xDF, 0x52, 0x77, 0x01, 0xFC, 0x44, 0x22, 0xEF,
  0x79, 0x77, 0x92, 0x6F, 0xB7, 0xB1, 0xFC, 0x44, 0x64, 0x43, 0xE6, 0xB5, 0x5A, 0xAE, 0x6E, 0x82, 0xA3, 0xA3, 0xBD, 0x0F, 0x5E, 0x33, 0x68, 0xF4, 0xFB, 0x20, 0x3A, 0x97, 0x10, 0x30, 0xAA, 0x1C, 0x17, 0x19, 0x51, 0xF1, 0xDE, 0x19, 0xBB, 0xB1,
  0x28, 0x93, 0x9E, 0xEE, 0x73, 0x6B, 0x8C, 0x6E, 0x75, 0x30, 0xB1, 0x26, 0x23, 0x1E, 0x89, 0xE5, 0xD5, 0xD5, 0x72, 0x32, 0xDB, 0x36, 0xBD, 0x2C, 0xFD, 0x16, 0x7F, 0x28, 0x23, 0xC3, 0xAA, 0xC5, 0x35, 0x42, 0x69, 0xEE, 0xCE, 0x11, 0x32, 0x76,
  0x04, 0x43, 0x3D, 0x63, 0x8A, 0xBD, 0x85, 0x25, 0xE3, 0x04, 0x02, 0xDD, 0xC4, 0x84, 0x04, 0xFA, 0x55, 0x99, 0x87, 0xA9, 0xAF, 0x22, 0x0F, 0xBC, 0xF6, 0xFF, 0xE1, 0xC4, 0x96, 0x38, 0xF9, 0xF7, 0x82, 0x62, 0xD2, 0x6A, 0xCF, 0x19, 0xCA, 0xC9,
  0xD5, 0x76, 0x63, 0x8D, 0x64, 0x9C, 0x7C, 0x70, 0x32, 0x4E, 0xE5, 0xBF, 0xA0, 0x04, 0x4B, 0xA2, 0xF7, 0xC7, 0x81, 0xDF, 0xC9, 0xC6, 0x1D, 0xB8, 0x3F, 0x6F, 0x6D, 0xD4, 0xCB, 0xA7, 0x98, 0x32, 0x32, 0x8F, 0x0F, 0x15, 0x8C, 0x6D, 0x88, 0x0F,
  0x75, 0x9D, 0xFD, 0xD1, 0x1F, 0x15, 0xCB, 0x47, 0x6E, 0xC8, 0x4E, 0x96, 0xFF, 0x74, 0xF5, 0x39, 0xC7, 0x0B, 0xA2, 0xA3, 0xEA, 0x6A, 0x52, 0xB4, 0x5F, 0x64, 0xD7, 0xBD, 0xCE, 0x3F, 0x10, 0x1E, 0xC1, 0x3F, 0x1C, 0xEF, 0xB4, 0xCF, 0x7F, 0xFB,
  0xA7, 0x7A, 0x84, 0x55, 0xBD, 0x7A, 0x56, 0xD8, 0x50, 0xA1, 0x24, 0xA5, 0x90, 0x3C, 0x90, 0xA7, 0x24, 0x05, 0xC4, 0x5D, 0x78, 0x3C, 0x2D, 0xC3, 0x75, 0x8F, 0xEC, 0xA7, 0x4C, 0xA5, 0xDF, 0x63, 0x86, 0x29, 0xBC, 0xFB, 0xAD, 0x82, 0xBB, 0x9A,
  0xC2, 0x7F, 0xD7, 0xD6, 0xFF, 0xF7, 0xD4, 0x37, 0x3C, 0x7C, 0xDA, 0xC2, 0xC1, 0x9A, 0x2E, 0x48, 0xFA, 0xC3, 0xDB, 0xEC, 0x09, 0x0C, 0x07, 0xFB, 0x3B, 0x77, 0x2C, 0xC0, 0x8D, 0x08, 0x84, 0x02, 0xEC, 0xF7, 0x82, 0x2A, 0x0A,
  0x15, 0xE8, 0xA0, 0x33, 0x6C, 0x7F, 0x3A, 0xE8, 0x64, 0x7A, 0xE5, 0xF1, 0x4A, 0xB7, 0xBC, 0x32, 0xB5, 0x85, 0x6F, 0xAD, 0x4E, 0xE0, 0xAC, 0x58, 0x45, 0xA7, 0x87, 0xF9, 0x87, 0xCE, 0x14, 0x44, 0x47, 0x47, 0x67, 0x5C, 0x6E, 0x0E, 0xCF, 0x5A,
  0x48, 0xF2, 0xA8, 0x6A, 0x0D, 0x0D, 0xCE, 0xCA, 0x75, 0x13, 0x04, 0x80, 0x30, 0x29, 0xF1, 0xFC, 0xA1, 0xA8, 0x92, 0xD0, 0x13, 0x7B, 0x16, 0xF2, 0x74, 0xA1, 0x86, 0xC1, 0x5A, 0x6B, 0x1E, 0x12, 0x0E, 0x87, 0x23, 0x51, 0x02, 0x3A, 0x81, 0x21,
  0x0C, 0xCF, 0x7C, 0xB0, 0x73, 0x01, 0xA5, 0x4B, 0x2D, 0xEF, 0x35, 0x98, 0x5A, 0xB5, 0x6E, 0x15, 0xC1, 0xEB, 0x71, 0x46, 0x68, 0xF3, 0xE4, 0x74, 0xF8, 0x83, 0xC8, 0x62, 0x35, 0xF9, 0x85, 0x20, 0xEA, 0x13, 0x89, 0xFA, 0x1A, 0x5E, 0x32, 0x72,
  0x32, 0x9B, 0xAC, 0x36, 0xB6, 0xB4, 0x5C, 0x0E, 0xDD, 0x71, 0xD7, 0xAD, 0x42, 0xE5, 0x63, 0x8C, 0x54, 0xE8, 0xC5, 0x66, 0xCA, 0xC0, 0x40, 0xCC, 0x13, 0xC8, 0xC8, 0x38, 0x6D, 0x7A, 0x13, 0x1D, 0xD5, 0x92, 0x7D, 0xC4, 0xB5, 0xA8, 0x32, 0xB3,
  0xF8, 0xD7, 0x65, 0x33, 0xC1, 0x6E, 0xDE, 0x09, 0x8C, 0x5F, 0xDE, 0xCC, 0xC0, 0x80, 0x18, 0xA8, 0x7F, 0x5E, 0xB0, 0x2D, 0x3E, 0xC6, 0xF5, 0xEE, 0xF4, 0xEB, 0xE4, 0x3D, 0x91, 0x7B, 0x73, 0x8B, 0x55, 0x7F, 0xE5, 0x38, 0x42, 0x96, 0x22, 0xF5,
  0x48, 0x29, 0x57, 0xE5, 0x0E, 0x0D, 0x69, 0x0D, 0x35, 0x99, 0x69, 0xA0, 0xE8, 0x17, 0xC3, 0x0E, 0xA4, 0xA8, 0x28, 0xCA, 0xC3, 0x60, 0x1F, 0x47, 0x0D, 0x6F, 0xB4, 0xAA, 0xB7, 0xB2, 0xA5, 0xB7, 0xB7, 0x48, 0xDC, 0x3B, 0x34, 0x34, 0x25, 0xD6,
  0x2F, 0x2F, 0xA7, 0xDB, 0x2E, 0xB8, 0x56, 0x29, 0x52, 0xDB, 0xB5, 0x35, 0x37, 0xBC, 0xDB, 0xB8, 0x1C, 0xDE, 0x59, 0xF1, 0xD0, 0x94, 0x99, 0x71, 0x12, 0x7F, 0xF6, 0x45, 0xCA, 0x02, 0x72, 0x46, 0xA3, 0x45, 0x34, 0xDC, 0x35, 0x1C, 0x0E, 0x1B,
  0xBB, 0x56, 0x2C, 0x26, 0x6A, 0x4C, 0x4C, 0x24, 0x94, 0xBF, 0xBC, 0x78, 0x53, 0x7D, 0x81, 0x1B, 0x69, 0xEA, 0x9D, 0x82, 0x33, 0xEA, 0x01, 0x18, 0xDD, 0xC4, 0x09, 0x63, 0x10, 0x85, 0x8E, 0xDA, 0x7C, 0xD7, 0xBF, 0xD4, 0xDB, 0xF2, 0x1B, 0x17,
  0xC0, 0xD4, 0x5B, 0x34, 0xEF, 0x46, 0x9C, 0xA1, 0x26, 0xD7, 0xF2, 0x4C, 0x27, 0x86, 0x64, 0xBE, 0xB2, 0x7D, 0xC2, 0xC6, 0xD8, 0xD8, 0x22, 0x80, 0x4D, 0x61, 0x77, 0x81, 0xFF, 0x94, 0x31, 0x0A,
  0x9B, 0x70, 0x5E, 0xFE, 0x43, 0xC0, 0xC0, 0xB1, 0x71, 0x2C, 0x91, 0xA9, 0xC8, 0xD1, 0xF9, 0xE6, 0xB8, 0x0E, 0x9F, 0x8E, 0xA9, 0xB5, 0xC0, 0xB3, 0x57, 0x63, 0xF8, 0x8E, 0x28, 0x3C, 0x63, 0x94, 0x1E, 0xAC, 0xBA, 0x33, 0x79, 0xCB, 0xF6, 0x77,
  0x2B, 0x63, 0xE1, 0x4C, 0x2D, 0x3B, 0xEC, 0xC8, 0xD7, 0x49, 0xA6, 0xB5, 0x16, 0x18, 0x21, 0x63, 0x9C, 0xD0, 0x5E, 0x4B, 0x97, 0xD9, 0xB4, 0xB1, 0x2E, 0x6A, 0xB4, 0xEE, 0x44, 0xBA, 0x5B, 0x51, 0x68, 0x68, 0xFA, 0xBB, 0x6D, 0x97, 0x6A, 0x44,
  0xF6, 0xBC, 0x7E, 0xEE, 0x8C, 0xA7, 0x7A, 0x07, 0x99, 0xC9, 0xBC, 0x6D, 0x48, 0xE1, 0x7F, 0x57, 0x8D, 0x92, 0x59, 0xB2, 0xE1, 0x65, 0xE9, 0xC3, 0xD1, 0x75, 0x05, 0x51, 0x56, 0x19, 0x75, 0xFB, 0x77, 0xCE, 0x89, 0x00, 0x8B, 0x25, 0x5F, 0x37,
  0xE9, 0x61, 0xE9, 0xE9, 0x9A, 0xAC, 0xEC, 0xE2, 0x76, 0x71, 0xB9, 0x76, 0xC8, 0x04, 0x14, 0x08, 0x48, 0x05, 0xA1, 0x3B, 0xEE, 0x65, 0xBC, 0xB1, 0xAA, 0x1B, 0xC8, 0x8C, 0x7C, 0x17, 0x29, 0xF9, 0x58, 0xAA, 0x29, 0x8E, 0x3A, 0xC2, 0xBD, 0x3E,
  0x4E, 0x26, 0xAB, 0xF3, 0xF5, 0x50, 0x09, 0x09, 0x09, 0xB1, 0x72, 0xBB, 0xA3, 0x42, 0x1A, 0xAA, 0x36, 0x57, 0x36, 0xBA, 0xA6, 0xEF, 0x52, 0x92, 0x7D, 0x27, 0x53, 0x74, 0x6D, 0x5B, 0x87, 0xA7, 0x2F, 0x1A, 0x87, 0x35, 0x92, 0xC3, 0x92, 0x47,
  0xE4, 0xC0, 0x8E, 0xCC, 0x17, 0xC8, 0x3D, 0xBE, 0xB7, 0x59, 0x41, 0x5A, 0x3E, 0x25, 0xD9, 0xED, 0xF5, 0xAF, 0xA2, 0x67, 0xEA, 0xE9, 0x91, 0x3C, 0xE4, 0xE4, 0x98, 0xD7, 0x71, 0x32, 0x32, 0xDB, 0x3A, 0xFA, 0x96, 0xD4, 0x02, 0xB3, 0xE5, 0x6F,
  0xC8, 0x7E, 0x0E, 0xD6, 0x2A, 0xAD, 0xB4, 0x3D, 0x32, 0xE7, 0xC3, 0x8D, 0x67, 0xEC, 0x7A, 0xA8, 0xDA, 0x72, 0x32, 0x4B, 0x9C, 0xB0, 0xD8, 0xDD, 0xF1, 0x17, 0x98, 0x9B, 0x0A,
  0x50, 0x08, 0x14, 0x7C, 0xF7, 0xCC, 0x6B, 0xC5, 0x8F, 0x02, 0x17, 0xE4, 0xC7, 0x6D, 0xE1, 0x69, 0x3D, 0x32, 0x4E, 0xFB, 0x32, 0x98, 0xDE, 0x8F, 0x37, 0xBA, 0xA6, 0x6E, 0x0C, 0xAD, 0x44, 0x0A,
  0xF8, 0x4B, 0xA2, 0x8F, 0xE5, 0x7F, 0xA2, 0x43, 0x85, 0xCC, 0x99, 0xD5, 0x4E, 0xA5, 0xD9, 0xB6, 0x93, 0x37, 0x0F, 0x45, 0x4D, 0xE6, 0xD9, 0xFA, 0xDB, 0x02, 0x8F, 0xE9, 0x2F, 0x6D, 0x8C, 0xFC, 0xC4, 0x53, 0x65, 0x37, 0x87, 0xC6, 0x17, 0x6C,
  0xF4, 0x8F, 0x2C, 0x7C, 0x70, 0x78, 0xC6, 0x7F, 0x57, 0xCA, 0x83, 0xF0, 0x3D, 0x5E, 0xB3, 0x1B, 0x0E, 0x96, 0x64, 0x7E, 0xB2, 0x3F, 0x49, 0x6F, 0x0F, 0x69, 0xDC, 0x3F, 0x39, 0x59, 0x25, 0xAB, 0xB4, 0xA5, 0xB1, 0xB9, 0x4C, 0x56, 0x39, 0xC5,
  0xFD, 0xFE, 0x40, 0xF4, 0x41, 0x2B, 0x5B, 0xF7, 0x4F, 0x3E, 0x5B, 0x25, 0x22, 0x73, 0x67, 0xD9, 0x96, 0x62, 0x69, 0xA9, 0x94, 0xF4, 0xCA, 0x5C, 0x90, 0x2A, 0x4A, 0x2B, 0x3E, 0x48, 0xB5, 0x9A, 0x4D, 0x8F, 0xFB, 0xE4, 0x46, 0xD9, 0xFC, 0x1C,
  0x59, 0x79, 0x15, 0xE0, 0xE9, 0x0A,
  0x65, 0x4F, 0x55, 0x25, 0x9F, 0x11, 0x97, 0x59, 0x59, 0x53, 0xB6, 0x80, 0xEB, 0xC3, 0xDE, 0xC9, 0x4A, 0x5A, 0xFE, 0x5D, 0xEC, 0x86, 0xA9, 0xC6, 0x29, 0xCB, 0x4A, 0xFD, 0x45, 0xFF, 0x3B, 0x0A,
  0xB6, 0x66, 0x38, 0x38, 0x58, 0x03, 0x62, 0x04, 0x21, 0x09, 0x7D, 0xFF, 0x66, 0x9E, 0x6E, 0xE1, 0x60, 0x71, 0xFA, 0x8E, 0xFD, 0xF0, 0xB0, 0x3D, 0xD8, 0x7E, 0xEC, 0xED, 0x2D, 0x74, 0x18, 0x49, 0x82, 0xF2, 0x6A, 0xC4, 0xF9, 0x3F, 0xB5, 0x4F,
  0x7B, 0x25, 0x09, 0xCB, 0xBF, 0x22, 0xE8, 0x10, 0xAC, 0x1D, 0x2C, 0xEC, 0xED, 0x4F, 0x9F, 0x06, 0xEC, 0x86, 0xAD, 0x93, 0xCA, 0x91, 0x5E, 0x12, 0xEA, 0x2F, 0xCC, 0x51, 0x55, 0x94, 0xFD, 0x57, 0xF8, 0xFE, 0x80, 0xE2, 0x73, 0x38, 0xC6, 0x0E,
  0x5A, 0xE6, 0x77, 0xEE, 0xE8, 0x58, 0x83, 0x64, 0x94, 0x61, 0xE5, 0x56, 0x79, 0x77, 0xAB, 0x6B, 0xEB, 0xBD, 0x6C, 0x40, 0xA1, 0xF5, 0xAD, 0xA7, 0x8A, 0xF6, 0x87, 0x45, 0x44, 0x66, 0x29, 0xC1, 0x16, 0xCB, 0xB0, 0x3F, 0xB6, 0x9A, 0x33, 0x01,
  0x92, 0xD5, 0x55, 0xFA, 0x66, 0x1E, 0x8C, 0xFE, 0xF4, 0x01, 0xD7, 0xEC, 0xC1, 0xC1, 0xC1, 0xAB, 0x83, 0x0E, 0x9B, 0x00, 0xBD, 0x2C, 0x7D, 0xF4, 0xE6, 0xED, 0xA1, 0x8C, 0x96, 0x3A, 0xD7, 0xC9, 0x93, 0x65, 0x6A, 0x8B, 0x34, 0xF0, 0x50, 0x38,
  0x62, 0x1D, 0x4F, 0x6C, 0xA6, 0xCF, 0x4B, 0x24, 0x58, 0xD8, 0x0F, 0xFF, 0x0C, 0xB6, 0x47, 0x04, 0xFC, 0x97, 0x5F, 0x7E, 0x89, 0x8D, 0x45, 0xC4, 0x42, 0x84, 0xD4, 0xF9, 0xDB, 0xA9, 0xAD, 0x87, 0x8B, 0x42, 0x6C, 0x4F, 0x3E, 0xCD, 0x59, 0x64,
  0xE6, 0x53, 0x0E, 0xD7, 0xD0, 0xEF, 0x35, 0x20, 0x0E, 0x4D, 0xF1, 0x35, 0x56, 0xF0, 0xD8, 0x28, 0x04, 0x12, 0x29, 0xA0, 0x5B, 0x0F, 0x0E, 0xB6, 0x64, 0xB7, 0x36, 0xDF, 0xAD, 0x4C, 0xAF, 0xC9, 0x8C, 0x68, 0xA8, 0x38, 0xB0, 0xEB, 0x7E, 0x6E,
  0x71, 0xBE, 0xEA, 0x62, 0x53, 0x29, 0xA4, 0x46, 0x13, 0xD8, 0x19, 0x7B, 0x21, 0x94, 0xAB, 0xAF, 0xCA, 0x80, 0x0D, 0x17, 0xA4, 0xA0, 0xF1, 0x51, 0xB3, 0xD9, 0xF5, 0xAD, 0x8D, 0xAE, 0xCD, 0x57, 0xFC, 0x07, 0x8E, 0xD9, 0xBA, 0x85, 0x47, 0x3C,
  0xAF, 0x4A, 0x51, 0xF9, 0x0C, 0x43, 0xF4, 0x07, 0x29, 0x6A, 0x88, 0x0D, 0xB4, 0x88, 0x5A, 0x4D, 0x67, 0x79, 0x1A, 0xEB, 0x24, 0xFC, 0xC0, 0xDE, 0xBC, 0xA1, 0x74, 0x5F, 0x7C, 0x74, 0xF4, 0x21, 0xAB, 0x82, 0x8C, 0xB4, 0x96, 0x92, 0xCB, 0xA1,
  0x47, 0x5C, 0xFD, 0x27, 0xD3, 0x33, 0x9F, 0x66, 0x29, 0xFE, 0x81, 0x6A, 0x5C, 0x70, 0xB7, 0xE6, 0x02, 0x8B, 0x94, 0x94, 0x86, 0x59, 0xAF, 0x01, 0x44, 0x62, 0xB1, 0xBE, 0x86, 0x80, 0xEF, 0x28, 0xB3, 0x64, 0xDB, 0xE3, 0x47, 0x6F, 0x0B, 0xA2,
  0x5A, 0x62, 0xB2, 0x53, 0x5D, 0xAF, 0x14, 0x85, 0x1C, 0xB7, 0x9D, 0x7E, 0x71, 0x29, 0x3C, 0x33, 0x6F, 0xCB, 0x93, 0xB2, 0x05, 0x95, 0xCD, 0xA2, 0xB1, 0x24, 0x00, 0xD5, 0x6F, 0x40, 0x91, 0x4D, 0x49, 0x2D, 0x4E, 0x2D, 0xB4, 0xC9, 0xAC, 0xB7,
  0x77, 0xCA, 0x80, 0x68, 0x10, 0x18, 0xA8, 0xAF, 0xCF, 0x11, 0x96, 0x0B, 0xE9, 0x6F, 0xD2, 0x52, 0x8B, 0x6C, 0xC3, 0x4E, 0x46, 0x3C, 0x79, 0x5A, 0xB5, 0xBD, 0x30, 0x3F, 0xCE, 0x5D, 0x45, 0x55, 0x59, 0x49, 0x49, 0x51, 0x49, 0x51, 0x61, 0x41,
  0x8B, 0x5C, 0xCF, 0xC2, 0x91, 0xA4, 0x65, 0x45, 0xD4, 0x1B, 0x67, 0xA4, 0x61, 0x4A, 0x85, 0x7B, 0xF2, 0xF2, 0x9E, 0x23, 0x7B, 0xF5, 0xCF, 0x4E, 0x19, 0x4C, 0xF5, 0x8A, 0xA7, 0x9A, 0x02, 0xC5, 0x3C, 0x9B, 0x9F, 0x85, 0x49, 0x49, 0x17, 0x8B,
  0xC2, 0x23, 0xF3, 0xE7, 0xAA, 0x8E, 0xC5, 0xE8, 0x81, 0xD4, 0x8D, 0xDE, 0x09, 0x4A, 0x56, 0xAA, 0xB3, 0x33, 0xAD, 0x13, 0x22, 0xB8, 0x19, 0x4F, 0xBF, 0x09, 0xA2, 0xA9, 0x40, 0x40, 0xEB, 0x12, 0xCA, 0x93, 0xE8, 0xF4, 0xD9, 0xE6, 0xF4, 0xCD,
  0x85, 0x8B, 0xB4, 0xE7, 0x11, 0x9C, 0x3A, 0x96, 0x22, 0xD2, 0xC4, 0x76, 0x8A, 0x3C, 0xB1, 0x8E, 0x8E, 0x04, 0xC7, 0x20, 0x0C, 0x9D, 0xBF, 0x56, 0x5F, 0x5F, 0xFF, 0xAC, 0x99, 0xB8, 0x69, 0x2D, 0x71, 0x2D, 0xC8, 0x1E, 0x6C, 0x04, 0x42, 0x41,
  0x52, 0x74, 0xCC, 0xD6, 0xB0, 0x67, 0x39, 0xF2, 0x8B, 0xE1, 0x78, 0xE3, 0xDA, 0x0D, 0x40, 0x4C, 0x2A, 0x9B, 0xD4, 0xCD, 0x32, 0x27, 0xDE, 0x20, 0x12, 0x89, 0xD7, 0x9C, 0x83, 0x26, 0x34, 0xD6, 0x12, 0x57, 0x4D, 0x70, 0x26, 0x20, 0x32, 0x36,
  0x4E, 0x40, 0xA1, 0x04, 0xBB, 0x4B, 0x0B, 0xEA, 0x3D, 0x6E, 0x81, 0xDA, 0xE8, 0xC3, 0x1F, 0x8A, 0x68, 0xD4, 0x85, 0x8B, 0xC9, 0x76, 0x13, 0x1A, 0xA9, 0xE7, 0x9A, 0xB9, 0x39, 0x8D, 0xC2, 0x3C, 0x47, 0x32, 0x0F, 0xD0, 0x1B, 0xC7, 0xF8, 0xDE,
  0x54, 0x5F, 0x8A, 0x97, 0xB0, 0x9A, 0x63, 0x68, 0x6C, 0x43, 0x0F, 0x60, 0xB3, 0xF1, 0x9A, 0x14, 0x4D, 0x36, 0x45, 0xE4, 0x3B, 0x36, 0xE6, 0x6D, 0x69, 0x49, 0x05, 0xA9, 0x17, 0xA5, 0x7D, 0xF5, 0x79, 0xD1, 0x42, 0x1C, 0x59, 0xE8, 0x1E, 0x1C,
  0x26, 0xC8, 0x11, 0xDB, 0xFE, 0x35, 0x93, 0xDC, 0x41, 0x33, 0xC2, 0xE0, 0x70, 0xD7, 0x0C, 0x3D, 0x74, 0xB9, 0xF0, 0x44, 0x1B, 0x63, 0x1B, 0xE3, 0x09, 0xE3, 0x44, 0x7B, 0x7B, 0x2E, 0x9E, 0x8D, 0xF7, 0xA5, 0xB0, 0x1D, 0xD9, 0x7C, 0x7E, 0xC0,
  0x28, 0x3D, 0xA0, 0x8B, 0xA2, 0xD7, 0x06, 0xEA, 0xFE, 0xF3, 0xF4, 0x3E, 0x98, 0x2C, 0x41, 0x2D, 0xBF, 0x30, 0x05, 0xEC, 0x5E, 0x1F, 0xE9, 0x8B, 0xDA, 0x6E, 0xD2, 0x4D, 0xF2, 0xF4, 0x24, 0x91, 0x7A, 0x48, 0x20, 0x63, 0x21, 0x99, 0x60, 0x69,
  0x3D, 0x18, 0x53, 0x53, 0xEB, 0x61, 0x2E, 0x86, 0x1B, 0x80, 0x19, 0xC5, 0xE3, 0xAD, 0xAD, 0xDB, 0x7D, 0xD8, 0xA3, 0x94, 0x51, 0xC7, 0xDA, 0xBE, 0x7D, 0x69, 0xAD, 0x27, 0x06, 0xFC, 0x6B, 0x35, 0x35, 0xFB, 0xFA, 0xDA, 0x83, 0x37, 0x47, 0x96,
  0x1D, 0x78, 0x9E, 0xF7, 0xE2, 0xD8, 0xDD, 0x90, 0x17, 0x0F, 0xB6, 0x2B, 0xCF, 0xD7, 0x59, 0x47, 0x9B, 0x7A, 0x2D, 0x16, 0x6D, 0x44, 0xED, 0x20, 0x77, 0x74, 0x74, 0xE8, 0x32, 0xED, 0x9C, 0x4D, 0xC7, 0xD5, 0x8D, 0x8C, 0x8C, 0x3C, 0x3D, 0x3D,
  0x7B, 0xFC, 0xC6, 0x1D, 0x03, 0xCE, 0xB3, 0xF9, 0x5D, 0x6C, 0x01, 0x02, 0xF5, 0x1D, 0xC8, 0x3B, 0x76, 0x6F, 0x7A, 0x73, 0xE1, 0x42, 0xFC, 0xB7, 0x7F, 0xFF, 0xBB, 0x0E, 0xDB, 0x65, 0x36, 0xBB, 0x75, 0x47, 0x6B, 0xFD, 0xE5, 0x8D, 0x51, 0x51,
  0x25, 0x47, 0x26, 0x23, 0x8A, 0x15, 0xE7, 0xA1, 0x24, 0x51, 0xED, 0x70, 0x23, 0xA6, 0x6B, 0xC8, 0xDD, 0x9E, 0x46, 0x3F, 0x99, 0x92, 0xBB, 0xD1, 0xA6, 0xEA, 0xEA, 0xBA, 0xBA, 0x76, 0x4C, 0xF0, 0x01, 0xB7, 0x71, 0xB8, 0xDB, 0x6B, 0xFC, 0x74,
  0x41, 0xDC, 0x41, 0xA0, 0xF8, 0x74, 0xC8, 0x19, 0x97, 0xEC, 0xDE, 0x50, 0x1A, 0x0F, 0xEA, 0xCB, 0x8C, 0x82, 0x68, 0x8C, 0xCB, 0xA3, 0x37, 0xF1, 0x17, 0x0A,
  0x5A, 0xB2, 0x5D, 0x4F, 0x54, 0xBE, 0xDA, 0x93, 0x35, 0xDF, 0xC1, 0x0D, 0x05, 0x76, 0xD8, 0x33, 0x3D, 0x3F, 0x71, 0xAF, 0x53, 0x4D, 0xBA, 0x8D, 0x6E, 0x63, 0x82, 0x7C, 0x8D, 0x74, 0xB1, 0x64, 0x32, 0xCE, 0x68, 0x1C, 0x83, 0xE9, 0x0A,
  0x60, 0xD4, 0x0A,
  0x90, 0x48, 0x24, 0x1D, 0x54, 0xA1, 0x08, 0x39, 0x39, 0xE0, 0xDC, 0xF1, 0x69, 0xF7, 0x0E, 0x1F, 0x7F, 0x11, 0xE6, 0x56, 0x79, 0x38, 0x75, 0x36, 0x6A, 0xE3, 0xE5, 0x1F, 0xFC, 0xA7, 0xF3, 0x9E, 0x6E, 0xCF, 0x72, 0x57, 0x96, 0x9F, 0x2F, 0x48,
  0x2C, 0xFA, 0x5C, 0x1B, 0xF6, 0x6B, 0xAC, 0xCF, 0x19, 0x9F, 0x35, 0x38, 0x91, 0x89, 0xDF, 0x4F, 0xD8, 0xB6, 0x91, 0x3E, 0xB9, 0x36, 0x32, 0x99, 0x89, 0x03, 0x99, 0x1A, 0x28, 0x59, 0xF9, 0xA0, 0xAA, 0x4D, 0x48, 0x40, 0x09, 0x51, 0x72, 0x4B,
  0x36, 0xC4, 0xC7, 0x14, 0xBD, 0x3E, 0x90, 0xAF, 0xA2, 0xAC, 0x9A, 0xBF, 0x37, 0xB9, 0xA6, 0x72, 0x60, 0x00, 0xA0, 0x4B, 0xF9, 0xD4, 0xEC, 0xB1, 0xCE, 0x3D, 0x7A, 0xE3, 0x5C, 0xDF, 0x73, 0xA4, 0x9E, 0x9B, 0x72, 0x3F, 0xB5, 0x3B, 0x9B, 0xE0,
  0xB0, 0x76, 0xDD, 0xDA, 0x60, 0x85, 0x83, 0x26, 0x1D, 0x54, 0x32, 0xF8, 0xEE, 0x05, 0x47, 0xFC, 0x82, 0x44, 0xC2, 0x51, 0xD5, 0x57, 0x97, 0x3C, 0x3E, 0x54, 0x6F, 0x5B, 0x31, 0x57, 0x0C, 0xC1, 0x14, 0x54, 0x0A,
  0x23, 0x93, 0xF3, 0x22, 0x9E, 0x2D, 0xC0, 0xD1, 0xA7, 0x83, 0x66, 0xAA, 0x77, 0xAE, 0xA7, 0xA7, 0xC7, 0x09, 0x20, 0x02, 0x1C, 0x96, 0x61, 0x6F, 0x7B, 0x78, 0x7B, 0xC9, 0x38, 0x1D, 0x04, 0x1B, 0x00, 0x13, 0xE7, 0x04, 0xC2, 0x0E, 0xFC, 0x3B,
  0x04, 0xAA, 0x1C, 0xC5, 0x47, 0xCA, 0x1C, 0x8C, 0x8F, 0x09, 0xD9, 0x92, 0xF5, 0xDE, 0x6F, 0xA4, 0xE5, 0x95, 0xDD, 0x73, 0xDC, 0x95, 0x17, 0x08, 0x16, 0x58, 0xAA, 0x5D, 0xCF, 0xFA, 0x53, 0x6D, 0x22, 0x3F, 0x88, 0x1F, 0x60, 0xF4, 0x12, 0x6F,
  0x69, 0xA9, 0xEE, 0xB4, 0xE1, 0xDB, 0x82, 0x96, 0xD9, 0x96, 0x0C, 0x66, 0xBC, 0xD5, 0x6C, 0xE3, 0x3F, 0xCB, 0xE1, 0x42, 0x01, 0x5F, 0xC0, 0x77, 0x7A, 0x99, 0xD1, 0xF8, 0x22, 0x52, 0x65, 0x1E, 0xA8, 0xDF, 0x09, 0x1C, 0x38, 0xC5, 0xDC, 0xF0,
  0xE6, 0x34, 0x2F, 0x6F, 0xA0, 0xCB, 0x0D, 0xFB, 0xA2, 0x2E, 0xB6, 0xB6, 0xAE, 0xA7, 0x78, 0xEF, 0x7B, 0x18, 0xBF, 0xB1, 0xF5, 0x6E, 0xE5, 0xB1, 0xC3, 0x8D, 0x3F, 0xB4, 0xFA, 0x4F, 0xD7, 0x82, 0x34, 0x95, 0x2F, 0x40, 0xF5, 0xED, 0xDE, 0x57,
  0x72, 0x38, 0x73, 0xBB, 0xE2, 0x67, 0xE3, 0x8F, 0x97, 0x7C, 0x61, 0x44, 0xD1, 0x6C, 0xFC, 0xA6, 0xC7, 0x2F, 0x1F, 0xBD, 0xFD, 0xD1, 0x75, 0x7A, 0xCB, 0xF3, 0x07, 0x96, 0xDA, 0xAE, 0x17, 0xA3, 0xA2, 0xB2, 0x07, 0x32, 0x9F, 0x46, 0x26, 0x87,
  0x4F, 0x57, 0x4E, 0xBF, 0xEE, 0x17, 0x24, 0xD1, 0xD7, 0xEB, 0x79, 0x39, 0x6D, 0x88, 0xCE, 0x3E, 0xD6, 0x90, 0xFF, 0xF9, 0x78, 0x01, 0x53, 0x39, 0xE0, 0xE6, 0x3A, 0x3B, 0x13, 0x53, 0xDF, 0x7A, 0xA4, 0xF1, 0x44, 0x78, 0x95, 0x8A, 0xA2, 0x4A,
  0xF1, 0x93, 0xF4, 0x53, 0x75, 0x75, 0x5B, 0x6B, 0xAA, 0x54, 0x94, 0xD4, 0x76, 0x46, 0xEE, 0x89, 0xBC, 0x7F, 0xBF, 0xC1, 0xB6, 0x35, 0xEA, 0xE1, 0xEE, 0x6D, 0xA5, 0x51, 0x3B, 0xDC, 0xCA, 0x54, 0x3F, 0x1F, 0x24, 0xE5, 0xF3, 0x9F, 0xB8, 0x4D,
  0x1E, 0xAF, 0x79, 0x90, 0x9C, 0xE9, 0xE6, 0x16, 0xB1, 0x57, 0x15, 0x06, 0x3E, 0xA3, 0xAC, 0xA6, 0xC8, 0xF5, 0x44, 0x4D, 0x95, 0xB2, 0xB4, 0x14, 0x4C, 0x5E, 0x51, 0x51, 0x41, 0xC1, 0x3D, 0x32, 0xEC, 0xD4, 0x4C, 0xFC, 0xCB, 0x47, 0x05, 0xF5,
  0x95, 0x4F, 0xE2, 0x3E, 0xBF, 0x49, 0x4B, 0x2B, 0xA5, 0x1C, 0xA8, 0x38, 0x90, 0xA2, 0xAC, 0xE4, 0xBE, 0x73, 0xEF, 0x4E, 0x35, 0xC8, 0x5C, 0x61, 0x2A, 0x55, 0x11, 0x97, 0x5E, 0x57, 0xE4, 0x7F, 0xC8, 0x74, 0x61, 0xAA, 0xBB, 0x4E, 0x86, 0xEC,
  0xA8, 0x6F, 0xDD, 0xBA, 0x3F, 0x73, 0x97, 0xCA, 0x22, 0x22, 0xAF, 0xB4, 0xBC, 0xA2, 0x92, 0x02, 0x48, 0x8A, 0xA5, 0x61, 0xB2, 0xEF, 0xAC, 0x01, 0xA6, 0x14, 0x97, 0x95, 0xA3, 0x3A, 0xCF, 0x17, 0xA4, 0x15, 0x73, 0xF6, 0x56, 0x3C, 0x79, 0xB6,
  0xAB, 0xD0, 0x5D, 0x11, 0xF6, 0x27, 0xD3, 0x32, 0xE9, 0xDF, 0x9A, 0x06, 0xF4, 0x71, 0x8B, 0xDC, 0x68, 0xFE, 0xA2, 0xBF, 0xE8, 0xFF, 0x2B, 0x02, 0x95, 0x8C, 0xA4, 0x9E, 0x21, 0x30, 0xCA, 0x93, 0x06, 0x83, 0xFF, 0x5D, 0x6E, 0x2E, 0x0E, 0xC3,
  0x16, 0x0E, 0x50, 0xF5, 0x31, 0x3C, 0x0C, 0x58, 0xD2, 0xE9, 0x7C, 0x14, 0x62, 0xF0, 0xDF, 0xE1, 0x67, 0xC1, 0x38, 0xED, 0x70, 0xE7, 0xCE, 0xF0, 0xB0, 0x85, 0xFD, 0xE9, 0x3B, 0xA0, 0xA4, 0x81, 0x7A, 0x79, 0x02, 0x38, 0x02, 0xF9, 0xA7, 0x71,
  0x7A, 0x31, 0xE8, 0xD6, 0x3A, 0x04, 0x1D, 0x50, 0xCF, 0x9C, 0xBE, 0x73, 0x07, 0x42, 0xC9, 0x48, 0x12, 0x0A,
  0x90, 0x08, 0x44, 0x35, 0x32, 0x58, 0x1E, 0xF6, 0xAF, 0x3B, 0x78, 0xBF, 0x90, 0xBE, 0x8E, 0xAD, 0x43, 0x20, 0xCC, 0x95, 0x5C, 0xA7, 0xA1, 0x92, 0x8B, 0x20, 0x7C, 0x57, 0x72, 0x79, 0x25, 0x64, 0xA9, 0x29, 0xC9, 0xFF, 0x6B, 0x31, 0xA8, 0x1F,
  0xD4, 0x30, 0x0C, 0xCE, 0xDA, 0xA5, 0x0E, 0x0E, 0x40, 0x8E, 0x80, 0xA5, 0xBD, 0x35, 0xDD, 0x2B, 0xDC, 0x6D, 0xDA, 0x76, 0xFF, 0xF1, 0xE3, 0x95, 0xB6, 0xE9, 0x97, 0x4E, 0x3E, 0x78, 0x76, 0x3F, 0x5F, 0xF9, 0x5F, 0x29, 0xE3, 0x84, 0x48, 0x90,
  0x3D, 0x26, 0x70, 0x88, 0xE6, 0xA7, 0x81, 0x3E, 0x86, 0x4F, 0x3B, 0xF4, 0xD7, 0x4C, 0x4F, 0x16, 0x9D, 0x6A, 0x4C, 0x95, 0x54, 0x71, 0xF7, 0x52, 0x77, 0xF8, 0x87, 0x4C, 0xBF, 0x7E, 0x92, 0xAB, 0x26, 0xBF, 0x68, 0x96, 0xF4, 0x7F, 0xD0, 0x39,
  0x0E, 0x13, 0x13, 0xE7, 0xCD, 0xCD, 0x2D, 0xAC, 0xE9, 0xF4, 0xFE, 0x70, 0xDB, 0xBB, 0xCD, 0xA9, 0x17, 0x4B, 0xD2, 0x32, 0x0E, 0x45, 0x43, 0x74, 0x28, 0x23, 0xAD, 0x24, 0xBB, 0xF1, 0x44, 0x7A, 0xC4, 0x5E, 0x95, 0x45, 0x77, 0x29, 0xE0, 0xB1,
  0x09, 0x9C, 0x84, 0x09, 0x0E, 0x43, 0x5F, 0x7F, 0x95, 0x43, 0x92, 0x55, 0xA5, 0xFF, 0x91, 0xC1, 0x0F, 0x75, 0xE1, 0xCB, 0xD2, 0x87, 0xA0, 0xB2, 0x29, 0x48, 0x9B, 0xAD, 0xF7, 0x4F, 0x6F, 0x28, 0x54, 0x5C, 0x24, 0x48, 0x41, 0x6C, 0xAC, 0x8D,
  0x06, 0x20, 0x7E, 0xA0, 0xF9, 0x79, 0x9B, 0x75, 0xEB, 0x96, 0x27, 0x10, 0x1C, 0x74, 0x74, 0x00, 0xD8, 0xA4, 0x24, 0xBA, 0xCD, 0xF9, 0x41, 0x6D, 0x2B, 0x50, 0x25, 0xCD, 0xD6, 0xD5, 0x37, 0x57, 0xE6, 0xDD, 0x57, 0x5D, 0xA4, 0x76, 0x50, 0x70,
  0xA1, 0x86, 0xFE, 0x59, 0xB1, 0xFE, 0xEA, 0x51, 0xAE, 0xBD, 0x85, 0x75, 0x39, 0x1C, 0x18, 0x0C, 0xFC, 0x17, 0xF8, 0xBB, 0x42, 0x13, 0x01, 0x27, 0x38, 0xB8, 0x82, 0x42, 0xF3, 0xEE, 0xB1, 0xB0, 0xE4, 0xDC, 0x45, 0x73, 0x44, 0x70, 0x78, 0x4D,
  0x6B, 0x87, 0xD6, 0x7E, 0xC5, 0x31, 0xE7, 0xAD, 0x86, 0xF2, 0x47, 0xA8, 0xB9, 0x8B, 0x44, 0x81, 0xC2, 0x86, 0x4E, 0x27, 0x60, 0x08, 0x8C, 0xA0, 0xA0, 0x57, 0xAF, 0x33, 0xF3, 0x22, 0x36, 0x57, 0xE5, 0x2F, 0x76, 0xD5, 0xF0, 0xE5, 0x3C, 0x31,
  0x54, 0x73, 0xAD, 0x4A, 0x5C, 0xC1, 0xD3, 0x40, 0x41, 0xDC, 0x84, 0x0C, 0x87, 0xC1, 0xBE, 0x98, 0x7B, 0xAE, 0x45, 0x93, 0xB6, 0x61, 0xE1, 0x79, 0x0F, 0x9E, 0x47, 0x96, 0xED, 0xCD, 0xDD, 0x99, 0xE2, 0xAE, 0xB4, 0x48, 0xCD, 0x78, 0x21, 0x34,
  0xCC, 0x86, 0x0C, 0x86, 0x7A, 0x03, 0xCD, 0xCE, 0x27, 0xAE, 0x5A, 0x31, 0x46, 0x60, 0x5C, 0x5D, 0x72, 0xB0, 0xF4, 0x42, 0xDA, 0x45, 0x50, 0x5E, 0x82, 0xB2, 0xF5, 0x45, 0xCD, 0xC9, 0x88, 0x86, 0x67, 0x65, 0xB9, 0x29, 0x71, 0xAA, 0x0A,
  0x8B, 0x35, 0x48, 0x81, 0x0D, 0x6F, 0x88, 0x48, 0x9C, 0x9A, 0x12, 0xEB, 0xF3, 0x34, 0x46, 0xBD, 0xA0, 0xEA, 0xD5, 0x69, 0xC3, 0x23, 0xAB, 0x99, 0x8B, 0xA1, 0x47, 0x1A, 0x77, 0xB8, 0x36, 0xFB, 0x9F, 0x08, 0x81, 0x6A, 0xEC, 0xE4, 0xC8, 0xED,
  0x71, 0x4A, 0x9F, 0xE1, 0xF8, 0xC1, 0xFD, 0x11, 0x1A, 0x4D, 0x5A, 0x06, 0x06, 0x53, 0xFA, 0xFA, 0x1A, 0x9C, 0x00, 0xC0, 0x0F, 0xA4, 0x95, 0x00, 0xE3, 0xDB, 0x8C, 0xB4, 0x8D, 0x2D, 0x2D, 0x2D, 0x25, 0xB3, 0x97, 0xB3, 0xEF, 0x35, 0x9E, 0xF2,
  0x9F, 0x9C, 0x7E, 0x95, 0x5C, 0x95, 0xF3, 0xC7, 0xC9, 0x40, 0xFB, 0x37, 0xEF, 0xDF, 0x01, 0x88, 0x43, 0x44, 0x83, 0x29, 0xF1, 0x59, 0x0D, 0x8E, 0xA3, 0x8C, 0xDC, 0x5C, 0x4A, 0xBF, 0xE9, 0x51, 0xFC, 0xDB, 0xE8, 0x0B, 0x87, 0xAC, 0x32, 0xA2,
  0x36, 0xB6, 0x5C, 0xAE, 0xAB, 0x6F, 0x6C, 0xBE, 0x5B, 0x59, 0x93, 0x7C, 0xFF, 0x0F, 0xDB, 0x14, 0xC1, 0x68, 0xED, 0xF7, 0x2E, 0xCD, 0x3B, 0x3B, 0x04, 0xF4, 0x42, 0x0C, 0x04, 0x15, 0xFB, 0xE8, 0x5C, 0x8D, 0xB0, 0x6D, 0xC3, 0xCB, 0x47, 0xF1,
  0xC0, 0x57, 0xA2, 0x80, 0x1D, 0x86, 0xD6, 0xB7, 0xEE, 0x68, 0x06, 0x02, 0x9D, 0xAE, 0xD9, 0x52, 0x15, 0xF7, 0x47, 0x4D, 0x00, 0x16, 0xED, 0x7D, 0xD6, 0x4A, 0xD7, 0x37, 0x6B, 0x32, 0x20, 0x02, 0x90, 0x4D, 0xFA, 0xBC, 0x75, 0x42, 0x3A, 0xD4,
  0x00, 0x78, 0xF9, 0x06, 0xF2, 0xBC, 0x8B, 0xF7, 0x1A, 0x9B, 0xFD, 0xEF, 0x4E, 0x82, 0x48, 0xE1, 0x56, 0xF3, 0x3A, 0x33, 0x22, 0xF9, 0xD9, 0xF6, 0x05, 0x1D, 0x1B, 0xDD, 0x36, 0x57, 0x37, 0xE2, 0xA0, 0xC2, 0x5D, 0x5A, 0x56, 0x5E, 0x5E, 0x96,
  0xD3, 0xD4, 0xD4, 0x0B, 0x35, 0x01, 0xB4, 0x9A, 0xCC, 0x78, 0x1A, 0x42, 0x61, 0xD2, 0x12, 0xA0, 0x96, 0x92, 0xEC, 0xD6, 0xE6, 0xA2, 0x10, 0x5B, 0xB7, 0x57, 0x99, 0x11, 0x0D, 0xCF, 0x2B, 0x22, 0xA1, 0xBE, 0xC7, 0x76, 0x60, 0x3D, 0x0B, 0xCA,
  0x91, 0x44, 0xB3, 0x83, 0x62, 0x3F, 0xA9, 0xF3, 0x36, 0x60, 0xA8, 0xA0, 0x1A, 0xE7, 0xAE, 0xCC, 0x39, 0xDB, 0xA4, 0xA5, 0x35, 0x34, 0x34, 0x35, 0x24, 0x16, 0xF3, 0x78, 0x5D, 0x82, 0x9F, 0x93, 0x4A, 0x0F, 0xC5, 0x9C, 0x9A, 0x4C, 0x0F, 0xCF,
  0x4B, 0xAE, 0x38, 0x70, 0x7F, 0x67, 0x56, 0x8E, 0xBB, 0x1A, 0xD4, 0x03, 0x50, 0x54, 0x52, 0x52, 0x5C, 0x38, 0xEC, 0x7A, 0x92, 0xA0, 0xE5, 0x7A, 0xAB, 0x5F, 0x73, 0x01, 0x0C, 0xDD, 0x73, 0x0F, 0x54, 0x5D, 0xE6, 0x34, 0x01, 0x63, 0x1C, 0xD2,
  0x9A, 0x9A, 0x6A, 0x32, 0xD3, 0xE7, 0x71, 0xC0, 0x2E, 0x90, 0x94, 0xD6, 0x58, 0x99, 0x59, 0xB1, 0xB7, 0x38, 0xDF, 0x5D, 0x55, 0x49, 0x41, 0x5E, 0x16, 0x26, 0x39, 0x49, 0x90, 0x96, 0x96, 0xFE, 0x9D, 0x3C, 0x0D, 0xED, 0x49, 0xBB, 0x0D, 0x93,
  0x77, 0x76, 0xBE, 0x21, 0x2D, 0x2D, 0xEF, 0x5E, 0xF5, 0x20, 0x73, 0x8B, 0x17, 0x47, 0x5F, 0xAC, 0x35, 0x64, 0x30, 0x35, 0x14, 0x28, 0x36, 0x6B, 0xD2, 0xD7, 0xE0, 0x0B, 0x04, 0x02, 0xC2, 0x0E, 0xDB, 0xE4, 0xED, 0x6A, 0x10, 0xA4, 0xC5, 0x58,
  0x74, 0x30, 0xAB, 0xDB, 0x59, 0xB1, 0x8F, 0xDA, 0xD9, 0xAD, 0xE8, 0x23, 0xF2, 0x46, 0x7B, 0x8B, 0xBC, 0xF5, 0xD6, 0x35, 0xF1, 0xC4, 0xD0, 0xAA, 0x03, 0xC5, 0x4D, 0x53, 0x66, 0xBC, 0x04, 0xA1, 0xA0, 0x3C, 0x29, 0xFB, 0x6E, 0x78, 0x64, 0xDC,
  0xA2, 0x0F, 0xDE, 0x44, 0x24, 0xEA, 0x37, 0xDA, 0xCC, 0xCE, 0xAA, 0x6B, 0xCE, 0x34, 0x1A, 0xAD, 0x93, 0xD6, 0x39, 0x9E, 0x20, 0x3E, 0xAB, 0x3F, 0xD5, 0xD4, 0x3B, 0xA5, 0x15, 0x18, 0x18, 0xB8, 0xD6, 0xCC, 0x58, 0x58, 0x9E, 0xC4, 0x67, 0xA4,
  0x86, 0x64, 0x96, 0xB9, 0x2F, 0x3A, 0x62, 0x93, 0x58, 0xDE, 0xDA, 0x4B, 0x5D, 0x44, 0xAC, 0x1B, 0x9D, 0xDE, 0x5F, 0x7B, 0xE8, 0x8E, 0x62, 0x10, 0x06, 0xFA, 0x20, 0x94, 0x41, 0x9D, 0x14, 0xC0, 0x71, 0xDD, 0x44, 0xC2, 0xCF, 0x82, 0xA4, 0xA4,
  0x28, 0xC0, 0x72, 0xD7, 0x22, 0x23, 0xF6, 0x08, 0xCE, 0xA4, 0xCD, 0xB2, 0x0D, 0x3D, 0xD6, 0xD9, 0x7D, 0x4D, 0xAF, 0x96, 0x80, 0xA9, 0xC5, 0x30, 0x10, 0x1C, 0x2D, 0x9E, 0xBE, 0xBE, 0x19, 0x58, 0x33, 0x91, 0xC8, 0x99, 0x98, 0x30, 0x4E, 0x2C,
  0x17, 0x26, 0x79, 0x45, 0xA5, 0x1E, 0x8B, 0xC8, 0x55, 0x5E, 0xD4, 0x3E, 0x8D, 0x46, 0xE3, 0xD0, 0x68, 0x11, 0xC9, 0x8F, 0x7A, 0x9D, 0xD5, 0x83, 0x03, 0xC4, 0xF4, 0x11, 0xF0, 0x79, 0xC4, 0x26, 0x33, 0xF1, 0x5A, 0x22, 0x71, 0x2D, 0xD4, 0xFB,
  0x30, 0xB6, 0x11, 0xA0, 0x04, 0xFD, 0xFB, 0xD2, 0x1A, 0xFF, 0x76, 0x73, 0xFC, 0xD6, 0x62, 0xD6, 0x2D, 0x69, 0xA5, 0xD0, 0xBE, 0x5A, 0xEF, 0x7C, 0xE6, 0xDC, 0x35, 0xA8, 0x93, 0x42, 0x24, 0x76, 0x32, 0x6D, 0xD6, 0xF1, 0x88, 0x6B, 0x27, 0x38,
  0xEB, 0xE6, 0x7A, 0x29, 0x36, 0x89, 0xA0, 0xCE, 0xDC, 0x10, 0x5F, 0xB2, 0x55, 0xDD, 0x52, 0x7D, 0xDE, 0x51, 0x90, 0xB3, 0xB3, 0xC7, 0xEF, 0x61, 0x44, 0xF7, 0xB0, 0x7C, 0x57, 0xA3, 0xB9, 0xDC, 0x73, 0x68, 0x73, 0x8A, 0x29, 0x1B, 0x83, 0x31,
  0xD5, 0x43, 0x4A, 0x8E, 0xAA, 0x27, 0x26, 0xDE, 0x71, 0x4C, 0x40, 0xA1, 0xE8, 0x83, 0xBE, 0xEA, 0xEA, 0x37, 0xD9, 0x96, 0x7E, 0x2E, 0x2E, 0x73, 0x76, 0xD8, 0xEE, 0xED, 0xBD, 0xF4, 0xAB, 0x05, 0x5B, 0x29, 0x52, 0x1E, 0x26, 0x3D, 0x9E, 0xD7,
  0xCC, 0xCD, 0x6F, 0x58, 0x72, 0xCF, 0xAC, 0xE9, 0xB9, 0x89, 0x31, 0xC5, 0x70, 0x2D, 0xD5, 0x6F, 0xFA, 0x26, 0x40, 0xAC, 0x8E, 0x1E, 0x05, 0x6C, 0x8D, 0x8D, 0x8D, 0x13, 0x83, 0x46, 0x35, 0xC7, 0xD9, 0x6C, 0x4D, 0x4D, 0xF6, 0x98, 0xA5, 0xA6,
  0xA5, 0x88, 0x6A, 0x49, 0xA5, 0xA2, 0x45, 0x96, 0x4B, 0xDB, 0xDB, 0xBF, 0x5A, 0x50, 0xAE, 0x9E, 0x24, 0x92, 0xE1, 0x52, 0x6E, 0x9B, 0xE9, 0x18, 0x85, 0x7C, 0x86, 0x64, 0x88, 0xE1, 0xA2, 0x49, 0x3D, 0xE6, 0xE6, 0x96, 0xF8, 0xB1, 0xA3, 0x13,
  0x50, 0x73, 0x66, 0xE2, 0xE8, 0x70, 0x02, 0x03, 0x30, 0x63, 0x6B, 0xE2, 0xD9, 0x9A, 0x5D, 0xE0, 0x0D, 0x97, 0x4D, 0x69, 0x6F, 0x1F, 0xA3, 0x50, 0xD8, 0xED, 0xAB, 0x09, 0x0C, 0xB6, 0x8B, 0xAC, 0xBC, 0xC2, 0x27, 0xAE, 0x38, 0x32, 0xE2, 0x89,
  0x65, 0xA3, 0xB0, 0x58, 0x26, 0xD3, 0xA7, 0xC3, 0xE4, 0x9A, 0x6E, 0x3B, 0xCE, 0xD9, 0xD0, 0x90, 0xAB, 0xAB, 0x8B, 0x4C, 0x30, 0x3E, 0x6A, 0x03, 0x16, 0xEC, 0x60, 0x6D, 0x1A, 0xD0, 0xD5, 0x46, 0x61, 0xE3, 0x35, 0xBB, 0x34, 0x1D, 0xE9, 0xFC,
  0x2E, 0x01, 0x60, 0x8B, 0xC7, 0x6B, 0xB2, 0x01, 0x49, 0xC3, 0xF0, 0xDA, 0x71, 0x29, 0x85, 0xF9, 0x2A, 0xBF, 0x39, 0x4E, 0xD5, 0x63, 0x61, 0x44, 0x4C, 0x34, 0x0B, 0x4D, 0xFD, 0x1A, 0x4B, 0xEE, 0xA0, 0x91, 0xB1, 0xCC, 0xCE, 0x6B, 0xCB, 0xB8,
  0xBA, 0x0E, 0x16, 0xC2, 0xC4, 0xC4, 0x20, 0x4C, 0x97, 0x23, 0x43, 0xC7, 0x03, 0xCF, 0xE5, 0x52, 0xD8, 0x14, 0x4A, 0x10, 0xE5, 0xBB, 0xA0, 0x20, 0xFE, 0xF7, 0x0C, 0x3C, 0x23, 0x20, 0x80, 0x8B, 0xE7, 0xB3, 0x55, 0x95, 0xD5, 0xB2, 0x76, 0x3D,
  0xDF, 0x12, 0xD1, 0x50, 0x96, 0xFF, 0x71, 0x08, 0x1A, 0x61, 0x51, 0x59, 0x24, 0xCF, 0x1E, 0x12, 0x89, 0xC4, 0x32, 0x25, 0x8B, 0x58, 0xBE, 0xCE, 0xB4, 0x36, 0xEE, 0x78, 0xED, 0x1D, 0x7B, 0x46, 0x00, 0x06, 0xC3, 0xC0, 0xE0, 0x1D, 0x75, 0xEC,
  0x7D, 0x4D, 0xD9, 0xEC, 0x20, 0x8A, 0x63, 0xD0, 0xA6, 0x43, 0x17, 0x9B, 0x07, 0x4E, 0x60, 0x18, 0x63, 0x83, 0x7D, 0x3A, 0x2E, 0x0F, 0x2A, 0x0E, 0x94, 0x3D, 0x4D, 0x7E, 0x65, 0x1B, 0x72, 0xB7, 0x32, 0xFC, 0x69, 0xCE, 0x47, 0xDE, 0x24, 0x62,
  0x99, 0x74, 0x63, 0x4D, 0x3D, 0x98, 0xB7, 0x4C, 0x98, 0xA6, 0xA6, 0x58, 0xA3, 0x36, 0x12, 0x49, 0x77, 0x3D, 0x46, 0x68, 0x6F, 0x6F, 0xAA, 0x47, 0xE7, 0x0B, 0x47, 0xF1, 0x5D, 0x04, 0x0B, 0x20, 0xBB, 0x44, 0xA4, 0x1E, 0xD8, 0x6B, 0x1E, 0x15,
  0xCC, 0xD6, 0xD5, 0xFD, 0x38, 0x48, 0x20, 0x8C, 0xFD, 0x70, 0x05, 0xC4, 0x4A, 0xB7, 0xE9, 0xC9, 0x2B, 0xF5, 0x75, 0xD9, 0x8D, 0x93, 0x99, 0xF7, 0x3F, 0xEA, 0x49, 0xB1, 0xDA, 0xAE, 0xEB, 0xAE, 0xE9, 0xF1, 0x83, 0x3A, 0x52, 0x6B, 0xB0, 0x18,
  0x67, 0x8A, 0x77, 0xAD, 0xA5, 0xDF, 0x5C, 0x4B, 0xCA, 0xE8, 0x66, 0x00, 0x9D, 0x1D, 0xC0, 0x0D, 0xE2, 0xFE, 0xA4, 0x8B, 0x58, 0xD6, 0x0F, 0x85, 0xF2, 0x87, 0xF1, 0x17, 0xDE, 0x7E, 0x5B, 0xFA, 0x77, 0xAF, 0x80, 0xB1, 0x1F, 0xEB, 0xC0, 0xDE,
  0xD0, 0x9A, 0x5D, 0x12, 0x95, 0xB1, 0xB1, 0xEE, 0x4A, 0x58, 0xE4, 0x47, 0xFB, 0x4D, 0x8F, 0x0F, 0xAE, 0xCD, 0x87, 0xDC, 0xDD, 0xD3, 0xD3, 0x7D, 0xEE, 0xDC, 0xB9, 0x33, 0x23, 0x9E, 0x46, 0xB7, 0x3A, 0x3A, 0xC8, 0x64, 0x26, 0x20, 0x13, 0x1C,
  0x6B, 0x25, 0x1B, 0x83, 0xFF, 0xE5, 0x9F, 0xB5, 0x48, 0x24, 0x7F, 0xAE, 0x2D, 0xF2, 0x18, 0x24, 0x52, 0xA5, 0xA5, 0xDF, 0x7E, 0x3B, 0xDE, 0x75, 0x01, 0xEC, 0x61, 0x51, 0x05, 0x56, 0x05, 0x69, 0x97, 0xEB, 0x4F, 0x84, 0x3D, 0x75, 0x9F, 0xCF,
  0xD1, 0x88, 0x8C, 0xF5, 0x6C, 0xC3, 0xAE, 0x31, 0x61, 0xF5, 0x30, 0x75, 0xDB, 0x46, 0xDA, 0x47, 0xDA, 0xFC, 0x3C, 0x6A, 0x4D, 0xB1, 0x64, 0x72, 0xC7, 0x9A, 0xEB, 0xD7, 0x71, 0x6B, 0xA8, 0xB7, 0x6A, 0xE1, 0x88, 0x6A, 0x04, 0xFD, 0x1F, 0x57,
  0x01, 0xCB, 0x25, 0x4E, 0x07, 0x37, 0xED, 0x8B, 0xB6, 0xCA, 0xC8, 0xC8, 0x38, 0xE4, 0xB5, 0xFA, 0xD1, 0xB7, 0xF1, 0x6F, 0xAD, 0xA2, 0x66, 0x8F, 0x5C, 0x99, 0x84, 0xB2, 0xBE, 0xF9, 0xAB, 0xC6, 0x61, 0xED, 0xCE, 0xF4, 0xF8, 0x90, 0xCF, 0xAC,
  0xE9, 0x66, 0x8D, 0x5C, 0xF7, 0xFC, 0x09, 0x7B, 0xD3, 0x87, 0xEC, 0x67, 0x74, 0x53, 0xD7, 0x87, 0x8B, 0x01, 0x1A, 0xD5, 0xD3, 0xF5, 0x55, 0x07, 0x59, 0x4F, 0x62, 0x22, 0x5C, 0xC2, 0xF1, 0x60, 0x69, 0x74, 0xDA, 0xC5, 0xD4, 0x1D, 0x3B, 0x5A,
  0x2F, 0xCE, 0xF4, 0xC5, 0xC7, 0x5F, 0x88, 0x2A, 0xA9, 0xF7, 0xAF, 0xAC, 0x89, 0x78, 0xBE, 0x2B, 0xE7, 0xA3, 0xF4, 0xA7, 0x4D, 0x17, 0x8B, 0xED, 0xBE, 0x0E, 0x5F, 0x83, 0xA3, 0x9E, 0x19, 0x61, 0xB5, 0x01, 0x98, 0xBA, 0x76, 0x64, 0xEC, 0x6D,
  0xA3, 0x9B, 0x5C, 0x3C, 0x7E, 0x3D, 0x26, 0x40, 0x80, 0x82, 0xA3, 0x04, 0x09, 0x09, 0x09, 0xD5, 0x89, 0x50, 0x6F, 0x0F, 0x6C, 0x38, 0x3B, 0x06, 0x6C, 0xC3, 0xC2, 0xA6, 0x43, 0x5C, 0xEB, 0x5A, 0xA2, 0x7E, 0x0C, 0x75, 0x9D, 0xAC, 0x69, 0xA8,
  0x2A, 0xCC, 0x51, 0xF9, 0xD8, 0x7A, 0xB0, 0x80, 0x23, 0xD5, 0xAF, 0x4D, 0x8F, 0x89, 0xA3, 0x32, 0xAF, 0x1B, 0x99, 0x9A, 0xB6, 0x19, 0x71, 0x4D, 0xC9, 0x64, 0xEC, 0x1A, 0xA3, 0x9F, 0x90, 0x82, 0x20, 0x9D, 0xA0, 0xB9, 0xB6, 0x59, 0x22, 0x0A,
  0x09, 0x52, 0x95, 0xC7, 0xD1, 0x31, 0x5B, 0xD3, 0x23, 0x9E, 0x95, 0x55, 0x3D, 0x8D, 0x70, 0x1B, 0x70, 0x3D, 0x72, 0xA4, 0xF9, 0x58, 0x78, 0x45, 0xA1, 0x0A,
  0xD8, 0x79, 0x3E, 0x76, 0x1A, 0x6F, 0x26, 0x19, 0xEB, 0xC1, 0xC4, 0xDA, 0x75, 0xF8, 0x02, 0x96, 0x67, 0x6E, 0x63, 0xEC, 0xAE, 0x8F, 0xC8, 0xAD, 0x87, 0xE4, 0x38, 0xA2, 0x0D, 0xF2, 0x13, 0x2F, 0xB8, 0x84, 0x23, 0x1D, 0x85, 0xE8, 0x93, 0xD9,
  0x56, 0x9A, 0xD1, 0x6A, 0xDB, 0xB0, 0xDD, 0x5D, 0x59, 0x59, 0xAD, 0xF8, 0x69, 0x5E, 0xFA, 0xE4, 0x00, 0x90, 0xE0, 0xAE, 0x05, 0x76, 0x6C, 0x6F, 0xE7, 0x65, 0x6D, 0xD8, 0x71, 0xD3, 0x73, 0xDD, 0xD7, 0xB1, 0x4C, 0x34, 0x75, 0x0D, 0x19, 0xC8,
  0x00, 0xB0, 0x02, 0x30, 0x99, 0x24, 0x88, 0x65, 0x3F, 0x42, 0x90, 0x98, 0x48, 0x47, 0xC1, 0x91, 0x0C, 0x99, 0xDD, 0x8F, 0x66, 0xB6, 0x86, 0xEF, 0x55, 0x95, 0x95, 0x96, 0x96, 0x55, 0x74, 0xCF, 0xAD, 0xC8, 0x0B, 0x7B, 0x71, 0x09, 0x70, 0xFC,
  0x34, 0xAE, 0x33, 0x69, 0xA6, 0x8E, 0x6D, 0xBA, 0xE7, 0x46, 0x7A, 0x0C, 0xBD, 0xE4, 0x4C, 0xD1, 0x68, 0x13, 0x32, 0x96, 0x6A, 0x04, 0x99, 0x4A, 0x5B, 0x07, 0x99, 0x04, 0x9D, 0x28, 0x08, 0xE1, 0x08, 0x04, 0x12, 0x81, 0xE2, 0xC3, 0x01, 0xC7,
  0x96, 0xC3, 0x99, 0x3B, 0x25, 0x4A, 0x90, 0x96, 0x55, 0xCA, 0xD9, 0xFB, 0x3C, 0x22, 0xAF, 0x61, 0xEF, 0x02, 0x33, 0x05, 0x1D, 0xCE, 0x7E, 0xB5, 0x7A, 0x64, 0x56, 0x8F, 0x91, 0x17, 0xB4, 0x48, 0xAE, 0xDF, 0x19, 0x26, 0x16, 0x37, 0x08, 0x59,
  0x8A, 0x17, 0x96, 0x8C, 0x03, 0x36, 0xB8, 0x1B, 0xCA, 0x6F, 0xE1, 0x42, 0x41, 0x75, 0xDF, 0xB6, 0x87, 0x69, 0x5B, 0xC3, 0x73, 0xDF, 0xA9, 0x15, 0x26, 0xAF, 0x9A, 0xB2, 0x2B, 0xB2, 0xAC, 0x58, 0xF5, 0x53, 0x8C, 0x6B, 0xA8, 0x34, 0xBD, 0x36,
  0x96, 0x21, 0xE9, 0xF6, 0x5C, 0x16, 0xE6, 0x65, 0x4A, 0xB6, 0xA4, 0xFA, 0x41, 0xB9, 0xD3, 0xA6, 0x4D, 0xDA, 0x64, 0x3B, 0xA7, 0x83, 0x2F, 0x97, 0x09, 0xE0, 0xD5, 0x28, 0x14, 0xB2, 0x3C, 0xC0, 0xE9, 0x65, 0xC6, 0xBC, 0x16, 0x97, 0x34, 0x4C,
  0x51, 0x25, 0x27, 0x47, 0x65, 0x81, 0x31, 0x0E, 0x5F, 0x32, 0x4D, 0xAF, 0xBB, 0x87, 0x4A, 0x35, 0x9C, 0x3B, 0x36, 0x59, 0xE2, 0x84, 0x69, 0x1B, 0xF3, 0x06, 0x1E, 0xF7, 0xED, 0xDB, 0x0B, 0xF1, 0x83, 0xB7, 0x1F, 0x83, 0xDC, 0x16, 0x80, 0x44,
  0xA1, 0xBE, 0xE7, 0xA3, 0x96, 0x3C, 0x3E, 0x74, 0xAF, 0xF2, 0xF9, 0xAF, 0xEE, 0x21, 0x2D, 0x09, 0x8E, 0x0B, 0x84, 0xDC, 0x33, 0x34, 0xAC, 0xFA, 0x71, 0xB9, 0x35, 0x2C, 0x88, 0xE3, 0x92, 0xDD, 0x1B, 0x36, 0xBD, 0x64, 0xFA, 0x7A, 0x3B, 0x6D,
  0xDB, 0x74, 0x21, 0x6D, 0xB6, 0x24, 0xCD, 0x2B, 0xFE, 0x6D, 0x5A, 0xE8, 0x6E, 0x21, 0x02, 0xF1, 0xFD, 0xF7, 0x7C, 0x64, 0xDF, 0x86, 0xF8, 0x98, 0xBB, 0x11, 0x85, 0x0A,
  0x7F, 0xD0, 0x64, 0x7A, 0x27, 0x48, 0x96, 0xC7, 0xF3, 0xE3, 0xD9, 0xEB, 0x25, 0xE7, 0xE2, 0xBB, 0x4B, 0xE3, 0x0B, 0x32, 0xF0, 0x96, 0xA2, 0xC1, 0x0D, 0xA5, 0x56, 0x97, 0x5B, 0x5D, 0x5B, 0xB3, 0x5B, 0x36, 0xCE, 0x36, 0x0E, 0x2C, 0x43, 0xC2,
  0xF9, 0x02, 0x3E, 0x32, 0x00, 0x08, 0xF2, 0x54, 0xCD, 0x2E, 0xE5, 0xCF, 0xEE, 0x87, 0x4C, 0x13, 0xF7, 0xE7, 0xFB, 0xB3, 0xA3, 0x29, 0xB7, 0xA0, 0xB3, 0xA7, 0xE8, 0x92, 0xFA, 0xD6, 0xFA, 0x31, 0x91, 0xF6, 0xA3, 0x47, 0x56, 0x75, 0xCD, 0xC7,
  0x2A, 0x07, 0x5C, 0xEB, 0x7F, 0x70, 0x9D, 0x0C, 0x43, 0xA1, 0x62, 0xF9, 0x7C, 0xFA, 0xF7, 0x4E, 0x9B, 0xAC, 0x52, 0x6D, 0xF7, 0xB8, 0x7F, 0x36, 0x0F, 0x60, 0xF6, 0xAB, 0x55, 0xD8, 0xDE, 0x8B, 0x7E, 0xAC, 0xEE, 0xB4, 0xED, 0x71, 0xFC, 0xCC,
  0x8E, 0xC9, 0xE9, 0x4A, 0x4D, 0x51, 0x4C, 0x46, 0xB4, 0xD5, 0x6C, 0x73, 0x7A, 0x66, 0xA6, 0x5B, 0x88, 0xBF, 0xFF, 0x64, 0x58, 0xBF, 0x00, 0x2E, 0x00, 0xD1, 0x72, 0xC9, 0x27, 0xCB, 0x5E, 0x98, 0x3C, 0x60, 0xAA, 0x91, 0xE9, 0xAD, 0x19, 0xA5,
  0x8F, 0x37, 0x95, 0xEE, 0xB3, 0xCA, 0x1E, 0x78, 0xFD, 0x64, 0x73, 0x9F, 0xA8, 0x28, 0xB5, 0x25, 0xA3, 0xC4, 0x35, 0xBD, 0xE1, 0x40, 0x45, 0x9E, 0x5B, 0xA5, 0x6D, 0x58, 0x04, 0x0A,
  0x29, 0x18, 0xFC, 0x09, 0xE3, 0xB4, 0x7B, 0x91, 0xCB, 0x96, 0x56, 0xBA, 0xFF, 0x6A, 0x6B, 0x4B, 0x74, 0x3C, 0x48, 0x8C, 0x7F, 0x6C, 0xAD, 0x4C, 0xDE, 0x9E, 0xB5, 0xBD, 0xE2, 0xF5, 0xB1, 0xD6, 0x92, 0x92, 0x56, 0xDB, 0x27, 0x85, 0xF9, 0xB9,
  0x7B, 0xF2, 0x5E, 0x65, 0x36, 0x6C, 0x0C, 0xFA, 0x5B, 0x6A, 0x46, 0xE9, 0x6E, 0xC9, 0xB2, 0x2B, 0xDC, 0x3F, 0x5F, 0xB9, 0x29, 0xA4, 0x44, 0x84, 0x84, 0xCE, 0x80, 0xC4, 0xB8, 0xF5, 0x48, 0xB3, 0x6D, 0x43, 0x96, 0x92, 0x52, 0x5C, 0x55, 0x66,
  0x48, 0xEA, 0xE5, 0xFA, 0x63, 0xC9, 0x59, 0x4A, 0xCA, 0x59, 0xBB, 0x2A, 0x2A, 0xCA, 0x72, 0x23, 0x5F, 0x17, 0xC5, 0x44, 0x3F, 0xDE, 0xB6, 0x01, 0xEA, 0x5F, 0xA7, 0x7C, 0xBE, 0x8F, 0x2B, 0xEB, 0x5E, 0x91, 0xBE, 0xB5, 0xF5, 0x54, 0x88, 0x6D,
  0xE5, 0xDD, 0x81, 0xF4, 0x86, 0x2C, 0x05, 0x98, 0xBC, 0x7B, 0xE4, 0x25, 0xFF, 0x7B, 0xAD, 0x93, 0x0F, 0xC0, 0x7B, 0x05, 0xB5, 0xAC, 0x94, 0x1C, 0xB5, 0xAC, 0x8A, 0x17, 0x3B, 0xD2, 0xF6, 0x6D, 0xD8, 0xB0, 0xAF, 0xC4, 0xFF, 0xE4, 0x22, 0x9A,
  0xCD, 0xD2, 0xCA, 0x7B, 0x33, 0x2B, 0x43, 0xA6, 0xF3, 0x1A, 0xB6, 0xD4, 0xA4, 0xBF, 0xDA, 0x93, 0x2F, 0x0F, 0xD2, 0xE7, 0x94, 0xE4, 0xCA, 0xE6, 0xE6, 0xCA, 0xE4, 0x2C, 0xF0, 0x5E, 0x56, 0x41, 0x51, 0x41, 0x5E, 0xA9, 0x38, 0x22, 0x24, 0xDB,
  0xEA, 0x61, 0x69, 0x7C, 0xC9, 0x95, 0xF0, 0xFB, 0x4A, 0x9F, 0xE7, 0xA8, 0x98, 0xF2, 0xFC, 0x75, 0x78, 0xF2, 0xAE, 0xC2, 0xDC, 0x8A, 0x2D, 0xC9, 0x55, 0xEE, 0xF2, 0x50, 0x1B, 0xB7, 0x2C, 0xFC, 0x58, 0x88, 0x5B, 0x85, 0xA4, 0x07, 0x0C, 0x25,
  0x3A, 0xB2, 0x2A, 0x07, 0x6A, 0xB6, 0xC6, 0x64, 0x14, 0xA4, 0xDD, 0xBB, 0x9B, 0x99, 0xFB, 0x79, 0x8E, 0x52, 0xB2, 0x6A, 0xF7, 0x9F, 0x3D, 0xCB, 0x75, 0x57, 0x52, 0xCD, 0xBA, 0x7F, 0x5F, 0x72, 0xA8, 0x08, 0x40, 0x3E, 0x0F, 0xAF, 0x91, 0xB4,
  0x9D, 0xDF, 0x7D, 0xA8, 0x42, 0xD6, 0xE6, 0xF4, 0xAD, 0xA9, 0xF5, 0x3B, 0xEE, 0xBA, 0x3D, 0xC9, 0x5A, 0x44, 0xFA, 0x0C, 0x53, 0x74, 0x4F, 0xC9, 0x52, 0x53, 0x80, 0xC9, 0x2A, 0xAA, 0xA8, 0xCC, 0x55, 0x8F, 0xB2, 0x2A, 0xDB, 0x9F, 0xED, 0xA9,
  0x9A, 0x77, 0xF2, 0x0B, 0x53, 0xDE, 0x9E, 0x1C, 0x66, 0x6B, 0xEB, 0x96, 0xF9, 0x7C, 0xA7, 0xEA, 0x62, 0x52, 0x5D, 0x98, 0x02, 0x28, 0x4E, 0xA0, 0xA6, 0x35, 0xD4, 0xFB, 0x9D, 0x6B, 0x3E, 0xAB, 0xE4, 0x67, 0x7D, 0x54, 0x00, 0xC9, 0xAA, 0x16,
  0x47, 0x3E, 0xDF, 0x13, 0x99, 0x9B, 0xAF, 0xBC, 0xB8, 0x74, 0x5C, 0xFA, 0xB7, 0x85, 0x05, 0x50, 0xC8, 0xC7, 0x81, 0x45, 0x1A, 0x3A, 0x41, 0x75, 0x57, 0x51, 0xFA, 0x33, 0xCD, 0xA8, 0x3F, 0xEE, 0x5E, 0xFF, 0xD5, 0xE9, 0xFC, 0x8B, 0xFE, 0xA2,
  0xBF, 0xE8, 0x2F, 0xFA, 0x13, 0xA7, 0x1A, 0x7D, 0xC3, 0x0E, 0xD6, 0xD6, 0x04, 0x02, 0x81, 0xCE, 0x60, 0x10, 0xAC, 0x87, 0xFB, 0x82, 0xFF, 0xAF, 0x00, 0x0B, 0xEE, 0xB3, 0x66, 0xE8, 0x58, 0x58, 0x58, 0x0C, 0x43, 0x83, 0xC9, 0x12, 0x92, 0xFC,
  0x00, 0xC0, 0x32, 0xE8, 0x49, 0x42, 0x24, 0x92, 0xF1, 0xBF, 0x84, 0x1A, 0xEC, 0xE2, 0x60, 0x3D, 0x0C, 0xF0, 0xE8, 0x40, 0x47, 0x23, 0xA7, 0x21, 0x64, 0x73, 0x34, 0x0C, 0x21, 0xD4, 0x21, 0x30, 0x92, 0x92, 0x92, 0x04, 0x02, 0x01, 0xD4, 0x4C,
  0x67, 0x0C, 0xFF, 0x2F, 0x60, 0xBA, 0x38, 0x10, 0xE8, 0xF6, 0x77, 0xEE, 0x40, 0x87, 0x55, 0x0E, 0xD6, 0x92, 0x03, 0x97, 0xD3, 0xA7, 0xEF, 0x48, 0x08, 0x1A, 0x9E, 0x03, 0x20, 0x21, 0x21, 0xF2, 0x41, 0x55, 0x09, 0x10, 0xC6, 0x22, 0x10, 0xF0,
  0xF3, 0xC1, 0xBF, 0x1D, 0x56, 0xFE, 0x0F, 0x52, 0x9F, 0x35, 0x5D, 0xC0, 0xC0, 0xD0, 0xE9, 0x0C, 0x60, 0x73, 0x04, 0x82, 0x8E, 0x8E, 0xE4, 0x3C, 0x08, 0x12, 0xA4, 0x04, 0x30, 0x34, 0xDC, 0x07, 0x74, 0x6E, 0x0D, 0x09, 0x11, 0x85, 0x84, 0x83,
  0x72, 0x0D, 0xF1, 0x0B, 0x00, 0x59, 0x0D, 0x17, 0x9E, 0x56, 0x51, 0x05, 0x69, 0x8B, 0x2C, 0xEC, 0x3F, 0xBB, 0xE1, 0x7B, 0xF5, 0x83, 0xCA, 0x0B, 0x8E, 0xA2, 0xF3, 0x39, 0xE2, 0x55, 0xED, 0x40, 0x97, 0x00, 0x21, 0x24, 0x40, 0x8B, 0x39, 0x1B,
  0xB4, 0x87, 0x00, 0x02, 0xF1, 0x11, 0x92, 0x92, 0x1C, 0xA1, 0x83, 0x30, 0xAB, 0xF0, 0x39, 0x82, 0x4E, 0x34, 0x22, 0x92, 0x37, 0x7B, 0x45, 0x96, 0xDD, 0xDF, 0x09, 0x32, 0x5B, 0x65, 0x80, 0xF3, 0x3F, 0x24, 0xCE, 0x50, 0xA8, 0x17, 0x90, 0x60,
  0x0C, 0xEA, 0x6C, 0xA1, 0x03, 0x67, 0x8A, 0x68, 0x6E, 0x78, 0x5A, 0x22, 0x30, 0x80, 0x71, 0x58, 0x02, 0xCF, 0x82, 0x10, 0x14, 0xE4, 0x15, 0x7E, 0xC9, 0x6D, 0xDA, 0xF6, 0x78, 0xC8, 0x40, 0x51, 0xD1, 0xE1, 0xAD, 0x5B, 0x9B, 0x9B, 0x4F, 0x9D,
  0x3A, 0xD5, 0xBC, 0x75, 0x2B, 0x74, 0x90, 0x13, 0x72, 0xDC, 0x36, 0x3D, 0x2C, 0x3C, 0x73, 0xCB, 0x93, 0xC8, 0xBD, 0xC5, 0x39, 0xFF, 0x56, 0x2E, 0xF6, 0xFB, 0xBE, 0x11, 0x84, 0x42, 0x40, 0x47, 0x73, 0x36, 0x47, 0x27, 0x26, 0x96, 0x5B, 0x7C,
  0x65, 0x60, 0x6E, 0x6E, 0xBE, 0xF2, 0x8E, 0xFD, 0x30, 0x01, 0x8A, 0x2F, 0x0E, 0xD6, 0xF4, 0xFE, 0xBE, 0x9A, 0x17, 0xB6, 0xC7, 0x06, 0xFC, 0xB7, 0xBA, 0xB6, 0xA6, 0xDE, 0xCB, 0xBE, 0x18, 0x33, 0x5B, 0x32, 0x33, 0x93, 0xF6, 0x9E, 0x66, 0x4A,
  0x4A, 0x62, 0x2E, 0x66, 0xD7, 0xB7, 0xBA, 0x5E, 0x39, 0x31, 0x69, 0x1B, 0x76, 0x32, 0xF9, 0xD9, 0xDE, 0x14, 0xB5, 0x2F, 0x0F, 0xB2, 0x4F, 0x80, 0xA8, 0x8E, 0x4D, 0xE0, 0x4C, 0x24, 0x3A, 0x0C, 0x2F, 0x07, 0xAF, 0x84, 0x55, 0xE2, 0x15, 0x66,
  0x2B, 0xC6, 0x80, 0x4A, 0x93, 0xF8, 0xFD, 0x56, 0xE1, 0x6E, 0x95, 0x21, 0xFE, 0xCD, 0x8D, 0xF5, 0xD9, 0x31, 0x25, 0x1B, 0xA3, 0x32, 0xAC, 0xA2, 0xA3, 0xE3, 0xE3, 0xDF, 0xEC, 0x7B, 0xF4, 0xE8, 0x21, 0xA0, 0x47, 0x8F, 0xF6, 0xED, 0xDB, 0x17,
  0x1F, 0xFF, 0x36, 0xFA, 0x50, 0x41, 0x54, 0x5A, 0xCB, 0xE5, 0xEC, 0x7A, 0x57, 0xFF, 0x90, 0xE9, 0x57, 0x5B, 0x9E, 0xE6, 0xE6, 0xA8, 0x2A, 0x7C, 0x59, 0x8C, 0x57, 0x85, 0x00, 0x61, 0x75, 0x82, 0x86, 0x06, 0x47, 0x42, 0x36, 0x74, 0x8E, 0xBE,
  0xBE, 0x98, 0x68, 0xBE, 0xD2, 0x81, 0xD1, 0x3F, 0x7D, 0xEC, 0xAE, 0xF6, 0xF9, 0xE5, 0x47, 0x8F, 0x42, 0x53, 0xFC, 0x47, 0x97, 0x2F, 0x5F, 0x6E, 0x23, 0xA1, 0xF3, 0x80, 0x06, 0x07, 0x07, 0x4B, 0x4B, 0x1F, 0x3E, 0xDA, 0xF7, 0x26, 0x1E, 0x1A,
  0x99, 0x2C, 0xC8, 0x88, 0x82, 0x0E, 0x03, 0x43, 0x5B, 0x9B, 0x4F, 0xD8, 0xD6, 0x44, 0x3C, 0xDD, 0x9E, 0xA3, 0x2C, 0x0F, 0xFB, 0x92, 0x10, 0x05, 0xF0, 0xEA, 0xD8, 0x58, 0xFE, 0x84, 0x86, 0x06, 0x4F, 0xF2, 0xC5, 0x59, 0x36, 0x61, 0xBE, 0x72,
  0x6C, 0x74, 0x34, 0x71, 0x94, 0x00, 0x2C, 0x71, 0x18, 0xB2, 0x48, 0x6B, 0x46, 0x92, 0x40, 0x88, 0x84, 0x1C, 0x18, 0x21, 0x89, 0x32, 0x92, 0x48, 0x83, 0x40, 0xD1, 0x19, 0xA3, 0x36, 0xAB, 0x1D, 0xFE, 0x36, 0x0B, 0x14, 0x1D, 0x7A, 0x2F, 0x35,
  0x15, 0x9A, 0x16, 0x05, 0xCA, 0xAE, 0x89, 0xA8, 0xB8, 0x9F, 0xFF, 0x65, 0xC5, 0xE8, 0x25, 0x80, 0xC3, 0xAB, 0x6D, 0x34, 0x78, 0xBC, 0xB3, 0x66, 0xE2, 0xC0, 0xA9, 0x26, 0xB1, 0xD9, 0x57, 0x16, 0x2B, 0xEF, 0x98, 0x9B, 0xAF, 0x3A, 0x1F, 0x04,
  0x3D, 0x6F, 0xF2, 0x0B, 0x1C, 0x2E, 0x19, 0xAB, 0x85, 0x43, 0xA0, 0x10, 0x88, 0xEA, 0x6A, 0x04, 0x22, 0x09, 0xFA, 0x16, 0x0B, 0xAF, 0xAE, 0xAE, 0x46, 0x22, 0x91, 0xE0, 0x2A, 0x9F, 0xD0, 0x77, 0x6C, 0x7F, 0xA5, 0xAD, 0xAD, 0xED, 0xF4, 0xF4,
  0x8B, 0xB0, 0x57, 0x99, 0x0F, 0xF6, 0x54, 0x15, 0xBA, 0x7F, 0x59, 0x6B, 0x14, 0x20, 0x11, 0xFF, 0x98, 0xD0, 0xE0, 0x9D, 0x6D, 0x32, 0x98, 0x22, 0x12, 0xB5, 0x88, 0x53, 0x81, 0xCE, 0x82, 0x09, 0xB1, 0x19, 0x24, 0x4E, 0x4C, 0x39, 0x7C, 0xEE,
  0xEC, 0xF4, 0x67, 0x78, 0x39, 0x52, 0x58, 0x2E, 0x14, 0xF0, 0xE9, 0x04, 0x6B, 0x6B, 0x1D, 0x6D, 0xA0, 0xE4, 0xBE, 0xC1, 0xC1, 0xBB, 0x92, 0xD9, 0xD5, 0xB0, 0x9A, 0xF0, 0x93, 0x56, 0x7D, 0x98, 0xBE, 0x86, 0x27, 0xCF, 0xF7, 0xEC, 0xA9, 0x78,
  0x16, 0x79, 0xA0, 0x2A, 0xB7, 0xF0, 0x4B, 0x3B, 0xB5, 0x17, 0x02, 0x81, 0x5C, 0xAE, 0xC1, 0x13, 0x37, 0x69, 0x19, 0x68, 0x19, 0x4C, 0xAD, 0x5D, 0x1B, 0x28, 0x5E, 0x81, 0x17, 0x2E, 0xE7, 0xE9, 0xF3, 0x78, 0x3C, 0xB6, 0x10, 0x5E, 0x5E, 0x2E,
  0x10, 0x24, 0x25, 0x31, 0x18, 0x57, 0x07, 0xFB, 0x1E, 0xC6, 0x5F, 0xC8, 0xD8, 0x58, 0x02, 0x1D, 0x78, 0x9E, 0xBA, 0x72, 0x62, 0x40, 0x72, 0x52, 0x77, 0xE9, 0xD5, 0xEB, 0xBC, 0x88, 0x2D, 0xC9, 0x4F, 0x2A, 0x00, 0xB2, 0xFB, 0xB9, 0x3B, 0x0B,
  0x53, 0xB2, 0x72, 0xE2, 0xD4, 0x54, 0xA0, 0xD8, 0xF8, 0x45, 0xBD, 0xA5, 0x5F, 0x40, 0xE7, 0xF0, 0xCE, 0x0E, 0x69, 0x19, 0x10, 0x0D, 0x0C, 0x86, 0xA6, 0x9A, 0x9A, 0xC4, 0x62, 0x7D, 0x7D, 0x1E, 0x67, 0x9D, 0x4D, 0x02, 0x23, 0xE0, 0xEA, 0xE0,
  0xA0, 0x8C, 0x84, 0xA0, 0xE6, 0xDA, 0xC3, 0x78, 0xAB, 0xA8, 0x99, 0x98, 0x3A, 0x80, 0xD0, 0xF5, 0x54, 0xF3, 0x15, 0xFF, 0x13, 0x27, 0x06, 0x42, 0x26, 0x8F, 0x57, 0xCE, 0xC9, 0x31, 0x33, 0x6F, 0x4B, 0xF2, 0xF3, 0x67, 0x07, 0x76, 0xE5, 0x16,
  0x67, 0xC5, 0xA9, 0x28, 0x29, 0xC8, 0x7F, 0xE1, 0x91, 0x28, 0x38, 0x9F, 0x03, 0x1D, 0x9F, 0x19, 0x18, 0x40, 0x47, 0xBA, 0xC0, 0x12, 0xCF, 0x02, 0xF9, 0x69, 0x70, 0xD6, 0x39, 0x7A, 0x41, 0xD8, 0xE4, 0xE6, 0x66, 0x06, 0x9D, 0x00, 0xC4, 0x47,
  0x50, 0x4F, 0xA7, 0xA5, 0x24, 0x26, 0xA6, 0x0E, 0x50, 0x76, 0x76, 0x68, 0x68, 0x68, 0x7D, 0xFD, 0x91, 0x46, 0xC9, 0x3C, 0x75, 0xD1, 0xC0, 0xE4, 0x7E, 0x28, 0x76, 0xE7, 0x7D, 0x89, 0xD8, 0xBD, 0x14, 0xF7, 0x89, 0x9E, 0x01, 0x42, 0xFD, 0xA9,
  0x5E, 0x48, 0x86, 0x44, 0xA2, 0x58, 0x3C, 0x07, 0x90, 0x33, 0x11, 0xF0, 0x01, 0xE0, 0xDC, 0xF1, 0xEE, 0xC1, 0x0D, 0x2F, 0x1F, 0xBE, 0x79, 0x0B, 0x0D, 0x64, 0x03, 0xCA, 0x00, 0x14, 0x15, 0x15, 0x05, 0x1D, 0x49, 0x97, 0xCC, 0x5E, 0xAE, 0x0B,
  0xBD, 0x07, 0x24, 0x2B, 0x39, 0xA5, 0x4D, 0xBF, 0x94, 0xB9, 0x65, 0x4F, 0x55, 0xF1, 0xBF, 0x70, 0x7E, 0xFE, 0x5B, 0xD2, 0xA6, 0x92, 0x5C, 0x3E, 0xD9, 0xF8, 0x80, 0x96, 0x7B, 0x21, 0x09, 0x12, 0xA1, 0x99, 0xEE, 0xA6, 0xA9, 0xA6, 0xB3, 0x00,
  0xA3, 0xC6, 0x3A, 0xFA, 0xB2, 0xFE, 0x39, 0x01, 0xCE, 0x75, 0x3E, 0x01, 0xC4, 0x4D, 0x2F, 0x4B, 0xA1, 0x38, 0x0D, 0xA2, 0xE0, 0x85, 0x43, 0x56, 0xD0, 0xB1, 0x00, 0x40, 0x08, 0x01, 0xAC, 0x83, 0x86, 0xFB, 0x21, 0x88, 0x90, 0x7D, 0x4E, 0x87,
  0xBD, 0x86, 0x30, 0xBA, 0x2B, 0xFF, 0x49, 0x39, 0x5A, 0xE2, 0x9C, 0x6F, 0xFD, 0x16, 0x22, 0x92, 0xA3, 0x7F, 0x56, 0xDC, 0x0B, 0x49, 0x11, 0x90, 0x01, 0x71, 0xA8, 0xA9, 0x09, 0x92, 0x23, 0x4F, 0xC3, 0x06, 0x78, 0xC9, 0xB2, 0xF7, 0xF8, 0xA0,
  0x5E, 0xEA, 0xC3, 0x7D, 0x92, 0x5D, 0x04, 0x84, 0xE8, 0x99, 0x12, 0x28, 0x10, 0xDE, 0x3B, 0xD2, 0x3A, 0x67, 0x94, 0xFE, 0x45, 0x77, 0x07, 0x42, 0x8E, 0xED, 0xB7, 0xB5, 0x4D, 0x7F, 0x11, 0x76, 0x29, 0x3C, 0x33, 0xA2, 0xE1, 0xE9, 0xAE, 0xC2,
  0xC5, 0x42, 0x14, 0xF9, 0x06, 0x7F, 0x2C, 0xC2, 0x11, 0x67, 0x1A, 0xF9, 0xD7, 0xCE, 0x09, 0x4C, 0x72, 0x8C, 0x3C, 0x01, 0x5C, 0xB9, 0xB7, 0xD7, 0xA0, 0xC9, 0xA0, 0x97, 0x08, 0xB9, 0x8B, 0xC1, 0xD0, 0xD0, 0xDA, 0x26, 0x7D, 0xC8, 0x5F, 0x18,
  0xC2, 0xF2, 0x9F, 0x93, 0x18, 0x00, 0x20, 0xC0, 0xF7, 0xF0, 0x4D, 0x74, 0x41, 0xD4, 0x0C, 0xB4, 0x15, 0xDF, 0x4B, 0x6D, 0xDC, 0x71, 0x0A,
  0xCA, 0x1B, 0x8E, 0x41, 0x0E, 0x1D, 0x56, 0xF3, 0x2A, 0xFC, 0x64, 0x26, 0x94, 0xEA, 0x3C, 0x48, 0xDE, 0x0C, 0x82, 0x4E, 0xC5, 0xB3, 0xA7, 0x91, 0x65, 0x7B, 0x77, 0x66, 0xB9, 0x2F, 0x56, 0xD1, 0xCE, 0x34, 0x12, 0x9A, 0xF9, 0xE1, 0xA7, 0x6F,
  0x48, 0x23, 0xCE, 0x37, 0x70, 0xC1, 0x73, 0xF8, 0x60, 0xF2, 0x0A,
  0x4A, 0xCA, 0xCA, 0xCA, 0x8A, 0x0A,
  0xF2, 0x9C, 0x5E, 0x7D, 0x71, 0x6F, 0x6F, 0x2F, 0xF0, 0x96, 0x21, 0x00, 0xB1, 0x77, 0x48, 0x2B, 0x50, 0x1C, 0x68, 0xA6, 0x0F, 0x42, 0xCE, 0x3A, 0x3E, 0x88, 0x83, 0x49, 0x49, 0xCB, 0x0E, 0x02, 0x57, 0x2E, 0x48, 0x8B, 0xB9, 0xD7, 0x7A, 0xEA,
  0xB0, 0x24, 0x10, 0xBA, 0x5D, 0x0A,
  0x3F, 0x99, 0x07, 0xB2, 0xAF, 0x3D, 0x50, 0x08, 0xDC, 0x0B, 0x1D, 0xE6, 0x17, 0x17, 0xA6, 0xA4, 0x64, 0xE5, 0xE7, 0xC4, 0x41, 0xE4, 0xEE, 0xEE, 0xAE, 0xA6, 0xBA, 0xF8, 0x84, 0xCC, 0x93, 0x45, 0x22, 0xD1, 0x70, 0xEF, 0x24, 0xD9, 0x4E, 0x1A,
  0x41, 0x77, 0x76, 0xBA, 0xBC, 0xEB, 0x67, 0x29, 0xAB, 0xE5, 0x17, 0xEE, 0xDC, 0x59, 0x9C, 0xE5, 0xDE, 0xBF, 0xAA, 0xF7, 0xAC, 0x78, 0x08, 0x12, 0x1E, 0x78, 0x99, 0x02, 0xC2, 0x9C, 0x0A,
  0x6C, 0x0A,
  0x04, 0x52, 0x04, 0x91, 0x7B, 0xB9, 0x50, 0x50, 0x0E, 0xFE, 0xD1, 0x09, 0x6F, 0x33, 0x66, 0xEB, 0x4F, 0xDD, 0xAD, 0x74, 0x0B, 0xCF, 0x7B, 0xB0, 0xB9, 0xE2, 0xE9, 0x81, 0x5D, 0xF7, 0xB7, 0x17, 0xA7, 0xE4, 0xC7, 0xCD, 0x0D, 0x07, 0x28, 0x41,
  0x23, 0xA7, 0x0A,
  0xF2, 0xF2, 0xF2, 0xB2, 0xF3, 0x08, 0xB6, 0xE8, 0x98, 0x43, 0x65, 0xB1, 0xBA, 0x49, 0x9D, 0x2C, 0x17, 0x48, 0x6A, 0x1E, 0x68, 0xB4, 0xF7, 0x8D, 0x1B, 0x92, 0x71, 0x07, 0x98, 0xBC, 0xB2, 0x7B, 0xE1, 0xAE, 0xA7, 0x4F, 0x1A, 0x1A, 0xF6, 0x44,
  0x7A, 0xC1, 0x57, 0x69, 0xE9, 0x8B, 0x87, 0x7A, 0x21, 0x15, 0x1B, 0x68, 0x41, 0x03, 0x0B, 0x5A, 0x5A, 0x20, 0x30, 0x02, 0x02, 0xAA, 0x4E, 0x14, 0x08, 0x05, 0xC2, 0xF2, 0x24, 0x21, 0xDD, 0x2B, 0x7B, 0xC7, 0xDD, 0xE9, 0xF0, 0x07, 0xCF, 0x76,
  0x81, 0xA8, 0xA7, 0x06, 0x0D, 0x2D, 0x00, 0x4C, 0xEF, 0xA7, 0x0D, 0xFE, 0xCD, 0x88, 0x47, 0x61, 0xB1, 0x58, 0x68, 0x1A, 0xCB, 0x45, 0x5E, 0xA1, 0xCF, 0xDB, 0x4F, 0xD4, 0xD9, 0x49, 0x0B, 0x06, 0x8C, 0x65, 0x83, 0xB5, 0x3D, 0x3C, 0x2C, 0x99,
  0x4C, 0x4B, 0x4B, 0x0F, 0x0F, 0x6D, 0xBD, 0x58, 0x0E, 0x14, 0xA9, 0x7B, 0xA7, 0x20, 0x84, 0x43, 0xE0, 0xB5, 0x49, 0x3C, 0x24, 0x6E, 0x32, 0x6B, 0x82, 0x86, 0x20, 0x34, 0x8E, 0x42, 0xC3, 0x70, 0x82, 0x24, 0xA0, 0xED, 0xC1, 0xD4, 0xC3, 0xFB,
  0x2F, 0x45, 0x3C, 0xBB, 0x0F, 0x4D, 0x9C, 0x7D, 0xE1, 0x49, 0x55, 0x0A,
  0x8B, 0xC4, 0xC2, 0xA1, 0xD1, 0xC1, 0x39, 0xDA, 0x54, 0x13, 0xE7, 0x4E, 0x9A, 0x4B, 0xB0, 0x8B, 0xA5, 0xB7, 0xB3, 0xB3, 0xB7, 0xC8, 0x1B, 0x10, 0x1A, 0x90, 0x9F, 0x6E, 0xEC, 0xF2, 0x29, 0x31, 0x0F, 0xF8, 0x74, 0x93, 0xD6, 0xD0, 0x50, 0x6F,
  0x2F, 0xD8, 0x5B, 0x86, 0x02, 0x9B, 0xC4, 0x40, 0xD7, 0x62, 0xB1, 0xD9, 0x8A, 0x75, 0xC6, 0xFC, 0x9F, 0x85, 0x42, 0x81, 0x40, 0x08, 0x30, 0xDE, 0x3B, 0x15, 0x92, 0x7E, 0xB2, 0xA1, 0xEC, 0x4B, 0xA7, 0x07, 0x50, 0x25, 0x87, 0x26, 0x91, 0xA8,
  0xDE, 0xD4, 0x60, 0x6D, 0xA6, 0xE5, 0x35, 0xE7, 0x60, 0x0A,
  0x95, 0x26, 0x19, 0x00, 0x80, 0x9E, 0xF3, 0xB8, 0xD1, 0x49, 0x72, 0xF6, 0xD6, 0x64, 0x08, 0xBE, 0x5F, 0xD5, 0x6B, 0x06, 0x6C, 0x0F, 0xC4, 0x1A, 0x31, 0x00, 0xD8, 0xDB, 0x04, 0x8D, 0x7D, 0x4C, 0x4D, 0x4D, 0x05, 0xAE, 0x5D, 0xB0, 0xB8, 0x27,
  0x71, 0x00, 0x00, 0x0D, 0xF8, 0x49, 0x44, 0x41, 0x54, 0xAB, 0x31, 0x31, 0x61, 0x93, 0x58, 0x0E, 0x7C, 0x86, 0x0E, 0xC9, 0x71, 0x36, 0xB5, 0x39, 0x24, 0x3D, 0x73, 0x73, 0x55, 0xE1, 0x17, 0xCD, 0xA8, 0xFB, 0xB4, 0x5D, 0xB4, 0xD9, 0x96, 0x68,
  0x67, 0xAA, 0xC8, 0x92, 0xAB, 0x29, 0xF2, 0x0B, 0xB1, 0xEC, 0xC4, 0x8D, 0xD0, 0x7A, 0xDA, 0x30, 0xB5, 0xB5, 0x8E, 0x7A, 0x41, 0x7A, 0xBA, 0xA6, 0x5C, 0x6E, 0x80, 0x63, 0x12, 0xC2, 0x46, 0x6C, 0x20, 0xE6, 0xF1, 0xA0, 0x87, 0x48, 0xCE, 0x4A,
  0x8C, 0x70, 0xAA, 0x29, 0x70, 0xED, 0xD4, 0x5A, 0x83, 0x40, 0x68, 0x04, 0xE2, 0xA8, 0x71, 0x02, 0x1F, 0x4A, 0x23, 0x04, 0x49, 0x8C, 0xE8, 0xA8, 0xD9, 0xD4, 0xAD, 0x21, 0x6E, 0x79, 0x7B, 0xF6, 0x7E, 0xC9, 0x54, 0x90, 0x06, 0x1C, 0x9A, 0x44,
  0xA3, 0x79, 0xDE, 0x6E, 0xD3, 0x14, 0x59, 0xA2, 0xC7, 0x68, 0x22, 0x1F, 0x8F, 0xEB, 0x2C, 0x9A, 0xA1, 0x3A, 0xD5, 0xC4, 0xC4, 0x84, 0xC9, 0xC4, 0xFA, 0x72, 0xF5, 0x82, 0x18, 0x8E, 0xA8, 0xEA, 0x44, 0x0E, 0x51, 0x4B, 0x2C, 0x79, 0xCC, 0x05,
  0x08, 0x73, 0x6A, 0x4A, 0x0B, 0x0A,
  0xE2, 0x2B, 0x38, 0xEF, 0x66, 0x20, 0x6C, 0x12, 0x12, 0x51, 0x28, 0x01, 0x50, 0xF7, 0xD5, 0x7D, 0xD1, 0x51, 0x31, 0xAD, 0x87, 0xF7, 0xD7, 0x68, 0x6B, 0xF7, 0xA9, 0x05, 0xDF, 0xE4, 0x7E, 0x19, 0x88, 0x40, 0xA9, 0xD7, 0x00, 0x75, 0xD2, 0x9C,
  0x81, 0x1D, 0x76, 0x02, 0xC0, 0xAC, 0xEE, 0xDB, 0x23, 0xDD, 0x34, 0x73, 0x70, 0x05, 0x5C, 0x42, 0xA3, 0x71, 0x38, 0x3F, 0xEA, 0x1A, 0xEC, 0x4F, 0xFF, 0x48, 0x98, 0xD0, 0x30, 0x03, 0xB0, 0xA6, 0x7A, 0xD7, 0x12, 0x57, 0x98, 0x89, 0xC5, 0x2B,
  0x78, 0xEF, 0xF1, 0xCD, 0x8D, 0x69, 0xD0, 0xCB, 0x41, 0xE1, 0x8A, 0xA2, 0x43, 0x33, 0x53, 0x33, 0xD9, 0xAE, 0x7F, 0x7B, 0x11, 0xAC, 0x6E, 0x39, 0x72, 0x4B, 0xF6, 0xCB, 0xC8, 0xF1, 0xC6, 0x1C, 0xC4, 0x1B, 0xD7, 0x7A, 0xFC, 0x7C, 0xF5, 0x56,
  0x3B, 0x2F, 0xC5, 0x04, 0x8D, 0x99, 0x9C, 0xEB, 0xC6, 0x75, 0x5E, 0x33, 0x87, 0x0C, 0xF2, 0xC6, 0xB5, 0x4E, 0x67, 0x67, 0x11, 0xF4, 0xB0, 0xCD, 0x38, 0xDD, 0x06, 0x1A, 0x1C, 0xE1, 0x70, 0xD6, 0x1D, 0xB5, 0xB1, 0x99, 0x98, 0x4F, 0xC6, 0xC6,
  0xD0, 0x64, 0x05, 0x4A, 0x08, 0x04, 0x29, 0xE8, 0xDF, 0xFD, 0xB8, 0xCF, 0xE5, 0x1B, 0x17, 0x97, 0x5B, 0x1E, 0xEA, 0xB7, 0x6E, 0xDD, 0xFC, 0x26, 0x78, 0x81, 0x26, 0x89, 0xC8, 0x19, 0x22, 0xEF, 0x6F, 0x16, 0xDF, 0x3F, 0xD1, 0xF4, 0xF5, 0xF5,
  0xB1, 0xA4, 0xF5, 0xF4, 0x00, 0x7D, 0xF7, 0x38, 0x83, 0x98, 0x43, 0x1D, 0x33, 0xE5, 0xAE, 0x39, 0x77, 0x0E, 0xF8, 0x8C, 0x21, 0xB7, 0xF6, 0x9F, 0xDF, 0x9B, 0xFA, 0x60, 0x30, 0x8E, 0x7A, 0x18, 0x53, 0x8C, 0xDE, 0x3F, 0xF9, 0x89, 0x10, 0xC8,
  0xA3, 0x1F, 0x9E, 0x17, 0xFA, 0x80, 0xD0, 0x58, 0x22, 0x46, 0x38, 0x2A, 0xC8, 0xB1, 0x0B, 0xAF, 0xA9, 0xA9, 0x49, 0x69, 0xA7, 0x2C, 0xB5, 0x5C, 0xDA, 0x86, 0x67, 0x8B, 0x44, 0xA2, 0xAF, 0x45, 0x20, 0x30, 0x50, 0x45, 0x2E, 0x73, 0x91, 0x3A,
  0xD8, 0x05, 0x04, 0x89, 0xA5, 0x22, 0xD1, 0xD2, 0xA5, 0x63, 0x63, 0x63, 0xDE, 0x2E, 0x8B, 0x85, 0xC8, 0xC2, 0x31, 0x9D, 0x7B, 0x58, 0x9E, 0x40, 0x90, 0x3D, 0x7E, 0xA2, 0xA5, 0x22, 0x67, 0x1A, 0x7A, 0x0C, 0xDF, 0x76, 0xE6, 0xCC, 0x19, 0x1C,
  0xED, 0xDA, 0xCA, 0x2E, 0x0C, 0x06, 0xA3, 0xC7, 0x15, 0x8D, 0x90, 0x7A, 0x0C, 0x0D, 0x41, 0xD1, 0x6C, 0x6E, 0xB8, 0x52, 0x04, 0x95, 0x79, 0xC0, 0x3F, 0x00, 0x58, 0x49, 0xC1, 0x37, 0x07, 0x11, 0x42, 0x18, 0x80, 0x87, 0x1E, 0x6E, 0x62, 0xFB,
  0xB2, 0xD9, 0x14, 0x4D, 0x0A,
  0x85, 0x8D, 0x67, 0x53, 0xC6, 0xC0, 0x97, 0x26, 0x97, 0x02, 0x48, 0x34, 0x06, 0xD0, 0x8A, 0xA8, 0x22, 0x67, 0xD1, 0xD2, 0x31, 0x91, 0xE5, 0xF8, 0x18, 0x9B, 0x6D, 0xC3, 0xC6, 0xAF, 0x1E, 0x93, 0xCC, 0xED, 0xC0, 0x3E, 0xDF, 0xE7, 0xF1, 0xF4,
  0x44, 0x93, 0x58, 0x3D, 0x24, 0xAC, 0x0E, 0x3B, 0x40, 0xE8, 0xC3, 0xC4, 0x8E, 0x9B, 0x62, 0xBE, 0x6A, 0xF7, 0xB1, 0xEB, 0xE8, 0xE8, 0xA0, 0x92, 0xAE, 0xAD, 0x74, 0xC4, 0xB0, 0x71, 0x2C, 0x34, 0x9A, 0x06, 0x10, 0x1A, 0x7A, 0x8C, 0x8F, 0xEB,
  0xC2, 0xF9, 0x40, 0xDD, 0xC6, 0x90, 0xF1, 0xD9, 0xCC, 0x09, 0xD2, 0x18, 0x94, 0x7E, 0x77, 0xF4, 0x30, 0x8E, 0x01, 0x5D, 0x3E, 0x6C, 0x00, 0x4F, 0x93, 0xD2, 0xA6, 0xE9, 0x83, 0xD7, 0xA4, 0xF8, 0x04, 0x60, 0xBA, 0xBA, 0xD8, 0x01, 0x14, 0x36,
  0x86, 0x11, 0x10, 0xD0, 0x45, 0xA1, 0x68, 0x72, 0x35, 0x81, 0xAD, 0x68, 0xAE, 0x66, 0xAF, 0xD6, 0x1C, 0x6B, 0x0F, 0x60, 0x3B, 0x76, 0x0D, 0xBA, 0x60, 0x08, 0x6C, 0x17, 0x90, 0x02, 0xA8, 0xAA, 0x42, 0x3B, 0xA4, 0xC2, 0x1F, 0x6E, 0xD7, 0x4C,
  0x26, 0x9A, 0x45, 0x62, 0x5A, 0x9A, 0x98, 0x72, 0x31, 0x6D, 0x4C, 0x2A, 0x08, 0xD4, 0xDE, 0x54, 0x2A, 0xD5, 0x0E, 0xC2, 0x08, 0x90, 0xD9, 0x61, 0x98, 0x26, 0x54, 0x60, 0x97, 0x86, 0x86, 0x1E, 0xB5, 0x28, 0xCC, 0x38, 0x90, 0x29, 0x0A,
  0x45, 0x4F, 0xB0, 0x81, 0x6C, 0x2F, 0x31, 0x21, 0xC1, 0x91, 0xCE, 0x5F, 0x66, 0x6D, 0xCF, 0xB0, 0x1F, 0xE7, 0xFA, 0xE0, 0x03, 0xD8, 0x90, 0xF8, 0xF0, 0x63, 0xEC, 0x2E, 0x0A,
  0x06, 0xC3, 0xD6, 0xE4, 0xD3, 0xF9, 0xF4, 0x20, 0x94, 0x63, 0x90, 0x80, 0xCF, 0xE8, 0xC2, 0xB3, 0xF1, 0xA3, 0x8E, 0xE0, 0xD7, 0x78, 0xF6, 0x28, 0x7B, 0x54, 0x87, 0xCD, 0xD5, 0xD1, 0x06, 0xBB, 0xB5, 0x82, 0x92, 0xAA, 0x7B, 0x70, 0x71, 0xEE,
  0xAE, 0x03, 0x91, 0x91, 0x65, 0xBB, 0xB6, 0xA7, 0xC4, 0xA9, 0x2A, 0xFE, 0x7E, 0x20, 0xF5, 0xC4, 0x32, 0x59, 0xBE, 0x5C, 0x0A,
  0x95, 0x35, 0xC2, 0x82, 0xC8, 0x93, 0x04, 0x4D, 0xF1, 0x5C, 0xB7, 0xF3, 0x21, 0x77, 0x90, 0xD1, 0xB4, 0x11, 0xAC, 0x2F, 0x56, 0x44, 0xEB, 0xEC, 0xF4, 0xD3, 0x5B, 0x6F, 0xCA, 0xD5, 0x0D, 0xB2, 0x3E, 0x6D, 0x71, 0x47, 0xA7, 0x0B, 0x88, 0x4C,
  0x2F, 0x40, 0xCF, 0x11, 0x88, 0x07, 0xCF, 0xC5, 0xD3, 0x2D, 0x74, 0xEC, 0x2D, 0x7D, 0xDB, 0x7C, 0x30, 0x00, 0xC3, 0x6A, 0x36, 0x40, 0x42, 0xEF, 0x72, 0x0C, 0x62, 0xEB, 0x0C, 0x66, 0x40, 0x01, 0xD2, 0x36, 0x3D, 0xBD, 0xAF, 0x9F, 0x4F, 0xC7,
  0x8F, 0x69, 0x3A, 0xD2, 0xE9, 0xFC, 0xD1, 0xA0, 0x44, 0xB6, 0x35, 0x3B, 0x18, 0x2A, 0xAF, 0xB2, 0x52, 0x8A, 0x73, 0xAB, 0x9E, 0x35, 0x44, 0xBC, 0xAE, 0x71, 0x7B, 0x01, 0x2A, 0xD6, 0xBC, 0xE4, 0xC8, 0xDC, 0x7C, 0x95, 0xDF, 0x7D, 0x36, 0xD6,
  0xC7, 0x1B, 0x40, 0x22, 0xDB, 0x8D, 0x7B, 0xE0, 0x58, 0x46, 0xD0, 0x73, 0x6A, 0x9E, 0xE0, 0xC5, 0x93, 0xD5, 0x61, 0xB7, 0x9E, 0x49, 0x66, 0x92, 0x8C, 0xBA, 0xED, 0x2C, 0x69, 0x34, 0x9A, 0xBA, 0xAE, 0x29, 0x20, 0xBD, 0xEF, 0x09, 0xA7, 0x1D,
  0x2C, 0xD6, 0xEB, 0x61, 0x30, 0xDC, 0x2E, 0x47, 0x7A, 0x50, 0x50, 0x40, 0x17, 0x9B, 0xCB, 0x60, 0x3B, 0x5A, 0x13, 0xEC, 0x7D, 0x7C, 0x7C, 0xB8, 0x00, 0xDC, 0x68, 0x97, 0x80, 0xA2, 0xA9, 0xB7, 0xDE, 0x4B, 0xF2, 0x8C, 0x58, 0xC1, 0xCC, 0xC5,
  0xFA, 0x46, 0x57, 0xD7, 0xC6, 0x1F, 0xE4, 0x06, 0xF9, 0x0C, 0xC2, 0xEA, 0xF3, 0x2E, 0x3F, 0xB8, 0xFA, 0x0F, 0xEC, 0x9F, 0x0E, 0x03, 0xE9, 0x6C, 0xC4, 0x96, 0x2D, 0x11, 0x79, 0xAF, 0x2F, 0xA5, 0xEF, 0x1F, 0xF0, 0x6F, 0x76, 0x05, 0x99, 0xA5,
  0xFF, 0xE4, 0x74, 0x78, 0xF2, 0x81, 0x42, 0xB5, 0xDF, 0xC3, 0xE8, 0x33, 0x72, 0x7B, 0xCD, 0x88, 0xAE, 0xCF, 0x1A, 0x16, 0xCB, 0x8F, 0x8C, 0xF5, 0xD1, 0x5D, 0xEF, 0xE3, 0x8B, 0xC5, 0xDA, 0xD9, 0xD9, 0x99, 0xD6, 0xA2, 0x4C, 0xB1, 0x5F, 0x7B,
  0xDA, 0xF9, 0xA0, 0x49, 0xCE, 0x3E, 0x7A, 0xBA, 0xEB, 0x75, 0xD7, 0x8F, 0x8F, 0xB7, 0x8B, 0x56, 0xAE, 0x34, 0xF2, 0x53, 0x07, 0xDB, 0x90, 0xA3, 0x23, 0xB7, 0x4B, 0x2F, 0x88, 0x0E, 0x3C, 0xA4, 0x8B, 0xAD, 0x47, 0x77, 0xC4, 0xE3, 0x29, 0xB5,
  0xA3, 0xA3, 0x41, 0x70, 0xFA, 0x3F, 0x05, 0xFD, 0x92, 0x3A, 0x6B, 0xF7, 0x86, 0x97, 0xFB, 0xDE, 0x42, 0x13, 0xAF, 0x51, 0x51, 0x56, 0x56, 0x17, 0xBE, 0xF5, 0x1A, 0x5C, 0xCF, 0x75, 0x64, 0x8F, 0xFD, 0xF8, 0xFF, 0xDA, 0xB9, 0xDA, 0x98, 0xA6,
  0xD2, 0x2C, 0xBC, 0x8C, 0x42, 0x4B, 0xA1, 0x40, 0x4B, 0xC6, 0x4C, 0x64, 0x1B, 0x42, 0x33, 0xED, 0x6D, 0xFC, 0x01, 0x99, 0x4D, 0xBA, 0xA9, 0xC9, 0x10, 0xBC, 0xA1, 0x42, 0x4A, 0x4D, 0x29, 0x5E, 0x8C, 0x8D, 0x09, 0x1A, 0x17, 0x90, 0xB6, 0x40,
  0x95, 0xB2, 0xC5, 0x58, 0x28, 0x14, 0xBA, 0x7C, 0x84, 0xCC, 0x50, 0xAA, 0xB4, 0x04, 0x2B, 0x50, 0x50, 0x3E, 0x0A,
  0x0C, 0x21, 0x45, 0x51, 0x9A, 0xAD, 0x74, 0x25, 0x90, 0x54, 0x10, 0x21, 0xFE, 0x20, 0x4D, 0x26, 0x8B, 0x59, 0x8D, 0x51, 0x40, 0x18, 0x14, 0x1B, 0x30, 0x9D, 0x9D, 0x3D, 0xEF, 0xA5, 0x8C, 0x93, 0x51, 0x0C, 0xB3, 0x43, 0x36, 0xD9, 0xC4, 0xF3,
  0x07, 0x4A, 0x08, 0x3C, 0xF7, 0x39, 0xE7, 0x3D, 0xDF, 0xEF, 0xED, 0xBB, 0x3B, 0x9A, 0xEC, 0x80, 0x54, 0x77, 0x76, 0xF6, 0xA9, 0x29, 0xEB, 0xCE, 0x50, 0x7F, 0x9F, 0x6F, 0xA4, 0xA0, 0x60, 0x64, 0xE6, 0xDC, 0x50, 0x56, 0x5B, 0x97, 0xB6, 0xB9,
  0x34, 0x62, 0x87, 0x80, 0xE4, 0x12, 0x63, 0x18, 0x37, 0x13, 0x3F, 0x8B, 0x11, 0x04, 0x4F, 0x3C, 0x19, 0xC7, 0xE6, 0xE1, 0x38, 0xB9, 0x0C, 0x35, 0x36, 0x86, 0x4B, 0x9D, 0xB2, 0xB1, 0x54, 0xF7, 0x81, 0x68, 0x19, 0x1B, 0xDD, 0xD2, 0x03, 0x2B,
  0xF0, 0x06, 0x04, 0xEC, 0x61, 0x92, 0x2D, 0x4B, 0x63, 0x25, 0x1E, 0x3A, 0xC1, 0xBA, 0x77, 0x22, 0x51, 0x95, 0x78, 0x26, 0xD1, 0x4E, 0xFF, 0x09, 0x8A, 0xFD, 0x0C, 0xBA, 0x24, 0xB0, 0xC0, 0x81, 0xAA, 0x04, 0xCB, 0xF2, 0x69, 0x10, 0xCB, 0x1B,
  0x72, 0x5D, 0xFC, 0x74, 0xEC, 0x99, 0xC7, 0x8F, 0xBF, 0x04, 0xD4, 0x50, 0x30, 0x80, 0xF8, 0xCC, 0x05, 0xBA, 0xFC, 0x0A,
  0xA8, 0xC1, 0xF2, 0x0B, 0x7C, 0x7D, 0xA3, 0x0F, 0x9F, 0xA5, 0x28, 0x5E, 0xB5, 0x88, 0x76, 0xA0, 0x31, 0x73, 0x72, 0x9C, 0x2B, 0x20, 0xBC, 0xEC, 0x83, 0x18, 0x97, 0x33, 0x46, 0xA4, 0xC2, 0x3F, 0x8F, 0x13, 0xBB, 0x26, 0x5C, 0x5C, 0xE9, 0x93,
  0x27, 0x52, 0xF6, 0xE1, 0xC3, 0xE3, 0x3C, 0x9E, 0xD3, 0x5E, 0xC9, 0x3A, 0xC5, 0x25, 0x48, 0xE8, 0x38, 0x41, 0x7E, 0x15, 0x0A,
  0xE1, 0xBB, 0xAF, 0x79, 0x6C, 0x99, 0x93, 0xA1, 0x3A, 0x44, 0xA7, 0x50, 0x18, 0x64, 0x2B, 0x56, 0xC5, 0x60, 0x5C, 0xDC, 0xAE, 0xB6, 0x50, 0x2D, 0xD3, 0x93, 0xBB, 0x52, 0x64, 0xB1, 0x90, 0x3D, 0xA7, 0x62, 0xBF, 0xDF, 0x5F, 0x3C, 0x97, 0x1D,
  0x7B, 0xEF, 0xCB, 0xB7, 0xA8, 0x47, 0x76, 0x1F, 0x84, 0xAC, 0xBE, 0x46, 0x7C, 0x86, 0xFE, 0x21, 0xC7, 0xAD, 0x67, 0xE5, 0xA0, 0xE9, 0xA6, 0x9D, 0x34, 0x3D, 0xE9, 0xC5, 0xB9, 0x4E, 0x01, 0x31, 0xCE, 0x5E, 0xC0, 0x30, 0xC2, 0xE5, 0x5A, 0xE0,
  0x08, 0xBD, 0x99, 0xE2, 0x38, 0xDE, 0xC9, 0x79, 0x20, 0x0B, 0xB7, 0x4B, 0xA3, 0xBD, 0x2C, 0x0C, 0x1F, 0x93, 0xB1, 0xBF, 0xFA, 0x1E, 0xB3, 0xC7, 0x62, 0x98, 0xD3, 0xE9, 0x4C, 0xE3, 0x72, 0x09, 0xB4, 0xBD, 0x47, 0x10, 0x1C, 0xA1, 0x50, 0xC8,
  0x93, 0x71, 0x29, 0x14, 0x3A, 0x95, 0x42, 0xA7, 0x30, 0x4A, 0x4A, 0x32, 0xA8, 0xAA, 0xB9, 0x77, 0x10, 0x7B, 0x56, 0xD0, 0x46, 0x32, 0x2A, 0x67, 0x02, 0xBC, 0xE9, 0x2A, 0x7A, 0x3D, 0xF7, 0x1E, 0xBF, 0x7C, 0x79, 0xFA, 0x74, 0xB1, 0xFF, 0x7E,
  0x02, 0xD0, 0x67, 0x40, 0x6B, 0xDF, 0x37, 0x17, 0x53, 0x36, 0xA0, 0x68, 0x6D, 0x6E, 0x52, 0xEF, 0x54, 0x6D, 0xC5, 0xE1, 0x18, 0x57, 0x80, 0xDE, 0x3D, 0x21, 0x66, 0x73, 0x31, 0xA9, 0x70, 0x9E, 0xB7, 0x20, 0xE4, 0xCC, 0x7B, 0x33, 0xD9, 0xDE,
  0x05, 0xF1, 0x7C, 0xB6, 0xFD, 0xAC, 0xC0, 0xCD, 0x16, 0xB0, 0x9C, 0x00, 0x89, 0x13, 0x2D, 0xFB, 0x8A, 0xFD, 0xBD, 0xF4, 0x04, 0x76, 0xE8, 0x50, 0xEC, 0x89, 0x7B, 0xB1, 0xC8, 0x53, 0x9F, 0xA1, 0xA3, 0x0D, 0xA1, 0x33, 0x27, 0xED, 0x74, 0x3A,
  0xE3, 0x32, 0xDA, 0x92, 0xCA, 0xB8, 0x71, 0xE3, 0x4F, 0x5B, 0x34, 0x46, 0x26, 0xF5, 0xAC, 0x58, 0x8A, 0x7B, 0xF3, 0xCD, 0xD3, 0x65, 0x8D, 0xD5, 0x50, 0xCE, 0xE4, 0xE4, 0x3C, 0x35, 0x55, 0x27, 0x97, 0x19, 0x7C, 0x05, 0x15, 0x09, 0x48, 0xF2,
  0x91, 0x05, 0x3A, 0x9E, 0x5E, 0x5F, 0x97, 0x2B, 0xB4, 0xED, 0xCA, 0x8E, 0x17, 0x2D, 0xA5, 0xEA, 0x88, 0x1D, 0xDD, 0x0E, 0xFB, 0x60, 0xA5, 0x4A, 0x00, 0x18, 0x09, 0x9E, 0x8C, 0xCD, 0x7D, 0x62, 0xC7, 0x38, 0xE3, 0xBC, 0xD4, 0x54, 0x8E, 0x70,
  0x7E, 0x5C, 0xEC, 0x95, 0xB2, 0x58, 0x76, 0x20, 0x98, 0xED, 0xC5, 0x30, 0x29, 0x17, 0x9C, 0x10, 0x81, 0x0B, 0x79, 0x6C, 0x76, 0xFC, 0xA9, 0xD8, 0xC4, 0x58, 0x56, 0xEC, 0xD9, 0xB3, 0x19, 0x89, 0xC7, 0xAF, 0xA8, 0x32, 0x32, 0x32, 0x4A, 0x4A,
  0xC8, 0x25, 0x2E, 0x04, 0x91, 0x72, 0xA1, 0xD2, 0x83, 0x20, 0xA2, 0x9D, 0xEE, 0xCE, 0x5E, 0xDD, 0xF9, 0x32, 0x07, 0x54, 0x33, 0x1B, 0x7A, 0x28, 0xFD, 0x96, 0x14, 0x75, 0xF2, 0x14, 0x7E, 0xCE, 0x40, 0xF2, 0x77, 0x86, 0x3E, 0xA8, 0xAA, 0xEF,
  0x82, 0x76, 0x6F, 0xAE, 0xCB, 0x81, 0x3C, 0x63, 0xA0, 0x8C, 0xF8, 0x48, 0x83, 0x07, 0x77, 0x9F, 0x74, 0x8E, 0xB9, 0xB8, 0x80, 0x51, 0xC8, 0x89, 0x26, 0x9C, 0x52, 0xD0, 0x24, 0x0F, 0x40, 0xA6, 0x12, 0xC2, 0x79, 0x99, 0x37, 0x3B, 0x16, 0xE3,
  0x3A, 0xC1, 0x50, 0x05, 0xC1, 0x92, 0x6C, 0x01, 0x8E, 0x84, 0x10, 0xF2, 0xBC, 0x5E, 0x6C, 0x0A,
  0x04, 0xB0, 0x04, 0x67, 0x5F, 0xB9, 0x92, 0xF1, 0x33, 0xC0, 0xBF, 0x96, 0xA8, 0xAE, 0x52, 0xA9, 0xC7, 0xD1, 0x62, 0x7C, 0x52, 0x4F, 0xD1, 0xDB, 0x84, 0x11, 0x32, 0x09, 0xD7, 0xAE, 0x59, 0x5B, 0xA0, 0xF4, 0xAB, 0x2F, 0x6D, 0xB1, 0x29, 0x35,
  0x8A, 0x0D, 0xE4, 0x69, 0x1E, 0x3A, 0x1C, 0xA8, 0x9D, 0xFC, 0xA0, 0x6E, 0x15, 0xB4, 0x1B, 0x15, 0x78, 0x2F, 0xCB, 0x47, 0x62, 0x60, 0x5A, 0x7A, 0xCC, 0x02, 0xCE, 0xC2, 0x90, 0x7D, 0x09, 0x9C, 0x4E, 0xE9, 0xD8, 0xC4, 0x04, 0x2E, 0x95, 0x7E,
  0x8D, 0x50, 0x72, 0x38, 0x0B, 0x32, 0xDC, 0x0E, 0x3F, 0x06, 0x43, 0xC5, 0xD1, 0x36, 0x18, 0xDA, 0x22, 0x04, 0x90, 0x1C, 0x9E, 0x58, 0x86, 0xF6, 0xD5, 0x90, 0x48, 0x18, 0x10, 0x13, 0x4B, 0xB6, 0x11, 0xD2, 0x19, 0x95, 0x17, 0x6E, 0xCC, 0x05,
  0x23, 0x12, 0x97, 0x0B, 0x75, 0x86, 0x3B, 0xCF, 0xF2, 0x14, 0xCA, 0x96, 0x9A, 0x28, 0x54, 0x68, 0x85, 0x84, 0xD2, 0xA0, 0xA0, 0x6C, 0xE9, 0x68, 0xD5, 0xD6, 0x6D, 0xA4, 0x2C, 0xF2, 0xDB, 0xDA, 0xD0, 0x7D, 0xF9, 0x76, 0x6B, 0x29, 0x73, 0x17,
  0x2F, 0x33, 0xE0, 0xBA, 0xFF, 0x71, 0x4C, 0xC6, 0x62, 0xC5, 0x72, 0xB9, 0x18, 0x76, 0x90, 0x98, 0x98, 0x80, 0x23, 0x2D, 0x5E, 0x88, 0xB7, 0xDB, 0x3F, 0x4F, 0x8D, 0x39, 0x92, 0x0E, 0x9C, 0x11, 0x88, 0xE0, 0x71, 0x2F, 0x6F, 0xEB, 0x18, 0xCC,
  0x49, 0x11, 0x4C, 0x22, 0xF5, 0x30, 0xCF, 0x13, 0x68, 0x93, 0xD8, 0xD1, 0x61, 0xA6, 0x57, 0xAA, 0x54, 0x74, 0xD4, 0x0A,
  0x65, 0x5C, 0xA4, 0x56, 0x7A, 0x3E, 0x8B, 0xBC, 0xB6, 0xD2, 0xD9, 0x3B, 0xD2, 0x3F, 0xC0, 0xBF, 0xDD, 0xFE, 0xEE, 0x9A, 0x42, 0xD0, 0xBE, 0xFD, 0x21, 0x61, 0x11, 0xEA, 0xD2, 0xDA, 0xEE, 0x76, 0x6D, 0xDD, 0xE6, 0xC6, 0x86, 0x5C, 0xBF, 0xD4,
  0x6E, 0x85, 0x0A,
  0x62, 0x17, 0x10, 0xF1, 0xF4, 0x63, 0xC7, 0x38, 0x2C, 0x3B, 0xEB, 0xD4, 0x41, 0xCC, 0x35, 0x91, 0x79, 0x78, 0x72, 0x32, 0xEE, 0x80, 0x84, 0x24, 0xE8, 0x8F, 0x18, 0x84, 0xEF, 0x05, 0x21, 0x0F, 0x27, 0x0D, 0x35, 0x3A, 0xD0, 0xBA, 0x89, 0x8C,
  0xCC, 0x3E, 0x49, 0x8C, 0xE1, 0xA9, 0x99, 0xDC, 0xC0, 0x47, 0x3B, 0x3A, 0xD0, 0xE0, 0x72, 0xE8, 0x14, 0x2A, 0xDA, 0x7E, 0xA4, 0x5F, 0xF8, 0x33, 0x79, 0x7F, 0xBF, 0xF0, 0x87, 0xE7, 0xD5, 0xFC, 0xDB, 0xAD, 0xC6, 0x5F, 0x6E, 0xAB, 0xA0, 0xEE,
  0x01, 0x49, 0xA6, 0x55, 0xD9, 0xAE, 0x19, 0xD4, 0xB4, 0x76, 0xD7, 0x56, 0xED, 0x86, 0x45, 0xC2, 0x35, 0x96, 0x7E, 0x84, 0x9D, 0x0D, 0x39, 0x21, 0x3E, 0x21, 0x16, 0xC7, 0xC5, 0xC5, 0x39, 0x93, 0x3E, 0x0B, 0xDE, 0x16, 0x89, 0x3D, 0x36, 0x6D,
  0xC1, 0xE5, 0x22, 0xB8, 0x1C, 0xDE, 0x91, 0x85, 0x77, 0xEE, 0x2E, 0x57, 0xE2, 0xC4, 0x71, 0x9E, 0x30, 0x32, 0x92, 0xEC, 0x34, 0x4D, 0xD1, 0x01, 0x1A, 0xE5, 0x06, 0xF5, 0x32, 0xE5, 0x0A,
  0xE3, 0x2A, 0x5D, 0x45, 0xFD, 0x71, 0x0E, 0x14, 0x6D, 0xF1, 0xE7, 0x4F, 0x27, 0x0F, 0x77, 0x0D, 0xDA, 0x6A, 0x7E, 0x45, 0x13, 0x90, 0x19, 0x1A, 0xCE, 0xAC, 0x29, 0x6D, 0x32, 0x1A, 0x5B, 0x1A, 0x6A, 0x76, 0x55, 0x86, 0xFD, 0x85, 0x70, 0x71,
  0x8E, 0x1C, 0x13, 0x00, 0xC2, 0x4C, 0x88, 0x2D, 0xA9, 0x31, 0x62, 0x76, 0xD2, 0x76, 0xBF, 0x30, 0x20, 0x53, 0x07, 0x9D, 0xC4, 0x49, 0x77, 0xFA, 0x91, 0x2F, 0x02, 0xCE, 0xCE, 0x02, 0x8E, 0xED, 0xA5, 0xC5, 0x03, 0xC7, 0xCB, 0x03, 0xCE, 0xD9,
  0x72, 0xDA, 0x9F, 0xF0, 0x13, 0xE8, 0xF8, 0xDF, 0x54, 0x0A,
  0xE3, 0xEA, 0xDF, 0x2A, 0x19, 0xAA, 0x8B, 0x54, 0x95, 0x07, 0x1D, 0x97, 0x6F, 0xCC, 0xA3, 0xA6, 0xF2, 0xBA, 0xB5, 0xA6, 0xF7, 0xB7, 0x09, 0x91, 0xCA, 0x69, 0x28, 0x0F, 0x83, 0x2C, 0x6C, 0x57, 0x8D, 0x5A, 0xCF, 0x98, 0x2B, 0xE6, 0x98, 0x20,
  0x7B, 0x61, 0x92, 0xFD, 0x2F, 0xCF, 0xD1, 0x54, 0x77, 0xCC, 0x64, 0x60, 0xAF, 0x31, 0xC0, 0x19, 0x90, 0x26, 0xF9, 0x3C, 0x3E, 0xFE, 0xA8, 0x3B, 0xFD, 0x40, 0x64, 0xE4, 0xB7, 0xA8, 0x77, 0x03, 0x5E, 0x37, 0x1F, 0x8D, 0x56, 0x1E, 0x11, 0x38,
  0x84, 0x38, 0x7F, 0x42, 0xC1, 0x4C, 0x30, 0x03, 0x0D, 0xDD, 0xA8, 0x37, 0x2A, 0x91, 0xA8, 0x2A, 0xE9, 0xF7, 0x10, 0x8D, 0x85, 0xBA, 0xE9, 0x3B, 0xC3, 0x5D, 0x5A, 0xEB, 0x07, 0x57, 0x90, 0xB6, 0xFA, 0x59, 0xBB, 0xEE, 0x99, 0x48, 0x5D, 0xA9,
  0x87, 0x9D, 0xBC, 0xF8, 0x02, 0xF9, 0xCD, 0x3B, 0x06, 0x49, 0x1A, 0x27, 0x86, 0xFD, 0x28, 0xB0, 0x29, 0x89, 0xDA, 0x71, 0x16, 0x14, 0xBE, 0x24, 0x47, 0x89, 0xB4, 0xF8, 0xF4, 0xF4, 0x47, 0x00, 0xF7, 0xCD, 0xDB, 0xFB, 0xF9, 0xFF, 0xEC, 0x3B,
  0xF7, 0xFC, 0xB9, 0x61, 0xDA, 0x5C, 0x90, 0x8F, 0x9C, 0x30, 0x24, 0x07, 0x8E, 0x5B, 0x12, 0x06, 0x1A, 0x28, 0x50, 0x54, 0x2A, 0xD5, 0x65, 0x74, 0x70, 0x1E, 0x25, 0x5D, 0x2B, 0xEA, 0x4C, 0x30, 0x97, 0x91, 0x07, 0x46, 0x44, 0xFB, 0xFD, 0x65,
  0x16, 0xC1, 0x1B, 0x9F, 0x12, 0xD5, 0xBE, 0x96, 0x5F, 0x77, 0x18, 0x74, 0xFE, 0x13, 0x6E, 0x36, 0x4E, 0xAE, 0x5E, 0x42, 0x26, 0x60, 0xE9, 0x2C, 0xAC, 0xD0, 0x41, 0xF8, 0xF2, 0x05, 0x1F, 0x25, 0x80, 0xC6, 0x2F, 0x20, 0x21, 0x58, 0x2E, 0x4E,
  0x28, 0xE8, 0x83, 0xBC, 0xCA, 0x64, 0x32, 0x55, 0x37, 0x96, 0x81, 0x1B, 0x9E, 0x41, 0x9F, 0x9E, 0xF1, 0x25, 0x0C, 0x15, 0x9D, 0x72, 0x01, 0xD4, 0xAC, 0x02, 0x1E, 0x29, 0xC7, 0x23, 0x93, 0x72, 0xDF, 0x14, 0x57, 0x9C, 0x1F, 0x7A, 0xBA, 0xAE,
  0x50, 0x36, 0x44, 0x84, 0xFE, 0xEE, 0x01, 0x10, 0x97, 0x87, 0xD1, 0x44, 0xC6, 0xF6, 0xCD, 0xB6, 0x6A, 0x83, 0xAE, 0x70, 0x79, 0xCE, 0x1D, 0x8D, 0x0E, 0x2A, 0xE8, 0xF4, 0xA5, 0xBF, 0xC2, 0x7C, 0xAE, 0xB1, 0x1A, 0xD0, 0x0C, 0x24, 0x1F, 0xFD,
  0xBB, 0xDB, 0xFD, 0xA8, 0xD7, 0x0F, 0x09, 0x41, 0x82, 0x6E, 0x86, 0xDC, 0x1D, 0xCF, 0xCB, 0x2B, 0x47, 0x33, 0xB5, 0xE4, 0x46, 0x34, 0xE9, 0x59, 0xCC, 0x93, 0x40, 0x14, 0xA4, 0x50, 0x7F, 0x84, 0x70, 0x03, 0x0E, 0x88, 0x31, 0xB7, 0xED, 0x1A,
  0xE1, 0xC4, 0x58, 0x77, 0xBB, 0x6D, 0xF6, 0x31, 0x16, 0x9D, 0xFB, 0x42, 0x23, 0x9A, 0xD6, 0xEA, 0x16, 0x07, 0xCA, 0xCC, 0x09, 0x9D, 0x45, 0x73, 0x69, 0xD7, 0xAE, 0xE5, 0x22, 0x15, 0xDF, 0xCF, 0x9F, 0x19, 0xCD, 0x1A, 0x5E, 0xDF, 0xD0, 0xEB,
  0xE5, 0x79, 0x9E, 0x78, 0x37, 0x77, 0xD4, 0xE0, 0xD3, 0x41, 0x88, 0xCD, 0x37, 0x9F, 0x73, 0xE4, 0xAC, 0xDF, 0x5E, 0xD2, 0x68, 0xB4, 0x28, 0xA8, 0x0D, 0xE7, 0xCC, 0xE6, 0x0C, 0xF3, 0xF3, 0xE4, 0x09, 0x74, 0xC6, 0x15, 0x8A, 0xEA, 0x62, 0x25,
  0x14, 0x04, 0x17, 0x19, 0x53, 0xE4, 0x56, 0x38, 0xA9, 0x6A, 0xFD, 0x5E, 0xA8, 0xDA, 0x83, 0xAE, 0xFD, 0x57, 0x75, 0x2C, 0xE5, 0xE5, 0x34, 0x4E, 0xE7, 0x17, 0x76, 0x2E, 0x5B, 0x96, 0xC1, 0x00, 0x0B, 0xEF, 0x27, 0xE8, 0x7C, 0x77, 0x1D, 0xC3,
  0x79, 0x8A, 0xF6, 0x66, 0x9B, 0xB5, 0xDB, 0xE3, 0x16, 0x3C, 0xE0, 0xE7, 0x54, 0x8F, 0x4E, 0x9B, 0x75, 0xBA, 0x91, 0xBE, 0x21, 0xD3, 0xA2, 0x7E, 0xB5, 0xB9, 0xD6, 0x58, 0xDB, 0x8C, 0xA2, 0x45, 0xDE, 0xFA, 0x7A, 0x4A, 0x97, 0xFE, 0x92, 0x76,
  0x8A, 0xC1, 0x50, 0x25, 0x46, 0x4E, 0xEB, 0x0A,
  0x5F, 0x16, 0xF5, 0x24, 0x25, 0xC1, 0x89, 0x21, 0x55, 0x9D, 0xB2, 0x37, 0xAA, 0x0E, 0xDA, 0x47, 0x13, 0xB5, 0xB4, 0xEA, 0x17, 0x4D, 0xA3, 0xE7, 0x75, 0x90, 0x67, 0x6E, 0xE5, 0x4F, 0x60, 0x65, 0x8D, 0x59, 0x6D, 0xF2, 0xC1, 0x8E, 0x06, 0x35,
  0x93, 0x09, 0x51, 0x41, 0xA9, 0xD1, 0xA7, 0x0C, 0x03, 0x48, 0x9F, 0x79, 0xA6, 0xBF, 0xFA, 0xFA, 0xC6, 0xA0, 0xB5, 0x4A, 0x14, 0xC1, 0xAC, 0x69, 0xB0, 0x29, 0x57, 0xB5, 0x90, 0xEB, 0x0F, 0xB6, 0x2A, 0x9B, 0x95, 0xAB, 0x75, 0x29, 0x39, 0x77,
  0x0C, 0x3F, 0xF4, 0x76, 0x16, 0xF5, 0x7C, 0x9B, 0x74, 0x6D, 0x65, 0xB9, 0xB0, 0xC0, 0xE0, 0x18, 0xDE, 0x78, 0xDF, 0x39, 0xFE, 0x57, 0x18, 0x43, 0xC2, 0xEB, 0x6D, 0x83, 0xF2, 0xB6, 0x81, 0xA1, 0x73, 0xD3, 0xD3, 0xCF, 0x47, 0xD1, 0x55, 0x45,
  0x14, 0xED, 0xB3, 0x66, 0xF9, 0x00, 0xB1, 0x0A,
  0x42, 0x7D, 0x48, 0x68, 0xB8, 0xA8, 0xA1, 0x43, 0xB3, 0xC9, 0x37, 0x25, 0x3F, 0xEF, 0x33, 0xF4, 0x3B, 0x9E, 0xE5, 0x2D, 0x35, 0x57, 0x45, 0x41, 0xF0, 0x45, 0x31, 0xCD, 0x68, 0xB3, 0x5A, 0x21, 0x9F, 0xAA, 0x82, 0xC7, 0x58, 0xEA, 0xBA, 0x59,
  0xDD, 0x6F, 0xFE, 0xA6, 0xF8, 0x4D, 0x2E, 0x58, 0x0B, 0x38, 0x47, 0xDF, 0x4E, 0xCE, 0xF1, 0xB7, 0x0B, 0x7A, 0x6D, 0x44, 0xF7, 0x52, 0x57, 0xDB, 0xD3, 0x81, 0xEA, 0x81, 0xD9, 0xB6, 0xF5, 0x2E, 0xB9, 0xBC, 0x6B, 0x1D, 0xBD, 0xFA, 0x32, 0x45,
  0xAF, 0xB1, 0x56, 0xA1, 0x2E, 0x17, 0xEA, 0xDB, 0xD6, 0xD4, 0xB6, 0xEB, 0xCB, 0x73, 0x1C, 0x43, 0xA3, 0x43, 0x59, 0xC3, 0x0F, 0x10, 0x44, 0x34, 0x80, 0x02, 0x37, 0x1C, 0x1E, 0xC1, 0x24, 0x1B, 0xC6, 0xE1, 0xCC, 0x52, 0xAB, 0x46, 0xCE, 0x1F,
  0x28, 0xF3, 0x55, 0x14, 0x5B, 0x8A, 0x72, 0x57, 0xDE, 0xA0, 0x74, 0xE7, 0x61, 0x9B, 0xFC, 0x75, 0xAD, 0x7A, 0x2F, 0x68, 0xDC, 0x1F, 0x26, 0x32, 0x2A, 0x2F, 0xC9, 0x53, 0x16, 0xCB, 0xF3, 0xE4, 0x8A, 0xD7, 0xCA, 0xE6, 0xE6, 0x35, 0x8D, 0x42,
  0x2F, 0x97, 0xD7, 0x69, 0xD7, 0x6A, 0x03, 0x63, 0x63, 0xF8, 0x15, 0x75, 0x6D, 0x6B, 0x5D, 0xCA, 0xF0, 0xAD, 0xAC, 0xAC, 0xD9, 0xC5, 0x4D, 0x8D, 0x2D, 0x70, 0x57, 0x17, 0xB9, 0xE1, 0xAD, 0xE6, 0x35, 0x84, 0xB6, 0x9A, 0x17, 0xAF, 0xC1, 0x5E,
  0x86, 0xA6, 0x75, 0xBD, 0xC5, 0x6F, 0x8B, 0xFD, 0x90, 0x32, 0x8E, 0x0E, 0xF0, 0x37, 0x57, 0x5F, 0xEC, 0x05, 0xC4, 0x3F, 0x20, 0x92, 0x8C, 0xCA, 0xD5, 0x25, 0xC5, 0x25, 0xCD, 0x9A, 0xAD, 0x41, 0x2D, 0x12, 0xD5, 0x34, 0xD9, 0xBA, 0x5F, 0xBD,
  0x5A, 0xEB, 0x30, 0xFE, 0x5C, 0xE1, 0x92, 0x18, 0x5F, 0x29, 0xBA, 0xCA, 0xF9, 0x90, 0x49, 0x69, 0x95, 0x50, 0x6B, 0xFC, 0x3A, 0x7A, 0xED, 0x0B, 0x09, 0x53, 0x1B, 0x5F, 0x81, 0x41, 0x3A, 0xCA, 0xC0, 0x64, 0xCD, 0xBE, 0xE9, 0xFE, 0x46, 0xD3,
  0xF5, 0x07, 0x0A,
  0x65, 0x13, 0x73, 0x0F, 0xDC, 0x37, 0x39, 0x21, 0x20, 0xAD, 0xEA, 0x45, 0x4B, 0x15, 0x33, 0x3C, 0x14, 0x19, 0x1F, 0x53, 0x5D, 0x5F, 0x55, 0x55, 0x03, 0x1F, 0xB6, 0xFF, 0x3C, 0x3C, 0x86, 0xBA, 0xA5, 0x7B, 0xF5, 0x92, 0x42, 0xB1, 0x04, 0xB5,
  0x86, 0xE8, 0x03, 0xCC, 0x04, 0xED, 0xA7, 0x31, 0x9B, 0xBA, 0xB5, 0xF2, 0xF2, 0x61, 0x13, 0x58, 0x8C, 0x09, 0x0A,
  0x93, 0x07, 0x75, 0x9A, 0xEE, 0x16, 0x75, 0xD8, 0x9E, 0x8C, 0xEF, 0xC9, 0x44, 0x89, 0x34, 0xAA, 0xAD, 0x6E, 0x3A, 0x4A, 0x49, 0x42, 0x69, 0xB4, 0xD0, 0x5F, 0x64, 0xEC, 0xF0, 0x2B, 0x61, 0x11, 0xF5, 0x4D, 0xB5, 0x36, 0x1B, 0x9A, 0x26, 0x7F,
  0x90, 0x18, 0x78, 0xD2, 0xA8, 0x1A, 0x63, 0xF7, 0xAA, 0x42, 0xBF, 0x49, 0x4E, 0x5E, 0xDA, 0x95, 0x36, 0xF2, 0x25, 0x5C, 0x7B, 0xD3, 0xB2, 0x45, 0xA0, 0xD0, 0xD5, 0xCD, 0x77, 0xDD, 0xFE, 0xF7, 0xEF, 0x3E, 0x92, 0xCF, 0x11, 0x15, 0x11, 0x11,
  0x15, 0x16, 0xBA, 0x43, 0x16, 0x05, 0x7F, 0x84, 0x16, 0x2E, 0xAA, 0x6F, 0x32, 0xD6, 0xA2, 0xD1, 0x73, 0xBD, 0x9A, 0x19, 0x4E, 0x0B, 0xDD, 0xDB, 0xB9, 0x73, 0xD0, 0x2E, 0x1E, 0x64, 0xDF, 0xC7, 0xE7, 0x3A, 0x24, 0xFF, 0x34, 0x1A, 0x39, 0x10,
  0x0A,
  0xF9, 0x0D, 0x13, 0xA0, 0xFF, 0xB5, 0x04, 0x05, 0x05, 0x7D, 0x7A, 0x47, 0xC8, 0x27, 0xF9, 0x24, 0x9F, 0xE4, 0xFF, 0x4E, 0xFE, 0x03, 0xCD, 0x41, 0xC3, 0xDB, 0xF0, 0xCF, 0x35, 0x82, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42,
  0x60, 0x82, 0x00
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawStripes
*/
static void _DrawStripes(void) {
  int i;

  GUI_COLOR _aColor[] = {
    GUI_BLUE   ,
    GUI_GREEN  ,
    GUI_RED    ,
    GUI_CYAN   ,
    GUI_MAGENTA,
    GUI_YELLOW ,
  };
  for (i = 0; i < 240; i += 10) {
    GUI_SetColor(_aColor[(i / 10) % GUI_COUNTOF(_aColor)]);
    GUI_FillRect(0, i, 319, i + 9);
  }
}

/*********************************************************************
*
*       _GetData
*/
static int _GetData(void * p, const U8 ** ppData, unsigned NumBytesReq, U32 Off) {
  HANDLE * phFile;
  DWORD    NumBytesRead;
  U8     * pData;

  pData  = (U8 *)*ppData;
  phFile = (HANDLE *)p;
  //
  // Set file pointer to the required position
  //
  SetFilePointer(*phFile, Off, 0, FILE_BEGIN);
  //
  // Read data into buffer
  //
  ReadFile(*phFile, pData, NumBytesReq, &NumBytesRead, NULL);
  //
  // Return number of available bytes
  //
  return NumBytesRead;
}

/*********************************************************************
*
*       _DrawPNG_file
*
* Function description
*   Draws a PNG file from a file system
*/
static void _DrawPNG_file(const char * sFilename) {
  HANDLE hFile;
  int    xSize;
  int    ySize;
  int    w;
  int    h;
  int    xPos;
  int    yPos;

  hFile = CreateFile(sFilename, GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
  w     = GUI_PNG_GetXSizeEx(_GetData, &hFile);
  h     = GUI_PNG_GetYSizeEx(_GetData, &hFile);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  xPos  = (xSize - w) / 2 + 10;
  yPos  = (ySize - h) / 2 + 10;
  GUI_PNG_DrawEx(_GetData, &hFile, xPos, yPos);
  CloseHandle(hFile);
}

/*********************************************************************
*
*       _DrawPNG_mem
*
* Function description
*   Draws a PNG file from memory
*/
static void _DrawPNG_mem(const void * pFileData, int FileSize) {
  int xSize;
  int ySize;
  int w;
  int h;
  int xPos;
  int yPos;

  w     = GUI_PNG_GetXSize(pFileData, FileSize);
  h     = GUI_PNG_GetYSize(pFileData, FileSize);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  xPos  = (xSize - w) / 2 - 10;
  yPos  = (ySize - h) / 2 - 10;
  GUI_PNG_Draw(pFileData, FileSize, xPos, yPos);
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  GUI_Init();
  while (1) {
    _DrawStripes();
    _DrawPNG_file("C:\\Work\\Grafik\\PNG\\Toucan.png"); /* Please change the link to a valid PNG file */
    GUI_Delay(1000);
    _DrawStripes();
    _DrawPNG_mem(_acPNG, sizeof(_acPNG));
    GUI_Delay(1000);
  }
}

#endif

/*************************** End of file ****************************/
